/**
 * example_cli_connection_interface_hats_signal_callback_hats_changed:
 * @proxy: The proxy on which example_cli_connection_interface_hats_connect_to_hats_changed ()
 *  was called
 * @arg_Contact: The handle representing the contact&apos;s ID on the server
 * @arg_Color: The color of the contact&apos;s hat.
 * @arg_Style: The style of the contact&apos;s hat.
 * @arg_Properties: There&apos;s always an a{sv}. Perhaps there&apos;s some special religious           reason.
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal HatsChanged.
 */

/**
 * example_cli_connection_interface_hats_connect_to_hats_changed:
 * @proxy: A #TpConnection or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal HatsChanged.
 *
 * Emitted when the contact&apos;s hat has changed.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * example_cli_connection_interface_hats_callback_for_get_hats:
 * @proxy: the proxy on which the call was made
 * @out_Hats: Used to return an 'out' argument if @error is %NULL: A list of contacts and their hats.
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetHats method call
 * succeeds or fails.
 */

/**
 * example_cli_connection_interface_hats_call_get_hats:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Contact: Used to pass an 'in' argument: The handles of the contacts whose hats are requested
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetHats method call.
 *
 * Request a list of the hats worn by the given contacts.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * example_cli_connection_interface_hats_run_get_hats:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Contact: Used to pass an 'in' argument: The handles of the contacts whose hats are requested
 * @out_Hats: Used to return an 'out' argument if %TRUE is returned: A list of contacts and their hats.
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetHats and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Request a list of the hats worn by the given contacts.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * example_cli_connection_interface_hats_callback_for_set_hat:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a SetHat method call
 * succeeds or fails.
 */

/**
 * example_cli_connection_interface_hats_call_set_hat:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Color: Used to pass an 'in' argument: The color of the contact&apos;s hat.
 * @in_Style: Used to pass an 'in' argument: The style of the contact&apos;s hat.
 * @in_Properties: Used to pass an 'in' argument: There&apos;s always an a{sv}...
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a SetHat method call.
 *
 * Indicate that the hat currently being worn by the local user         has changed.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * example_cli_connection_interface_hats_run_set_hat:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Color: Used to pass an 'in' argument: The color of the contact&apos;s hat.
 * @in_Style: Used to pass an 'in' argument: The style of the contact&apos;s hat.
 * @in_Properties: Used to pass an 'in' argument: There&apos;s always an a{sv}...
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method SetHat and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Indicate that the hat currently being worn by the local user         has changed.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */

