#include <glib-object.h>
#include <dbus/dbus-glib.h>
#include <telepathy-glib/dbus-properties-mixin.h>

G_BEGIN_DECLS

/**
 * GabbleSvcCallContent:
 *
 * Dummy typedef representing any implementation of this interface.
 */
typedef struct _GabbleSvcCallContent GabbleSvcCallContent;

/**
 * GabbleSvcCallContentClass:
 *
 * The class of GabbleSvcCallContent.
 * This interface has no D-Bus methods, so an
 * implementation can typically pass %NULL to
 * G_IMPLEMENT_INTERFACE() as the interface
 * initialization function.
 */
typedef struct _GabbleSvcCallContentClass GabbleSvcCallContentClass;

GType gabble_svc_call_content_get_type (void);
#define GABBLE_TYPE_SVC_CALL_CONTENT \
  (gabble_svc_call_content_get_type ())
#define GABBLE_SVC_CALL_CONTENT(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), GABBLE_TYPE_SVC_CALL_CONTENT, GabbleSvcCallContent))
#define GABBLE_IS_SVC_CALL_CONTENT(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), GABBLE_TYPE_SVC_CALL_CONTENT))
#define GABBLE_SVC_CALL_CONTENT_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), GABBLE_TYPE_SVC_CALL_CONTENT, GabbleSvcCallContentClass))


void gabble_svc_call_content_emit_stream_added (gpointer instance,
    const gchar *arg_Stream);
void gabble_svc_call_content_emit_stream_removed (gpointer instance,
    const gchar *arg_Stream);

/**
 * GabbleSvcCallContentCodecOffer:
 *
 * Dummy typedef representing any implementation of this interface.
 */
typedef struct _GabbleSvcCallContentCodecOffer GabbleSvcCallContentCodecOffer;

/**
 * GabbleSvcCallContentCodecOfferClass:
 *
 * The class of GabbleSvcCallContentCodecOffer.
 *
 * In a full implementation of this interface (i.e. all
 * methods implemented), the interface initialization
 * function used in G_IMPLEMENT_INTERFACE() would
 * typically look like this:
 *
 * <programlisting>
 * static void
 * implement_call_content_codec_offer (gpointer klass,
 *     gpointer unused G_GNUC_UNUSED)
 * {
 * #define IMPLEMENT(x) gabble_svc_call_content_codec_offer_implement_###x (\
 *   klass, my_object_###x)
 *   IMPLEMENT (accept);
 *   IMPLEMENT (reject);
 * #undef IMPLEMENT
 * }
 * </programlisting>
 */
typedef struct _GabbleSvcCallContentCodecOfferClass GabbleSvcCallContentCodecOfferClass;

GType gabble_svc_call_content_codec_offer_get_type (void);
#define GABBLE_TYPE_SVC_CALL_CONTENT_CODEC_OFFER \
  (gabble_svc_call_content_codec_offer_get_type ())
#define GABBLE_SVC_CALL_CONTENT_CODEC_OFFER(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), GABBLE_TYPE_SVC_CALL_CONTENT_CODEC_OFFER, GabbleSvcCallContentCodecOffer))
#define GABBLE_IS_SVC_CALL_CONTENT_CODEC_OFFER(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), GABBLE_TYPE_SVC_CALL_CONTENT_CODEC_OFFER))
#define GABBLE_SVC_CALL_CONTENT_CODEC_OFFER_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), GABBLE_TYPE_SVC_CALL_CONTENT_CODEC_OFFER, GabbleSvcCallContentCodecOfferClass))


typedef void (*gabble_svc_call_content_codec_offer_accept_impl) (GabbleSvcCallContentCodecOffer *self,
    const GPtrArray *in_Codecs,
    DBusGMethodInvocation *context);
void gabble_svc_call_content_codec_offer_implement_accept (GabbleSvcCallContentCodecOfferClass *klass, gabble_svc_call_content_codec_offer_accept_impl impl);
/**
 * gabble_svc_call_content_codec_offer_return_from_accept:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void gabble_svc_call_content_codec_offer_return_from_accept (DBusGMethodInvocation *context);
static inline void
gabble_svc_call_content_codec_offer_return_from_accept (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}

typedef void (*gabble_svc_call_content_codec_offer_reject_impl) (GabbleSvcCallContentCodecOffer *self,
    DBusGMethodInvocation *context);
void gabble_svc_call_content_codec_offer_implement_reject (GabbleSvcCallContentCodecOfferClass *klass, gabble_svc_call_content_codec_offer_reject_impl impl);
/**
 * gabble_svc_call_content_codec_offer_return_from_reject:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void gabble_svc_call_content_codec_offer_return_from_reject (DBusGMethodInvocation *context);
static inline void
gabble_svc_call_content_codec_offer_return_from_reject (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}


/**
 * GabbleSvcCallContentInterfaceMedia:
 *
 * Dummy typedef representing any implementation of this interface.
 */
typedef struct _GabbleSvcCallContentInterfaceMedia GabbleSvcCallContentInterfaceMedia;

/**
 * GabbleSvcCallContentInterfaceMediaClass:
 *
 * The class of GabbleSvcCallContentInterfaceMedia.
 *
 * In a full implementation of this interface (i.e. all
 * methods implemented), the interface initialization
 * function used in G_IMPLEMENT_INTERFACE() would
 * typically look like this:
 *
 * <programlisting>
 * static void
 * implement_call_content_interface_media (gpointer klass,
 *     gpointer unused G_GNUC_UNUSED)
 * {
 * #define IMPLEMENT(x) gabble_svc_call_content_interface_media_implement_###x (\
 *   klass, my_object_###x)
 *   IMPLEMENT (set_codecs);
 * #undef IMPLEMENT
 * }
 * </programlisting>
 */
typedef struct _GabbleSvcCallContentInterfaceMediaClass GabbleSvcCallContentInterfaceMediaClass;

GType gabble_svc_call_content_interface_media_get_type (void);
#define GABBLE_TYPE_SVC_CALL_CONTENT_INTERFACE_MEDIA \
  (gabble_svc_call_content_interface_media_get_type ())
#define GABBLE_SVC_CALL_CONTENT_INTERFACE_MEDIA(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), GABBLE_TYPE_SVC_CALL_CONTENT_INTERFACE_MEDIA, GabbleSvcCallContentInterfaceMedia))
#define GABBLE_IS_SVC_CALL_CONTENT_INTERFACE_MEDIA(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), GABBLE_TYPE_SVC_CALL_CONTENT_INTERFACE_MEDIA))
#define GABBLE_SVC_CALL_CONTENT_INTERFACE_MEDIA_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), GABBLE_TYPE_SVC_CALL_CONTENT_INTERFACE_MEDIA, GabbleSvcCallContentInterfaceMediaClass))


typedef void (*gabble_svc_call_content_interface_media_set_codecs_impl) (GabbleSvcCallContentInterfaceMedia *self,
    const GPtrArray *in_Codecs,
    DBusGMethodInvocation *context);
void gabble_svc_call_content_interface_media_implement_set_codecs (GabbleSvcCallContentInterfaceMediaClass *klass, gabble_svc_call_content_interface_media_set_codecs_impl impl);
/**
 * gabble_svc_call_content_interface_media_return_from_set_codecs:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void gabble_svc_call_content_interface_media_return_from_set_codecs (DBusGMethodInvocation *context);
static inline void
gabble_svc_call_content_interface_media_return_from_set_codecs (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}

void gabble_svc_call_content_interface_media_emit_codecs_changed (gpointer instance,
    GHashTable *arg_Updated_Codecs,
    const GArray *arg_Removed_Contacts);
void gabble_svc_call_content_interface_media_emit_new_codec_offer (gpointer instance,
    const gchar *arg_Offer,
    GHashTable *arg_Codecs);

/**
 * GabbleSvcCallStream:
 *
 * Dummy typedef representing any implementation of this interface.
 */
typedef struct _GabbleSvcCallStream GabbleSvcCallStream;

/**
 * GabbleSvcCallStreamClass:
 *
 * The class of GabbleSvcCallStream.
 *
 * In a full implementation of this interface (i.e. all
 * methods implemented), the interface initialization
 * function used in G_IMPLEMENT_INTERFACE() would
 * typically look like this:
 *
 * <programlisting>
 * static void
 * implement_call_stream (gpointer klass,
 *     gpointer unused G_GNUC_UNUSED)
 * {
 * #define IMPLEMENT(x) gabble_svc_call_stream_implement_###x (\
 *   klass, my_object_###x)
 *   IMPLEMENT (set_sending);
 *   IMPLEMENT (request_receiving);
 * #undef IMPLEMENT
 * }
 * </programlisting>
 */
typedef struct _GabbleSvcCallStreamClass GabbleSvcCallStreamClass;

GType gabble_svc_call_stream_get_type (void);
#define GABBLE_TYPE_SVC_CALL_STREAM \
  (gabble_svc_call_stream_get_type ())
#define GABBLE_SVC_CALL_STREAM(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), GABBLE_TYPE_SVC_CALL_STREAM, GabbleSvcCallStream))
#define GABBLE_IS_SVC_CALL_STREAM(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), GABBLE_TYPE_SVC_CALL_STREAM))
#define GABBLE_SVC_CALL_STREAM_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), GABBLE_TYPE_SVC_CALL_STREAM, GabbleSvcCallStreamClass))


typedef void (*gabble_svc_call_stream_set_sending_impl) (GabbleSvcCallStream *self,
    gboolean in_Send,
    DBusGMethodInvocation *context);
void gabble_svc_call_stream_implement_set_sending (GabbleSvcCallStreamClass *klass, gabble_svc_call_stream_set_sending_impl impl);
/**
 * gabble_svc_call_stream_return_from_set_sending:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void gabble_svc_call_stream_return_from_set_sending (DBusGMethodInvocation *context);
static inline void
gabble_svc_call_stream_return_from_set_sending (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}

typedef void (*gabble_svc_call_stream_request_receiving_impl) (GabbleSvcCallStream *self,
    guint in_Contact,
    gboolean in_Receive,
    DBusGMethodInvocation *context);
void gabble_svc_call_stream_implement_request_receiving (GabbleSvcCallStreamClass *klass, gabble_svc_call_stream_request_receiving_impl impl);
/**
 * gabble_svc_call_stream_return_from_request_receiving:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void gabble_svc_call_stream_return_from_request_receiving (DBusGMethodInvocation *context);
static inline void
gabble_svc_call_stream_return_from_request_receiving (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}

void gabble_svc_call_stream_emit_senders_changed (gpointer instance,
    GHashTable *arg_Updates,
    const GArray *arg_Removed);

/**
 * GabbleSvcCallStreamEndpoint:
 *
 * Dummy typedef representing any implementation of this interface.
 */
typedef struct _GabbleSvcCallStreamEndpoint GabbleSvcCallStreamEndpoint;

/**
 * GabbleSvcCallStreamEndpointClass:
 *
 * The class of GabbleSvcCallStreamEndpoint.
 *
 * In a full implementation of this interface (i.e. all
 * methods implemented), the interface initialization
 * function used in G_IMPLEMENT_INTERFACE() would
 * typically look like this:
 *
 * <programlisting>
 * static void
 * implement_call_stream_endpoint (gpointer klass,
 *     gpointer unused G_GNUC_UNUSED)
 * {
 * #define IMPLEMENT(x) gabble_svc_call_stream_endpoint_implement_###x (\
 *   klass, my_object_###x)
 *   IMPLEMENT (set_selected_candidate);
 *   IMPLEMENT (set_stream_state);
 * #undef IMPLEMENT
 * }
 * </programlisting>
 */
typedef struct _GabbleSvcCallStreamEndpointClass GabbleSvcCallStreamEndpointClass;

GType gabble_svc_call_stream_endpoint_get_type (void);
#define GABBLE_TYPE_SVC_CALL_STREAM_ENDPOINT \
  (gabble_svc_call_stream_endpoint_get_type ())
#define GABBLE_SVC_CALL_STREAM_ENDPOINT(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), GABBLE_TYPE_SVC_CALL_STREAM_ENDPOINT, GabbleSvcCallStreamEndpoint))
#define GABBLE_IS_SVC_CALL_STREAM_ENDPOINT(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), GABBLE_TYPE_SVC_CALL_STREAM_ENDPOINT))
#define GABBLE_SVC_CALL_STREAM_ENDPOINT_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), GABBLE_TYPE_SVC_CALL_STREAM_ENDPOINT, GabbleSvcCallStreamEndpointClass))


typedef void (*gabble_svc_call_stream_endpoint_set_selected_candidate_impl) (GabbleSvcCallStreamEndpoint *self,
    const GValueArray *in_Candidate,
    DBusGMethodInvocation *context);
void gabble_svc_call_stream_endpoint_implement_set_selected_candidate (GabbleSvcCallStreamEndpointClass *klass, gabble_svc_call_stream_endpoint_set_selected_candidate_impl impl);
/**
 * gabble_svc_call_stream_endpoint_return_from_set_selected_candidate:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void gabble_svc_call_stream_endpoint_return_from_set_selected_candidate (DBusGMethodInvocation *context);
static inline void
gabble_svc_call_stream_endpoint_return_from_set_selected_candidate (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}

typedef void (*gabble_svc_call_stream_endpoint_set_stream_state_impl) (GabbleSvcCallStreamEndpoint *self,
    guint in_State,
    DBusGMethodInvocation *context);
void gabble_svc_call_stream_endpoint_implement_set_stream_state (GabbleSvcCallStreamEndpointClass *klass, gabble_svc_call_stream_endpoint_set_stream_state_impl impl);
/**
 * gabble_svc_call_stream_endpoint_return_from_set_stream_state:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void gabble_svc_call_stream_endpoint_return_from_set_stream_state (DBusGMethodInvocation *context);
static inline void
gabble_svc_call_stream_endpoint_return_from_set_stream_state (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}

void gabble_svc_call_stream_endpoint_emit_remote_credentials_set (gpointer instance,
    const gchar *arg_Username,
    const gchar *arg_Password);
void gabble_svc_call_stream_endpoint_emit_remote_candidates_added (gpointer instance,
    const GPtrArray *arg_Candidates);
void gabble_svc_call_stream_endpoint_emit_candidate_selected (gpointer instance,
    const GValueArray *arg_Candidate);
void gabble_svc_call_stream_endpoint_emit_stream_state_changed (gpointer instance,
    guint arg_state);

/**
 * GabbleSvcCallStreamInterfaceMedia:
 *
 * Dummy typedef representing any implementation of this interface.
 */
typedef struct _GabbleSvcCallStreamInterfaceMedia GabbleSvcCallStreamInterfaceMedia;

/**
 * GabbleSvcCallStreamInterfaceMediaClass:
 *
 * The class of GabbleSvcCallStreamInterfaceMedia.
 *
 * In a full implementation of this interface (i.e. all
 * methods implemented), the interface initialization
 * function used in G_IMPLEMENT_INTERFACE() would
 * typically look like this:
 *
 * <programlisting>
 * static void
 * implement_call_stream_interface_media (gpointer klass,
 *     gpointer unused G_GNUC_UNUSED)
 * {
 * #define IMPLEMENT(x) gabble_svc_call_stream_interface_media_implement_###x (\
 *   klass, my_object_###x)
 *   IMPLEMENT (add_candidates);
 *   IMPLEMENT (candidates_prepared);
 * #undef IMPLEMENT
 * }
 * </programlisting>
 */
typedef struct _GabbleSvcCallStreamInterfaceMediaClass GabbleSvcCallStreamInterfaceMediaClass;

GType gabble_svc_call_stream_interface_media_get_type (void);
#define GABBLE_TYPE_SVC_CALL_STREAM_INTERFACE_MEDIA \
  (gabble_svc_call_stream_interface_media_get_type ())
#define GABBLE_SVC_CALL_STREAM_INTERFACE_MEDIA(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), GABBLE_TYPE_SVC_CALL_STREAM_INTERFACE_MEDIA, GabbleSvcCallStreamInterfaceMedia))
#define GABBLE_IS_SVC_CALL_STREAM_INTERFACE_MEDIA(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), GABBLE_TYPE_SVC_CALL_STREAM_INTERFACE_MEDIA))
#define GABBLE_SVC_CALL_STREAM_INTERFACE_MEDIA_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), GABBLE_TYPE_SVC_CALL_STREAM_INTERFACE_MEDIA, GabbleSvcCallStreamInterfaceMediaClass))


typedef void (*gabble_svc_call_stream_interface_media_add_candidates_impl) (GabbleSvcCallStreamInterfaceMedia *self,
    const GPtrArray *in_candidates,
    DBusGMethodInvocation *context);
void gabble_svc_call_stream_interface_media_implement_add_candidates (GabbleSvcCallStreamInterfaceMediaClass *klass, gabble_svc_call_stream_interface_media_add_candidates_impl impl);
/**
 * gabble_svc_call_stream_interface_media_return_from_add_candidates:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void gabble_svc_call_stream_interface_media_return_from_add_candidates (DBusGMethodInvocation *context);
static inline void
gabble_svc_call_stream_interface_media_return_from_add_candidates (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}

typedef void (*gabble_svc_call_stream_interface_media_candidates_prepared_impl) (GabbleSvcCallStreamInterfaceMedia *self,
    DBusGMethodInvocation *context);
void gabble_svc_call_stream_interface_media_implement_candidates_prepared (GabbleSvcCallStreamInterfaceMediaClass *klass, gabble_svc_call_stream_interface_media_candidates_prepared_impl impl);
/**
 * gabble_svc_call_stream_interface_media_return_from_candidates_prepared:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void gabble_svc_call_stream_interface_media_return_from_candidates_prepared (DBusGMethodInvocation *context);
static inline void
gabble_svc_call_stream_interface_media_return_from_candidates_prepared (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}

void gabble_svc_call_stream_interface_media_emit_local_candidates_added (gpointer instance,
    const GPtrArray *arg_Candidates);
void gabble_svc_call_stream_interface_media_emit_local_credentials_set (gpointer instance,
    const gchar *arg_Username,
    const gchar *arg_Password);
void gabble_svc_call_stream_interface_media_emit_server_info_retrieved (gpointer instance);
void gabble_svc_call_stream_interface_media_emit_endpoints_changed (gpointer instance,
    const GPtrArray *arg_EndpointsAdded,
    const GPtrArray *arg_EndpointsRemoved);

/**
 * GabbleSvcChannelBundle:
 *
 * Dummy typedef representing any implementation of this interface.
 */
typedef struct _GabbleSvcChannelBundle GabbleSvcChannelBundle;

/**
 * GabbleSvcChannelBundleClass:
 *
 * The class of GabbleSvcChannelBundle.
 * This interface has no D-Bus methods, so an
 * implementation can typically pass %NULL to
 * G_IMPLEMENT_INTERFACE() as the interface
 * initialization function.
 */
typedef struct _GabbleSvcChannelBundleClass GabbleSvcChannelBundleClass;

GType gabble_svc_channel_bundle_get_type (void);
#define GABBLE_TYPE_SVC_CHANNEL_BUNDLE \
  (gabble_svc_channel_bundle_get_type ())
#define GABBLE_SVC_CHANNEL_BUNDLE(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), GABBLE_TYPE_SVC_CHANNEL_BUNDLE, GabbleSvcChannelBundle))
#define GABBLE_IS_SVC_CHANNEL_BUNDLE(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), GABBLE_TYPE_SVC_CHANNEL_BUNDLE))
#define GABBLE_SVC_CHANNEL_BUNDLE_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), GABBLE_TYPE_SVC_CHANNEL_BUNDLE, GabbleSvcChannelBundleClass))



/**
 * GabbleSvcChannelFuture:
 *
 * Dummy typedef representing any implementation of this interface.
 */
typedef struct _GabbleSvcChannelFuture GabbleSvcChannelFuture;

/**
 * GabbleSvcChannelFutureClass:
 *
 * The class of GabbleSvcChannelFuture.
 * This interface has no D-Bus methods, so an
 * implementation can typically pass %NULL to
 * G_IMPLEMENT_INTERFACE() as the interface
 * initialization function.
 */
typedef struct _GabbleSvcChannelFutureClass GabbleSvcChannelFutureClass;

GType gabble_svc_channel_future_get_type (void);
#define GABBLE_TYPE_SVC_CHANNEL_FUTURE \
  (gabble_svc_channel_future_get_type ())
#define GABBLE_SVC_CHANNEL_FUTURE(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), GABBLE_TYPE_SVC_CHANNEL_FUTURE, GabbleSvcChannelFuture))
#define GABBLE_IS_SVC_CHANNEL_FUTURE(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), GABBLE_TYPE_SVC_CHANNEL_FUTURE))
#define GABBLE_SVC_CHANNEL_FUTURE_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), GABBLE_TYPE_SVC_CHANNEL_FUTURE, GabbleSvcChannelFutureClass))



/**
 * GabbleSvcChannelInterfaceSaslAuthentication:
 *
 * Dummy typedef representing any implementation of this interface.
 */
typedef struct _GabbleSvcChannelInterfaceSaslAuthentication GabbleSvcChannelInterfaceSaslAuthentication;

/**
 * GabbleSvcChannelInterfaceSaslAuthenticationClass:
 *
 * The class of GabbleSvcChannelInterfaceSaslAuthentication.
 *
 * In a full implementation of this interface (i.e. all
 * methods implemented), the interface initialization
 * function used in G_IMPLEMENT_INTERFACE() would
 * typically look like this:
 *
 * <programlisting>
 * static void
 * implement_channel_interface_sasl_authentication (gpointer klass,
 *     gpointer unused G_GNUC_UNUSED)
 * {
 * #define IMPLEMENT(x) gabble_svc_channel_interface_sasl_authentication_implement_###x (\
 *   klass, my_object_###x)
 *   IMPLEMENT (start_mechanism);
 *   IMPLEMENT (respond);
 *   IMPLEMENT (accept);
 *   IMPLEMENT (abort);
 * #undef IMPLEMENT
 * }
 * </programlisting>
 */
typedef struct _GabbleSvcChannelInterfaceSaslAuthenticationClass GabbleSvcChannelInterfaceSaslAuthenticationClass;

GType gabble_svc_channel_interface_sasl_authentication_get_type (void);
#define GABBLE_TYPE_SVC_CHANNEL_INTERFACE_SASL_AUTHENTICATION \
  (gabble_svc_channel_interface_sasl_authentication_get_type ())
#define GABBLE_SVC_CHANNEL_INTERFACE_SASL_AUTHENTICATION(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), GABBLE_TYPE_SVC_CHANNEL_INTERFACE_SASL_AUTHENTICATION, GabbleSvcChannelInterfaceSaslAuthentication))
#define GABBLE_IS_SVC_CHANNEL_INTERFACE_SASL_AUTHENTICATION(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), GABBLE_TYPE_SVC_CHANNEL_INTERFACE_SASL_AUTHENTICATION))
#define GABBLE_SVC_CHANNEL_INTERFACE_SASL_AUTHENTICATION_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), GABBLE_TYPE_SVC_CHANNEL_INTERFACE_SASL_AUTHENTICATION, GabbleSvcChannelInterfaceSaslAuthenticationClass))


typedef void (*gabble_svc_channel_interface_sasl_authentication_start_mechanism_impl) (GabbleSvcChannelInterfaceSaslAuthentication *self,
    const gchar *in_Mechanism,
    const GArray *in_InitialData,
    DBusGMethodInvocation *context);
void gabble_svc_channel_interface_sasl_authentication_implement_start_mechanism (GabbleSvcChannelInterfaceSaslAuthenticationClass *klass, gabble_svc_channel_interface_sasl_authentication_start_mechanism_impl impl);
/**
 * gabble_svc_channel_interface_sasl_authentication_return_from_start_mechanism:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void gabble_svc_channel_interface_sasl_authentication_return_from_start_mechanism (DBusGMethodInvocation *context);
static inline void
gabble_svc_channel_interface_sasl_authentication_return_from_start_mechanism (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}

typedef void (*gabble_svc_channel_interface_sasl_authentication_respond_impl) (GabbleSvcChannelInterfaceSaslAuthentication *self,
    const GArray *in_Response_Data,
    DBusGMethodInvocation *context);
void gabble_svc_channel_interface_sasl_authentication_implement_respond (GabbleSvcChannelInterfaceSaslAuthenticationClass *klass, gabble_svc_channel_interface_sasl_authentication_respond_impl impl);
/**
 * gabble_svc_channel_interface_sasl_authentication_return_from_respond:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void gabble_svc_channel_interface_sasl_authentication_return_from_respond (DBusGMethodInvocation *context);
static inline void
gabble_svc_channel_interface_sasl_authentication_return_from_respond (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}

typedef void (*gabble_svc_channel_interface_sasl_authentication_accept_impl) (GabbleSvcChannelInterfaceSaslAuthentication *self,
    DBusGMethodInvocation *context);
void gabble_svc_channel_interface_sasl_authentication_implement_accept (GabbleSvcChannelInterfaceSaslAuthenticationClass *klass, gabble_svc_channel_interface_sasl_authentication_accept_impl impl);
/**
 * gabble_svc_channel_interface_sasl_authentication_return_from_accept:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void gabble_svc_channel_interface_sasl_authentication_return_from_accept (DBusGMethodInvocation *context);
static inline void
gabble_svc_channel_interface_sasl_authentication_return_from_accept (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}

typedef void (*gabble_svc_channel_interface_sasl_authentication_abort_impl) (GabbleSvcChannelInterfaceSaslAuthentication *self,
    guint in_Reason,
    const gchar *in_Debug_Message,
    DBusGMethodInvocation *context);
void gabble_svc_channel_interface_sasl_authentication_implement_abort (GabbleSvcChannelInterfaceSaslAuthenticationClass *klass, gabble_svc_channel_interface_sasl_authentication_abort_impl impl);
/**
 * gabble_svc_channel_interface_sasl_authentication_return_from_abort:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void gabble_svc_channel_interface_sasl_authentication_return_from_abort (DBusGMethodInvocation *context);
static inline void
gabble_svc_channel_interface_sasl_authentication_return_from_abort (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}

void gabble_svc_channel_interface_sasl_authentication_emit_state_changed (gpointer instance,
    guint arg_Status,
    const gchar *arg_Reason,
    const gchar *arg_DebugMessage);
void gabble_svc_channel_interface_sasl_authentication_emit_new_challenge (gpointer instance,
    const GArray *arg_ChallengeData);

/**
 * GabbleSvcChannelTypeCall:
 *
 * Dummy typedef representing any implementation of this interface.
 */
typedef struct _GabbleSvcChannelTypeCall GabbleSvcChannelTypeCall;

/**
 * GabbleSvcChannelTypeCallClass:
 *
 * The class of GabbleSvcChannelTypeCall.
 *
 * In a full implementation of this interface (i.e. all
 * methods implemented), the interface initialization
 * function used in G_IMPLEMENT_INTERFACE() would
 * typically look like this:
 *
 * <programlisting>
 * static void
 * implement_channel_type_call (gpointer klass,
 *     gpointer unused G_GNUC_UNUSED)
 * {
 * #define IMPLEMENT(x) gabble_svc_channel_type_call_implement_###x (\
 *   klass, my_object_###x)
 *   IMPLEMENT (ringing);
 *   IMPLEMENT (accept);
 *   IMPLEMENT (hangup);
 *   IMPLEMENT (add_content);
 * #undef IMPLEMENT
 * }
 * </programlisting>
 */
typedef struct _GabbleSvcChannelTypeCallClass GabbleSvcChannelTypeCallClass;

GType gabble_svc_channel_type_call_get_type (void);
#define GABBLE_TYPE_SVC_CHANNEL_TYPE_CALL \
  (gabble_svc_channel_type_call_get_type ())
#define GABBLE_SVC_CHANNEL_TYPE_CALL(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), GABBLE_TYPE_SVC_CHANNEL_TYPE_CALL, GabbleSvcChannelTypeCall))
#define GABBLE_IS_SVC_CHANNEL_TYPE_CALL(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), GABBLE_TYPE_SVC_CHANNEL_TYPE_CALL))
#define GABBLE_SVC_CHANNEL_TYPE_CALL_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), GABBLE_TYPE_SVC_CHANNEL_TYPE_CALL, GabbleSvcChannelTypeCallClass))


typedef void (*gabble_svc_channel_type_call_ringing_impl) (GabbleSvcChannelTypeCall *self,
    DBusGMethodInvocation *context);
void gabble_svc_channel_type_call_implement_ringing (GabbleSvcChannelTypeCallClass *klass, gabble_svc_channel_type_call_ringing_impl impl);
/**
 * gabble_svc_channel_type_call_return_from_ringing:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void gabble_svc_channel_type_call_return_from_ringing (DBusGMethodInvocation *context);
static inline void
gabble_svc_channel_type_call_return_from_ringing (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}

typedef void (*gabble_svc_channel_type_call_accept_impl) (GabbleSvcChannelTypeCall *self,
    DBusGMethodInvocation *context);
void gabble_svc_channel_type_call_implement_accept (GabbleSvcChannelTypeCallClass *klass, gabble_svc_channel_type_call_accept_impl impl);
/**
 * gabble_svc_channel_type_call_return_from_accept:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void gabble_svc_channel_type_call_return_from_accept (DBusGMethodInvocation *context);
static inline void
gabble_svc_channel_type_call_return_from_accept (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}

typedef void (*gabble_svc_channel_type_call_hangup_impl) (GabbleSvcChannelTypeCall *self,
    guint in_Reason,
    const gchar *in_Detailed_Hangup_Reason,
    const gchar *in_Message,
    DBusGMethodInvocation *context);
void gabble_svc_channel_type_call_implement_hangup (GabbleSvcChannelTypeCallClass *klass, gabble_svc_channel_type_call_hangup_impl impl);
/**
 * gabble_svc_channel_type_call_return_from_hangup:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void gabble_svc_channel_type_call_return_from_hangup (DBusGMethodInvocation *context);
static inline void
gabble_svc_channel_type_call_return_from_hangup (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}

typedef void (*gabble_svc_channel_type_call_add_content_impl) (GabbleSvcChannelTypeCall *self,
    const gchar *in_Content_Name,
    guint in_Content_Type,
    DBusGMethodInvocation *context);
void gabble_svc_channel_type_call_implement_add_content (GabbleSvcChannelTypeCallClass *klass, gabble_svc_channel_type_call_add_content_impl impl);
/**
 * gabble_svc_channel_type_call_return_from_add_content:
 * @context: The D-Bus method invocation context
 * @out_Content: const gchar * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void gabble_svc_channel_type_call_return_from_add_content (DBusGMethodInvocation *context,
    const gchar *out_Content);
static inline void
gabble_svc_channel_type_call_return_from_add_content (DBusGMethodInvocation *context,
    const gchar *out_Content)
{
  dbus_g_method_return (context,
      out_Content);
}

void gabble_svc_channel_type_call_emit_content_added (gpointer instance,
    const gchar *arg_Content,
    guint arg_Content_Type);
void gabble_svc_channel_type_call_emit_content_removed (gpointer instance,
    const gchar *arg_Content);
void gabble_svc_channel_type_call_emit_call_state_changed (gpointer instance,
    guint arg_Call_State,
    guint arg_Call_Flags,
    const GValueArray *arg_Call_State_Reason,
    GHashTable *arg_Call_State_Details);
void gabble_svc_channel_type_call_emit_call_members_changed (gpointer instance,
    GHashTable *arg_Flags_Changed,
    const GArray *arg_Removed);

/**
 * GabbleSvcChannelTypeFileTransferFuture:
 *
 * Dummy typedef representing any implementation of this interface.
 */
typedef struct _GabbleSvcChannelTypeFileTransferFuture GabbleSvcChannelTypeFileTransferFuture;

/**
 * GabbleSvcChannelTypeFileTransferFutureClass:
 *
 * The class of GabbleSvcChannelTypeFileTransferFuture.
 * This interface has no D-Bus methods, so an
 * implementation can typically pass %NULL to
 * G_IMPLEMENT_INTERFACE() as the interface
 * initialization function.
 */
typedef struct _GabbleSvcChannelTypeFileTransferFutureClass GabbleSvcChannelTypeFileTransferFutureClass;

GType gabble_svc_channel_type_filetransfer_future_get_type (void);
#define GABBLE_TYPE_SVC_CHANNEL_TYPE_FILETRANSFER_FUTURE \
  (gabble_svc_channel_type_filetransfer_future_get_type ())
#define GABBLE_SVC_CHANNEL_TYPE_FILETRANSFER_FUTURE(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), GABBLE_TYPE_SVC_CHANNEL_TYPE_FILETRANSFER_FUTURE, GabbleSvcChannelTypeFileTransferFuture))
#define GABBLE_IS_SVC_CHANNEL_TYPE_FILETRANSFER_FUTURE(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), GABBLE_TYPE_SVC_CHANNEL_TYPE_FILETRANSFER_FUTURE))
#define GABBLE_SVC_CHANNEL_TYPE_FILETRANSFER_FUTURE_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), GABBLE_TYPE_SVC_CHANNEL_TYPE_FILETRANSFER_FUTURE, GabbleSvcChannelTypeFileTransferFutureClass))



/**
 * GabbleSvcChannelTypeServerAuthentication:
 *
 * Dummy typedef representing any implementation of this interface.
 */
typedef struct _GabbleSvcChannelTypeServerAuthentication GabbleSvcChannelTypeServerAuthentication;

/**
 * GabbleSvcChannelTypeServerAuthenticationClass:
 *
 * The class of GabbleSvcChannelTypeServerAuthentication.
 * This interface has no D-Bus methods, so an
 * implementation can typically pass %NULL to
 * G_IMPLEMENT_INTERFACE() as the interface
 * initialization function.
 */
typedef struct _GabbleSvcChannelTypeServerAuthenticationClass GabbleSvcChannelTypeServerAuthenticationClass;

GType gabble_svc_channel_type_server_authentication_get_type (void);
#define GABBLE_TYPE_SVC_CHANNEL_TYPE_SERVER_AUTHENTICATION \
  (gabble_svc_channel_type_server_authentication_get_type ())
#define GABBLE_SVC_CHANNEL_TYPE_SERVER_AUTHENTICATION(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), GABBLE_TYPE_SVC_CHANNEL_TYPE_SERVER_AUTHENTICATION, GabbleSvcChannelTypeServerAuthentication))
#define GABBLE_IS_SVC_CHANNEL_TYPE_SERVER_AUTHENTICATION(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), GABBLE_TYPE_SVC_CHANNEL_TYPE_SERVER_AUTHENTICATION))
#define GABBLE_SVC_CHANNEL_TYPE_SERVER_AUTHENTICATION_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), GABBLE_TYPE_SVC_CHANNEL_TYPE_SERVER_AUTHENTICATION, GabbleSvcChannelTypeServerAuthenticationClass))



/**
 * GabbleSvcConnectionFUTURE:
 *
 * Dummy typedef representing any implementation of this interface.
 */
typedef struct _GabbleSvcConnectionFUTURE GabbleSvcConnectionFUTURE;

/**
 * GabbleSvcConnectionFUTUREClass:
 *
 * The class of GabbleSvcConnectionFUTURE.
 *
 * In a full implementation of this interface (i.e. all
 * methods implemented), the interface initialization
 * function used in G_IMPLEMENT_INTERFACE() would
 * typically look like this:
 *
 * <programlisting>
 * static void
 * implement_connection_future (gpointer klass,
 *     gpointer unused G_GNUC_UNUSED)
 * {
 * #define IMPLEMENT(x) gabble_svc_connection_future_implement_###x (\
 *   klass, my_object_###x)
 *   IMPLEMENT (ensure_sidecar);
 * #undef IMPLEMENT
 * }
 * </programlisting>
 */
typedef struct _GabbleSvcConnectionFUTUREClass GabbleSvcConnectionFUTUREClass;

GType gabble_svc_connection_future_get_type (void);
#define GABBLE_TYPE_SVC_CONNECTION_FUTURE \
  (gabble_svc_connection_future_get_type ())
#define GABBLE_SVC_CONNECTION_FUTURE(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), GABBLE_TYPE_SVC_CONNECTION_FUTURE, GabbleSvcConnectionFUTURE))
#define GABBLE_IS_SVC_CONNECTION_FUTURE(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), GABBLE_TYPE_SVC_CONNECTION_FUTURE))
#define GABBLE_SVC_CONNECTION_FUTURE_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), GABBLE_TYPE_SVC_CONNECTION_FUTURE, GabbleSvcConnectionFUTUREClass))


typedef void (*gabble_svc_connection_future_ensure_sidecar_impl) (GabbleSvcConnectionFUTURE *self,
    const gchar *in_Main_Interface,
    DBusGMethodInvocation *context);
void gabble_svc_connection_future_implement_ensure_sidecar (GabbleSvcConnectionFUTUREClass *klass, gabble_svc_connection_future_ensure_sidecar_impl impl);
/**
 * gabble_svc_connection_future_return_from_ensure_sidecar:
 * @context: The D-Bus method invocation context
 * @out_Path: const gchar * (FIXME, generate documentation)
 * @out_Properties: GHashTable * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void gabble_svc_connection_future_return_from_ensure_sidecar (DBusGMethodInvocation *context,
    const gchar *out_Path,
    GHashTable *out_Properties);
static inline void
gabble_svc_connection_future_return_from_ensure_sidecar (DBusGMethodInvocation *context,
    const gchar *out_Path,
    GHashTable *out_Properties)
{
  dbus_g_method_return (context,
      out_Path,
      out_Properties);
}


/**
 * GabbleSvcConnectionInterfaceGabbleDecloak:
 *
 * Dummy typedef representing any implementation of this interface.
 */
typedef struct _GabbleSvcConnectionInterfaceGabbleDecloak GabbleSvcConnectionInterfaceGabbleDecloak;

/**
 * GabbleSvcConnectionInterfaceGabbleDecloakClass:
 *
 * The class of GabbleSvcConnectionInterfaceGabbleDecloak.
 *
 * In a full implementation of this interface (i.e. all
 * methods implemented), the interface initialization
 * function used in G_IMPLEMENT_INTERFACE() would
 * typically look like this:
 *
 * <programlisting>
 * static void
 * implement_connection_interface_gabble_decloak (gpointer klass,
 *     gpointer unused G_GNUC_UNUSED)
 * {
 * #define IMPLEMENT(x) gabble_svc_connection_interface_gabble_decloak_implement_###x (\
 *   klass, my_object_###x)
 *   IMPLEMENT (send_directed_presence);
 * #undef IMPLEMENT
 * }
 * </programlisting>
 */
typedef struct _GabbleSvcConnectionInterfaceGabbleDecloakClass GabbleSvcConnectionInterfaceGabbleDecloakClass;

GType gabble_svc_connection_interface_gabble_decloak_get_type (void);
#define GABBLE_TYPE_SVC_CONNECTION_INTERFACE_GABBLE_DECLOAK \
  (gabble_svc_connection_interface_gabble_decloak_get_type ())
#define GABBLE_SVC_CONNECTION_INTERFACE_GABBLE_DECLOAK(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), GABBLE_TYPE_SVC_CONNECTION_INTERFACE_GABBLE_DECLOAK, GabbleSvcConnectionInterfaceGabbleDecloak))
#define GABBLE_IS_SVC_CONNECTION_INTERFACE_GABBLE_DECLOAK(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), GABBLE_TYPE_SVC_CONNECTION_INTERFACE_GABBLE_DECLOAK))
#define GABBLE_SVC_CONNECTION_INTERFACE_GABBLE_DECLOAK_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), GABBLE_TYPE_SVC_CONNECTION_INTERFACE_GABBLE_DECLOAK, GabbleSvcConnectionInterfaceGabbleDecloakClass))


typedef void (*gabble_svc_connection_interface_gabble_decloak_send_directed_presence_impl) (GabbleSvcConnectionInterfaceGabbleDecloak *self,
    guint in_Contact,
    gboolean in_Full,
    DBusGMethodInvocation *context);
void gabble_svc_connection_interface_gabble_decloak_implement_send_directed_presence (GabbleSvcConnectionInterfaceGabbleDecloakClass *klass, gabble_svc_connection_interface_gabble_decloak_send_directed_presence_impl impl);
/**
 * gabble_svc_connection_interface_gabble_decloak_return_from_send_directed_presence:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void gabble_svc_connection_interface_gabble_decloak_return_from_send_directed_presence (DBusGMethodInvocation *context);
static inline void
gabble_svc_connection_interface_gabble_decloak_return_from_send_directed_presence (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}

void gabble_svc_connection_interface_gabble_decloak_emit_decloak_requested (gpointer instance,
    guint arg_Contact,
    const gchar *arg_Reason,
    gboolean arg_Decloaked);

/**
 * GabbleSvcConnectionInterfaceMailNotification:
 *
 * Dummy typedef representing any implementation of this interface.
 */
typedef struct _GabbleSvcConnectionInterfaceMailNotification GabbleSvcConnectionInterfaceMailNotification;

/**
 * GabbleSvcConnectionInterfaceMailNotificationClass:
 *
 * The class of GabbleSvcConnectionInterfaceMailNotification.
 *
 * In a full implementation of this interface (i.e. all
 * methods implemented), the interface initialization
 * function used in G_IMPLEMENT_INTERFACE() would
 * typically look like this:
 *
 * <programlisting>
 * static void
 * implement_connection_interface_mail_notification (gpointer klass,
 *     gpointer unused G_GNUC_UNUSED)
 * {
 * #define IMPLEMENT(x) gabble_svc_connection_interface_mail_notification_implement_###x (\
 *   klass, my_object_###x)
 *   IMPLEMENT (subscribe);
 *   IMPLEMENT (unsubscribe);
 *   IMPLEMENT (request_inbox_url);
 *   IMPLEMENT (request_mail_url);
 * #undef IMPLEMENT
 * }
 * </programlisting>
 */
typedef struct _GabbleSvcConnectionInterfaceMailNotificationClass GabbleSvcConnectionInterfaceMailNotificationClass;

GType gabble_svc_connection_interface_mail_notification_get_type (void);
#define GABBLE_TYPE_SVC_CONNECTION_INTERFACE_MAIL_NOTIFICATION \
  (gabble_svc_connection_interface_mail_notification_get_type ())
#define GABBLE_SVC_CONNECTION_INTERFACE_MAIL_NOTIFICATION(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), GABBLE_TYPE_SVC_CONNECTION_INTERFACE_MAIL_NOTIFICATION, GabbleSvcConnectionInterfaceMailNotification))
#define GABBLE_IS_SVC_CONNECTION_INTERFACE_MAIL_NOTIFICATION(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), GABBLE_TYPE_SVC_CONNECTION_INTERFACE_MAIL_NOTIFICATION))
#define GABBLE_SVC_CONNECTION_INTERFACE_MAIL_NOTIFICATION_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), GABBLE_TYPE_SVC_CONNECTION_INTERFACE_MAIL_NOTIFICATION, GabbleSvcConnectionInterfaceMailNotificationClass))


typedef void (*gabble_svc_connection_interface_mail_notification_subscribe_impl) (GabbleSvcConnectionInterfaceMailNotification *self,
    DBusGMethodInvocation *context);
void gabble_svc_connection_interface_mail_notification_implement_subscribe (GabbleSvcConnectionInterfaceMailNotificationClass *klass, gabble_svc_connection_interface_mail_notification_subscribe_impl impl);
/**
 * gabble_svc_connection_interface_mail_notification_return_from_subscribe:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void gabble_svc_connection_interface_mail_notification_return_from_subscribe (DBusGMethodInvocation *context);
static inline void
gabble_svc_connection_interface_mail_notification_return_from_subscribe (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}

typedef void (*gabble_svc_connection_interface_mail_notification_unsubscribe_impl) (GabbleSvcConnectionInterfaceMailNotification *self,
    DBusGMethodInvocation *context);
void gabble_svc_connection_interface_mail_notification_implement_unsubscribe (GabbleSvcConnectionInterfaceMailNotificationClass *klass, gabble_svc_connection_interface_mail_notification_unsubscribe_impl impl);
/**
 * gabble_svc_connection_interface_mail_notification_return_from_unsubscribe:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void gabble_svc_connection_interface_mail_notification_return_from_unsubscribe (DBusGMethodInvocation *context);
static inline void
gabble_svc_connection_interface_mail_notification_return_from_unsubscribe (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}

typedef void (*gabble_svc_connection_interface_mail_notification_request_inbox_url_impl) (GabbleSvcConnectionInterfaceMailNotification *self,
    DBusGMethodInvocation *context);
void gabble_svc_connection_interface_mail_notification_implement_request_inbox_url (GabbleSvcConnectionInterfaceMailNotificationClass *klass, gabble_svc_connection_interface_mail_notification_request_inbox_url_impl impl);
/**
 * gabble_svc_connection_interface_mail_notification_return_from_request_inbox_url:
 * @context: The D-Bus method invocation context
 * @out_URL: const GValueArray * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void gabble_svc_connection_interface_mail_notification_return_from_request_inbox_url (DBusGMethodInvocation *context,
    const GValueArray *out_URL);
static inline void
gabble_svc_connection_interface_mail_notification_return_from_request_inbox_url (DBusGMethodInvocation *context,
    const GValueArray *out_URL)
{
  dbus_g_method_return (context,
      out_URL);
}

typedef void (*gabble_svc_connection_interface_mail_notification_request_mail_url_impl) (GabbleSvcConnectionInterfaceMailNotification *self,
    const gchar *in_ID,
    const GValue *in_URL_Data,
    DBusGMethodInvocation *context);
void gabble_svc_connection_interface_mail_notification_implement_request_mail_url (GabbleSvcConnectionInterfaceMailNotificationClass *klass, gabble_svc_connection_interface_mail_notification_request_mail_url_impl impl);
/**
 * gabble_svc_connection_interface_mail_notification_return_from_request_mail_url:
 * @context: The D-Bus method invocation context
 * @out_URL: const GValueArray * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void gabble_svc_connection_interface_mail_notification_return_from_request_mail_url (DBusGMethodInvocation *context,
    const GValueArray *out_URL);
static inline void
gabble_svc_connection_interface_mail_notification_return_from_request_mail_url (DBusGMethodInvocation *context,
    const GValueArray *out_URL)
{
  dbus_g_method_return (context,
      out_URL);
}

void gabble_svc_connection_interface_mail_notification_emit_mails_received (gpointer instance,
    const GPtrArray *arg_Mails);
void gabble_svc_connection_interface_mail_notification_emit_unread_mails_changed (gpointer instance,
    guint arg_Count,
    const GPtrArray *arg_Mails_Added,
    const gchar **arg_Mails_Removed);

/**
 * GabbleSvcGabblePluginGateways:
 *
 * Dummy typedef representing any implementation of this interface.
 */
typedef struct _GabbleSvcGabblePluginGateways GabbleSvcGabblePluginGateways;

/**
 * GabbleSvcGabblePluginGatewaysClass:
 *
 * The class of GabbleSvcGabblePluginGateways.
 *
 * In a full implementation of this interface (i.e. all
 * methods implemented), the interface initialization
 * function used in G_IMPLEMENT_INTERFACE() would
 * typically look like this:
 *
 * <programlisting>
 * static void
 * implement_gabble_plugin_gateways (gpointer klass,
 *     gpointer unused G_GNUC_UNUSED)
 * {
 * #define IMPLEMENT(x) gabble_svc_gabble_plugin_gateways_implement_###x (\
 *   klass, my_object_###x)
 *   IMPLEMENT (register);
 * #undef IMPLEMENT
 * }
 * </programlisting>
 */
typedef struct _GabbleSvcGabblePluginGatewaysClass GabbleSvcGabblePluginGatewaysClass;

GType gabble_svc_gabble_plugin_gateways_get_type (void);
#define GABBLE_TYPE_SVC_GABBLE_PLUGIN_GATEWAYS \
  (gabble_svc_gabble_plugin_gateways_get_type ())
#define GABBLE_SVC_GABBLE_PLUGIN_GATEWAYS(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), GABBLE_TYPE_SVC_GABBLE_PLUGIN_GATEWAYS, GabbleSvcGabblePluginGateways))
#define GABBLE_IS_SVC_GABBLE_PLUGIN_GATEWAYS(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), GABBLE_TYPE_SVC_GABBLE_PLUGIN_GATEWAYS))
#define GABBLE_SVC_GABBLE_PLUGIN_GATEWAYS_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), GABBLE_TYPE_SVC_GABBLE_PLUGIN_GATEWAYS, GabbleSvcGabblePluginGatewaysClass))


typedef void (*gabble_svc_gabble_plugin_gateways_register_impl) (GabbleSvcGabblePluginGateways *self,
    const gchar *in_Gateway,
    const gchar *in_Username,
    const gchar *in_Password,
    DBusGMethodInvocation *context);
void gabble_svc_gabble_plugin_gateways_implement_register (GabbleSvcGabblePluginGatewaysClass *klass, gabble_svc_gabble_plugin_gateways_register_impl impl);
/**
 * gabble_svc_gabble_plugin_gateways_return_from_register:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void gabble_svc_gabble_plugin_gateways_return_from_register (DBusGMethodInvocation *context);
static inline void
gabble_svc_gabble_plugin_gateways_return_from_register (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}


/**
 * GabbleSvcGabblePluginTest:
 *
 * Dummy typedef representing any implementation of this interface.
 */
typedef struct _GabbleSvcGabblePluginTest GabbleSvcGabblePluginTest;

/**
 * GabbleSvcGabblePluginTestClass:
 *
 * The class of GabbleSvcGabblePluginTest.
 * This interface has no D-Bus methods, so an
 * implementation can typically pass %NULL to
 * G_IMPLEMENT_INTERFACE() as the interface
 * initialization function.
 */
typedef struct _GabbleSvcGabblePluginTestClass GabbleSvcGabblePluginTestClass;

GType gabble_svc_gabble_plugin_test_get_type (void);
#define GABBLE_TYPE_SVC_GABBLE_PLUGIN_TEST \
  (gabble_svc_gabble_plugin_test_get_type ())
#define GABBLE_SVC_GABBLE_PLUGIN_TEST(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), GABBLE_TYPE_SVC_GABBLE_PLUGIN_TEST, GabbleSvcGabblePluginTest))
#define GABBLE_IS_SVC_GABBLE_PLUGIN_TEST(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), GABBLE_TYPE_SVC_GABBLE_PLUGIN_TEST))
#define GABBLE_SVC_GABBLE_PLUGIN_TEST_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), GABBLE_TYPE_SVC_GABBLE_PLUGIN_TEST, GabbleSvcGabblePluginTestClass))



/**
 * GabbleSvcOLPCActivityProperties:
 *
 * Dummy typedef representing any implementation of this interface.
 */
typedef struct _GabbleSvcOLPCActivityProperties GabbleSvcOLPCActivityProperties;

/**
 * GabbleSvcOLPCActivityPropertiesClass:
 *
 * The class of GabbleSvcOLPCActivityProperties.
 *
 * In a full implementation of this interface (i.e. all
 * methods implemented), the interface initialization
 * function used in G_IMPLEMENT_INTERFACE() would
 * typically look like this:
 *
 * <programlisting>
 * static void
 * implement_olpc_activity_properties (gpointer klass,
 *     gpointer unused G_GNUC_UNUSED)
 * {
 * #define IMPLEMENT(x) gabble_svc_olpc_activity_properties_implement_###x (\
 *   klass, my_object_###x)
 *   IMPLEMENT (set_properties);
 *   IMPLEMENT (get_properties);
 *   IMPLEMENT (get_activity);
 * #undef IMPLEMENT
 * }
 * </programlisting>
 */
typedef struct _GabbleSvcOLPCActivityPropertiesClass GabbleSvcOLPCActivityPropertiesClass;

GType gabble_svc_olpc_activity_properties_get_type (void);
#define GABBLE_TYPE_SVC_OLPC_ACTIVITY_PROPERTIES \
  (gabble_svc_olpc_activity_properties_get_type ())
#define GABBLE_SVC_OLPC_ACTIVITY_PROPERTIES(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), GABBLE_TYPE_SVC_OLPC_ACTIVITY_PROPERTIES, GabbleSvcOLPCActivityProperties))
#define GABBLE_IS_SVC_OLPC_ACTIVITY_PROPERTIES(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), GABBLE_TYPE_SVC_OLPC_ACTIVITY_PROPERTIES))
#define GABBLE_SVC_OLPC_ACTIVITY_PROPERTIES_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), GABBLE_TYPE_SVC_OLPC_ACTIVITY_PROPERTIES, GabbleSvcOLPCActivityPropertiesClass))


typedef void (*gabble_svc_olpc_activity_properties_set_properties_impl) (GabbleSvcOLPCActivityProperties *self,
    guint in_room,
    GHashTable *in_properties,
    DBusGMethodInvocation *context);
void gabble_svc_olpc_activity_properties_implement_set_properties (GabbleSvcOLPCActivityPropertiesClass *klass, gabble_svc_olpc_activity_properties_set_properties_impl impl);
/**
 * gabble_svc_olpc_activity_properties_return_from_set_properties:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void gabble_svc_olpc_activity_properties_return_from_set_properties (DBusGMethodInvocation *context);
static inline void
gabble_svc_olpc_activity_properties_return_from_set_properties (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}

typedef void (*gabble_svc_olpc_activity_properties_get_properties_impl) (GabbleSvcOLPCActivityProperties *self,
    guint in_room,
    DBusGMethodInvocation *context);
void gabble_svc_olpc_activity_properties_implement_get_properties (GabbleSvcOLPCActivityPropertiesClass *klass, gabble_svc_olpc_activity_properties_get_properties_impl impl);
/**
 * gabble_svc_olpc_activity_properties_return_from_get_properties:
 * @context: The D-Bus method invocation context
 * @out_properties: GHashTable * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void gabble_svc_olpc_activity_properties_return_from_get_properties (DBusGMethodInvocation *context,
    GHashTable *out_properties);
static inline void
gabble_svc_olpc_activity_properties_return_from_get_properties (DBusGMethodInvocation *context,
    GHashTable *out_properties)
{
  dbus_g_method_return (context,
      out_properties);
}

typedef void (*gabble_svc_olpc_activity_properties_get_activity_impl) (GabbleSvcOLPCActivityProperties *self,
    const gchar *in_activity_id,
    DBusGMethodInvocation *context);
void gabble_svc_olpc_activity_properties_implement_get_activity (GabbleSvcOLPCActivityPropertiesClass *klass, gabble_svc_olpc_activity_properties_get_activity_impl impl);
/**
 * gabble_svc_olpc_activity_properties_return_from_get_activity:
 * @context: The D-Bus method invocation context
 * @out_room: guint  (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void gabble_svc_olpc_activity_properties_return_from_get_activity (DBusGMethodInvocation *context,
    guint out_room);
static inline void
gabble_svc_olpc_activity_properties_return_from_get_activity (DBusGMethodInvocation *context,
    guint out_room)
{
  dbus_g_method_return (context,
      out_room);
}

void gabble_svc_olpc_activity_properties_emit_activity_properties_changed (gpointer instance,
    guint arg_room,
    GHashTable *arg_properties);

/**
 * GabbleSvcOLPCBuddyInfo:
 *
 * Dummy typedef representing any implementation of this interface.
 */
typedef struct _GabbleSvcOLPCBuddyInfo GabbleSvcOLPCBuddyInfo;

/**
 * GabbleSvcOLPCBuddyInfoClass:
 *
 * The class of GabbleSvcOLPCBuddyInfo.
 *
 * In a full implementation of this interface (i.e. all
 * methods implemented), the interface initialization
 * function used in G_IMPLEMENT_INTERFACE() would
 * typically look like this:
 *
 * <programlisting>
 * static void
 * implement_olpc_buddy_info (gpointer klass,
 *     gpointer unused G_GNUC_UNUSED)
 * {
 * #define IMPLEMENT(x) gabble_svc_olpc_buddy_info_implement_###x (\
 *   klass, my_object_###x)
 *   IMPLEMENT (set_properties);
 *   IMPLEMENT (get_properties);
 *   IMPLEMENT (set_activities);
 *   IMPLEMENT (add_activity);
 *   IMPLEMENT (get_activities);
 *   IMPLEMENT (set_current_activity);
 *   IMPLEMENT (get_current_activity);
 * #undef IMPLEMENT
 * }
 * </programlisting>
 */
typedef struct _GabbleSvcOLPCBuddyInfoClass GabbleSvcOLPCBuddyInfoClass;

GType gabble_svc_olpc_buddy_info_get_type (void);
#define GABBLE_TYPE_SVC_OLPC_BUDDY_INFO \
  (gabble_svc_olpc_buddy_info_get_type ())
#define GABBLE_SVC_OLPC_BUDDY_INFO(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), GABBLE_TYPE_SVC_OLPC_BUDDY_INFO, GabbleSvcOLPCBuddyInfo))
#define GABBLE_IS_SVC_OLPC_BUDDY_INFO(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), GABBLE_TYPE_SVC_OLPC_BUDDY_INFO))
#define GABBLE_SVC_OLPC_BUDDY_INFO_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), GABBLE_TYPE_SVC_OLPC_BUDDY_INFO, GabbleSvcOLPCBuddyInfoClass))


typedef void (*gabble_svc_olpc_buddy_info_set_properties_impl) (GabbleSvcOLPCBuddyInfo *self,
    GHashTable *in_properties,
    DBusGMethodInvocation *context);
void gabble_svc_olpc_buddy_info_implement_set_properties (GabbleSvcOLPCBuddyInfoClass *klass, gabble_svc_olpc_buddy_info_set_properties_impl impl);
/**
 * gabble_svc_olpc_buddy_info_return_from_set_properties:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void gabble_svc_olpc_buddy_info_return_from_set_properties (DBusGMethodInvocation *context);
static inline void
gabble_svc_olpc_buddy_info_return_from_set_properties (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}

typedef void (*gabble_svc_olpc_buddy_info_get_properties_impl) (GabbleSvcOLPCBuddyInfo *self,
    guint in_contact,
    DBusGMethodInvocation *context);
void gabble_svc_olpc_buddy_info_implement_get_properties (GabbleSvcOLPCBuddyInfoClass *klass, gabble_svc_olpc_buddy_info_get_properties_impl impl);
/**
 * gabble_svc_olpc_buddy_info_return_from_get_properties:
 * @context: The D-Bus method invocation context
 * @out_properties: GHashTable * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void gabble_svc_olpc_buddy_info_return_from_get_properties (DBusGMethodInvocation *context,
    GHashTable *out_properties);
static inline void
gabble_svc_olpc_buddy_info_return_from_get_properties (DBusGMethodInvocation *context,
    GHashTable *out_properties)
{
  dbus_g_method_return (context,
      out_properties);
}

typedef void (*gabble_svc_olpc_buddy_info_set_activities_impl) (GabbleSvcOLPCBuddyInfo *self,
    const GPtrArray *in_activities,
    DBusGMethodInvocation *context);
void gabble_svc_olpc_buddy_info_implement_set_activities (GabbleSvcOLPCBuddyInfoClass *klass, gabble_svc_olpc_buddy_info_set_activities_impl impl);
/**
 * gabble_svc_olpc_buddy_info_return_from_set_activities:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void gabble_svc_olpc_buddy_info_return_from_set_activities (DBusGMethodInvocation *context);
static inline void
gabble_svc_olpc_buddy_info_return_from_set_activities (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}

typedef void (*gabble_svc_olpc_buddy_info_add_activity_impl) (GabbleSvcOLPCBuddyInfo *self,
    const gchar *in_id,
    guint in_handle,
    DBusGMethodInvocation *context);
void gabble_svc_olpc_buddy_info_implement_add_activity (GabbleSvcOLPCBuddyInfoClass *klass, gabble_svc_olpc_buddy_info_add_activity_impl impl);
/**
 * gabble_svc_olpc_buddy_info_return_from_add_activity:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void gabble_svc_olpc_buddy_info_return_from_add_activity (DBusGMethodInvocation *context);
static inline void
gabble_svc_olpc_buddy_info_return_from_add_activity (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}

typedef void (*gabble_svc_olpc_buddy_info_get_activities_impl) (GabbleSvcOLPCBuddyInfo *self,
    guint in_contact,
    DBusGMethodInvocation *context);
void gabble_svc_olpc_buddy_info_implement_get_activities (GabbleSvcOLPCBuddyInfoClass *klass, gabble_svc_olpc_buddy_info_get_activities_impl impl);
/**
 * gabble_svc_olpc_buddy_info_return_from_get_activities:
 * @context: The D-Bus method invocation context
 * @out_activities: const GPtrArray * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void gabble_svc_olpc_buddy_info_return_from_get_activities (DBusGMethodInvocation *context,
    const GPtrArray *out_activities);
static inline void
gabble_svc_olpc_buddy_info_return_from_get_activities (DBusGMethodInvocation *context,
    const GPtrArray *out_activities)
{
  dbus_g_method_return (context,
      out_activities);
}

typedef void (*gabble_svc_olpc_buddy_info_set_current_activity_impl) (GabbleSvcOLPCBuddyInfo *self,
    const gchar *in_activity,
    guint in_channel,
    DBusGMethodInvocation *context);
void gabble_svc_olpc_buddy_info_implement_set_current_activity (GabbleSvcOLPCBuddyInfoClass *klass, gabble_svc_olpc_buddy_info_set_current_activity_impl impl);
/**
 * gabble_svc_olpc_buddy_info_return_from_set_current_activity:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void gabble_svc_olpc_buddy_info_return_from_set_current_activity (DBusGMethodInvocation *context);
static inline void
gabble_svc_olpc_buddy_info_return_from_set_current_activity (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}

typedef void (*gabble_svc_olpc_buddy_info_get_current_activity_impl) (GabbleSvcOLPCBuddyInfo *self,
    guint in_contact,
    DBusGMethodInvocation *context);
void gabble_svc_olpc_buddy_info_implement_get_current_activity (GabbleSvcOLPCBuddyInfoClass *klass, gabble_svc_olpc_buddy_info_get_current_activity_impl impl);
/**
 * gabble_svc_olpc_buddy_info_return_from_get_current_activity:
 * @context: The D-Bus method invocation context
 * @out_activity: const gchar * (FIXME, generate documentation)
 * @out_channel: guint  (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void gabble_svc_olpc_buddy_info_return_from_get_current_activity (DBusGMethodInvocation *context,
    const gchar *out_activity,
    guint out_channel);
static inline void
gabble_svc_olpc_buddy_info_return_from_get_current_activity (DBusGMethodInvocation *context,
    const gchar *out_activity,
    guint out_channel)
{
  dbus_g_method_return (context,
      out_activity,
      out_channel);
}

void gabble_svc_olpc_buddy_info_emit_properties_changed (gpointer instance,
    guint arg_contact,
    GHashTable *arg_properties);
void gabble_svc_olpc_buddy_info_emit_activities_changed (gpointer instance,
    guint arg_contact,
    const GPtrArray *arg_activities);
void gabble_svc_olpc_buddy_info_emit_current_activity_changed (gpointer instance,
    guint arg_contact,
    const gchar *arg_activity,
    guint arg_channel);


G_END_DECLS
