#include "_gen/svc.h"

#include <telepathy-glib/dbus.h>
#include "_gen/signals-marshal.h"

static const DBusGObjectInfo _gabble_svc_call_content_object_info;

struct _GabbleSvcCallContentClass {
    GTypeInterface parent_class;
};

enum {
    SIGNAL_CALL_CONTENT_StreamAdded,
    SIGNAL_CALL_CONTENT_StreamRemoved,
    N_CALL_CONTENT_SIGNALS
};
static guint call_content_signals[N_CALL_CONTENT_SIGNALS] = {0};

static void gabble_svc_call_content_base_init (gpointer klass);

GType
gabble_svc_call_content_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (GabbleSvcCallContentClass),
        gabble_svc_call_content_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "GabbleSvcCallContent", &info, 0);
    }

  return type;
}

/**
 * gabble_svc_call_content_emit_stream_added:
 * @instance: The object implementing this interface
 * @arg_Stream: const gchar * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * StreamAdded signal on interface org.freedesktop.Telepathy.Call.Content.DRAFT.
 */
void
gabble_svc_call_content_emit_stream_added (gpointer instance,
    const gchar *arg_Stream)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, GABBLE_TYPE_SVC_CALL_CONTENT));
  g_signal_emit (instance,
      call_content_signals[SIGNAL_CALL_CONTENT_StreamAdded],
      0,
      arg_Stream);
}

/**
 * gabble_svc_call_content_emit_stream_removed:
 * @instance: The object implementing this interface
 * @arg_Stream: const gchar * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * StreamRemoved signal on interface org.freedesktop.Telepathy.Call.Content.DRAFT.
 */
void
gabble_svc_call_content_emit_stream_removed (gpointer instance,
    const gchar *arg_Stream)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, GABBLE_TYPE_SVC_CALL_CONTENT));
  g_signal_emit (instance,
      call_content_signals[SIGNAL_CALL_CONTENT_StreamRemoved],
      0,
      arg_Stream);
}

static inline void
gabble_svc_call_content_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  static TpDBusPropertiesMixinPropInfo properties[6] = {
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "s", 0, NULL, NULL }, /* Name */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "u", 0, NULL, NULL }, /* Type */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "u", 0, NULL, NULL }, /* Creator */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "u", 0, NULL, NULL }, /* Disposition */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "ao", 0, NULL, NULL }, /* Streams */
      { 0, 0, NULL, 0, NULL, NULL }
  };
  static TpDBusPropertiesMixinIfaceInfo interface =
      { 0, properties, NULL, NULL };

  dbus_g_object_type_install_info (gabble_svc_call_content_get_type (),
      &_gabble_svc_call_content_object_info);

  interface.dbus_interface = g_quark_from_static_string ("org.freedesktop.Telepathy.Call.Content.DRAFT");
  properties[0].name = g_quark_from_static_string ("Name");
  properties[0].type = G_TYPE_STRING;
  properties[1].name = g_quark_from_static_string ("Type");
  properties[1].type = G_TYPE_UINT;
  properties[2].name = g_quark_from_static_string ("Creator");
  properties[2].type = G_TYPE_UINT;
  properties[3].name = g_quark_from_static_string ("Disposition");
  properties[3].type = G_TYPE_UINT;
  properties[4].name = g_quark_from_static_string ("Streams");
  properties[4].type = dbus_g_type_get_collection ("GPtrArray", DBUS_TYPE_G_OBJECT_PATH);
  tp_svc_interface_set_dbus_properties_info (GABBLE_TYPE_SVC_CALL_CONTENT, &interface);

  /**
   * GabbleSvcCallContent::stream-added:
   * @arg_Stream: const gchar * (FIXME, generate documentation)
   *
   * The StreamAdded D-Bus signal is emitted whenever this GObject signal is.
   */
  call_content_signals[SIGNAL_CALL_CONTENT_StreamAdded] =
  g_signal_new ("stream-added",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      g_cclosure_marshal_VOID__BOXED,
      G_TYPE_NONE,
      1,
      DBUS_TYPE_G_OBJECT_PATH);

  /**
   * GabbleSvcCallContent::stream-removed:
   * @arg_Stream: const gchar * (FIXME, generate documentation)
   *
   * The StreamRemoved D-Bus signal is emitted whenever this GObject signal is.
   */
  call_content_signals[SIGNAL_CALL_CONTENT_StreamRemoved] =
  g_signal_new ("stream-removed",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      g_cclosure_marshal_VOID__BOXED,
      G_TYPE_NONE,
      1,
      DBUS_TYPE_G_OBJECT_PATH);

}
static void
gabble_svc_call_content_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      gabble_svc_call_content_base_init_once (klass);
    }
}
static const DBusGMethodInfo _gabble_svc_call_content_methods[] = {
  { NULL, NULL, 0 }
};

static const DBusGObjectInfo _gabble_svc_call_content_object_info = {
  0,
  _gabble_svc_call_content_methods,
  0,
"\0",
"org.freedesktop.Telepathy.Call.Content.DRAFT\0StreamAdded\0org.freedesktop.Telepathy.Call.Content.DRAFT\0StreamRemoved\0\0",
"\0\0",
};

static const DBusGObjectInfo _gabble_svc_call_content_codec_offer_object_info;

struct _GabbleSvcCallContentCodecOfferClass {
    GTypeInterface parent_class;
    gabble_svc_call_content_codec_offer_accept_impl accept_cb;
    gabble_svc_call_content_codec_offer_reject_impl reject_cb;
};

static void gabble_svc_call_content_codec_offer_base_init (gpointer klass);

GType
gabble_svc_call_content_codec_offer_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (GabbleSvcCallContentCodecOfferClass),
        gabble_svc_call_content_codec_offer_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "GabbleSvcCallContentCodecOffer", &info, 0);
    }

  return type;
}

/**
 * gabble_svc_call_content_codec_offer_accept_impl:
 * @self: The object implementing this interface
 * @in_Codecs: const GPtrArray * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * Accept on interface org.freedesktop.Telepathy.Call.Content.CodecOffer.DRAFT.
 */
static void
gabble_svc_call_content_codec_offer_accept (GabbleSvcCallContentCodecOffer *self,
    const GPtrArray *in_Codecs,
    DBusGMethodInvocation *context)
{
  gabble_svc_call_content_codec_offer_accept_impl impl = (GABBLE_SVC_CALL_CONTENT_CODEC_OFFER_GET_CLASS (self)->accept_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_Codecs,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * gabble_svc_call_content_codec_offer_implement_accept:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the Accept D-Bus method
 *
 * Register an implementation for the Accept method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
gabble_svc_call_content_codec_offer_implement_accept (GabbleSvcCallContentCodecOfferClass *klass, gabble_svc_call_content_codec_offer_accept_impl impl)
{
  klass->accept_cb = impl;
}

/**
 * gabble_svc_call_content_codec_offer_reject_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * Reject on interface org.freedesktop.Telepathy.Call.Content.CodecOffer.DRAFT.
 */
static void
gabble_svc_call_content_codec_offer_reject (GabbleSvcCallContentCodecOffer *self,
    DBusGMethodInvocation *context)
{
  gabble_svc_call_content_codec_offer_reject_impl impl = (GABBLE_SVC_CALL_CONTENT_CODEC_OFFER_GET_CLASS (self)->reject_cb);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * gabble_svc_call_content_codec_offer_implement_reject:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the Reject D-Bus method
 *
 * Register an implementation for the Reject method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
gabble_svc_call_content_codec_offer_implement_reject (GabbleSvcCallContentCodecOfferClass *klass, gabble_svc_call_content_codec_offer_reject_impl impl)
{
  klass->reject_cb = impl;
}

static inline void
gabble_svc_call_content_codec_offer_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  static TpDBusPropertiesMixinPropInfo properties[2] = {
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "a{ua(usuua{ss})}", 0, NULL, NULL }, /* RemoteContactCodecMap */
      { 0, 0, NULL, 0, NULL, NULL }
  };
  static TpDBusPropertiesMixinIfaceInfo interface =
      { 0, properties, NULL, NULL };

  dbus_g_object_type_install_info (gabble_svc_call_content_codec_offer_get_type (),
      &_gabble_svc_call_content_codec_offer_object_info);

  interface.dbus_interface = g_quark_from_static_string ("org.freedesktop.Telepathy.Call.Content.CodecOffer.DRAFT");
  properties[0].name = g_quark_from_static_string ("RemoteContactCodecMap");
  properties[0].type = (dbus_g_type_get_map ("GHashTable", G_TYPE_UINT, (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_UINT, DBUS_TYPE_G_STRING_STRING_HASHTABLE, G_TYPE_INVALID))))));
  tp_svc_interface_set_dbus_properties_info (GABBLE_TYPE_SVC_CALL_CONTENT_CODEC_OFFER, &interface);

}
static void
gabble_svc_call_content_codec_offer_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      gabble_svc_call_content_codec_offer_base_init_once (klass);
    }
}
static const DBusGMethodInfo _gabble_svc_call_content_codec_offer_methods[] = {
  { (GCallback) gabble_svc_call_content_codec_offer_accept, _gabble_ext_marshal_VOID__BOXED_POINTER, 0 },
  { (GCallback) gabble_svc_call_content_codec_offer_reject, g_cclosure_marshal_VOID__POINTER, 88 },
};

static const DBusGObjectInfo _gabble_svc_call_content_codec_offer_object_info = {
  0,
  _gabble_svc_call_content_codec_offer_methods,
  2,
"org.freedesktop.Telepathy.Call.Content.CodecOffer.DRAFT\0Accept\0A\0Codecs\0I\0a(usuua{ss})\0\0org.freedesktop.Telepathy.Call.Content.CodecOffer.DRAFT\0Reject\0A\0\0\0",
"\0\0",
"\0\0",
};

static const DBusGObjectInfo _gabble_svc_call_content_interface_media_object_info;

struct _GabbleSvcCallContentInterfaceMediaClass {
    GTypeInterface parent_class;
    gabble_svc_call_content_interface_media_set_codecs_impl set_codecs_cb;
};

enum {
    SIGNAL_CALL_CONTENT_INTERFACE_MEDIA_CodecsChanged,
    SIGNAL_CALL_CONTENT_INTERFACE_MEDIA_NewCodecOffer,
    N_CALL_CONTENT_INTERFACE_MEDIA_SIGNALS
};
static guint call_content_interface_media_signals[N_CALL_CONTENT_INTERFACE_MEDIA_SIGNALS] = {0};

static void gabble_svc_call_content_interface_media_base_init (gpointer klass);

GType
gabble_svc_call_content_interface_media_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (GabbleSvcCallContentInterfaceMediaClass),
        gabble_svc_call_content_interface_media_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "GabbleSvcCallContentInterfaceMedia", &info, 0);
    }

  return type;
}

/**
 * gabble_svc_call_content_interface_media_set_codecs_impl:
 * @self: The object implementing this interface
 * @in_Codecs: const GPtrArray * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * SetCodecs on interface org.freedesktop.Telepathy.Call.Content.Interface.Media.DRAFT.
 */
static void
gabble_svc_call_content_interface_media_set_codecs (GabbleSvcCallContentInterfaceMedia *self,
    const GPtrArray *in_Codecs,
    DBusGMethodInvocation *context)
{
  gabble_svc_call_content_interface_media_set_codecs_impl impl = (GABBLE_SVC_CALL_CONTENT_INTERFACE_MEDIA_GET_CLASS (self)->set_codecs_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_Codecs,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * gabble_svc_call_content_interface_media_implement_set_codecs:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the SetCodecs D-Bus method
 *
 * Register an implementation for the SetCodecs method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
gabble_svc_call_content_interface_media_implement_set_codecs (GabbleSvcCallContentInterfaceMediaClass *klass, gabble_svc_call_content_interface_media_set_codecs_impl impl)
{
  klass->set_codecs_cb = impl;
}

/**
 * gabble_svc_call_content_interface_media_emit_codecs_changed:
 * @instance: The object implementing this interface
 * @arg_Updated_Codecs: GHashTable * (FIXME, generate documentation)
 * @arg_Removed_Contacts: const GArray * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * CodecsChanged signal on interface org.freedesktop.Telepathy.Call.Content.Interface.Media.DRAFT.
 */
void
gabble_svc_call_content_interface_media_emit_codecs_changed (gpointer instance,
    GHashTable *arg_Updated_Codecs,
    const GArray *arg_Removed_Contacts)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, GABBLE_TYPE_SVC_CALL_CONTENT_INTERFACE_MEDIA));
  g_signal_emit (instance,
      call_content_interface_media_signals[SIGNAL_CALL_CONTENT_INTERFACE_MEDIA_CodecsChanged],
      0,
      arg_Updated_Codecs,
      arg_Removed_Contacts);
}

/**
 * gabble_svc_call_content_interface_media_emit_new_codec_offer:
 * @instance: The object implementing this interface
 * @arg_Offer: const gchar * (FIXME, generate documentation)
 * @arg_Codecs: GHashTable * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * NewCodecOffer signal on interface org.freedesktop.Telepathy.Call.Content.Interface.Media.DRAFT.
 */
void
gabble_svc_call_content_interface_media_emit_new_codec_offer (gpointer instance,
    const gchar *arg_Offer,
    GHashTable *arg_Codecs)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, GABBLE_TYPE_SVC_CALL_CONTENT_INTERFACE_MEDIA));
  g_signal_emit (instance,
      call_content_interface_media_signals[SIGNAL_CALL_CONTENT_INTERFACE_MEDIA_NewCodecOffer],
      0,
      arg_Offer,
      arg_Codecs);
}

static inline void
gabble_svc_call_content_interface_media_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  static TpDBusPropertiesMixinPropInfo properties[3] = {
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "a{ua(usuua{ss})}", 0, NULL, NULL }, /* ContactCodecMap */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "(oa{ua(usuua{ss})})", 0, NULL, NULL }, /* CodecOffer */
      { 0, 0, NULL, 0, NULL, NULL }
  };
  static TpDBusPropertiesMixinIfaceInfo interface =
      { 0, properties, NULL, NULL };

  dbus_g_object_type_install_info (gabble_svc_call_content_interface_media_get_type (),
      &_gabble_svc_call_content_interface_media_object_info);

  interface.dbus_interface = g_quark_from_static_string ("org.freedesktop.Telepathy.Call.Content.Interface.Media.DRAFT");
  properties[0].name = g_quark_from_static_string ("ContactCodecMap");
  properties[0].type = (dbus_g_type_get_map ("GHashTable", G_TYPE_UINT, (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_UINT, DBUS_TYPE_G_STRING_STRING_HASHTABLE, G_TYPE_INVALID))))));
  properties[1].name = g_quark_from_static_string ("CodecOffer");
  properties[1].type = (dbus_g_type_get_struct ("GValueArray", DBUS_TYPE_G_OBJECT_PATH, (dbus_g_type_get_map ("GHashTable", G_TYPE_UINT, (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_UINT, DBUS_TYPE_G_STRING_STRING_HASHTABLE, G_TYPE_INVALID)))))), G_TYPE_INVALID));
  tp_svc_interface_set_dbus_properties_info (GABBLE_TYPE_SVC_CALL_CONTENT_INTERFACE_MEDIA, &interface);

  /**
   * GabbleSvcCallContentInterfaceMedia::codecs-changed:
   * @arg_Updated_Codecs: GHashTable * (FIXME, generate documentation)
   * @arg_Removed_Contacts: const GArray * (FIXME, generate documentation)
   *
   * The CodecsChanged D-Bus signal is emitted whenever this GObject signal is.
   */
  call_content_interface_media_signals[SIGNAL_CALL_CONTENT_INTERFACE_MEDIA_CodecsChanged] =
  g_signal_new ("codecs-changed",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      _gabble_ext_marshal_VOID__BOXED_BOXED,
      G_TYPE_NONE,
      2,
      (dbus_g_type_get_map ("GHashTable", G_TYPE_UINT, (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_UINT, DBUS_TYPE_G_STRING_STRING_HASHTABLE, G_TYPE_INVALID)))))),
      DBUS_TYPE_G_UINT_ARRAY);

  /**
   * GabbleSvcCallContentInterfaceMedia::new-codec-offer:
   * @arg_Offer: const gchar * (FIXME, generate documentation)
   * @arg_Codecs: GHashTable * (FIXME, generate documentation)
   *
   * The NewCodecOffer D-Bus signal is emitted whenever this GObject signal is.
   */
  call_content_interface_media_signals[SIGNAL_CALL_CONTENT_INTERFACE_MEDIA_NewCodecOffer] =
  g_signal_new ("new-codec-offer",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      _gabble_ext_marshal_VOID__BOXED_BOXED,
      G_TYPE_NONE,
      2,
      DBUS_TYPE_G_OBJECT_PATH,
      (dbus_g_type_get_map ("GHashTable", G_TYPE_UINT, (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_UINT, DBUS_TYPE_G_STRING_STRING_HASHTABLE, G_TYPE_INVALID)))))));

}
static void
gabble_svc_call_content_interface_media_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      gabble_svc_call_content_interface_media_base_init_once (klass);
    }
}
static const DBusGMethodInfo _gabble_svc_call_content_interface_media_methods[] = {
  { (GCallback) gabble_svc_call_content_interface_media_set_codecs, _gabble_ext_marshal_VOID__BOXED_POINTER, 0 },
};

static const DBusGObjectInfo _gabble_svc_call_content_interface_media_object_info = {
  0,
  _gabble_svc_call_content_interface_media_methods,
  1,
"org.freedesktop.Telepathy.Call.Content.Interface.Media.DRAFT\0SetCodecs\0A\0Codecs\0I\0a(usuua{ss})\0\0\0",
"org.freedesktop.Telepathy.Call.Content.Interface.Media.DRAFT\0CodecsChanged\0org.freedesktop.Telepathy.Call.Content.Interface.Media.DRAFT\0NewCodecOffer\0\0",
"\0\0",
};

static const DBusGObjectInfo _gabble_svc_call_stream_object_info;

struct _GabbleSvcCallStreamClass {
    GTypeInterface parent_class;
    gabble_svc_call_stream_set_sending_impl set_sending_cb;
    gabble_svc_call_stream_request_receiving_impl request_receiving_cb;
};

enum {
    SIGNAL_CALL_STREAM_SendersChanged,
    N_CALL_STREAM_SIGNALS
};
static guint call_stream_signals[N_CALL_STREAM_SIGNALS] = {0};

static void gabble_svc_call_stream_base_init (gpointer klass);

GType
gabble_svc_call_stream_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (GabbleSvcCallStreamClass),
        gabble_svc_call_stream_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "GabbleSvcCallStream", &info, 0);
    }

  return type;
}

/**
 * gabble_svc_call_stream_set_sending_impl:
 * @self: The object implementing this interface
 * @in_Send: gboolean  (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * SetSending on interface org.freedesktop.Telepathy.Call.Stream.DRAFT.
 */
static void
gabble_svc_call_stream_set_sending (GabbleSvcCallStream *self,
    gboolean in_Send,
    DBusGMethodInvocation *context)
{
  gabble_svc_call_stream_set_sending_impl impl = (GABBLE_SVC_CALL_STREAM_GET_CLASS (self)->set_sending_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_Send,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * gabble_svc_call_stream_implement_set_sending:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the SetSending D-Bus method
 *
 * Register an implementation for the SetSending method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
gabble_svc_call_stream_implement_set_sending (GabbleSvcCallStreamClass *klass, gabble_svc_call_stream_set_sending_impl impl)
{
  klass->set_sending_cb = impl;
}

/**
 * gabble_svc_call_stream_request_receiving_impl:
 * @self: The object implementing this interface
 * @in_Contact: guint  (FIXME, generate documentation)
 * @in_Receive: gboolean  (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * RequestReceiving on interface org.freedesktop.Telepathy.Call.Stream.DRAFT.
 */
static void
gabble_svc_call_stream_request_receiving (GabbleSvcCallStream *self,
    guint in_Contact,
    gboolean in_Receive,
    DBusGMethodInvocation *context)
{
  gabble_svc_call_stream_request_receiving_impl impl = (GABBLE_SVC_CALL_STREAM_GET_CLASS (self)->request_receiving_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_Contact,
        in_Receive,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * gabble_svc_call_stream_implement_request_receiving:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the RequestReceiving D-Bus method
 *
 * Register an implementation for the RequestReceiving method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
gabble_svc_call_stream_implement_request_receiving (GabbleSvcCallStreamClass *klass, gabble_svc_call_stream_request_receiving_impl impl)
{
  klass->request_receiving_cb = impl;
}

/**
 * gabble_svc_call_stream_emit_senders_changed:
 * @instance: The object implementing this interface
 * @arg_Updates: GHashTable * (FIXME, generate documentation)
 * @arg_Removed: const GArray * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * SendersChanged signal on interface org.freedesktop.Telepathy.Call.Stream.DRAFT.
 */
void
gabble_svc_call_stream_emit_senders_changed (gpointer instance,
    GHashTable *arg_Updates,
    const GArray *arg_Removed)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, GABBLE_TYPE_SVC_CALL_STREAM));
  g_signal_emit (instance,
      call_stream_signals[SIGNAL_CALL_STREAM_SendersChanged],
      0,
      arg_Updates,
      arg_Removed);
}

static inline void
gabble_svc_call_stream_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  static TpDBusPropertiesMixinPropInfo properties[2] = {
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "a{uu}", 0, NULL, NULL }, /* Senders */
      { 0, 0, NULL, 0, NULL, NULL }
  };
  static TpDBusPropertiesMixinIfaceInfo interface =
      { 0, properties, NULL, NULL };

  dbus_g_object_type_install_info (gabble_svc_call_stream_get_type (),
      &_gabble_svc_call_stream_object_info);

  interface.dbus_interface = g_quark_from_static_string ("org.freedesktop.Telepathy.Call.Stream.DRAFT");
  properties[0].name = g_quark_from_static_string ("Senders");
  properties[0].type = (dbus_g_type_get_map ("GHashTable", G_TYPE_UINT, G_TYPE_UINT));
  tp_svc_interface_set_dbus_properties_info (GABBLE_TYPE_SVC_CALL_STREAM, &interface);

  /**
   * GabbleSvcCallStream::senders-changed:
   * @arg_Updates: GHashTable * (FIXME, generate documentation)
   * @arg_Removed: const GArray * (FIXME, generate documentation)
   *
   * The SendersChanged D-Bus signal is emitted whenever this GObject signal is.
   */
  call_stream_signals[SIGNAL_CALL_STREAM_SendersChanged] =
  g_signal_new ("senders-changed",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      _gabble_ext_marshal_VOID__BOXED_BOXED,
      G_TYPE_NONE,
      2,
      (dbus_g_type_get_map ("GHashTable", G_TYPE_UINT, G_TYPE_UINT)),
      DBUS_TYPE_G_UINT_ARRAY);

}
static void
gabble_svc_call_stream_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      gabble_svc_call_stream_base_init_once (klass);
    }
}
static const DBusGMethodInfo _gabble_svc_call_stream_methods[] = {
  { (GCallback) gabble_svc_call_stream_set_sending, _gabble_ext_marshal_VOID__BOOLEAN_POINTER, 0 },
  { (GCallback) gabble_svc_call_stream_request_receiving, _gabble_ext_marshal_VOID__UINT_BOOLEAN_POINTER, 67 },
};

static const DBusGObjectInfo _gabble_svc_call_stream_object_info = {
  0,
  _gabble_svc_call_stream_methods,
  2,
"org.freedesktop.Telepathy.Call.Stream.DRAFT\0SetSending\0A\0Send\0I\0b\0\0org.freedesktop.Telepathy.Call.Stream.DRAFT\0RequestReceiving\0A\0Contact\0I\0u\0Receive\0I\0b\0\0\0",
"org.freedesktop.Telepathy.Call.Stream.DRAFT\0SendersChanged\0\0",
"\0\0",
};

static const DBusGObjectInfo _gabble_svc_call_stream_endpoint_object_info;

struct _GabbleSvcCallStreamEndpointClass {
    GTypeInterface parent_class;
    gabble_svc_call_stream_endpoint_set_selected_candidate_impl set_selected_candidate_cb;
    gabble_svc_call_stream_endpoint_set_stream_state_impl set_stream_state_cb;
};

enum {
    SIGNAL_CALL_STREAM_ENDPOINT_RemoteCredentialsSet,
    SIGNAL_CALL_STREAM_ENDPOINT_RemoteCandidatesAdded,
    SIGNAL_CALL_STREAM_ENDPOINT_CandidateSelected,
    SIGNAL_CALL_STREAM_ENDPOINT_StreamStateChanged,
    N_CALL_STREAM_ENDPOINT_SIGNALS
};
static guint call_stream_endpoint_signals[N_CALL_STREAM_ENDPOINT_SIGNALS] = {0};

static void gabble_svc_call_stream_endpoint_base_init (gpointer klass);

GType
gabble_svc_call_stream_endpoint_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (GabbleSvcCallStreamEndpointClass),
        gabble_svc_call_stream_endpoint_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "GabbleSvcCallStreamEndpoint", &info, 0);
    }

  return type;
}

/**
 * gabble_svc_call_stream_endpoint_set_selected_candidate_impl:
 * @self: The object implementing this interface
 * @in_Candidate: const GValueArray * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * SetSelectedCandidate on interface org.freedesktop.Telepathy.Call.Stream.Endpoint.DRAFT.
 */
static void
gabble_svc_call_stream_endpoint_set_selected_candidate (GabbleSvcCallStreamEndpoint *self,
    const GValueArray *in_Candidate,
    DBusGMethodInvocation *context)
{
  gabble_svc_call_stream_endpoint_set_selected_candidate_impl impl = (GABBLE_SVC_CALL_STREAM_ENDPOINT_GET_CLASS (self)->set_selected_candidate_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_Candidate,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * gabble_svc_call_stream_endpoint_implement_set_selected_candidate:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the SetSelectedCandidate D-Bus method
 *
 * Register an implementation for the SetSelectedCandidate method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
gabble_svc_call_stream_endpoint_implement_set_selected_candidate (GabbleSvcCallStreamEndpointClass *klass, gabble_svc_call_stream_endpoint_set_selected_candidate_impl impl)
{
  klass->set_selected_candidate_cb = impl;
}

/**
 * gabble_svc_call_stream_endpoint_set_stream_state_impl:
 * @self: The object implementing this interface
 * @in_State: guint  (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * SetStreamState on interface org.freedesktop.Telepathy.Call.Stream.Endpoint.DRAFT.
 */
static void
gabble_svc_call_stream_endpoint_set_stream_state (GabbleSvcCallStreamEndpoint *self,
    guint in_State,
    DBusGMethodInvocation *context)
{
  gabble_svc_call_stream_endpoint_set_stream_state_impl impl = (GABBLE_SVC_CALL_STREAM_ENDPOINT_GET_CLASS (self)->set_stream_state_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_State,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * gabble_svc_call_stream_endpoint_implement_set_stream_state:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the SetStreamState D-Bus method
 *
 * Register an implementation for the SetStreamState method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
gabble_svc_call_stream_endpoint_implement_set_stream_state (GabbleSvcCallStreamEndpointClass *klass, gabble_svc_call_stream_endpoint_set_stream_state_impl impl)
{
  klass->set_stream_state_cb = impl;
}

/**
 * gabble_svc_call_stream_endpoint_emit_remote_credentials_set:
 * @instance: The object implementing this interface
 * @arg_Username: const gchar * (FIXME, generate documentation)
 * @arg_Password: const gchar * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * RemoteCredentialsSet signal on interface org.freedesktop.Telepathy.Call.Stream.Endpoint.DRAFT.
 */
void
gabble_svc_call_stream_endpoint_emit_remote_credentials_set (gpointer instance,
    const gchar *arg_Username,
    const gchar *arg_Password)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, GABBLE_TYPE_SVC_CALL_STREAM_ENDPOINT));
  g_signal_emit (instance,
      call_stream_endpoint_signals[SIGNAL_CALL_STREAM_ENDPOINT_RemoteCredentialsSet],
      0,
      arg_Username,
      arg_Password);
}

/**
 * gabble_svc_call_stream_endpoint_emit_remote_candidates_added:
 * @instance: The object implementing this interface
 * @arg_Candidates: const GPtrArray * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * RemoteCandidatesAdded signal on interface org.freedesktop.Telepathy.Call.Stream.Endpoint.DRAFT.
 */
void
gabble_svc_call_stream_endpoint_emit_remote_candidates_added (gpointer instance,
    const GPtrArray *arg_Candidates)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, GABBLE_TYPE_SVC_CALL_STREAM_ENDPOINT));
  g_signal_emit (instance,
      call_stream_endpoint_signals[SIGNAL_CALL_STREAM_ENDPOINT_RemoteCandidatesAdded],
      0,
      arg_Candidates);
}

/**
 * gabble_svc_call_stream_endpoint_emit_candidate_selected:
 * @instance: The object implementing this interface
 * @arg_Candidate: const GValueArray * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * CandidateSelected signal on interface org.freedesktop.Telepathy.Call.Stream.Endpoint.DRAFT.
 */
void
gabble_svc_call_stream_endpoint_emit_candidate_selected (gpointer instance,
    const GValueArray *arg_Candidate)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, GABBLE_TYPE_SVC_CALL_STREAM_ENDPOINT));
  g_signal_emit (instance,
      call_stream_endpoint_signals[SIGNAL_CALL_STREAM_ENDPOINT_CandidateSelected],
      0,
      arg_Candidate);
}

/**
 * gabble_svc_call_stream_endpoint_emit_stream_state_changed:
 * @instance: The object implementing this interface
 * @arg_state: guint  (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * StreamStateChanged signal on interface org.freedesktop.Telepathy.Call.Stream.Endpoint.DRAFT.
 */
void
gabble_svc_call_stream_endpoint_emit_stream_state_changed (gpointer instance,
    guint arg_state)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, GABBLE_TYPE_SVC_CALL_STREAM_ENDPOINT));
  g_signal_emit (instance,
      call_stream_endpoint_signals[SIGNAL_CALL_STREAM_ENDPOINT_StreamStateChanged],
      0,
      arg_state);
}

static inline void
gabble_svc_call_stream_endpoint_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  static TpDBusPropertiesMixinPropInfo properties[6] = {
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "(ss)", 0, NULL, NULL }, /* RemoteCredentials */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "a(usqa{sv})", 0, NULL, NULL }, /* RemoteCandidates */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "(usqa{sv})", 0, NULL, NULL }, /* SelectedCandidate */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "u", 0, NULL, NULL }, /* StreamState */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "u", 0, NULL, NULL }, /* Transport */
      { 0, 0, NULL, 0, NULL, NULL }
  };
  static TpDBusPropertiesMixinIfaceInfo interface =
      { 0, properties, NULL, NULL };

  dbus_g_object_type_install_info (gabble_svc_call_stream_endpoint_get_type (),
      &_gabble_svc_call_stream_endpoint_object_info);

  interface.dbus_interface = g_quark_from_static_string ("org.freedesktop.Telepathy.Call.Stream.Endpoint.DRAFT");
  properties[0].name = g_quark_from_static_string ("RemoteCredentials");
  properties[0].type = (dbus_g_type_get_struct ("GValueArray", G_TYPE_STRING, G_TYPE_STRING, G_TYPE_INVALID));
  properties[1].name = g_quark_from_static_string ("RemoteCandidates");
  properties[1].type = (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)), G_TYPE_INVALID))));
  properties[2].name = g_quark_from_static_string ("SelectedCandidate");
  properties[2].type = (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)), G_TYPE_INVALID));
  properties[3].name = g_quark_from_static_string ("StreamState");
  properties[3].type = G_TYPE_UINT;
  properties[4].name = g_quark_from_static_string ("Transport");
  properties[4].type = G_TYPE_UINT;
  tp_svc_interface_set_dbus_properties_info (GABBLE_TYPE_SVC_CALL_STREAM_ENDPOINT, &interface);

  /**
   * GabbleSvcCallStreamEndpoint::remote-credentials-set:
   * @arg_Username: const gchar * (FIXME, generate documentation)
   * @arg_Password: const gchar * (FIXME, generate documentation)
   *
   * The RemoteCredentialsSet D-Bus signal is emitted whenever this GObject signal is.
   */
  call_stream_endpoint_signals[SIGNAL_CALL_STREAM_ENDPOINT_RemoteCredentialsSet] =
  g_signal_new ("remote-credentials-set",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      _gabble_ext_marshal_VOID__STRING_STRING,
      G_TYPE_NONE,
      2,
      G_TYPE_STRING,
      G_TYPE_STRING);

  /**
   * GabbleSvcCallStreamEndpoint::remote-candidates-added:
   * @arg_Candidates: const GPtrArray * (FIXME, generate documentation)
   *
   * The RemoteCandidatesAdded D-Bus signal is emitted whenever this GObject signal is.
   */
  call_stream_endpoint_signals[SIGNAL_CALL_STREAM_ENDPOINT_RemoteCandidatesAdded] =
  g_signal_new ("remote-candidates-added",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      g_cclosure_marshal_VOID__BOXED,
      G_TYPE_NONE,
      1,
      (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)), G_TYPE_INVALID)))));

  /**
   * GabbleSvcCallStreamEndpoint::candidate-selected:
   * @arg_Candidate: const GValueArray * (FIXME, generate documentation)
   *
   * The CandidateSelected D-Bus signal is emitted whenever this GObject signal is.
   */
  call_stream_endpoint_signals[SIGNAL_CALL_STREAM_ENDPOINT_CandidateSelected] =
  g_signal_new ("candidate-selected",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      g_cclosure_marshal_VOID__BOXED,
      G_TYPE_NONE,
      1,
      (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)), G_TYPE_INVALID)));

  /**
   * GabbleSvcCallStreamEndpoint::stream-state-changed:
   * @arg_state: guint  (FIXME, generate documentation)
   *
   * The StreamStateChanged D-Bus signal is emitted whenever this GObject signal is.
   */
  call_stream_endpoint_signals[SIGNAL_CALL_STREAM_ENDPOINT_StreamStateChanged] =
  g_signal_new ("stream-state-changed",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      g_cclosure_marshal_VOID__UINT,
      G_TYPE_NONE,
      1,
      G_TYPE_UINT);

}
static void
gabble_svc_call_stream_endpoint_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      gabble_svc_call_stream_endpoint_base_init_once (klass);
    }
}
static const DBusGMethodInfo _gabble_svc_call_stream_endpoint_methods[] = {
  { (GCallback) gabble_svc_call_stream_endpoint_set_selected_candidate, _gabble_ext_marshal_VOID__BOXED_POINTER, 0 },
  { (GCallback) gabble_svc_call_stream_endpoint_set_stream_state, g_cclosure_marshal_VOID__UINT_POINTER, 100 },
};

static const DBusGObjectInfo _gabble_svc_call_stream_endpoint_object_info = {
  0,
  _gabble_svc_call_stream_endpoint_methods,
  2,
"org.freedesktop.Telepathy.Call.Stream.Endpoint.DRAFT\0SetSelectedCandidate\0A\0Candidate\0I\0(usqa{sv})\0\0org.freedesktop.Telepathy.Call.Stream.Endpoint.DRAFT\0SetStreamState\0A\0State\0I\0u\0\0\0",
"org.freedesktop.Telepathy.Call.Stream.Endpoint.DRAFT\0RemoteCredentialsSet\0org.freedesktop.Telepathy.Call.Stream.Endpoint.DRAFT\0RemoteCandidatesAdded\0org.freedesktop.Telepathy.Call.Stream.Endpoint.DRAFT\0CandidateSelected\0org.freedesktop.Telepathy.Call.Stream.Endpoint.DRAFT\0StreamStateChanged\0\0",
"\0\0",
};

static const DBusGObjectInfo _gabble_svc_call_stream_interface_media_object_info;

struct _GabbleSvcCallStreamInterfaceMediaClass {
    GTypeInterface parent_class;
    gabble_svc_call_stream_interface_media_add_candidates_impl add_candidates_cb;
    gabble_svc_call_stream_interface_media_candidates_prepared_impl candidates_prepared_cb;
};

enum {
    SIGNAL_CALL_STREAM_INTERFACE_MEDIA_LocalCandidatesAdded,
    SIGNAL_CALL_STREAM_INTERFACE_MEDIA_LocalCredentialsSet,
    SIGNAL_CALL_STREAM_INTERFACE_MEDIA_ServerInfoRetrieved,
    SIGNAL_CALL_STREAM_INTERFACE_MEDIA_EndpointsChanged,
    N_CALL_STREAM_INTERFACE_MEDIA_SIGNALS
};
static guint call_stream_interface_media_signals[N_CALL_STREAM_INTERFACE_MEDIA_SIGNALS] = {0};

static void gabble_svc_call_stream_interface_media_base_init (gpointer klass);

GType
gabble_svc_call_stream_interface_media_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (GabbleSvcCallStreamInterfaceMediaClass),
        gabble_svc_call_stream_interface_media_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "GabbleSvcCallStreamInterfaceMedia", &info, 0);
    }

  return type;
}

/**
 * gabble_svc_call_stream_interface_media_add_candidates_impl:
 * @self: The object implementing this interface
 * @in_candidates: const GPtrArray * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * AddCandidates on interface org.freedesktop.Telepathy.Call.Stream.Interface.Media.DRAFT.
 */
static void
gabble_svc_call_stream_interface_media_add_candidates (GabbleSvcCallStreamInterfaceMedia *self,
    const GPtrArray *in_candidates,
    DBusGMethodInvocation *context)
{
  gabble_svc_call_stream_interface_media_add_candidates_impl impl = (GABBLE_SVC_CALL_STREAM_INTERFACE_MEDIA_GET_CLASS (self)->add_candidates_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_candidates,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * gabble_svc_call_stream_interface_media_implement_add_candidates:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the AddCandidates D-Bus method
 *
 * Register an implementation for the AddCandidates method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
gabble_svc_call_stream_interface_media_implement_add_candidates (GabbleSvcCallStreamInterfaceMediaClass *klass, gabble_svc_call_stream_interface_media_add_candidates_impl impl)
{
  klass->add_candidates_cb = impl;
}

/**
 * gabble_svc_call_stream_interface_media_candidates_prepared_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * CandidatesPrepared on interface org.freedesktop.Telepathy.Call.Stream.Interface.Media.DRAFT.
 */
static void
gabble_svc_call_stream_interface_media_candidates_prepared (GabbleSvcCallStreamInterfaceMedia *self,
    DBusGMethodInvocation *context)
{
  gabble_svc_call_stream_interface_media_candidates_prepared_impl impl = (GABBLE_SVC_CALL_STREAM_INTERFACE_MEDIA_GET_CLASS (self)->candidates_prepared_cb);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * gabble_svc_call_stream_interface_media_implement_candidates_prepared:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the CandidatesPrepared D-Bus method
 *
 * Register an implementation for the CandidatesPrepared method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
gabble_svc_call_stream_interface_media_implement_candidates_prepared (GabbleSvcCallStreamInterfaceMediaClass *klass, gabble_svc_call_stream_interface_media_candidates_prepared_impl impl)
{
  klass->candidates_prepared_cb = impl;
}

/**
 * gabble_svc_call_stream_interface_media_emit_local_candidates_added:
 * @instance: The object implementing this interface
 * @arg_Candidates: const GPtrArray * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * LocalCandidatesAdded signal on interface org.freedesktop.Telepathy.Call.Stream.Interface.Media.DRAFT.
 */
void
gabble_svc_call_stream_interface_media_emit_local_candidates_added (gpointer instance,
    const GPtrArray *arg_Candidates)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, GABBLE_TYPE_SVC_CALL_STREAM_INTERFACE_MEDIA));
  g_signal_emit (instance,
      call_stream_interface_media_signals[SIGNAL_CALL_STREAM_INTERFACE_MEDIA_LocalCandidatesAdded],
      0,
      arg_Candidates);
}

/**
 * gabble_svc_call_stream_interface_media_emit_local_credentials_set:
 * @instance: The object implementing this interface
 * @arg_Username: const gchar * (FIXME, generate documentation)
 * @arg_Password: const gchar * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * LocalCredentialsSet signal on interface org.freedesktop.Telepathy.Call.Stream.Interface.Media.DRAFT.
 */
void
gabble_svc_call_stream_interface_media_emit_local_credentials_set (gpointer instance,
    const gchar *arg_Username,
    const gchar *arg_Password)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, GABBLE_TYPE_SVC_CALL_STREAM_INTERFACE_MEDIA));
  g_signal_emit (instance,
      call_stream_interface_media_signals[SIGNAL_CALL_STREAM_INTERFACE_MEDIA_LocalCredentialsSet],
      0,
      arg_Username,
      arg_Password);
}

/**
 * gabble_svc_call_stream_interface_media_emit_server_info_retrieved:
 * @instance: The object implementing this interface
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * ServerInfoRetrieved signal on interface org.freedesktop.Telepathy.Call.Stream.Interface.Media.DRAFT.
 */
void
gabble_svc_call_stream_interface_media_emit_server_info_retrieved (gpointer instance)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, GABBLE_TYPE_SVC_CALL_STREAM_INTERFACE_MEDIA));
  g_signal_emit (instance,
      call_stream_interface_media_signals[SIGNAL_CALL_STREAM_INTERFACE_MEDIA_ServerInfoRetrieved],
      0);
}

/**
 * gabble_svc_call_stream_interface_media_emit_endpoints_changed:
 * @instance: The object implementing this interface
 * @arg_EndpointsAdded: const GPtrArray * (FIXME, generate documentation)
 * @arg_EndpointsRemoved: const GPtrArray * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * EndpointsChanged signal on interface org.freedesktop.Telepathy.Call.Stream.Interface.Media.DRAFT.
 */
void
gabble_svc_call_stream_interface_media_emit_endpoints_changed (gpointer instance,
    const GPtrArray *arg_EndpointsAdded,
    const GPtrArray *arg_EndpointsRemoved)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, GABBLE_TYPE_SVC_CALL_STREAM_INTERFACE_MEDIA));
  g_signal_emit (instance,
      call_stream_interface_media_signals[SIGNAL_CALL_STREAM_INTERFACE_MEDIA_EndpointsChanged],
      0,
      arg_EndpointsAdded,
      arg_EndpointsRemoved);
}

static inline void
gabble_svc_call_stream_interface_media_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  static TpDBusPropertiesMixinPropInfo properties[8] = {
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "u", 0, NULL, NULL }, /* Transport */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "a(usqa{sv})", 0, NULL, NULL }, /* LocalCandidates */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "(ss)", 0, NULL, NULL }, /* LocalCredentials */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "a(sq)", 0, NULL, NULL }, /* STUNServers */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "aa{sv}", 0, NULL, NULL }, /* RelayInfo */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "b", 0, NULL, NULL }, /* RetrievedServerInfo */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "ao", 0, NULL, NULL }, /* Endpoints */
      { 0, 0, NULL, 0, NULL, NULL }
  };
  static TpDBusPropertiesMixinIfaceInfo interface =
      { 0, properties, NULL, NULL };

  dbus_g_object_type_install_info (gabble_svc_call_stream_interface_media_get_type (),
      &_gabble_svc_call_stream_interface_media_object_info);

  interface.dbus_interface = g_quark_from_static_string ("org.freedesktop.Telepathy.Call.Stream.Interface.Media.DRAFT");
  properties[0].name = g_quark_from_static_string ("Transport");
  properties[0].type = G_TYPE_UINT;
  properties[1].name = g_quark_from_static_string ("LocalCandidates");
  properties[1].type = (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)), G_TYPE_INVALID))));
  properties[2].name = g_quark_from_static_string ("LocalCredentials");
  properties[2].type = (dbus_g_type_get_struct ("GValueArray", G_TYPE_STRING, G_TYPE_STRING, G_TYPE_INVALID));
  properties[3].name = g_quark_from_static_string ("STUNServers");
  properties[3].type = (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_STRING, G_TYPE_UINT, G_TYPE_INVALID))));
  properties[4].name = g_quark_from_static_string ("RelayInfo");
  properties[4].type = (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE))));
  properties[5].name = g_quark_from_static_string ("RetrievedServerInfo");
  properties[5].type = G_TYPE_BOOLEAN;
  properties[6].name = g_quark_from_static_string ("Endpoints");
  properties[6].type = dbus_g_type_get_collection ("GPtrArray", DBUS_TYPE_G_OBJECT_PATH);
  tp_svc_interface_set_dbus_properties_info (GABBLE_TYPE_SVC_CALL_STREAM_INTERFACE_MEDIA, &interface);

  /**
   * GabbleSvcCallStreamInterfaceMedia::local-candidates-added:
   * @arg_Candidates: const GPtrArray * (FIXME, generate documentation)
   *
   * The LocalCandidatesAdded D-Bus signal is emitted whenever this GObject signal is.
   */
  call_stream_interface_media_signals[SIGNAL_CALL_STREAM_INTERFACE_MEDIA_LocalCandidatesAdded] =
  g_signal_new ("local-candidates-added",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      g_cclosure_marshal_VOID__BOXED,
      G_TYPE_NONE,
      1,
      (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)), G_TYPE_INVALID)))));

  /**
   * GabbleSvcCallStreamInterfaceMedia::local-credentials-set:
   * @arg_Username: const gchar * (FIXME, generate documentation)
   * @arg_Password: const gchar * (FIXME, generate documentation)
   *
   * The LocalCredentialsSet D-Bus signal is emitted whenever this GObject signal is.
   */
  call_stream_interface_media_signals[SIGNAL_CALL_STREAM_INTERFACE_MEDIA_LocalCredentialsSet] =
  g_signal_new ("local-credentials-set",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      _gabble_ext_marshal_VOID__STRING_STRING,
      G_TYPE_NONE,
      2,
      G_TYPE_STRING,
      G_TYPE_STRING);

  /**
   * GabbleSvcCallStreamInterfaceMedia::server-info-retrieved:
   *
   * The ServerInfoRetrieved D-Bus signal is emitted whenever this GObject signal is.
   */
  call_stream_interface_media_signals[SIGNAL_CALL_STREAM_INTERFACE_MEDIA_ServerInfoRetrieved] =
  g_signal_new ("server-info-retrieved",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      g_cclosure_marshal_VOID__VOID,
      G_TYPE_NONE,
      0);

  /**
   * GabbleSvcCallStreamInterfaceMedia::endpoints-changed:
   * @arg_EndpointsAdded: const GPtrArray * (FIXME, generate documentation)
   * @arg_EndpointsRemoved: const GPtrArray * (FIXME, generate documentation)
   *
   * The EndpointsChanged D-Bus signal is emitted whenever this GObject signal is.
   */
  call_stream_interface_media_signals[SIGNAL_CALL_STREAM_INTERFACE_MEDIA_EndpointsChanged] =
  g_signal_new ("endpoints-changed",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      _gabble_ext_marshal_VOID__BOXED_BOXED,
      G_TYPE_NONE,
      2,
      dbus_g_type_get_collection ("GPtrArray", DBUS_TYPE_G_OBJECT_PATH),
      dbus_g_type_get_collection ("GPtrArray", DBUS_TYPE_G_OBJECT_PATH));

}
static void
gabble_svc_call_stream_interface_media_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      gabble_svc_call_stream_interface_media_base_init_once (klass);
    }
}
static const DBusGMethodInfo _gabble_svc_call_stream_interface_media_methods[] = {
  { (GCallback) gabble_svc_call_stream_interface_media_add_candidates, _gabble_ext_marshal_VOID__BOXED_POINTER, 0 },
  { (GCallback) gabble_svc_call_stream_interface_media_candidates_prepared, g_cclosure_marshal_VOID__POINTER, 102 },
};

static const DBusGObjectInfo _gabble_svc_call_stream_interface_media_object_info = {
  0,
  _gabble_svc_call_stream_interface_media_methods,
  2,
"org.freedesktop.Telepathy.Call.Stream.Interface.Media.DRAFT\0AddCandidates\0A\0candidates\0I\0a(usqa{sv})\0\0org.freedesktop.Telepathy.Call.Stream.Interface.Media.DRAFT\0CandidatesPrepared\0A\0\0\0",
"org.freedesktop.Telepathy.Call.Stream.Interface.Media.DRAFT\0LocalCandidatesAdded\0org.freedesktop.Telepathy.Call.Stream.Interface.Media.DRAFT\0LocalCredentialsSet\0org.freedesktop.Telepathy.Call.Stream.Interface.Media.DRAFT\0ServerInfoRetrieved\0org.freedesktop.Telepathy.Call.Stream.Interface.Media.DRAFT\0EndpointsChanged\0\0",
"\0\0",
};

static const DBusGObjectInfo _gabble_svc_channel_bundle_object_info;

struct _GabbleSvcChannelBundleClass {
    GTypeInterface parent_class;
};

static void gabble_svc_channel_bundle_base_init (gpointer klass);

GType
gabble_svc_channel_bundle_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (GabbleSvcChannelBundleClass),
        gabble_svc_channel_bundle_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "GabbleSvcChannelBundle", &info, 0);
    }

  return type;
}

static inline void
gabble_svc_channel_bundle_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  static TpDBusPropertiesMixinPropInfo properties[2] = {
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "as", 0, NULL, NULL }, /* Interfaces */
      { 0, 0, NULL, 0, NULL, NULL }
  };
  static TpDBusPropertiesMixinIfaceInfo interface =
      { 0, properties, NULL, NULL };

  dbus_g_object_type_install_info (gabble_svc_channel_bundle_get_type (),
      &_gabble_svc_channel_bundle_object_info);

  interface.dbus_interface = g_quark_from_static_string ("org.freedesktop.Telepathy.ChannelBundle.DRAFT");
  properties[0].name = g_quark_from_static_string ("Interfaces");
  properties[0].type = G_TYPE_STRV;
  tp_svc_interface_set_dbus_properties_info (GABBLE_TYPE_SVC_CHANNEL_BUNDLE, &interface);

}
static void
gabble_svc_channel_bundle_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      gabble_svc_channel_bundle_base_init_once (klass);
    }
}
static const DBusGMethodInfo _gabble_svc_channel_bundle_methods[] = {
  { NULL, NULL, 0 }
};

static const DBusGObjectInfo _gabble_svc_channel_bundle_object_info = {
  0,
  _gabble_svc_channel_bundle_methods,
  0,
"\0",
"\0\0",
"\0\0",
};

static const DBusGObjectInfo _gabble_svc_channel_future_object_info;

struct _GabbleSvcChannelFutureClass {
    GTypeInterface parent_class;
};

static void gabble_svc_channel_future_base_init (gpointer klass);

GType
gabble_svc_channel_future_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (GabbleSvcChannelFutureClass),
        gabble_svc_channel_future_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "GabbleSvcChannelFuture", &info, 0);
    }

  return type;
}

static inline void
gabble_svc_channel_future_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  static TpDBusPropertiesMixinPropInfo properties[2] = {
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "o", 0, NULL, NULL }, /* Bundle */
      { 0, 0, NULL, 0, NULL, NULL }
  };
  static TpDBusPropertiesMixinIfaceInfo interface =
      { 0, properties, NULL, NULL };

  dbus_g_object_type_install_info (gabble_svc_channel_future_get_type (),
      &_gabble_svc_channel_future_object_info);

  interface.dbus_interface = g_quark_from_static_string ("org.freedesktop.Telepathy.Channel.FUTURE");
  properties[0].name = g_quark_from_static_string ("Bundle");
  properties[0].type = DBUS_TYPE_G_OBJECT_PATH;
  tp_svc_interface_set_dbus_properties_info (GABBLE_TYPE_SVC_CHANNEL_FUTURE, &interface);

}
static void
gabble_svc_channel_future_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      gabble_svc_channel_future_base_init_once (klass);
    }
}
static const DBusGMethodInfo _gabble_svc_channel_future_methods[] = {
  { NULL, NULL, 0 }
};

static const DBusGObjectInfo _gabble_svc_channel_future_object_info = {
  0,
  _gabble_svc_channel_future_methods,
  0,
"\0",
"\0\0",
"\0\0",
};

static const DBusGObjectInfo _gabble_svc_channel_interface_sasl_authentication_object_info;

struct _GabbleSvcChannelInterfaceSaslAuthenticationClass {
    GTypeInterface parent_class;
    gabble_svc_channel_interface_sasl_authentication_start_mechanism_impl start_mechanism_cb;
    gabble_svc_channel_interface_sasl_authentication_respond_impl respond_cb;
    gabble_svc_channel_interface_sasl_authentication_accept_impl accept_cb;
    gabble_svc_channel_interface_sasl_authentication_abort_impl abort_cb;
};

enum {
    SIGNAL_CHANNEL_INTERFACE_SASL_AUTHENTICATION_StateChanged,
    SIGNAL_CHANNEL_INTERFACE_SASL_AUTHENTICATION_NewChallenge,
    N_CHANNEL_INTERFACE_SASL_AUTHENTICATION_SIGNALS
};
static guint channel_interface_sasl_authentication_signals[N_CHANNEL_INTERFACE_SASL_AUTHENTICATION_SIGNALS] = {0};

static void gabble_svc_channel_interface_sasl_authentication_base_init (gpointer klass);

GType
gabble_svc_channel_interface_sasl_authentication_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (GabbleSvcChannelInterfaceSaslAuthenticationClass),
        gabble_svc_channel_interface_sasl_authentication_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "GabbleSvcChannelInterfaceSaslAuthentication", &info, 0);
    }

  return type;
}

/**
 * gabble_svc_channel_interface_sasl_authentication_start_mechanism_impl:
 * @self: The object implementing this interface
 * @in_Mechanism: const gchar * (FIXME, generate documentation)
 * @in_InitialData: const GArray * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * StartMechanism on interface org.freedesktop.Telepathy.Channel.Interface.SaslAuthentication.DRAFT.
 */
static void
gabble_svc_channel_interface_sasl_authentication_start_mechanism (GabbleSvcChannelInterfaceSaslAuthentication *self,
    const gchar *in_Mechanism,
    const GArray *in_InitialData,
    DBusGMethodInvocation *context)
{
  gabble_svc_channel_interface_sasl_authentication_start_mechanism_impl impl = (GABBLE_SVC_CHANNEL_INTERFACE_SASL_AUTHENTICATION_GET_CLASS (self)->start_mechanism_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_Mechanism,
        in_InitialData,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * gabble_svc_channel_interface_sasl_authentication_implement_start_mechanism:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the StartMechanism D-Bus method
 *
 * Register an implementation for the StartMechanism method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
gabble_svc_channel_interface_sasl_authentication_implement_start_mechanism (GabbleSvcChannelInterfaceSaslAuthenticationClass *klass, gabble_svc_channel_interface_sasl_authentication_start_mechanism_impl impl)
{
  klass->start_mechanism_cb = impl;
}

/**
 * gabble_svc_channel_interface_sasl_authentication_respond_impl:
 * @self: The object implementing this interface
 * @in_Response_Data: const GArray * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * Respond on interface org.freedesktop.Telepathy.Channel.Interface.SaslAuthentication.DRAFT.
 */
static void
gabble_svc_channel_interface_sasl_authentication_respond (GabbleSvcChannelInterfaceSaslAuthentication *self,
    const GArray *in_Response_Data,
    DBusGMethodInvocation *context)
{
  gabble_svc_channel_interface_sasl_authentication_respond_impl impl = (GABBLE_SVC_CHANNEL_INTERFACE_SASL_AUTHENTICATION_GET_CLASS (self)->respond_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_Response_Data,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * gabble_svc_channel_interface_sasl_authentication_implement_respond:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the Respond D-Bus method
 *
 * Register an implementation for the Respond method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
gabble_svc_channel_interface_sasl_authentication_implement_respond (GabbleSvcChannelInterfaceSaslAuthenticationClass *klass, gabble_svc_channel_interface_sasl_authentication_respond_impl impl)
{
  klass->respond_cb = impl;
}

/**
 * gabble_svc_channel_interface_sasl_authentication_accept_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * Accept on interface org.freedesktop.Telepathy.Channel.Interface.SaslAuthentication.DRAFT.
 */
static void
gabble_svc_channel_interface_sasl_authentication_accept (GabbleSvcChannelInterfaceSaslAuthentication *self,
    DBusGMethodInvocation *context)
{
  gabble_svc_channel_interface_sasl_authentication_accept_impl impl = (GABBLE_SVC_CHANNEL_INTERFACE_SASL_AUTHENTICATION_GET_CLASS (self)->accept_cb);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * gabble_svc_channel_interface_sasl_authentication_implement_accept:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the Accept D-Bus method
 *
 * Register an implementation for the Accept method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
gabble_svc_channel_interface_sasl_authentication_implement_accept (GabbleSvcChannelInterfaceSaslAuthenticationClass *klass, gabble_svc_channel_interface_sasl_authentication_accept_impl impl)
{
  klass->accept_cb = impl;
}

/**
 * gabble_svc_channel_interface_sasl_authentication_abort_impl:
 * @self: The object implementing this interface
 * @in_Reason: guint  (FIXME, generate documentation)
 * @in_Debug_Message: const gchar * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * Abort on interface org.freedesktop.Telepathy.Channel.Interface.SaslAuthentication.DRAFT.
 */
static void
gabble_svc_channel_interface_sasl_authentication_abort (GabbleSvcChannelInterfaceSaslAuthentication *self,
    guint in_Reason,
    const gchar *in_Debug_Message,
    DBusGMethodInvocation *context)
{
  gabble_svc_channel_interface_sasl_authentication_abort_impl impl = (GABBLE_SVC_CHANNEL_INTERFACE_SASL_AUTHENTICATION_GET_CLASS (self)->abort_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_Reason,
        in_Debug_Message,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * gabble_svc_channel_interface_sasl_authentication_implement_abort:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the Abort D-Bus method
 *
 * Register an implementation for the Abort method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
gabble_svc_channel_interface_sasl_authentication_implement_abort (GabbleSvcChannelInterfaceSaslAuthenticationClass *klass, gabble_svc_channel_interface_sasl_authentication_abort_impl impl)
{
  klass->abort_cb = impl;
}

/**
 * gabble_svc_channel_interface_sasl_authentication_emit_state_changed:
 * @instance: The object implementing this interface
 * @arg_Status: guint  (FIXME, generate documentation)
 * @arg_Reason: const gchar * (FIXME, generate documentation)
 * @arg_DebugMessage: const gchar * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * StateChanged signal on interface org.freedesktop.Telepathy.Channel.Interface.SaslAuthentication.DRAFT.
 */
void
gabble_svc_channel_interface_sasl_authentication_emit_state_changed (gpointer instance,
    guint arg_Status,
    const gchar *arg_Reason,
    const gchar *arg_DebugMessage)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, GABBLE_TYPE_SVC_CHANNEL_INTERFACE_SASL_AUTHENTICATION));
  g_signal_emit (instance,
      channel_interface_sasl_authentication_signals[SIGNAL_CHANNEL_INTERFACE_SASL_AUTHENTICATION_StateChanged],
      0,
      arg_Status,
      arg_Reason,
      arg_DebugMessage);
}

/**
 * gabble_svc_channel_interface_sasl_authentication_emit_new_challenge:
 * @instance: The object implementing this interface
 * @arg_ChallengeData: const GArray * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * NewChallenge signal on interface org.freedesktop.Telepathy.Channel.Interface.SaslAuthentication.DRAFT.
 */
void
gabble_svc_channel_interface_sasl_authentication_emit_new_challenge (gpointer instance,
    const GArray *arg_ChallengeData)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, GABBLE_TYPE_SVC_CHANNEL_INTERFACE_SASL_AUTHENTICATION));
  g_signal_emit (instance,
      channel_interface_sasl_authentication_signals[SIGNAL_CHANNEL_INTERFACE_SASL_AUTHENTICATION_NewChallenge],
      0,
      arg_ChallengeData);
}

static inline void
gabble_svc_channel_interface_sasl_authentication_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  static TpDBusPropertiesMixinPropInfo properties[5] = {
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "as", 0, NULL, NULL }, /* AvailableMechanisms */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "b", 0, NULL, NULL }, /* Secure */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "ay", 0, NULL, NULL }, /* CurrentChallenge */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "(uss)", 0, NULL, NULL }, /* CurrentState */
      { 0, 0, NULL, 0, NULL, NULL }
  };
  static TpDBusPropertiesMixinIfaceInfo interface =
      { 0, properties, NULL, NULL };

  dbus_g_object_type_install_info (gabble_svc_channel_interface_sasl_authentication_get_type (),
      &_gabble_svc_channel_interface_sasl_authentication_object_info);

  interface.dbus_interface = g_quark_from_static_string ("org.freedesktop.Telepathy.Channel.Interface.SaslAuthentication.DRAFT");
  properties[0].name = g_quark_from_static_string ("AvailableMechanisms");
  properties[0].type = G_TYPE_STRV;
  properties[1].name = g_quark_from_static_string ("Secure");
  properties[1].type = G_TYPE_BOOLEAN;
  properties[2].name = g_quark_from_static_string ("CurrentChallenge");
  properties[2].type = dbus_g_type_get_collection ("GArray", G_TYPE_UCHAR);
  properties[3].name = g_quark_from_static_string ("CurrentState");
  properties[3].type = (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_INVALID));
  tp_svc_interface_set_dbus_properties_info (GABBLE_TYPE_SVC_CHANNEL_INTERFACE_SASL_AUTHENTICATION, &interface);

  /**
   * GabbleSvcChannelInterfaceSaslAuthentication::state-changed:
   * @arg_Status: guint  (FIXME, generate documentation)
   * @arg_Reason: const gchar * (FIXME, generate documentation)
   * @arg_DebugMessage: const gchar * (FIXME, generate documentation)
   *
   * The StateChanged D-Bus signal is emitted whenever this GObject signal is.
   */
  channel_interface_sasl_authentication_signals[SIGNAL_CHANNEL_INTERFACE_SASL_AUTHENTICATION_StateChanged] =
  g_signal_new ("state-changed",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      _gabble_ext_marshal_VOID__UINT_STRING_STRING,
      G_TYPE_NONE,
      3,
      G_TYPE_UINT,
      G_TYPE_STRING,
      G_TYPE_STRING);

  /**
   * GabbleSvcChannelInterfaceSaslAuthentication::new-challenge:
   * @arg_ChallengeData: const GArray * (FIXME, generate documentation)
   *
   * The NewChallenge D-Bus signal is emitted whenever this GObject signal is.
   */
  channel_interface_sasl_authentication_signals[SIGNAL_CHANNEL_INTERFACE_SASL_AUTHENTICATION_NewChallenge] =
  g_signal_new ("new-challenge",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      g_cclosure_marshal_VOID__BOXED,
      G_TYPE_NONE,
      1,
      dbus_g_type_get_collection ("GArray", G_TYPE_UCHAR));

}
static void
gabble_svc_channel_interface_sasl_authentication_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      gabble_svc_channel_interface_sasl_authentication_base_init_once (klass);
    }
}
static const DBusGMethodInfo _gabble_svc_channel_interface_sasl_authentication_methods[] = {
  { (GCallback) gabble_svc_channel_interface_sasl_authentication_start_mechanism, _gabble_ext_marshal_VOID__STRING_BOXED_POINTER, 0 },
  { (GCallback) gabble_svc_channel_interface_sasl_authentication_respond, _gabble_ext_marshal_VOID__BOXED_POINTER, 118 },
  { (GCallback) gabble_svc_channel_interface_sasl_authentication_accept, g_cclosure_marshal_VOID__POINTER, 217 },
  { (GCallback) gabble_svc_channel_interface_sasl_authentication_abort, _gabble_ext_marshal_VOID__UINT_STRING_POINTER, 296 },
};

static const DBusGObjectInfo _gabble_svc_channel_interface_sasl_authentication_object_info = {
  0,
  _gabble_svc_channel_interface_sasl_authentication_methods,
  4,
"org.freedesktop.Telepathy.Channel.Interface.SaslAuthentication.DRAFT\0StartMechanism\0A\0Mechanism\0I\0s\0InitialData\0I\0ay\0\0org.freedesktop.Telepathy.Channel.Interface.SaslAuthentication.DRAFT\0Respond\0A\0Response_Data\0I\0ay\0\0org.freedesktop.Telepathy.Channel.Interface.SaslAuthentication.DRAFT\0Accept\0A\0\0org.freedesktop.Telepathy.Channel.Interface.SaslAuthentication.DRAFT\0Abort\0A\0Reason\0I\0u\0Debug_Message\0I\0s\0\0\0",
"org.freedesktop.Telepathy.Channel.Interface.SaslAuthentication.DRAFT\0StateChanged\0org.freedesktop.Telepathy.Channel.Interface.SaslAuthentication.DRAFT\0NewChallenge\0\0",
"\0\0",
};

static const DBusGObjectInfo _gabble_svc_channel_type_call_object_info;

struct _GabbleSvcChannelTypeCallClass {
    GTypeInterface parent_class;
    gabble_svc_channel_type_call_ringing_impl ringing_cb;
    gabble_svc_channel_type_call_accept_impl accept_cb;
    gabble_svc_channel_type_call_hangup_impl hangup_cb;
    gabble_svc_channel_type_call_add_content_impl add_content_cb;
};

enum {
    SIGNAL_CHANNEL_TYPE_CALL_ContentAdded,
    SIGNAL_CHANNEL_TYPE_CALL_ContentRemoved,
    SIGNAL_CHANNEL_TYPE_CALL_CallStateChanged,
    SIGNAL_CHANNEL_TYPE_CALL_CallMembersChanged,
    N_CHANNEL_TYPE_CALL_SIGNALS
};
static guint channel_type_call_signals[N_CHANNEL_TYPE_CALL_SIGNALS] = {0};

static void gabble_svc_channel_type_call_base_init (gpointer klass);

GType
gabble_svc_channel_type_call_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (GabbleSvcChannelTypeCallClass),
        gabble_svc_channel_type_call_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "GabbleSvcChannelTypeCall", &info, 0);
    }

  return type;
}

/**
 * gabble_svc_channel_type_call_ringing_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * Ringing on interface org.freedesktop.Telepathy.Channel.Type.Call.DRAFT.
 */
static void
gabble_svc_channel_type_call_ringing (GabbleSvcChannelTypeCall *self,
    DBusGMethodInvocation *context)
{
  gabble_svc_channel_type_call_ringing_impl impl = (GABBLE_SVC_CHANNEL_TYPE_CALL_GET_CLASS (self)->ringing_cb);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * gabble_svc_channel_type_call_implement_ringing:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the Ringing D-Bus method
 *
 * Register an implementation for the Ringing method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
gabble_svc_channel_type_call_implement_ringing (GabbleSvcChannelTypeCallClass *klass, gabble_svc_channel_type_call_ringing_impl impl)
{
  klass->ringing_cb = impl;
}

/**
 * gabble_svc_channel_type_call_accept_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * Accept on interface org.freedesktop.Telepathy.Channel.Type.Call.DRAFT.
 */
static void
gabble_svc_channel_type_call_accept (GabbleSvcChannelTypeCall *self,
    DBusGMethodInvocation *context)
{
  gabble_svc_channel_type_call_accept_impl impl = (GABBLE_SVC_CHANNEL_TYPE_CALL_GET_CLASS (self)->accept_cb);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * gabble_svc_channel_type_call_implement_accept:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the Accept D-Bus method
 *
 * Register an implementation for the Accept method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
gabble_svc_channel_type_call_implement_accept (GabbleSvcChannelTypeCallClass *klass, gabble_svc_channel_type_call_accept_impl impl)
{
  klass->accept_cb = impl;
}

/**
 * gabble_svc_channel_type_call_hangup_impl:
 * @self: The object implementing this interface
 * @in_Reason: guint  (FIXME, generate documentation)
 * @in_Detailed_Hangup_Reason: const gchar * (FIXME, generate documentation)
 * @in_Message: const gchar * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * Hangup on interface org.freedesktop.Telepathy.Channel.Type.Call.DRAFT.
 */
static void
gabble_svc_channel_type_call_hangup (GabbleSvcChannelTypeCall *self,
    guint in_Reason,
    const gchar *in_Detailed_Hangup_Reason,
    const gchar *in_Message,
    DBusGMethodInvocation *context)
{
  gabble_svc_channel_type_call_hangup_impl impl = (GABBLE_SVC_CHANNEL_TYPE_CALL_GET_CLASS (self)->hangup_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_Reason,
        in_Detailed_Hangup_Reason,
        in_Message,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * gabble_svc_channel_type_call_implement_hangup:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the Hangup D-Bus method
 *
 * Register an implementation for the Hangup method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
gabble_svc_channel_type_call_implement_hangup (GabbleSvcChannelTypeCallClass *klass, gabble_svc_channel_type_call_hangup_impl impl)
{
  klass->hangup_cb = impl;
}

/**
 * gabble_svc_channel_type_call_add_content_impl:
 * @self: The object implementing this interface
 * @in_Content_Name: const gchar * (FIXME, generate documentation)
 * @in_Content_Type: guint  (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * AddContent on interface org.freedesktop.Telepathy.Channel.Type.Call.DRAFT.
 */
static void
gabble_svc_channel_type_call_add_content (GabbleSvcChannelTypeCall *self,
    const gchar *in_Content_Name,
    guint in_Content_Type,
    DBusGMethodInvocation *context)
{
  gabble_svc_channel_type_call_add_content_impl impl = (GABBLE_SVC_CHANNEL_TYPE_CALL_GET_CLASS (self)->add_content_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_Content_Name,
        in_Content_Type,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * gabble_svc_channel_type_call_implement_add_content:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the AddContent D-Bus method
 *
 * Register an implementation for the AddContent method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
gabble_svc_channel_type_call_implement_add_content (GabbleSvcChannelTypeCallClass *klass, gabble_svc_channel_type_call_add_content_impl impl)
{
  klass->add_content_cb = impl;
}

/**
 * gabble_svc_channel_type_call_emit_content_added:
 * @instance: The object implementing this interface
 * @arg_Content: const gchar * (FIXME, generate documentation)
 * @arg_Content_Type: guint  (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * ContentAdded signal on interface org.freedesktop.Telepathy.Channel.Type.Call.DRAFT.
 */
void
gabble_svc_channel_type_call_emit_content_added (gpointer instance,
    const gchar *arg_Content,
    guint arg_Content_Type)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, GABBLE_TYPE_SVC_CHANNEL_TYPE_CALL));
  g_signal_emit (instance,
      channel_type_call_signals[SIGNAL_CHANNEL_TYPE_CALL_ContentAdded],
      0,
      arg_Content,
      arg_Content_Type);
}

/**
 * gabble_svc_channel_type_call_emit_content_removed:
 * @instance: The object implementing this interface
 * @arg_Content: const gchar * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * ContentRemoved signal on interface org.freedesktop.Telepathy.Channel.Type.Call.DRAFT.
 */
void
gabble_svc_channel_type_call_emit_content_removed (gpointer instance,
    const gchar *arg_Content)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, GABBLE_TYPE_SVC_CHANNEL_TYPE_CALL));
  g_signal_emit (instance,
      channel_type_call_signals[SIGNAL_CHANNEL_TYPE_CALL_ContentRemoved],
      0,
      arg_Content);
}

/**
 * gabble_svc_channel_type_call_emit_call_state_changed:
 * @instance: The object implementing this interface
 * @arg_Call_State: guint  (FIXME, generate documentation)
 * @arg_Call_Flags: guint  (FIXME, generate documentation)
 * @arg_Call_State_Reason: const GValueArray * (FIXME, generate documentation)
 * @arg_Call_State_Details: GHashTable * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * CallStateChanged signal on interface org.freedesktop.Telepathy.Channel.Type.Call.DRAFT.
 */
void
gabble_svc_channel_type_call_emit_call_state_changed (gpointer instance,
    guint arg_Call_State,
    guint arg_Call_Flags,
    const GValueArray *arg_Call_State_Reason,
    GHashTable *arg_Call_State_Details)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, GABBLE_TYPE_SVC_CHANNEL_TYPE_CALL));
  g_signal_emit (instance,
      channel_type_call_signals[SIGNAL_CHANNEL_TYPE_CALL_CallStateChanged],
      0,
      arg_Call_State,
      arg_Call_Flags,
      arg_Call_State_Reason,
      arg_Call_State_Details);
}

/**
 * gabble_svc_channel_type_call_emit_call_members_changed:
 * @instance: The object implementing this interface
 * @arg_Flags_Changed: GHashTable * (FIXME, generate documentation)
 * @arg_Removed: const GArray * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * CallMembersChanged signal on interface org.freedesktop.Telepathy.Channel.Type.Call.DRAFT.
 */
void
gabble_svc_channel_type_call_emit_call_members_changed (gpointer instance,
    GHashTable *arg_Flags_Changed,
    const GArray *arg_Removed)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, GABBLE_TYPE_SVC_CHANNEL_TYPE_CALL));
  g_signal_emit (instance,
      channel_type_call_signals[SIGNAL_CHANNEL_TYPE_CALL_CallMembersChanged],
      0,
      arg_Flags_Changed,
      arg_Removed);
}

static inline void
gabble_svc_channel_type_call_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  static TpDBusPropertiesMixinPropInfo properties[12] = {
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "ao", 0, NULL, NULL }, /* Contents */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "a{sv}", 0, NULL, NULL }, /* CallStateDetails */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "u", 0, NULL, NULL }, /* CallState */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "u", 0, NULL, NULL }, /* CallFlags */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "(uus)", 0, NULL, NULL }, /* CallStateReason */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "b", 0, NULL, NULL }, /* HardwareStreaming */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "a{uu}", 0, NULL, NULL }, /* CallMembers */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "s", 0, NULL, NULL }, /* InitialTransport */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "b", 0, NULL, NULL }, /* InitialAudio */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "b", 0, NULL, NULL }, /* InitialVideo */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "b", 0, NULL, NULL }, /* MutableContents */
      { 0, 0, NULL, 0, NULL, NULL }
  };
  static TpDBusPropertiesMixinIfaceInfo interface =
      { 0, properties, NULL, NULL };

  dbus_g_object_type_install_info (gabble_svc_channel_type_call_get_type (),
      &_gabble_svc_channel_type_call_object_info);

  interface.dbus_interface = g_quark_from_static_string ("org.freedesktop.Telepathy.Channel.Type.Call.DRAFT");
  properties[0].name = g_quark_from_static_string ("Contents");
  properties[0].type = dbus_g_type_get_collection ("GPtrArray", DBUS_TYPE_G_OBJECT_PATH);
  properties[1].name = g_quark_from_static_string ("CallStateDetails");
  properties[1].type = (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE));
  properties[2].name = g_quark_from_static_string ("CallState");
  properties[2].type = G_TYPE_UINT;
  properties[3].name = g_quark_from_static_string ("CallFlags");
  properties[3].type = G_TYPE_UINT;
  properties[4].name = g_quark_from_static_string ("CallStateReason");
  properties[4].type = (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_INVALID));
  properties[5].name = g_quark_from_static_string ("HardwareStreaming");
  properties[5].type = G_TYPE_BOOLEAN;
  properties[6].name = g_quark_from_static_string ("CallMembers");
  properties[6].type = (dbus_g_type_get_map ("GHashTable", G_TYPE_UINT, G_TYPE_UINT));
  properties[7].name = g_quark_from_static_string ("InitialTransport");
  properties[7].type = G_TYPE_STRING;
  properties[8].name = g_quark_from_static_string ("InitialAudio");
  properties[8].type = G_TYPE_BOOLEAN;
  properties[9].name = g_quark_from_static_string ("InitialVideo");
  properties[9].type = G_TYPE_BOOLEAN;
  properties[10].name = g_quark_from_static_string ("MutableContents");
  properties[10].type = G_TYPE_BOOLEAN;
  tp_svc_interface_set_dbus_properties_info (GABBLE_TYPE_SVC_CHANNEL_TYPE_CALL, &interface);

  /**
   * GabbleSvcChannelTypeCall::content-added:
   * @arg_Content: const gchar * (FIXME, generate documentation)
   * @arg_Content_Type: guint  (FIXME, generate documentation)
   *
   * The ContentAdded D-Bus signal is emitted whenever this GObject signal is.
   */
  channel_type_call_signals[SIGNAL_CHANNEL_TYPE_CALL_ContentAdded] =
  g_signal_new ("content-added",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      _gabble_ext_marshal_VOID__BOXED_UINT,
      G_TYPE_NONE,
      2,
      DBUS_TYPE_G_OBJECT_PATH,
      G_TYPE_UINT);

  /**
   * GabbleSvcChannelTypeCall::content-removed:
   * @arg_Content: const gchar * (FIXME, generate documentation)
   *
   * The ContentRemoved D-Bus signal is emitted whenever this GObject signal is.
   */
  channel_type_call_signals[SIGNAL_CHANNEL_TYPE_CALL_ContentRemoved] =
  g_signal_new ("content-removed",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      g_cclosure_marshal_VOID__BOXED,
      G_TYPE_NONE,
      1,
      DBUS_TYPE_G_OBJECT_PATH);

  /**
   * GabbleSvcChannelTypeCall::call-state-changed:
   * @arg_Call_State: guint  (FIXME, generate documentation)
   * @arg_Call_Flags: guint  (FIXME, generate documentation)
   * @arg_Call_State_Reason: const GValueArray * (FIXME, generate documentation)
   * @arg_Call_State_Details: GHashTable * (FIXME, generate documentation)
   *
   * The CallStateChanged D-Bus signal is emitted whenever this GObject signal is.
   */
  channel_type_call_signals[SIGNAL_CHANNEL_TYPE_CALL_CallStateChanged] =
  g_signal_new ("call-state-changed",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      _gabble_ext_marshal_VOID__UINT_UINT_BOXED_BOXED,
      G_TYPE_NONE,
      4,
      G_TYPE_UINT,
      G_TYPE_UINT,
      (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_INVALID)),
      (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)));

  /**
   * GabbleSvcChannelTypeCall::call-members-changed:
   * @arg_Flags_Changed: GHashTable * (FIXME, generate documentation)
   * @arg_Removed: const GArray * (FIXME, generate documentation)
   *
   * The CallMembersChanged D-Bus signal is emitted whenever this GObject signal is.
   */
  channel_type_call_signals[SIGNAL_CHANNEL_TYPE_CALL_CallMembersChanged] =
  g_signal_new ("call-members-changed",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      _gabble_ext_marshal_VOID__BOXED_BOXED,
      G_TYPE_NONE,
      2,
      (dbus_g_type_get_map ("GHashTable", G_TYPE_UINT, G_TYPE_UINT)),
      DBUS_TYPE_G_UINT_ARRAY);

}
static void
gabble_svc_channel_type_call_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      gabble_svc_channel_type_call_base_init_once (klass);
    }
}
static const DBusGMethodInfo _gabble_svc_channel_type_call_methods[] = {
  { (GCallback) gabble_svc_channel_type_call_ringing, g_cclosure_marshal_VOID__POINTER, 0 },
  { (GCallback) gabble_svc_channel_type_call_accept, g_cclosure_marshal_VOID__POINTER, 61 },
  { (GCallback) gabble_svc_channel_type_call_hangup, _gabble_ext_marshal_VOID__UINT_STRING_STRING_POINTER, 121 },
  { (GCallback) gabble_svc_channel_type_call_add_content, _gabble_ext_marshal_VOID__STRING_UINT_POINTER, 231 },
};

static const DBusGObjectInfo _gabble_svc_channel_type_call_object_info = {
  0,
  _gabble_svc_channel_type_call_methods,
  4,
"org.freedesktop.Telepathy.Channel.Type.Call.DRAFT\0Ringing\0A\0\0org.freedesktop.Telepathy.Channel.Type.Call.DRAFT\0Accept\0A\0\0org.freedesktop.Telepathy.Channel.Type.Call.DRAFT\0Hangup\0A\0Reason\0I\0u\0Detailed_Hangup_Reason\0I\0s\0Message\0I\0s\0\0org.freedesktop.Telepathy.Channel.Type.Call.DRAFT\0AddContent\0A\0Content_Name\0I\0s\0Content_Type\0I\0u\0Content\0O\0F\0N\0o\0\0\0",
"org.freedesktop.Telepathy.Channel.Type.Call.DRAFT\0ContentAdded\0org.freedesktop.Telepathy.Channel.Type.Call.DRAFT\0ContentRemoved\0org.freedesktop.Telepathy.Channel.Type.Call.DRAFT\0CallStateChanged\0org.freedesktop.Telepathy.Channel.Type.Call.DRAFT\0CallMembersChanged\0\0",
"\0\0",
};

static const DBusGObjectInfo _gabble_svc_channel_type_filetransfer_future_object_info;

struct _GabbleSvcChannelTypeFileTransferFutureClass {
    GTypeInterface parent_class;
};

static void gabble_svc_channel_type_filetransfer_future_base_init (gpointer klass);

GType
gabble_svc_channel_type_filetransfer_future_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (GabbleSvcChannelTypeFileTransferFutureClass),
        gabble_svc_channel_type_filetransfer_future_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "GabbleSvcChannelTypeFileTransferFuture", &info, 0);
    }

  return type;
}

static inline void
gabble_svc_channel_type_filetransfer_future_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  static TpDBusPropertiesMixinPropInfo properties[2] = {
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "s", 0, NULL, NULL }, /* FileCollection */
      { 0, 0, NULL, 0, NULL, NULL }
  };
  static TpDBusPropertiesMixinIfaceInfo interface =
      { 0, properties, NULL, NULL };

  dbus_g_object_type_install_info (gabble_svc_channel_type_filetransfer_future_get_type (),
      &_gabble_svc_channel_type_filetransfer_future_object_info);

  interface.dbus_interface = g_quark_from_static_string ("org.freedesktop.Telepathy.Channel.Type.FileTransfer.FUTURE");
  properties[0].name = g_quark_from_static_string ("FileCollection");
  properties[0].type = G_TYPE_STRING;
  tp_svc_interface_set_dbus_properties_info (GABBLE_TYPE_SVC_CHANNEL_TYPE_FILETRANSFER_FUTURE, &interface);

}
static void
gabble_svc_channel_type_filetransfer_future_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      gabble_svc_channel_type_filetransfer_future_base_init_once (klass);
    }
}
static const DBusGMethodInfo _gabble_svc_channel_type_filetransfer_future_methods[] = {
  { NULL, NULL, 0 }
};

static const DBusGObjectInfo _gabble_svc_channel_type_filetransfer_future_object_info = {
  0,
  _gabble_svc_channel_type_filetransfer_future_methods,
  0,
"\0",
"\0\0",
"\0\0",
};

static const DBusGObjectInfo _gabble_svc_channel_type_server_authentication_object_info;

struct _GabbleSvcChannelTypeServerAuthenticationClass {
    GTypeInterface parent_class;
};

static void gabble_svc_channel_type_server_authentication_base_init (gpointer klass);

GType
gabble_svc_channel_type_server_authentication_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (GabbleSvcChannelTypeServerAuthenticationClass),
        gabble_svc_channel_type_server_authentication_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "GabbleSvcChannelTypeServerAuthentication", &info, 0);
    }

  return type;
}

static inline void
gabble_svc_channel_type_server_authentication_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  static TpDBusPropertiesMixinPropInfo properties[3] = {
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "a{sv}", 0, NULL, NULL }, /* AuthenticationInformation */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "u", 0, NULL, NULL }, /* AuthenticationMethod */
      { 0, 0, NULL, 0, NULL, NULL }
  };
  static TpDBusPropertiesMixinIfaceInfo interface =
      { 0, properties, NULL, NULL };

  dbus_g_object_type_install_info (gabble_svc_channel_type_server_authentication_get_type (),
      &_gabble_svc_channel_type_server_authentication_object_info);

  interface.dbus_interface = g_quark_from_static_string ("org.freedesktop.Telepathy.Channel.Type.ServerAuthentication.DRAFT");
  properties[0].name = g_quark_from_static_string ("AuthenticationInformation");
  properties[0].type = (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE));
  properties[1].name = g_quark_from_static_string ("AuthenticationMethod");
  properties[1].type = G_TYPE_UINT;
  tp_svc_interface_set_dbus_properties_info (GABBLE_TYPE_SVC_CHANNEL_TYPE_SERVER_AUTHENTICATION, &interface);

}
static void
gabble_svc_channel_type_server_authentication_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      gabble_svc_channel_type_server_authentication_base_init_once (klass);
    }
}
static const DBusGMethodInfo _gabble_svc_channel_type_server_authentication_methods[] = {
  { NULL, NULL, 0 }
};

static const DBusGObjectInfo _gabble_svc_channel_type_server_authentication_object_info = {
  0,
  _gabble_svc_channel_type_server_authentication_methods,
  0,
"\0",
"\0\0",
"\0\0",
};

static const DBusGObjectInfo _gabble_svc_connection_future_object_info;

struct _GabbleSvcConnectionFUTUREClass {
    GTypeInterface parent_class;
    gabble_svc_connection_future_ensure_sidecar_impl ensure_sidecar_cb;
};

static void gabble_svc_connection_future_base_init (gpointer klass);

GType
gabble_svc_connection_future_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (GabbleSvcConnectionFUTUREClass),
        gabble_svc_connection_future_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "GabbleSvcConnectionFUTURE", &info, 0);
    }

  return type;
}

/**
 * gabble_svc_connection_future_ensure_sidecar_impl:
 * @self: The object implementing this interface
 * @in_Main_Interface: const gchar * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * EnsureSidecar on interface org.freedesktop.Telepathy.Connection.FUTURE.
 */
static void
gabble_svc_connection_future_ensure_sidecar (GabbleSvcConnectionFUTURE *self,
    const gchar *in_Main_Interface,
    DBusGMethodInvocation *context)
{
  gabble_svc_connection_future_ensure_sidecar_impl impl = (GABBLE_SVC_CONNECTION_FUTURE_GET_CLASS (self)->ensure_sidecar_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_Main_Interface,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * gabble_svc_connection_future_implement_ensure_sidecar:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the EnsureSidecar D-Bus method
 *
 * Register an implementation for the EnsureSidecar method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
gabble_svc_connection_future_implement_ensure_sidecar (GabbleSvcConnectionFUTUREClass *klass, gabble_svc_connection_future_ensure_sidecar_impl impl)
{
  klass->ensure_sidecar_cb = impl;
}

static inline void
gabble_svc_connection_future_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  dbus_g_object_type_install_info (gabble_svc_connection_future_get_type (),
      &_gabble_svc_connection_future_object_info);

}
static void
gabble_svc_connection_future_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      gabble_svc_connection_future_base_init_once (klass);
    }
}
static const DBusGMethodInfo _gabble_svc_connection_future_methods[] = {
  { (GCallback) gabble_svc_connection_future_ensure_sidecar, _gabble_ext_marshal_VOID__STRING_POINTER, 0 },
};

static const DBusGObjectInfo _gabble_svc_connection_future_object_info = {
  0,
  _gabble_svc_connection_future_methods,
  1,
"org.freedesktop.Telepathy.Connection.FUTURE\0EnsureSidecar\0A\0Main_Interface\0I\0s\0Path\0O\0F\0N\0o\0Properties\0O\0F\0N\0a{sv}\0\0\0",
"\0\0",
"\0\0",
};

static const DBusGObjectInfo _gabble_svc_connection_interface_gabble_decloak_object_info;

struct _GabbleSvcConnectionInterfaceGabbleDecloakClass {
    GTypeInterface parent_class;
    gabble_svc_connection_interface_gabble_decloak_send_directed_presence_impl send_directed_presence_cb;
};

enum {
    SIGNAL_CONNECTION_INTERFACE_GABBLE_DECLOAK_DecloakRequested,
    N_CONNECTION_INTERFACE_GABBLE_DECLOAK_SIGNALS
};
static guint connection_interface_gabble_decloak_signals[N_CONNECTION_INTERFACE_GABBLE_DECLOAK_SIGNALS] = {0};

static void gabble_svc_connection_interface_gabble_decloak_base_init (gpointer klass);

GType
gabble_svc_connection_interface_gabble_decloak_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (GabbleSvcConnectionInterfaceGabbleDecloakClass),
        gabble_svc_connection_interface_gabble_decloak_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "GabbleSvcConnectionInterfaceGabbleDecloak", &info, 0);
    }

  return type;
}

/**
 * gabble_svc_connection_interface_gabble_decloak_send_directed_presence_impl:
 * @self: The object implementing this interface
 * @in_Contact: guint  (FIXME, generate documentation)
 * @in_Full: gboolean  (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * SendDirectedPresence on interface org.freedesktop.Telepathy.Connection.Interface.Gabble.Decloak.
 */
static void
gabble_svc_connection_interface_gabble_decloak_send_directed_presence (GabbleSvcConnectionInterfaceGabbleDecloak *self,
    guint in_Contact,
    gboolean in_Full,
    DBusGMethodInvocation *context)
{
  gabble_svc_connection_interface_gabble_decloak_send_directed_presence_impl impl = (GABBLE_SVC_CONNECTION_INTERFACE_GABBLE_DECLOAK_GET_CLASS (self)->send_directed_presence_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_Contact,
        in_Full,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * gabble_svc_connection_interface_gabble_decloak_implement_send_directed_presence:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the SendDirectedPresence D-Bus method
 *
 * Register an implementation for the SendDirectedPresence method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
gabble_svc_connection_interface_gabble_decloak_implement_send_directed_presence (GabbleSvcConnectionInterfaceGabbleDecloakClass *klass, gabble_svc_connection_interface_gabble_decloak_send_directed_presence_impl impl)
{
  klass->send_directed_presence_cb = impl;
}

/**
 * gabble_svc_connection_interface_gabble_decloak_emit_decloak_requested:
 * @instance: The object implementing this interface
 * @arg_Contact: guint  (FIXME, generate documentation)
 * @arg_Reason: const gchar * (FIXME, generate documentation)
 * @arg_Decloaked: gboolean  (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * DecloakRequested signal on interface org.freedesktop.Telepathy.Connection.Interface.Gabble.Decloak.
 */
void
gabble_svc_connection_interface_gabble_decloak_emit_decloak_requested (gpointer instance,
    guint arg_Contact,
    const gchar *arg_Reason,
    gboolean arg_Decloaked)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, GABBLE_TYPE_SVC_CONNECTION_INTERFACE_GABBLE_DECLOAK));
  g_signal_emit (instance,
      connection_interface_gabble_decloak_signals[SIGNAL_CONNECTION_INTERFACE_GABBLE_DECLOAK_DecloakRequested],
      0,
      arg_Contact,
      arg_Reason,
      arg_Decloaked);
}

static inline void
gabble_svc_connection_interface_gabble_decloak_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  static TpDBusPropertiesMixinPropInfo properties[2] = {
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ | TP_DBUS_PROPERTIES_MIXIN_FLAG_WRITE, "b", 0, NULL, NULL }, /* DecloakAutomatically */
      { 0, 0, NULL, 0, NULL, NULL }
  };
  static TpDBusPropertiesMixinIfaceInfo interface =
      { 0, properties, NULL, NULL };

  dbus_g_object_type_install_info (gabble_svc_connection_interface_gabble_decloak_get_type (),
      &_gabble_svc_connection_interface_gabble_decloak_object_info);

  interface.dbus_interface = g_quark_from_static_string ("org.freedesktop.Telepathy.Connection.Interface.Gabble.Decloak");
  properties[0].name = g_quark_from_static_string ("DecloakAutomatically");
  properties[0].type = G_TYPE_BOOLEAN;
  tp_svc_interface_set_dbus_properties_info (GABBLE_TYPE_SVC_CONNECTION_INTERFACE_GABBLE_DECLOAK, &interface);

  /**
   * GabbleSvcConnectionInterfaceGabbleDecloak::decloak-requested:
   * @arg_Contact: guint  (FIXME, generate documentation)
   * @arg_Reason: const gchar * (FIXME, generate documentation)
   * @arg_Decloaked: gboolean  (FIXME, generate documentation)
   *
   * The DecloakRequested D-Bus signal is emitted whenever this GObject signal is.
   */
  connection_interface_gabble_decloak_signals[SIGNAL_CONNECTION_INTERFACE_GABBLE_DECLOAK_DecloakRequested] =
  g_signal_new ("decloak-requested",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      _gabble_ext_marshal_VOID__UINT_STRING_BOOLEAN,
      G_TYPE_NONE,
      3,
      G_TYPE_UINT,
      G_TYPE_STRING,
      G_TYPE_BOOLEAN);

}
static void
gabble_svc_connection_interface_gabble_decloak_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      gabble_svc_connection_interface_gabble_decloak_base_init_once (klass);
    }
}
static const DBusGMethodInfo _gabble_svc_connection_interface_gabble_decloak_methods[] = {
  { (GCallback) gabble_svc_connection_interface_gabble_decloak_send_directed_presence, _gabble_ext_marshal_VOID__UINT_BOOLEAN_POINTER, 0 },
};

static const DBusGObjectInfo _gabble_svc_connection_interface_gabble_decloak_object_info = {
  0,
  _gabble_svc_connection_interface_gabble_decloak_methods,
  1,
"org.freedesktop.Telepathy.Connection.Interface.Gabble.Decloak\0SendDirectedPresence\0A\0Contact\0I\0u\0Full\0I\0b\0\0\0",
"org.freedesktop.Telepathy.Connection.Interface.Gabble.Decloak\0DecloakRequested\0\0",
"\0\0",
};

static const DBusGObjectInfo _gabble_svc_connection_interface_mail_notification_object_info;

struct _GabbleSvcConnectionInterfaceMailNotificationClass {
    GTypeInterface parent_class;
    gabble_svc_connection_interface_mail_notification_subscribe_impl subscribe_cb;
    gabble_svc_connection_interface_mail_notification_unsubscribe_impl unsubscribe_cb;
    gabble_svc_connection_interface_mail_notification_request_inbox_url_impl request_inbox_url_cb;
    gabble_svc_connection_interface_mail_notification_request_mail_url_impl request_mail_url_cb;
};

enum {
    SIGNAL_CONNECTION_INTERFACE_MAIL_NOTIFICATION_MailsReceived,
    SIGNAL_CONNECTION_INTERFACE_MAIL_NOTIFICATION_UnreadMailsChanged,
    N_CONNECTION_INTERFACE_MAIL_NOTIFICATION_SIGNALS
};
static guint connection_interface_mail_notification_signals[N_CONNECTION_INTERFACE_MAIL_NOTIFICATION_SIGNALS] = {0};

static void gabble_svc_connection_interface_mail_notification_base_init (gpointer klass);

GType
gabble_svc_connection_interface_mail_notification_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (GabbleSvcConnectionInterfaceMailNotificationClass),
        gabble_svc_connection_interface_mail_notification_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "GabbleSvcConnectionInterfaceMailNotification", &info, 0);
    }

  return type;
}

/**
 * gabble_svc_connection_interface_mail_notification_subscribe_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * Subscribe on interface org.freedesktop.Telepathy.Connection.Interface.MailNotification.DRAFT.
 */
static void
gabble_svc_connection_interface_mail_notification_subscribe (GabbleSvcConnectionInterfaceMailNotification *self,
    DBusGMethodInvocation *context)
{
  gabble_svc_connection_interface_mail_notification_subscribe_impl impl = (GABBLE_SVC_CONNECTION_INTERFACE_MAIL_NOTIFICATION_GET_CLASS (self)->subscribe_cb);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * gabble_svc_connection_interface_mail_notification_implement_subscribe:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the Subscribe D-Bus method
 *
 * Register an implementation for the Subscribe method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
gabble_svc_connection_interface_mail_notification_implement_subscribe (GabbleSvcConnectionInterfaceMailNotificationClass *klass, gabble_svc_connection_interface_mail_notification_subscribe_impl impl)
{
  klass->subscribe_cb = impl;
}

/**
 * gabble_svc_connection_interface_mail_notification_unsubscribe_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * Unsubscribe on interface org.freedesktop.Telepathy.Connection.Interface.MailNotification.DRAFT.
 */
static void
gabble_svc_connection_interface_mail_notification_unsubscribe (GabbleSvcConnectionInterfaceMailNotification *self,
    DBusGMethodInvocation *context)
{
  gabble_svc_connection_interface_mail_notification_unsubscribe_impl impl = (GABBLE_SVC_CONNECTION_INTERFACE_MAIL_NOTIFICATION_GET_CLASS (self)->unsubscribe_cb);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * gabble_svc_connection_interface_mail_notification_implement_unsubscribe:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the Unsubscribe D-Bus method
 *
 * Register an implementation for the Unsubscribe method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
gabble_svc_connection_interface_mail_notification_implement_unsubscribe (GabbleSvcConnectionInterfaceMailNotificationClass *klass, gabble_svc_connection_interface_mail_notification_unsubscribe_impl impl)
{
  klass->unsubscribe_cb = impl;
}

/**
 * gabble_svc_connection_interface_mail_notification_request_inbox_url_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * RequestInboxURL on interface org.freedesktop.Telepathy.Connection.Interface.MailNotification.DRAFT.
 */
static void
gabble_svc_connection_interface_mail_notification_request_inbox_url (GabbleSvcConnectionInterfaceMailNotification *self,
    DBusGMethodInvocation *context)
{
  gabble_svc_connection_interface_mail_notification_request_inbox_url_impl impl = (GABBLE_SVC_CONNECTION_INTERFACE_MAIL_NOTIFICATION_GET_CLASS (self)->request_inbox_url_cb);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * gabble_svc_connection_interface_mail_notification_implement_request_inbox_url:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the RequestInboxURL D-Bus method
 *
 * Register an implementation for the RequestInboxURL method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
gabble_svc_connection_interface_mail_notification_implement_request_inbox_url (GabbleSvcConnectionInterfaceMailNotificationClass *klass, gabble_svc_connection_interface_mail_notification_request_inbox_url_impl impl)
{
  klass->request_inbox_url_cb = impl;
}

/**
 * gabble_svc_connection_interface_mail_notification_request_mail_url_impl:
 * @self: The object implementing this interface
 * @in_ID: const gchar * (FIXME, generate documentation)
 * @in_URL_Data: const GValue * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * RequestMailURL on interface org.freedesktop.Telepathy.Connection.Interface.MailNotification.DRAFT.
 */
static void
gabble_svc_connection_interface_mail_notification_request_mail_url (GabbleSvcConnectionInterfaceMailNotification *self,
    const gchar *in_ID,
    const GValue *in_URL_Data,
    DBusGMethodInvocation *context)
{
  gabble_svc_connection_interface_mail_notification_request_mail_url_impl impl = (GABBLE_SVC_CONNECTION_INTERFACE_MAIL_NOTIFICATION_GET_CLASS (self)->request_mail_url_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_ID,
        in_URL_Data,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * gabble_svc_connection_interface_mail_notification_implement_request_mail_url:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the RequestMailURL D-Bus method
 *
 * Register an implementation for the RequestMailURL method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
gabble_svc_connection_interface_mail_notification_implement_request_mail_url (GabbleSvcConnectionInterfaceMailNotificationClass *klass, gabble_svc_connection_interface_mail_notification_request_mail_url_impl impl)
{
  klass->request_mail_url_cb = impl;
}

/**
 * gabble_svc_connection_interface_mail_notification_emit_mails_received:
 * @instance: The object implementing this interface
 * @arg_Mails: const GPtrArray * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * MailsReceived signal on interface org.freedesktop.Telepathy.Connection.Interface.MailNotification.DRAFT.
 */
void
gabble_svc_connection_interface_mail_notification_emit_mails_received (gpointer instance,
    const GPtrArray *arg_Mails)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, GABBLE_TYPE_SVC_CONNECTION_INTERFACE_MAIL_NOTIFICATION));
  g_signal_emit (instance,
      connection_interface_mail_notification_signals[SIGNAL_CONNECTION_INTERFACE_MAIL_NOTIFICATION_MailsReceived],
      0,
      arg_Mails);
}

/**
 * gabble_svc_connection_interface_mail_notification_emit_unread_mails_changed:
 * @instance: The object implementing this interface
 * @arg_Count: guint  (FIXME, generate documentation)
 * @arg_Mails_Added: const GPtrArray * (FIXME, generate documentation)
 * @arg_Mails_Removed: const gchar ** (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * UnreadMailsChanged signal on interface org.freedesktop.Telepathy.Connection.Interface.MailNotification.DRAFT.
 */
void
gabble_svc_connection_interface_mail_notification_emit_unread_mails_changed (gpointer instance,
    guint arg_Count,
    const GPtrArray *arg_Mails_Added,
    const gchar **arg_Mails_Removed)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, GABBLE_TYPE_SVC_CONNECTION_INTERFACE_MAIL_NOTIFICATION));
  g_signal_emit (instance,
      connection_interface_mail_notification_signals[SIGNAL_CONNECTION_INTERFACE_MAIL_NOTIFICATION_UnreadMailsChanged],
      0,
      arg_Count,
      arg_Mails_Added,
      arg_Mails_Removed);
}

static inline void
gabble_svc_connection_interface_mail_notification_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  static TpDBusPropertiesMixinPropInfo properties[5] = {
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "u", 0, NULL, NULL }, /* MailNotificationFlags */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "u", 0, NULL, NULL }, /* UnreadMailCount */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "aa{sv}", 0, NULL, NULL }, /* UnreadMails */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "s", 0, NULL, NULL }, /* MailAddress */
      { 0, 0, NULL, 0, NULL, NULL }
  };
  static TpDBusPropertiesMixinIfaceInfo interface =
      { 0, properties, NULL, NULL };

  dbus_g_object_type_install_info (gabble_svc_connection_interface_mail_notification_get_type (),
      &_gabble_svc_connection_interface_mail_notification_object_info);

  interface.dbus_interface = g_quark_from_static_string ("org.freedesktop.Telepathy.Connection.Interface.MailNotification.DRAFT");
  properties[0].name = g_quark_from_static_string ("MailNotificationFlags");
  properties[0].type = G_TYPE_UINT;
  properties[1].name = g_quark_from_static_string ("UnreadMailCount");
  properties[1].type = G_TYPE_UINT;
  properties[2].name = g_quark_from_static_string ("UnreadMails");
  properties[2].type = (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE))));
  properties[3].name = g_quark_from_static_string ("MailAddress");
  properties[3].type = G_TYPE_STRING;
  tp_svc_interface_set_dbus_properties_info (GABBLE_TYPE_SVC_CONNECTION_INTERFACE_MAIL_NOTIFICATION, &interface);

  /**
   * GabbleSvcConnectionInterfaceMailNotification::mails-received:
   * @arg_Mails: const GPtrArray * (FIXME, generate documentation)
   *
   * The MailsReceived D-Bus signal is emitted whenever this GObject signal is.
   */
  connection_interface_mail_notification_signals[SIGNAL_CONNECTION_INTERFACE_MAIL_NOTIFICATION_MailsReceived] =
  g_signal_new ("mails-received",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      g_cclosure_marshal_VOID__BOXED,
      G_TYPE_NONE,
      1,
      (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)))));

  /**
   * GabbleSvcConnectionInterfaceMailNotification::unread-mails-changed:
   * @arg_Count: guint  (FIXME, generate documentation)
   * @arg_Mails_Added: const GPtrArray * (FIXME, generate documentation)
   * @arg_Mails_Removed: const gchar ** (FIXME, generate documentation)
   *
   * The UnreadMailsChanged D-Bus signal is emitted whenever this GObject signal is.
   */
  connection_interface_mail_notification_signals[SIGNAL_CONNECTION_INTERFACE_MAIL_NOTIFICATION_UnreadMailsChanged] =
  g_signal_new ("unread-mails-changed",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      _gabble_ext_marshal_VOID__UINT_BOXED_BOXED,
      G_TYPE_NONE,
      3,
      G_TYPE_UINT,
      (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)))),
      G_TYPE_STRV);

}
static void
gabble_svc_connection_interface_mail_notification_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      gabble_svc_connection_interface_mail_notification_base_init_once (klass);
    }
}
static const DBusGMethodInfo _gabble_svc_connection_interface_mail_notification_methods[] = {
  { (GCallback) gabble_svc_connection_interface_mail_notification_subscribe, g_cclosure_marshal_VOID__POINTER, 0 },
  { (GCallback) gabble_svc_connection_interface_mail_notification_unsubscribe, g_cclosure_marshal_VOID__POINTER, 83 },
  { (GCallback) gabble_svc_connection_interface_mail_notification_request_inbox_url, g_cclosure_marshal_VOID__POINTER, 168 },
  { (GCallback) gabble_svc_connection_interface_mail_notification_request_mail_url, _gabble_ext_marshal_VOID__STRING_BOXED_POINTER, 277 },
};

static const DBusGObjectInfo _gabble_svc_connection_interface_mail_notification_object_info = {
  0,
  _gabble_svc_connection_interface_mail_notification_methods,
  4,
"org.freedesktop.Telepathy.Connection.Interface.MailNotification.DRAFT\0Subscribe\0A\0\0org.freedesktop.Telepathy.Connection.Interface.MailNotification.DRAFT\0Unsubscribe\0A\0\0org.freedesktop.Telepathy.Connection.Interface.MailNotification.DRAFT\0RequestInboxURL\0A\0URL\0O\0F\0N\0(sua(ss))\0\0org.freedesktop.Telepathy.Connection.Interface.MailNotification.DRAFT\0RequestMailURL\0A\0ID\0I\0s\0URL_Data\0I\0v\0URL\0O\0F\0N\0(sua(ss))\0\0\0",
"org.freedesktop.Telepathy.Connection.Interface.MailNotification.DRAFT\0MailsReceived\0org.freedesktop.Telepathy.Connection.Interface.MailNotification.DRAFT\0UnreadMailsChanged\0\0",
"\0\0",
};

static const DBusGObjectInfo _gabble_svc_gabble_plugin_gateways_object_info;

struct _GabbleSvcGabblePluginGatewaysClass {
    GTypeInterface parent_class;
    gabble_svc_gabble_plugin_gateways_register_impl register_cb;
};

static void gabble_svc_gabble_plugin_gateways_base_init (gpointer klass);

GType
gabble_svc_gabble_plugin_gateways_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (GabbleSvcGabblePluginGatewaysClass),
        gabble_svc_gabble_plugin_gateways_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "GabbleSvcGabblePluginGateways", &info, 0);
    }

  return type;
}

/**
 * gabble_svc_gabble_plugin_gateways_register_impl:
 * @self: The object implementing this interface
 * @in_Gateway: const gchar * (FIXME, generate documentation)
 * @in_Username: const gchar * (FIXME, generate documentation)
 * @in_Password: const gchar * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * Register on interface org.freedesktop.Telepathy.Gabble.Plugin.Gateways.
 */
static void
gabble_svc_gabble_plugin_gateways_register (GabbleSvcGabblePluginGateways *self,
    const gchar *in_Gateway,
    const gchar *in_Username,
    const gchar *in_Password,
    DBusGMethodInvocation *context)
{
  gabble_svc_gabble_plugin_gateways_register_impl impl = (GABBLE_SVC_GABBLE_PLUGIN_GATEWAYS_GET_CLASS (self)->register_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_Gateway,
        in_Username,
        in_Password,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * gabble_svc_gabble_plugin_gateways_implement_register:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the Register D-Bus method
 *
 * Register an implementation for the Register method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
gabble_svc_gabble_plugin_gateways_implement_register (GabbleSvcGabblePluginGatewaysClass *klass, gabble_svc_gabble_plugin_gateways_register_impl impl)
{
  klass->register_cb = impl;
}

static inline void
gabble_svc_gabble_plugin_gateways_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  dbus_g_object_type_install_info (gabble_svc_gabble_plugin_gateways_get_type (),
      &_gabble_svc_gabble_plugin_gateways_object_info);

}
static void
gabble_svc_gabble_plugin_gateways_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      gabble_svc_gabble_plugin_gateways_base_init_once (klass);
    }
}
static const DBusGMethodInfo _gabble_svc_gabble_plugin_gateways_methods[] = {
  { (GCallback) gabble_svc_gabble_plugin_gateways_register, _gabble_ext_marshal_VOID__STRING_STRING_STRING_POINTER, 0 },
};

static const DBusGObjectInfo _gabble_svc_gabble_plugin_gateways_object_info = {
  0,
  _gabble_svc_gabble_plugin_gateways_methods,
  1,
"org.freedesktop.Telepathy.Gabble.Plugin.Gateways\0Register\0A\0Gateway\0I\0s\0Username\0I\0s\0Password\0I\0s\0\0\0",
"\0\0",
"\0\0",
};

static const DBusGObjectInfo _gabble_svc_gabble_plugin_test_object_info;

struct _GabbleSvcGabblePluginTestClass {
    GTypeInterface parent_class;
};

static void gabble_svc_gabble_plugin_test_base_init (gpointer klass);

GType
gabble_svc_gabble_plugin_test_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (GabbleSvcGabblePluginTestClass),
        gabble_svc_gabble_plugin_test_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "GabbleSvcGabblePluginTest", &info, 0);
    }

  return type;
}

static inline void
gabble_svc_gabble_plugin_test_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  dbus_g_object_type_install_info (gabble_svc_gabble_plugin_test_get_type (),
      &_gabble_svc_gabble_plugin_test_object_info);

}
static void
gabble_svc_gabble_plugin_test_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      gabble_svc_gabble_plugin_test_base_init_once (klass);
    }
}
static const DBusGMethodInfo _gabble_svc_gabble_plugin_test_methods[] = {
  { NULL, NULL, 0 }
};

static const DBusGObjectInfo _gabble_svc_gabble_plugin_test_object_info = {
  0,
  _gabble_svc_gabble_plugin_test_methods,
  0,
"\0",
"\0\0",
"\0\0",
};

static const DBusGObjectInfo _gabble_svc_olpc_activity_properties_object_info;

struct _GabbleSvcOLPCActivityPropertiesClass {
    GTypeInterface parent_class;
    gabble_svc_olpc_activity_properties_set_properties_impl set_properties_cb;
    gabble_svc_olpc_activity_properties_get_properties_impl get_properties_cb;
    gabble_svc_olpc_activity_properties_get_activity_impl get_activity_cb;
};

enum {
    SIGNAL_OLPC_ACTIVITY_PROPERTIES_ActivityPropertiesChanged,
    N_OLPC_ACTIVITY_PROPERTIES_SIGNALS
};
static guint olpc_activity_properties_signals[N_OLPC_ACTIVITY_PROPERTIES_SIGNALS] = {0};

static void gabble_svc_olpc_activity_properties_base_init (gpointer klass);

GType
gabble_svc_olpc_activity_properties_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (GabbleSvcOLPCActivityPropertiesClass),
        gabble_svc_olpc_activity_properties_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "GabbleSvcOLPCActivityProperties", &info, 0);
    }

  return type;
}

/**
 * gabble_svc_olpc_activity_properties_set_properties_impl:
 * @self: The object implementing this interface
 * @in_room: guint  (FIXME, generate documentation)
 * @in_properties: GHashTable * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * SetProperties on interface org.laptop.Telepathy.ActivityProperties.
 */
static void
gabble_svc_olpc_activity_properties_set_properties (GabbleSvcOLPCActivityProperties *self,
    guint in_room,
    GHashTable *in_properties,
    DBusGMethodInvocation *context)
{
  gabble_svc_olpc_activity_properties_set_properties_impl impl = (GABBLE_SVC_OLPC_ACTIVITY_PROPERTIES_GET_CLASS (self)->set_properties_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_room,
        in_properties,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * gabble_svc_olpc_activity_properties_implement_set_properties:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the SetProperties D-Bus method
 *
 * Register an implementation for the SetProperties method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
gabble_svc_olpc_activity_properties_implement_set_properties (GabbleSvcOLPCActivityPropertiesClass *klass, gabble_svc_olpc_activity_properties_set_properties_impl impl)
{
  klass->set_properties_cb = impl;
}

/**
 * gabble_svc_olpc_activity_properties_get_properties_impl:
 * @self: The object implementing this interface
 * @in_room: guint  (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetProperties on interface org.laptop.Telepathy.ActivityProperties.
 */
static void
gabble_svc_olpc_activity_properties_get_properties (GabbleSvcOLPCActivityProperties *self,
    guint in_room,
    DBusGMethodInvocation *context)
{
  gabble_svc_olpc_activity_properties_get_properties_impl impl = (GABBLE_SVC_OLPC_ACTIVITY_PROPERTIES_GET_CLASS (self)->get_properties_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_room,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * gabble_svc_olpc_activity_properties_implement_get_properties:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetProperties D-Bus method
 *
 * Register an implementation for the GetProperties method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
gabble_svc_olpc_activity_properties_implement_get_properties (GabbleSvcOLPCActivityPropertiesClass *klass, gabble_svc_olpc_activity_properties_get_properties_impl impl)
{
  klass->get_properties_cb = impl;
}

/**
 * gabble_svc_olpc_activity_properties_get_activity_impl:
 * @self: The object implementing this interface
 * @in_activity_id: const gchar * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetActivity on interface org.laptop.Telepathy.ActivityProperties.
 */
static void
gabble_svc_olpc_activity_properties_get_activity (GabbleSvcOLPCActivityProperties *self,
    const gchar *in_activity_id,
    DBusGMethodInvocation *context)
{
  gabble_svc_olpc_activity_properties_get_activity_impl impl = (GABBLE_SVC_OLPC_ACTIVITY_PROPERTIES_GET_CLASS (self)->get_activity_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_activity_id,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * gabble_svc_olpc_activity_properties_implement_get_activity:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetActivity D-Bus method
 *
 * Register an implementation for the GetActivity method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
gabble_svc_olpc_activity_properties_implement_get_activity (GabbleSvcOLPCActivityPropertiesClass *klass, gabble_svc_olpc_activity_properties_get_activity_impl impl)
{
  klass->get_activity_cb = impl;
}

/**
 * gabble_svc_olpc_activity_properties_emit_activity_properties_changed:
 * @instance: The object implementing this interface
 * @arg_room: guint  (FIXME, generate documentation)
 * @arg_properties: GHashTable * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * ActivityPropertiesChanged signal on interface org.laptop.Telepathy.ActivityProperties.
 */
void
gabble_svc_olpc_activity_properties_emit_activity_properties_changed (gpointer instance,
    guint arg_room,
    GHashTable *arg_properties)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, GABBLE_TYPE_SVC_OLPC_ACTIVITY_PROPERTIES));
  g_signal_emit (instance,
      olpc_activity_properties_signals[SIGNAL_OLPC_ACTIVITY_PROPERTIES_ActivityPropertiesChanged],
      0,
      arg_room,
      arg_properties);
}

static inline void
gabble_svc_olpc_activity_properties_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  dbus_g_object_type_install_info (gabble_svc_olpc_activity_properties_get_type (),
      &_gabble_svc_olpc_activity_properties_object_info);

  /**
   * GabbleSvcOLPCActivityProperties::activity-properties-changed:
   * @arg_room: guint  (FIXME, generate documentation)
   * @arg_properties: GHashTable * (FIXME, generate documentation)
   *
   * The ActivityPropertiesChanged D-Bus signal is emitted whenever this GObject signal is.
   */
  olpc_activity_properties_signals[SIGNAL_OLPC_ACTIVITY_PROPERTIES_ActivityPropertiesChanged] =
  g_signal_new ("activity-properties-changed",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      _gabble_ext_marshal_VOID__UINT_BOXED,
      G_TYPE_NONE,
      2,
      G_TYPE_UINT,
      (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)));

}
static void
gabble_svc_olpc_activity_properties_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      gabble_svc_olpc_activity_properties_base_init_once (klass);
    }
}
static const DBusGMethodInfo _gabble_svc_olpc_activity_properties_methods[] = {
  { (GCallback) gabble_svc_olpc_activity_properties_set_properties, _gabble_ext_marshal_VOID__UINT_BOXED_POINTER, 0 },
  { (GCallback) gabble_svc_olpc_activity_properties_get_properties, g_cclosure_marshal_VOID__UINT_POINTER, 85 },
  { (GCallback) gabble_svc_olpc_activity_properties_get_activity, _gabble_ext_marshal_VOID__STRING_POINTER, 174 },
};

static const DBusGObjectInfo _gabble_svc_olpc_activity_properties_object_info = {
  0,
  _gabble_svc_olpc_activity_properties_methods,
  3,
"org.laptop.Telepathy.ActivityProperties\0SetProperties\0A\0room\0I\0u\0properties\0I\0a{sv}\0\0org.laptop.Telepathy.ActivityProperties\0GetProperties\0A\0room\0I\0u\0properties\0O\0F\0N\0a{sv}\0\0org.laptop.Telepathy.ActivityProperties\0GetActivity\0A\0activity_id\0I\0s\0room\0O\0F\0N\0u\0\0\0",
"org.laptop.Telepathy.ActivityProperties\0ActivityPropertiesChanged\0\0",
"\0\0",
};

static const DBusGObjectInfo _gabble_svc_olpc_buddy_info_object_info;

struct _GabbleSvcOLPCBuddyInfoClass {
    GTypeInterface parent_class;
    gabble_svc_olpc_buddy_info_set_properties_impl set_properties_cb;
    gabble_svc_olpc_buddy_info_get_properties_impl get_properties_cb;
    gabble_svc_olpc_buddy_info_set_activities_impl set_activities_cb;
    gabble_svc_olpc_buddy_info_add_activity_impl add_activity_cb;
    gabble_svc_olpc_buddy_info_get_activities_impl get_activities_cb;
    gabble_svc_olpc_buddy_info_set_current_activity_impl set_current_activity_cb;
    gabble_svc_olpc_buddy_info_get_current_activity_impl get_current_activity_cb;
};

enum {
    SIGNAL_OLPC_BUDDY_INFO_PropertiesChanged,
    SIGNAL_OLPC_BUDDY_INFO_ActivitiesChanged,
    SIGNAL_OLPC_BUDDY_INFO_CurrentActivityChanged,
    N_OLPC_BUDDY_INFO_SIGNALS
};
static guint olpc_buddy_info_signals[N_OLPC_BUDDY_INFO_SIGNALS] = {0};

static void gabble_svc_olpc_buddy_info_base_init (gpointer klass);

GType
gabble_svc_olpc_buddy_info_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (GabbleSvcOLPCBuddyInfoClass),
        gabble_svc_olpc_buddy_info_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "GabbleSvcOLPCBuddyInfo", &info, 0);
    }

  return type;
}

/**
 * gabble_svc_olpc_buddy_info_set_properties_impl:
 * @self: The object implementing this interface
 * @in_properties: GHashTable * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * SetProperties on interface org.laptop.Telepathy.BuddyInfo.
 */
static void
gabble_svc_olpc_buddy_info_set_properties (GabbleSvcOLPCBuddyInfo *self,
    GHashTable *in_properties,
    DBusGMethodInvocation *context)
{
  gabble_svc_olpc_buddy_info_set_properties_impl impl = (GABBLE_SVC_OLPC_BUDDY_INFO_GET_CLASS (self)->set_properties_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_properties,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * gabble_svc_olpc_buddy_info_implement_set_properties:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the SetProperties D-Bus method
 *
 * Register an implementation for the SetProperties method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
gabble_svc_olpc_buddy_info_implement_set_properties (GabbleSvcOLPCBuddyInfoClass *klass, gabble_svc_olpc_buddy_info_set_properties_impl impl)
{
  klass->set_properties_cb = impl;
}

/**
 * gabble_svc_olpc_buddy_info_get_properties_impl:
 * @self: The object implementing this interface
 * @in_contact: guint  (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetProperties on interface org.laptop.Telepathy.BuddyInfo.
 */
static void
gabble_svc_olpc_buddy_info_get_properties (GabbleSvcOLPCBuddyInfo *self,
    guint in_contact,
    DBusGMethodInvocation *context)
{
  gabble_svc_olpc_buddy_info_get_properties_impl impl = (GABBLE_SVC_OLPC_BUDDY_INFO_GET_CLASS (self)->get_properties_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_contact,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * gabble_svc_olpc_buddy_info_implement_get_properties:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetProperties D-Bus method
 *
 * Register an implementation for the GetProperties method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
gabble_svc_olpc_buddy_info_implement_get_properties (GabbleSvcOLPCBuddyInfoClass *klass, gabble_svc_olpc_buddy_info_get_properties_impl impl)
{
  klass->get_properties_cb = impl;
}

/**
 * gabble_svc_olpc_buddy_info_set_activities_impl:
 * @self: The object implementing this interface
 * @in_activities: const GPtrArray * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * SetActivities on interface org.laptop.Telepathy.BuddyInfo.
 */
static void
gabble_svc_olpc_buddy_info_set_activities (GabbleSvcOLPCBuddyInfo *self,
    const GPtrArray *in_activities,
    DBusGMethodInvocation *context)
{
  gabble_svc_olpc_buddy_info_set_activities_impl impl = (GABBLE_SVC_OLPC_BUDDY_INFO_GET_CLASS (self)->set_activities_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_activities,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * gabble_svc_olpc_buddy_info_implement_set_activities:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the SetActivities D-Bus method
 *
 * Register an implementation for the SetActivities method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
gabble_svc_olpc_buddy_info_implement_set_activities (GabbleSvcOLPCBuddyInfoClass *klass, gabble_svc_olpc_buddy_info_set_activities_impl impl)
{
  klass->set_activities_cb = impl;
}

/**
 * gabble_svc_olpc_buddy_info_add_activity_impl:
 * @self: The object implementing this interface
 * @in_id: const gchar * (FIXME, generate documentation)
 * @in_handle: guint  (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * AddActivity on interface org.laptop.Telepathy.BuddyInfo.
 */
static void
gabble_svc_olpc_buddy_info_add_activity (GabbleSvcOLPCBuddyInfo *self,
    const gchar *in_id,
    guint in_handle,
    DBusGMethodInvocation *context)
{
  gabble_svc_olpc_buddy_info_add_activity_impl impl = (GABBLE_SVC_OLPC_BUDDY_INFO_GET_CLASS (self)->add_activity_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_id,
        in_handle,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * gabble_svc_olpc_buddy_info_implement_add_activity:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the AddActivity D-Bus method
 *
 * Register an implementation for the AddActivity method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
gabble_svc_olpc_buddy_info_implement_add_activity (GabbleSvcOLPCBuddyInfoClass *klass, gabble_svc_olpc_buddy_info_add_activity_impl impl)
{
  klass->add_activity_cb = impl;
}

/**
 * gabble_svc_olpc_buddy_info_get_activities_impl:
 * @self: The object implementing this interface
 * @in_contact: guint  (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetActivities on interface org.laptop.Telepathy.BuddyInfo.
 */
static void
gabble_svc_olpc_buddy_info_get_activities (GabbleSvcOLPCBuddyInfo *self,
    guint in_contact,
    DBusGMethodInvocation *context)
{
  gabble_svc_olpc_buddy_info_get_activities_impl impl = (GABBLE_SVC_OLPC_BUDDY_INFO_GET_CLASS (self)->get_activities_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_contact,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * gabble_svc_olpc_buddy_info_implement_get_activities:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetActivities D-Bus method
 *
 * Register an implementation for the GetActivities method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
gabble_svc_olpc_buddy_info_implement_get_activities (GabbleSvcOLPCBuddyInfoClass *klass, gabble_svc_olpc_buddy_info_get_activities_impl impl)
{
  klass->get_activities_cb = impl;
}

/**
 * gabble_svc_olpc_buddy_info_set_current_activity_impl:
 * @self: The object implementing this interface
 * @in_activity: const gchar * (FIXME, generate documentation)
 * @in_channel: guint  (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * SetCurrentActivity on interface org.laptop.Telepathy.BuddyInfo.
 */
static void
gabble_svc_olpc_buddy_info_set_current_activity (GabbleSvcOLPCBuddyInfo *self,
    const gchar *in_activity,
    guint in_channel,
    DBusGMethodInvocation *context)
{
  gabble_svc_olpc_buddy_info_set_current_activity_impl impl = (GABBLE_SVC_OLPC_BUDDY_INFO_GET_CLASS (self)->set_current_activity_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_activity,
        in_channel,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * gabble_svc_olpc_buddy_info_implement_set_current_activity:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the SetCurrentActivity D-Bus method
 *
 * Register an implementation for the SetCurrentActivity method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
gabble_svc_olpc_buddy_info_implement_set_current_activity (GabbleSvcOLPCBuddyInfoClass *klass, gabble_svc_olpc_buddy_info_set_current_activity_impl impl)
{
  klass->set_current_activity_cb = impl;
}

/**
 * gabble_svc_olpc_buddy_info_get_current_activity_impl:
 * @self: The object implementing this interface
 * @in_contact: guint  (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetCurrentActivity on interface org.laptop.Telepathy.BuddyInfo.
 */
static void
gabble_svc_olpc_buddy_info_get_current_activity (GabbleSvcOLPCBuddyInfo *self,
    guint in_contact,
    DBusGMethodInvocation *context)
{
  gabble_svc_olpc_buddy_info_get_current_activity_impl impl = (GABBLE_SVC_OLPC_BUDDY_INFO_GET_CLASS (self)->get_current_activity_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_contact,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * gabble_svc_olpc_buddy_info_implement_get_current_activity:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetCurrentActivity D-Bus method
 *
 * Register an implementation for the GetCurrentActivity method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
gabble_svc_olpc_buddy_info_implement_get_current_activity (GabbleSvcOLPCBuddyInfoClass *klass, gabble_svc_olpc_buddy_info_get_current_activity_impl impl)
{
  klass->get_current_activity_cb = impl;
}

/**
 * gabble_svc_olpc_buddy_info_emit_properties_changed:
 * @instance: The object implementing this interface
 * @arg_contact: guint  (FIXME, generate documentation)
 * @arg_properties: GHashTable * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * PropertiesChanged signal on interface org.laptop.Telepathy.BuddyInfo.
 */
void
gabble_svc_olpc_buddy_info_emit_properties_changed (gpointer instance,
    guint arg_contact,
    GHashTable *arg_properties)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, GABBLE_TYPE_SVC_OLPC_BUDDY_INFO));
  g_signal_emit (instance,
      olpc_buddy_info_signals[SIGNAL_OLPC_BUDDY_INFO_PropertiesChanged],
      0,
      arg_contact,
      arg_properties);
}

/**
 * gabble_svc_olpc_buddy_info_emit_activities_changed:
 * @instance: The object implementing this interface
 * @arg_contact: guint  (FIXME, generate documentation)
 * @arg_activities: const GPtrArray * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * ActivitiesChanged signal on interface org.laptop.Telepathy.BuddyInfo.
 */
void
gabble_svc_olpc_buddy_info_emit_activities_changed (gpointer instance,
    guint arg_contact,
    const GPtrArray *arg_activities)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, GABBLE_TYPE_SVC_OLPC_BUDDY_INFO));
  g_signal_emit (instance,
      olpc_buddy_info_signals[SIGNAL_OLPC_BUDDY_INFO_ActivitiesChanged],
      0,
      arg_contact,
      arg_activities);
}

/**
 * gabble_svc_olpc_buddy_info_emit_current_activity_changed:
 * @instance: The object implementing this interface
 * @arg_contact: guint  (FIXME, generate documentation)
 * @arg_activity: const gchar * (FIXME, generate documentation)
 * @arg_channel: guint  (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * CurrentActivityChanged signal on interface org.laptop.Telepathy.BuddyInfo.
 */
void
gabble_svc_olpc_buddy_info_emit_current_activity_changed (gpointer instance,
    guint arg_contact,
    const gchar *arg_activity,
    guint arg_channel)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, GABBLE_TYPE_SVC_OLPC_BUDDY_INFO));
  g_signal_emit (instance,
      olpc_buddy_info_signals[SIGNAL_OLPC_BUDDY_INFO_CurrentActivityChanged],
      0,
      arg_contact,
      arg_activity,
      arg_channel);
}

static inline void
gabble_svc_olpc_buddy_info_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  dbus_g_object_type_install_info (gabble_svc_olpc_buddy_info_get_type (),
      &_gabble_svc_olpc_buddy_info_object_info);

  /**
   * GabbleSvcOLPCBuddyInfo::properties-changed:
   * @arg_contact: guint  (FIXME, generate documentation)
   * @arg_properties: GHashTable * (FIXME, generate documentation)
   *
   * The PropertiesChanged D-Bus signal is emitted whenever this GObject signal is.
   */
  olpc_buddy_info_signals[SIGNAL_OLPC_BUDDY_INFO_PropertiesChanged] =
  g_signal_new ("properties-changed",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      _gabble_ext_marshal_VOID__UINT_BOXED,
      G_TYPE_NONE,
      2,
      G_TYPE_UINT,
      (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)));

  /**
   * GabbleSvcOLPCBuddyInfo::activities-changed:
   * @arg_contact: guint  (FIXME, generate documentation)
   * @arg_activities: const GPtrArray * (FIXME, generate documentation)
   *
   * The ActivitiesChanged D-Bus signal is emitted whenever this GObject signal is.
   */
  olpc_buddy_info_signals[SIGNAL_OLPC_BUDDY_INFO_ActivitiesChanged] =
  g_signal_new ("activities-changed",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      _gabble_ext_marshal_VOID__UINT_BOXED,
      G_TYPE_NONE,
      2,
      G_TYPE_UINT,
      (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_STRING, G_TYPE_UINT, G_TYPE_INVALID)))));

  /**
   * GabbleSvcOLPCBuddyInfo::current-activity-changed:
   * @arg_contact: guint  (FIXME, generate documentation)
   * @arg_activity: const gchar * (FIXME, generate documentation)
   * @arg_channel: guint  (FIXME, generate documentation)
   *
   * The CurrentActivityChanged D-Bus signal is emitted whenever this GObject signal is.
   */
  olpc_buddy_info_signals[SIGNAL_OLPC_BUDDY_INFO_CurrentActivityChanged] =
  g_signal_new ("current-activity-changed",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      _gabble_ext_marshal_VOID__UINT_STRING_UINT,
      G_TYPE_NONE,
      3,
      G_TYPE_UINT,
      G_TYPE_STRING,
      G_TYPE_UINT);

}
static void
gabble_svc_olpc_buddy_info_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      gabble_svc_olpc_buddy_info_base_init_once (klass);
    }
}
static const DBusGMethodInfo _gabble_svc_olpc_buddy_info_methods[] = {
  { (GCallback) gabble_svc_olpc_buddy_info_set_properties, _gabble_ext_marshal_VOID__BOXED_POINTER, 0 },
  { (GCallback) gabble_svc_olpc_buddy_info_get_properties, g_cclosure_marshal_VOID__UINT_POINTER, 67 },
  { (GCallback) gabble_svc_olpc_buddy_info_set_activities, _gabble_ext_marshal_VOID__BOXED_POINTER, 150 },
  { (GCallback) gabble_svc_olpc_buddy_info_add_activity, _gabble_ext_marshal_VOID__STRING_UINT_POINTER, 217 },
  { (GCallback) gabble_svc_olpc_buddy_info_get_activities, g_cclosure_marshal_VOID__UINT_POINTER, 281 },
  { (GCallback) gabble_svc_olpc_buddy_info_set_current_activity, _gabble_ext_marshal_VOID__STRING_UINT_POINTER, 364 },
  { (GCallback) gabble_svc_olpc_buddy_info_get_current_activity, g_cclosure_marshal_VOID__UINT_POINTER, 442 },
};

static const DBusGObjectInfo _gabble_svc_olpc_buddy_info_object_info = {
  0,
  _gabble_svc_olpc_buddy_info_methods,
  7,
"org.laptop.Telepathy.BuddyInfo\0SetProperties\0A\0properties\0I\0a{sv}\0\0org.laptop.Telepathy.BuddyInfo\0GetProperties\0A\0contact\0I\0u\0properties\0O\0F\0N\0a{sv}\0\0org.laptop.Telepathy.BuddyInfo\0SetActivities\0A\0activities\0I\0a(su)\0\0org.laptop.Telepathy.BuddyInfo\0AddActivity\0A\0id\0I\0s\0handle\0I\0u\0\0org.laptop.Telepathy.BuddyInfo\0GetActivities\0A\0contact\0I\0u\0activities\0O\0F\0N\0a(su)\0\0org.laptop.Telepathy.BuddyInfo\0SetCurrentActivity\0A\0activity\0I\0s\0channel\0I\0u\0\0org.laptop.Telepathy.BuddyInfo\0GetCurrentActivity\0A\0contact\0I\0u\0activity\0O\0F\0N\0s\0channel\0O\0F\0N\0u\0\0\0",
"org.laptop.Telepathy.BuddyInfo\0PropertiesChanged\0org.laptop.Telepathy.BuddyInfo\0ActivitiesChanged\0org.laptop.Telepathy.BuddyInfo\0CurrentActivityChanged\0\0",
"\0\0",
};


