/* Auto-generated, do not edit.
 *
 * This file may be distributed under the same terms
 * as the specification from which it was generated.
 */

/**
 * GABBLE_HASH_TYPE_MAIL:
 *
 * An extensible map representing a mail, or (on protocols where         &lt;tt&gt;Thread_Based&lt;/tt&gt; appears in         &lt;tp:member-ref&gt;MailNotificationFlags&lt;/tp:member-ref&gt;) a thread of         mails. All keys are optional where not otherwise stated; however, at         least one of &amp;quot;senders&amp;quot; and &amp;quot;subject&amp;quot; must be included.
 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GHashTable
 * appropriate for representing a D-Bus
 * dictionary of signature
 * <literal>a{sv}</literal>.
 *
 * Keys (D-Bus type <literal>s</literal>,
 * named <literal>Key</literal>):
 * &lt;p&gt;A key providing information about the mail or thread. Well-known             keys are as follows:&lt;/p&gt;          &lt;dl&gt;           &lt;dt&gt;id — s&lt;/dt&gt;           &lt;dd&gt;             &lt;p&gt;A unique ID for this e-mail. CMs with               &lt;tt&gt;Supports_Unread_Mails&lt;/tt&gt; set in               &lt;tp:member-ref&gt;MailNotificationFlags&lt;/tp:member-ref&gt; MUST provide               this key in each &lt;tp:type&gt;Mail&lt;/tp:type&gt;.&lt;/p&gt;              &lt;p&gt;If provided, the ID SHOULD be unique to a Mail at least until               that mail is removed with the               &lt;tp:member-ref&gt;UnreadMailsChanged&lt;/tp:member-ref&gt; signal               (in protocols with &lt;tt&gt;Supports_Unread_Emails&lt;/tt&gt;), or               unique for the duration of a session (otherwise).&lt;/p&gt;              &lt;tp:rationale&gt;               &lt;p&gt;In protocols with Supports_Unread_Mails, this key is used to                 indicate which mail was removed. In protocols without that                 feature, it&apos;s impossible to tell when a mail has been removed                 (and hence how long the identifier will remain valid for use                 with &lt;tp:member-ref&gt;RequestMailURL&lt;/tp:member-ref&gt;).&lt;/p&gt;             &lt;/tp:rationale&gt;           &lt;/dd&gt;            &lt;dt&gt;url-data — any type&lt;/dt&gt;           &lt;dd&gt;An opaque identifier (typically a string or list of strings)             provided to the Connection when calling             &lt;tp:member-ref&gt;RequestMailURL&lt;/tp:member-ref&gt;,             containing information used by the Connection to build the URL.           &lt;/dd&gt;            &lt;dt&gt;senders — a(ss) (&lt;tp:type&gt;Mail_Address&lt;/tp:type&gt;)&lt;/dt&gt;           &lt;dd&gt;             An array of sender display name and e-mail address pairs. Note that             only e-mails represented as a thread can have multiple senders.           &lt;/dd&gt;            &lt;dt&gt;to-addresses — a(ss) (&lt;tp:type&gt;Mail_Address&lt;/tp:type&gt;)&lt;/dt&gt;           &lt;dd&gt;             An array of display name and e-mail address pairs representing             the recipients.           &lt;/dd&gt;            &lt;dt&gt;cc-addresses — a(ss) (&lt;tp:type&gt;Mail_Address&lt;/tp:type&gt;)&lt;/dt&gt;           &lt;dd&gt;             An array of display name and e-mail address pairs representing             the carbon-copy recipients.           &lt;/dd&gt;            &lt;dt&gt;sent-timestamp — x (&lt;tp:type&gt;Unix_Timestamp64&lt;/tp:type&gt;)&lt;/dt&gt;           &lt;dd&gt;A UNIX timestamp indicating when the message was sent, or for             a thread, when the most recent message was sent.           &lt;/dd&gt;            &lt;dt&gt;received-timestamp — x (&lt;tp:type&gt;Unix_Timestamp64&lt;/tp:type&gt;)&lt;/dt&gt;           &lt;dd&gt;A UNIX timestamp indicating when the message was received, or for             a thread, when the most recent message was received.           &lt;/dd&gt;            &lt;dt&gt;has-attachments — b&lt;/dt&gt;           &lt;dd&gt;If true, this mail has attachments.&lt;/dd&gt;            &lt;dt&gt;subject — s&lt;/dt&gt;           &lt;dd&gt;             The subject of the message. This MUST be encoded in UTF-8.           &lt;/dd&gt;            &lt;dt&gt;content-type — s&lt;/dt&gt;           &lt;dd&gt;             &lt;p&gt;The MIME type of the message content. Two types are currently               supported: &amp;quot;text/plain&amp;quot; for plain text, and &amp;quot;text/html&amp;quot; for a               HTML document. If omitted, &amp;quot;text/plain&amp;quot; MUST be assumed.               Regardless of MIME type, the content MUST be valid UTF-8 (which               may require that the Connection transcodes it from a legacy               encoding).&lt;/p&gt;              &lt;tp:rationale&gt;               &lt;p&gt;All strings on D-Bus must be UTF-8.&lt;/p&gt;             &lt;/tp:rationale&gt;           &lt;/dd&gt;            &lt;dt&gt;truncated — b&lt;/dt&gt;           &lt;dd&gt;             If true, the content is only a partial message; if false or             omitted, the content is the entire message.           &lt;/dd&gt;            &lt;dt&gt;content — s&lt;/dt&gt;           &lt;dd&gt;             The body of the message, possibly truncated, encoded as appropriate             for &amp;quot;content-type&amp;quot;.           &lt;/dd&gt;            &lt;dt&gt;folder — s&lt;/dt&gt;           &lt;dd&gt;             The name of the folder containing this e-mails.             If omitted, the inbox SHOULD be assumed.           &lt;/dd&gt;         &lt;/dl&gt;
 *
 * Values (D-Bus type <literal>v</literal>,
 * named <literal>Value</literal>):
 * The value, of whatever type is appropriate for the           key.
 *
 */
#define GABBLE_HASH_TYPE_MAIL (gabble_type_dbus_hash_sv ())

/**
 * GABBLE_ARRAY_TYPE_MAIL_LIST:

 * Expands to a call to a function
 * that returns the #GType of a #GPtrArray
 * of #GABBLE_HASH_TYPE_MAIL.
 */
#define GABBLE_ARRAY_TYPE_MAIL_LIST (gabble_type_dbus_array_of_a_7bsv_7d ())

/**
 * GABBLE_HASH_TYPE_CONTACT_CODEC_MAP:
 *
 * A map from contacts to the lists of codecs they support.
 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GHashTable
 * appropriate for representing a D-Bus
 * dictionary of signature
 * <literal>a{ua(usuua{ss})}</literal>.
 *
 * Keys (D-Bus type <literal>u</literal>,
 * type <literal>Contact_Handle</literal>,
 * named <literal>Handle</literal>):
 * A contact
 *
 * Values (D-Bus type <literal>a(usuua{ss})</literal>,
 * type <literal>Codec[]</literal>,
 * named <literal>Codecs</literal>):
 * The codecs that the contact supports
 *
 */
#define GABBLE_HASH_TYPE_CONTACT_CODEC_MAP (gabble_type_dbus_hash_ua_28usuua_7bss_7d_29 ())

/**
 * GABBLE_HASH_TYPE_CONTACT_SENDING_STATE_MAP:
 *
 * A map from contacts to their sending state.
 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GHashTable
 * appropriate for representing a D-Bus
 * dictionary of signature
 * <literal>a{uu}</literal>.
 *
 * Keys (D-Bus type <literal>u</literal>,
 * type <literal>Contact_Handle</literal>,
 * named <literal>Contact</literal>):
 * (Undocumented)
 *
 * Values (D-Bus type <literal>u</literal>,
 * type <literal>Sending_State</literal>,
 * named <literal>Sending</literal>):
 * (Undocumented)
 *
 */
#define GABBLE_HASH_TYPE_CONTACT_SENDING_STATE_MAP (gabble_type_dbus_hash_uu ())

/**
 * GABBLE_HASH_TYPE_CANDIDATE_INFO:
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         Extra information about the candidate. Allowed and mandatory keys         depend on the transport protocol used. The following keys are commenly         used:         &lt;dl&gt;           &lt;dt&gt;Type (u)&lt;/dt&gt;           &lt;dd&gt;type of candidate (host, srflx, prflx, relay)&lt;/dd&gt;            &lt;dt&gt;Foundation (s)&lt;/dt&gt;           &lt;dd&gt;the foundation of this candiate&lt;/dd&gt;            &lt;dt&gt;Protocol (u) &lt;/dt&gt;           &lt;dd&gt;Underlying protocol of the candidate (udp, tcp) &lt;/dd&gt;            &lt;dt&gt;Priority (u) &lt;/dt&gt;           &lt;dd&gt;Priority of the candidate &lt;/dd&gt;            &lt;dt&gt;BaseIP (u) &lt;/dt&gt;           &lt;dd&gt;Base IP of this candidate &lt;/dd&gt;            &lt;dt&gt;Username (s) &lt;/dt&gt;           &lt;dd&gt;Username of this candidate             (only if credentials are per candidate)&lt;/dd&gt;            &lt;dt&gt;Password (s) &lt;/dt&gt;           &lt;dd&gt;Password of this candidate             (only if credentials are per candidate)&lt;/dd&gt;            &lt;dt&gt;RawUDPFallback (b) &lt;/dt&gt;           &lt;dd&gt;Indicate whether this candidate may be used to provide a UDP                fallback&lt;/dd&gt;         &lt;/dl&gt;
 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GHashTable
 * appropriate for representing a D-Bus
 * dictionary of signature
 * <literal>a{sv}</literal>.
 *
 * Keys (D-Bus type <literal>s</literal>,
 * named <literal>Key</literal>):
 * One of the well-known keys documented here, or an           implementation-specific key
 *
 * Values (D-Bus type <literal>v</literal>,
 * named <literal>Value</literal>):
 * The value corresponding to that key
 *
 */
#define GABBLE_HASH_TYPE_CANDIDATE_INFO (gabble_type_dbus_hash_sv ())

/**
 * GABBLE_HASH_TYPE_CALL_MEMBER_MAP:
 *
 * A mapping from handles to their current state in the call.
 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GHashTable
 * appropriate for representing a D-Bus
 * dictionary of signature
 * <literal>a{uu}</literal>.
 *
 * Keys (D-Bus type <literal>u</literal>,
 * type <literal>Handle</literal>,
 * named <literal>key</literal>):
 * (Undocumented)
 *
 * Values (D-Bus type <literal>u</literal>,
 * type <literal>Call_Member_Flags</literal>,
 * named <literal>Flag</literal>):
 * (Undocumented)
 *
 */
#define GABBLE_HASH_TYPE_CALL_MEMBER_MAP (gabble_type_dbus_hash_uu ())

/**
 * GABBLE_ARRAY_TYPE_CALL_MEMBER_MAP_LIST:

 * Expands to a call to a function
 * that returns the #GType of a #GPtrArray
 * of #GABBLE_HASH_TYPE_CALL_MEMBER_MAP.
 */
#define GABBLE_ARRAY_TYPE_CALL_MEMBER_MAP_LIST (gabble_type_dbus_array_of_a_7buu_7d ())

/**
 * GABBLE_HASH_TYPE_AUTHDETAILS:
 *
 * An extensible map representing details provided by the server for         authentication.
 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GHashTable
 * appropriate for representing a D-Bus
 * dictionary of signature
 * <literal>a{sv}</literal>.
 *
 * Keys (D-Bus type <literal>s</literal>,
 * named <literal>Key</literal>):
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;             Well-known keys:             &lt;dl&gt;               &lt;dt&gt;username&lt;/dt&gt;               &lt;dd&gt;                 string, Username to authenticate with if needed               &lt;/dd&gt;               &lt;dt&gt;realm&lt;/dt&gt;               &lt;dd&gt;                 string, Realm to use for authentication if needed               &lt;/dd&gt;               &lt;dt&gt;session-id&lt;/dt&gt;               &lt;dd&gt;                 XMPP session id as needed for the legacy jabber digest method.               &lt;/dd&gt;             &lt;/dl&gt;           &lt;/p&gt;
 *
 * Values (D-Bus type <literal>v</literal>,
 * named <literal>Value</literal>):
 * (Undocumented)
 *
 */
#define GABBLE_HASH_TYPE_AUTHDETAILS (gabble_type_dbus_hash_sv ())

/**
 * GABBLE_ARRAY_TYPE_AUTHDETAILS_LIST:

 * Expands to a call to a function
 * that returns the #GType of a #GPtrArray
 * of #GABBLE_HASH_TYPE_AUTHDETAILS.
 */
#define GABBLE_ARRAY_TYPE_AUTHDETAILS_LIST (gabble_type_dbus_array_of_a_7bsv_7d ())

GType gabble_type_dbus_hash_uu (void);

GType gabble_type_dbus_hash_ua_28usuua_7bss_7d_29 (void);

GType gabble_type_dbus_hash_sv (void);

/**
 * GABBLE_STRUCT_TYPE_ACTIVITY:

 * 
	A struct containing:
          
	&lt;ul&gt;
		
            
		&lt;li&gt;
			the identifier of the activity
		&lt;/li&gt;
		
            
		&lt;li&gt;
			the room handle of the activity channel
		&lt;/li&gt;
		
          
	&lt;/ul&gt;
	
        

 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(su)</literal>.
 *
 * Member 0 (D-Bus type <literal>s</literal>,
 * named <literal>id</literal>):
 * (Undocumented)
 *
 * Member 1 (D-Bus type <literal>u</literal>,
 * type <literal>Room_Handle</literal>,
 * named <literal>room</literal>):
 * (Undocumented)
 *
 */
#define GABBLE_STRUCT_TYPE_ACTIVITY (gabble_type_dbus_struct_su ())

/**
 * GABBLE_ARRAY_TYPE_ACTIVITY_LIST:

 * Expands to a call to a function
 * that returns the #GType of a #GPtrArray
 * of #GABBLE_STRUCT_TYPE_ACTIVITY.
 */
#define GABBLE_ARRAY_TYPE_ACTIVITY_LIST (gabble_type_dbus_array_su ())

/**
 * GABBLE_STRUCT_TYPE_HTTP_POST_DATA:

 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;
	
        
	&lt;p&gt;
		A pair (key, value) representing POST data compatible with the
        application/x-www-form-urlencoded MIME type. The strings MUST be
        valid UTF-8 strings, and the characters used in the key MUST obey
        the requirements of the
        
		&lt;a href=&quot;http://www.w3.org/TR/html401/types.html#type-cdata&quot;&gt;
			
          HTML CDATA type
		&lt;/a&gt;
		. The value MUST NOT be
        encoded with HTML entities.
	&lt;/p&gt;
	

        
	&lt;p&gt;
		For example, if the POST data should contain a key &amp;quot;less-than&amp;quot; with value
        &amp;quot;&amp;lt;&amp;quot;, and a key &amp;quot;percent&amp;quot; with value &amp;quot;%&amp;quot;, this should be represented as
        two HTTP_Post_Data structures, (&amp;quot;less-than&amp;quot;, &amp;quot;&amp;lt;&amp;quot;) and (&amp;quot;percent&amp;quot;, &amp;quot;%&amp;quot;),
        resulting in a POST request whose request body is &amp;quot;less-than=&amp;amp;lt;&amp;amp;percent=%25&amp;quot;.
        If a client passes this to a browser by writing it into an HTML form, it
        could do so by representing it as:
	&lt;/p&gt;
	

        
	&lt;pre&gt;
		
        &amp;lt;input type=&amp;quot;hidden&amp;quot; name=&amp;quot;less-than&amp;quot;&amp;gt;&amp;amp;lt;&amp;lt;/input&amp;gt;
        &amp;lt;input type=&amp;quot;hidden&amp;quot; name=&amp;quot;percent&amp;quot;&amp;gt;%&amp;lt;/input&amp;gt;
        
	&lt;/pre&gt;
	

        
	&lt;tp:rationale&gt;
		
          
		&lt;p&gt;
			This data can be used to generate a HTML file that will
            automatically load the URL with appropriate POST data, in which case
            the client MUST convert any characters that are special within HTML
            into HTML entities. Alternatively, it can be used in an API that will
            instruct the browser how to load the URL (like the Netscape Plug-in
            API), in which case the client MUST escape
            
			&lt;a href=&quot;http://www.ietf.org/rfc/rfc1738.txt&quot;&gt;
				characters that are
              reserved in URLs
			&lt;/a&gt;
			, if appropriate for that API.
		&lt;/p&gt;
		

          
		&lt;p&gt;
			An array of pairs is used instead of a map from keys to values,
            because it&apos;s valid to repeat keys in both HTML and
            x-www-form-urlencoded data.
		&lt;/p&gt;
		
        
	&lt;/tp:rationale&gt;
	
      

 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(ss)</literal>.
 *
 * Member 0 (D-Bus type <literal>s</literal>,
 * named <literal>Key</literal>):
 * The key, corresponding to a HTML control           name
 *
 * Member 1 (D-Bus type <literal>s</literal>,
 * named <literal>Value</literal>):
 * The value
 *
 */
#define GABBLE_STRUCT_TYPE_HTTP_POST_DATA (gabble_type_dbus_struct_ss ())

/**
 * GABBLE_ARRAY_TYPE_HTTP_POST_DATA_LIST:

 * Expands to a call to a function
 * that returns the #GType of a #GPtrArray
 * of #GABBLE_STRUCT_TYPE_HTTP_POST_DATA.
 */
#define GABBLE_ARRAY_TYPE_HTTP_POST_DATA_LIST (gabble_type_dbus_array_ss ())

/**
 * GABBLE_STRUCT_TYPE_MAIL_ADDRESS:

 * 
	
        A pair (name, address) representing an e-mail address,
        such as (&amp;quot;Nicolas Dufresne&amp;quot;, &amp;quot;nicolas.dufresne@collabora.co.uk&amp;quot;).
      

 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(ss)</literal>.
 *
 * Member 0 (D-Bus type <literal>s</literal>,
 * named <literal>Name</literal>):
 * The displayed name corresponding to the e-mail           address
 *
 * Member 1 (D-Bus type <literal>s</literal>,
 * named <literal>Address</literal>):
 * The actual e-mail address
 *
 */
#define GABBLE_STRUCT_TYPE_MAIL_ADDRESS (gabble_type_dbus_struct_ss ())

/**
 * GABBLE_ARRAY_TYPE_MAIL_ADDRESS_LIST:

 * Expands to a call to a function
 * that returns the #GType of a #GPtrArray
 * of #GABBLE_STRUCT_TYPE_MAIL_ADDRESS.
 */
#define GABBLE_ARRAY_TYPE_MAIL_ADDRESS_LIST (gabble_type_dbus_array_ss ())

/**
 * GABBLE_STRUCT_TYPE_MAIL_URL:

 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;
	
        
	&lt;p&gt;
		A structure containing the required information to open a web-based
          e-mail UI, without needing re-authentication (if possible).
	&lt;/p&gt;
	

        
	&lt;p&gt;
		Because the URL and POST data frequently contain short-lived
          credential tokens, a new URL should be requested (by calling one of
          the methods that returns a Mail_URL) for each visit to the web-based
          UI, and the URL should be visited soon after it is returned.
	&lt;/p&gt;
	
      

 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(sua(ss))</literal>.
 *
 * Member 0 (D-Bus type <literal>s</literal>,
 * named <literal>URL</literal>):
 * The URL to which to send a request.
 *
 * Member 1 (D-Bus type <literal>u</literal>,
 * type <literal>HTTP_Method</literal>,
 * named <literal>Method</literal>):
 * The HTTP method of the request.
 *
 * Member 2 (D-Bus type <literal>a(ss)</literal>,
 * type <literal>HTTP_Post_Data[]</literal>,
 * named <literal>Post_Data</literal>):
 * An array of name-value pairs containing the POST data to use when           opening the URL. This MUST be an empty array if the Method is not           POST.
 *
 */
#define GABBLE_STRUCT_TYPE_MAIL_URL (gabble_type_dbus_struct_sua_28ss_29 ())

/**
 * GABBLE_STRUCT_TYPE_CODEC:

 * 
	
        A description of a codec.
      

 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(usuua{ss})</literal>.
 *
 * Member 0 (D-Bus type <literal>u</literal>,
 * named <literal>Identifier</literal>):
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           Numeric identifier for the codec. This will be used as the PT in the           SDP or content description.
 *
 * Member 1 (D-Bus type <literal>s</literal>,
 * named <literal>Name</literal>):
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           The name of the codec.
 *
 * Member 2 (D-Bus type <literal>u</literal>,
 * named <literal>Clockrate</literal>):
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           The clockrate of the codec
 *
 * Member 3 (D-Bus type <literal>u</literal>,
 * named <literal>Channels</literal>):
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           Number of channels of the codec if applicable, otherwise 0
 *
 * Member 4 (D-Bus type <literal>a{ss}</literal>,
 * named <literal>Parameters</literal>):
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           Extra parameters for this codec
 *
 */
#define GABBLE_STRUCT_TYPE_CODEC (gabble_type_dbus_struct_usuua_7bss_7d ())

/**
 * GABBLE_ARRAY_TYPE_CODEC_LIST:

 * Expands to a call to a function
 * that returns the #GType of a #GPtrArray
 * of #GABBLE_STRUCT_TYPE_CODEC.
 */
#define GABBLE_ARRAY_TYPE_CODEC_LIST (gabble_type_dbus_array_usuua_7bss_7d ())

/**
 * GABBLE_STRUCT_TYPE_CODEC_OFFERING:

 * 
	
        A codec offer and its corresponding remote contact codec map.
      

 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(oa{ua(usuua{ss})})</literal>.
 *
 * Member 0 (D-Bus type <literal>o</literal>,
 * named <literal>Codec_Offer</literal>):
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           The object path to the             &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Call.Content&quot;&gt;CodecOffer.DRAFT&lt;/tp:dbus-ref&gt;
 *
 * Member 1 (D-Bus type <literal>a{ua(usuua{ss})}</literal>,
 * type <literal>Contact_Codec_Map</literal>,
 * named <literal>Remote_Contact_Codec_Map</literal>):
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           The &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Call.Content&quot;&gt;CodecOffer.DRAFT.RemoteContactCodecMap&lt;/tp:dbus-ref&gt; property           of the codec offer.
 *
 */
#define GABBLE_STRUCT_TYPE_CODEC_OFFERING (gabble_type_dbus_struct_oa_7bua_28usuua_7bss_7d_29_7d ())

/**
 * GABBLE_STRUCT_TYPE_CANDIDATE:

 * 
	A Stream Candidate

 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(usqa{sv})</literal>.
 *
 * Member 0 (D-Bus type <literal>u</literal>,
 * named <literal>Component</literal>):
 * The component number
 *
 * Member 1 (D-Bus type <literal>s</literal>,
 * named <literal>IP</literal>):
 * The IP address to use
 *
 * Member 2 (D-Bus type <literal>q</literal>,
 * named <literal>Port</literal>):
 * The port number to use
 *
 * Member 3 (D-Bus type <literal>a{sv}</literal>,
 * type <literal>Candidate_Info</literal>,
 * named <literal>Info</literal>):
 * Additional information about the candidate
 *
 */
#define GABBLE_STRUCT_TYPE_CANDIDATE (gabble_type_dbus_struct_usqa_7bsv_7d ())

/**
 * GABBLE_ARRAY_TYPE_CANDIDATE_LIST:

 * Expands to a call to a function
 * that returns the #GType of a #GPtrArray
 * of #GABBLE_STRUCT_TYPE_CANDIDATE.
 */
#define GABBLE_ARRAY_TYPE_CANDIDATE_LIST (gabble_type_dbus_array_usqa_7bsv_7d ())

/**
 * GABBLE_STRUCT_TYPE_STREAM_CREDENTIALS:

 * 
	A username/password pair.

 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(ss)</literal>.
 *
 * Member 0 (D-Bus type <literal>s</literal>,
 * named <literal>Username</literal>):
 * The username
 *
 * Member 1 (D-Bus type <literal>s</literal>,
 * named <literal>Password</literal>):
 * The password
 *
 */
#define GABBLE_STRUCT_TYPE_STREAM_CREDENTIALS (gabble_type_dbus_struct_ss ())

/**
 * GABBLE_STRUCT_TYPE_CALL_STATE_REASON:

 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;
	
        
	&lt;p&gt;
		A description of the reason for a change to the
          
		&lt;tp:member-ref&gt;
			CallState
		&lt;/tp:member-ref&gt;
		 and/or
          
		&lt;tp:member-ref&gt;
			CallFlags
		&lt;/tp:member-ref&gt;
		.
	&lt;/p&gt;
	
      

 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(uus)</literal>.
 *
 * Member 0 (D-Bus type <literal>u</literal>,
 * type <literal>Contact_Handle</literal>,
 * named <literal>Actor</literal>):
 * The contact responsible for the change, or 0 if no contact was           responsible.
 *
 * Member 1 (D-Bus type <literal>u</literal>,
 * type <literal>Call_State_Change_Reason</literal>,
 * named <literal>Reason</literal>):
 * The reason, chosen from a limited set of possibilities defined by           the Telepathy specification.
 *
 * Member 2 (D-Bus type <literal>s</literal>,
 * type <literal>DBus_Error_Name</literal>,
 * named <literal>DBus_Reason</literal>):
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;A specific reason for the change, which may be a D-Bus error in             the Telepathy namespace, a D-Bus error in any other namespace             (for implementation-specific errors), or the empty string to             indicate that the state change was not an error.&lt;/p&gt;            &lt;p&gt;This SHOULD be an empty string for changes to any state other             than Ended.&lt;/p&gt;            &lt;p&gt;The errors Cancelled and Terminated SHOULD NOT be used here;             an empty string SHOULD be used instead.&lt;/p&gt;            &lt;tp:rationale&gt;             &lt;p&gt;Those error names are used to indicate normal call               termination by the local user or another user, respectively,               in contexts where a D-Bus error name must appear.&lt;/p&gt;           &lt;/tp:rationale&gt;
 *
 */
#define GABBLE_STRUCT_TYPE_CALL_STATE_REASON (gabble_type_dbus_struct_uus ())

/**
 * GABBLE_STRUCT_TYPE_SASL_STATE:

 * 
	
          The status of the state.
        

 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(uss)</literal>.
 *
 * Member 0 (D-Bus type <literal>u</literal>,
 * type <literal>Sasl_Status</literal>,
 * named <literal>Status</literal>):
 * The status of the state.
 *
 * Member 1 (D-Bus type <literal>s</literal>,
 * type <literal>DBus_Error_Name</literal>,
 * named <literal>Reason</literal>):
 * The reason for the state.
 *
 * Member 2 (D-Bus type <literal>s</literal>,
 * named <literal>DebugMessage</literal>):
 * A non-localized debug message.
 *
 */
#define GABBLE_STRUCT_TYPE_SASL_STATE (gabble_type_dbus_struct_uss ())

/**
 * GABBLE_STRUCT_TYPE_SOCKET_ADDRESS_IP:

 * 
	An IP address and port.

 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(sq)</literal>.
 *
 * Member 0 (D-Bus type <literal>s</literal>,
 * named <literal>Address</literal>):
 * Either a dotted-quad IPv4 address literal as for         &lt;tp:type&gt;Socket_Address_IPv4&lt;/tp:type&gt;, or an RFC2373 IPv6 address         as for &lt;tp:type&gt;Socket_Address_IPv6&lt;/tp:type&gt;.
 *
 * Member 1 (D-Bus type <literal>q</literal>,
 * named <literal>Port</literal>):
 * The TCP or UDP port number.
 *
 */
#define GABBLE_STRUCT_TYPE_SOCKET_ADDRESS_IP (gabble_type_dbus_struct_sq ())

/**
 * GABBLE_ARRAY_TYPE_SOCKET_ADDRESS_IP_LIST:

 * Expands to a call to a function
 * that returns the #GType of a #GPtrArray
 * of #GABBLE_STRUCT_TYPE_SOCKET_ADDRESS_IP.
 */
#define GABBLE_ARRAY_TYPE_SOCKET_ADDRESS_IP_LIST (gabble_type_dbus_array_sq ())

/**
 * GABBLE_STRUCT_TYPE_SOCKET_ADDRESS_IPV4:

 * 
	An IPv4 address and port.

 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(sq)</literal>.
 *
 * Member 0 (D-Bus type <literal>s</literal>,
 * named <literal>Address</literal>):
 * A dotted-quad IPv4 address literal: four ASCII decimal         numbers, each between 0 and 255 inclusive, e.g.         &amp;quot;192.168.0.1&amp;quot;.
 *
 * Member 1 (D-Bus type <literal>q</literal>,
 * named <literal>Port</literal>):
 * The TCP or UDP port number.
 *
 */
#define GABBLE_STRUCT_TYPE_SOCKET_ADDRESS_IPV4 (gabble_type_dbus_struct_sq ())

/**
 * GABBLE_STRUCT_TYPE_SOCKET_ADDRESS_IPV6:

 * 
	An IPv6 address and port.

 *
 * This macro expands to a call to a function
 * that returns the #GType of a #GValueArray
 * appropriate for representing a D-Bus struct
 * with signature <literal>(sq)</literal>.
 *
 * Member 0 (D-Bus type <literal>s</literal>,
 * named <literal>Address</literal>):
 * An IPv6 address literal as specified by RFC2373         section 2.2, e.g. &amp;quot;2001:DB8::8:800:200C:4171&amp;quot;.
 *
 * Member 1 (D-Bus type <literal>q</literal>,
 * named <literal>Port</literal>):
 * The TCP or UDP port number.
 *
 */
#define GABBLE_STRUCT_TYPE_SOCKET_ADDRESS_IPV6 (gabble_type_dbus_struct_sq ())

GType gabble_type_dbus_struct_usqa_7bsv_7d (void);

GType gabble_type_dbus_struct_ss (void);

GType gabble_type_dbus_struct_sq (void);

GType gabble_type_dbus_struct_sua_28ss_29 (void);

GType gabble_type_dbus_struct_su (void);

GType gabble_type_dbus_struct_usuua_7bss_7d (void);

GType gabble_type_dbus_struct_oa_7bua_28usuua_7bss_7d_29_7d (void);

GType gabble_type_dbus_struct_uss (void);

GType gabble_type_dbus_struct_uus (void);

GType gabble_type_dbus_array_ss (void);

GType gabble_type_dbus_array_usuua_7bss_7d (void);

GType gabble_type_dbus_array_sq (void);

GType gabble_type_dbus_array_su (void);

GType gabble_type_dbus_array_usqa_7bsv_7d (void);

GType gabble_type_dbus_array_of_a_7bsv_7d (void);

GType gabble_type_dbus_array_of_a_7buu_7d (void);

