import os
import sys

import jhbuild.config
import distutils.sysconfig

import sysdeps


class Config(jhbuild.config.Config):

    def __init__(self, base_dir, rc_file):
        self.base_dir = base_dir
        jhbuild.config.Config.__init__(self, rc_file)
        self._setup()

    def _setup(self):
        # pylint: disable-msg=W0201
        self.autogenargs = ''

        self.checkoutroot = os.path.join(self.base_dir, 'source')
        self.tarballdir = os.path.join(self.base_dir, 'source')

        deps = sysdeps.get_packages()
        if not deps:
            sys.stderr.write('ERROR: Dependencies information is missing '
                '(unknown distribution/version).\n')
            sys.exit(126)

        for package_, source in deps:
            # pylint: disable-msg=E1101
            if source and source not in self.skip:
                self.skip.append(source)

    def setup_env(self):
        # Hack to replace the default prefix
        if self.prefix == '/opt/gnome':
            self.prefix = os.path.join(self.base_dir, 'install')

        #Hack to allow sugar-jhbuild to find its self again.

        MY_PATH = os.getenv('PATH', 'Error')
        os.environ["PATH"] = MY_PATH + ':' + self.base_dir

        jhbuild.config.Config.setup_env(self)

        jhbuild.config.addpath('XDG_DATA_DIRS', '/usr/share')
        jhbuild.config.addpath('XDG_DATA_DIRS',
            os.path.join(self.prefix, 'share'))

        jhbuild.config.addpath('GTK_PATH',
            os.path.join(self.prefix, ['lib', 'lib64'][self.use_lib64],
                'gtk-2.0', ''))
        jhbuild.config.addpath('GTK_DATA_PREFIX', self.prefix)

        os.environ['SUGAR_PREFIX'] = self.prefix
        os.environ['SUGAR_PATH'] = os.path.join(self.prefix, 'share', 'sugar')
        os.environ['SUGAR_LOCALEDIR'] = os.path.join(self.prefix, 'share', 'locale')
        os.environ.setdefault('SUGAR_LOGGER_LEVEL', 'debug')

        # Enable debug log of the Telepathy components
        os.environ.setdefault('GABBLE_DEBUG', 'all')
        os.environ.setdefault('SALUT_DEBUG', 'all')
        os.environ.setdefault('MC_DEBUG', 'all')
        os.environ.setdefault('STREAM_ENGINE_DEBUG', 'all')

        # We need to add the gtk-2.0 directory explicitly to
        # the Python path since '.pth' files (here pygtk.pth)
        # only work properly in system directories
        pythonlib = distutils.sysconfig.get_python_lib(prefix='')
        pythonpath_basic = pythonlib.split('/', 1)[1]
        jhbuild.config.addpath('PYTHONPATH',
            os.path.join(self.prefix, 'lib', pythonpath_basic, 'gtk-2.0'))
        jhbuild.config.addpath('PYTHONPATH',
            os.path.join(self.prefix, 'lib64', pythonpath_basic, 'gtk-2.0'))

        # workaround for bug in jhbuild
        # note: even for use_lib64 we need "lib" here as that's where
        # distutils installs to
        pythonpath_lib = os.path.join(self.prefix, 'lib', pythonpath_basic)
        jhbuild.config.addpath('PYTHONPATH', pythonpath_lib)

        os.environ['PYTHON_LIB'] = distutils.sysconfig.get_python_lib(
            prefix=self.prefix)

        os.environ['PYLINTRC'] = os.path.join(self.base_dir, 'scripts',
            'data', 'pylintrc')

        os.environ.pop('DBUS_SESSION_BUS_ADDRESS', '')
        # if set, it prevents translations from getting installed
        os.environ.pop('LINGUAS', '')

        if not 'SUGAR_PROFILE' in os.environ:
            os.environ['SUGAR_PROFILE'] = 'default'
