%{!?python_sitelib: %global python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print(get_python_lib())")}

Name: sugar-datastore
Version: 0.88.0
Release: 3.6uy%{?dist}
#Release: 2.%{alphatag}%{?dist}
Summary: Sugar Datastore

Group: Development/Libraries
License: GPLv2+
URL: http://sugarlabs.org/
Source0: http://download.sugarlabs.org/sources/sucrose/glucose/%{name}/%{name}-%{version}.tar.bz2

# Bug fixes
Patch1: sl2095-invert-datastore-clean-logic.patch
Patch2: sl2132-reduce-_FLUSH_TIMEOUT-to-5sec.patch
Patch3: sl2132-set-index_updated-flag-on-ds-shutting-down.patch

# aa's "sort by filesize" patch series
#Patch0: sizelist-0000-cover-letter.patch
Patch101: sizelist-0001-Add-filesize-property-to-the-index.patch
Patch102: sizelist-0002-Add-migration-code-from-DS-v0-for-the-filesize-prope.patch
Patch103: sizelist-0003-Check-filesize-property-on-index-rebuild.patch
Patch104: sizelist-0004-Add-ctime-property-to-the-index-and-datastore.patch
Patch105: sizelist-0005-Check-ctime-on-index-rebuild.patch
Patch106: sizelist-0006-Implement-migration-from-DS-v0-for-ctime-property.patch
Patch107: sizelist-0007-Increment-CURRENT_LAYOUT_VERSION-to-trigger-an-index.patch

# bug: 2149
Patch201: migration.patch

BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildRequires: python-devel

Requires: gnome-python2-gnomevfs
Requires: xapian-bindings-python
Requires: python-cjson

%description
sugar-datastore is a simple log like datastore able to connect with multiple
backends. The datastore supports connectionig and disconnecting from
backends on the fly to help the support the limit space/memory
characteristics of the OLPC system and the fact that network services
may become unavailable at times

%prep
%setup -q
%patch1 -p1
%patch2 -p1
%patch3 -p1

%patch101 -p1
%patch102 -p1
%patch103 -p1
%patch104 -p1
%patch105 -p1
%patch106 -p1
%patch107 -p1

%patch201 -p1

%build
%configure
make %{?_smp_mflags} V=1

%install
rm -rf %{buildroot}
make install DESTDIR=%{buildroot} INSTALL='install -p'

#Remove libtool archives.
find %{buildroot} -name '*.la' -exec rm -f {} ';'

%clean
rm -rf %{buildroot}

%files
%defattr(-,root,root,-)
%doc AUTHORS COPYING NEWS README
%{python_sitelib}/*
%{_bindir}/*
%{_datadir}/dbus-1/services/*.service

%changelog
* Mon Mar 29 2010 Peter Robinson <pbrobinson@gmail.com> - 0.88.0-1
- New upstream stable 0.88.0 release

* Wed Mar 10 2010 Sebastian Dziallas <sebastian@when.com> - 0.87.4-1
- New upstream release

* Tue Mar 09 2010 Sebastian Dziallas <sebastian@when.com> - 0.87.3-1
- #1787 rebuild index on migration

* Sat Jan  9 2010 Peter Robinson <pbrobinson@gmail.com> - 0.87.2-2
- Updated to the new python sysarch spec file reqs

* Wed Dec 23 2009 Sebastian Dziallas <sebastian@when.com> - 0.87.2-1
- New upstream release

* Fri Dec 18 2009 Peter Robinson <pbrobinson@gmail.com> 0.87.1-2
- Remove libtool archives

* Tue Dec 01 2009 Sebastian Dziallas <sebastian@when.com> - 0.87.1-1
- New upstream release

* Sun Sep 27 2009 Sebastian Dziallas <sebastian@when.com> - 0.86.0-1
- New upstream release

* Fri Sep 18 2009 Tomeu Vizoso <tomeu@sugarlabs.org> - 0.85.4-3
- Rename files in docs accordingly

* Fri Sep 18 2009 Tomeu Vizoso <tomeu@sugarlabs.org> - 0.85.4-2
- Upload sources

* Fri Sep 18 2009 Tomeu Vizoso <tomeu@sugarlabs.org> - 0.85.4-1
- New upstream release

* Fri Sep 11 2009 Simon Schampijer <simon@schampijer.de> - 0.85.3-1
- Fix memory leaks after many get_properties() ds calls #1240

* Wed Aug 26 2009 Tomeu Vizoso <tomeu@sugarlabs.org> - 0.85.2-1
- Update to new upstream release

* Fri Aug 07 2009 Simon Schampijer <simon@schampijer.de> - 0.85.1-1
- PEP8 compliance fixes #1108
- Rebuild index when an inconsistency between the index and the metadata is detected
- Implement sorting by timestamp and title
- Return a consistent entry count when some entries are missing (dsd)
- Don't include in find() results entries without metadata
- Remove title option (copy-from-journal) #896
- Only one dot for the filename if we specify an extension (copy-from-journal)

* Sun Jul 26 2009 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 0.84.0-2
- Rebuilt for https://fedoraproject.org/wiki/Fedora_12_Mass_Rebuild

* Tue Mar 03 2009 Simon Schampijer <simon@schampijer.de> - 0.84.0-1
- Rebuild for 0.84

* Wed Feb 25 2009 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 0.83.3-2
- Rebuilt for https://fedoraproject.org/wiki/Fedora_11_Mass_Rebuild

* Wed Feb 04 2009 Simon Schampijer <simon@schampijer.de> - 0.83.3-1
- Only try to remove the checksum dir if it already exists
- Rename the installed package from olpc.datastore to carquinyol

* Fri Jan 30 2009 Simon Schampijer <simon@schampijer.de> - 0.83.2-2.20090130gite999c1c1e1
- Only try to remove the checksum dir if it already exists

* Tue Jan 20 2009 Marco Pesenti Gritti <mpg@redhat.com> - 0.83.2-1
- #181 Replace deprecated os.popen by subprocess
- #140 Crash when joining a shared Read 

* Sun Jan 04 2009 Simon Schampijer <simon@laptop.org> - 0.83.1-1
- contains a bunch of stability and robustness improvements 

* Sat Nov 29 2008 Ignacio Vazquez-Abrams <ivazqueznet+rpm@gmail.com> - 0.83.0-2
- Rebuild for Python 2.6

* Tue Nov  4 2008 Marco Pesenti Gritti <mpg@redhat.com> - 0.83.1-1
- Update to 0.83.1

* Sat Sep  6 2008 Tom "spot" Callaway <tcallawa@redhat.com> - 0.8.3-2
- fix license tag

* Tue Jul 08 2008 Tomeu Vizoso <tomeu@tomeuvizoso.net> - 0.8.3-1
- Update to 0.8.3

* Fri Jun 13 2008 Simon Schampijer <simon@laptop.org> - 0.8.1-1
- Update to 0.8.1

* Tue Dec 11 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.6.0-1
- Fix #5218 #5254

* Wed Dec  5 2007 Marco Pesenti Gritti <marco@localhost.localdomain> - 0.5-1
- Update to 0.5

* Tue Nov 20 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.3-1
- Update to 0.3

* Wed Nov 14 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.2-0.40.20071114gitea0764a9e9
- #4662 Add the 'source' property to the model. (marco)
- #4558 Correctly encode characters in URI. (tomeu)

* Wed Nov 14 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.2-0.39.20071114gita42f40d575
- #4784 Use valid FAT names when saving entries to usb sticks. (tomeu)

* Mon Nov 12 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.2-0.38.20071112git6d3d607ec7
- #4783 Try harder to guess the file extension. (tomeu)
- #4796 Ignore failure to chmod files in usb sticks. (tomeu)

* Fri Nov 09 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.2-0.37.20071109git62a5c30d81
- Copy files to the profile dir when asked by an out-of-container process. (tomeu)

* Wed Nov 07 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.2-0.36.20071107git3b70954e71
- #3801 Check out files in the activity instance dir with the correct
  permissions. (tomeu)
- #4704 Fix copy of entries with file to removable devices. (tomeu)
- #4714 Fix copy of entries without file to removable devices. (tomeu)

* Tue Nov 06 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.2-0.35.20071106git74cbc13878
- #4654 Hard link files on check out instead of copying if possible. (tomeu)

* Fri Nov 02 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.2-0.34.20071102git2b5596554c
- #4234 Fix copying a download to an usb stick. (marco)

* Tue Oct  9 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.2-0.33.20071009gitcb0acdf653
- New snapshot

* Sun Oct  7 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.2-0.32.20071007gitb603f340b2
- New snapshot

* Sat Oct  6 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.2-0.31.20071005git23becaa683
- New snapshot

* Fri Oct  5 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.2-0.30.20071005git64abebe398
- New snapshot

* Fri Oct  5 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.2-0.29.20071005git87204de5b9
- New snapshot

* Thu Oct  4 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.2-0.28.20071004git902883ab7c
- New snapshot

* Thu Oct  4 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.2-0.27.20071004git23f5b3439e
- New snapshot

* Thu Sep 20 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.2-0.26.20070920gitdce9c18d56
- New snapshot

* Wed Sep 19 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.2-0.25.20070919git11013dc3ca
- New snapshot

* Tue Sep 18 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.2-0.24.20070918git48ab782a01
- New snapshot

* Fri Sep 14 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.2-0.23.20070914gitea13f75d6a
- New snapshot

* Wed Sep 12 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.2-0.22.20070912git7655f4d99a
- New snapshot

* Tue Sep 11 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.2-0.21.20070911gitb0b4c4115a
- New snapshot

* Mon Sep 10 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.2-0.20.20070910git617bf5d005
- New snapshot

* Sun Sep 09 2007 Dan Williams <dcbw@redhat.com> - 0.2.2-0.19.20070909git0a7e80f01a
- New snapshot (async writes and ownership transfer on update/create)

* Wed Aug 01 2007 Dan Williams <dcbw@redhat.com> - 0.2.2-0.18.20070801gita111996299
- New snapshot (fix #2607)

* Tue Jul 31 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.2-0.18.20070731git356b35a278
- New snapshot

* Sun Jul 29 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.2-0.17.20070729git4a4283978f
- New snapshot

* Fri Jul 27 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.2-0.16.20070727gitd0bcbf67d1
- New snapshot

* Wed Jul 25 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.2-0.15.20070725git30ce1b1378
- New snapshot

* Mon Jul 23 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.2-0.14.20070723git00570bc517
- New snapshot

* Sat Jul 21 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.2-0.13.20070720git033d224d3b
- New snapshot

* Fri Jul 20 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.2-0.12.20070720gite30379af95
- New snapshot

* Thu Jul 19 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.2-0.11.20070719git9aabdfb24b
- New snapshot

* Wed Jul 18 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.2-0.2.20070718git535d9835e2
- New snapshot

* Tue Jul 17 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.2-0.10.20070716git2978ff86bd
- New snapshot

* Tue Jul 17 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.2-0.9.20070716git643ac4dad8
- New snapshot

* Mon Jul 16 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.2-0.8.20070715git6666e28e60
- New snapshot

* Fri Jul 13 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.2-0.7.20070713git33bf60bb4f
- Remove dependencies on sqlalchemy and pyxapian
- New snapshot

* Fri Jul  6 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.2-0.6.20070705git18b7951026
- Full indexing refactor
- Support or in the queries

* Tue Jul  3 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.2-0.5.20070703gita248b5cb79
- Support for binary properties
- Indexer fixes
- External devices fixes

* Thu Jun 28 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.2-0.4.20070628gitd23ee8a383
- New snapshot

* Wed Jun 27 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.2-0.3.20070627gitf5a5d0ff66
- New snapshot

* Tue Jun 26 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.2-0.2.20070626git30c1a1abb8
- New snapshot

* Wed Jun 20 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.2-0.1.20070620git49f3211d34
- Update to 0.2.2
- Fix rpmlint complaints

* Mon Jun  4 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.1-3.git8d46929bf7.1
- New snapshot

* Wed May 30 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.0-2.gita7ec17405d
- Fix locks

* Tue May 29 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.0-1.9.20070529git
- New snapshot

* Tue May 16 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.0-1.9.20070516.2git
- Remove setuptools again

* Tue May 16 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.0-1.9.20070516git
- More performance work

* Tue May 15 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.0-1.7.20070515git
- Performance fix

* Mon May 14 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.0-1.7.20070514git.4
- Disable indexer, fix empty files

* Mon May 14 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.0-1.7.20070514git.3
- Fixes

* Mon May 14 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.0-1.7.20070514git.2
- Fix startup

* Mon May 14 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.0-1.7.20070514git
- New snapshot, use auto*

* Thu May 11 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.0-1.6.20070511git
- Fix service path

* Thu May 11 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.0-1.5.20070511git
- Update snapshot

* Thu May 10 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.0-1.4.20070510git
- Require pyxapian

* Thu May 10 2007 Marco Pesenti Gritti <mpg@redhat.com> - 0.2.0-1.3.20070510git
- Initial build
