#!/bin/sh

# Copyright (C) 2009 Nokia Corporation
# Copyright (C) 2009 Collabora Ltd.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
# 02110-1301 USA

cd "/home/anish/sugar-jhbuild-dx1.5-uy/source/telepathy-mission-control-5.6.1/test/twisted/tools"

ulimit -c unlimited
exec > missioncontrol-$$.log 2>&1
ln -f missioncontrol-$$.log missioncontrol.log

if test -z "$MC_ACCOUNT_DIR"; then
        echo "MC_ACCOUNT_DIR must be set"
        exit 1
fi

if test -n "$MISSIONCONTROL_TEST_VALGRIND"; then
        G_DEBUG="$G_DEBUG,gc-friendly"
        export G_DEBUG
        G_SLICE=always-malloc
        export G_SLICE
	MISSIONCONTROL_WRAPPER="valgrind --leak-check=full --num-callers=20"
	MISSIONCONTROL_WRAPPER="$MISSIONCONTROL_WRAPPER --track-origins=yes"
	MISSIONCONTROL_WRAPPER="$MISSIONCONTROL_WRAPPER -v"
	MISSIONCONTROL_WRAPPER="$MISSIONCONTROL_WRAPPER --suppressions=/home/anish/sugar-jhbuild-dx1.5-uy/source/telepathy-mission-control-5.6.1/test/twisted/tools/valgrind.supp"
	MISSIONCONTROL_WRAPPER="$MISSIONCONTROL_WRAPPER --gen-suppressions=all"
	MISSIONCONTROL_WRAPPER="$MISSIONCONTROL_WRAPPER --show-reachable=yes"
elif test -n "$MISSIONCONTROL_TEST_REFDBG"; then
        if test -z "$REFDBG_OPTIONS" ; then
                REFDBG_OPTIONS="btnum=10"
                export REFDBG_OPTIONS
        fi
        if test -z "$MISSIONCONTROL_WRAPPER" ; then
                MISSIONCONTROL_WRAPPER="refdbg"
        fi
fi

if test "z$MC_EXECUTABLE" = z; then
        MC_EXECUTABLE=/home/anish/sugar-jhbuild-dx1.5-uy/source/telepathy-mission-control-5.6.1/test/twisted/mc-debug-server
fi

if test -f "$MC_ACCOUNT_DIR/gnome-keyring-env"; then
        cat "$MC_ACCOUNT_DIR/gnome-keyring-env"
        . "$MC_ACCOUNT_DIR/gnome-keyring-env"
        export GNOME_KEYRING_CONTROL GNOME_KEYRING_PID MC_KEYRING_NAME SSH_AUTH_SOCK
fi

exec /home/anish/sugar-jhbuild-dx1.5-uy/source/telepathy-mission-control-5.6.1/libtool --mode=execute \
        $MISSIONCONTROL_WRAPPER \
        $MC_EXECUTABLE
