#include "_gen/svc-Account_Interface_Stats.h"

#include <telepathy-glib/dbus.h>
#include "_gen/signals-marshal.h"

static const DBusGObjectInfo _mc_svc_account_interface_stats_object_info;

struct _McSvcAccountInterfaceStatsClass {
    GTypeInterface parent_class;
};

enum {
    SIGNAL_ACCOUNT_INTERFACE_STATS_StatsChanged,
    N_ACCOUNT_INTERFACE_STATS_SIGNALS
};
static guint account_interface_stats_signals[N_ACCOUNT_INTERFACE_STATS_SIGNALS] = {0};

static void mc_svc_account_interface_stats_base_init (gpointer klass);

GType
mc_svc_account_interface_stats_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (McSvcAccountInterfaceStatsClass),
        mc_svc_account_interface_stats_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "McSvcAccountInterfaceStats", &info, 0);
    }

  return type;
}

/**
 * mc_svc_account_interface_stats_emit_stats_changed:
 * @instance: The object implementing this interface
 * @arg_Properties: GHashTable * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * StatsChanged signal on interface com.nokia.Account.Interface.Stats.
 */
void
mc_svc_account_interface_stats_emit_stats_changed (gpointer instance,
    GHashTable *arg_Properties)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, MC_TYPE_SVC_ACCOUNT_INTERFACE_STATS));
  g_signal_emit (instance,
      account_interface_stats_signals[SIGNAL_ACCOUNT_INTERFACE_STATS_StatsChanged],
      0,
      arg_Properties);
}

static inline void
mc_svc_account_interface_stats_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  static TpDBusPropertiesMixinPropInfo properties[2] = {
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "a{su}", 0, NULL, NULL }, /* ChannelCount */
      { 0, 0, NULL, 0, NULL, NULL }
  };
  static TpDBusPropertiesMixinIfaceInfo interface =
      { 0, properties, NULL, NULL };

  dbus_g_object_type_install_info (mc_svc_account_interface_stats_get_type (),
      &_mc_svc_account_interface_stats_object_info);

  interface.dbus_interface = g_quark_from_static_string ("com.nokia.Account.Interface.Stats");
  properties[0].name = g_quark_from_static_string ("ChannelCount");
  properties[0].type = (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_UINT));
  tp_svc_interface_set_dbus_properties_info (MC_TYPE_SVC_ACCOUNT_INTERFACE_STATS, &interface);

  /**
   * McSvcAccountInterfaceStats::stats-changed:
   * @arg_Properties: GHashTable * (FIXME, generate documentation)
   *
   * The StatsChanged D-Bus signal is emitted whenever this GObject signal is.
   */
  account_interface_stats_signals[SIGNAL_ACCOUNT_INTERFACE_STATS_StatsChanged] =
  g_signal_new ("stats-changed",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      g_cclosure_marshal_VOID__BOXED,
      G_TYPE_NONE,
      1,
      (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)));

}
static void
mc_svc_account_interface_stats_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      mc_svc_account_interface_stats_base_init_once (klass);
    }
}
static const DBusGMethodInfo _mc_svc_account_interface_stats_methods[] = {
  { NULL, NULL, 0 }
};

static const DBusGObjectInfo _mc_svc_account_interface_stats_object_info = {
  0,
  _mc_svc_account_interface_stats_methods,
  0,
"\0",
"com.nokia.Account.Interface.Stats\0StatsChanged\0\0",
"\0\0",
};


