/* We don't want gtkdoc scanning this file, it'll get
 * confused by seeing function definitions, so mark it as: */
/*<private_header>*/

static inline void
mc_cli_add_signals_for_connection_interface_contact_capabilities (DBusGProxy *proxy)
{
  if (!tp_proxy_dbus_g_proxy_claim_for_signal_adding (proxy))
    return;
  dbus_g_proxy_add_signal (proxy, "ContactCapabilitiesChanged",
      (dbus_g_type_get_map ("GHashTable", G_TYPE_UINT, (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)), G_TYPE_STRV, G_TYPE_INVALID)))))),
      G_TYPE_INVALID);
}


/**
 * mc_cli_connection_interface_contact_capabilities_signal_callback_contact_capabilities_changed:
 * @proxy: The proxy on which mc_cli_connection_interface_contact_capabilities_connect_to_contact_capabilities_changed ()
 *  was called
 * @arg_caps: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           All the capabilities of the contacts
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal ContactCapabilitiesChanged.
 */
static void
_mc_cli_connection_interface_contact_capabilities_collect_args_of_contact_capabilities_changed (DBusGProxy *proxy G_GNUC_UNUSED,
    GHashTable *arg_caps,
    TpProxySignalConnection *sc)
{
  GValueArray *args = g_value_array_new (1);
  GValue blank = { 0 };
  guint i;

  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 1; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, (dbus_g_type_get_map ("GHashTable", G_TYPE_UINT, (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)), G_TYPE_STRV, G_TYPE_INVALID)))))));
  g_value_set_boxed (args->values + 0, arg_caps);

  tp_proxy_signal_connection_v0_take_results (sc, args);
}
static void
_mc_cli_connection_interface_contact_capabilities_invoke_callback_for_contact_capabilities_changed (TpProxy *tpproxy,
    GError *error G_GNUC_UNUSED,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  mc_cli_connection_interface_contact_capabilities_signal_callback_contact_capabilities_changed callback =
      (mc_cli_connection_interface_contact_capabilities_signal_callback_contact_capabilities_changed) generic_callback;

  if (callback != NULL)
    callback (g_object_ref (tpproxy),
      g_value_get_boxed (args->values + 0),
      user_data,
      weak_object);

  g_value_array_free (args);
  g_object_unref (tpproxy);
}
/**
 * mc_cli_connection_interface_contact_capabilities_connect_to_contact_capabilities_changed:
 * @proxy: A #TpProxy or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal ContactCapabilitiesChanged.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Announce that there has been a change of capabilities on the           given handles. A single signal can be emitted for several         contacts.&lt;/p&gt;          &lt;tp:rationale&gt;           &lt;p&gt;The underlying protocol can get several contacts&apos; capabilities at             the same time.&lt;/p&gt;         &lt;/tp:rationale&gt;
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */
TpProxySignalConnection *
mc_cli_connection_interface_contact_capabilities_connect_to_contact_capabilities_changed (gpointer proxy,
    mc_cli_connection_interface_contact_capabilities_signal_callback_contact_capabilities_changed callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object,
    GError **error)
{
  GType expected_types[2] = {
      (dbus_g_type_get_map ("GHashTable", G_TYPE_UINT, (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)), G_TYPE_STRV, G_TYPE_INVALID)))))),
      G_TYPE_INVALID };

  g_return_val_if_fail (TP_IS_PROXY (proxy), NULL);
  g_return_val_if_fail (callback != NULL, NULL);

  return tp_proxy_signal_connection_v0_new ((TpProxy *) proxy,
      MC_IFACE_QUARK_CONNECTION_INTERFACE_CONTACT_CAPABILITIES, "ContactCapabilitiesChanged",
      expected_types,
      G_CALLBACK (_mc_cli_connection_interface_contact_capabilities_collect_args_of_contact_capabilities_changed),
      _mc_cli_connection_interface_contact_capabilities_invoke_callback_for_contact_capabilities_changed,
      G_CALLBACK (callback), user_data, destroy,
      weak_object, error);
}

/**
 * mc_cli_connection_interface_contact_capabilities_callback_for_update_capabilities:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a UpdateCapabilities method call
 * succeeds or fails.
 */
static void
_mc_cli_connection_interface_contact_capabilities_collect_callback_update_capabilities (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;

  dbus_g_proxy_end_call (proxy, call, &error,
      G_TYPE_INVALID);
  tp_proxy_pending_call_v0_take_results (user_data, error,NULL);
}
static void
_mc_cli_connection_interface_contact_capabilities_invoke_callback_update_capabilities (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  mc_cli_connection_interface_contact_capabilities_callback_for_update_capabilities callback = (mc_cli_connection_interface_contact_capabilities_callback_for_update_capabilities) generic_callback;

  if (error != NULL)
    {
      callback ((TpProxy *) self,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((TpProxy *) self,
      error, user_data, weak_object);

  if (args != NULL)
    g_value_array_free (args);
}

/**
 * mc_cli_connection_interface_contact_capabilities_call_update_capabilities:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Handler_Capabilities: Used to pass an 'in' argument: &lt;p&gt;The capabilities of one or more clients.&lt;/p&gt;            &lt;p&gt;For each client in the given list, any capabilities previously             advertised for the same client name are discarded, then replaced by             the capabilities indicated.&lt;/p&gt;            &lt;p&gt;As a result, if a client becomes unavailable, this method SHOULD             be called with a &lt;tp:type&gt;Handler_Capabilities&lt;/tp:type&gt; structure             containing its name, an empty list of channel classes, and an             empty list of capabilities. When this is done, the connection             manager SHOULD free all memory associated with that client name.&lt;/p&gt;            &lt;tp:rationale&gt;             &lt;p&gt;This method takes a list of clients so that               when the channel dispatcher first calls it (with a list of all               the Handlers that are initially available), the changes can be               made atomically, with only one transmission of updated               capabilities to the network. Afterwards, the channel dispatcher               will call this method with a single-element list every time               a Handler becomes available or unavailable.&lt;/p&gt;           &lt;/tp:rationale&gt;            &lt;p&gt;The connection manager MUST ignore any channel classes and client             capabilities for which there is no representation in the protocol             or no support in the connection manager.&lt;/p&gt;
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a UpdateCapabilities method call.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Alter the connection&apos;s advertised capabilities to include           the intersection of the given clients&apos; capabilities with what the           connection manager is able to implement.&lt;/p&gt;          &lt;p&gt;On connections managed by the ChannelDispatcher, processes other           than the ChannelDispatcher SHOULD NOT call this method, and the           ChannelDispatcher SHOULD use this method to advertise the           capabilities of all the registered &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy&quot;&gt;Client.Handler&lt;/tp:dbus-ref&gt;           implementations.On connections not managed by the ChannelDispatcher,           clients MAY use this method directly, to indicate the channels they           will handle and the extra capabilities they have.&lt;/p&gt;          &lt;p&gt;Upon a successful invocation of this method, the connection manager           will only emit the           &lt;tp:member-ref&gt;ContactCapabilitiesChanged&lt;/tp:member-ref&gt; signal           for the user&apos;s &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Connection&quot;&gt;SelfHandle&lt;/tp:dbus-ref&gt;           if, in the underlying protocol, the new capabilities are distinct           from the previous state.&lt;/p&gt;          &lt;tp:rationale&gt;           &lt;p&gt;The connection manager will essentially intersect the provided             capabilities and the channel classes it implements. Therefore,             certain properties which are never fixed for a channel class             (such as the target handle, or the Parameters property of a tube             channel) will almost certainly not be advertised.&lt;/p&gt;         &lt;/tp:rationale&gt;          &lt;p&gt;This method MAY be called on a newly-created connection while it           is still in the DISCONNECTED state, to request that when the           connection connects, it will do so with the appropriate           capabilities. Doing so MUST NOT fail.&lt;/p&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */
TpProxyPendingCall *
mc_cli_connection_interface_contact_capabilities_call_update_capabilities (gpointer proxy,
    gint timeout_ms,
    const GPtrArray *in_Handler_Capabilities,
    mc_cli_connection_interface_contact_capabilities_callback_for_update_capabilities callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = MC_IFACE_QUARK_CONNECTION_INTERFACE_CONTACT_CAPABILITIES;
  DBusGProxy *iface;

  g_return_val_if_fail (TP_IS_PROXY (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "UpdateCapabilities",
          (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_STRING, (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)))), G_TYPE_STRV, G_TYPE_INVALID)))), in_Handler_Capabilities,
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "UpdateCapabilities", iface,
          _mc_cli_connection_interface_contact_capabilities_invoke_callback_update_capabilities,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "UpdateCapabilities",
              _mc_cli_connection_interface_contact_capabilities_collect_callback_update_capabilities,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_STRING, (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)))), G_TYPE_STRV, G_TYPE_INVALID)))), in_Handler_Capabilities,
              G_TYPE_INVALID));

      return data;
    }
}


/**
 * mc_cli_connection_interface_contact_capabilities_callback_for_get_contact_capabilities:
 * @proxy: the proxy on which the call was made
 * @out_Contact_Capabilities: Used to return an 'out' argument if @error is %NULL: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           An array of structures containing:           &lt;ul&gt;             &lt;li&gt;a dictionary mapping the channel properties to their values.&lt;/li&gt;             &lt;li&gt;an array of additional allowed properties&lt;/li&gt;           &lt;/ul&gt;
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetContactCapabilities method call
 * succeeds or fails.
 */
static void
_mc_cli_connection_interface_contact_capabilities_collect_callback_get_contact_capabilities (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;
  GValueArray *args;
  GValue blank = { 0 };
  guint i;
  GHashTable *out_Contact_Capabilities;

  dbus_g_proxy_end_call (proxy, call, &error,
      (dbus_g_type_get_map ("GHashTable", G_TYPE_UINT, (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)), G_TYPE_STRV, G_TYPE_INVALID)))))), &out_Contact_Capabilities,
      G_TYPE_INVALID);

  if (error != NULL)
    {
      tp_proxy_pending_call_v0_take_results (user_data, error,
          NULL);
      return;
    }

  args = g_value_array_new (1);
  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 1; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, (dbus_g_type_get_map ("GHashTable", G_TYPE_UINT, (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)), G_TYPE_STRV, G_TYPE_INVALID)))))));
  g_value_take_boxed (args->values + 0, out_Contact_Capabilities);
  tp_proxy_pending_call_v0_take_results (user_data, NULL, args);
}
static void
_mc_cli_connection_interface_contact_capabilities_invoke_callback_get_contact_capabilities (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  mc_cli_connection_interface_contact_capabilities_callback_for_get_contact_capabilities callback = (mc_cli_connection_interface_contact_capabilities_callback_for_get_contact_capabilities) generic_callback;

  if (error != NULL)
    {
      callback ((TpProxy *) self,
          NULL,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((TpProxy *) self,
      g_value_get_boxed (args->values + 0),
      error, user_data, weak_object);

  g_value_array_free (args);
}

/**
 * mc_cli_connection_interface_contact_capabilities_call_get_contact_capabilities:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_handles: Used to pass an 'in' argument: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;An array of contact handles for this connection.&lt;/p&gt;            &lt;p&gt;The handle zero MUST NOT be included in the request.&lt;/p&gt;
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetContactCapabilities method call.
 *
 * Returns an array of enhanced capabilities for the given contact handles.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */
TpProxyPendingCall *
mc_cli_connection_interface_contact_capabilities_call_get_contact_capabilities (gpointer proxy,
    gint timeout_ms,
    const GArray *in_handles,
    mc_cli_connection_interface_contact_capabilities_callback_for_get_contact_capabilities callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = MC_IFACE_QUARK_CONNECTION_INTERFACE_CONTACT_CAPABILITIES;
  DBusGProxy *iface;

  g_return_val_if_fail (TP_IS_PROXY (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            0,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "GetContactCapabilities",
          DBUS_TYPE_G_UINT_ARRAY, in_handles,
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "GetContactCapabilities", iface,
          _mc_cli_connection_interface_contact_capabilities_invoke_callback_get_contact_capabilities,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "GetContactCapabilities",
              _mc_cli_connection_interface_contact_capabilities_collect_callback_get_contact_capabilities,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              DBUS_TYPE_G_UINT_ARRAY, in_handles,
              G_TYPE_INVALID));

      return data;
    }
}


/*
 * mc_cli_Connection_Interface_Contact_Capabilities_add_signals:
 * @self: the #TpProxy
 * @quark: a quark whose string value is the interface
 *   name whose signals should be added
 * @proxy: the D-Bus proxy to which to add the signals
 * @unused: not used for anything
 *
 * Tell dbus-glib that @proxy has the signatures of all
 * signals on the given interface, if it's one we
 * support.
 *
 * This function should be used as a signal handler for
 * #TpProxy::interface-added.
 */
static void
mc_cli_Connection_Interface_Contact_Capabilities_add_signals (TpProxy *self G_GNUC_UNUSED,
    guint quark,
    DBusGProxy *proxy,
    gpointer unused G_GNUC_UNUSED)
{
  if (quark == MC_IFACE_QUARK_CONNECTION_INTERFACE_CONTACT_CAPABILITIES)
    mc_cli_add_signals_for_connection_interface_contact_capabilities (proxy);
}
