/* We don't want gtkdoc scanning this file, it'll get
 * confused by seeing function definitions, so mark it as: */
/*<private_header>*/

static inline void
mc_cli_add_signals_for_account (DBusGProxy *proxy)
{
  if (!tp_proxy_dbus_g_proxy_claim_for_signal_adding (proxy))
    return;
  dbus_g_proxy_add_signal (proxy, "Removed",
      G_TYPE_INVALID);
  dbus_g_proxy_add_signal (proxy, "AccountPropertyChanged",
      (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)),
      G_TYPE_INVALID);
}


/**
 * mc_cli_account_signal_callback_removed:
 * @proxy: The proxy on which mc_cli_account_connect_to_removed ()
 *  was called
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal Removed.
 */
static void
_mc_cli_account_invoke_callback_for_removed (TpProxy *tpproxy,
    GError *error G_GNUC_UNUSED,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  mc_cli_account_signal_callback_removed callback =
      (mc_cli_account_signal_callback_removed) generic_callback;

  if (callback != NULL)
    callback (g_object_ref (tpproxy),
      user_data,
      weak_object);

  if (args != NULL)
    g_value_array_free (args);

  g_object_unref (tpproxy);
}
/**
 * mc_cli_account_connect_to_removed:
 * @proxy: A #TpProxy or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal Removed.
 *
 * This account has been removed.          &lt;tp:rationale&gt;           This is redundant with &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.AccountManager&quot;&gt;AccountRemoved&lt;/tp:dbus-ref&gt;,           but it&apos;s still worth having,           to avoid having to bind to AccountManager.AccountRemoved to tell           you whether your Account is valid — ideally, an account-editing UI           should only care about a single Account.         &lt;/tp:rationale&gt;
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */
TpProxySignalConnection *
mc_cli_account_connect_to_removed (gpointer proxy,
    mc_cli_account_signal_callback_removed callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object,
    GError **error)
{
  GType expected_types[1] = {
      G_TYPE_INVALID };

  g_return_val_if_fail (TP_IS_PROXY (proxy), NULL);
  g_return_val_if_fail (callback != NULL, NULL);

  return tp_proxy_signal_connection_v0_new ((TpProxy *) proxy,
      MC_IFACE_QUARK_ACCOUNT, "Removed",
      expected_types,
      NULL, /* no args => no collector function */
      _mc_cli_account_invoke_callback_for_removed,
      G_CALLBACK (callback), user_data, destroy,
      weak_object, error);
}

/**
 * mc_cli_account_signal_callback_account_property_changed:
 * @proxy: The proxy on which mc_cli_account_connect_to_account_property_changed ()
 *  was called
 * @arg_Properties: A map from property names in this namespace (e.g.           &lt;tp:member-ref&gt;Nickname&lt;/tp:member-ref&gt;) to           values. Properties whose values have not changed SHOULD be           omitted, but this need not be done.
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal AccountPropertyChanged.
 */
static void
_mc_cli_account_collect_args_of_account_property_changed (DBusGProxy *proxy G_GNUC_UNUSED,
    GHashTable *arg_Properties,
    TpProxySignalConnection *sc)
{
  GValueArray *args = g_value_array_new (1);
  GValue blank = { 0 };
  guint i;

  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 1; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)));
  g_value_set_boxed (args->values + 0, arg_Properties);

  tp_proxy_signal_connection_v0_take_results (sc, args);
}
static void
_mc_cli_account_invoke_callback_for_account_property_changed (TpProxy *tpproxy,
    GError *error G_GNUC_UNUSED,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  mc_cli_account_signal_callback_account_property_changed callback =
      (mc_cli_account_signal_callback_account_property_changed) generic_callback;

  if (callback != NULL)
    callback (g_object_ref (tpproxy),
      g_value_get_boxed (args->values + 0),
      user_data,
      weak_object);

  g_value_array_free (args);
  g_object_unref (tpproxy);
}
/**
 * mc_cli_account_connect_to_account_property_changed:
 * @proxy: A #TpProxy or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal AccountPropertyChanged.
 *
 * The values of one or more properties on this interface (that do not         specify that this signal does not apply to them) may have changed.         This does not cover properties of other interfaces, which must         provide their own change notification if appropriate.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */
TpProxySignalConnection *
mc_cli_account_connect_to_account_property_changed (gpointer proxy,
    mc_cli_account_signal_callback_account_property_changed callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object,
    GError **error)
{
  GType expected_types[2] = {
      (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)),
      G_TYPE_INVALID };

  g_return_val_if_fail (TP_IS_PROXY (proxy), NULL);
  g_return_val_if_fail (callback != NULL, NULL);

  return tp_proxy_signal_connection_v0_new ((TpProxy *) proxy,
      MC_IFACE_QUARK_ACCOUNT, "AccountPropertyChanged",
      expected_types,
      G_CALLBACK (_mc_cli_account_collect_args_of_account_property_changed),
      _mc_cli_account_invoke_callback_for_account_property_changed,
      G_CALLBACK (callback), user_data, destroy,
      weak_object, error);
}

/**
 * mc_cli_account_callback_for_remove:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a Remove method call
 * succeeds or fails.
 */
static void
_mc_cli_account_collect_callback_remove (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;

  dbus_g_proxy_end_call (proxy, call, &error,
      G_TYPE_INVALID);
  tp_proxy_pending_call_v0_take_results (user_data, error,NULL);
}
static void
_mc_cli_account_invoke_callback_remove (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  mc_cli_account_callback_for_remove callback = (mc_cli_account_callback_for_remove) generic_callback;

  if (error != NULL)
    {
      callback ((TpProxy *) self,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((TpProxy *) self,
      error, user_data, weak_object);

  if (args != NULL)
    g_value_array_free (args);
}

/**
 * mc_cli_account_call_remove:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a Remove method call.
 *
 * Delete the account.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */
TpProxyPendingCall *
mc_cli_account_call_remove (gpointer proxy,
    gint timeout_ms,
    mc_cli_account_callback_for_remove callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = MC_IFACE_QUARK_ACCOUNT;
  DBusGProxy *iface;

  g_return_val_if_fail (TP_IS_PROXY (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "Remove",
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "Remove", iface,
          _mc_cli_account_invoke_callback_remove,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "Remove",
              _mc_cli_account_collect_callback_remove,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              G_TYPE_INVALID));

      return data;
    }
}


/**
 * mc_cli_account_callback_for_update_parameters:
 * @proxy: the proxy on which the call was made
 * @out_Reconnect_Required: Used to return an 'out' argument if @error is %NULL: A list of the names of parameters with changes that will not take           effect until the account is reconnected (this may be empty, e.g. if           all the parameters are D-Bus properties or parameters for which the           account manager has specific support). User interfaces that           require &amp;quot;instant apply&amp;quot; semantics MAY call           &lt;tp:member-ref&gt;Reconnect&lt;/tp:member-ref&gt; in response to receiving           a non-empty list.
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a UpdateParameters method call
 * succeeds or fails.
 */
static void
_mc_cli_account_collect_callback_update_parameters (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;
  GValueArray *args;
  GValue blank = { 0 };
  guint i;
  gchar **out_Reconnect_Required;

  dbus_g_proxy_end_call (proxy, call, &error,
      G_TYPE_STRV, &out_Reconnect_Required,
      G_TYPE_INVALID);

  if (error != NULL)
    {
      tp_proxy_pending_call_v0_take_results (user_data, error,
          NULL);
      return;
    }

  args = g_value_array_new (1);
  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 1; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, G_TYPE_STRV);
  g_value_take_boxed (args->values + 0, out_Reconnect_Required);
  tp_proxy_pending_call_v0_take_results (user_data, NULL, args);
}
static void
_mc_cli_account_invoke_callback_update_parameters (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  mc_cli_account_callback_for_update_parameters callback = (mc_cli_account_callback_for_update_parameters) generic_callback;

  if (error != NULL)
    {
      callback ((TpProxy *) self,
          NULL,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((TpProxy *) self,
      g_value_get_boxed (args->values + 0),
      error, user_data, weak_object);

  g_value_array_free (args);
}

/**
 * mc_cli_account_call_update_parameters:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Set: Used to pass an 'in' argument: A mapping from parameter names to their values. These parameters           should be stored for future use.
 * @in_Unset: Used to pass an 'in' argument: A list of the names of parameters to be removed from the set of           stored values, allowing the default values to be used.           If the given parameters were not, in fact, stored, or even if they           do not exist at all, the account manager MUST accept this without           error.
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a UpdateParameters method call.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Change the value of the &lt;tp:member-ref&gt;Parameters&lt;/tp:member-ref&gt;           property.&lt;/p&gt;          &lt;p&gt;If any of the changed parameters&apos;           &lt;tp:type&gt;Conn_Mgr_Param_Flags&lt;/tp:type&gt; include           &lt;code&gt;DBus_Property&lt;/code&gt;, the change will be applied to the           corresponding D-Bus Property on the active           &lt;tp:member-ref&gt;Connection&lt;/tp:member-ref&gt;, if there is one. Changes to           other parameters will not take effect until the next time the account           is disconnected and reconnected.&lt;/p&gt;          &lt;tp:rationale&gt;           &lt;p&gt;In general, reconnecting is a destructive operation that shouldn&apos;t             happen as a side-effect. In particular, migration tools that             twiddle the settings of all accounts shouldn&apos;t cause an automatic             disconnect and reconnect.&lt;/p&gt;         &lt;/tp:rationale&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */
TpProxyPendingCall *
mc_cli_account_call_update_parameters (gpointer proxy,
    gint timeout_ms,
    GHashTable *in_Set,
    const gchar **in_Unset,
    mc_cli_account_callback_for_update_parameters callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = MC_IFACE_QUARK_ACCOUNT;
  DBusGProxy *iface;

  g_return_val_if_fail (TP_IS_PROXY (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            NULL,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "UpdateParameters",
          (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)), in_Set,
          G_TYPE_STRV, in_Unset,
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "UpdateParameters", iface,
          _mc_cli_account_invoke_callback_update_parameters,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "UpdateParameters",
              _mc_cli_account_collect_callback_update_parameters,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)), in_Set,
              G_TYPE_STRV, in_Unset,
              G_TYPE_INVALID));

      return data;
    }
}


/**
 * mc_cli_account_callback_for_reconnect:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a Reconnect method call
 * succeeds or fails.
 */
static void
_mc_cli_account_collect_callback_reconnect (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;

  dbus_g_proxy_end_call (proxy, call, &error,
      G_TYPE_INVALID);
  tp_proxy_pending_call_v0_take_results (user_data, error,NULL);
}
static void
_mc_cli_account_invoke_callback_reconnect (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  mc_cli_account_callback_for_reconnect callback = (mc_cli_account_callback_for_reconnect) generic_callback;

  if (error != NULL)
    {
      callback ((TpProxy *) self,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((TpProxy *) self,
      error, user_data, weak_object);

  if (args != NULL)
    g_value_array_free (args);
}

/**
 * mc_cli_account_call_reconnect:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a Reconnect method call.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Re-connect this account. If the account is currently disconnected           and the requested presence is offline, or if the account           is not &lt;tp:member-ref&gt;Enabled&lt;/tp:member-ref&gt; or not           &lt;tp:member-ref&gt;Valid&lt;/tp:member-ref&gt;, this does nothing.&lt;/p&gt;          &lt;p&gt;If the account is disconnected and the requested presence is not           offline, this forces an attempt to connect with the requested           presence immediately.&lt;/p&gt;          &lt;p&gt;If the account is connecting or connected, this is equivalent to           remembering the current value of           &lt;tp:member-ref&gt;RequestedPresence&lt;/tp:member-ref&gt;, setting its value           to (OFFLINE, &amp;quot;offline&amp;quot;, &amp;quot;&amp;quot;), waiting for the change to take effect,           then setting its value to the value that was previously           remembered.&lt;/p&gt;          &lt;tp:rationale&gt;           &lt;p&gt;Clients desiring &amp;quot;instant apply&amp;quot; semantics for CM parameters MAY             call this method to achieve that.&lt;/p&gt;         &lt;/tp:rationale&gt;          &lt;p&gt;In particular, if the account&apos;s           &lt;tp:member-ref&gt;Connection&lt;/tp:member-ref&gt; is in the Connecting           state, calling this method causes the attempt to connect to be           aborted and re-tried.&lt;/p&gt;          &lt;tp:rationale&gt;           &lt;p&gt;This is necessary to ensure that the new parameters are             picked up.&lt;/p&gt;         &lt;/tp:rationale&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */
TpProxyPendingCall *
mc_cli_account_call_reconnect (gpointer proxy,
    gint timeout_ms,
    mc_cli_account_callback_for_reconnect callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = MC_IFACE_QUARK_ACCOUNT;
  DBusGProxy *iface;

  g_return_val_if_fail (TP_IS_PROXY (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "Reconnect",
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "Reconnect", iface,
          _mc_cli_account_invoke_callback_reconnect,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "Reconnect",
              _mc_cli_account_collect_callback_reconnect,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              G_TYPE_INVALID));

      return data;
    }
}


static inline void
mc_cli_add_signals_for_account_interface_avatar (DBusGProxy *proxy)
{
  if (!tp_proxy_dbus_g_proxy_claim_for_signal_adding (proxy))
    return;
  dbus_g_proxy_add_signal (proxy, "AvatarChanged",
      G_TYPE_INVALID);
}


/**
 * mc_cli_account_interface_avatar_signal_callback_avatar_changed:
 * @proxy: The proxy on which mc_cli_account_interface_avatar_connect_to_avatar_changed ()
 *  was called
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal AvatarChanged.
 */
static void
_mc_cli_account_interface_avatar_invoke_callback_for_avatar_changed (TpProxy *tpproxy,
    GError *error G_GNUC_UNUSED,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  mc_cli_account_interface_avatar_signal_callback_avatar_changed callback =
      (mc_cli_account_interface_avatar_signal_callback_avatar_changed) generic_callback;

  if (callback != NULL)
    callback (g_object_ref (tpproxy),
      user_data,
      weak_object);

  if (args != NULL)
    g_value_array_free (args);

  g_object_unref (tpproxy);
}
/**
 * mc_cli_account_interface_avatar_connect_to_avatar_changed:
 * @proxy: A #TpProxy or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal AvatarChanged.
 *
 * Emitted when the Avatar property changes.          &lt;tp:rationale&gt;The avatar itself is deliberately not included in this           signal, to reduce bus traffic in the (likely common) case where no           running application cares about the user&apos;s own avatar.&lt;/tp:rationale&gt;
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */
TpProxySignalConnection *
mc_cli_account_interface_avatar_connect_to_avatar_changed (gpointer proxy,
    mc_cli_account_interface_avatar_signal_callback_avatar_changed callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object,
    GError **error)
{
  GType expected_types[1] = {
      G_TYPE_INVALID };

  g_return_val_if_fail (TP_IS_PROXY (proxy), NULL);
  g_return_val_if_fail (callback != NULL, NULL);

  return tp_proxy_signal_connection_v0_new ((TpProxy *) proxy,
      MC_IFACE_QUARK_ACCOUNT_INTERFACE_AVATAR, "AvatarChanged",
      expected_types,
      NULL, /* no args => no collector function */
      _mc_cli_account_interface_avatar_invoke_callback_for_avatar_changed,
      G_CALLBACK (callback), user_data, destroy,
      weak_object, error);
}

static inline void
mc_cli_add_signals_for_account_interface_channelrequests (DBusGProxy *proxy)
{
  if (!tp_proxy_dbus_g_proxy_claim_for_signal_adding (proxy))
    return;
  dbus_g_proxy_add_signal (proxy, "Failed",
      DBUS_TYPE_G_OBJECT_PATH,
      G_TYPE_STRING,
      G_TYPE_STRING,
      G_TYPE_INVALID);
  dbus_g_proxy_add_signal (proxy, "Succeeded",
      DBUS_TYPE_G_OBJECT_PATH,
      G_TYPE_INVALID);
}


/**
 * mc_cli_account_interface_channelrequests_signal_callback_failed:
 * @proxy: The proxy on which mc_cli_account_interface_channelrequests_connect_to_failed ()
 *  was called
 * @arg_Request: The channel request.
 * @arg_Error: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;The name of a D-Bus error. This can come from various sources,             including the error raised by CreateChannel, or an error generated             to represent failure to establish the Connection.&lt;/p&gt;
 * @arg_Message: If the first argument of the D-Bus error message was a string,           that string. Otherwise, an empty string.
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal Failed.
 */
static void
_mc_cli_account_interface_channelrequests_collect_args_of_failed (DBusGProxy *proxy G_GNUC_UNUSED,
    const gchar *arg_Request,
    const gchar *arg_Error,
    const gchar *arg_Message,
    TpProxySignalConnection *sc)
{
  GValueArray *args = g_value_array_new (3);
  GValue blank = { 0 };
  guint i;

  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 3; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, DBUS_TYPE_G_OBJECT_PATH);
  g_value_set_boxed (args->values + 0, arg_Request);

  g_value_unset (args->values + 1);
  g_value_init (args->values + 1, G_TYPE_STRING);
  g_value_set_string (args->values + 1, arg_Error);

  g_value_unset (args->values + 2);
  g_value_init (args->values + 2, G_TYPE_STRING);
  g_value_set_string (args->values + 2, arg_Message);

  tp_proxy_signal_connection_v0_take_results (sc, args);
}
static void
_mc_cli_account_interface_channelrequests_invoke_callback_for_failed (TpProxy *tpproxy,
    GError *error G_GNUC_UNUSED,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  mc_cli_account_interface_channelrequests_signal_callback_failed callback =
      (mc_cli_account_interface_channelrequests_signal_callback_failed) generic_callback;

  if (callback != NULL)
    callback (g_object_ref (tpproxy),
      g_value_get_boxed (args->values + 0),
      g_value_get_string (args->values + 1),
      g_value_get_string (args->values + 2),
      user_data,
      weak_object);

  g_value_array_free (args);
  g_object_unref (tpproxy);
}
/**
 * mc_cli_account_interface_channelrequests_connect_to_failed:
 * @proxy: A #TpProxy or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal Failed.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;The channel request has failed. It is no longer present,           and further methods must not be called on it.&lt;/p&gt;
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */
TpProxySignalConnection *
mc_cli_account_interface_channelrequests_connect_to_failed (gpointer proxy,
    mc_cli_account_interface_channelrequests_signal_callback_failed callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object,
    GError **error)
{
  GType expected_types[4] = {
      DBUS_TYPE_G_OBJECT_PATH,
      G_TYPE_STRING,
      G_TYPE_STRING,
      G_TYPE_INVALID };

  g_return_val_if_fail (TP_IS_PROXY (proxy), NULL);
  g_return_val_if_fail (callback != NULL, NULL);

  return tp_proxy_signal_connection_v0_new ((TpProxy *) proxy,
      MC_IFACE_QUARK_ACCOUNT_INTERFACE_CHANNELREQUESTS, "Failed",
      expected_types,
      G_CALLBACK (_mc_cli_account_interface_channelrequests_collect_args_of_failed),
      _mc_cli_account_interface_channelrequests_invoke_callback_for_failed,
      G_CALLBACK (callback), user_data, destroy,
      weak_object, error);
}

/**
 * mc_cli_account_interface_channelrequests_signal_callback_succeeded:
 * @proxy: The proxy on which mc_cli_account_interface_channelrequests_connect_to_succeeded ()
 *  was called
 * @arg_Request: The channel request.
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal Succeeded.
 */
static void
_mc_cli_account_interface_channelrequests_collect_args_of_succeeded (DBusGProxy *proxy G_GNUC_UNUSED,
    const gchar *arg_Request,
    TpProxySignalConnection *sc)
{
  GValueArray *args = g_value_array_new (1);
  GValue blank = { 0 };
  guint i;

  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 1; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, DBUS_TYPE_G_OBJECT_PATH);
  g_value_set_boxed (args->values + 0, arg_Request);

  tp_proxy_signal_connection_v0_take_results (sc, args);
}
static void
_mc_cli_account_interface_channelrequests_invoke_callback_for_succeeded (TpProxy *tpproxy,
    GError *error G_GNUC_UNUSED,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  mc_cli_account_interface_channelrequests_signal_callback_succeeded callback =
      (mc_cli_account_interface_channelrequests_signal_callback_succeeded) generic_callback;

  if (callback != NULL)
    callback (g_object_ref (tpproxy),
      g_value_get_boxed (args->values + 0),
      user_data,
      weak_object);

  g_value_array_free (args);
  g_object_unref (tpproxy);
}
/**
 * mc_cli_account_interface_channelrequests_connect_to_succeeded:
 * @proxy: A #TpProxy or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal Succeeded.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;The channel request has succeeded. It is no longer present,           and further methods must not be called on it.&lt;/p&gt;
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */
TpProxySignalConnection *
mc_cli_account_interface_channelrequests_connect_to_succeeded (gpointer proxy,
    mc_cli_account_interface_channelrequests_signal_callback_succeeded callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object,
    GError **error)
{
  GType expected_types[2] = {
      DBUS_TYPE_G_OBJECT_PATH,
      G_TYPE_INVALID };

  g_return_val_if_fail (TP_IS_PROXY (proxy), NULL);
  g_return_val_if_fail (callback != NULL, NULL);

  return tp_proxy_signal_connection_v0_new ((TpProxy *) proxy,
      MC_IFACE_QUARK_ACCOUNT_INTERFACE_CHANNELREQUESTS, "Succeeded",
      expected_types,
      G_CALLBACK (_mc_cli_account_interface_channelrequests_collect_args_of_succeeded),
      _mc_cli_account_interface_channelrequests_invoke_callback_for_succeeded,
      G_CALLBACK (callback), user_data, destroy,
      weak_object, error);
}

/**
 * mc_cli_account_interface_channelrequests_callback_for_create:
 * @proxy: the proxy on which the call was made
 * @out_Request: Used to return an 'out' argument if @error is %NULL: A           &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy&quot;&gt;ChannelRequest.DRAFT&lt;/tp:dbus-ref&gt;           object. Currently the object itself is not implemented and this           object path should be used only like a unique indentifier for the           channel request.
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a Create method call
 * succeeds or fails.
 */
static void
_mc_cli_account_interface_channelrequests_collect_callback_create (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;
  GValueArray *args;
  GValue blank = { 0 };
  guint i;
  gchar *out_Request;

  dbus_g_proxy_end_call (proxy, call, &error,
      DBUS_TYPE_G_OBJECT_PATH, &out_Request,
      G_TYPE_INVALID);

  if (error != NULL)
    {
      tp_proxy_pending_call_v0_take_results (user_data, error,
          NULL);
      return;
    }

  args = g_value_array_new (1);
  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 1; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, DBUS_TYPE_G_OBJECT_PATH);
  g_value_take_boxed (args->values + 0, out_Request);
  tp_proxy_pending_call_v0_take_results (user_data, NULL, args);
}
static void
_mc_cli_account_interface_channelrequests_invoke_callback_create (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  mc_cli_account_interface_channelrequests_callback_for_create callback = (mc_cli_account_interface_channelrequests_callback_for_create) generic_callback;

  if (error != NULL)
    {
      callback ((TpProxy *) self,
          NULL,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((TpProxy *) self,
      g_value_get_boxed (args->values + 0),
      error, user_data, weak_object);

  g_value_array_free (args);
}

/**
 * mc_cli_account_interface_channelrequests_call_create:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Requested_Properties: Used to pass an 'in' argument: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;A dictionary containing desirable properties. This has the same             semantics as the corresponding parameter to             &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy&quot;&gt;Connection.Interface.Requests.CreateChannel&lt;/tp:dbus-ref&gt;.           &lt;/p&gt;            &lt;p&gt;Certain properties will not necessarily make sense in this             dictionary: for instance,             &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel&quot;&gt;TargetHandle&lt;/tp:dbus-ref&gt;             can only be given if the requester is able to interact with a             &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy&quot;&gt;Connection&lt;/tp:dbus-ref&gt;             to the desired account.&lt;/p&gt;
 * @in_User_Action_Time: Used to pass an 'in' argument: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;The time at which user action occurred, or 0 if this channel             request is for some reason not involving user action.             This value will eventually be passed as the             &lt;code&gt;User_Action_Time&lt;/code&gt; parameter of &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Client.Handler.DRAFT&quot;&gt;HandleChannels&lt;/tp:dbus-ref&gt;.&lt;/p&gt;
 * @in_Preferred_Handler: Used to pass an 'in' argument: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;Either the well-known bus name (starting with             &lt;code&gt;org.freedesktop.Telepathy.Client.&lt;/code&gt;)             of the preferred handler for this             channel, or an empty string to indicate that any handler would be             acceptable. The channel dispatcher SHOULD dispatch as many as             possible of the resulting channels (ideally, all of them)             to that handler, and SHOULD remember the preferred handler             so it can try to dispatch subsequent channels in the same bundle             to the same handler.&lt;/p&gt;            &lt;tp:rationale&gt;             &lt;p&gt;This must be the well-known bus name, not the unique name,               to ensure that all handlers do indeed have the Client API,               and the Client object on the handler can be located easily.&lt;/p&gt;              &lt;p&gt;This is partly so the channel dispatcher can call               &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Client.Handler.DRAFT&quot;&gt;HandleChannels&lt;/tp:dbus-ref&gt;               on it, and partly so the channel dispatcher               can recover state if it crashes and is restarted.&lt;/p&gt;           &lt;/tp:rationale&gt;
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a Create method call.
 *
 * Create a channel request.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */
TpProxyPendingCall *
mc_cli_account_interface_channelrequests_call_create (gpointer proxy,
    gint timeout_ms,
    GHashTable *in_Requested_Properties,
    guint64 in_User_Action_Time,
    const gchar *in_Preferred_Handler,
    mc_cli_account_interface_channelrequests_callback_for_create callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = MC_IFACE_QUARK_ACCOUNT_INTERFACE_CHANNELREQUESTS;
  DBusGProxy *iface;

  g_return_val_if_fail (TP_IS_PROXY (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            NULL,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "Create",
          (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)), in_Requested_Properties,
          G_TYPE_UINT64, in_User_Action_Time,
          G_TYPE_STRING, in_Preferred_Handler,
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "Create", iface,
          _mc_cli_account_interface_channelrequests_invoke_callback_create,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "Create",
              _mc_cli_account_interface_channelrequests_collect_callback_create,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)), in_Requested_Properties,
              G_TYPE_UINT64, in_User_Action_Time,
              G_TYPE_STRING, in_Preferred_Handler,
              G_TYPE_INVALID));

      return data;
    }
}


/**
 * mc_cli_account_interface_channelrequests_callback_for_ensure_channel:
 * @proxy: the proxy on which the call was made
 * @out_Request: Used to return an 'out' argument if @error is %NULL: A           &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy&quot;&gt;ChannelRequest.DRAFT&lt;/tp:dbus-ref&gt;           object.
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a EnsureChannel method call
 * succeeds or fails.
 */
static void
_mc_cli_account_interface_channelrequests_collect_callback_ensure_channel (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;
  GValueArray *args;
  GValue blank = { 0 };
  guint i;
  gchar *out_Request;

  dbus_g_proxy_end_call (proxy, call, &error,
      DBUS_TYPE_G_OBJECT_PATH, &out_Request,
      G_TYPE_INVALID);

  if (error != NULL)
    {
      tp_proxy_pending_call_v0_take_results (user_data, error,
          NULL);
      return;
    }

  args = g_value_array_new (1);
  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 1; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, DBUS_TYPE_G_OBJECT_PATH);
  g_value_take_boxed (args->values + 0, out_Request);
  tp_proxy_pending_call_v0_take_results (user_data, NULL, args);
}
static void
_mc_cli_account_interface_channelrequests_invoke_callback_ensure_channel (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  mc_cli_account_interface_channelrequests_callback_for_ensure_channel callback = (mc_cli_account_interface_channelrequests_callback_for_ensure_channel) generic_callback;

  if (error != NULL)
    {
      callback ((TpProxy *) self,
          NULL,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((TpProxy *) self,
      g_value_get_boxed (args->values + 0),
      error, user_data, weak_object);

  g_value_array_free (args);
}

/**
 * mc_cli_account_interface_channelrequests_call_ensure_channel:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Requested_Properties: Used to pass an 'in' argument: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;A dictionary containing desirable properties. This has the same             semantics as the corresponding parameter to             &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy&quot;&gt;Connection.Interface.Requests.EnsureChannel&lt;/tp:dbus-ref&gt;.           &lt;/p&gt;            &lt;p&gt;Certain properties will not necessarily make sense in this             dictionary: for instance,             &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel&quot;&gt;TargetHandle&lt;/tp:dbus-ref&gt;             can only be given if the requester is able to interact with a             &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy&quot;&gt;Connection&lt;/tp:dbus-ref&gt;             to the desired account.&lt;/p&gt;
 * @in_User_Action_Time: Used to pass an 'in' argument: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;The time at which user action occurred, or 0 if this channel             request is for some reason not involving user action.             This value will eventually be passed as the             &lt;code&gt;User_Action_Time&lt;/code&gt; parameter of &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Client.Handler.DRAFT&quot;&gt;HandleChannels&lt;/tp:dbus-ref&gt;.&lt;/p&gt;
 * @in_Preferred_Handler: Used to pass an 'in' argument: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;Either the well-known bus name (starting with             &lt;code&gt;org.freedesktop.Telepathy.Client.&lt;/code&gt;)             of the preferred handler for this             channel, or an empty string to indicate that any handler would be             acceptable.&lt;/p&gt;            &lt;tp:rationale&gt;             &lt;p&gt;This must be the well-known bus name, not the unique name,               to ensure that all handlers do indeed have the Client API,               and the Client object on the handler can be located easily.&lt;/p&gt;              &lt;p&gt;This is partly so the channel dispatcher can call               &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Client.Handler.DRAFT&quot;&gt;HandleChannels&lt;/tp:dbus-ref&gt;               on it, and partly so the channel dispatcher               can recover state if it crashes and is restarted.&lt;/p&gt;           &lt;/tp:rationale&gt;            &lt;p&gt;If any new channels are created in response to this             request, the channel dispatcher SHOULD dispatch as many as             possible of the resulting channels (ideally, all of them)             to that handler, and SHOULD remember the preferred handler             so it can try to dispatch subsequent channels in the same bundle             to the same handler. If the requested channel already exists (that             is, &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy&quot;&gt;Connection.Interface.Requests.EnsureChannel&lt;/tp:dbus-ref&gt;             returns &lt;code&gt;Yours=False&lt;/code&gt;) then the channel dispatcher             SHOULD re-dispatch the channel to its existing handler, and MUST             NOT dispatch it to this client (unless it is the existing handler);             the request is still deemed to have succeeded in this case.&lt;/p&gt;            &lt;tp:rationale&gt;             &lt;p&gt;An address book application, for example, might call &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.ChannelDispatcher.DRAFT&quot;&gt;EnsureChannel&lt;/tp:dbus-ref&gt;               to ensure that a text channel with a particular contact is               displayed to the user; it does not care whether a new channel was               made. An IM client might call &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.ChannelDispatcher.DRAFT&quot;&gt;EnsureChannel&lt;/tp:dbus-ref&gt;               in response to the user double-clicking an entry in the contact               list, with itself as the &lt;code&gt;Preferred_Handler&lt;/code&gt;; if the               user already has a conversation with that contact in another               application, they would expect the existing window to be               presented, rather than their double-click leading to an error               message.  So the request should succeed, even if its               &lt;code&gt;Preferred_Handler&lt;/code&gt; is not used.&lt;/p&gt;           &lt;/tp:rationale&gt;
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a EnsureChannel method call.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Start a request to ensure that a channel exists, creating it if           necessary.&lt;/p&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */
TpProxyPendingCall *
mc_cli_account_interface_channelrequests_call_ensure_channel (gpointer proxy,
    gint timeout_ms,
    GHashTable *in_Requested_Properties,
    guint64 in_User_Action_Time,
    const gchar *in_Preferred_Handler,
    mc_cli_account_interface_channelrequests_callback_for_ensure_channel callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = MC_IFACE_QUARK_ACCOUNT_INTERFACE_CHANNELREQUESTS;
  DBusGProxy *iface;

  g_return_val_if_fail (TP_IS_PROXY (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            NULL,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "EnsureChannel",
          (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)), in_Requested_Properties,
          G_TYPE_UINT64, in_User_Action_Time,
          G_TYPE_STRING, in_Preferred_Handler,
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "EnsureChannel", iface,
          _mc_cli_account_interface_channelrequests_invoke_callback_ensure_channel,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "EnsureChannel",
              _mc_cli_account_interface_channelrequests_collect_callback_ensure_channel,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)), in_Requested_Properties,
              G_TYPE_UINT64, in_User_Action_Time,
              G_TYPE_STRING, in_Preferred_Handler,
              G_TYPE_INVALID));

      return data;
    }
}


/**
 * mc_cli_account_interface_channelrequests_callback_for_cancel:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a Cancel method call
 * succeeds or fails.
 */
static void
_mc_cli_account_interface_channelrequests_collect_callback_cancel (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;

  dbus_g_proxy_end_call (proxy, call, &error,
      G_TYPE_INVALID);
  tp_proxy_pending_call_v0_take_results (user_data, error,NULL);
}
static void
_mc_cli_account_interface_channelrequests_invoke_callback_cancel (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  mc_cli_account_interface_channelrequests_callback_for_cancel callback = (mc_cli_account_interface_channelrequests_callback_for_cancel) generic_callback;

  if (error != NULL)
    {
      callback ((TpProxy *) self,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((TpProxy *) self,
      error, user_data, weak_object);

  if (args != NULL)
    g_value_array_free (args);
}

/**
 * mc_cli_account_interface_channelrequests_call_cancel:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Request: Used to pass an 'in' argument: The channel request to be cancelled.
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a Cancel method call.
 *
 * &lt;p&gt;Cancel a channel request. The precise effect depends on the           current progress of the request.&lt;/p&gt;          &lt;p&gt;If the connection manager has not already been asked to create           a channel, then &lt;tp:member-ref&gt;Failed&lt;/tp:member-ref&gt; is emitted           immediately, and the channel request is removed.&lt;/p&gt;          &lt;p&gt;If the connection manager has already been asked to create a           channel but has not produced one yet (e.g. if &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy&quot;&gt;Connection.Interface.Requests.CreateChannel&lt;/tp:dbus-ref&gt;           has been called, but has not yet returned), then the           ChannelDispatcher will remember that the request has been cancelled.           When the channel appears, it will be closed (if it was newly           created and can be closed), and will not be dispatched to a           handler.&lt;/p&gt;          &lt;p&gt;If the connection manager has already returned a channel, but the           channel has not yet been dispatched to a handler           then the channel dispatcher will not dispatch that           channel to a handler. If the channel was newly created for this           request, the channel dispatcher will close it with Close; otherwise,           the channel dispatcher will ignore it. In either case,           &lt;tp:member-ref&gt;Failed&lt;/tp:member-ref&gt; will be emitted when processing           has been completed.&lt;/p&gt;          &lt;p&gt;If Failed is emitted in response to this method, the error SHOULD be           &lt;code&gt;org.freedesktop.Telepathy.Errors.Cancelled&lt;/code&gt;.&lt;/p&gt;          &lt;p&gt;If the channel has already been dispatched to a handler, then           it&apos;s too late to call this method, and the channel request will           no longer exist.&lt;/p&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */
TpProxyPendingCall *
mc_cli_account_interface_channelrequests_call_cancel (gpointer proxy,
    gint timeout_ms,
    const gchar *in_Request,
    mc_cli_account_interface_channelrequests_callback_for_cancel callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = MC_IFACE_QUARK_ACCOUNT_INTERFACE_CHANNELREQUESTS;
  DBusGProxy *iface;

  g_return_val_if_fail (TP_IS_PROXY (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "Cancel",
          DBUS_TYPE_G_OBJECT_PATH, in_Request,
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "Cancel", iface,
          _mc_cli_account_interface_channelrequests_invoke_callback_cancel,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "Cancel",
              _mc_cli_account_interface_channelrequests_collect_callback_cancel,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              DBUS_TYPE_G_OBJECT_PATH, in_Request,
              G_TYPE_INVALID));

      return data;
    }
}


static inline void
mc_cli_add_signals_for_account_interface_compat (DBusGProxy *proxy)
{
  if (!tp_proxy_dbus_g_proxy_claim_for_signal_adding (proxy))
    return;
  dbus_g_proxy_add_signal (proxy, "CompatPropertyChanged",
      (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)),
      G_TYPE_INVALID);
}


/**
 * mc_cli_account_interface_compat_signal_callback_compat_property_changed:
 * @proxy: The proxy on which mc_cli_account_interface_compat_connect_to_compat_property_changed ()
 *  was called
 * @arg_Properties: A map from property names in this namespace (e.g.           &lt;tp:member-ref&gt;SecondaryVCardFields&lt;/tp:member-ref&gt;) to           values. Properties whose values have not changed SHOULD be           omitted, but this need not be done.
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal CompatPropertyChanged.
 */
static void
_mc_cli_account_interface_compat_collect_args_of_compat_property_changed (DBusGProxy *proxy G_GNUC_UNUSED,
    GHashTable *arg_Properties,
    TpProxySignalConnection *sc)
{
  GValueArray *args = g_value_array_new (1);
  GValue blank = { 0 };
  guint i;

  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 1; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)));
  g_value_set_boxed (args->values + 0, arg_Properties);

  tp_proxy_signal_connection_v0_take_results (sc, args);
}
static void
_mc_cli_account_interface_compat_invoke_callback_for_compat_property_changed (TpProxy *tpproxy,
    GError *error G_GNUC_UNUSED,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  mc_cli_account_interface_compat_signal_callback_compat_property_changed callback =
      (mc_cli_account_interface_compat_signal_callback_compat_property_changed) generic_callback;

  if (callback != NULL)
    callback (g_object_ref (tpproxy),
      g_value_get_boxed (args->values + 0),
      user_data,
      weak_object);

  g_value_array_free (args);
  g_object_unref (tpproxy);
}
/**
 * mc_cli_account_interface_compat_connect_to_compat_property_changed:
 * @proxy: A #TpProxy or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal CompatPropertyChanged.
 *
 * The values of one or more properties on this interface may have         changed.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */
TpProxySignalConnection *
mc_cli_account_interface_compat_connect_to_compat_property_changed (gpointer proxy,
    mc_cli_account_interface_compat_signal_callback_compat_property_changed callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object,
    GError **error)
{
  GType expected_types[2] = {
      (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)),
      G_TYPE_INVALID };

  g_return_val_if_fail (TP_IS_PROXY (proxy), NULL);
  g_return_val_if_fail (callback != NULL, NULL);

  return tp_proxy_signal_connection_v0_new ((TpProxy *) proxy,
      MC_IFACE_QUARK_ACCOUNT_INTERFACE_COMPAT, "CompatPropertyChanged",
      expected_types,
      G_CALLBACK (_mc_cli_account_interface_compat_collect_args_of_compat_property_changed),
      _mc_cli_account_interface_compat_invoke_callback_for_compat_property_changed,
      G_CALLBACK (callback), user_data, destroy,
      weak_object, error);
}

/**
 * mc_cli_account_interface_compat_callback_for_set_has_been_online:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a SetHasBeenOnline method call
 * succeeds or fails.
 */
static void
_mc_cli_account_interface_compat_collect_callback_set_has_been_online (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;

  dbus_g_proxy_end_call (proxy, call, &error,
      G_TYPE_INVALID);
  tp_proxy_pending_call_v0_take_results (user_data, error,NULL);
}
static void
_mc_cli_account_interface_compat_invoke_callback_set_has_been_online (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  mc_cli_account_interface_compat_callback_for_set_has_been_online callback = (mc_cli_account_interface_compat_callback_for_set_has_been_online) generic_callback;

  if (error != NULL)
    {
      callback ((TpProxy *) self,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((TpProxy *) self,
      error, user_data, weak_object);

  if (args != NULL)
    g_value_array_free (args);
}

/**
 * mc_cli_account_interface_compat_call_set_has_been_online:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a SetHasBeenOnline method call.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Force MC to believe that this account has been put online           successfully at some point in the past.&lt;/p&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */
TpProxyPendingCall *
mc_cli_account_interface_compat_call_set_has_been_online (gpointer proxy,
    gint timeout_ms,
    mc_cli_account_interface_compat_callback_for_set_has_been_online callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = MC_IFACE_QUARK_ACCOUNT_INTERFACE_COMPAT;
  DBusGProxy *iface;

  g_return_val_if_fail (TP_IS_PROXY (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "SetHasBeenOnline",
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "SetHasBeenOnline", iface,
          _mc_cli_account_interface_compat_invoke_callback_set_has_been_online,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "SetHasBeenOnline",
              _mc_cli_account_interface_compat_collect_callback_set_has_been_online,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              G_TYPE_INVALID));

      return data;
    }
}


static inline void
mc_cli_add_signals_for_account_interface_stats (DBusGProxy *proxy)
{
  if (!tp_proxy_dbus_g_proxy_claim_for_signal_adding (proxy))
    return;
  dbus_g_proxy_add_signal (proxy, "StatsChanged",
      (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)),
      G_TYPE_INVALID);
}


/**
 * mc_cli_account_interface_stats_signal_callback_stats_changed:
 * @proxy: The proxy on which mc_cli_account_interface_stats_connect_to_stats_changed ()
 *  was called
 * @arg_Properties: A map from property names in this namespace (e.g. Nickname) to           values. Properties whose values have not changed SHOULD be           omitted, but this need not be done.
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal StatsChanged.
 */
static void
_mc_cli_account_interface_stats_collect_args_of_stats_changed (DBusGProxy *proxy G_GNUC_UNUSED,
    GHashTable *arg_Properties,
    TpProxySignalConnection *sc)
{
  GValueArray *args = g_value_array_new (1);
  GValue blank = { 0 };
  guint i;

  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 1; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)));
  g_value_set_boxed (args->values + 0, arg_Properties);

  tp_proxy_signal_connection_v0_take_results (sc, args);
}
static void
_mc_cli_account_interface_stats_invoke_callback_for_stats_changed (TpProxy *tpproxy,
    GError *error G_GNUC_UNUSED,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  mc_cli_account_interface_stats_signal_callback_stats_changed callback =
      (mc_cli_account_interface_stats_signal_callback_stats_changed) generic_callback;

  if (callback != NULL)
    callback (g_object_ref (tpproxy),
      g_value_get_boxed (args->values + 0),
      user_data,
      weak_object);

  g_value_array_free (args);
  g_object_unref (tpproxy);
}
/**
 * mc_cli_account_interface_stats_connect_to_stats_changed:
 * @proxy: A #TpProxy or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal StatsChanged.
 *
 * Emitted when a property in this interface changes.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */
TpProxySignalConnection *
mc_cli_account_interface_stats_connect_to_stats_changed (gpointer proxy,
    mc_cli_account_interface_stats_signal_callback_stats_changed callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object,
    GError **error)
{
  GType expected_types[2] = {
      (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)),
      G_TYPE_INVALID };

  g_return_val_if_fail (TP_IS_PROXY (proxy), NULL);
  g_return_val_if_fail (callback != NULL, NULL);

  return tp_proxy_signal_connection_v0_new ((TpProxy *) proxy,
      MC_IFACE_QUARK_ACCOUNT_INTERFACE_STATS, "StatsChanged",
      expected_types,
      G_CALLBACK (_mc_cli_account_interface_stats_collect_args_of_stats_changed),
      _mc_cli_account_interface_stats_invoke_callback_for_stats_changed,
      G_CALLBACK (callback), user_data, destroy,
      weak_object, error);
}

/*
 * mc_cli_account_add_signals:
 * @self: the #TpProxy
 * @quark: a quark whose string value is the interface
 *   name whose signals should be added
 * @proxy: the D-Bus proxy to which to add the signals
 * @unused: not used for anything
 *
 * Tell dbus-glib that @proxy has the signatures of all
 * signals on the given interface, if it's one we
 * support.
 *
 * This function should be used as a signal handler for
 * #TpProxy::interface-added.
 */
static void
mc_cli_account_add_signals (TpProxy *self G_GNUC_UNUSED,
    guint quark,
    DBusGProxy *proxy,
    gpointer unused G_GNUC_UNUSED)
{
  if (quark == MC_IFACE_QUARK_ACCOUNT)
    mc_cli_add_signals_for_account (proxy);
  if (quark == MC_IFACE_QUARK_ACCOUNT_INTERFACE_AVATAR)
    mc_cli_add_signals_for_account_interface_avatar (proxy);
  if (quark == MC_IFACE_QUARK_ACCOUNT_INTERFACE_CHANNELREQUESTS)
    mc_cli_add_signals_for_account_interface_channelrequests (proxy);
  if (quark == MC_IFACE_QUARK_ACCOUNT_INTERFACE_COMPAT)
    mc_cli_add_signals_for_account_interface_compat (proxy);
  if (quark == MC_IFACE_QUARK_ACCOUNT_INTERFACE_STATS)
    mc_cli_add_signals_for_account_interface_stats (proxy);
}
