#include "_gen/tp-svc-protocol.h"

#include <telepathy-glib/dbus.h>
#include "_gen/signals-marshal.h"

static const DBusGObjectInfo _tp_svc_protocol_object_info;

struct _TpSvcProtocolClass {
    GTypeInterface parent_class;
    tp_svc_protocol_identify_account_impl identify_account_cb;
    tp_svc_protocol_normalize_contact_impl normalize_contact_cb;
};

static void tp_svc_protocol_base_init (gpointer klass);

GType
tp_svc_protocol_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (TpSvcProtocolClass),
        tp_svc_protocol_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "TpSvcProtocol", &info, 0);
    }

  return type;
}

static void
tp_svc_protocol_identify_account (TpSvcProtocol *self,
    GHashTable *in_Parameters,
    DBusGMethodInvocation *context)
{
  tp_svc_protocol_identify_account_impl impl = (TP_SVC_PROTOCOL_GET_CLASS (self)->identify_account_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_Parameters,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

void
tp_svc_protocol_implement_identify_account (TpSvcProtocolClass *klass, tp_svc_protocol_identify_account_impl impl)
{
  klass->identify_account_cb = impl;
}

static void
tp_svc_protocol_normalize_contact (TpSvcProtocol *self,
    const gchar *in_Contact_ID,
    DBusGMethodInvocation *context)
{
  tp_svc_protocol_normalize_contact_impl impl = (TP_SVC_PROTOCOL_GET_CLASS (self)->normalize_contact_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_Contact_ID,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

void
tp_svc_protocol_implement_normalize_contact (TpSvcProtocolClass *klass, tp_svc_protocol_normalize_contact_impl impl)
{
  klass->normalize_contact_cb = impl;
}

static inline void
tp_svc_protocol_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  static TpDBusPropertiesMixinPropInfo properties[8] = {
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "as", 0, NULL, NULL }, /* Interfaces */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "a(susv)", 0, NULL, NULL }, /* Parameters */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "as", 0, NULL, NULL }, /* ConnectionInterfaces */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "a(a{sv}as)", 0, NULL, NULL }, /* RequestableChannelClasses */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "s", 0, NULL, NULL }, /* VCardField */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "s", 0, NULL, NULL }, /* EnglishName */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "s", 0, NULL, NULL }, /* Icon */
      { 0, 0, NULL, 0, NULL, NULL }
  };
  static TpDBusPropertiesMixinIfaceInfo interface =
      { 0, properties, NULL, NULL };

  dbus_g_object_type_install_info (tp_svc_protocol_get_type (),
      &_tp_svc_protocol_object_info);

  interface.dbus_interface = g_quark_from_static_string ("org.freedesktop.Telepathy.Protocol");
  properties[0].name = g_quark_from_static_string ("Interfaces");
  properties[0].type = G_TYPE_STRV;
  properties[1].name = g_quark_from_static_string ("Parameters");
  properties[1].type = (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_STRING, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_VALUE, G_TYPE_INVALID))));
  properties[2].name = g_quark_from_static_string ("ConnectionInterfaces");
  properties[2].type = G_TYPE_STRV;
  properties[3].name = g_quark_from_static_string ("RequestableChannelClasses");
  properties[3].type = (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)), G_TYPE_STRV, G_TYPE_INVALID))));
  properties[4].name = g_quark_from_static_string ("VCardField");
  properties[4].type = G_TYPE_STRING;
  properties[5].name = g_quark_from_static_string ("EnglishName");
  properties[5].type = G_TYPE_STRING;
  properties[6].name = g_quark_from_static_string ("Icon");
  properties[6].type = G_TYPE_STRING;
  tp_svc_interface_set_dbus_properties_info (TP_TYPE_SVC_PROTOCOL, &interface);

}
static void
tp_svc_protocol_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      tp_svc_protocol_base_init_once (klass);
    }
}
static const DBusGMethodInfo _tp_svc_protocol_methods[] = {
  { (GCallback) tp_svc_protocol_identify_account, _tp_marshal_VOID__BOXED_POINTER, 0 },
  { (GCallback) tp_svc_protocol_normalize_contact, _tp_marshal_VOID__STRING_POINTER, 92 },
};

static const DBusGObjectInfo _tp_svc_protocol_object_info = {
  0,
  _tp_svc_protocol_methods,
  2,
"org.freedesktop.Telepathy.Protocol\0IdentifyAccount\0A\0Parameters\0I\0a{sv}\0Account_ID\0O\0F\0N\0s\0\0org.freedesktop.Telepathy.Protocol\0NormalizeContact\0A\0Contact_ID\0I\0s\0Normalized_Contact_ID\0O\0F\0N\0s\0\0\0",
"\0\0",
"\0\0",
};


