/**
 * TpSvcConnection:
 *
 * Dummy typedef representing any implementation of this interface.
 */
/**
 * TpSvcConnectionClass:
 *
 * The class of TpSvcConnection.
 *
 * In a full implementation of this interface (i.e. all
 * methods implemented), the interface initialization
 * function used in G_IMPLEMENT_INTERFACE() would
 * typically look like this:
 *
 * <programlisting>
 * static void
 * implement_connection (gpointer klass,
 *     gpointer unused G_GNUC_UNUSED)
 * {
 * #define IMPLEMENT(x) tp_svc_connection_implement_&num;&num;x (\
 *   klass, my_object_&num;&num;x)
 *   IMPLEMENT (connect);
 *   IMPLEMENT (disconnect);
 *   IMPLEMENT (get_interfaces);
 *   IMPLEMENT (get_protocol);
 *   IMPLEMENT (get_self_handle);
 *   IMPLEMENT (get_status);
 *   IMPLEMENT (hold_handles);
 *   IMPLEMENT (inspect_handles);
 *   IMPLEMENT (list_channels);
 *   IMPLEMENT (release_handles);
 *   IMPLEMENT (request_channel);
 *   IMPLEMENT (request_handles);
 * #undef IMPLEMENT
 * }
 * </programlisting>
 */

/**
 * tp_svc_connection_connect_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * Connect on interface org.freedesktop.Telepathy.Connection.
 */
/**
 * tp_svc_connection_implement_connect:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the Connect D-Bus method
 *
 * Register an implementation for the Connect method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_connection_return_from_connect:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_connection_disconnect_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * Disconnect on interface org.freedesktop.Telepathy.Connection.
 */
/**
 * tp_svc_connection_implement_disconnect:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the Disconnect D-Bus method
 *
 * Register an implementation for the Disconnect method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_connection_return_from_disconnect:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_connection_get_interfaces_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetInterfaces on interface org.freedesktop.Telepathy.Connection.
 */
/**
 * tp_svc_connection_implement_get_interfaces:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetInterfaces D-Bus method
 *
 * Register an implementation for the GetInterfaces method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_connection_return_from_get_interfaces:
 * @context: The D-Bus method invocation context
 * @out_Interfaces: const gchar ** (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_connection_get_protocol_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetProtocol on interface org.freedesktop.Telepathy.Connection.
 */
/**
 * tp_svc_connection_implement_get_protocol:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetProtocol D-Bus method
 *
 * Register an implementation for the GetProtocol method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_connection_return_from_get_protocol:
 * @context: The D-Bus method invocation context
 * @out_Protocol: const gchar * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_connection_get_self_handle_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetSelfHandle on interface org.freedesktop.Telepathy.Connection.
 */
/**
 * tp_svc_connection_implement_get_self_handle:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetSelfHandle D-Bus method
 *
 * Register an implementation for the GetSelfHandle method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_connection_return_from_get_self_handle:
 * @context: The D-Bus method invocation context
 * @out_Self_Handle: guint  (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_connection_get_status_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetStatus on interface org.freedesktop.Telepathy.Connection.
 */
/**
 * tp_svc_connection_implement_get_status:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetStatus D-Bus method
 *
 * Register an implementation for the GetStatus method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_connection_return_from_get_status:
 * @context: The D-Bus method invocation context
 * @out_Status: guint  (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_connection_hold_handles_impl:
 * @self: The object implementing this interface
 * @in_Handle_Type: guint  (FIXME, generate documentation)
 * @in_Handles: const GArray * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * HoldHandles on interface org.freedesktop.Telepathy.Connection.
 */
/**
 * tp_svc_connection_implement_hold_handles:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the HoldHandles D-Bus method
 *
 * Register an implementation for the HoldHandles method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_connection_return_from_hold_handles:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_connection_inspect_handles_impl:
 * @self: The object implementing this interface
 * @in_Handle_Type: guint  (FIXME, generate documentation)
 * @in_Handles: const GArray * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * InspectHandles on interface org.freedesktop.Telepathy.Connection.
 */
/**
 * tp_svc_connection_implement_inspect_handles:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the InspectHandles D-Bus method
 *
 * Register an implementation for the InspectHandles method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_connection_return_from_inspect_handles:
 * @context: The D-Bus method invocation context
 * @out_Identifiers: const gchar ** (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_connection_list_channels_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * ListChannels on interface org.freedesktop.Telepathy.Connection.
 */
/**
 * tp_svc_connection_implement_list_channels:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the ListChannels D-Bus method
 *
 * Register an implementation for the ListChannels method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_connection_return_from_list_channels:
 * @context: The D-Bus method invocation context
 * @out_Channel_Info: const GPtrArray * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_connection_release_handles_impl:
 * @self: The object implementing this interface
 * @in_Handle_Type: guint  (FIXME, generate documentation)
 * @in_Handles: const GArray * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * ReleaseHandles on interface org.freedesktop.Telepathy.Connection.
 */
/**
 * tp_svc_connection_implement_release_handles:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the ReleaseHandles D-Bus method
 *
 * Register an implementation for the ReleaseHandles method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_connection_return_from_release_handles:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_connection_request_channel_impl:
 * @self: The object implementing this interface
 * @in_Type: const gchar * (FIXME, generate documentation)
 * @in_Handle_Type: guint  (FIXME, generate documentation)
 * @in_Handle: guint  (FIXME, generate documentation)
 * @in_Suppress_Handler: gboolean  (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * RequestChannel on interface org.freedesktop.Telepathy.Connection.
 */
/**
 * tp_svc_connection_implement_request_channel:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the RequestChannel D-Bus method
 *
 * Register an implementation for the RequestChannel method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_connection_return_from_request_channel:
 * @context: The D-Bus method invocation context
 * @out_Object_Path: const gchar * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_connection_request_handles_impl:
 * @self: The object implementing this interface
 * @in_Handle_Type: guint  (FIXME, generate documentation)
 * @in_Identifiers: const gchar ** (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * RequestHandles on interface org.freedesktop.Telepathy.Connection.
 */
/**
 * tp_svc_connection_implement_request_handles:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the RequestHandles D-Bus method
 *
 * Register an implementation for the RequestHandles method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_connection_return_from_request_handles:
 * @context: The D-Bus method invocation context
 * @out_Handles: const GArray * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_connection_emit_self_handle_changed:
 * @instance: The object implementing this interface
 * @arg_Self_Handle: guint  (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * SelfHandleChanged signal on interface org.freedesktop.Telepathy.Connection.
 */
/**
 * TpSvcConnection::self-handle-changed:
 * @arg_Self_Handle: guint  (FIXME, generate documentation)
 *
 * The SelfHandleChanged D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * tp_svc_connection_emit_new_channel:
 * @instance: The object implementing this interface
 * @arg_Object_Path: const gchar * (FIXME, generate documentation)
 * @arg_Channel_Type: const gchar * (FIXME, generate documentation)
 * @arg_Handle_Type: guint  (FIXME, generate documentation)
 * @arg_Handle: guint  (FIXME, generate documentation)
 * @arg_Suppress_Handler: gboolean  (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * NewChannel signal on interface org.freedesktop.Telepathy.Connection.
 */
/**
 * TpSvcConnection::new-channel:
 * @arg_Object_Path: const gchar * (FIXME, generate documentation)
 * @arg_Channel_Type: const gchar * (FIXME, generate documentation)
 * @arg_Handle_Type: guint  (FIXME, generate documentation)
 * @arg_Handle: guint  (FIXME, generate documentation)
 * @arg_Suppress_Handler: gboolean  (FIXME, generate documentation)
 *
 * The NewChannel D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * tp_svc_connection_emit_connection_error:
 * @instance: The object implementing this interface
 * @arg_Error: const gchar * (FIXME, generate documentation)
 * @arg_Details: GHashTable * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * ConnectionError signal on interface org.freedesktop.Telepathy.Connection.
 */
/**
 * TpSvcConnection::connection-error:
 * @arg_Error: const gchar * (FIXME, generate documentation)
 * @arg_Details: GHashTable * (FIXME, generate documentation)
 *
 * The ConnectionError D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * tp_svc_connection_emit_status_changed:
 * @instance: The object implementing this interface
 * @arg_Status: guint  (FIXME, generate documentation)
 * @arg_Reason: guint  (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * StatusChanged signal on interface org.freedesktop.Telepathy.Connection.
 */
/**
 * TpSvcConnection::status-changed:
 * @arg_Status: guint  (FIXME, generate documentation)
 * @arg_Reason: guint  (FIXME, generate documentation)
 *
 * The StatusChanged D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * TpSvcConnectionInterfaceAliasing:
 *
 * Dummy typedef representing any implementation of this interface.
 */
/**
 * TpSvcConnectionInterfaceAliasingClass:
 *
 * The class of TpSvcConnectionInterfaceAliasing.
 *
 * In a full implementation of this interface (i.e. all
 * methods implemented), the interface initialization
 * function used in G_IMPLEMENT_INTERFACE() would
 * typically look like this:
 *
 * <programlisting>
 * static void
 * implement_connection_interface_aliasing (gpointer klass,
 *     gpointer unused G_GNUC_UNUSED)
 * {
 * #define IMPLEMENT(x) tp_svc_connection_interface_aliasing_implement_&num;&num;x (\
 *   klass, my_object_&num;&num;x)
 *   IMPLEMENT (get_alias_flags);
 *   IMPLEMENT (request_aliases);
 *   IMPLEMENT (get_aliases);
 *   IMPLEMENT (set_aliases);
 * #undef IMPLEMENT
 * }
 * </programlisting>
 */

/**
 * tp_svc_connection_interface_aliasing_get_alias_flags_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetAliasFlags on interface org.freedesktop.Telepathy.Connection.Interface.Aliasing.
 */
/**
 * tp_svc_connection_interface_aliasing_implement_get_alias_flags:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetAliasFlags D-Bus method
 *
 * Register an implementation for the GetAliasFlags method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_connection_interface_aliasing_return_from_get_alias_flags:
 * @context: The D-Bus method invocation context
 * @out_Alias_Flags: guint  (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_connection_interface_aliasing_request_aliases_impl:
 * @self: The object implementing this interface
 * @in_Contacts: const GArray * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * RequestAliases on interface org.freedesktop.Telepathy.Connection.Interface.Aliasing.
 */
/**
 * tp_svc_connection_interface_aliasing_implement_request_aliases:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the RequestAliases D-Bus method
 *
 * Register an implementation for the RequestAliases method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_connection_interface_aliasing_return_from_request_aliases:
 * @context: The D-Bus method invocation context
 * @out_Aliases: const gchar ** (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_connection_interface_aliasing_get_aliases_impl:
 * @self: The object implementing this interface
 * @in_Contacts: const GArray * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetAliases on interface org.freedesktop.Telepathy.Connection.Interface.Aliasing.
 */
/**
 * tp_svc_connection_interface_aliasing_implement_get_aliases:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetAliases D-Bus method
 *
 * Register an implementation for the GetAliases method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_connection_interface_aliasing_return_from_get_aliases:
 * @context: The D-Bus method invocation context
 * @out_Aliases: GHashTable * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_connection_interface_aliasing_set_aliases_impl:
 * @self: The object implementing this interface
 * @in_Aliases: GHashTable * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * SetAliases on interface org.freedesktop.Telepathy.Connection.Interface.Aliasing.
 */
/**
 * tp_svc_connection_interface_aliasing_implement_set_aliases:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the SetAliases D-Bus method
 *
 * Register an implementation for the SetAliases method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_connection_interface_aliasing_return_from_set_aliases:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_connection_interface_aliasing_emit_aliases_changed:
 * @instance: The object implementing this interface
 * @arg_Aliases: const GPtrArray * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * AliasesChanged signal on interface org.freedesktop.Telepathy.Connection.Interface.Aliasing.
 */
/**
 * TpSvcConnectionInterfaceAliasing::aliases-changed:
 * @arg_Aliases: const GPtrArray * (FIXME, generate documentation)
 *
 * The AliasesChanged D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * TpSvcConnectionInterfaceAnonymity:
 *
 * Dummy typedef representing any implementation of this interface.
 */
/**
 * TpSvcConnectionInterfaceAnonymityClass:
 *
 * The class of TpSvcConnectionInterfaceAnonymity.
 * This interface has no D-Bus methods, so an
 * implementation can typically pass %NULL to
 * G_IMPLEMENT_INTERFACE() as the interface
 * initialization function.
 */

/**
 * tp_svc_connection_interface_anonymity_emit_anonymity_modes_changed:
 * @instance: The object implementing this interface
 * @arg_Modes: guint  (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * AnonymityModesChanged signal on interface org.freedesktop.Telepathy.Connection.Interface.Anonymity.
 */
/**
 * TpSvcConnectionInterfaceAnonymity::anonymity-modes-changed:
 * @arg_Modes: guint  (FIXME, generate documentation)
 *
 * The AnonymityModesChanged D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * TpSvcConnectionInterfaceAvatars:
 *
 * Dummy typedef representing any implementation of this interface.
 */
/**
 * TpSvcConnectionInterfaceAvatarsClass:
 *
 * The class of TpSvcConnectionInterfaceAvatars.
 *
 * In a full implementation of this interface (i.e. all
 * methods implemented), the interface initialization
 * function used in G_IMPLEMENT_INTERFACE() would
 * typically look like this:
 *
 * <programlisting>
 * static void
 * implement_connection_interface_avatars (gpointer klass,
 *     gpointer unused G_GNUC_UNUSED)
 * {
 * #define IMPLEMENT(x) tp_svc_connection_interface_avatars_implement_&num;&num;x (\
 *   klass, my_object_&num;&num;x)
 *   IMPLEMENT (get_avatar_requirements);
 *   IMPLEMENT (get_avatar_tokens);
 *   IMPLEMENT (get_known_avatar_tokens);
 *   IMPLEMENT (request_avatar);
 *   IMPLEMENT (request_avatars);
 *   IMPLEMENT (set_avatar);
 *   IMPLEMENT (clear_avatar);
 * #undef IMPLEMENT
 * }
 * </programlisting>
 */

/**
 * tp_svc_connection_interface_avatars_get_avatar_requirements_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetAvatarRequirements on interface org.freedesktop.Telepathy.Connection.Interface.Avatars.
 */
/**
 * tp_svc_connection_interface_avatars_implement_get_avatar_requirements:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetAvatarRequirements D-Bus method
 *
 * Register an implementation for the GetAvatarRequirements method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_connection_interface_avatars_return_from_get_avatar_requirements:
 * @context: The D-Bus method invocation context
 * @out_MIME_Types: const gchar ** (FIXME, generate documentation)
 * @out_Min_Width: guint  (FIXME, generate documentation)
 * @out_Min_Height: guint  (FIXME, generate documentation)
 * @out_Max_Width: guint  (FIXME, generate documentation)
 * @out_Max_Height: guint  (FIXME, generate documentation)
 * @out_Max_Bytes: guint  (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_connection_interface_avatars_get_avatar_tokens_impl:
 * @self: The object implementing this interface
 * @in_Contacts: const GArray * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetAvatarTokens on interface org.freedesktop.Telepathy.Connection.Interface.Avatars.
 */
/**
 * tp_svc_connection_interface_avatars_implement_get_avatar_tokens:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetAvatarTokens D-Bus method
 *
 * Register an implementation for the GetAvatarTokens method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_connection_interface_avatars_return_from_get_avatar_tokens:
 * @context: The D-Bus method invocation context
 * @out_Tokens: const gchar ** (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_connection_interface_avatars_get_known_avatar_tokens_impl:
 * @self: The object implementing this interface
 * @in_Contacts: const GArray * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetKnownAvatarTokens on interface org.freedesktop.Telepathy.Connection.Interface.Avatars.
 */
/**
 * tp_svc_connection_interface_avatars_implement_get_known_avatar_tokens:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetKnownAvatarTokens D-Bus method
 *
 * Register an implementation for the GetKnownAvatarTokens method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_connection_interface_avatars_return_from_get_known_avatar_tokens:
 * @context: The D-Bus method invocation context
 * @out_Tokens: GHashTable * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_connection_interface_avatars_request_avatar_impl:
 * @self: The object implementing this interface
 * @in_Contact: guint  (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * RequestAvatar on interface org.freedesktop.Telepathy.Connection.Interface.Avatars.
 */
/**
 * tp_svc_connection_interface_avatars_implement_request_avatar:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the RequestAvatar D-Bus method
 *
 * Register an implementation for the RequestAvatar method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_connection_interface_avatars_return_from_request_avatar:
 * @context: The D-Bus method invocation context
 * @out_Data: const GArray * (FIXME, generate documentation)
 * @out_MIME_Type: const gchar * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_connection_interface_avatars_request_avatars_impl:
 * @self: The object implementing this interface
 * @in_Contacts: const GArray * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * RequestAvatars on interface org.freedesktop.Telepathy.Connection.Interface.Avatars.
 */
/**
 * tp_svc_connection_interface_avatars_implement_request_avatars:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the RequestAvatars D-Bus method
 *
 * Register an implementation for the RequestAvatars method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_connection_interface_avatars_return_from_request_avatars:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_connection_interface_avatars_set_avatar_impl:
 * @self: The object implementing this interface
 * @in_Avatar: const GArray * (FIXME, generate documentation)
 * @in_MIME_Type: const gchar * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * SetAvatar on interface org.freedesktop.Telepathy.Connection.Interface.Avatars.
 */
/**
 * tp_svc_connection_interface_avatars_implement_set_avatar:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the SetAvatar D-Bus method
 *
 * Register an implementation for the SetAvatar method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_connection_interface_avatars_return_from_set_avatar:
 * @context: The D-Bus method invocation context
 * @out_Token: const gchar * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_connection_interface_avatars_clear_avatar_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * ClearAvatar on interface org.freedesktop.Telepathy.Connection.Interface.Avatars.
 */
/**
 * tp_svc_connection_interface_avatars_implement_clear_avatar:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the ClearAvatar D-Bus method
 *
 * Register an implementation for the ClearAvatar method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_connection_interface_avatars_return_from_clear_avatar:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_connection_interface_avatars_emit_avatar_updated:
 * @instance: The object implementing this interface
 * @arg_Contact: guint  (FIXME, generate documentation)
 * @arg_New_Avatar_Token: const gchar * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * AvatarUpdated signal on interface org.freedesktop.Telepathy.Connection.Interface.Avatars.
 */
/**
 * TpSvcConnectionInterfaceAvatars::avatar-updated:
 * @arg_Contact: guint  (FIXME, generate documentation)
 * @arg_New_Avatar_Token: const gchar * (FIXME, generate documentation)
 *
 * The AvatarUpdated D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * tp_svc_connection_interface_avatars_emit_avatar_retrieved:
 * @instance: The object implementing this interface
 * @arg_Contact: guint  (FIXME, generate documentation)
 * @arg_Token: const gchar * (FIXME, generate documentation)
 * @arg_Avatar: const GArray * (FIXME, generate documentation)
 * @arg_Type: const gchar * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * AvatarRetrieved signal on interface org.freedesktop.Telepathy.Connection.Interface.Avatars.
 */
/**
 * TpSvcConnectionInterfaceAvatars::avatar-retrieved:
 * @arg_Contact: guint  (FIXME, generate documentation)
 * @arg_Token: const gchar * (FIXME, generate documentation)
 * @arg_Avatar: const GArray * (FIXME, generate documentation)
 * @arg_Type: const gchar * (FIXME, generate documentation)
 *
 * The AvatarRetrieved D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * TpSvcConnectionInterfaceBalance:
 *
 * Dummy typedef representing any implementation of this interface.
 */
/**
 * TpSvcConnectionInterfaceBalanceClass:
 *
 * The class of TpSvcConnectionInterfaceBalance.
 * This interface has no D-Bus methods, so an
 * implementation can typically pass %NULL to
 * G_IMPLEMENT_INTERFACE() as the interface
 * initialization function.
 */

/**
 * tp_svc_connection_interface_balance_emit_balance_changed:
 * @instance: The object implementing this interface
 * @arg_Balance: const GValueArray * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * BalanceChanged signal on interface org.freedesktop.Telepathy.Connection.Interface.Balance.
 */
/**
 * TpSvcConnectionInterfaceBalance::balance-changed:
 * @arg_Balance: const GValueArray * (FIXME, generate documentation)
 *
 * The BalanceChanged D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * TpSvcConnectionInterfaceCapabilities:
 *
 * Dummy typedef representing any implementation of this interface.
 */
/**
 * TpSvcConnectionInterfaceCapabilitiesClass:
 *
 * The class of TpSvcConnectionInterfaceCapabilities.
 *
 * In a full implementation of this interface (i.e. all
 * methods implemented), the interface initialization
 * function used in G_IMPLEMENT_INTERFACE() would
 * typically look like this:
 *
 * <programlisting>
 * static void
 * implement_connection_interface_capabilities (gpointer klass,
 *     gpointer unused G_GNUC_UNUSED)
 * {
 * #define IMPLEMENT(x) tp_svc_connection_interface_capabilities_implement_&num;&num;x (\
 *   klass, my_object_&num;&num;x)
 *   IMPLEMENT (advertise_capabilities);
 *   IMPLEMENT (get_capabilities);
 * #undef IMPLEMENT
 * }
 * </programlisting>
 */

/**
 * tp_svc_connection_interface_capabilities_advertise_capabilities_impl:
 * @self: The object implementing this interface
 * @in_Add: const GPtrArray * (FIXME, generate documentation)
 * @in_Remove: const gchar ** (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * AdvertiseCapabilities on interface org.freedesktop.Telepathy.Connection.Interface.Capabilities.
 */
/**
 * tp_svc_connection_interface_capabilities_implement_advertise_capabilities:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the AdvertiseCapabilities D-Bus method
 *
 * Register an implementation for the AdvertiseCapabilities method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_connection_interface_capabilities_return_from_advertise_capabilities:
 * @context: The D-Bus method invocation context
 * @out_Self_Capabilities: const GPtrArray * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_connection_interface_capabilities_get_capabilities_impl:
 * @self: The object implementing this interface
 * @in_Handles: const GArray * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetCapabilities on interface org.freedesktop.Telepathy.Connection.Interface.Capabilities.
 */
/**
 * tp_svc_connection_interface_capabilities_implement_get_capabilities:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetCapabilities D-Bus method
 *
 * Register an implementation for the GetCapabilities method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_connection_interface_capabilities_return_from_get_capabilities:
 * @context: The D-Bus method invocation context
 * @out_Contact_Capabilities: const GPtrArray * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_connection_interface_capabilities_emit_capabilities_changed:
 * @instance: The object implementing this interface
 * @arg_Caps: const GPtrArray * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * CapabilitiesChanged signal on interface org.freedesktop.Telepathy.Connection.Interface.Capabilities.
 */
/**
 * TpSvcConnectionInterfaceCapabilities::capabilities-changed:
 * @arg_Caps: const GPtrArray * (FIXME, generate documentation)
 *
 * The CapabilitiesChanged D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * TpSvcConnectionInterfaceCellular:
 *
 * Dummy typedef representing any implementation of this interface.
 */
/**
 * TpSvcConnectionInterfaceCellularClass:
 *
 * The class of TpSvcConnectionInterfaceCellular.
 * This interface has no D-Bus methods, so an
 * implementation can typically pass %NULL to
 * G_IMPLEMENT_INTERFACE() as the interface
 * initialization function.
 */

/**
 * tp_svc_connection_interface_cellular_emit_imsi_changed:
 * @instance: The object implementing this interface
 * @arg_IMSI: const gchar * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * IMSIChanged signal on interface org.freedesktop.Telepathy.Connection.Interface.Cellular.
 */
/**
 * TpSvcConnectionInterfaceCellular::i-ms-ichanged:
 * @arg_IMSI: const gchar * (FIXME, generate documentation)
 *
 * The IMSIChanged D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * TpSvcConnectionInterfaceContactCapabilities:
 *
 * Dummy typedef representing any implementation of this interface.
 */
/**
 * TpSvcConnectionInterfaceContactCapabilitiesClass:
 *
 * The class of TpSvcConnectionInterfaceContactCapabilities.
 *
 * In a full implementation of this interface (i.e. all
 * methods implemented), the interface initialization
 * function used in G_IMPLEMENT_INTERFACE() would
 * typically look like this:
 *
 * <programlisting>
 * static void
 * implement_connection_interface_contact_capabilities (gpointer klass,
 *     gpointer unused G_GNUC_UNUSED)
 * {
 * #define IMPLEMENT(x) tp_svc_connection_interface_contact_capabilities_implement_&num;&num;x (\
 *   klass, my_object_&num;&num;x)
 *   IMPLEMENT (update_capabilities);
 *   IMPLEMENT (get_contact_capabilities);
 * #undef IMPLEMENT
 * }
 * </programlisting>
 */

/**
 * tp_svc_connection_interface_contact_capabilities_update_capabilities_impl:
 * @self: The object implementing this interface
 * @in_Handler_Capabilities: const GPtrArray * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * UpdateCapabilities on interface org.freedesktop.Telepathy.Connection.Interface.ContactCapabilities.
 */
/**
 * tp_svc_connection_interface_contact_capabilities_implement_update_capabilities:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the UpdateCapabilities D-Bus method
 *
 * Register an implementation for the UpdateCapabilities method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_connection_interface_contact_capabilities_return_from_update_capabilities:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_connection_interface_contact_capabilities_get_contact_capabilities_impl:
 * @self: The object implementing this interface
 * @in_Handles: const GArray * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetContactCapabilities on interface org.freedesktop.Telepathy.Connection.Interface.ContactCapabilities.
 */
/**
 * tp_svc_connection_interface_contact_capabilities_implement_get_contact_capabilities:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetContactCapabilities D-Bus method
 *
 * Register an implementation for the GetContactCapabilities method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_connection_interface_contact_capabilities_return_from_get_contact_capabilities:
 * @context: The D-Bus method invocation context
 * @out_Contact_Capabilities: GHashTable * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_connection_interface_contact_capabilities_emit_contact_capabilities_changed:
 * @instance: The object implementing this interface
 * @arg_caps: GHashTable * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * ContactCapabilitiesChanged signal on interface org.freedesktop.Telepathy.Connection.Interface.ContactCapabilities.
 */
/**
 * TpSvcConnectionInterfaceContactCapabilities::contact-capabilities-changed:
 * @arg_caps: GHashTable * (FIXME, generate documentation)
 *
 * The ContactCapabilitiesChanged D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * TpSvcConnectionInterfaceContactInfo:
 *
 * Dummy typedef representing any implementation of this interface.
 */
/**
 * TpSvcConnectionInterfaceContactInfoClass:
 *
 * The class of TpSvcConnectionInterfaceContactInfo.
 *
 * In a full implementation of this interface (i.e. all
 * methods implemented), the interface initialization
 * function used in G_IMPLEMENT_INTERFACE() would
 * typically look like this:
 *
 * <programlisting>
 * static void
 * implement_connection_interface_contact_info (gpointer klass,
 *     gpointer unused G_GNUC_UNUSED)
 * {
 * #define IMPLEMENT(x) tp_svc_connection_interface_contact_info_implement_&num;&num;x (\
 *   klass, my_object_&num;&num;x)
 *   IMPLEMENT (get_contact_info);
 *   IMPLEMENT (refresh_contact_info);
 *   IMPLEMENT (request_contact_info);
 *   IMPLEMENT (set_contact_info);
 * #undef IMPLEMENT
 * }
 * </programlisting>
 */

/**
 * tp_svc_connection_interface_contact_info_get_contact_info_impl:
 * @self: The object implementing this interface
 * @in_Contacts: const GArray * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetContactInfo on interface org.freedesktop.Telepathy.Connection.Interface.ContactInfo.
 */
/**
 * tp_svc_connection_interface_contact_info_implement_get_contact_info:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetContactInfo D-Bus method
 *
 * Register an implementation for the GetContactInfo method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_connection_interface_contact_info_return_from_get_contact_info:
 * @context: The D-Bus method invocation context
 * @out_ContactInfo: GHashTable * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_connection_interface_contact_info_refresh_contact_info_impl:
 * @self: The object implementing this interface
 * @in_Contacts: const GArray * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * RefreshContactInfo on interface org.freedesktop.Telepathy.Connection.Interface.ContactInfo.
 */
/**
 * tp_svc_connection_interface_contact_info_implement_refresh_contact_info:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the RefreshContactInfo D-Bus method
 *
 * Register an implementation for the RefreshContactInfo method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_connection_interface_contact_info_return_from_refresh_contact_info:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_connection_interface_contact_info_request_contact_info_impl:
 * @self: The object implementing this interface
 * @in_Contact: guint  (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * RequestContactInfo on interface org.freedesktop.Telepathy.Connection.Interface.ContactInfo.
 */
/**
 * tp_svc_connection_interface_contact_info_implement_request_contact_info:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the RequestContactInfo D-Bus method
 *
 * Register an implementation for the RequestContactInfo method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_connection_interface_contact_info_return_from_request_contact_info:
 * @context: The D-Bus method invocation context
 * @out_Contact_Info: const GPtrArray * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_connection_interface_contact_info_set_contact_info_impl:
 * @self: The object implementing this interface
 * @in_ContactInfo: const GPtrArray * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * SetContactInfo on interface org.freedesktop.Telepathy.Connection.Interface.ContactInfo.
 */
/**
 * tp_svc_connection_interface_contact_info_implement_set_contact_info:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the SetContactInfo D-Bus method
 *
 * Register an implementation for the SetContactInfo method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_connection_interface_contact_info_return_from_set_contact_info:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_connection_interface_contact_info_emit_contact_info_changed:
 * @instance: The object implementing this interface
 * @arg_Contact: guint  (FIXME, generate documentation)
 * @arg_ContactInfo: const GPtrArray * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * ContactInfoChanged signal on interface org.freedesktop.Telepathy.Connection.Interface.ContactInfo.
 */
/**
 * TpSvcConnectionInterfaceContactInfo::contact-info-changed:
 * @arg_Contact: guint  (FIXME, generate documentation)
 * @arg_ContactInfo: const GPtrArray * (FIXME, generate documentation)
 *
 * The ContactInfoChanged D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * TpSvcConnectionInterfaceContacts:
 *
 * Dummy typedef representing any implementation of this interface.
 */
/**
 * TpSvcConnectionInterfaceContactsClass:
 *
 * The class of TpSvcConnectionInterfaceContacts.
 *
 * In a full implementation of this interface (i.e. all
 * methods implemented), the interface initialization
 * function used in G_IMPLEMENT_INTERFACE() would
 * typically look like this:
 *
 * <programlisting>
 * static void
 * implement_connection_interface_contacts (gpointer klass,
 *     gpointer unused G_GNUC_UNUSED)
 * {
 * #define IMPLEMENT(x) tp_svc_connection_interface_contacts_implement_&num;&num;x (\
 *   klass, my_object_&num;&num;x)
 *   IMPLEMENT (get_contact_attributes);
 * #undef IMPLEMENT
 * }
 * </programlisting>
 */

/**
 * tp_svc_connection_interface_contacts_get_contact_attributes_impl:
 * @self: The object implementing this interface
 * @in_Handles: const GArray * (FIXME, generate documentation)
 * @in_Interfaces: const gchar ** (FIXME, generate documentation)
 * @in_Hold: gboolean  (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetContactAttributes on interface org.freedesktop.Telepathy.Connection.Interface.Contacts.
 */
/**
 * tp_svc_connection_interface_contacts_implement_get_contact_attributes:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetContactAttributes D-Bus method
 *
 * Register an implementation for the GetContactAttributes method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_connection_interface_contacts_return_from_get_contact_attributes:
 * @context: The D-Bus method invocation context
 * @out_Attributes: GHashTable * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * TpSvcConnectionInterfaceLocation:
 *
 * Dummy typedef representing any implementation of this interface.
 */
/**
 * TpSvcConnectionInterfaceLocationClass:
 *
 * The class of TpSvcConnectionInterfaceLocation.
 *
 * In a full implementation of this interface (i.e. all
 * methods implemented), the interface initialization
 * function used in G_IMPLEMENT_INTERFACE() would
 * typically look like this:
 *
 * <programlisting>
 * static void
 * implement_connection_interface_location (gpointer klass,
 *     gpointer unused G_GNUC_UNUSED)
 * {
 * #define IMPLEMENT(x) tp_svc_connection_interface_location_implement_&num;&num;x (\
 *   klass, my_object_&num;&num;x)
 *   IMPLEMENT (get_locations);
 *   IMPLEMENT (request_location);
 *   IMPLEMENT (set_location);
 * #undef IMPLEMENT
 * }
 * </programlisting>
 */

/**
 * tp_svc_connection_interface_location_get_locations_impl:
 * @self: The object implementing this interface
 * @in_Contacts: const GArray * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetLocations on interface org.freedesktop.Telepathy.Connection.Interface.Location.
 */
/**
 * tp_svc_connection_interface_location_implement_get_locations:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetLocations D-Bus method
 *
 * Register an implementation for the GetLocations method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_connection_interface_location_return_from_get_locations:
 * @context: The D-Bus method invocation context
 * @out_Locations: GHashTable * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_connection_interface_location_request_location_impl:
 * @self: The object implementing this interface
 * @in_Contact: guint  (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * RequestLocation on interface org.freedesktop.Telepathy.Connection.Interface.Location.
 */
/**
 * tp_svc_connection_interface_location_implement_request_location:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the RequestLocation D-Bus method
 *
 * Register an implementation for the RequestLocation method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_connection_interface_location_return_from_request_location:
 * @context: The D-Bus method invocation context
 * @out_Location: GHashTable * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_connection_interface_location_set_location_impl:
 * @self: The object implementing this interface
 * @in_Location: GHashTable * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * SetLocation on interface org.freedesktop.Telepathy.Connection.Interface.Location.
 */
/**
 * tp_svc_connection_interface_location_implement_set_location:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the SetLocation D-Bus method
 *
 * Register an implementation for the SetLocation method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_connection_interface_location_return_from_set_location:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_connection_interface_location_emit_location_updated:
 * @instance: The object implementing this interface
 * @arg_Contact: guint  (FIXME, generate documentation)
 * @arg_Location: GHashTable * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * LocationUpdated signal on interface org.freedesktop.Telepathy.Connection.Interface.Location.
 */
/**
 * TpSvcConnectionInterfaceLocation::location-updated:
 * @arg_Contact: guint  (FIXME, generate documentation)
 * @arg_Location: GHashTable * (FIXME, generate documentation)
 *
 * The LocationUpdated D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * TpSvcConnectionInterfacePresence:
 *
 * Dummy typedef representing any implementation of this interface.
 */
/**
 * TpSvcConnectionInterfacePresenceClass:
 *
 * The class of TpSvcConnectionInterfacePresence.
 *
 * In a full implementation of this interface (i.e. all
 * methods implemented), the interface initialization
 * function used in G_IMPLEMENT_INTERFACE() would
 * typically look like this:
 *
 * <programlisting>
 * static void
 * implement_connection_interface_presence (gpointer klass,
 *     gpointer unused G_GNUC_UNUSED)
 * {
 * #define IMPLEMENT(x) tp_svc_connection_interface_presence_implement_&num;&num;x (\
 *   klass, my_object_&num;&num;x)
 *   IMPLEMENT (add_status);
 *   IMPLEMENT (clear_status);
 *   IMPLEMENT (get_presence);
 *   IMPLEMENT (get_statuses);
 *   IMPLEMENT (remove_status);
 *   IMPLEMENT (request_presence);
 *   IMPLEMENT (set_last_activity_time);
 *   IMPLEMENT (set_status);
 * #undef IMPLEMENT
 * }
 * </programlisting>
 */

/**
 * tp_svc_connection_interface_presence_add_status_impl:
 * @self: The object implementing this interface
 * @in_Status: const gchar * (FIXME, generate documentation)
 * @in_Parameters: GHashTable * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * AddStatus on interface org.freedesktop.Telepathy.Connection.Interface.Presence.
 */
/**
 * tp_svc_connection_interface_presence_implement_add_status:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the AddStatus D-Bus method
 *
 * Register an implementation for the AddStatus method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_connection_interface_presence_return_from_add_status:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_connection_interface_presence_clear_status_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * ClearStatus on interface org.freedesktop.Telepathy.Connection.Interface.Presence.
 */
/**
 * tp_svc_connection_interface_presence_implement_clear_status:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the ClearStatus D-Bus method
 *
 * Register an implementation for the ClearStatus method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_connection_interface_presence_return_from_clear_status:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_connection_interface_presence_get_presence_impl:
 * @self: The object implementing this interface
 * @in_Contacts: const GArray * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetPresence on interface org.freedesktop.Telepathy.Connection.Interface.Presence.
 */
/**
 * tp_svc_connection_interface_presence_implement_get_presence:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetPresence D-Bus method
 *
 * Register an implementation for the GetPresence method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_connection_interface_presence_return_from_get_presence:
 * @context: The D-Bus method invocation context
 * @out_Presence: GHashTable * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_connection_interface_presence_get_statuses_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetStatuses on interface org.freedesktop.Telepathy.Connection.Interface.Presence.
 */
/**
 * tp_svc_connection_interface_presence_implement_get_statuses:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetStatuses D-Bus method
 *
 * Register an implementation for the GetStatuses method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_connection_interface_presence_return_from_get_statuses:
 * @context: The D-Bus method invocation context
 * @out_Available_Statuses: GHashTable * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_connection_interface_presence_remove_status_impl:
 * @self: The object implementing this interface
 * @in_Status: const gchar * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * RemoveStatus on interface org.freedesktop.Telepathy.Connection.Interface.Presence.
 */
/**
 * tp_svc_connection_interface_presence_implement_remove_status:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the RemoveStatus D-Bus method
 *
 * Register an implementation for the RemoveStatus method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_connection_interface_presence_return_from_remove_status:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_connection_interface_presence_request_presence_impl:
 * @self: The object implementing this interface
 * @in_Contacts: const GArray * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * RequestPresence on interface org.freedesktop.Telepathy.Connection.Interface.Presence.
 */
/**
 * tp_svc_connection_interface_presence_implement_request_presence:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the RequestPresence D-Bus method
 *
 * Register an implementation for the RequestPresence method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_connection_interface_presence_return_from_request_presence:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_connection_interface_presence_set_last_activity_time_impl:
 * @self: The object implementing this interface
 * @in_Time: guint  (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * SetLastActivityTime on interface org.freedesktop.Telepathy.Connection.Interface.Presence.
 */
/**
 * tp_svc_connection_interface_presence_implement_set_last_activity_time:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the SetLastActivityTime D-Bus method
 *
 * Register an implementation for the SetLastActivityTime method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_connection_interface_presence_return_from_set_last_activity_time:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_connection_interface_presence_set_status_impl:
 * @self: The object implementing this interface
 * @in_Statuses: GHashTable * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * SetStatus on interface org.freedesktop.Telepathy.Connection.Interface.Presence.
 */
/**
 * tp_svc_connection_interface_presence_implement_set_status:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the SetStatus D-Bus method
 *
 * Register an implementation for the SetStatus method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_connection_interface_presence_return_from_set_status:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_connection_interface_presence_emit_presence_update:
 * @instance: The object implementing this interface
 * @arg_Presence: GHashTable * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * PresenceUpdate signal on interface org.freedesktop.Telepathy.Connection.Interface.Presence.
 */
/**
 * TpSvcConnectionInterfacePresence::presence-update:
 * @arg_Presence: GHashTable * (FIXME, generate documentation)
 *
 * The PresenceUpdate D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * TpSvcConnectionInterfaceRequests:
 *
 * Dummy typedef representing any implementation of this interface.
 */
/**
 * TpSvcConnectionInterfaceRequestsClass:
 *
 * The class of TpSvcConnectionInterfaceRequests.
 *
 * In a full implementation of this interface (i.e. all
 * methods implemented), the interface initialization
 * function used in G_IMPLEMENT_INTERFACE() would
 * typically look like this:
 *
 * <programlisting>
 * static void
 * implement_connection_interface_requests (gpointer klass,
 *     gpointer unused G_GNUC_UNUSED)
 * {
 * #define IMPLEMENT(x) tp_svc_connection_interface_requests_implement_&num;&num;x (\
 *   klass, my_object_&num;&num;x)
 *   IMPLEMENT (create_channel);
 *   IMPLEMENT (ensure_channel);
 * #undef IMPLEMENT
 * }
 * </programlisting>
 */

/**
 * tp_svc_connection_interface_requests_create_channel_impl:
 * @self: The object implementing this interface
 * @in_Request: GHashTable * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * CreateChannel on interface org.freedesktop.Telepathy.Connection.Interface.Requests.
 */
/**
 * tp_svc_connection_interface_requests_implement_create_channel:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the CreateChannel D-Bus method
 *
 * Register an implementation for the CreateChannel method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_connection_interface_requests_return_from_create_channel:
 * @context: The D-Bus method invocation context
 * @out_Channel: const gchar * (FIXME, generate documentation)
 * @out_Properties: GHashTable * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_connection_interface_requests_ensure_channel_impl:
 * @self: The object implementing this interface
 * @in_Request: GHashTable * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * EnsureChannel on interface org.freedesktop.Telepathy.Connection.Interface.Requests.
 */
/**
 * tp_svc_connection_interface_requests_implement_ensure_channel:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the EnsureChannel D-Bus method
 *
 * Register an implementation for the EnsureChannel method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_connection_interface_requests_return_from_ensure_channel:
 * @context: The D-Bus method invocation context
 * @out_Yours: gboolean  (FIXME, generate documentation)
 * @out_Channel: const gchar * (FIXME, generate documentation)
 * @out_Properties: GHashTable * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_connection_interface_requests_emit_new_channels:
 * @instance: The object implementing this interface
 * @arg_Channels: const GPtrArray * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * NewChannels signal on interface org.freedesktop.Telepathy.Connection.Interface.Requests.
 */
/**
 * TpSvcConnectionInterfaceRequests::new-channels:
 * @arg_Channels: const GPtrArray * (FIXME, generate documentation)
 *
 * The NewChannels D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * tp_svc_connection_interface_requests_emit_channel_closed:
 * @instance: The object implementing this interface
 * @arg_Removed: const gchar * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * ChannelClosed signal on interface org.freedesktop.Telepathy.Connection.Interface.Requests.
 */
/**
 * TpSvcConnectionInterfaceRequests::channel-closed:
 * @arg_Removed: const gchar * (FIXME, generate documentation)
 *
 * The ChannelClosed D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * TpSvcConnectionInterfaceServicePoint:
 *
 * Dummy typedef representing any implementation of this interface.
 */
/**
 * TpSvcConnectionInterfaceServicePointClass:
 *
 * The class of TpSvcConnectionInterfaceServicePoint.
 * This interface has no D-Bus methods, so an
 * implementation can typically pass %NULL to
 * G_IMPLEMENT_INTERFACE() as the interface
 * initialization function.
 */

/**
 * tp_svc_connection_interface_service_point_emit_service_points_changed:
 * @instance: The object implementing this interface
 * @arg_Service_Points: const GPtrArray * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * ServicePointsChanged signal on interface org.freedesktop.Telepathy.Connection.Interface.ServicePoint.
 */
/**
 * TpSvcConnectionInterfaceServicePoint::service-points-changed:
 * @arg_Service_Points: const GPtrArray * (FIXME, generate documentation)
 *
 * The ServicePointsChanged D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * TpSvcConnectionInterfaceSimplePresence:
 *
 * Dummy typedef representing any implementation of this interface.
 */
/**
 * TpSvcConnectionInterfaceSimplePresenceClass:
 *
 * The class of TpSvcConnectionInterfaceSimplePresence.
 *
 * In a full implementation of this interface (i.e. all
 * methods implemented), the interface initialization
 * function used in G_IMPLEMENT_INTERFACE() would
 * typically look like this:
 *
 * <programlisting>
 * static void
 * implement_connection_interface_simple_presence (gpointer klass,
 *     gpointer unused G_GNUC_UNUSED)
 * {
 * #define IMPLEMENT(x) tp_svc_connection_interface_simple_presence_implement_&num;&num;x (\
 *   klass, my_object_&num;&num;x)
 *   IMPLEMENT (set_presence);
 *   IMPLEMENT (get_presences);
 * #undef IMPLEMENT
 * }
 * </programlisting>
 */

/**
 * tp_svc_connection_interface_simple_presence_set_presence_impl:
 * @self: The object implementing this interface
 * @in_Status: const gchar * (FIXME, generate documentation)
 * @in_Status_Message: const gchar * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * SetPresence on interface org.freedesktop.Telepathy.Connection.Interface.SimplePresence.
 */
/**
 * tp_svc_connection_interface_simple_presence_implement_set_presence:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the SetPresence D-Bus method
 *
 * Register an implementation for the SetPresence method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_connection_interface_simple_presence_return_from_set_presence:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_connection_interface_simple_presence_get_presences_impl:
 * @self: The object implementing this interface
 * @in_Contacts: const GArray * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetPresences on interface org.freedesktop.Telepathy.Connection.Interface.SimplePresence.
 */
/**
 * tp_svc_connection_interface_simple_presence_implement_get_presences:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetPresences D-Bus method
 *
 * Register an implementation for the GetPresences method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_connection_interface_simple_presence_return_from_get_presences:
 * @context: The D-Bus method invocation context
 * @out_Presence: GHashTable * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_connection_interface_simple_presence_emit_presences_changed:
 * @instance: The object implementing this interface
 * @arg_Presence: GHashTable * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * PresencesChanged signal on interface org.freedesktop.Telepathy.Connection.Interface.SimplePresence.
 */
/**
 * TpSvcConnectionInterfaceSimplePresence::presences-changed:
 * @arg_Presence: GHashTable * (FIXME, generate documentation)
 *
 * The PresencesChanged D-Bus signal is emitted whenever this GObject signal is.
 */
