/**
 * TpSvcChannel:
 *
 * Dummy typedef representing any implementation of this interface.
 */
/**
 * TpSvcChannelClass:
 *
 * The class of TpSvcChannel.
 *
 * In a full implementation of this interface (i.e. all
 * methods implemented), the interface initialization
 * function used in G_IMPLEMENT_INTERFACE() would
 * typically look like this:
 *
 * <programlisting>
 * static void
 * implement_channel (gpointer klass,
 *     gpointer unused G_GNUC_UNUSED)
 * {
 * #define IMPLEMENT(x) tp_svc_channel_implement_&num;&num;x (\
 *   klass, my_object_&num;&num;x)
 *   IMPLEMENT (close);
 *   IMPLEMENT (get_channel_type);
 *   IMPLEMENT (get_handle);
 *   IMPLEMENT (get_interfaces);
 * #undef IMPLEMENT
 * }
 * </programlisting>
 */

/**
 * tp_svc_channel_close_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * Close on interface org.freedesktop.Telepathy.Channel.
 */
/**
 * tp_svc_channel_implement_close:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the Close D-Bus method
 *
 * Register an implementation for the Close method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_return_from_close:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_get_channel_type_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetChannelType on interface org.freedesktop.Telepathy.Channel.
 */
/**
 * tp_svc_channel_implement_get_channel_type:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetChannelType D-Bus method
 *
 * Register an implementation for the GetChannelType method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_return_from_get_channel_type:
 * @context: The D-Bus method invocation context
 * @out_Channel_Type: const gchar * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_get_handle_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetHandle on interface org.freedesktop.Telepathy.Channel.
 */
/**
 * tp_svc_channel_implement_get_handle:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetHandle D-Bus method
 *
 * Register an implementation for the GetHandle method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_return_from_get_handle:
 * @context: The D-Bus method invocation context
 * @out_Target_Handle_Type: guint  (FIXME, generate documentation)
 * @out_Target_Handle: guint  (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_get_interfaces_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetInterfaces on interface org.freedesktop.Telepathy.Channel.
 */
/**
 * tp_svc_channel_implement_get_interfaces:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetInterfaces D-Bus method
 *
 * Register an implementation for the GetInterfaces method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_return_from_get_interfaces:
 * @context: The D-Bus method invocation context
 * @out_Interfaces: const gchar ** (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_emit_closed:
 * @instance: The object implementing this interface
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * Closed signal on interface org.freedesktop.Telepathy.Channel.
 */
/**
 * TpSvcChannel::closed:
 *
 * The Closed D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * TpSvcChannelInterfaceAnonymity:
 *
 * Dummy typedef representing any implementation of this interface.
 */
/**
 * TpSvcChannelInterfaceAnonymityClass:
 *
 * The class of TpSvcChannelInterfaceAnonymity.
 * This interface has no D-Bus methods, so an
 * implementation can typically pass %NULL to
 * G_IMPLEMENT_INTERFACE() as the interface
 * initialization function.
 */

/**
 * TpSvcChannelInterfaceCallState:
 *
 * Dummy typedef representing any implementation of this interface.
 */
/**
 * TpSvcChannelInterfaceCallStateClass:
 *
 * The class of TpSvcChannelInterfaceCallState.
 *
 * In a full implementation of this interface (i.e. all
 * methods implemented), the interface initialization
 * function used in G_IMPLEMENT_INTERFACE() would
 * typically look like this:
 *
 * <programlisting>
 * static void
 * implement_channel_interface_call_state (gpointer klass,
 *     gpointer unused G_GNUC_UNUSED)
 * {
 * #define IMPLEMENT(x) tp_svc_channel_interface_call_state_implement_&num;&num;x (\
 *   klass, my_object_&num;&num;x)
 *   IMPLEMENT (get_call_states);
 * #undef IMPLEMENT
 * }
 * </programlisting>
 */

/**
 * tp_svc_channel_interface_call_state_get_call_states_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetCallStates on interface org.freedesktop.Telepathy.Channel.Interface.CallState.
 */
/**
 * tp_svc_channel_interface_call_state_implement_get_call_states:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetCallStates D-Bus method
 *
 * Register an implementation for the GetCallStates method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_interface_call_state_return_from_get_call_states:
 * @context: The D-Bus method invocation context
 * @out_States: GHashTable * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_interface_call_state_emit_call_state_changed:
 * @instance: The object implementing this interface
 * @arg_Contact: guint  (FIXME, generate documentation)
 * @arg_State: guint  (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * CallStateChanged signal on interface org.freedesktop.Telepathy.Channel.Interface.CallState.
 */
/**
 * TpSvcChannelInterfaceCallState::call-state-changed:
 * @arg_Contact: guint  (FIXME, generate documentation)
 * @arg_State: guint  (FIXME, generate documentation)
 *
 * The CallStateChanged D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * TpSvcChannelInterfaceChatState:
 *
 * Dummy typedef representing any implementation of this interface.
 */
/**
 * TpSvcChannelInterfaceChatStateClass:
 *
 * The class of TpSvcChannelInterfaceChatState.
 *
 * In a full implementation of this interface (i.e. all
 * methods implemented), the interface initialization
 * function used in G_IMPLEMENT_INTERFACE() would
 * typically look like this:
 *
 * <programlisting>
 * static void
 * implement_channel_interface_chat_state (gpointer klass,
 *     gpointer unused G_GNUC_UNUSED)
 * {
 * #define IMPLEMENT(x) tp_svc_channel_interface_chat_state_implement_&num;&num;x (\
 *   klass, my_object_&num;&num;x)
 *   IMPLEMENT (set_chat_state);
 * #undef IMPLEMENT
 * }
 * </programlisting>
 */

/**
 * tp_svc_channel_interface_chat_state_set_chat_state_impl:
 * @self: The object implementing this interface
 * @in_State: guint  (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * SetChatState on interface org.freedesktop.Telepathy.Channel.Interface.ChatState.
 */
/**
 * tp_svc_channel_interface_chat_state_implement_set_chat_state:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the SetChatState D-Bus method
 *
 * Register an implementation for the SetChatState method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_interface_chat_state_return_from_set_chat_state:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_interface_chat_state_emit_chat_state_changed:
 * @instance: The object implementing this interface
 * @arg_Contact: guint  (FIXME, generate documentation)
 * @arg_State: guint  (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * ChatStateChanged signal on interface org.freedesktop.Telepathy.Channel.Interface.ChatState.
 */
/**
 * TpSvcChannelInterfaceChatState::chat-state-changed:
 * @arg_Contact: guint  (FIXME, generate documentation)
 * @arg_State: guint  (FIXME, generate documentation)
 *
 * The ChatStateChanged D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * TpSvcChannelInterfaceConference:
 *
 * Dummy typedef representing any implementation of this interface.
 */
/**
 * TpSvcChannelInterfaceConferenceClass:
 *
 * The class of TpSvcChannelInterfaceConference.
 * This interface has no D-Bus methods, so an
 * implementation can typically pass %NULL to
 * G_IMPLEMENT_INTERFACE() as the interface
 * initialization function.
 */

/**
 * tp_svc_channel_interface_conference_emit_channel_merged:
 * @instance: The object implementing this interface
 * @arg_Channel: const gchar * (FIXME, generate documentation)
 * @arg_Channel_Specific_Handle: guint  (FIXME, generate documentation)
 * @arg_Properties: GHashTable * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * ChannelMerged signal on interface org.freedesktop.Telepathy.Channel.Interface.Conference.
 */
/**
 * TpSvcChannelInterfaceConference::channel-merged:
 * @arg_Channel: const gchar * (FIXME, generate documentation)
 * @arg_Channel_Specific_Handle: guint  (FIXME, generate documentation)
 * @arg_Properties: GHashTable * (FIXME, generate documentation)
 *
 * The ChannelMerged D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * tp_svc_channel_interface_conference_emit_channel_removed:
 * @instance: The object implementing this interface
 * @arg_Channel: const gchar * (FIXME, generate documentation)
 * @arg_Details: GHashTable * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * ChannelRemoved signal on interface org.freedesktop.Telepathy.Channel.Interface.Conference.
 */
/**
 * TpSvcChannelInterfaceConference::channel-removed:
 * @arg_Channel: const gchar * (FIXME, generate documentation)
 * @arg_Details: GHashTable * (FIXME, generate documentation)
 *
 * The ChannelRemoved D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * TpSvcChannelInterfaceDTMF:
 *
 * Dummy typedef representing any implementation of this interface.
 */
/**
 * TpSvcChannelInterfaceDTMFClass:
 *
 * The class of TpSvcChannelInterfaceDTMF.
 *
 * In a full implementation of this interface (i.e. all
 * methods implemented), the interface initialization
 * function used in G_IMPLEMENT_INTERFACE() would
 * typically look like this:
 *
 * <programlisting>
 * static void
 * implement_channel_interface_dtmf (gpointer klass,
 *     gpointer unused G_GNUC_UNUSED)
 * {
 * #define IMPLEMENT(x) tp_svc_channel_interface_dtmf_implement_&num;&num;x (\
 *   klass, my_object_&num;&num;x)
 *   IMPLEMENT (start_tone);
 *   IMPLEMENT (stop_tone);
 *   IMPLEMENT (multiple_tones);
 * #undef IMPLEMENT
 * }
 * </programlisting>
 */

/**
 * tp_svc_channel_interface_dtmf_start_tone_impl:
 * @self: The object implementing this interface
 * @in_Stream_ID: guint  (FIXME, generate documentation)
 * @in_Event: guchar  (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * StartTone on interface org.freedesktop.Telepathy.Channel.Interface.DTMF.
 */
/**
 * tp_svc_channel_interface_dtmf_implement_start_tone:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the StartTone D-Bus method
 *
 * Register an implementation for the StartTone method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_interface_dtmf_return_from_start_tone:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_interface_dtmf_stop_tone_impl:
 * @self: The object implementing this interface
 * @in_Stream_ID: guint  (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * StopTone on interface org.freedesktop.Telepathy.Channel.Interface.DTMF.
 */
/**
 * tp_svc_channel_interface_dtmf_implement_stop_tone:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the StopTone D-Bus method
 *
 * Register an implementation for the StopTone method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_interface_dtmf_return_from_stop_tone:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_interface_dtmf_multiple_tones_impl:
 * @self: The object implementing this interface
 * @in_Tones: const gchar * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * MultipleTones on interface org.freedesktop.Telepathy.Channel.Interface.DTMF.
 */
/**
 * tp_svc_channel_interface_dtmf_implement_multiple_tones:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the MultipleTones D-Bus method
 *
 * Register an implementation for the MultipleTones method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_interface_dtmf_return_from_multiple_tones:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_interface_dtmf_emit_sending_tones:
 * @instance: The object implementing this interface
 * @arg_Tones: const gchar * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * SendingTones signal on interface org.freedesktop.Telepathy.Channel.Interface.DTMF.
 */
/**
 * TpSvcChannelInterfaceDTMF::sending-tones:
 * @arg_Tones: const gchar * (FIXME, generate documentation)
 *
 * The SendingTones D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * tp_svc_channel_interface_dtmf_emit_stopped_tones:
 * @instance: The object implementing this interface
 * @arg_Cancelled: gboolean  (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * StoppedTones signal on interface org.freedesktop.Telepathy.Channel.Interface.DTMF.
 */
/**
 * TpSvcChannelInterfaceDTMF::stopped-tones:
 * @arg_Cancelled: gboolean  (FIXME, generate documentation)
 *
 * The StoppedTones D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * TpSvcChannelInterfaceDestroyable:
 *
 * Dummy typedef representing any implementation of this interface.
 */
/**
 * TpSvcChannelInterfaceDestroyableClass:
 *
 * The class of TpSvcChannelInterfaceDestroyable.
 *
 * In a full implementation of this interface (i.e. all
 * methods implemented), the interface initialization
 * function used in G_IMPLEMENT_INTERFACE() would
 * typically look like this:
 *
 * <programlisting>
 * static void
 * implement_channel_interface_destroyable (gpointer klass,
 *     gpointer unused G_GNUC_UNUSED)
 * {
 * #define IMPLEMENT(x) tp_svc_channel_interface_destroyable_implement_&num;&num;x (\
 *   klass, my_object_&num;&num;x)
 *   IMPLEMENT (destroy);
 * #undef IMPLEMENT
 * }
 * </programlisting>
 */

/**
 * tp_svc_channel_interface_destroyable_destroy_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * Destroy on interface org.freedesktop.Telepathy.Channel.Interface.Destroyable.
 */
/**
 * tp_svc_channel_interface_destroyable_implement_destroy:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the Destroy D-Bus method
 *
 * Register an implementation for the Destroy method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_interface_destroyable_return_from_destroy:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * TpSvcChannelInterfaceGroup:
 *
 * Dummy typedef representing any implementation of this interface.
 */
/**
 * TpSvcChannelInterfaceGroupClass:
 *
 * The class of TpSvcChannelInterfaceGroup.
 *
 * In a full implementation of this interface (i.e. all
 * methods implemented), the interface initialization
 * function used in G_IMPLEMENT_INTERFACE() would
 * typically look like this:
 *
 * <programlisting>
 * static void
 * implement_channel_interface_group (gpointer klass,
 *     gpointer unused G_GNUC_UNUSED)
 * {
 * #define IMPLEMENT(x) tp_svc_channel_interface_group_implement_&num;&num;x (\
 *   klass, my_object_&num;&num;x)
 *   IMPLEMENT (add_members);
 *   IMPLEMENT (get_all_members);
 *   IMPLEMENT (get_group_flags);
 *   IMPLEMENT (get_handle_owners);
 *   IMPLEMENT (get_local_pending_members);
 *   IMPLEMENT (get_local_pending_members_with_info);
 *   IMPLEMENT (get_members);
 *   IMPLEMENT (get_remote_pending_members);
 *   IMPLEMENT (get_self_handle);
 *   IMPLEMENT (remove_members);
 *   IMPLEMENT (remove_members_with_reason);
 * #undef IMPLEMENT
 * }
 * </programlisting>
 */

/**
 * tp_svc_channel_interface_group_add_members_impl:
 * @self: The object implementing this interface
 * @in_Contacts: const GArray * (FIXME, generate documentation)
 * @in_Message: const gchar * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * AddMembers on interface org.freedesktop.Telepathy.Channel.Interface.Group.
 */
/**
 * tp_svc_channel_interface_group_implement_add_members:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the AddMembers D-Bus method
 *
 * Register an implementation for the AddMembers method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_interface_group_return_from_add_members:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_interface_group_get_all_members_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetAllMembers on interface org.freedesktop.Telepathy.Channel.Interface.Group.
 */
/**
 * tp_svc_channel_interface_group_implement_get_all_members:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetAllMembers D-Bus method
 *
 * Register an implementation for the GetAllMembers method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_interface_group_return_from_get_all_members:
 * @context: The D-Bus method invocation context
 * @out_Members: const GArray * (FIXME, generate documentation)
 * @out_Local_Pending: const GArray * (FIXME, generate documentation)
 * @out_Remote_Pending: const GArray * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_interface_group_get_group_flags_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetGroupFlags on interface org.freedesktop.Telepathy.Channel.Interface.Group.
 */
/**
 * tp_svc_channel_interface_group_implement_get_group_flags:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetGroupFlags D-Bus method
 *
 * Register an implementation for the GetGroupFlags method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_interface_group_return_from_get_group_flags:
 * @context: The D-Bus method invocation context
 * @out_Group_Flags: guint  (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_interface_group_get_handle_owners_impl:
 * @self: The object implementing this interface
 * @in_Handles: const GArray * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetHandleOwners on interface org.freedesktop.Telepathy.Channel.Interface.Group.
 */
/**
 * tp_svc_channel_interface_group_implement_get_handle_owners:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetHandleOwners D-Bus method
 *
 * Register an implementation for the GetHandleOwners method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_interface_group_return_from_get_handle_owners:
 * @context: The D-Bus method invocation context
 * @out_Owners: const GArray * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_interface_group_get_local_pending_members_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetLocalPendingMembers on interface org.freedesktop.Telepathy.Channel.Interface.Group.
 */
/**
 * tp_svc_channel_interface_group_implement_get_local_pending_members:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetLocalPendingMembers D-Bus method
 *
 * Register an implementation for the GetLocalPendingMembers method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_interface_group_return_from_get_local_pending_members:
 * @context: The D-Bus method invocation context
 * @out_Handles: const GArray * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_interface_group_get_local_pending_members_with_info_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetLocalPendingMembersWithInfo on interface org.freedesktop.Telepathy.Channel.Interface.Group.
 */
/**
 * tp_svc_channel_interface_group_implement_get_local_pending_members_with_info:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetLocalPendingMembersWithInfo D-Bus method
 *
 * Register an implementation for the GetLocalPendingMembersWithInfo method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_interface_group_return_from_get_local_pending_members_with_info:
 * @context: The D-Bus method invocation context
 * @out_Info: const GPtrArray * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_interface_group_get_members_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetMembers on interface org.freedesktop.Telepathy.Channel.Interface.Group.
 */
/**
 * tp_svc_channel_interface_group_implement_get_members:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetMembers D-Bus method
 *
 * Register an implementation for the GetMembers method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_interface_group_return_from_get_members:
 * @context: The D-Bus method invocation context
 * @out_Handles: const GArray * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_interface_group_get_remote_pending_members_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetRemotePendingMembers on interface org.freedesktop.Telepathy.Channel.Interface.Group.
 */
/**
 * tp_svc_channel_interface_group_implement_get_remote_pending_members:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetRemotePendingMembers D-Bus method
 *
 * Register an implementation for the GetRemotePendingMembers method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_interface_group_return_from_get_remote_pending_members:
 * @context: The D-Bus method invocation context
 * @out_Handles: const GArray * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_interface_group_get_self_handle_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetSelfHandle on interface org.freedesktop.Telepathy.Channel.Interface.Group.
 */
/**
 * tp_svc_channel_interface_group_implement_get_self_handle:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetSelfHandle D-Bus method
 *
 * Register an implementation for the GetSelfHandle method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_interface_group_return_from_get_self_handle:
 * @context: The D-Bus method invocation context
 * @out_Self_Handle: guint  (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_interface_group_remove_members_impl:
 * @self: The object implementing this interface
 * @in_Contacts: const GArray * (FIXME, generate documentation)
 * @in_Message: const gchar * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * RemoveMembers on interface org.freedesktop.Telepathy.Channel.Interface.Group.
 */
/**
 * tp_svc_channel_interface_group_implement_remove_members:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the RemoveMembers D-Bus method
 *
 * Register an implementation for the RemoveMembers method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_interface_group_return_from_remove_members:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_interface_group_remove_members_with_reason_impl:
 * @self: The object implementing this interface
 * @in_Contacts: const GArray * (FIXME, generate documentation)
 * @in_Message: const gchar * (FIXME, generate documentation)
 * @in_Reason: guint  (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * RemoveMembersWithReason on interface org.freedesktop.Telepathy.Channel.Interface.Group.
 */
/**
 * tp_svc_channel_interface_group_implement_remove_members_with_reason:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the RemoveMembersWithReason D-Bus method
 *
 * Register an implementation for the RemoveMembersWithReason method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_interface_group_return_from_remove_members_with_reason:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_interface_group_emit_handle_owners_changed:
 * @instance: The object implementing this interface
 * @arg_Added: GHashTable * (FIXME, generate documentation)
 * @arg_Removed: const GArray * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * HandleOwnersChanged signal on interface org.freedesktop.Telepathy.Channel.Interface.Group.
 */
/**
 * TpSvcChannelInterfaceGroup::handle-owners-changed:
 * @arg_Added: GHashTable * (FIXME, generate documentation)
 * @arg_Removed: const GArray * (FIXME, generate documentation)
 *
 * The HandleOwnersChanged D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * tp_svc_channel_interface_group_emit_self_handle_changed:
 * @instance: The object implementing this interface
 * @arg_Self_Handle: guint  (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * SelfHandleChanged signal on interface org.freedesktop.Telepathy.Channel.Interface.Group.
 */
/**
 * TpSvcChannelInterfaceGroup::self-handle-changed:
 * @arg_Self_Handle: guint  (FIXME, generate documentation)
 *
 * The SelfHandleChanged D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * tp_svc_channel_interface_group_emit_group_flags_changed:
 * @instance: The object implementing this interface
 * @arg_Added: guint  (FIXME, generate documentation)
 * @arg_Removed: guint  (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * GroupFlagsChanged signal on interface org.freedesktop.Telepathy.Channel.Interface.Group.
 */
/**
 * TpSvcChannelInterfaceGroup::group-flags-changed:
 * @arg_Added: guint  (FIXME, generate documentation)
 * @arg_Removed: guint  (FIXME, generate documentation)
 *
 * The GroupFlagsChanged D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * tp_svc_channel_interface_group_emit_members_changed:
 * @instance: The object implementing this interface
 * @arg_Message: const gchar * (FIXME, generate documentation)
 * @arg_Added: const GArray * (FIXME, generate documentation)
 * @arg_Removed: const GArray * (FIXME, generate documentation)
 * @arg_Local_Pending: const GArray * (FIXME, generate documentation)
 * @arg_Remote_Pending: const GArray * (FIXME, generate documentation)
 * @arg_Actor: guint  (FIXME, generate documentation)
 * @arg_Reason: guint  (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * MembersChanged signal on interface org.freedesktop.Telepathy.Channel.Interface.Group.
 */
/**
 * TpSvcChannelInterfaceGroup::members-changed:
 * @arg_Message: const gchar * (FIXME, generate documentation)
 * @arg_Added: const GArray * (FIXME, generate documentation)
 * @arg_Removed: const GArray * (FIXME, generate documentation)
 * @arg_Local_Pending: const GArray * (FIXME, generate documentation)
 * @arg_Remote_Pending: const GArray * (FIXME, generate documentation)
 * @arg_Actor: guint  (FIXME, generate documentation)
 * @arg_Reason: guint  (FIXME, generate documentation)
 *
 * The MembersChanged D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * tp_svc_channel_interface_group_emit_members_changed_detailed:
 * @instance: The object implementing this interface
 * @arg_Added: const GArray * (FIXME, generate documentation)
 * @arg_Removed: const GArray * (FIXME, generate documentation)
 * @arg_Local_Pending: const GArray * (FIXME, generate documentation)
 * @arg_Remote_Pending: const GArray * (FIXME, generate documentation)
 * @arg_Details: GHashTable * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * MembersChangedDetailed signal on interface org.freedesktop.Telepathy.Channel.Interface.Group.
 */
/**
 * TpSvcChannelInterfaceGroup::members-changed-detailed:
 * @arg_Added: const GArray * (FIXME, generate documentation)
 * @arg_Removed: const GArray * (FIXME, generate documentation)
 * @arg_Local_Pending: const GArray * (FIXME, generate documentation)
 * @arg_Remote_Pending: const GArray * (FIXME, generate documentation)
 * @arg_Details: GHashTable * (FIXME, generate documentation)
 *
 * The MembersChangedDetailed D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * TpSvcChannelInterfaceHold:
 *
 * Dummy typedef representing any implementation of this interface.
 */
/**
 * TpSvcChannelInterfaceHoldClass:
 *
 * The class of TpSvcChannelInterfaceHold.
 *
 * In a full implementation of this interface (i.e. all
 * methods implemented), the interface initialization
 * function used in G_IMPLEMENT_INTERFACE() would
 * typically look like this:
 *
 * <programlisting>
 * static void
 * implement_channel_interface_hold (gpointer klass,
 *     gpointer unused G_GNUC_UNUSED)
 * {
 * #define IMPLEMENT(x) tp_svc_channel_interface_hold_implement_&num;&num;x (\
 *   klass, my_object_&num;&num;x)
 *   IMPLEMENT (get_hold_state);
 *   IMPLEMENT (request_hold);
 * #undef IMPLEMENT
 * }
 * </programlisting>
 */

/**
 * tp_svc_channel_interface_hold_get_hold_state_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetHoldState on interface org.freedesktop.Telepathy.Channel.Interface.Hold.
 */
/**
 * tp_svc_channel_interface_hold_implement_get_hold_state:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetHoldState D-Bus method
 *
 * Register an implementation for the GetHoldState method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_interface_hold_return_from_get_hold_state:
 * @context: The D-Bus method invocation context
 * @out_HoldState: guint  (FIXME, generate documentation)
 * @out_Reason: guint  (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_interface_hold_request_hold_impl:
 * @self: The object implementing this interface
 * @in_Hold: gboolean  (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * RequestHold on interface org.freedesktop.Telepathy.Channel.Interface.Hold.
 */
/**
 * tp_svc_channel_interface_hold_implement_request_hold:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the RequestHold D-Bus method
 *
 * Register an implementation for the RequestHold method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_interface_hold_return_from_request_hold:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_interface_hold_emit_hold_state_changed:
 * @instance: The object implementing this interface
 * @arg_HoldState: guint  (FIXME, generate documentation)
 * @arg_Reason: guint  (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * HoldStateChanged signal on interface org.freedesktop.Telepathy.Channel.Interface.Hold.
 */
/**
 * TpSvcChannelInterfaceHold::hold-state-changed:
 * @arg_HoldState: guint  (FIXME, generate documentation)
 * @arg_Reason: guint  (FIXME, generate documentation)
 *
 * The HoldStateChanged D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * TpSvcChannelInterfaceMediaSignalling:
 *
 * Dummy typedef representing any implementation of this interface.
 */
/**
 * TpSvcChannelInterfaceMediaSignallingClass:
 *
 * The class of TpSvcChannelInterfaceMediaSignalling.
 *
 * In a full implementation of this interface (i.e. all
 * methods implemented), the interface initialization
 * function used in G_IMPLEMENT_INTERFACE() would
 * typically look like this:
 *
 * <programlisting>
 * static void
 * implement_channel_interface_media_signalling (gpointer klass,
 *     gpointer unused G_GNUC_UNUSED)
 * {
 * #define IMPLEMENT(x) tp_svc_channel_interface_media_signalling_implement_&num;&num;x (\
 *   klass, my_object_&num;&num;x)
 *   IMPLEMENT (get_session_handlers);
 * #undef IMPLEMENT
 * }
 * </programlisting>
 */

/**
 * tp_svc_channel_interface_media_signalling_get_session_handlers_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetSessionHandlers on interface org.freedesktop.Telepathy.Channel.Interface.MediaSignalling.
 */
/**
 * tp_svc_channel_interface_media_signalling_implement_get_session_handlers:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetSessionHandlers D-Bus method
 *
 * Register an implementation for the GetSessionHandlers method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_interface_media_signalling_return_from_get_session_handlers:
 * @context: The D-Bus method invocation context
 * @out_Session_Handlers: const GPtrArray * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_interface_media_signalling_emit_new_session_handler:
 * @instance: The object implementing this interface
 * @arg_Session_Handler: const gchar * (FIXME, generate documentation)
 * @arg_Session_Type: const gchar * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * NewSessionHandler signal on interface org.freedesktop.Telepathy.Channel.Interface.MediaSignalling.
 */
/**
 * TpSvcChannelInterfaceMediaSignalling::new-session-handler:
 * @arg_Session_Handler: const gchar * (FIXME, generate documentation)
 * @arg_Session_Type: const gchar * (FIXME, generate documentation)
 *
 * The NewSessionHandler D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * TpSvcChannelInterfaceMessages:
 *
 * Dummy typedef representing any implementation of this interface.
 */
/**
 * TpSvcChannelInterfaceMessagesClass:
 *
 * The class of TpSvcChannelInterfaceMessages.
 *
 * In a full implementation of this interface (i.e. all
 * methods implemented), the interface initialization
 * function used in G_IMPLEMENT_INTERFACE() would
 * typically look like this:
 *
 * <programlisting>
 * static void
 * implement_channel_interface_messages (gpointer klass,
 *     gpointer unused G_GNUC_UNUSED)
 * {
 * #define IMPLEMENT(x) tp_svc_channel_interface_messages_implement_&num;&num;x (\
 *   klass, my_object_&num;&num;x)
 *   IMPLEMENT (send_message);
 *   IMPLEMENT (get_pending_message_content);
 * #undef IMPLEMENT
 * }
 * </programlisting>
 */

/**
 * tp_svc_channel_interface_messages_send_message_impl:
 * @self: The object implementing this interface
 * @in_Message: const GPtrArray * (FIXME, generate documentation)
 * @in_Flags: guint  (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * SendMessage on interface org.freedesktop.Telepathy.Channel.Interface.Messages.
 */
/**
 * tp_svc_channel_interface_messages_implement_send_message:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the SendMessage D-Bus method
 *
 * Register an implementation for the SendMessage method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_interface_messages_return_from_send_message:
 * @context: The D-Bus method invocation context
 * @out_Token: const gchar * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_interface_messages_get_pending_message_content_impl:
 * @self: The object implementing this interface
 * @in_Message_ID: guint  (FIXME, generate documentation)
 * @in_Parts: const GArray * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetPendingMessageContent on interface org.freedesktop.Telepathy.Channel.Interface.Messages.
 */
/**
 * tp_svc_channel_interface_messages_implement_get_pending_message_content:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetPendingMessageContent D-Bus method
 *
 * Register an implementation for the GetPendingMessageContent method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_interface_messages_return_from_get_pending_message_content:
 * @context: The D-Bus method invocation context
 * @out_Content: GHashTable * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_interface_messages_emit_message_sent:
 * @instance: The object implementing this interface
 * @arg_Content: const GPtrArray * (FIXME, generate documentation)
 * @arg_Flags: guint  (FIXME, generate documentation)
 * @arg_Message_Token: const gchar * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * MessageSent signal on interface org.freedesktop.Telepathy.Channel.Interface.Messages.
 */
/**
 * TpSvcChannelInterfaceMessages::message-sent:
 * @arg_Content: const GPtrArray * (FIXME, generate documentation)
 * @arg_Flags: guint  (FIXME, generate documentation)
 * @arg_Message_Token: const gchar * (FIXME, generate documentation)
 *
 * The MessageSent D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * tp_svc_channel_interface_messages_emit_pending_messages_removed:
 * @instance: The object implementing this interface
 * @arg_Message_IDs: const GArray * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * PendingMessagesRemoved signal on interface org.freedesktop.Telepathy.Channel.Interface.Messages.
 */
/**
 * TpSvcChannelInterfaceMessages::pending-messages-removed:
 * @arg_Message_IDs: const GArray * (FIXME, generate documentation)
 *
 * The PendingMessagesRemoved D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * tp_svc_channel_interface_messages_emit_message_received:
 * @instance: The object implementing this interface
 * @arg_Message: const GPtrArray * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * MessageReceived signal on interface org.freedesktop.Telepathy.Channel.Interface.Messages.
 */
/**
 * TpSvcChannelInterfaceMessages::message-received:
 * @arg_Message: const GPtrArray * (FIXME, generate documentation)
 *
 * The MessageReceived D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * TpSvcChannelInterfacePassword:
 *
 * Dummy typedef representing any implementation of this interface.
 */
/**
 * TpSvcChannelInterfacePasswordClass:
 *
 * The class of TpSvcChannelInterfacePassword.
 *
 * In a full implementation of this interface (i.e. all
 * methods implemented), the interface initialization
 * function used in G_IMPLEMENT_INTERFACE() would
 * typically look like this:
 *
 * <programlisting>
 * static void
 * implement_channel_interface_password (gpointer klass,
 *     gpointer unused G_GNUC_UNUSED)
 * {
 * #define IMPLEMENT(x) tp_svc_channel_interface_password_implement_&num;&num;x (\
 *   klass, my_object_&num;&num;x)
 *   IMPLEMENT (get_password_flags);
 *   IMPLEMENT (provide_password);
 * #undef IMPLEMENT
 * }
 * </programlisting>
 */

/**
 * tp_svc_channel_interface_password_get_password_flags_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetPasswordFlags on interface org.freedesktop.Telepathy.Channel.Interface.Password.
 */
/**
 * tp_svc_channel_interface_password_implement_get_password_flags:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetPasswordFlags D-Bus method
 *
 * Register an implementation for the GetPasswordFlags method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_interface_password_return_from_get_password_flags:
 * @context: The D-Bus method invocation context
 * @out_Password_Flags: guint  (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_interface_password_provide_password_impl:
 * @self: The object implementing this interface
 * @in_Password: const gchar * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * ProvidePassword on interface org.freedesktop.Telepathy.Channel.Interface.Password.
 */
/**
 * tp_svc_channel_interface_password_implement_provide_password:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the ProvidePassword D-Bus method
 *
 * Register an implementation for the ProvidePassword method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_interface_password_return_from_provide_password:
 * @context: The D-Bus method invocation context
 * @out_Correct: gboolean  (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_interface_password_emit_password_flags_changed:
 * @instance: The object implementing this interface
 * @arg_Added: guint  (FIXME, generate documentation)
 * @arg_Removed: guint  (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * PasswordFlagsChanged signal on interface org.freedesktop.Telepathy.Channel.Interface.Password.
 */
/**
 * TpSvcChannelInterfacePassword::password-flags-changed:
 * @arg_Added: guint  (FIXME, generate documentation)
 * @arg_Removed: guint  (FIXME, generate documentation)
 *
 * The PasswordFlagsChanged D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * TpSvcChannelInterfaceSMS:
 *
 * Dummy typedef representing any implementation of this interface.
 */
/**
 * TpSvcChannelInterfaceSMSClass:
 *
 * The class of TpSvcChannelInterfaceSMS.
 * This interface has no D-Bus methods, so an
 * implementation can typically pass %NULL to
 * G_IMPLEMENT_INTERFACE() as the interface
 * initialization function.
 */

/**
 * TpSvcChannelInterfaceServicePoint:
 *
 * Dummy typedef representing any implementation of this interface.
 */
/**
 * TpSvcChannelInterfaceServicePointClass:
 *
 * The class of TpSvcChannelInterfaceServicePoint.
 * This interface has no D-Bus methods, so an
 * implementation can typically pass %NULL to
 * G_IMPLEMENT_INTERFACE() as the interface
 * initialization function.
 */

/**
 * tp_svc_channel_interface_service_point_emit_service_point_changed:
 * @instance: The object implementing this interface
 * @arg_Service_Point: const GValueArray * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * ServicePointChanged signal on interface org.freedesktop.Telepathy.Channel.Interface.ServicePoint.
 */
/**
 * TpSvcChannelInterfaceServicePoint::service-point-changed:
 * @arg_Service_Point: const GValueArray * (FIXME, generate documentation)
 *
 * The ServicePointChanged D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * TpSvcChannelInterfaceTube:
 *
 * Dummy typedef representing any implementation of this interface.
 */
/**
 * TpSvcChannelInterfaceTubeClass:
 *
 * The class of TpSvcChannelInterfaceTube.
 * This interface has no D-Bus methods, so an
 * implementation can typically pass %NULL to
 * G_IMPLEMENT_INTERFACE() as the interface
 * initialization function.
 */

/**
 * tp_svc_channel_interface_tube_emit_tube_channel_state_changed:
 * @instance: The object implementing this interface
 * @arg_State: guint  (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * TubeChannelStateChanged signal on interface org.freedesktop.Telepathy.Channel.Interface.Tube.
 */
/**
 * TpSvcChannelInterfaceTube::tube-channel-state-changed:
 * @arg_State: guint  (FIXME, generate documentation)
 *
 * The TubeChannelStateChanged D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * TpSvcChannelTypeContactList:
 *
 * Dummy typedef representing any implementation of this interface.
 */
/**
 * TpSvcChannelTypeContactListClass:
 *
 * The class of TpSvcChannelTypeContactList.
 * This interface has no D-Bus methods, so an
 * implementation can typically pass %NULL to
 * G_IMPLEMENT_INTERFACE() as the interface
 * initialization function.
 */

/**
 * TpSvcChannelTypeContactSearch:
 *
 * Dummy typedef representing any implementation of this interface.
 */
/**
 * TpSvcChannelTypeContactSearchClass:
 *
 * The class of TpSvcChannelTypeContactSearch.
 *
 * In a full implementation of this interface (i.e. all
 * methods implemented), the interface initialization
 * function used in G_IMPLEMENT_INTERFACE() would
 * typically look like this:
 *
 * <programlisting>
 * static void
 * implement_channel_type_contact_search (gpointer klass,
 *     gpointer unused G_GNUC_UNUSED)
 * {
 * #define IMPLEMENT(x) tp_svc_channel_type_contact_search_implement_&num;&num;x (\
 *   klass, my_object_&num;&num;x)
 *   IMPLEMENT (search);
 *   IMPLEMENT (more);
 *   IMPLEMENT (stop);
 * #undef IMPLEMENT
 * }
 * </programlisting>
 */

/**
 * tp_svc_channel_type_contact_search_search_impl:
 * @self: The object implementing this interface
 * @in_Terms: GHashTable * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * Search on interface org.freedesktop.Telepathy.Channel.Type.ContactSearch.
 */
/**
 * tp_svc_channel_type_contact_search_implement_search:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the Search D-Bus method
 *
 * Register an implementation for the Search method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_type_contact_search_return_from_search:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_type_contact_search_more_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * More on interface org.freedesktop.Telepathy.Channel.Type.ContactSearch.
 */
/**
 * tp_svc_channel_type_contact_search_implement_more:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the More D-Bus method
 *
 * Register an implementation for the More method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_type_contact_search_return_from_more:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_type_contact_search_stop_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * Stop on interface org.freedesktop.Telepathy.Channel.Type.ContactSearch.
 */
/**
 * tp_svc_channel_type_contact_search_implement_stop:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the Stop D-Bus method
 *
 * Register an implementation for the Stop method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_type_contact_search_return_from_stop:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_type_contact_search_emit_search_state_changed:
 * @instance: The object implementing this interface
 * @arg_State: guint  (FIXME, generate documentation)
 * @arg_Error: const gchar * (FIXME, generate documentation)
 * @arg_Details: GHashTable * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * SearchStateChanged signal on interface org.freedesktop.Telepathy.Channel.Type.ContactSearch.
 */
/**
 * TpSvcChannelTypeContactSearch::search-state-changed:
 * @arg_State: guint  (FIXME, generate documentation)
 * @arg_Error: const gchar * (FIXME, generate documentation)
 * @arg_Details: GHashTable * (FIXME, generate documentation)
 *
 * The SearchStateChanged D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * tp_svc_channel_type_contact_search_emit_search_result_received:
 * @instance: The object implementing this interface
 * @arg_Result: GHashTable * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * SearchResultReceived signal on interface org.freedesktop.Telepathy.Channel.Type.ContactSearch.
 */
/**
 * TpSvcChannelTypeContactSearch::search-result-received:
 * @arg_Result: GHashTable * (FIXME, generate documentation)
 *
 * The SearchResultReceived D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * TpSvcChannelTypeDBusTube:
 *
 * Dummy typedef representing any implementation of this interface.
 */
/**
 * TpSvcChannelTypeDBusTubeClass:
 *
 * The class of TpSvcChannelTypeDBusTube.
 *
 * In a full implementation of this interface (i.e. all
 * methods implemented), the interface initialization
 * function used in G_IMPLEMENT_INTERFACE() would
 * typically look like this:
 *
 * <programlisting>
 * static void
 * implement_channel_type_dbus_tube (gpointer klass,
 *     gpointer unused G_GNUC_UNUSED)
 * {
 * #define IMPLEMENT(x) tp_svc_channel_type_dbus_tube_implement_&num;&num;x (\
 *   klass, my_object_&num;&num;x)
 *   IMPLEMENT (offer);
 *   IMPLEMENT (accept);
 * #undef IMPLEMENT
 * }
 * </programlisting>
 */

/**
 * tp_svc_channel_type_dbus_tube_offer_impl:
 * @self: The object implementing this interface
 * @in_parameters: GHashTable * (FIXME, generate documentation)
 * @in_access_control: guint  (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * Offer on interface org.freedesktop.Telepathy.Channel.Type.DBusTube.
 */
/**
 * tp_svc_channel_type_dbus_tube_implement_offer:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the Offer D-Bus method
 *
 * Register an implementation for the Offer method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_type_dbus_tube_return_from_offer:
 * @context: The D-Bus method invocation context
 * @out_address: const gchar * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_type_dbus_tube_accept_impl:
 * @self: The object implementing this interface
 * @in_access_control: guint  (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * Accept on interface org.freedesktop.Telepathy.Channel.Type.DBusTube.
 */
/**
 * tp_svc_channel_type_dbus_tube_implement_accept:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the Accept D-Bus method
 *
 * Register an implementation for the Accept method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_type_dbus_tube_return_from_accept:
 * @context: The D-Bus method invocation context
 * @out_address: const gchar * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_type_dbus_tube_emit_dbus_names_changed:
 * @instance: The object implementing this interface
 * @arg_Added: GHashTable * (FIXME, generate documentation)
 * @arg_Removed: const GArray * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * DBusNamesChanged signal on interface org.freedesktop.Telepathy.Channel.Type.DBusTube.
 */
/**
 * TpSvcChannelTypeDBusTube::d-bus-names-changed:
 * @arg_Added: GHashTable * (FIXME, generate documentation)
 * @arg_Removed: const GArray * (FIXME, generate documentation)
 *
 * The DBusNamesChanged D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * TpSvcChannelTypeFileTransfer:
 *
 * Dummy typedef representing any implementation of this interface.
 */
/**
 * TpSvcChannelTypeFileTransferClass:
 *
 * The class of TpSvcChannelTypeFileTransfer.
 *
 * In a full implementation of this interface (i.e. all
 * methods implemented), the interface initialization
 * function used in G_IMPLEMENT_INTERFACE() would
 * typically look like this:
 *
 * <programlisting>
 * static void
 * implement_channel_type_file_transfer (gpointer klass,
 *     gpointer unused G_GNUC_UNUSED)
 * {
 * #define IMPLEMENT(x) tp_svc_channel_type_file_transfer_implement_&num;&num;x (\
 *   klass, my_object_&num;&num;x)
 *   IMPLEMENT (accept_file);
 *   IMPLEMENT (provide_file);
 * #undef IMPLEMENT
 * }
 * </programlisting>
 */

/**
 * tp_svc_channel_type_file_transfer_accept_file_impl:
 * @self: The object implementing this interface
 * @in_Address_Type: guint  (FIXME, generate documentation)
 * @in_Access_Control: guint  (FIXME, generate documentation)
 * @in_Access_Control_Param: const GValue * (FIXME, generate documentation)
 * @in_Offset: guint64  (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * AcceptFile on interface org.freedesktop.Telepathy.Channel.Type.FileTransfer.
 */
/**
 * tp_svc_channel_type_file_transfer_implement_accept_file:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the AcceptFile D-Bus method
 *
 * Register an implementation for the AcceptFile method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_type_file_transfer_return_from_accept_file:
 * @context: The D-Bus method invocation context
 * @out_Address: const GValue * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_type_file_transfer_provide_file_impl:
 * @self: The object implementing this interface
 * @in_Address_Type: guint  (FIXME, generate documentation)
 * @in_Access_Control: guint  (FIXME, generate documentation)
 * @in_Access_Control_Param: const GValue * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * ProvideFile on interface org.freedesktop.Telepathy.Channel.Type.FileTransfer.
 */
/**
 * tp_svc_channel_type_file_transfer_implement_provide_file:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the ProvideFile D-Bus method
 *
 * Register an implementation for the ProvideFile method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_type_file_transfer_return_from_provide_file:
 * @context: The D-Bus method invocation context
 * @out_Address: const GValue * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_type_file_transfer_emit_file_transfer_state_changed:
 * @instance: The object implementing this interface
 * @arg_State: guint  (FIXME, generate documentation)
 * @arg_Reason: guint  (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * FileTransferStateChanged signal on interface org.freedesktop.Telepathy.Channel.Type.FileTransfer.
 */
/**
 * TpSvcChannelTypeFileTransfer::file-transfer-state-changed:
 * @arg_State: guint  (FIXME, generate documentation)
 * @arg_Reason: guint  (FIXME, generate documentation)
 *
 * The FileTransferStateChanged D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * tp_svc_channel_type_file_transfer_emit_transferred_bytes_changed:
 * @instance: The object implementing this interface
 * @arg_Count: guint64  (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * TransferredBytesChanged signal on interface org.freedesktop.Telepathy.Channel.Type.FileTransfer.
 */
/**
 * TpSvcChannelTypeFileTransfer::transferred-bytes-changed:
 * @arg_Count: guint64  (FIXME, generate documentation)
 *
 * The TransferredBytesChanged D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * tp_svc_channel_type_file_transfer_emit_initial_offset_defined:
 * @instance: The object implementing this interface
 * @arg_InitialOffset: guint64  (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * InitialOffsetDefined signal on interface org.freedesktop.Telepathy.Channel.Type.FileTransfer.
 */
/**
 * TpSvcChannelTypeFileTransfer::initial-offset-defined:
 * @arg_InitialOffset: guint64  (FIXME, generate documentation)
 *
 * The InitialOffsetDefined D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * TpSvcChannelTypeRoomList:
 *
 * Dummy typedef representing any implementation of this interface.
 */
/**
 * TpSvcChannelTypeRoomListClass:
 *
 * The class of TpSvcChannelTypeRoomList.
 *
 * In a full implementation of this interface (i.e. all
 * methods implemented), the interface initialization
 * function used in G_IMPLEMENT_INTERFACE() would
 * typically look like this:
 *
 * <programlisting>
 * static void
 * implement_channel_type_room_list (gpointer klass,
 *     gpointer unused G_GNUC_UNUSED)
 * {
 * #define IMPLEMENT(x) tp_svc_channel_type_room_list_implement_&num;&num;x (\
 *   klass, my_object_&num;&num;x)
 *   IMPLEMENT (get_listing_rooms);
 *   IMPLEMENT (list_rooms);
 *   IMPLEMENT (stop_listing);
 * #undef IMPLEMENT
 * }
 * </programlisting>
 */

/**
 * tp_svc_channel_type_room_list_get_listing_rooms_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetListingRooms on interface org.freedesktop.Telepathy.Channel.Type.RoomList.
 */
/**
 * tp_svc_channel_type_room_list_implement_get_listing_rooms:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetListingRooms D-Bus method
 *
 * Register an implementation for the GetListingRooms method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_type_room_list_return_from_get_listing_rooms:
 * @context: The D-Bus method invocation context
 * @out_In_Progress: gboolean  (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_type_room_list_list_rooms_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * ListRooms on interface org.freedesktop.Telepathy.Channel.Type.RoomList.
 */
/**
 * tp_svc_channel_type_room_list_implement_list_rooms:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the ListRooms D-Bus method
 *
 * Register an implementation for the ListRooms method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_type_room_list_return_from_list_rooms:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_type_room_list_stop_listing_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * StopListing on interface org.freedesktop.Telepathy.Channel.Type.RoomList.
 */
/**
 * tp_svc_channel_type_room_list_implement_stop_listing:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the StopListing D-Bus method
 *
 * Register an implementation for the StopListing method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_type_room_list_return_from_stop_listing:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_type_room_list_emit_got_rooms:
 * @instance: The object implementing this interface
 * @arg_Rooms: const GPtrArray * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * GotRooms signal on interface org.freedesktop.Telepathy.Channel.Type.RoomList.
 */
/**
 * TpSvcChannelTypeRoomList::got-rooms:
 * @arg_Rooms: const GPtrArray * (FIXME, generate documentation)
 *
 * The GotRooms D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * tp_svc_channel_type_room_list_emit_listing_rooms:
 * @instance: The object implementing this interface
 * @arg_Listing: gboolean  (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * ListingRooms signal on interface org.freedesktop.Telepathy.Channel.Type.RoomList.
 */
/**
 * TpSvcChannelTypeRoomList::listing-rooms:
 * @arg_Listing: gboolean  (FIXME, generate documentation)
 *
 * The ListingRooms D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * TpSvcChannelTypeServerTLSConnection:
 *
 * Dummy typedef representing any implementation of this interface.
 */
/**
 * TpSvcChannelTypeServerTLSConnectionClass:
 *
 * The class of TpSvcChannelTypeServerTLSConnection.
 * This interface has no D-Bus methods, so an
 * implementation can typically pass %NULL to
 * G_IMPLEMENT_INTERFACE() as the interface
 * initialization function.
 */

/**
 * TpSvcChannelTypeStreamTube:
 *
 * Dummy typedef representing any implementation of this interface.
 */
/**
 * TpSvcChannelTypeStreamTubeClass:
 *
 * The class of TpSvcChannelTypeStreamTube.
 *
 * In a full implementation of this interface (i.e. all
 * methods implemented), the interface initialization
 * function used in G_IMPLEMENT_INTERFACE() would
 * typically look like this:
 *
 * <programlisting>
 * static void
 * implement_channel_type_stream_tube (gpointer klass,
 *     gpointer unused G_GNUC_UNUSED)
 * {
 * #define IMPLEMENT(x) tp_svc_channel_type_stream_tube_implement_&num;&num;x (\
 *   klass, my_object_&num;&num;x)
 *   IMPLEMENT (offer);
 *   IMPLEMENT (accept);
 * #undef IMPLEMENT
 * }
 * </programlisting>
 */

/**
 * tp_svc_channel_type_stream_tube_offer_impl:
 * @self: The object implementing this interface
 * @in_address_type: guint  (FIXME, generate documentation)
 * @in_address: const GValue * (FIXME, generate documentation)
 * @in_access_control: guint  (FIXME, generate documentation)
 * @in_parameters: GHashTable * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * Offer on interface org.freedesktop.Telepathy.Channel.Type.StreamTube.
 */
/**
 * tp_svc_channel_type_stream_tube_implement_offer:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the Offer D-Bus method
 *
 * Register an implementation for the Offer method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_type_stream_tube_return_from_offer:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_type_stream_tube_accept_impl:
 * @self: The object implementing this interface
 * @in_address_type: guint  (FIXME, generate documentation)
 * @in_access_control: guint  (FIXME, generate documentation)
 * @in_access_control_param: const GValue * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * Accept on interface org.freedesktop.Telepathy.Channel.Type.StreamTube.
 */
/**
 * tp_svc_channel_type_stream_tube_implement_accept:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the Accept D-Bus method
 *
 * Register an implementation for the Accept method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_type_stream_tube_return_from_accept:
 * @context: The D-Bus method invocation context
 * @out_address: const GValue * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_type_stream_tube_emit_new_remote_connection:
 * @instance: The object implementing this interface
 * @arg_Handle: guint  (FIXME, generate documentation)
 * @arg_Connection_Param: const GValue * (FIXME, generate documentation)
 * @arg_Connection_ID: guint  (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * NewRemoteConnection signal on interface org.freedesktop.Telepathy.Channel.Type.StreamTube.
 */
/**
 * TpSvcChannelTypeStreamTube::new-remote-connection:
 * @arg_Handle: guint  (FIXME, generate documentation)
 * @arg_Connection_Param: const GValue * (FIXME, generate documentation)
 * @arg_Connection_ID: guint  (FIXME, generate documentation)
 *
 * The NewRemoteConnection D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * tp_svc_channel_type_stream_tube_emit_new_local_connection:
 * @instance: The object implementing this interface
 * @arg_Connection_ID: guint  (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * NewLocalConnection signal on interface org.freedesktop.Telepathy.Channel.Type.StreamTube.
 */
/**
 * TpSvcChannelTypeStreamTube::new-local-connection:
 * @arg_Connection_ID: guint  (FIXME, generate documentation)
 *
 * The NewLocalConnection D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * tp_svc_channel_type_stream_tube_emit_connection_closed:
 * @instance: The object implementing this interface
 * @arg_Connection_ID: guint  (FIXME, generate documentation)
 * @arg_Error: const gchar * (FIXME, generate documentation)
 * @arg_Message: const gchar * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * ConnectionClosed signal on interface org.freedesktop.Telepathy.Channel.Type.StreamTube.
 */
/**
 * TpSvcChannelTypeStreamTube::connection-closed:
 * @arg_Connection_ID: guint  (FIXME, generate documentation)
 * @arg_Error: const gchar * (FIXME, generate documentation)
 * @arg_Message: const gchar * (FIXME, generate documentation)
 *
 * The ConnectionClosed D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * TpSvcChannelTypeStreamedMedia:
 *
 * Dummy typedef representing any implementation of this interface.
 */
/**
 * TpSvcChannelTypeStreamedMediaClass:
 *
 * The class of TpSvcChannelTypeStreamedMedia.
 *
 * In a full implementation of this interface (i.e. all
 * methods implemented), the interface initialization
 * function used in G_IMPLEMENT_INTERFACE() would
 * typically look like this:
 *
 * <programlisting>
 * static void
 * implement_channel_type_streamed_media (gpointer klass,
 *     gpointer unused G_GNUC_UNUSED)
 * {
 * #define IMPLEMENT(x) tp_svc_channel_type_streamed_media_implement_&num;&num;x (\
 *   klass, my_object_&num;&num;x)
 *   IMPLEMENT (list_streams);
 *   IMPLEMENT (remove_streams);
 *   IMPLEMENT (request_stream_direction);
 *   IMPLEMENT (request_streams);
 * #undef IMPLEMENT
 * }
 * </programlisting>
 */

/**
 * tp_svc_channel_type_streamed_media_list_streams_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * ListStreams on interface org.freedesktop.Telepathy.Channel.Type.StreamedMedia.
 */
/**
 * tp_svc_channel_type_streamed_media_implement_list_streams:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the ListStreams D-Bus method
 *
 * Register an implementation for the ListStreams method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_type_streamed_media_return_from_list_streams:
 * @context: The D-Bus method invocation context
 * @out_Streams: const GPtrArray * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_type_streamed_media_remove_streams_impl:
 * @self: The object implementing this interface
 * @in_Streams: const GArray * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * RemoveStreams on interface org.freedesktop.Telepathy.Channel.Type.StreamedMedia.
 */
/**
 * tp_svc_channel_type_streamed_media_implement_remove_streams:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the RemoveStreams D-Bus method
 *
 * Register an implementation for the RemoveStreams method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_type_streamed_media_return_from_remove_streams:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_type_streamed_media_request_stream_direction_impl:
 * @self: The object implementing this interface
 * @in_Stream_ID: guint  (FIXME, generate documentation)
 * @in_Stream_Direction: guint  (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * RequestStreamDirection on interface org.freedesktop.Telepathy.Channel.Type.StreamedMedia.
 */
/**
 * tp_svc_channel_type_streamed_media_implement_request_stream_direction:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the RequestStreamDirection D-Bus method
 *
 * Register an implementation for the RequestStreamDirection method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_type_streamed_media_return_from_request_stream_direction:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_type_streamed_media_request_streams_impl:
 * @self: The object implementing this interface
 * @in_Contact_Handle: guint  (FIXME, generate documentation)
 * @in_Types: const GArray * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * RequestStreams on interface org.freedesktop.Telepathy.Channel.Type.StreamedMedia.
 */
/**
 * tp_svc_channel_type_streamed_media_implement_request_streams:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the RequestStreams D-Bus method
 *
 * Register an implementation for the RequestStreams method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_type_streamed_media_return_from_request_streams:
 * @context: The D-Bus method invocation context
 * @out_Streams: const GPtrArray * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_type_streamed_media_emit_stream_added:
 * @instance: The object implementing this interface
 * @arg_Stream_ID: guint  (FIXME, generate documentation)
 * @arg_Contact_Handle: guint  (FIXME, generate documentation)
 * @arg_Stream_Type: guint  (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * StreamAdded signal on interface org.freedesktop.Telepathy.Channel.Type.StreamedMedia.
 */
/**
 * TpSvcChannelTypeStreamedMedia::stream-added:
 * @arg_Stream_ID: guint  (FIXME, generate documentation)
 * @arg_Contact_Handle: guint  (FIXME, generate documentation)
 * @arg_Stream_Type: guint  (FIXME, generate documentation)
 *
 * The StreamAdded D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * tp_svc_channel_type_streamed_media_emit_stream_direction_changed:
 * @instance: The object implementing this interface
 * @arg_Stream_ID: guint  (FIXME, generate documentation)
 * @arg_Stream_Direction: guint  (FIXME, generate documentation)
 * @arg_Pending_Flags: guint  (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * StreamDirectionChanged signal on interface org.freedesktop.Telepathy.Channel.Type.StreamedMedia.
 */
/**
 * TpSvcChannelTypeStreamedMedia::stream-direction-changed:
 * @arg_Stream_ID: guint  (FIXME, generate documentation)
 * @arg_Stream_Direction: guint  (FIXME, generate documentation)
 * @arg_Pending_Flags: guint  (FIXME, generate documentation)
 *
 * The StreamDirectionChanged D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * tp_svc_channel_type_streamed_media_emit_stream_error:
 * @instance: The object implementing this interface
 * @arg_Stream_ID: guint  (FIXME, generate documentation)
 * @arg_Error_Code: guint  (FIXME, generate documentation)
 * @arg_Message: const gchar * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * StreamError signal on interface org.freedesktop.Telepathy.Channel.Type.StreamedMedia.
 */
/**
 * TpSvcChannelTypeStreamedMedia::stream-error:
 * @arg_Stream_ID: guint  (FIXME, generate documentation)
 * @arg_Error_Code: guint  (FIXME, generate documentation)
 * @arg_Message: const gchar * (FIXME, generate documentation)
 *
 * The StreamError D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * tp_svc_channel_type_streamed_media_emit_stream_removed:
 * @instance: The object implementing this interface
 * @arg_Stream_ID: guint  (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * StreamRemoved signal on interface org.freedesktop.Telepathy.Channel.Type.StreamedMedia.
 */
/**
 * TpSvcChannelTypeStreamedMedia::stream-removed:
 * @arg_Stream_ID: guint  (FIXME, generate documentation)
 *
 * The StreamRemoved D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * tp_svc_channel_type_streamed_media_emit_stream_state_changed:
 * @instance: The object implementing this interface
 * @arg_Stream_ID: guint  (FIXME, generate documentation)
 * @arg_Stream_State: guint  (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * StreamStateChanged signal on interface org.freedesktop.Telepathy.Channel.Type.StreamedMedia.
 */
/**
 * TpSvcChannelTypeStreamedMedia::stream-state-changed:
 * @arg_Stream_ID: guint  (FIXME, generate documentation)
 * @arg_Stream_State: guint  (FIXME, generate documentation)
 *
 * The StreamStateChanged D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * TpSvcChannelTypeText:
 *
 * Dummy typedef representing any implementation of this interface.
 */
/**
 * TpSvcChannelTypeTextClass:
 *
 * The class of TpSvcChannelTypeText.
 *
 * In a full implementation of this interface (i.e. all
 * methods implemented), the interface initialization
 * function used in G_IMPLEMENT_INTERFACE() would
 * typically look like this:
 *
 * <programlisting>
 * static void
 * implement_channel_type_text (gpointer klass,
 *     gpointer unused G_GNUC_UNUSED)
 * {
 * #define IMPLEMENT(x) tp_svc_channel_type_text_implement_&num;&num;x (\
 *   klass, my_object_&num;&num;x)
 *   IMPLEMENT (acknowledge_pending_messages);
 *   IMPLEMENT (get_message_types);
 *   IMPLEMENT (list_pending_messages);
 *   IMPLEMENT (send);
 * #undef IMPLEMENT
 * }
 * </programlisting>
 */

/**
 * tp_svc_channel_type_text_acknowledge_pending_messages_impl:
 * @self: The object implementing this interface
 * @in_IDs: const GArray * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * AcknowledgePendingMessages on interface org.freedesktop.Telepathy.Channel.Type.Text.
 */
/**
 * tp_svc_channel_type_text_implement_acknowledge_pending_messages:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the AcknowledgePendingMessages D-Bus method
 *
 * Register an implementation for the AcknowledgePendingMessages method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_type_text_return_from_acknowledge_pending_messages:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_type_text_get_message_types_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetMessageTypes on interface org.freedesktop.Telepathy.Channel.Type.Text.
 */
/**
 * tp_svc_channel_type_text_implement_get_message_types:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetMessageTypes D-Bus method
 *
 * Register an implementation for the GetMessageTypes method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_type_text_return_from_get_message_types:
 * @context: The D-Bus method invocation context
 * @out_Available_Types: const GArray * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_type_text_list_pending_messages_impl:
 * @self: The object implementing this interface
 * @in_Clear: gboolean  (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * ListPendingMessages on interface org.freedesktop.Telepathy.Channel.Type.Text.
 */
/**
 * tp_svc_channel_type_text_implement_list_pending_messages:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the ListPendingMessages D-Bus method
 *
 * Register an implementation for the ListPendingMessages method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_type_text_return_from_list_pending_messages:
 * @context: The D-Bus method invocation context
 * @out_Pending_Messages: const GPtrArray * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_type_text_send_impl:
 * @self: The object implementing this interface
 * @in_Type: guint  (FIXME, generate documentation)
 * @in_Text: const gchar * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * Send on interface org.freedesktop.Telepathy.Channel.Type.Text.
 */
/**
 * tp_svc_channel_type_text_implement_send:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the Send D-Bus method
 *
 * Register an implementation for the Send method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_type_text_return_from_send:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_type_text_emit_lost_message:
 * @instance: The object implementing this interface
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * LostMessage signal on interface org.freedesktop.Telepathy.Channel.Type.Text.
 */
/**
 * TpSvcChannelTypeText::lost-message:
 *
 * The LostMessage D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * tp_svc_channel_type_text_emit_received:
 * @instance: The object implementing this interface
 * @arg_ID: guint  (FIXME, generate documentation)
 * @arg_Timestamp: guint  (FIXME, generate documentation)
 * @arg_Sender: guint  (FIXME, generate documentation)
 * @arg_Type: guint  (FIXME, generate documentation)
 * @arg_Flags: guint  (FIXME, generate documentation)
 * @arg_Text: const gchar * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * Received signal on interface org.freedesktop.Telepathy.Channel.Type.Text.
 */
/**
 * TpSvcChannelTypeText::received:
 * @arg_ID: guint  (FIXME, generate documentation)
 * @arg_Timestamp: guint  (FIXME, generate documentation)
 * @arg_Sender: guint  (FIXME, generate documentation)
 * @arg_Type: guint  (FIXME, generate documentation)
 * @arg_Flags: guint  (FIXME, generate documentation)
 * @arg_Text: const gchar * (FIXME, generate documentation)
 *
 * The Received D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * tp_svc_channel_type_text_emit_send_error:
 * @instance: The object implementing this interface
 * @arg_Error: guint  (FIXME, generate documentation)
 * @arg_Timestamp: guint  (FIXME, generate documentation)
 * @arg_Type: guint  (FIXME, generate documentation)
 * @arg_Text: const gchar * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * SendError signal on interface org.freedesktop.Telepathy.Channel.Type.Text.
 */
/**
 * TpSvcChannelTypeText::send-error:
 * @arg_Error: guint  (FIXME, generate documentation)
 * @arg_Timestamp: guint  (FIXME, generate documentation)
 * @arg_Type: guint  (FIXME, generate documentation)
 * @arg_Text: const gchar * (FIXME, generate documentation)
 *
 * The SendError D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * tp_svc_channel_type_text_emit_sent:
 * @instance: The object implementing this interface
 * @arg_Timestamp: guint  (FIXME, generate documentation)
 * @arg_Type: guint  (FIXME, generate documentation)
 * @arg_Text: const gchar * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * Sent signal on interface org.freedesktop.Telepathy.Channel.Type.Text.
 */
/**
 * TpSvcChannelTypeText::sent:
 * @arg_Timestamp: guint  (FIXME, generate documentation)
 * @arg_Type: guint  (FIXME, generate documentation)
 * @arg_Text: const gchar * (FIXME, generate documentation)
 *
 * The Sent D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * TpSvcChannelTypeTubes:
 *
 * Dummy typedef representing any implementation of this interface.
 */
/**
 * TpSvcChannelTypeTubesClass:
 *
 * The class of TpSvcChannelTypeTubes.
 *
 * In a full implementation of this interface (i.e. all
 * methods implemented), the interface initialization
 * function used in G_IMPLEMENT_INTERFACE() would
 * typically look like this:
 *
 * <programlisting>
 * static void
 * implement_channel_type_tubes (gpointer klass,
 *     gpointer unused G_GNUC_UNUSED)
 * {
 * #define IMPLEMENT(x) tp_svc_channel_type_tubes_implement_&num;&num;x (\
 *   klass, my_object_&num;&num;x)
 *   IMPLEMENT (get_available_stream_tube_types);
 *   IMPLEMENT (get_available_tube_types);
 *   IMPLEMENT (list_tubes);
 *   IMPLEMENT (offer_d_bus_tube);
 *   IMPLEMENT (offer_stream_tube);
 *   IMPLEMENT (accept_d_bus_tube);
 *   IMPLEMENT (accept_stream_tube);
 *   IMPLEMENT (close_tube);
 *   IMPLEMENT (get_d_bus_tube_address);
 *   IMPLEMENT (get_d_bus_names);
 *   IMPLEMENT (get_stream_tube_socket_address);
 * #undef IMPLEMENT
 * }
 * </programlisting>
 */

/**
 * tp_svc_channel_type_tubes_get_available_stream_tube_types_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetAvailableStreamTubeTypes on interface org.freedesktop.Telepathy.Channel.Type.Tubes.
 */
/**
 * tp_svc_channel_type_tubes_implement_get_available_stream_tube_types:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetAvailableStreamTubeTypes D-Bus method
 *
 * Register an implementation for the GetAvailableStreamTubeTypes method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_type_tubes_return_from_get_available_stream_tube_types:
 * @context: The D-Bus method invocation context
 * @out_Available_Stream_Tube_Types: GHashTable * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_type_tubes_get_available_tube_types_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetAvailableTubeTypes on interface org.freedesktop.Telepathy.Channel.Type.Tubes.
 */
/**
 * tp_svc_channel_type_tubes_implement_get_available_tube_types:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetAvailableTubeTypes D-Bus method
 *
 * Register an implementation for the GetAvailableTubeTypes method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_type_tubes_return_from_get_available_tube_types:
 * @context: The D-Bus method invocation context
 * @out_Available_Tube_Types: const GArray * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_type_tubes_list_tubes_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * ListTubes on interface org.freedesktop.Telepathy.Channel.Type.Tubes.
 */
/**
 * tp_svc_channel_type_tubes_implement_list_tubes:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the ListTubes D-Bus method
 *
 * Register an implementation for the ListTubes method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_type_tubes_return_from_list_tubes:
 * @context: The D-Bus method invocation context
 * @out_Tubes: const GPtrArray * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_type_tubes_offer_d_bus_tube_impl:
 * @self: The object implementing this interface
 * @in_Service: const gchar * (FIXME, generate documentation)
 * @in_Parameters: GHashTable * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * OfferDBusTube on interface org.freedesktop.Telepathy.Channel.Type.Tubes.
 */
/**
 * tp_svc_channel_type_tubes_implement_offer_d_bus_tube:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the OfferDBusTube D-Bus method
 *
 * Register an implementation for the OfferDBusTube method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_type_tubes_return_from_offer_d_bus_tube:
 * @context: The D-Bus method invocation context
 * @out_Tube_ID: guint  (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_type_tubes_offer_stream_tube_impl:
 * @self: The object implementing this interface
 * @in_Service: const gchar * (FIXME, generate documentation)
 * @in_Parameters: GHashTable * (FIXME, generate documentation)
 * @in_Address_Type: guint  (FIXME, generate documentation)
 * @in_Address: const GValue * (FIXME, generate documentation)
 * @in_Access_Control: guint  (FIXME, generate documentation)
 * @in_Access_Control_Param: const GValue * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * OfferStreamTube on interface org.freedesktop.Telepathy.Channel.Type.Tubes.
 */
/**
 * tp_svc_channel_type_tubes_implement_offer_stream_tube:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the OfferStreamTube D-Bus method
 *
 * Register an implementation for the OfferStreamTube method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_type_tubes_return_from_offer_stream_tube:
 * @context: The D-Bus method invocation context
 * @out_Tube_ID: guint  (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_type_tubes_accept_d_bus_tube_impl:
 * @self: The object implementing this interface
 * @in_ID: guint  (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * AcceptDBusTube on interface org.freedesktop.Telepathy.Channel.Type.Tubes.
 */
/**
 * tp_svc_channel_type_tubes_implement_accept_d_bus_tube:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the AcceptDBusTube D-Bus method
 *
 * Register an implementation for the AcceptDBusTube method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_type_tubes_return_from_accept_d_bus_tube:
 * @context: The D-Bus method invocation context
 * @out_Address: const gchar * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_type_tubes_accept_stream_tube_impl:
 * @self: The object implementing this interface
 * @in_ID: guint  (FIXME, generate documentation)
 * @in_Address_Type: guint  (FIXME, generate documentation)
 * @in_Access_Control: guint  (FIXME, generate documentation)
 * @in_Access_Control_Param: const GValue * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * AcceptStreamTube on interface org.freedesktop.Telepathy.Channel.Type.Tubes.
 */
/**
 * tp_svc_channel_type_tubes_implement_accept_stream_tube:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the AcceptStreamTube D-Bus method
 *
 * Register an implementation for the AcceptStreamTube method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_type_tubes_return_from_accept_stream_tube:
 * @context: The D-Bus method invocation context
 * @out_Address: const GValue * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_type_tubes_close_tube_impl:
 * @self: The object implementing this interface
 * @in_ID: guint  (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * CloseTube on interface org.freedesktop.Telepathy.Channel.Type.Tubes.
 */
/**
 * tp_svc_channel_type_tubes_implement_close_tube:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the CloseTube D-Bus method
 *
 * Register an implementation for the CloseTube method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_type_tubes_return_from_close_tube:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_type_tubes_get_d_bus_tube_address_impl:
 * @self: The object implementing this interface
 * @in_ID: guint  (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetDBusTubeAddress on interface org.freedesktop.Telepathy.Channel.Type.Tubes.
 */
/**
 * tp_svc_channel_type_tubes_implement_get_d_bus_tube_address:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetDBusTubeAddress D-Bus method
 *
 * Register an implementation for the GetDBusTubeAddress method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_type_tubes_return_from_get_d_bus_tube_address:
 * @context: The D-Bus method invocation context
 * @out_Address: const gchar * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_type_tubes_get_d_bus_names_impl:
 * @self: The object implementing this interface
 * @in_ID: guint  (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetDBusNames on interface org.freedesktop.Telepathy.Channel.Type.Tubes.
 */
/**
 * tp_svc_channel_type_tubes_implement_get_d_bus_names:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetDBusNames D-Bus method
 *
 * Register an implementation for the GetDBusNames method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_type_tubes_return_from_get_d_bus_names:
 * @context: The D-Bus method invocation context
 * @out_DBus_Names: const GPtrArray * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_type_tubes_get_stream_tube_socket_address_impl:
 * @self: The object implementing this interface
 * @in_ID: guint  (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetStreamTubeSocketAddress on interface org.freedesktop.Telepathy.Channel.Type.Tubes.
 */
/**
 * tp_svc_channel_type_tubes_implement_get_stream_tube_socket_address:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetStreamTubeSocketAddress D-Bus method
 *
 * Register an implementation for the GetStreamTubeSocketAddress method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
/**
 * tp_svc_channel_type_tubes_return_from_get_stream_tube_socket_address:
 * @context: The D-Bus method invocation context
 * @out_Address_Type: guint  (FIXME, generate documentation)
 * @out_Address: const GValue * (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */

/**
 * tp_svc_channel_type_tubes_emit_new_tube:
 * @instance: The object implementing this interface
 * @arg_ID: guint  (FIXME, generate documentation)
 * @arg_Initiator: guint  (FIXME, generate documentation)
 * @arg_Type: guint  (FIXME, generate documentation)
 * @arg_Service: const gchar * (FIXME, generate documentation)
 * @arg_Parameters: GHashTable * (FIXME, generate documentation)
 * @arg_State: guint  (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * NewTube signal on interface org.freedesktop.Telepathy.Channel.Type.Tubes.
 */
/**
 * TpSvcChannelTypeTubes::new-tube:
 * @arg_ID: guint  (FIXME, generate documentation)
 * @arg_Initiator: guint  (FIXME, generate documentation)
 * @arg_Type: guint  (FIXME, generate documentation)
 * @arg_Service: const gchar * (FIXME, generate documentation)
 * @arg_Parameters: GHashTable * (FIXME, generate documentation)
 * @arg_State: guint  (FIXME, generate documentation)
 *
 * The NewTube D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * tp_svc_channel_type_tubes_emit_tube_state_changed:
 * @instance: The object implementing this interface
 * @arg_ID: guint  (FIXME, generate documentation)
 * @arg_State: guint  (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * TubeStateChanged signal on interface org.freedesktop.Telepathy.Channel.Type.Tubes.
 */
/**
 * TpSvcChannelTypeTubes::tube-state-changed:
 * @arg_ID: guint  (FIXME, generate documentation)
 * @arg_State: guint  (FIXME, generate documentation)
 *
 * The TubeStateChanged D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * tp_svc_channel_type_tubes_emit_tube_closed:
 * @instance: The object implementing this interface
 * @arg_ID: guint  (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * TubeClosed signal on interface org.freedesktop.Telepathy.Channel.Type.Tubes.
 */
/**
 * TpSvcChannelTypeTubes::tube-closed:
 * @arg_ID: guint  (FIXME, generate documentation)
 *
 * The TubeClosed D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * tp_svc_channel_type_tubes_emit_d_bus_names_changed:
 * @instance: The object implementing this interface
 * @arg_ID: guint  (FIXME, generate documentation)
 * @arg_Added: const GPtrArray * (FIXME, generate documentation)
 * @arg_Removed: const GArray * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * DBusNamesChanged signal on interface org.freedesktop.Telepathy.Channel.Type.Tubes.
 */
/**
 * TpSvcChannelTypeTubes::d-bus-names-changed:
 * @arg_ID: guint  (FIXME, generate documentation)
 * @arg_Added: const GPtrArray * (FIXME, generate documentation)
 * @arg_Removed: const GArray * (FIXME, generate documentation)
 *
 * The DBusNamesChanged D-Bus signal is emitted whenever this GObject signal is.
 */

/**
 * tp_svc_channel_type_tubes_emit_stream_tube_new_connection:
 * @instance: The object implementing this interface
 * @arg_ID: guint  (FIXME, generate documentation)
 * @arg_Handle: guint  (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * StreamTubeNewConnection signal on interface org.freedesktop.Telepathy.Channel.Type.Tubes.
 */
/**
 * TpSvcChannelTypeTubes::stream-tube-new-connection:
 * @arg_ID: guint  (FIXME, generate documentation)
 * @arg_Handle: guint  (FIXME, generate documentation)
 *
 * The StreamTubeNewConnection D-Bus signal is emitted whenever this GObject signal is.
 */
