/**
 * tp_cli_protocol_callback_for_identify_account:
 * @proxy: the proxy on which the call was made
 * @out_Account_ID: Used to return an 'out' argument if @error is %NULL: &lt;p&gt;An opaque string suitable for use as the account-specific part of             an &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy&quot;&gt;Account&lt;/tp:dbus-ref&gt;&apos;s object path. This is not necessarily             globally unique, but should represent a &amp;quot;best-effort&amp;quot;             identification of the account.&lt;/p&gt;            &lt;tp:rationale&gt;             &lt;p&gt;For a pathological case, consider a user signing in as               &apos;me@example.com&apos; with &apos;server&apos; set to either jabber1.example.com               or jabber2.example.com. Both of these should result in               me@example.com being returned from this method, even if the user               can actually be signed in to those two servers               simultaneously.&lt;/p&gt;           &lt;/tp:rationale&gt;
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a IdentifyAccount method call
 * succeeds or fails.
 */

/**
 * tp_cli_protocol_call_identify_account:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Parameters: Used to pass an 'in' argument: A set of parameters as would be provided to &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.ConnectionManager&quot;&gt;RequestConnection&lt;/tp:dbus-ref&gt;
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a IdentifyAccount method call.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Return a string which uniquely identifies the account to which the           given parameters would connect.&lt;/p&gt;          &lt;tp:rationale&gt;           &lt;p&gt;For many protocols, this would return the well-known &apos;account&apos;             parameter. However, for IRC the returned string would be composed             from the &apos;account&apos; (i.e. nickname) and &apos;server&apos; parameters.             AccountManager implementations can use this to form the             account-specific part of an Account&apos;s object path.&lt;/p&gt;         &lt;/tp:rationale&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */


/**
 * tp_cli_protocol_callback_for_normalize_contact:
 * @proxy: the proxy on which the call was made
 * @out_Normalized_Contact_ID: Used to return an 'out' argument if @error is %NULL: The identifier of a contact in this protocol, normalized as much           as possible
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a NormalizeContact method call
 * succeeds or fails.
 */

/**
 * tp_cli_protocol_call_normalize_contact:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Contact_ID: Used to pass an 'in' argument: The identifier of a contact in this protocol
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a NormalizeContact method call.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Attempt to normalize the given contact ID. Where possible, this           SHOULD return the same thing that would be returned by           InspectHandles(RequestHandles(CONTACT, [Contact_ID])) on a connected           &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy&quot;&gt;Connection&lt;/tp:dbus-ref&gt;.&lt;/p&gt;          &lt;p&gt;If full normalization requires network activity or is otherwise           impossible to do without a &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy&quot;&gt;Connection&lt;/tp:dbus-ref&gt;,           this method SHOULD perform a best-effort normalization.&lt;/p&gt;          &lt;tp:rationale&gt;           &lt;p&gt;One common example of a best-effort offline normalization             differing from the ideal normalization is XMPP.&lt;/p&gt;            &lt;p&gt;On XMPP, contacts&apos; JIDs should normally have the resource removed             during normalization, but for contacts in a MUC (chatroom), the             resource is an integral part of the JID - so the contact JID             alice@example.com/Empathy should normalize to alice@example.com,             but the in-MUC JID wonderland@conference.example.com/Alice should             normalize to itself.&lt;/p&gt;            &lt;p&gt;While online, the connection manager has enough context to know             which chatrooms the user is in, and can infer from that whether             to remove resources, but the best-effort normalization performed             while offline does not have this context, so the best that can be             done is to remove the resource from all JIDs.&lt;/p&gt;         &lt;/tp:rationale&gt;          &lt;p&gt;This method MAY simply raise NotImplemented on some protocols.&lt;/p&gt;          &lt;tp:rationale&gt;           &lt;p&gt;In link-local XMPP, you can&apos;t talk to someone who isn&apos;t present             on your local network, so normalizing identifiers in advance is             meaningless.&lt;/p&gt;         &lt;/tp:rationale&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

