/**
 * tp_cli_media_stream_handler_signal_callback_add_remote_candidate:
 * @proxy: The proxy on which tp_cli_media_stream_handler_connect_to_add_remote_candidate ()
 *  was called
 * @arg_Candidate_ID: String identifier for this candidate
 * @arg_Transports: Array of transports for this candidate with fields,           as defined in NewNativeCandidate
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal AddRemoteCandidate.
 */

/**
 * tp_cli_media_stream_handler_connect_to_add_remote_candidate:
 * @proxy: A #TpMediaStreamHandler or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal AddRemoteCandidate.
 *
 * Signal emitted when the connection manager wishes to inform the         client of a new remote candidate.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_media_stream_handler_signal_callback_close:
 * @proxy: The proxy on which tp_cli_media_stream_handler_connect_to_close ()
 *  was called
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal Close.
 */

/**
 * tp_cli_media_stream_handler_connect_to_close:
 * @proxy: A #TpMediaStreamHandler or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal Close.
 *
 * Signal emitted when the connection manager wishes the stream to be         closed.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_media_stream_handler_signal_callback_remove_remote_candidate:
 * @proxy: The proxy on which tp_cli_media_stream_handler_connect_to_remove_remote_candidate ()
 *  was called
 * @arg_Candidate_ID: String identifier for remote candidate to drop
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal RemoveRemoteCandidate.
 */

/**
 * tp_cli_media_stream_handler_connect_to_remove_remote_candidate:
 * @proxy: A #TpMediaStreamHandler or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal RemoveRemoteCandidate.
 *
 * Signal emitted when the connection manager wishes to inform the         client that the remote end has removed a previously usable         candidate.          &lt;tp:rationale&gt;           It seemed like a good idea at the time, but wasn&apos;t.         &lt;/tp:rationale&gt;
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_media_stream_handler_signal_callback_set_active_candidate_pair:
 * @proxy: The proxy on which tp_cli_media_stream_handler_connect_to_set_active_candidate_pair ()
 *  was called
 * @arg_Native_Candidate_ID: (Undocumented)
 * @arg_Remote_Candidate_ID: (Undocumented)
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal SetActiveCandidatePair.
 */

/**
 * tp_cli_media_stream_handler_connect_to_set_active_candidate_pair:
 * @proxy: A #TpMediaStreamHandler or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal SetActiveCandidatePair.
 *
 * Emitted by the connection manager to inform the client that a         valid candidate pair has been discovered by the remote end         and streaming is in progress.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_media_stream_handler_signal_callback_set_remote_candidate_list:
 * @proxy: The proxy on which tp_cli_media_stream_handler_connect_to_set_remote_candidate_list ()
 *  was called
 * @arg_Remote_Candidates: A list of candidate id and a list of transports         as defined in NewNativeCandidate
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal SetRemoteCandidateList.
 */

/**
 * tp_cli_media_stream_handler_connect_to_set_remote_candidate_list:
 * @proxy: A #TpMediaStreamHandler or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal SetRemoteCandidateList.
 *
 * Signal emitted when the connection manager wishes to inform the         client of all the available remote candidates at once.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_media_stream_handler_signal_callback_set_remote_codecs:
 * @proxy: The proxy on which tp_cli_media_stream_handler_connect_to_set_remote_codecs ()
 *  was called
 * @arg_Codecs: Codecs supported by the remote peer.
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal SetRemoteCodecs.
 */

/**
 * tp_cli_media_stream_handler_connect_to_set_remote_codecs:
 * @proxy: A #TpMediaStreamHandler or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal SetRemoteCodecs.
 *
 * Signal emitted when the connection manager wishes to inform the         client of the codecs supported by the remote end. 	If these codecs are compatible with the remote codecs, then the client         must call &lt;tp:member-ref&gt;SupportedCodecs&lt;/tp:member-ref&gt;,         otherwise call &lt;tp:member-ref&gt;Error&lt;/tp:member-ref&gt;.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_media_stream_handler_signal_callback_set_stream_playing:
 * @proxy: The proxy on which tp_cli_media_stream_handler_connect_to_set_stream_playing ()
 *  was called
 * @arg_Playing: (Undocumented)
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal SetStreamPlaying.
 */

/**
 * tp_cli_media_stream_handler_connect_to_set_stream_playing:
 * @proxy: A #TpMediaStreamHandler or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal SetStreamPlaying.
 *
 * If emitted with argument TRUE, this means that the connection manager         wishes to set the stream playing; this means that the streaming         implementation should expect to receive data. If emitted with argument         FALSE this signal is basically meaningless and should be ignored.          &lt;tp:rationale&gt;           We&apos;re very sorry.         &lt;/tp:rationale&gt;
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_media_stream_handler_signal_callback_set_stream_sending:
 * @proxy: The proxy on which tp_cli_media_stream_handler_connect_to_set_stream_sending ()
 *  was called
 * @arg_Sending: (Undocumented)
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal SetStreamSending.
 */

/**
 * tp_cli_media_stream_handler_connect_to_set_stream_sending:
 * @proxy: A #TpMediaStreamHandler or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal SetStreamSending.
 *
 * Signal emitted when the connection manager wishes to set whether or not         the stream sends to the remote end.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_media_stream_handler_signal_callback_start_telephony_event:
 * @proxy: The proxy on which tp_cli_media_stream_handler_connect_to_start_telephony_event ()
 *  was called
 * @arg_Event: A telephony event code as defined by RFC 4733.
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal StartTelephonyEvent.
 */

/**
 * tp_cli_media_stream_handler_connect_to_start_telephony_event:
 * @proxy: A #TpMediaStreamHandler or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal StartTelephonyEvent.
 *
 * Request that a telephony event (as defined by RFC 4733) is transmitted         over this stream until StopTelephonyEvent is called.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_media_stream_handler_signal_callback_stop_telephony_event:
 * @proxy: The proxy on which tp_cli_media_stream_handler_connect_to_stop_telephony_event ()
 *  was called
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal StopTelephonyEvent.
 */

/**
 * tp_cli_media_stream_handler_connect_to_stop_telephony_event:
 * @proxy: A #TpMediaStreamHandler or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal StopTelephonyEvent.
 *
 * Request that any ongoing telephony events (as defined by RFC 4733)         being transmitted over this stream are stopped.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_media_stream_handler_signal_callback_set_stream_held:
 * @proxy: The proxy on which tp_cli_media_stream_handler_connect_to_set_stream_held ()
 *  was called
 * @arg_Held: If true, the stream is to be placed on hold.
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal SetStreamHeld.
 */

/**
 * tp_cli_media_stream_handler_connect_to_set_stream_held:
 * @proxy: A #TpMediaStreamHandler or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal SetStreamHeld.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Emitted when the connection manager wishes to place the stream on           hold (so the streaming client should free hardware or software           resources) or take the stream off hold (so the streaming client           should reacquire the necessary resources).&lt;/p&gt;          &lt;p&gt;When placing a channel&apos;s streams on hold, the connection manager           SHOULD notify the remote contact that this will be done (if           appropriate in the protocol) before it emits this signal.&lt;/p&gt;          &lt;tp:rationale&gt;           &lt;p&gt;It is assumed that relinquishing a resource will not fail.             If it does, the call is probably doomed anyway.&lt;/p&gt;         &lt;/tp:rationale&gt;          &lt;p&gt;When unholding a channel&apos;s streams, the connection manager           SHOULD emit this signal and wait for success to be indicated           via HoldState before it notifies the remote contact that the           channel has been taken off hold.&lt;/p&gt;          &lt;tp:rationale&gt;           &lt;p&gt;This means that if a resource is unavailable, the remote             contact will never even be told that we tried to acquire it.&lt;/p&gt;         &lt;/tp:rationale&gt;
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_media_stream_handler_callback_for_codec_choice:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a CodecChoice method call
 * succeeds or fails.
 */

/**
 * tp_cli_media_stream_handler_call_codec_choice:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Codec_ID: Used to pass an 'in' argument: (Undocumented)
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a CodecChoice method call.
 *
 * Inform the connection manager of codec used to receive data.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_media_stream_handler_run_codec_choice:
 * @proxy: A #TpMediaStreamHandler or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Codec_ID: Used to pass an 'in' argument: (Undocumented)
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method CodecChoice and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Inform the connection manager of codec used to receive data.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_media_stream_handler_callback_for_error:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a Error method call
 * succeeds or fails.
 */

/**
 * tp_cli_media_stream_handler_call_error:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Error_Code: Used to pass an 'in' argument: ID of error, from the MediaStreamError enumeration
 * @in_Message: Used to pass an 'in' argument: String describing the error
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a Error method call.
 *
 * Inform the connection manager that an error occured in this stream. The         connection manager should emit the StreamError signal for the stream on         the relevant channel, and remove the stream from the session.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_media_stream_handler_run_error:
 * @proxy: A #TpMediaStreamHandler or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Error_Code: Used to pass an 'in' argument: ID of error, from the MediaStreamError enumeration
 * @in_Message: Used to pass an 'in' argument: String describing the error
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method Error and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Inform the connection manager that an error occured in this stream. The         connection manager should emit the StreamError signal for the stream on         the relevant channel, and remove the stream from the session.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_media_stream_handler_callback_for_native_candidates_prepared:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a NativeCandidatesPrepared method call
 * succeeds or fails.
 */

/**
 * tp_cli_media_stream_handler_call_native_candidates_prepared:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a NativeCandidatesPrepared method call.
 *
 * Informs the connection manager that all possible native candisates         have been discovered for the moment.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_media_stream_handler_run_native_candidates_prepared:
 * @proxy: A #TpMediaStreamHandler or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method NativeCandidatesPrepared and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Informs the connection manager that all possible native candisates         have been discovered for the moment.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_media_stream_handler_callback_for_new_active_candidate_pair:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a NewActiveCandidatePair method call
 * succeeds or fails.
 */

/**
 * tp_cli_media_stream_handler_call_new_active_candidate_pair:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Native_Candidate_ID: Used to pass an 'in' argument: (Undocumented)
 * @in_Remote_Candidate_ID: Used to pass an 'in' argument: (Undocumented)
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a NewActiveCandidatePair method call.
 *
 * Informs the connection manager that a valid candidate pair         has been discovered and streaming is in progress.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_media_stream_handler_run_new_active_candidate_pair:
 * @proxy: A #TpMediaStreamHandler or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Native_Candidate_ID: Used to pass an 'in' argument: (Undocumented)
 * @in_Remote_Candidate_ID: Used to pass an 'in' argument: (Undocumented)
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method NewActiveCandidatePair and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Informs the connection manager that a valid candidate pair         has been discovered and streaming is in progress.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_media_stream_handler_callback_for_new_native_candidate:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a NewNativeCandidate method call
 * succeeds or fails.
 */

/**
 * tp_cli_media_stream_handler_call_new_native_candidate:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Candidate_ID: Used to pass an 'in' argument: String identifier for this candidate
 * @in_Transports: Used to pass an 'in' argument: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           Array of transports for this candidate, with fields:           &lt;ul&gt;             &lt;li&gt;component number&lt;/li&gt;             &lt;li&gt;IP address (as a string)&lt;/li&gt;             &lt;li&gt;port&lt;/li&gt;             &lt;li&gt;base network protocol (one of the values of MediaStreamBaseProto)&lt;/li&gt;             &lt;li&gt;proto subtype (e.g. RTP)&lt;/li&gt;             &lt;li&gt;proto profile (e.g. AVP)&lt;/li&gt;             &lt;li&gt;our preference value of this transport (double in range 0.0-1.0               inclusive); 1 signals the most preferred transport&lt;/li&gt;             &lt;li&gt;transport type, one of the values of MediaStreamTransportType&lt;/li&gt;             &lt;li&gt;username if authentication is required&lt;/li&gt;             &lt;li&gt;password if authentication is required&lt;/li&gt;           &lt;/ul&gt;
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a NewNativeCandidate method call.
 *
 * Inform this MediaStreamHandler that a new native transport candidate         has been ascertained.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_media_stream_handler_run_new_native_candidate:
 * @proxy: A #TpMediaStreamHandler or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Candidate_ID: Used to pass an 'in' argument: String identifier for this candidate
 * @in_Transports: Used to pass an 'in' argument: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           Array of transports for this candidate, with fields:           &lt;ul&gt;             &lt;li&gt;component number&lt;/li&gt;             &lt;li&gt;IP address (as a string)&lt;/li&gt;             &lt;li&gt;port&lt;/li&gt;             &lt;li&gt;base network protocol (one of the values of MediaStreamBaseProto)&lt;/li&gt;             &lt;li&gt;proto subtype (e.g. RTP)&lt;/li&gt;             &lt;li&gt;proto profile (e.g. AVP)&lt;/li&gt;             &lt;li&gt;our preference value of this transport (double in range 0.0-1.0               inclusive); 1 signals the most preferred transport&lt;/li&gt;             &lt;li&gt;transport type, one of the values of MediaStreamTransportType&lt;/li&gt;             &lt;li&gt;username if authentication is required&lt;/li&gt;             &lt;li&gt;password if authentication is required&lt;/li&gt;           &lt;/ul&gt;
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method NewNativeCandidate and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Inform this MediaStreamHandler that a new native transport candidate         has been ascertained.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_media_stream_handler_callback_for_ready:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a Ready method call
 * succeeds or fails.
 */

/**
 * tp_cli_media_stream_handler_call_ready:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Codecs: Used to pass an 'in' argument: Locally-supported codecs.
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a Ready method call.
 *
 * Inform the connection manager that a client is ready to handle         this StreamHandler. Also provide it with info about all supported         codecs.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_media_stream_handler_run_ready:
 * @proxy: A #TpMediaStreamHandler or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Codecs: Used to pass an 'in' argument: Locally-supported codecs.
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method Ready and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Inform the connection manager that a client is ready to handle         this StreamHandler. Also provide it with info about all supported         codecs.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_media_stream_handler_callback_for_set_local_codecs:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a SetLocalCodecs method call
 * succeeds or fails.
 */

/**
 * tp_cli_media_stream_handler_call_set_local_codecs:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Codecs: Used to pass an 'in' argument: Locally-supported codecs
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a SetLocalCodecs method call.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Used to provide codecs after Ready(), so the media client can go           ready for an incoming call and exchange candidates/codecs before           knowing what local codecs are available.&lt;/p&gt;          &lt;p&gt;This is useful for gatewaying calls between two connection managers.           Given an incoming call, you need to call           &lt;tp:member-ref&gt;Ready&lt;/tp:member-ref&gt; to get the remote codecs before           you can use them as the &amp;quot;local&amp;quot; codecs to place the outgoing call,           and hence receive the outgoing call&apos;s remote codecs to use as the           incoming call&apos;s &amp;quot;local&amp;quot; codecs.&lt;/p&gt;          &lt;p&gt;In this situation, you would pass an empty list of codecs to the           incoming call&apos;s Ready method, then later call SetLocalCodecs on the           incoming call in order to respond to the offer.&lt;/p&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_media_stream_handler_run_set_local_codecs:
 * @proxy: A #TpMediaStreamHandler or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Codecs: Used to pass an 'in' argument: Locally-supported codecs
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method SetLocalCodecs and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Used to provide codecs after Ready(), so the media client can go           ready for an incoming call and exchange candidates/codecs before           knowing what local codecs are available.&lt;/p&gt;          &lt;p&gt;This is useful for gatewaying calls between two connection managers.           Given an incoming call, you need to call           &lt;tp:member-ref&gt;Ready&lt;/tp:member-ref&gt; to get the remote codecs before           you can use them as the &amp;quot;local&amp;quot; codecs to place the outgoing call,           and hence receive the outgoing call&apos;s remote codecs to use as the           incoming call&apos;s &amp;quot;local&amp;quot; codecs.&lt;/p&gt;          &lt;p&gt;In this situation, you would pass an empty list of codecs to the           incoming call&apos;s Ready method, then later call SetLocalCodecs on the           incoming call in order to respond to the offer.&lt;/p&gt;
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_media_stream_handler_callback_for_stream_state:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a StreamState method call
 * succeeds or fails.
 */

/**
 * tp_cli_media_stream_handler_call_stream_state:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_State: Used to pass an 'in' argument: (Undocumented)
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a StreamState method call.
 *
 * Informs the connection manager of the stream&apos;s current state, as         as specified in Channel.Type.StreamedMedia::ListStreams.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_media_stream_handler_run_stream_state:
 * @proxy: A #TpMediaStreamHandler or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_State: Used to pass an 'in' argument: (Undocumented)
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method StreamState and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Informs the connection manager of the stream&apos;s current state, as         as specified in Channel.Type.StreamedMedia::ListStreams.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_media_stream_handler_callback_for_supported_codecs:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a SupportedCodecs method call
 * succeeds or fails.
 */

/**
 * tp_cli_media_stream_handler_call_supported_codecs:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Codecs: Used to pass an 'in' argument: Locally supported codecs.
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a SupportedCodecs method call.
 *
 * Inform the connection manager of the supported codecs for this session.         This is called after the connection manager has emitted SetRemoteCodecs         to notify what codecs are supported by the peer, and will thus be an         intersection of all locally supported codecs (passed to Ready)         and those supported by the peer.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_media_stream_handler_run_supported_codecs:
 * @proxy: A #TpMediaStreamHandler or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Codecs: Used to pass an 'in' argument: Locally supported codecs.
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method SupportedCodecs and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Inform the connection manager of the supported codecs for this session.         This is called after the connection manager has emitted SetRemoteCodecs         to notify what codecs are supported by the peer, and will thus be an         intersection of all locally supported codecs (passed to Ready)         and those supported by the peer.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_media_stream_handler_callback_for_codecs_updated:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a CodecsUpdated method call
 * succeeds or fails.
 */

/**
 * tp_cli_media_stream_handler_call_codecs_updated:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Codecs: Used to pass an 'in' argument: Locally supported codecs, which SHOULD be the same as were previously           in effect, but possibly with different parameters.
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a CodecsUpdated method call.
 *
 * Inform the connection manager that the parameters of the supported         codecs for this session have changed. The connection manager should         send the new parameters to the remote contact.          &lt;tp:rationale&gt;           This is required for H.264 and Theora, for example.         &lt;/tp:rationale&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_media_stream_handler_run_codecs_updated:
 * @proxy: A #TpMediaStreamHandler or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Codecs: Used to pass an 'in' argument: Locally supported codecs, which SHOULD be the same as were previously           in effect, but possibly with different parameters.
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method CodecsUpdated and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Inform the connection manager that the parameters of the supported         codecs for this session have changed. The connection manager should         send the new parameters to the remote contact.          &lt;tp:rationale&gt;           This is required for H.264 and Theora, for example.         &lt;/tp:rationale&gt;
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_media_stream_handler_callback_for_hold_state:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a HoldState method call
 * succeeds or fails.
 */

/**
 * tp_cli_media_stream_handler_call_hold_state:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Held: Used to pass an 'in' argument: If true, the stream is now on hold.
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a HoldState method call.
 *
 * Notify the connection manager that the stream&apos;s hold state has         been changed successfully in response to SetStreamHeld.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_media_stream_handler_run_hold_state:
 * @proxy: A #TpMediaStreamHandler or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Held: Used to pass an 'in' argument: If true, the stream is now on hold.
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method HoldState and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Notify the connection manager that the stream&apos;s hold state has         been changed successfully in response to SetStreamHeld.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_media_stream_handler_callback_for_unhold_failure:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a UnholdFailure method call
 * succeeds or fails.
 */

/**
 * tp_cli_media_stream_handler_call_unhold_failure:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a UnholdFailure method call.
 *
 * Notify the connection manager that an attempt to reacquire the         necessary hardware or software resources to unhold the stream,         in response to SetStreamHeld, has failed.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_media_stream_handler_run_unhold_failure:
 * @proxy: A #TpMediaStreamHandler or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method UnholdFailure and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Notify the connection manager that an attempt to reacquire the         necessary hardware or software resources to unhold the stream,         in response to SetStreamHeld, has failed.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */

