/**
 * tp_cli_media_session_handler_signal_callback_new_stream_handler:
 * @proxy: The proxy on which tp_cli_media_session_handler_connect_to_new_stream_handler ()
 *  was called
 * @arg_Stream_Handler: The path of a new object implementing the &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Media&quot;&gt;StreamHandler&lt;/tp:dbus-ref&gt;           interface.
 * @arg_ID: The unique ID of the new stream
 * @arg_Media_Type: Type of media that this stream should handle
 * @arg_Direction: Direction of this stream
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal NewStreamHandler.
 */

/**
 * tp_cli_media_session_handler_connect_to_new_stream_handler:
 * @proxy: A #TpMediaSessionHandler or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal NewStreamHandler.
 *
 * Emitted when a new stream handler has been created for this         session.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_media_session_handler_callback_for_error:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a Error method call
 * succeeds or fails.
 *
 * Deprecated: Use StreamHandler.Error on each StreamHandler object instead.
 */

/**
 * tp_cli_media_session_handler_call_error:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Error_Code: Used to pass an 'in' argument: (Undocumented)
 * @in_Message: Used to pass an 'in' argument: (Undocumented)
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a Error method call.
 *
 * Informs the connection manager that an error occured in this session.         If used, the connection manager must terminate the session and all of         the streams within it, and may also emit a &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel.Type.StreamedMedia&quot;&gt;StreamError&lt;/tp:dbus-ref&gt;         signal on the channel for each stream within the session.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 *
 * Deprecated: Use StreamHandler.Error on each StreamHandler object instead.
 */

/**
 * tp_cli_media_session_handler_run_error:
 * @proxy: A #TpMediaSessionHandler or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Error_Code: Used to pass an 'in' argument: (Undocumented)
 * @in_Message: Used to pass an 'in' argument: (Undocumented)
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method Error and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Informs the connection manager that an error occured in this session.         If used, the connection manager must terminate the session and all of         the streams within it, and may also emit a &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel.Type.StreamedMedia&quot;&gt;StreamError&lt;/tp:dbus-ref&gt;         signal on the channel for each stream within the session.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 *
 * Deprecated: Use StreamHandler.Error on each StreamHandler object instead.
 */


/**
 * tp_cli_media_session_handler_callback_for_ready:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a Ready method call
 * succeeds or fails.
 */

/**
 * tp_cli_media_session_handler_call_ready:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a Ready method call.
 *
 * Inform the connection manager that a client is ready to handle         this session handler (i.e. that it has connected to the         &lt;tp:member-ref&gt;NewStreamHandler&lt;/tp:member-ref&gt; signal and done any         other necessary setup).
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_media_session_handler_run_ready:
 * @proxy: A #TpMediaSessionHandler or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method Ready and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Inform the connection manager that a client is ready to handle         this session handler (i.e. that it has connected to the         &lt;tp:member-ref&gt;NewStreamHandler&lt;/tp:member-ref&gt; signal and done any         other necessary setup).
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */

