/**
 * tp_cli_dbus_introspectable_callback_for_introspect:
 * @proxy: the proxy on which the call was made
 * @out_XML_Data: Used to return an 'out' argument if @error is %NULL: (Undocumented)
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a Introspect method call
 * succeeds or fails.
 */

/**
 * tp_cli_dbus_introspectable_call_introspect:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a Introspect method call.
 *
 * (Undocumented)
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_dbus_introspectable_run_introspect:
 * @proxy: A #TpProxy or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @out_XML_Data: Used to return an 'out' argument if %TRUE is returned: (Undocumented)
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method Introspect and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * (Undocumented)
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_dbus_peer_callback_for_ping:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a Ping method call
 * succeeds or fails.
 */

/**
 * tp_cli_dbus_peer_call_ping:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a Ping method call.
 *
 * (Undocumented)
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_dbus_peer_run_ping:
 * @proxy: A #TpProxy or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method Ping and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * (Undocumented)
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_dbus_peer_callback_for_get_machine_id:
 * @proxy: the proxy on which the call was made
 * @out_Machine_UUID: Used to return an 'out' argument if @error is %NULL: (Undocumented)
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetMachineId method call
 * succeeds or fails.
 */

/**
 * tp_cli_dbus_peer_call_get_machine_id:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetMachineId method call.
 *
 * (Undocumented)
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_dbus_peer_run_get_machine_id:
 * @proxy: A #TpProxy or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @out_Machine_UUID: Used to return an 'out' argument if %TRUE is returned: (Undocumented)
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetMachineId and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * (Undocumented)
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_dbus_properties_callback_for_get:
 * @proxy: the proxy on which the call was made
 * @out_Value: Used to return an 'out' argument if @error is %NULL: (Undocumented)
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a Get method call
 * succeeds or fails.
 */

/**
 * tp_cli_dbus_properties_call_get:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Interface_Name: Used to pass an 'in' argument: (Undocumented)
 * @in_Property_Name: Used to pass an 'in' argument: (Undocumented)
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a Get method call.
 *
 * (Undocumented)
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_dbus_properties_run_get:
 * @proxy: A #TpProxy or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Interface_Name: Used to pass an 'in' argument: (Undocumented)
 * @in_Property_Name: Used to pass an 'in' argument: (Undocumented)
 * @out_Value: Used to return an 'out' argument if %TRUE is returned: (Undocumented)
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method Get and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * (Undocumented)
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_dbus_properties_callback_for_set:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a Set method call
 * succeeds or fails.
 */

/**
 * tp_cli_dbus_properties_call_set:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Interface_Name: Used to pass an 'in' argument: (Undocumented)
 * @in_Property_Name: Used to pass an 'in' argument: (Undocumented)
 * @in_Value: Used to pass an 'in' argument: (Undocumented)
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a Set method call.
 *
 * (Undocumented)
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_dbus_properties_run_set:
 * @proxy: A #TpProxy or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Interface_Name: Used to pass an 'in' argument: (Undocumented)
 * @in_Property_Name: Used to pass an 'in' argument: (Undocumented)
 * @in_Value: Used to pass an 'in' argument: (Undocumented)
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method Set and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * (Undocumented)
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_dbus_properties_callback_for_get_all:
 * @proxy: the proxy on which the call was made
 * @out_Properties: Used to return an 'out' argument if @error is %NULL: (Undocumented)
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetAll method call
 * succeeds or fails.
 */

/**
 * tp_cli_dbus_properties_call_get_all:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Interface_Name: Used to pass an 'in' argument: (Undocumented)
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetAll method call.
 *
 * (Undocumented)
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_dbus_properties_run_get_all:
 * @proxy: A #TpProxy or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Interface_Name: Used to pass an 'in' argument: (Undocumented)
 * @out_Properties: Used to return an 'out' argument if %TRUE is returned: (Undocumented)
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetAll and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * (Undocumented)
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_properties_interface_signal_callback_properties_changed:
 * @proxy: The proxy on which tp_cli_properties_interface_connect_to_properties_changed ()
 *  was called
 * @arg_Properties: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;An array of structs containing:&lt;/p&gt;           &lt;ul&gt;             &lt;li&gt;integer identifiers&lt;/li&gt;             &lt;li&gt;variant boxed values&lt;/li&gt;           &lt;/ul&gt;           &lt;p&gt;The array should contain only properties whose values have             actually changed.&lt;/p&gt;
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal PropertiesChanged.
 */

/**
 * tp_cli_properties_interface_connect_to_properties_changed:
 * @proxy: A #TpProxy or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal PropertiesChanged.
 *
 * Emitted when the value of readable properties has changed.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_properties_interface_signal_callback_property_flags_changed:
 * @proxy: The proxy on which tp_cli_properties_interface_connect_to_property_flags_changed ()
 *  was called
 * @arg_Properties: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;An array of structs containing:&lt;/p&gt;           &lt;ul&gt;             &lt;li&gt;integer identifiers&lt;/li&gt;             &lt;li&gt;a bitwise OR of the current flags&lt;/li&gt;           &lt;/ul&gt;           &lt;p&gt;The array should contain only properties whose flags have actually             changed.&lt;/p&gt;
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal PropertyFlagsChanged.
 */

/**
 * tp_cli_properties_interface_connect_to_property_flags_changed:
 * @proxy: A #TpProxy or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal PropertyFlagsChanged.
 *
 * Emitted when the flags of some room properties have changed.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_properties_interface_callback_for_get_properties:
 * @proxy: the proxy on which the call was made
 * @out_Values: Used to return an 'out' argument if @error is %NULL: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;An array of structs containing:&lt;/p&gt;           &lt;ul&gt;             &lt;li&gt;integer identifiers&lt;/li&gt;             &lt;li&gt;variant boxed values&lt;/li&gt;           &lt;/ul&gt;
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetProperties method call
 * succeeds or fails.
 */

/**
 * tp_cli_properties_interface_call_get_properties:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Properties: Used to pass an 'in' argument: An array of property identifiers
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetProperties method call.
 *
 * Returns an array of (identifier, value) pairs containing the current         values of the given properties.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_properties_interface_run_get_properties:
 * @proxy: A #TpProxy or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Properties: Used to pass an 'in' argument: An array of property identifiers
 * @out_Values: Used to return an 'out' argument if %TRUE is returned: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;An array of structs containing:&lt;/p&gt;           &lt;ul&gt;             &lt;li&gt;integer identifiers&lt;/li&gt;             &lt;li&gt;variant boxed values&lt;/li&gt;           &lt;/ul&gt;
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetProperties and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Returns an array of (identifier, value) pairs containing the current         values of the given properties.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_properties_interface_callback_for_list_properties:
 * @proxy: the proxy on which the call was made
 * @out_Available_Properties: Used to return an 'out' argument if @error is %NULL: An array of structs containing:           &lt;ul&gt;             &lt;li&gt;an integer identifier&lt;/li&gt;             &lt;li&gt;a string property name&lt;/li&gt;             &lt;li&gt;a string representing the D-Bus signature of this property&lt;/li&gt;             &lt;li&gt;a bitwise OR of the flags applicable to this property&lt;/li&gt;           &lt;/ul&gt;
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a ListProperties method call
 * succeeds or fails.
 */

/**
 * tp_cli_properties_interface_call_list_properties:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a ListProperties method call.
 *
 * Returns a dictionary of the properties available on this channel.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_properties_interface_run_list_properties:
 * @proxy: A #TpProxy or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @out_Available_Properties: Used to return an 'out' argument if %TRUE is returned: An array of structs containing:           &lt;ul&gt;             &lt;li&gt;an integer identifier&lt;/li&gt;             &lt;li&gt;a string property name&lt;/li&gt;             &lt;li&gt;a string representing the D-Bus signature of this property&lt;/li&gt;             &lt;li&gt;a bitwise OR of the flags applicable to this property&lt;/li&gt;           &lt;/ul&gt;
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method ListProperties and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Returns a dictionary of the properties available on this channel.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_properties_interface_callback_for_set_properties:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a SetProperties method call
 * succeeds or fails.
 */

/**
 * tp_cli_properties_interface_call_set_properties:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Properties: Used to pass an 'in' argument: An array mapping integer property identifiers to boxed values
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a SetProperties method call.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Takes an array of (identifier, value) pairs containing desired           values to set the given properties. In the case of any errors, no           properties will be changed. When the changes have been acknowledged           by the server, the PropertiesChanged signal will be emitted.&lt;/p&gt;          &lt;p&gt;All properties given must have the PROPERTY_FLAG_WRITE flag, or         PermissionDenied will be returned. If any variants are of the wrong         type, NotAvailable will be returned.  If any given property identifiers         are invalid, InvalidArgument will be returned.&lt;/p&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_properties_interface_run_set_properties:
 * @proxy: A #TpProxy or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Properties: Used to pass an 'in' argument: An array mapping integer property identifiers to boxed values
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method SetProperties and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Takes an array of (identifier, value) pairs containing desired           values to set the given properties. In the case of any errors, no           properties will be changed. When the changes have been acknowledged           by the server, the PropertiesChanged signal will be emitted.&lt;/p&gt;          &lt;p&gt;All properties given must have the PROPERTY_FLAG_WRITE flag, or         PermissionDenied will be returned. If any variants are of the wrong         type, NotAvailable will be returned.  If any given property identifiers         are invalid, InvalidArgument will be returned.&lt;/p&gt;
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */

