/**
 * tp_cli_connection_manager_signal_callback_new_connection:
 * @proxy: The proxy on which tp_cli_connection_manager_connect_to_new_connection ()
 *  was called
 * @arg_Bus_Name: The D-Bus service where the connection object can be found
 * @arg_Object_Path: The object path of the Connection object on this service
 * @arg_Protocol: The identifier for the protocol this connection uses
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal NewConnection.
 */

/**
 * tp_cli_connection_manager_connect_to_new_connection:
 * @proxy: A #TpConnectionManager or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal NewConnection.
 *
 * Emitted when a new &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy&quot;&gt;Connection&lt;/tp:dbus-ref&gt; object         is created.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_connection_manager_callback_for_get_parameters:
 * @proxy: the proxy on which the call was made
 * @out_Parameters: Used to return an 'out' argument if @error is %NULL: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           An array of structs representing possible parameters.
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetParameters method call
 * succeeds or fails.
 */

/**
 * tp_cli_connection_manager_call_get_parameters:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Protocol: Used to pass an 'in' argument: The required protocol name
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetParameters method call.
 *
 * Get a list of the parameters which must or may be provided to the         &lt;tp:member-ref&gt;RequestConnection&lt;/tp:member-ref&gt; method when connecting         to the given protocol,         or registering (the boolean &amp;quot;register&amp;quot; parameter is available,         and set to true).
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_connection_manager_run_get_parameters:
 * @proxy: A #TpConnectionManager or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Protocol: Used to pass an 'in' argument: The required protocol name
 * @out_Parameters: Used to return an 'out' argument if %TRUE is returned: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           An array of structs representing possible parameters.
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetParameters and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Get a list of the parameters which must or may be provided to the         &lt;tp:member-ref&gt;RequestConnection&lt;/tp:member-ref&gt; method when connecting         to the given protocol,         or registering (the boolean &amp;quot;register&amp;quot; parameter is available,         and set to true).
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_connection_manager_callback_for_list_protocols:
 * @proxy: the proxy on which the call was made
 * @out_Protocols: Used to return an 'out' argument if @error is %NULL: The keys of the &lt;tp:member-ref&gt;Protocols&lt;/tp:member-ref&gt; map.
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a ListProtocols method call
 * succeeds or fails.
 */

/**
 * tp_cli_connection_manager_call_list_protocols:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a ListProtocols method call.
 *
 * Get a list of protocol identifiers that are implemented by this         connection manager.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_connection_manager_run_list_protocols:
 * @proxy: A #TpConnectionManager or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @out_Protocols: Used to return an 'out' argument if %TRUE is returned: The keys of the &lt;tp:member-ref&gt;Protocols&lt;/tp:member-ref&gt; map.
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method ListProtocols and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Get a list of protocol identifiers that are implemented by this         connection manager.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_connection_manager_callback_for_request_connection:
 * @proxy: the proxy on which the call was made
 * @out_Bus_Name: Used to return an 'out' argument if @error is %NULL: A D-Bus service name where the new Connection object can be found
 * @out_Object_Path: Used to return an 'out' argument if @error is %NULL: The D-Bus object path to the Connection on this service
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a RequestConnection method call
 * succeeds or fails.
 */

/**
 * tp_cli_connection_manager_call_request_connection:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Protocol: Used to pass an 'in' argument: The protocol identifier
 * @in_Parameters: Used to pass an 'in' argument: A dictionary mapping parameter names to values of the appropriate           type, as indicated by &lt;tp:member-ref&gt;GetParameters&lt;/tp:member-ref&gt;           and the above well-known list.
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a RequestConnection method call.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Request a           &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy&quot;&gt;Connection&lt;/tp:dbus-ref&gt;           object representing a given account on a given           protocol with the given parameters. The method returns the bus name           and the object path where the new Connection object can be found,           which should have the status of Connection_Status_Disconnected, to           allow signal handlers to be attached before connecting is started           with the           &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Connection&quot;&gt;Connect&lt;/tp:dbus-ref&gt;           method.&lt;/p&gt;          &lt;p&gt;The parameters which must and may be provided in the parameters         dictionary can be discovered with the         &lt;tp:member-ref&gt;GetParameters&lt;/tp:member-ref&gt; method. These         parameters, their types, and their default values may be cached         in files so that all available connection managers do not need to be         started to discover which protocols are available.&lt;/p&gt;          &lt;p&gt;To request values for these parameters from the user, a client must         have prior knowledge of the meaning of the parameter names, so the         following well-known names and types should be used where appropriate:&lt;/p&gt;          &lt;dl&gt;           &lt;dt&gt;account (s)&lt;/dt&gt;           &lt;dd&gt;The identifier for the user&apos;s account on the server&lt;/dd&gt;            &lt;dt&gt;server (s)&lt;/dt&gt;           &lt;dd&gt;A fully qualified domain name or numeric IPv4 or IPv6 address.             Using the fully-qualified domain name form is recommended whenever             possible. If this parameter is specified and the account for that             protocol also specifies a server, this parameter should override             that in the user id.&lt;/dd&gt;            &lt;dt&gt;port (q)&lt;/dt&gt;           &lt;dd&gt;A TCP or UDP port number. If this parameter is specified and the             account for that protocol also specifies a port, this parameter             should override that in the account.&lt;/dd&gt;            &lt;dt&gt;password (s)&lt;/dt&gt;           &lt;dd&gt;A password associated with the account.&lt;/dd&gt;            &lt;dt&gt;require-encryption (b)&lt;/dt&gt;           &lt;dd&gt;Require encryption for this connection. A connection should fail             to connect if require-encryption is set and an encrypted connection             is not possible.&lt;/dd&gt;            &lt;dt&gt;register (b)&lt;/dt&gt;           &lt;dd&gt;This account should be created on the server if it does not             already exist.&lt;/dd&gt;            &lt;dt&gt;ident (s)&lt;/dt&gt;           &lt;dd&gt;The local username to report to the server if necessary, such as             in IRC.&lt;/dd&gt;            &lt;dt&gt;fullname (s)&lt;/dt&gt;           &lt;dd&gt;The user&apos;s full name if the service requires this when             authenticating or registering.&lt;/dd&gt;            &lt;dt&gt;stun-server (s)&lt;/dt&gt;           &lt;dd&gt;The IP address or FQDN of a STUN server to use for NAT traversal,             without any &amp;quot;:port&amp;quot; suffix.&lt;/dd&gt;            &lt;dt&gt;stun-port (q)&lt;/dt&gt;           &lt;dd&gt;The UDP port number on the stun-server to use for STUN. Only             significant if the stun-server is also supplied.&lt;/dd&gt;            &lt;dt&gt;keepalive-interval (u)&lt;/dt&gt;           &lt;dd&gt;The time in seconds between pings sent to the server to ensure             that the connection is still alive, or &lt;tt&gt;0&lt;/tt&gt; to disable such             pings.&lt;/dd&gt;         &lt;/dl&gt;          &lt;p&gt;Connection manager authors SHOULD avoid introducing parameters           whose default values would not be serializable in a           &lt;code&gt;.manager&lt;/code&gt; file.&lt;/p&gt;          &lt;tp:rationale&gt;           &lt;p&gt;The same serialization format is used in Mission Control             to store accounts.&lt;/p&gt;         &lt;/tp:rationale&gt;          &lt;p&gt;Every successful RequestConnection call will cause the emission of a         &lt;tp:member-ref&gt;NewConnection&lt;/tp:member-ref&gt; signal for the same newly         created connection. The         requester can use the returned object path and service name         independently of the emission of that signal. In that case this signal         emission is most useful for, e.g. other processes that are monitoring         the creation of new connections.&lt;/p&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_connection_manager_run_request_connection:
 * @proxy: A #TpConnectionManager or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Protocol: Used to pass an 'in' argument: The protocol identifier
 * @in_Parameters: Used to pass an 'in' argument: A dictionary mapping parameter names to values of the appropriate           type, as indicated by &lt;tp:member-ref&gt;GetParameters&lt;/tp:member-ref&gt;           and the above well-known list.
 * @out_Bus_Name: Used to return an 'out' argument if %TRUE is returned: A D-Bus service name where the new Connection object can be found
 * @out_Object_Path: Used to return an 'out' argument if %TRUE is returned: The D-Bus object path to the Connection on this service
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method RequestConnection and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Request a           &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy&quot;&gt;Connection&lt;/tp:dbus-ref&gt;           object representing a given account on a given           protocol with the given parameters. The method returns the bus name           and the object path where the new Connection object can be found,           which should have the status of Connection_Status_Disconnected, to           allow signal handlers to be attached before connecting is started           with the           &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Connection&quot;&gt;Connect&lt;/tp:dbus-ref&gt;           method.&lt;/p&gt;          &lt;p&gt;The parameters which must and may be provided in the parameters         dictionary can be discovered with the         &lt;tp:member-ref&gt;GetParameters&lt;/tp:member-ref&gt; method. These         parameters, their types, and their default values may be cached         in files so that all available connection managers do not need to be         started to discover which protocols are available.&lt;/p&gt;          &lt;p&gt;To request values for these parameters from the user, a client must         have prior knowledge of the meaning of the parameter names, so the         following well-known names and types should be used where appropriate:&lt;/p&gt;          &lt;dl&gt;           &lt;dt&gt;account (s)&lt;/dt&gt;           &lt;dd&gt;The identifier for the user&apos;s account on the server&lt;/dd&gt;            &lt;dt&gt;server (s)&lt;/dt&gt;           &lt;dd&gt;A fully qualified domain name or numeric IPv4 or IPv6 address.             Using the fully-qualified domain name form is recommended whenever             possible. If this parameter is specified and the account for that             protocol also specifies a server, this parameter should override             that in the user id.&lt;/dd&gt;            &lt;dt&gt;port (q)&lt;/dt&gt;           &lt;dd&gt;A TCP or UDP port number. If this parameter is specified and the             account for that protocol also specifies a port, this parameter             should override that in the account.&lt;/dd&gt;            &lt;dt&gt;password (s)&lt;/dt&gt;           &lt;dd&gt;A password associated with the account.&lt;/dd&gt;            &lt;dt&gt;require-encryption (b)&lt;/dt&gt;           &lt;dd&gt;Require encryption for this connection. A connection should fail             to connect if require-encryption is set and an encrypted connection             is not possible.&lt;/dd&gt;            &lt;dt&gt;register (b)&lt;/dt&gt;           &lt;dd&gt;This account should be created on the server if it does not             already exist.&lt;/dd&gt;            &lt;dt&gt;ident (s)&lt;/dt&gt;           &lt;dd&gt;The local username to report to the server if necessary, such as             in IRC.&lt;/dd&gt;            &lt;dt&gt;fullname (s)&lt;/dt&gt;           &lt;dd&gt;The user&apos;s full name if the service requires this when             authenticating or registering.&lt;/dd&gt;            &lt;dt&gt;stun-server (s)&lt;/dt&gt;           &lt;dd&gt;The IP address or FQDN of a STUN server to use for NAT traversal,             without any &amp;quot;:port&amp;quot; suffix.&lt;/dd&gt;            &lt;dt&gt;stun-port (q)&lt;/dt&gt;           &lt;dd&gt;The UDP port number on the stun-server to use for STUN. Only             significant if the stun-server is also supplied.&lt;/dd&gt;            &lt;dt&gt;keepalive-interval (u)&lt;/dt&gt;           &lt;dd&gt;The time in seconds between pings sent to the server to ensure             that the connection is still alive, or &lt;tt&gt;0&lt;/tt&gt; to disable such             pings.&lt;/dd&gt;         &lt;/dl&gt;          &lt;p&gt;Connection manager authors SHOULD avoid introducing parameters           whose default values would not be serializable in a           &lt;code&gt;.manager&lt;/code&gt; file.&lt;/p&gt;          &lt;tp:rationale&gt;           &lt;p&gt;The same serialization format is used in Mission Control             to store accounts.&lt;/p&gt;         &lt;/tp:rationale&gt;          &lt;p&gt;Every successful RequestConnection call will cause the emission of a         &lt;tp:member-ref&gt;NewConnection&lt;/tp:member-ref&gt; signal for the same newly         created connection. The         requester can use the returned object path and service name         independently of the emission of that signal. In that case this signal         emission is most useful for, e.g. other processes that are monitoring         the creation of new connections.&lt;/p&gt;
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */

