/**
 * tp_cli_connection_signal_callback_self_handle_changed:
 * @proxy: The proxy on which tp_cli_connection_connect_to_self_handle_changed ()
 *  was called
 * @arg_Self_Handle: The new value of the SelfHandle property.
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal SelfHandleChanged.
 */

/**
 * tp_cli_connection_connect_to_self_handle_changed:
 * @proxy: A #TpConnection or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal SelfHandleChanged.
 *
 * Emitted whenever the &lt;tp:member-ref&gt;SelfHandle&lt;/tp:member-ref&gt; property         changes. If the connection         is not yet in the CONNECTED state, this signal is not guaranteed         to be emitted.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_connection_signal_callback_new_channel:
 * @proxy: The proxy on which tp_cli_connection_connect_to_new_channel ()
 *  was called
 * @arg_Object_Path: A D-Bus object path for the channel object on this service
 * @arg_Channel_Type: A D-Bus interface name representing the channel type
 * @arg_Handle_Type: An integer representing the type of handle this channel           communicates with, or Handle_Type_None if no handle is specified
 * @arg_Handle: A handle indicating the specific contact, room or list this           channel communicates with, or zero if no handle is specified
 * @arg_Suppress_Handler: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;If true, the channel was requested by a client that intends to             present it to the user itself (i.e. it passed suppress_handler=TRUE             to the &lt;tp:member-ref&gt;RequestChannel&lt;/tp:member-ref&gt; method), so no             other handler should be             launched. Clients MAY assume that channels where this is true             were created by a user request.&lt;/p&gt;            &lt;p&gt;If false, either the channel was created due to incoming             information from the service, or the channel was requested by             a local client that does not intend to handle the channel itself             (this usage is deprecated).&lt;/p&gt;            &lt;p&gt;Clients MUST NOT assume that only incoming channels will have             this flag set to false.&lt;/p&gt;
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal NewChannel.
 */

/**
 * tp_cli_connection_connect_to_new_channel:
 * @proxy: A #TpConnection or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal NewChannel.
 *
 * Emitted when a new Channel object is created, either through user         request or incoming information from the service.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_connection_signal_callback_connection_error:
 * @proxy: The proxy on which tp_cli_connection_connect_to_connection_error ()
 *  was called
 * @arg_Error: The name of a D-Bus error describing the error that occurred,           which may correspond to a           &lt;tp:type&gt;Connection_Status_Reason&lt;/tp:type&gt;, or may be a more           specific Telepathy error           (such as           &lt;code&gt;org.freedesktop.Telepathy.Errors.ConnectionRefused&lt;/code&gt;           for Connection_Status_Reason_Network_Error)           or a protocol-specific or connection-manager-specific error in a           suitable namespace.            &lt;tp:rationale&gt;             For instance, a SIP connection manager could signal             &amp;quot;402 Payment Required&amp;quot; as an error in a             connection-manager-specific namespace, or a link-local             XMPP implementation that used Avahi could provide the error             given to it by the avahi-daemon.           &lt;/tp:rationale&gt;
 * @arg_Details: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;Additional information about the error, which may include             the following well-known keys:&lt;/p&gt;            &lt;dl&gt;             &lt;dt&gt;debug-message (s)&lt;/dt&gt;             &lt;dd&gt;Debugging information on the change, corresponding to the               message part of a D-Bus error message, which SHOULD NOT be               displayed to users under normal circumstances&lt;/dd&gt; 	    &lt;dt&gt;user-requested (b), expected-hostname (s), certificate-hostname (s)&lt;/dt&gt; 	    &lt;dd&gt;The same details defined in &lt;tp:type&gt;TLS_Certificate_Rejection&lt;/tp:type&gt;.&lt;/dd&gt;           &lt;/dl&gt;
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal ConnectionError.
 */

/**
 * tp_cli_connection_connect_to_connection_error:
 * @proxy: A #TpConnection or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal ConnectionError.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Emitted when an error occurs that renders this connection unusable.         &lt;/p&gt;          &lt;p&gt;Whenever this signal is emitted, it MUST immediately be followed by           a &lt;tp:member-ref&gt;StatusChanged&lt;/tp:member-ref&gt; signal with status           Connection_Status_Disconnected and an appropriate reason           code.&lt;/p&gt;          &lt;p&gt;Connection managers SHOULD emit this signal on disconnection, but           need not do so. Clients MUST support connection managers that emit           StatusChanged(Disconnected, ...) without first emitting           ConnectionError.&lt;/p&gt;          &lt;tp:rationale&gt;           &lt;p&gt;This signal provides additional information about the reason             for disconnection. The reason for connection is always             straightforward - it was requested - so it does not need further             explanation. However, on errors, it can be useful to provide             additional information.&lt;/p&gt;            &lt;p&gt;The &lt;tp:type&gt;Connection_Status_Reason&lt;/tp:type&gt; is not given             here, since it will be signalled in             &lt;tp:member-ref&gt;StatusChanged&lt;/tp:member-ref&gt;. A reasonable client             implementation would be to store the information given by this             signal until StatusChanged is received, at which point the             information given by this signal can be used to supplement the             StatusChanged signal.&lt;/p&gt;         &lt;/tp:rationale&gt;
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_connection_signal_callback_status_changed:
 * @proxy: The proxy on which tp_cli_connection_connect_to_status_changed ()
 *  was called
 * @arg_Status: An integer indicating the new status, as defined by ConnectionStatus
 * @arg_Reason: An integer indicating the reason for the status change, as defined           by ConnectionStatusReason
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal StatusChanged.
 */

/**
 * tp_cli_connection_connect_to_status_changed:
 * @proxy: A #TpConnection or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal StatusChanged.
 *
 * Emitted when the status of the connection changes.  All states and         reasons have numerical values, as defined in ConnectionStatus         and ConnectionStatusReason.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_connection_callback_for_connect:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a Connect method call
 * succeeds or fails.
 */

/**
 * tp_cli_connection_call_connect:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a Connect method call.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Request that the connection be established. This will be done           asynchronously and errors will be returned by emitting           &lt;tp:member-ref&gt;StatusChanged&lt;/tp:member-ref&gt; signals.&lt;/p&gt;          &lt;p&gt;Calling this method on a Connection that is already connecting           or connected is allowed, and has no effect.&lt;/p&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_connection_run_connect:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method Connect and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Request that the connection be established. This will be done           asynchronously and errors will be returned by emitting           &lt;tp:member-ref&gt;StatusChanged&lt;/tp:member-ref&gt; signals.&lt;/p&gt;          &lt;p&gt;Calling this method on a Connection that is already connecting           or connected is allowed, and has no effect.&lt;/p&gt;
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_connection_callback_for_disconnect:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a Disconnect method call
 * succeeds or fails.
 */

/**
 * tp_cli_connection_call_disconnect:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a Disconnect method call.
 *
 * Request that the connection be closed. This closes the connection if         it&apos;s not already in DISCONNECTED state, and destroys the connection         object.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_connection_run_disconnect:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method Disconnect and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Request that the connection be closed. This closes the connection if         it&apos;s not already in DISCONNECTED state, and destroys the connection         object.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_connection_callback_for_get_interfaces:
 * @proxy: the proxy on which the call was made
 * @out_Interfaces: Used to return an 'out' argument if @error is %NULL: The value of the &lt;tp:member-ref&gt;Interfaces&lt;/tp:member-ref&gt; property
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetInterfaces method call
 * succeeds or fails.
 */

/**
 * tp_cli_connection_call_get_interfaces:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetInterfaces method call.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Returns the set of optional interfaces supported by this           connection. See &lt;tp:member-ref&gt;Interfaces&lt;/tp:member-ref&gt; for more           details.&lt;/p&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_connection_run_get_interfaces:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @out_Interfaces: Used to return an 'out' argument if %TRUE is returned: The value of the &lt;tp:member-ref&gt;Interfaces&lt;/tp:member-ref&gt; property
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetInterfaces and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Returns the set of optional interfaces supported by this           connection. See &lt;tp:member-ref&gt;Interfaces&lt;/tp:member-ref&gt; for more           details.&lt;/p&gt;
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_connection_callback_for_get_protocol:
 * @proxy: the proxy on which the call was made
 * @out_Protocol: Used to return an 'out' argument if @error is %NULL: A string identifier for the protocol
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetProtocol method call
 * succeeds or fails.
 */

/**
 * tp_cli_connection_call_get_protocol:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetProtocol method call.
 *
 * Get the protocol this connection is using.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_connection_run_get_protocol:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @out_Protocol: Used to return an 'out' argument if %TRUE is returned: A string identifier for the protocol
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetProtocol and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Get the protocol this connection is using.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_connection_callback_for_get_self_handle:
 * @proxy: the proxy on which the call was made
 * @out_Self_Handle: Used to return an 'out' argument if @error is %NULL: The value of the &lt;tp:member-ref&gt;SelfHandle&lt;/tp:member-ref&gt; property
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetSelfHandle method call
 * succeeds or fails.
 *
 * Deprecated: Use GetAll to get the         SelfHandle property (and all other Connection properties)         instead.
 */

/**
 * tp_cli_connection_call_get_self_handle:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetSelfHandle method call.
 *
 * Returns the value of the SelfHandle property. Change notification         is via the SelfHandleChanged signal.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 *
 * Deprecated: Use GetAll to get the         SelfHandle property (and all other Connection properties)         instead.
 */

/**
 * tp_cli_connection_run_get_self_handle:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @out_Self_Handle: Used to return an 'out' argument if %TRUE is returned: The value of the &lt;tp:member-ref&gt;SelfHandle&lt;/tp:member-ref&gt; property
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetSelfHandle and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Returns the value of the SelfHandle property. Change notification         is via the SelfHandleChanged signal.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 *
 * Deprecated: Use GetAll to get the         SelfHandle property (and all other Connection properties)         instead.
 */


/**
 * tp_cli_connection_callback_for_get_status:
 * @proxy: the proxy on which the call was made
 * @out_Status: Used to return an 'out' argument if @error is %NULL: The value of the &lt;tp:member-ref&gt;Status&lt;/tp:member-ref&gt; property
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetStatus method call
 * succeeds or fails.
 */

/**
 * tp_cli_connection_call_get_status:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetStatus method call.
 *
 * Get the current status as defined in the         &lt;tp:member-ref&gt;StatusChanged&lt;/tp:member-ref&gt; signal.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_connection_run_get_status:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @out_Status: Used to return an 'out' argument if %TRUE is returned: The value of the &lt;tp:member-ref&gt;Status&lt;/tp:member-ref&gt; property
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetStatus and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Get the current status as defined in the         &lt;tp:member-ref&gt;StatusChanged&lt;/tp:member-ref&gt; signal.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_connection_callback_for_hold_handles:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a HoldHandles method call
 * succeeds or fails.
 */

/**
 * tp_cli_connection_call_hold_handles:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Handle_Type: Used to pass an 'in' argument: The type of handle to be held
 * @in_Handles: Used to pass an 'in' argument: A array of integer handles to hold
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a HoldHandles method call.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Notify the connection manger that your client is holding a copy         of handles which may not be in use in any existing channel or         list, and were not obtained by using the         &lt;tp:member-ref&gt;RequestHandles&lt;/tp:member-ref&gt; method. For         example, a handle observed in an emitted signal, or displayed         somewhere in the UI that is not associated with a channel. The         connection manager must not deallocate a handle where any clients         have used this method to indicate it is in use until the         &lt;tp:member-ref&gt;ReleaseHandles&lt;/tp:member-ref&gt;         method is called, or the clients disappear from the bus.&lt;/p&gt;          &lt;p&gt;Note that HoldHandles is idempotent - calling it multiple times           is equivalent to calling it once. If a handle is &amp;quot;referenced&amp;quot; by           several components which share a D-Bus unique name, the client           should perform reference counting internally, and only call           ReleaseHandles when none of the cooperating components need the           handle any longer.&lt;/p&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_connection_run_hold_handles:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Handle_Type: Used to pass an 'in' argument: The type of handle to be held
 * @in_Handles: Used to pass an 'in' argument: A array of integer handles to hold
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method HoldHandles and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Notify the connection manger that your client is holding a copy         of handles which may not be in use in any existing channel or         list, and were not obtained by using the         &lt;tp:member-ref&gt;RequestHandles&lt;/tp:member-ref&gt; method. For         example, a handle observed in an emitted signal, or displayed         somewhere in the UI that is not associated with a channel. The         connection manager must not deallocate a handle where any clients         have used this method to indicate it is in use until the         &lt;tp:member-ref&gt;ReleaseHandles&lt;/tp:member-ref&gt;         method is called, or the clients disappear from the bus.&lt;/p&gt;          &lt;p&gt;Note that HoldHandles is idempotent - calling it multiple times           is equivalent to calling it once. If a handle is &amp;quot;referenced&amp;quot; by           several components which share a D-Bus unique name, the client           should perform reference counting internally, and only call           ReleaseHandles when none of the cooperating components need the           handle any longer.&lt;/p&gt;
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_connection_callback_for_inspect_handles:
 * @proxy: the proxy on which the call was made
 * @out_Identifiers: Used to return an 'out' argument if @error is %NULL: An array of identifiers corresponding to the given handles, in the same order.
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a InspectHandles method call
 * succeeds or fails.
 */

/**
 * tp_cli_connection_call_inspect_handles:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Handle_Type: Used to pass an 'in' argument: The type of handle to be inspected
 * @in_Handles: Used to pass an 'in' argument: An array of integer handles of this type
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a InspectHandles method call.
 *
 * Return a string representation for a number of handles of a given         type.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_connection_run_inspect_handles:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Handle_Type: Used to pass an 'in' argument: The type of handle to be inspected
 * @in_Handles: Used to pass an 'in' argument: An array of integer handles of this type
 * @out_Identifiers: Used to return an 'out' argument if %TRUE is returned: An array of identifiers corresponding to the given handles, in the same order.
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method InspectHandles and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Return a string representation for a number of handles of a given         type.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_connection_callback_for_list_channels:
 * @proxy: the proxy on which the call was made
 * @out_Channel_Info: Used to return an 'out' argument if @error is %NULL: An array of structs representing channels.
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a ListChannels method call
 * succeeds or fails.
 *
 * Deprecated: Use the Requests.Channels property instead.
 */

/**
 * tp_cli_connection_call_list_channels:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a ListChannels method call.
 *
 * List all the channels which currently exist on this connection.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 *
 * Deprecated: Use the Requests.Channels property instead.
 */

/**
 * tp_cli_connection_run_list_channels:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @out_Channel_Info: Used to return an 'out' argument if %TRUE is returned: An array of structs representing channels.
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method ListChannels and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * List all the channels which currently exist on this connection.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 *
 * Deprecated: Use the Requests.Channels property instead.
 */


/**
 * tp_cli_connection_callback_for_release_handles:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a ReleaseHandles method call
 * succeeds or fails.
 */

/**
 * tp_cli_connection_call_release_handles:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Handle_Type: Used to pass an 'in' argument: An integer handle type (as defined in RequestHandle)
 * @in_Handles: Used to pass an 'in' argument: An array of integer handles being held by the client
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a ReleaseHandles method call.
 *
 * Explicitly notify the connection manager that your client is no         longer holding any references to the given handles, and that they         may be deallocated if they are not held by any other clients or         referenced by any existing channels. See HoldHandles for notes.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_connection_run_release_handles:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Handle_Type: Used to pass an 'in' argument: An integer handle type (as defined in RequestHandle)
 * @in_Handles: Used to pass an 'in' argument: An array of integer handles being held by the client
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method ReleaseHandles and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Explicitly notify the connection manager that your client is no         longer holding any references to the given handles, and that they         may be deallocated if they are not held by any other clients or         referenced by any existing channels. See HoldHandles for notes.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_connection_callback_for_request_channel:
 * @proxy: the proxy on which the call was made
 * @out_Object_Path: Used to return an 'out' argument if @error is %NULL: The D-Bus object path for the channel created or retrieved
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a RequestChannel method call
 * succeeds or fails.
 *
 * Deprecated: Use Requests.CreateChannel or Requests.EnsureChannel instead. Connection managers MAY implement RequestChannel by         raising NotImplemented, or implement fewer types of channel via         this API.
 */

/**
 * tp_cli_connection_call_request_channel:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Type: Used to pass an 'in' argument: A D-Bus interface name representing base channel type
 * @in_Handle_Type: Used to pass an 'in' argument: An integer representing the handle type, or Handle_Type_None if           no handle is specified
 * @in_Handle: Used to pass an 'in' argument: A nonzero integer handle representing a contact, room, list etc.           according to handle_type, or zero if the handle_type is           Handle_Type_None
 * @in_Suppress_Handler: Used to pass an 'in' argument: &lt;p&gt;Clients SHOULD always set this to true.&lt;/p&gt;            &lt;tp:rationale&gt;             &lt;p&gt;The historical meaning was that clients that did not               intend to take responsibility for displaying the channel to               the user could set this to FALSE, in which case the channel               dispatcher would launch an appropriate channel handler.&lt;/p&gt;              &lt;p&gt;However, clients whose functionality relies on having a               working channel dispatcher should obtain that functionality by               calling methods on the channel dispatcher, so that they will               get an appropriate error if the channel dispatcher is missing               or not working.&lt;/p&gt;              &lt;p&gt;The channel dispatcher itself should set this to true too,               so that it will ignore the               &lt;tp:member-ref&gt;NewChannel&lt;/tp:member-ref&gt; signal that results               from the creation of the channel. It can then dispatch the               channel returned from this method to an               appropriate handler.&lt;/p&gt;              &lt;p&gt;So, there is no sensible use-case for setting this to false,               and setting it to false can result in unhandled channels (in               the case where clients assume that a channel dispatcher is               present, but it isn&apos;t).&lt;/p&gt;           &lt;/tp:rationale&gt;
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a RequestChannel method call.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Request a channel satisfying the specified type and communicating           with the contact, room, list etc. indicated by the given           handle_type and handle. The handle_type and handle may both be           zero to request the creation of a new, empty channel, which may           or may not be possible, depending on the protocol and channel           type.&lt;/p&gt;          &lt;p&gt;On success, the returned channel will always be of the requested           type (i.e. implement the requested channel-type interface).&lt;/p&gt;          &lt;p&gt;If a new, empty channel is requested, on success the returned           channel will always be an &amp;quot;anonymous&amp;quot; channel for which the type           and handle are both zero.&lt;/p&gt;          &lt;p&gt;If a channel to a contact, room etc. is requested, on success, the           returned channel may either be a new or existing channel to           the requested entity (i.e. its           &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel&quot;&gt;TargetHandleType&lt;/tp:dbus-ref&gt;           and &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel&quot;&gt;TargetHandle&lt;/tp:dbus-ref&gt;           properties are the           requested handle type and handle), or a newly created &amp;quot;anonymous&amp;quot;           channel associated with the requested handle in some           implementation-specific way.&lt;/p&gt;          &lt;p&gt;For example, for a contact handle, the returned channel           might be &amp;quot;anonymous&amp;quot;, but implement the groups interface and have           the requested contact already present among the members.&lt;/p&gt;          &lt;p&gt;If the request cannot be satisfied, an error is raised and no           channel is created.&lt;/p&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 *
 * Deprecated: Use Requests.CreateChannel or Requests.EnsureChannel instead. Connection managers MAY implement RequestChannel by         raising NotImplemented, or implement fewer types of channel via         this API.
 */

/**
 * tp_cli_connection_run_request_channel:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Type: Used to pass an 'in' argument: A D-Bus interface name representing base channel type
 * @in_Handle_Type: Used to pass an 'in' argument: An integer representing the handle type, or Handle_Type_None if           no handle is specified
 * @in_Handle: Used to pass an 'in' argument: A nonzero integer handle representing a contact, room, list etc.           according to handle_type, or zero if the handle_type is           Handle_Type_None
 * @in_Suppress_Handler: Used to pass an 'in' argument: &lt;p&gt;Clients SHOULD always set this to true.&lt;/p&gt;            &lt;tp:rationale&gt;             &lt;p&gt;The historical meaning was that clients that did not               intend to take responsibility for displaying the channel to               the user could set this to FALSE, in which case the channel               dispatcher would launch an appropriate channel handler.&lt;/p&gt;              &lt;p&gt;However, clients whose functionality relies on having a               working channel dispatcher should obtain that functionality by               calling methods on the channel dispatcher, so that they will               get an appropriate error if the channel dispatcher is missing               or not working.&lt;/p&gt;              &lt;p&gt;The channel dispatcher itself should set this to true too,               so that it will ignore the               &lt;tp:member-ref&gt;NewChannel&lt;/tp:member-ref&gt; signal that results               from the creation of the channel. It can then dispatch the               channel returned from this method to an               appropriate handler.&lt;/p&gt;              &lt;p&gt;So, there is no sensible use-case for setting this to false,               and setting it to false can result in unhandled channels (in               the case where clients assume that a channel dispatcher is               present, but it isn&apos;t).&lt;/p&gt;           &lt;/tp:rationale&gt;
 * @out_Object_Path: Used to return an 'out' argument if %TRUE is returned: The D-Bus object path for the channel created or retrieved
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method RequestChannel and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Request a channel satisfying the specified type and communicating           with the contact, room, list etc. indicated by the given           handle_type and handle. The handle_type and handle may both be           zero to request the creation of a new, empty channel, which may           or may not be possible, depending on the protocol and channel           type.&lt;/p&gt;          &lt;p&gt;On success, the returned channel will always be of the requested           type (i.e. implement the requested channel-type interface).&lt;/p&gt;          &lt;p&gt;If a new, empty channel is requested, on success the returned           channel will always be an &amp;quot;anonymous&amp;quot; channel for which the type           and handle are both zero.&lt;/p&gt;          &lt;p&gt;If a channel to a contact, room etc. is requested, on success, the           returned channel may either be a new or existing channel to           the requested entity (i.e. its           &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel&quot;&gt;TargetHandleType&lt;/tp:dbus-ref&gt;           and &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel&quot;&gt;TargetHandle&lt;/tp:dbus-ref&gt;           properties are the           requested handle type and handle), or a newly created &amp;quot;anonymous&amp;quot;           channel associated with the requested handle in some           implementation-specific way.&lt;/p&gt;          &lt;p&gt;For example, for a contact handle, the returned channel           might be &amp;quot;anonymous&amp;quot;, but implement the groups interface and have           the requested contact already present among the members.&lt;/p&gt;          &lt;p&gt;If the request cannot be satisfied, an error is raised and no           channel is created.&lt;/p&gt;
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 *
 * Deprecated: Use Requests.CreateChannel or Requests.EnsureChannel instead. Connection managers MAY implement RequestChannel by         raising NotImplemented, or implement fewer types of channel via         this API.
 */


/**
 * tp_cli_connection_callback_for_request_handles:
 * @proxy: the proxy on which the call was made
 * @out_Handles: Used to return an 'out' argument if @error is %NULL: An array of integer handle numbers in the same order as the given identifiers.
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a RequestHandles method call
 * succeeds or fails.
 */

/**
 * tp_cli_connection_call_request_handles:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Handle_Type: Used to pass an 'in' argument: The type of handle required
 * @in_Identifiers: Used to pass an 'in' argument: An array of identifiers of entities to request handles for
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a RequestHandles method call.
 *
 * Request several handles from the connection manager which represent a         number of contacts, rooms or server-stored lists on the service. The         connection manager should record that these handles are in use by the         client who invokes this method, and must not deallocate the handles         until the client disconnects from the bus or calls the         &lt;tp:member-ref&gt;ReleaseHandles&lt;/tp:member-ref&gt;         method. Where the identifier refers to an entity that already has a         handle in this connection manager, this handle should be returned         instead. The handle number 0 must not be returned by the connection         manager.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_connection_run_request_handles:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Handle_Type: Used to pass an 'in' argument: The type of handle required
 * @in_Identifiers: Used to pass an 'in' argument: An array of identifiers of entities to request handles for
 * @out_Handles: Used to return an 'out' argument if %TRUE is returned: An array of integer handle numbers in the same order as the given identifiers.
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method RequestHandles and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Request several handles from the connection manager which represent a         number of contacts, rooms or server-stored lists on the service. The         connection manager should record that these handles are in use by the         client who invokes this method, and must not deallocate the handles         until the client disconnects from the bus or calls the         &lt;tp:member-ref&gt;ReleaseHandles&lt;/tp:member-ref&gt;         method. Where the identifier refers to an entity that already has a         handle in this connection manager, this handle should be returned         instead. The handle number 0 must not be returned by the connection         manager.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_connection_interface_aliasing_signal_callback_aliases_changed:
 * @proxy: The proxy on which tp_cli_connection_interface_aliasing_connect_to_aliases_changed ()
 *  was called
 * @arg_Aliases: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           An array containing structs of:           &lt;ul&gt;             &lt;li&gt;the handle representing the contact&lt;/li&gt;             &lt;li&gt;the new alias&lt;/li&gt;           &lt;/ul&gt;
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal AliasesChanged.
 */

/**
 * tp_cli_connection_interface_aliasing_connect_to_aliases_changed:
 * @proxy: A #TpConnection or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal AliasesChanged.
 *
 * Signal emitted when a contact&apos;s alias (or that of the user) is changed.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_connection_interface_aliasing_callback_for_get_alias_flags:
 * @proxy: the proxy on which the call was made
 * @out_Alias_Flags: Used to return an 'out' argument if @error is %NULL: An integer with a bitwise OR of flags from ConnectionAliasFlags
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetAliasFlags method call
 * succeeds or fails.
 */

/**
 * tp_cli_connection_interface_aliasing_call_get_alias_flags:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetAliasFlags method call.
 *
 * Return a bitwise OR of flags detailing the behaviour of aliases on this         connection.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_connection_interface_aliasing_run_get_alias_flags:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @out_Alias_Flags: Used to return an 'out' argument if %TRUE is returned: An integer with a bitwise OR of flags from ConnectionAliasFlags
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetAliasFlags and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Return a bitwise OR of flags detailing the behaviour of aliases on this         connection.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_connection_interface_aliasing_callback_for_request_aliases:
 * @proxy: the proxy on which the call was made
 * @out_Aliases: Used to return an 'out' argument if @error is %NULL: A list of aliases in the same order as the contact handles
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a RequestAliases method call
 * succeeds or fails.
 */

/**
 * tp_cli_connection_interface_aliasing_call_request_aliases:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Contacts: Used to pass an 'in' argument: An array of handles representing contacts
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a RequestAliases method call.
 *
 * Request the value of several contacts&apos; aliases at once.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_connection_interface_aliasing_run_request_aliases:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Contacts: Used to pass an 'in' argument: An array of handles representing contacts
 * @out_Aliases: Used to return an 'out' argument if %TRUE is returned: A list of aliases in the same order as the contact handles
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method RequestAliases and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Request the value of several contacts&apos; aliases at once.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_connection_interface_aliasing_callback_for_get_aliases:
 * @proxy: the proxy on which the call was made
 * @out_Aliases: Used to return an 'out' argument if @error is %NULL: A dictionary mapping contact handles to aliases
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetAliases method call
 * succeeds or fails.
 */

/**
 * tp_cli_connection_interface_aliasing_call_get_aliases:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Contacts: Used to pass an 'in' argument: An array of handles representing contacts
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetAliases method call.
 *
 * Request the value of several contacts&apos; aliases at once. This SHOULD         only return cached aliases, falling back on the contact identifier         (i.e. the string corresponding to the handle) if none is present. Also         if there was no cached alias, a request SHOULD be started of which the         result is later signalled by         &lt;tp:member-ref&gt;AliasesChanged&lt;/tp:member-ref&gt;.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_connection_interface_aliasing_run_get_aliases:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Contacts: Used to pass an 'in' argument: An array of handles representing contacts
 * @out_Aliases: Used to return an 'out' argument if %TRUE is returned: A dictionary mapping contact handles to aliases
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetAliases and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Request the value of several contacts&apos; aliases at once. This SHOULD         only return cached aliases, falling back on the contact identifier         (i.e. the string corresponding to the handle) if none is present. Also         if there was no cached alias, a request SHOULD be started of which the         result is later signalled by         &lt;tp:member-ref&gt;AliasesChanged&lt;/tp:member-ref&gt;.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_connection_interface_aliasing_callback_for_set_aliases:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a SetAliases method call
 * succeeds or fails.
 */

/**
 * tp_cli_connection_interface_aliasing_call_set_aliases:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Aliases: Used to pass an 'in' argument: A dictionary mapping integer handles of contacts           to strings of the new alias to set.
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a SetAliases method call.
 *
 * Request that the alias of the given contact be changed. Success will be         indicated by emitting an &lt;tp:member-ref&gt;AliasesChanged&lt;/tp:member-ref&gt;         signal. On connections where the CONNECTION_ALIAS_FLAG_USER_SET flag is         not set, this method will only ever succeed if the contact is the         user&apos;s own handle (as returned by &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy&quot;&gt;Connection.GetSelfHandle&lt;/tp:dbus-ref&gt;).
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_connection_interface_aliasing_run_set_aliases:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Aliases: Used to pass an 'in' argument: A dictionary mapping integer handles of contacts           to strings of the new alias to set.
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method SetAliases and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Request that the alias of the given contact be changed. Success will be         indicated by emitting an &lt;tp:member-ref&gt;AliasesChanged&lt;/tp:member-ref&gt;         signal. On connections where the CONNECTION_ALIAS_FLAG_USER_SET flag is         not set, this method will only ever succeed if the contact is the         user&apos;s own handle (as returned by &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy&quot;&gt;Connection.GetSelfHandle&lt;/tp:dbus-ref&gt;).
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_connection_interface_anonymity_signal_callback_anonymity_modes_changed:
 * @proxy: The proxy on which tp_cli_connection_interface_anonymity_connect_to_anonymity_modes_changed ()
 *  was called
 * @arg_Modes: The new anonymity modes for this connection.
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal AnonymityModesChanged.
 */

/**
 * tp_cli_connection_interface_anonymity_connect_to_anonymity_modes_changed:
 * @proxy: A #TpConnection or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal AnonymityModesChanged.
 *
 * Emitted when the anonymity mode has changed.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_connection_interface_avatars_signal_callback_avatar_updated:
 * @proxy: The proxy on which tp_cli_connection_interface_avatars_connect_to_avatar_updated ()
 *  was called
 * @arg_Contact: An integer handle for the contact whose avatar has changed
 * @arg_New_Avatar_Token: Unique token for their new avatar
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal AvatarUpdated.
 */

/**
 * tp_cli_connection_interface_avatars_connect_to_avatar_updated:
 * @proxy: A #TpConnection or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal AvatarUpdated.
 *
 * Emitted when the avatar for a contact has been updated, or first         discovered on this connection. If the token differs from the token         associated with the client&apos;s cached avatar for this contact, the new         avatar should be requested with         &lt;tp:member-ref&gt;RequestAvatars&lt;/tp:member-ref&gt;.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_connection_interface_avatars_signal_callback_avatar_retrieved:
 * @proxy: The proxy on which tp_cli_connection_interface_avatars_connect_to_avatar_retrieved ()
 *  was called
 * @arg_Contact: The contact whose avatar has been retrieved
 * @arg_Token: The token corresponding to the avatar
 * @arg_Avatar: An array of bytes containing the image data
 * @arg_Type: A string containing the image MIME type (eg image/jpeg), or empty if           unknown
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal AvatarRetrieved.
 */

/**
 * tp_cli_connection_interface_avatars_connect_to_avatar_retrieved:
 * @proxy: A #TpConnection or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal AvatarRetrieved.
 *
 * Emitted when the avatar for a contact has been retrieved.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_connection_interface_avatars_callback_for_get_avatar_requirements:
 * @proxy: the proxy on which the call was made
 * @out_MIME_Types: Used to return an 'out' argument if @error is %NULL: An array of supported MIME types (eg image/jpeg)
 * @out_Min_Width: Used to return an 'out' argument if @error is %NULL: The minimum image width in pixels
 * @out_Min_Height: Used to return an 'out' argument if @error is %NULL: The minimum image height in pixels
 * @out_Max_Width: Used to return an 'out' argument if @error is %NULL: The maximum image width in pixels, or 0 if there is no limit
 * @out_Max_Height: Used to return an 'out' argument if @error is %NULL: The maximum image height in pixels, or 0 if there is no limit
 * @out_Max_Bytes: Used to return an 'out' argument if @error is %NULL: The maximum image size in bytes, or 0 if there is no limit
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetAvatarRequirements method call
 * succeeds or fails.
 *
 * Deprecated: Use GetAll to retrieve the         D-Bus properties on this interface, falling back to this method         on failure.
 */

/**
 * tp_cli_connection_interface_avatars_call_get_avatar_requirements:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetAvatarRequirements method call.
 *
 * Get the required format of avatars on this connection.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 *
 * Deprecated: Use GetAll to retrieve the         D-Bus properties on this interface, falling back to this method         on failure.
 */

/**
 * tp_cli_connection_interface_avatars_run_get_avatar_requirements:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @out_MIME_Types: Used to return an 'out' argument if %TRUE is returned: An array of supported MIME types (eg image/jpeg)
 * @out_Min_Width: Used to return an 'out' argument if %TRUE is returned: The minimum image width in pixels
 * @out_Min_Height: Used to return an 'out' argument if %TRUE is returned: The minimum image height in pixels
 * @out_Max_Width: Used to return an 'out' argument if %TRUE is returned: The maximum image width in pixels, or 0 if there is no limit
 * @out_Max_Height: Used to return an 'out' argument if %TRUE is returned: The maximum image height in pixels, or 0 if there is no limit
 * @out_Max_Bytes: Used to return an 'out' argument if %TRUE is returned: The maximum image size in bytes, or 0 if there is no limit
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetAvatarRequirements and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Get the required format of avatars on this connection.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 *
 * Deprecated: Use GetAll to retrieve the         D-Bus properties on this interface, falling back to this method         on failure.
 */


/**
 * tp_cli_connection_interface_avatars_callback_for_get_avatar_tokens:
 * @proxy: the proxy on which the call was made
 * @out_Tokens: Used to return an 'out' argument if @error is %NULL: An array of avatar tokens or empty strings (if no avatar is set) in the           same order as the given array of contact handles
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetAvatarTokens method call
 * succeeds or fails.
 *
 * Deprecated: Use GetKnownAvatarTokens         instead.
 */

/**
 * tp_cli_connection_interface_avatars_call_get_avatar_tokens:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Contacts: Used to pass an 'in' argument: An array of handles representing contacts
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetAvatarTokens method call.
 *
 * Get the unique tokens for all of the given contacts&apos; avatars.          Using this method in new Telepathy clients is deprecated; use         &lt;tp:member-ref&gt;GetKnownAvatarTokens&lt;/tp:member-ref&gt; instead.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 *
 * Deprecated: Use GetKnownAvatarTokens         instead.
 */

/**
 * tp_cli_connection_interface_avatars_run_get_avatar_tokens:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Contacts: Used to pass an 'in' argument: An array of handles representing contacts
 * @out_Tokens: Used to return an 'out' argument if %TRUE is returned: An array of avatar tokens or empty strings (if no avatar is set) in the           same order as the given array of contact handles
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetAvatarTokens and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Get the unique tokens for all of the given contacts&apos; avatars.          Using this method in new Telepathy clients is deprecated; use         &lt;tp:member-ref&gt;GetKnownAvatarTokens&lt;/tp:member-ref&gt; instead.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 *
 * Deprecated: Use GetKnownAvatarTokens         instead.
 */


/**
 * tp_cli_connection_interface_avatars_callback_for_get_known_avatar_tokens:
 * @proxy: the proxy on which the call was made
 * @out_Tokens: Used to return an 'out' argument if @error is %NULL: A dictionary of handles mapped to avatar tokens, containing only           the known avatar tokens.
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetKnownAvatarTokens method call
 * succeeds or fails.
 */

/**
 * tp_cli_connection_interface_avatars_call_get_known_avatar_tokens:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Contacts: Used to pass an 'in' argument: An array of handles representing contacts
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetKnownAvatarTokens method call.
 *
 * Get the unique tokens for the given contacts&apos; avatars. These tokens         can be persisted across connections, and should be used by the client         to check whether the avatars have been updated.  For handles other than         the self handle, only tokens that are already known are returned; an         empty token means the given contact has no avatar.  However, a CM must         always have the tokens for the self handle if one is set (even if it is         set to no avatar).  On protocols where the avatar does not persist         between connections, a CM should omit the self handle from the returned         map until an avatar is explicitly set or cleared.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_connection_interface_avatars_run_get_known_avatar_tokens:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Contacts: Used to pass an 'in' argument: An array of handles representing contacts
 * @out_Tokens: Used to return an 'out' argument if %TRUE is returned: A dictionary of handles mapped to avatar tokens, containing only           the known avatar tokens.
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetKnownAvatarTokens and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Get the unique tokens for the given contacts&apos; avatars. These tokens         can be persisted across connections, and should be used by the client         to check whether the avatars have been updated.  For handles other than         the self handle, only tokens that are already known are returned; an         empty token means the given contact has no avatar.  However, a CM must         always have the tokens for the self handle if one is set (even if it is         set to no avatar).  On protocols where the avatar does not persist         between connections, a CM should omit the self handle from the returned         map until an avatar is explicitly set or cleared.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_connection_interface_avatars_callback_for_request_avatar:
 * @proxy: the proxy on which the call was made
 * @out_Data: Used to return an 'out' argument if @error is %NULL: An array of bytes containing the image data
 * @out_MIME_Type: Used to return an 'out' argument if @error is %NULL: A string containing the image MIME type (eg image/jpeg), or empty if         unknown
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a RequestAvatar method call
 * succeeds or fails.
 *
 * Deprecated: Use RequestAvatars         instead.
 */

/**
 * tp_cli_connection_interface_avatars_call_request_avatar:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Contact: Used to pass an 'in' argument: An integer handle for the contact to request the avatar for
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a RequestAvatar method call.
 *
 * Request the avatar for a given contact. Using this method in new         Telepathy clients is deprecated; use RequestAvatars instead.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 *
 * Deprecated: Use RequestAvatars         instead.
 */

/**
 * tp_cli_connection_interface_avatars_run_request_avatar:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Contact: Used to pass an 'in' argument: An integer handle for the contact to request the avatar for
 * @out_Data: Used to return an 'out' argument if %TRUE is returned: An array of bytes containing the image data
 * @out_MIME_Type: Used to return an 'out' argument if %TRUE is returned: A string containing the image MIME type (eg image/jpeg), or empty if         unknown
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method RequestAvatar and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Request the avatar for a given contact. Using this method in new         Telepathy clients is deprecated; use RequestAvatars instead.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 *
 * Deprecated: Use RequestAvatars         instead.
 */


/**
 * tp_cli_connection_interface_avatars_callback_for_request_avatars:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a RequestAvatars method call
 * succeeds or fails.
 */

/**
 * tp_cli_connection_interface_avatars_call_request_avatars:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Contacts: Used to pass an 'in' argument: The contacts to retrieve avatars for
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a RequestAvatars method call.
 *
 * Request avatars for a number of contacts. The         &lt;tp:member-ref&gt;AvatarRetrieved&lt;/tp:member-ref&gt; signal is emitted for         each avatar retrieved. If the handles are valid but retrieving an         avatar fails (for any reason, including the contact not having an         avatar) the AvatarRetrieved signal is not emitted for that contact.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_connection_interface_avatars_run_request_avatars:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Contacts: Used to pass an 'in' argument: The contacts to retrieve avatars for
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method RequestAvatars and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Request avatars for a number of contacts. The         &lt;tp:member-ref&gt;AvatarRetrieved&lt;/tp:member-ref&gt; signal is emitted for         each avatar retrieved. If the handles are valid but retrieving an         avatar fails (for any reason, including the contact not having an         avatar) the AvatarRetrieved signal is not emitted for that contact.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_connection_interface_avatars_callback_for_set_avatar:
 * @proxy: the proxy on which the call was made
 * @out_Token: Used to return an 'out' argument if @error is %NULL: The string token of the new avatar
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a SetAvatar method call
 * succeeds or fails.
 */

/**
 * tp_cli_connection_interface_avatars_call_set_avatar:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Avatar: Used to pass an 'in' argument: An array of bytes representing the avatar image data
 * @in_MIME_Type: Used to pass an 'in' argument: A string representing the image MIME type
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a SetAvatar method call.
 *
 * Set a new avatar image for this connection. The avatar image must         respect the requirements obtained by         &lt;tp:member-ref&gt;GetAvatarRequirements&lt;/tp:member-ref&gt;.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_connection_interface_avatars_run_set_avatar:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Avatar: Used to pass an 'in' argument: An array of bytes representing the avatar image data
 * @in_MIME_Type: Used to pass an 'in' argument: A string representing the image MIME type
 * @out_Token: Used to return an 'out' argument if %TRUE is returned: The string token of the new avatar
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method SetAvatar and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Set a new avatar image for this connection. The avatar image must         respect the requirements obtained by         &lt;tp:member-ref&gt;GetAvatarRequirements&lt;/tp:member-ref&gt;.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_connection_interface_avatars_callback_for_clear_avatar:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a ClearAvatar method call
 * succeeds or fails.
 */

/**
 * tp_cli_connection_interface_avatars_call_clear_avatar:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a ClearAvatar method call.
 *
 * Remove the avatar image for this connection.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_connection_interface_avatars_run_clear_avatar:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method ClearAvatar and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Remove the avatar image for this connection.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_connection_interface_balance_signal_callback_balance_changed:
 * @proxy: The proxy on which tp_cli_connection_interface_balance_connect_to_balance_changed ()
 *  was called
 * @arg_Balance: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;The new value of the &lt;tp:member-ref&gt;AccountBalance&lt;/tp:member-ref&gt;             property.&lt;/p&gt;
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal BalanceChanged.
 */

/**
 * tp_cli_connection_interface_balance_connect_to_balance_changed:
 * @proxy: A #TpConnection or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal BalanceChanged.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Emitted when the user&apos;s balance has changed.&lt;/p&gt;
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_connection_interface_capabilities_signal_callback_capabilities_changed:
 * @proxy: The proxy on which tp_cli_connection_interface_capabilities_connect_to_capabilities_changed ()
 *  was called
 * @arg_Caps: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           An array of structures containing:           &lt;ul&gt;             &lt;li&gt;an integer handle representing the contact&lt;/li&gt;             &lt;li&gt;a string channel type&lt;/li&gt;             &lt;li&gt;a bitwise OR of the contact&apos;s old generic capability flags&lt;/li&gt;             &lt;li&gt;a bitwise OR of the contact&apos;s new generic capability flags&lt;/li&gt;             &lt;li&gt;a bitwise OR of the contact&apos;s old type specific capability flags&lt;/li&gt;             &lt;li&gt;a bitwise OR of the contact&apos;s new type specific capability flags&lt;/li&gt;           &lt;/ul&gt;
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal CapabilitiesChanged.
 */

/**
 * tp_cli_connection_interface_capabilities_connect_to_capabilities_changed:
 * @proxy: A #TpConnection or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal CapabilitiesChanged.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Announce that there has been a change of capabilities on the           given handle.&lt;/p&gt;          &lt;p&gt;If the handle is zero, the capabilities refer to the connection           itself, in some poorly defined way. This usage is deprecated and           clients should ignore it.&lt;/p&gt;
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_connection_interface_capabilities_callback_for_advertise_capabilities:
 * @proxy: the proxy on which the call was made
 * @out_Self_Capabilities: Used to return an 'out' argument if @error is %NULL: An array of structures describing the current capabilities containing:           &lt;ul&gt;             &lt;li&gt;a string channel type&lt;/li&gt;             &lt;li&gt;a bitwise OR of type specific capability flags&lt;/li&gt;           &lt;/ul&gt;
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a AdvertiseCapabilities method call
 * succeeds or fails.
 */

/**
 * tp_cli_connection_interface_capabilities_call_advertise_capabilities:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Add: Used to pass an 'in' argument: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           An array of structures containing:           &lt;ul&gt;             &lt;li&gt;a string channel type&lt;/li&gt;             &lt;li&gt;a bitwise OR of type specific capability flags&lt;/li&gt;           &lt;/ul&gt;
 * @in_Remove: Used to pass an 'in' argument: An array of D-Bus interface names of channel types to remove
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a AdvertiseCapabilities method call.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Used by user interfaces to indicate which channel types they are able         to handle on this connection. Because these may be provided by         different client processes, this method accepts channel types to add         and remove from the set already advertised on this connection. The type         of advertised capabilities (create versus invite) is protocol-dependent         and hence cannot be set by the this method. In the case of a client         adding an already advertised channel type but with new channel type         specific flags, the connection manager should simply add the new flags         to the set of advertised capabilities.&lt;/p&gt;          &lt;p&gt;Upon a successful invocation of this method, the         &lt;tp:member-ref&gt;CapabilitiesChanged&lt;/tp:member-ref&gt;         signal will be emitted for the user&apos;s own handle ( &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy&quot;&gt;Connection.GetSelfHandle&lt;/tp:dbus-ref&gt;)         by the connection manager to indicate the changes         that have been made.  This signal should also be monitored to ensure         that the set is kept accurate - for example, a client may remove         capabilities or type specific capability flags when it exits         which are still provided by another client.&lt;/p&gt;          &lt;p&gt;On connections managed by the &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy&quot;&gt;ChannelDispatcher&lt;/tp:dbus-ref&gt;,           this method SHOULD NOT be used by clients other than the           ChannelDispatcher itself.&lt;/p&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_connection_interface_capabilities_run_advertise_capabilities:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Add: Used to pass an 'in' argument: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           An array of structures containing:           &lt;ul&gt;             &lt;li&gt;a string channel type&lt;/li&gt;             &lt;li&gt;a bitwise OR of type specific capability flags&lt;/li&gt;           &lt;/ul&gt;
 * @in_Remove: Used to pass an 'in' argument: An array of D-Bus interface names of channel types to remove
 * @out_Self_Capabilities: Used to return an 'out' argument if %TRUE is returned: An array of structures describing the current capabilities containing:           &lt;ul&gt;             &lt;li&gt;a string channel type&lt;/li&gt;             &lt;li&gt;a bitwise OR of type specific capability flags&lt;/li&gt;           &lt;/ul&gt;
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method AdvertiseCapabilities and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Used by user interfaces to indicate which channel types they are able         to handle on this connection. Because these may be provided by         different client processes, this method accepts channel types to add         and remove from the set already advertised on this connection. The type         of advertised capabilities (create versus invite) is protocol-dependent         and hence cannot be set by the this method. In the case of a client         adding an already advertised channel type but with new channel type         specific flags, the connection manager should simply add the new flags         to the set of advertised capabilities.&lt;/p&gt;          &lt;p&gt;Upon a successful invocation of this method, the         &lt;tp:member-ref&gt;CapabilitiesChanged&lt;/tp:member-ref&gt;         signal will be emitted for the user&apos;s own handle ( &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy&quot;&gt;Connection.GetSelfHandle&lt;/tp:dbus-ref&gt;)         by the connection manager to indicate the changes         that have been made.  This signal should also be monitored to ensure         that the set is kept accurate - for example, a client may remove         capabilities or type specific capability flags when it exits         which are still provided by another client.&lt;/p&gt;          &lt;p&gt;On connections managed by the &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy&quot;&gt;ChannelDispatcher&lt;/tp:dbus-ref&gt;,           this method SHOULD NOT be used by clients other than the           ChannelDispatcher itself.&lt;/p&gt;
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_connection_interface_capabilities_callback_for_get_capabilities:
 * @proxy: the proxy on which the call was made
 * @out_Contact_Capabilities: Used to return an 'out' argument if @error is %NULL: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           An array of structures containing:           &lt;ul&gt;             &lt;li&gt;an integer handle representing the contact&lt;/li&gt;             &lt;li&gt;a string channel type&lt;/li&gt;             &lt;li&gt;a bitwise OR of generic capability flags for the type&lt;/li&gt;             &lt;li&gt;a bitwise OR of type specific capability flags for the type&lt;/li&gt;           &lt;/ul&gt;
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetCapabilities method call
 * succeeds or fails.
 */

/**
 * tp_cli_connection_interface_capabilities_call_get_capabilities:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Handles: Used to pass an 'in' argument: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;An array of contact handles for this connection.&lt;/p&gt;            &lt;p&gt;This may include zero, which originally meant a query for             capabilities available on the connection itself. This usage             is deprecated; clients SHOULD NOT do this, and connection managers             SHOULD proceed as though zero had not been present in this             list.&lt;/p&gt;
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetCapabilities method call.
 *
 * Returns an array of capabilities for the given contact handles.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_connection_interface_capabilities_run_get_capabilities:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Handles: Used to pass an 'in' argument: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;An array of contact handles for this connection.&lt;/p&gt;            &lt;p&gt;This may include zero, which originally meant a query for             capabilities available on the connection itself. This usage             is deprecated; clients SHOULD NOT do this, and connection managers             SHOULD proceed as though zero had not been present in this             list.&lt;/p&gt;
 * @out_Contact_Capabilities: Used to return an 'out' argument if %TRUE is returned: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           An array of structures containing:           &lt;ul&gt;             &lt;li&gt;an integer handle representing the contact&lt;/li&gt;             &lt;li&gt;a string channel type&lt;/li&gt;             &lt;li&gt;a bitwise OR of generic capability flags for the type&lt;/li&gt;             &lt;li&gt;a bitwise OR of type specific capability flags for the type&lt;/li&gt;           &lt;/ul&gt;
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetCapabilities and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Returns an array of capabilities for the given contact handles.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_connection_interface_cellular_signal_callback_imsi_changed:
 * @proxy: The proxy on which tp_cli_connection_interface_cellular_connect_to_imsi_changed ()
 *  was called
 * @arg_IMSI: The new IMSI value.  This may be an empty string in the case where           the IMSI is being reset or removed.
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal IMSIChanged.
 */

/**
 * tp_cli_connection_interface_cellular_connect_to_imsi_changed:
 * @proxy: A #TpConnection or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal IMSIChanged.
 *
 * Emitted when the IMSI for the connection changes.  This sort of thing         is rare, but could happen on cellular phones that allow hot-swapping         of SIM cards.  In the case of SIM swapping, this signal would be         emitted twice; the first time while the SIM is being ejected (with an         empty string), and the second time after a new SIM has been inserted         (assuming that the IMSI can be determined from the new SIM).
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_connection_interface_contact_capabilities_signal_callback_contact_capabilities_changed:
 * @proxy: The proxy on which tp_cli_connection_interface_contact_capabilities_connect_to_contact_capabilities_changed ()
 *  was called
 * @arg_caps: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           All the capabilities of the contacts
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal ContactCapabilitiesChanged.
 */

/**
 * tp_cli_connection_interface_contact_capabilities_connect_to_contact_capabilities_changed:
 * @proxy: A #TpConnection or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal ContactCapabilitiesChanged.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Announce that there has been a change of capabilities on the           given handles. A single signal can be emitted for several         contacts.&lt;/p&gt;          &lt;tp:rationale&gt;           &lt;p&gt;The underlying protocol can get several contacts&apos; capabilities at             the same time.&lt;/p&gt;         &lt;/tp:rationale&gt;
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_connection_interface_contact_capabilities_callback_for_update_capabilities:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a UpdateCapabilities method call
 * succeeds or fails.
 */

/**
 * tp_cli_connection_interface_contact_capabilities_call_update_capabilities:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Handler_Capabilities: Used to pass an 'in' argument: &lt;p&gt;The capabilities of one or more clients.&lt;/p&gt;            &lt;p&gt;For each client in the given list, any capabilities previously             advertised for the same client name are discarded, then replaced by             the capabilities indicated.&lt;/p&gt;            &lt;p&gt;As a result, if a client becomes unavailable, this method SHOULD             be called with a &lt;tp:type&gt;Handler_Capabilities&lt;/tp:type&gt; structure             containing its name, an empty list of channel classes, and an             empty list of capabilities. When this is done, the connection             manager SHOULD free all memory associated with that client name.&lt;/p&gt;            &lt;tp:rationale&gt;             &lt;p&gt;This method takes a list of clients so that               when the channel dispatcher first calls it (with a list of all               the Handlers that are initially available), the changes can be               made atomically, with only one transmission of updated               capabilities to the network. Afterwards, the channel dispatcher               will call this method with a single-element list every time               a Handler becomes available or unavailable.&lt;/p&gt;           &lt;/tp:rationale&gt;            &lt;p&gt;The connection manager MUST ignore any channel classes and client             capabilities for which there is no representation in the protocol             or no support in the connection manager.&lt;/p&gt;
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a UpdateCapabilities method call.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Alter the connection&apos;s advertised capabilities to include           the intersection of the given clients&apos; capabilities with what the           connection manager is able to implement.&lt;/p&gt;          &lt;p&gt;On connections managed by the ChannelDispatcher, processes other           than the ChannelDispatcher SHOULD NOT call this method, and the           ChannelDispatcher SHOULD use this method to advertise the           capabilities of all the registered &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy&quot;&gt;Client.Handler&lt;/tp:dbus-ref&gt;           implementations.On connections not managed by the ChannelDispatcher,           clients MAY use this method directly, to indicate the channels they           will handle and the extra capabilities they have.&lt;/p&gt;          &lt;p&gt;Upon a successful invocation of this method, the connection manager           will only emit the           &lt;tp:member-ref&gt;ContactCapabilitiesChanged&lt;/tp:member-ref&gt; signal           for the user&apos;s &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Connection&quot;&gt;SelfHandle&lt;/tp:dbus-ref&gt;           if, in the underlying protocol, the new capabilities are distinct           from the previous state.&lt;/p&gt;          &lt;tp:rationale&gt;           &lt;p&gt;The connection manager will essentially intersect the provided             capabilities and the channel classes it implements. Therefore,             certain properties which are never fixed for a channel class             (such as the target handle, or the Parameters property of a tube             channel) will almost certainly not be advertised.&lt;/p&gt;         &lt;/tp:rationale&gt;          &lt;p&gt;This method MAY be called on a newly-created connection while it           is still in the DISCONNECTED state, to request that when the           connection connects, it will do so with the appropriate           capabilities. Doing so MUST NOT fail.&lt;/p&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_connection_interface_contact_capabilities_run_update_capabilities:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Handler_Capabilities: Used to pass an 'in' argument: &lt;p&gt;The capabilities of one or more clients.&lt;/p&gt;            &lt;p&gt;For each client in the given list, any capabilities previously             advertised for the same client name are discarded, then replaced by             the capabilities indicated.&lt;/p&gt;            &lt;p&gt;As a result, if a client becomes unavailable, this method SHOULD             be called with a &lt;tp:type&gt;Handler_Capabilities&lt;/tp:type&gt; structure             containing its name, an empty list of channel classes, and an             empty list of capabilities. When this is done, the connection             manager SHOULD free all memory associated with that client name.&lt;/p&gt;            &lt;tp:rationale&gt;             &lt;p&gt;This method takes a list of clients so that               when the channel dispatcher first calls it (with a list of all               the Handlers that are initially available), the changes can be               made atomically, with only one transmission of updated               capabilities to the network. Afterwards, the channel dispatcher               will call this method with a single-element list every time               a Handler becomes available or unavailable.&lt;/p&gt;           &lt;/tp:rationale&gt;            &lt;p&gt;The connection manager MUST ignore any channel classes and client             capabilities for which there is no representation in the protocol             or no support in the connection manager.&lt;/p&gt;
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method UpdateCapabilities and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Alter the connection&apos;s advertised capabilities to include           the intersection of the given clients&apos; capabilities with what the           connection manager is able to implement.&lt;/p&gt;          &lt;p&gt;On connections managed by the ChannelDispatcher, processes other           than the ChannelDispatcher SHOULD NOT call this method, and the           ChannelDispatcher SHOULD use this method to advertise the           capabilities of all the registered &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy&quot;&gt;Client.Handler&lt;/tp:dbus-ref&gt;           implementations.On connections not managed by the ChannelDispatcher,           clients MAY use this method directly, to indicate the channels they           will handle and the extra capabilities they have.&lt;/p&gt;          &lt;p&gt;Upon a successful invocation of this method, the connection manager           will only emit the           &lt;tp:member-ref&gt;ContactCapabilitiesChanged&lt;/tp:member-ref&gt; signal           for the user&apos;s &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Connection&quot;&gt;SelfHandle&lt;/tp:dbus-ref&gt;           if, in the underlying protocol, the new capabilities are distinct           from the previous state.&lt;/p&gt;          &lt;tp:rationale&gt;           &lt;p&gt;The connection manager will essentially intersect the provided             capabilities and the channel classes it implements. Therefore,             certain properties which are never fixed for a channel class             (such as the target handle, or the Parameters property of a tube             channel) will almost certainly not be advertised.&lt;/p&gt;         &lt;/tp:rationale&gt;          &lt;p&gt;This method MAY be called on a newly-created connection while it           is still in the DISCONNECTED state, to request that when the           connection connects, it will do so with the appropriate           capabilities. Doing so MUST NOT fail.&lt;/p&gt;
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_connection_interface_contact_capabilities_callback_for_get_contact_capabilities:
 * @proxy: the proxy on which the call was made
 * @out_Contact_Capabilities: Used to return an 'out' argument if @error is %NULL: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;A map from contact handles to lists of requestable channel             classes, representing the channel requests that are expected             to succeed for that contact.&lt;/p&gt;            &lt;p&gt;Contacts listed among Handles whose capabilities are unknown             SHOULD be omitted from this map; contacts known to have an empty             set of capabilities SHOULD be included in the keys of this map,             with an empty array as the corresponding value.&lt;/p&gt;
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetContactCapabilities method call
 * succeeds or fails.
 */

/**
 * tp_cli_connection_interface_contact_capabilities_call_get_contact_capabilities:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Handles: Used to pass an 'in' argument: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;An array of contact handles for this connection.&lt;/p&gt;            &lt;p&gt;The handle zero MUST NOT be included in the request.&lt;/p&gt;
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetContactCapabilities method call.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Returns an array of requestable channel classes for the given           contact handles, representing the channel requests that are           expected to succeed.&lt;/p&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_connection_interface_contact_capabilities_run_get_contact_capabilities:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Handles: Used to pass an 'in' argument: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;An array of contact handles for this connection.&lt;/p&gt;            &lt;p&gt;The handle zero MUST NOT be included in the request.&lt;/p&gt;
 * @out_Contact_Capabilities: Used to return an 'out' argument if %TRUE is returned: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;A map from contact handles to lists of requestable channel             classes, representing the channel requests that are expected             to succeed for that contact.&lt;/p&gt;            &lt;p&gt;Contacts listed among Handles whose capabilities are unknown             SHOULD be omitted from this map; contacts known to have an empty             set of capabilities SHOULD be included in the keys of this map,             with an empty array as the corresponding value.&lt;/p&gt;
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetContactCapabilities and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Returns an array of requestable channel classes for the given           contact handles, representing the channel requests that are           expected to succeed.&lt;/p&gt;
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_connection_interface_contact_info_signal_callback_contact_info_changed:
 * @proxy: The proxy on which tp_cli_connection_interface_contact_info_connect_to_contact_info_changed ()
 *  was called
 * @arg_Contact: An integer handle for the contact whose info has changed.
 * @arg_ContactInfo: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           An array of fields representing information about this contact.
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal ContactInfoChanged.
 */

/**
 * tp_cli_connection_interface_contact_info_connect_to_contact_info_changed:
 * @proxy: A #TpConnection or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal ContactInfoChanged.
 *
 * Emitted when a contact&apos;s information has changed or been received for         the first time on this connection.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_connection_interface_contact_info_callback_for_get_contact_info:
 * @proxy: the proxy on which the call was made
 * @out_ContactInfo: Used to return an 'out' argument if @error is %NULL: A dictionary mapping contact handles to information, whose keys are           the subset of the requested list of handles for which information was           cached.
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetContactInfo method call
 * succeeds or fails.
 */

/**
 * tp_cli_connection_interface_contact_info_call_get_contact_info:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Contacts: Used to pass an 'in' argument: An array of handles representing contacts.
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetContactInfo method call.
 *
 * Request information on several contacts at once.  This SHOULD only         return cached information, omitting handles for which no information is         cached from the returned map.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_connection_interface_contact_info_run_get_contact_info:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Contacts: Used to pass an 'in' argument: An array of handles representing contacts.
 * @out_ContactInfo: Used to return an 'out' argument if %TRUE is returned: A dictionary mapping contact handles to information, whose keys are           the subset of the requested list of handles for which information was           cached.
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetContactInfo and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Request information on several contacts at once.  This SHOULD only         return cached information, omitting handles for which no information is         cached from the returned map.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_connection_interface_contact_info_callback_for_refresh_contact_info:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a RefreshContactInfo method call
 * succeeds or fails.
 */

/**
 * tp_cli_connection_interface_contact_info_call_refresh_contact_info:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Contacts: Used to pass an 'in' argument: Integer handles for contacts.
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a RefreshContactInfo method call.
 *
 * Retrieve information for the given contact, requesting it from the         network if an up-to-date version is not cached locally. This method         SHOULD return immediately, emitting         &lt;tp:member-ref&gt;ContactInfoChanged&lt;/tp:member-ref&gt; when the contacts&apos;         updated contact information is returned.          &lt;tp:rationale&gt;           This method allows a client with cached contact information to           update its cache after a number of days.         &lt;/tp:rationale&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_connection_interface_contact_info_run_refresh_contact_info:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Contacts: Used to pass an 'in' argument: Integer handles for contacts.
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method RefreshContactInfo and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Retrieve information for the given contact, requesting it from the         network if an up-to-date version is not cached locally. This method         SHOULD return immediately, emitting         &lt;tp:member-ref&gt;ContactInfoChanged&lt;/tp:member-ref&gt; when the contacts&apos;         updated contact information is returned.          &lt;tp:rationale&gt;           This method allows a client with cached contact information to           update its cache after a number of days.         &lt;/tp:rationale&gt;
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_connection_interface_contact_info_callback_for_request_contact_info:
 * @proxy: the proxy on which the call was made
 * @out_Contact_Info: Used to return an 'out' argument if @error is %NULL: Information about that contact.
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a RequestContactInfo method call
 * succeeds or fails.
 */

/**
 * tp_cli_connection_interface_contact_info_call_request_contact_info:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Contact: Used to pass an 'in' argument: An integer handle for a contact.
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a RequestContactInfo method call.
 *
 * Retrieve information for a contact, requesting it from the network if         it is not cached locally.          &lt;tp:rationale&gt;           This method is appropriate for an explicit user request to show           a contact&apos;s information; it allows a UI to wait for the contact           info to be returned.         &lt;/tp:rationale&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_connection_interface_contact_info_run_request_contact_info:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Contact: Used to pass an 'in' argument: An integer handle for a contact.
 * @out_Contact_Info: Used to return an 'out' argument if %TRUE is returned: Information about that contact.
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method RequestContactInfo and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Retrieve information for a contact, requesting it from the network if         it is not cached locally.          &lt;tp:rationale&gt;           This method is appropriate for an explicit user request to show           a contact&apos;s information; it allows a UI to wait for the contact           info to be returned.         &lt;/tp:rationale&gt;
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_connection_interface_contact_info_callback_for_set_contact_info:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a SetContactInfo method call
 * succeeds or fails.
 */

/**
 * tp_cli_connection_interface_contact_info_call_set_contact_info:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_ContactInfo: Used to pass an 'in' argument: The new information to be set.
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a SetContactInfo method call.
 *
 * Set new contact information for this connection, replacing existing         information.  This method is only suppported if         &lt;tp:member-ref&gt;ContactInfoFlags&lt;/tp:member-ref&gt; contains         &lt;code&gt;Can_Set&lt;/code&gt;, and may only be passed fields conforming to         &lt;tp:member-ref&gt;SupportedFields&lt;/tp:member-ref&gt;.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_connection_interface_contact_info_run_set_contact_info:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_ContactInfo: Used to pass an 'in' argument: The new information to be set.
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method SetContactInfo and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Set new contact information for this connection, replacing existing         information.  This method is only suppported if         &lt;tp:member-ref&gt;ContactInfoFlags&lt;/tp:member-ref&gt; contains         &lt;code&gt;Can_Set&lt;/code&gt;, and may only be passed fields conforming to         &lt;tp:member-ref&gt;SupportedFields&lt;/tp:member-ref&gt;.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_connection_interface_contacts_callback_for_get_contact_attributes:
 * @proxy: the proxy on which the call was made
 * @out_Attributes: Used to return an 'out' argument if @error is %NULL: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;A dictionary mapping the contact handles to contact attributes.             If any of the requested handles are in fact invalid, they are             simply omitted from this mapping. If contact attributes are not             immediately known, the behaviour is defined by the interface;             the attribute should either be omitted from the result or             replaced with a default value.&lt;/p&gt;            &lt;p&gt;Each contact&apos;s attributes will always include at least the             identifier that would be obtained by inspecting the handle             (&lt;code&gt;org.freedesktop.Telepathy.Connection/contact-id&lt;/code&gt;).&lt;/p&gt;
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetContactAttributes method call
 * succeeds or fails.
 */

/**
 * tp_cli_connection_interface_contacts_call_get_contact_attributes:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Handles: Used to pass an 'in' argument: An array of handles representing contacts.
 * @in_Interfaces: Used to pass an 'in' argument: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;A list of strings indicating which D-Bus interfaces the calling             process is interested in. All supported attributes from these             interfaces, whose values can be obtained without additional network             activity, will be in the reply.&lt;/p&gt;            &lt;p&gt;Connection managers SHOULD ignore interfaces requested which they             do not support (i.e. those not mentioned in the             &lt;tp:member-ref&gt;ContactAttributeInterfaces&lt;/tp:member-ref&gt;             property.)&lt;/p&gt;            &lt;tp:rationale&gt;             &lt;p&gt;This simplifies client-side code. Clients which care may               distinguish between unsupported interfaces (e.g. this Connection               does not support Avatars), and interfaces on which no information               is known for these contacts (e.g. we don&apos;t know the avatar tokens               of any of the contacts, so we omitted them all) by inspecting               &lt;tp:member-ref&gt;ContactAttributeInterfaces&lt;/tp:member-ref&gt;.&lt;/p&gt;           &lt;/tp:rationale&gt;            &lt;p&gt;Attributes from the interface             &lt;tp:dbus-ref&gt;org.freedesktop.Telepathy.Connection&lt;/tp:dbus-ref&gt;             are always returned, and need not be requested explicitly.&lt;/p&gt;            &lt;p&gt;As well as returning cached information immediately, the             connection MAY start asynchronous requests to obtain better             values for the contact attributes. If better values are later             obtained by this process, they will be indicated with the usual             signals (such as &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Connection.Interface.Aliasing&quot;&gt;AliasesChanged&lt;/tp:dbus-ref&gt;).&lt;/p&gt;            &lt;tp:rationale&gt;             For instance, an XMPP connection manager could download vCards             in response to a request for &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Connection.Interface&quot;&gt;Aliasing&lt;/tp:dbus-ref&gt;             attributes.           &lt;/tp:rationale&gt;
 * @in_Hold: Used to pass an 'in' argument: If true, all handles in the result have been held on behalf of the           calling process, as if by a call to           &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy&quot;&gt;Connection.HoldHandles&lt;/tp:dbus-ref&gt;.            &lt;tp:rationale&gt;             For further round-trip avoidance.           &lt;/tp:rationale&gt;
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetContactAttributes method call.
 *
 * Return any number of contact attributes for the given handles.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_connection_interface_contacts_run_get_contact_attributes:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Handles: Used to pass an 'in' argument: An array of handles representing contacts.
 * @in_Interfaces: Used to pass an 'in' argument: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;A list of strings indicating which D-Bus interfaces the calling             process is interested in. All supported attributes from these             interfaces, whose values can be obtained without additional network             activity, will be in the reply.&lt;/p&gt;            &lt;p&gt;Connection managers SHOULD ignore interfaces requested which they             do not support (i.e. those not mentioned in the             &lt;tp:member-ref&gt;ContactAttributeInterfaces&lt;/tp:member-ref&gt;             property.)&lt;/p&gt;            &lt;tp:rationale&gt;             &lt;p&gt;This simplifies client-side code. Clients which care may               distinguish between unsupported interfaces (e.g. this Connection               does not support Avatars), and interfaces on which no information               is known for these contacts (e.g. we don&apos;t know the avatar tokens               of any of the contacts, so we omitted them all) by inspecting               &lt;tp:member-ref&gt;ContactAttributeInterfaces&lt;/tp:member-ref&gt;.&lt;/p&gt;           &lt;/tp:rationale&gt;            &lt;p&gt;Attributes from the interface             &lt;tp:dbus-ref&gt;org.freedesktop.Telepathy.Connection&lt;/tp:dbus-ref&gt;             are always returned, and need not be requested explicitly.&lt;/p&gt;            &lt;p&gt;As well as returning cached information immediately, the             connection MAY start asynchronous requests to obtain better             values for the contact attributes. If better values are later             obtained by this process, they will be indicated with the usual             signals (such as &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Connection.Interface.Aliasing&quot;&gt;AliasesChanged&lt;/tp:dbus-ref&gt;).&lt;/p&gt;            &lt;tp:rationale&gt;             For instance, an XMPP connection manager could download vCards             in response to a request for &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Connection.Interface&quot;&gt;Aliasing&lt;/tp:dbus-ref&gt;             attributes.           &lt;/tp:rationale&gt;
 * @in_Hold: Used to pass an 'in' argument: If true, all handles in the result have been held on behalf of the           calling process, as if by a call to           &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy&quot;&gt;Connection.HoldHandles&lt;/tp:dbus-ref&gt;.            &lt;tp:rationale&gt;             For further round-trip avoidance.           &lt;/tp:rationale&gt;
 * @out_Attributes: Used to return an 'out' argument if %TRUE is returned: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;A dictionary mapping the contact handles to contact attributes.             If any of the requested handles are in fact invalid, they are             simply omitted from this mapping. If contact attributes are not             immediately known, the behaviour is defined by the interface;             the attribute should either be omitted from the result or             replaced with a default value.&lt;/p&gt;            &lt;p&gt;Each contact&apos;s attributes will always include at least the             identifier that would be obtained by inspecting the handle             (&lt;code&gt;org.freedesktop.Telepathy.Connection/contact-id&lt;/code&gt;).&lt;/p&gt;
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetContactAttributes and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Return any number of contact attributes for the given handles.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_connection_interface_location_signal_callback_location_updated:
 * @proxy: The proxy on which tp_cli_connection_interface_location_connect_to_location_updated ()
 *  was called
 * @arg_Contact: The contact
 * @arg_Location: The contact&apos;s location, or empty to indicate that nothing is known           about the contact&apos;s location.
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal LocationUpdated.
 */

/**
 * tp_cli_connection_interface_location_connect_to_location_updated:
 * @proxy: A #TpConnection or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal LocationUpdated.
 *
 * Emitted when a contact&apos;s location changes or becomes known.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_connection_interface_location_callback_for_get_locations:
 * @proxy: the proxy on which the call was made
 * @out_Locations: Used to return an 'out' argument if @error is %NULL: The contacts&apos; locations, if already known. Contacts whose locations           are not already known are omitted from the mapping; contacts known           to have no location information appear in the mapping with an empty           Location dictionary.
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetLocations method call
 * succeeds or fails.
 */

/**
 * tp_cli_connection_interface_location_call_get_locations:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Contacts: Used to pass an 'in' argument: The contacts whose locations should be returned or signalled.
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetLocations method call.
 *
 * Return the current locations of the given contacts, if they are         already known. If any of the given contacts&apos; locations are not known,         request their current locations, but return immediately without waiting         for a reply; if a reply with a non-empty location is later received         for those contacts, the &lt;tp:member-ref&gt;LocationUpdated&lt;/tp:member-ref&gt;         signal will be emitted for them.          &lt;tp:rationale&gt;           This method is appropriate for &amp;quot;lazy&amp;quot; location finding, for instance           displaying the location (if available) of everyone in your contact           list.         &lt;/tp:rationale&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_connection_interface_location_run_get_locations:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Contacts: Used to pass an 'in' argument: The contacts whose locations should be returned or signalled.
 * @out_Locations: Used to return an 'out' argument if %TRUE is returned: The contacts&apos; locations, if already known. Contacts whose locations           are not already known are omitted from the mapping; contacts known           to have no location information appear in the mapping with an empty           Location dictionary.
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetLocations and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Return the current locations of the given contacts, if they are         already known. If any of the given contacts&apos; locations are not known,         request their current locations, but return immediately without waiting         for a reply; if a reply with a non-empty location is later received         for those contacts, the &lt;tp:member-ref&gt;LocationUpdated&lt;/tp:member-ref&gt;         signal will be emitted for them.          &lt;tp:rationale&gt;           This method is appropriate for &amp;quot;lazy&amp;quot; location finding, for instance           displaying the location (if available) of everyone in your contact           list.         &lt;/tp:rationale&gt;
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_connection_interface_location_callback_for_request_location:
 * @proxy: the proxy on which the call was made
 * @out_Location: Used to return an 'out' argument if @error is %NULL: The contact&apos;s location. It MAY be empty, indicating that no location           information was found.
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a RequestLocation method call
 * succeeds or fails.
 */

/**
 * tp_cli_connection_interface_location_call_request_location:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Contact: Used to pass an 'in' argument: The contact whose location should be returned.
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a RequestLocation method call.
 *
 * Return the current location of the given contact. If necessary, make         a request to the server for up-to-date information, and wait for a         reply.          &lt;tp:rationale&gt;           This method is appropriate for use in a &amp;quot;Contact Information...&amp;quot;           dialog; it can be used to show progress information (while waiting           for the method to return), and can distinguish between various error           conditions.         &lt;/tp:rationale&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_connection_interface_location_run_request_location:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Contact: Used to pass an 'in' argument: The contact whose location should be returned.
 * @out_Location: Used to return an 'out' argument if %TRUE is returned: The contact&apos;s location. It MAY be empty, indicating that no location           information was found.
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method RequestLocation and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Return the current location of the given contact. If necessary, make         a request to the server for up-to-date information, and wait for a         reply.          &lt;tp:rationale&gt;           This method is appropriate for use in a &amp;quot;Contact Information...&amp;quot;           dialog; it can be used to show progress information (while waiting           for the method to return), and can distinguish between various error           conditions.         &lt;/tp:rationale&gt;
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_connection_interface_location_callback_for_set_location:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a SetLocation method call
 * succeeds or fails.
 */

/**
 * tp_cli_connection_interface_location_call_set_location:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Location: Used to pass an 'in' argument: The location to advertise. If the user wants to obscure their           exact location by reducing the precision or accuracy, clients           MUST do this themselves, rather than relying on the connection           manager to do so. Clients that interact with more than one           connection SHOULD advertise the same reduced-accuracy location           to all of them, so that contacts cannot obtain an undesirably           accurate location by assuming that random errors have been added           and averaging the locations advertised on multiple connections.
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a SetLocation method call.
 *
 * Set the local user&apos;s own location.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_connection_interface_location_run_set_location:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Location: Used to pass an 'in' argument: The location to advertise. If the user wants to obscure their           exact location by reducing the precision or accuracy, clients           MUST do this themselves, rather than relying on the connection           manager to do so. Clients that interact with more than one           connection SHOULD advertise the same reduced-accuracy location           to all of them, so that contacts cannot obtain an undesirably           accurate location by assuming that random errors have been added           and averaging the locations advertised on multiple connections.
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method SetLocation and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Set the local user&apos;s own location.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_connection_interface_presence_signal_callback_presence_update:
 * @proxy: The proxy on which tp_cli_connection_interface_presence_connect_to_presence_update ()
 *  was called
 * @arg_Presence: A dictionary of contact handles mapped to a struct containing         a UNIX timestamp of the last activity time (in UTC), and         a dictionary mapping the contact&apos;s current status identifiers to           a dictionary of optional parameter names mapped to their           variant-boxed values
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal PresenceUpdate.
 */

/**
 * tp_cli_connection_interface_presence_connect_to_presence_update:
 * @proxy: A #TpConnection or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal PresenceUpdate.
 *
 * This signal should be emitted when your own presence has been changed,         or the presence of the member of any of the connection&apos;s channels has         been changed, or when the presence requested by         &lt;tp:member-ref&gt;RequestPresence&lt;/tp:member-ref&gt; is available.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_connection_interface_presence_callback_for_add_status:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a AddStatus method call
 * succeeds or fails.
 */

/**
 * tp_cli_connection_interface_presence_call_add_status:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Status: Used to pass an 'in' argument: The string identifier of the desired status
 * @in_Parameters: Used to pass an 'in' argument: A dictionary of optional parameter names mapped to their variant-boxed values
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a AddStatus method call.
 *
 * Request that a single presence status is published for the user, along         with any desired parameters. Changes will be indicated by         &lt;tp:member-ref&gt;PresenceUpdate&lt;/tp:member-ref&gt; signals being emitted.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_connection_interface_presence_run_add_status:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Status: Used to pass an 'in' argument: The string identifier of the desired status
 * @in_Parameters: Used to pass an 'in' argument: A dictionary of optional parameter names mapped to their variant-boxed values
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method AddStatus and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Request that a single presence status is published for the user, along         with any desired parameters. Changes will be indicated by         &lt;tp:member-ref&gt;PresenceUpdate&lt;/tp:member-ref&gt; signals being emitted.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_connection_interface_presence_callback_for_clear_status:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a ClearStatus method call
 * succeeds or fails.
 */

/**
 * tp_cli_connection_interface_presence_call_clear_status:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a ClearStatus method call.
 *
 * Request that all of a user&apos;s presence statuses be removed. Be aware         that this request may simply result in the statuses being replaced by a         default available status. Changes will be indicated by         &lt;tp:member-ref&gt;PresenceUpdate&lt;/tp:member-ref&gt; signals being emitted.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_connection_interface_presence_run_clear_status:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method ClearStatus and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Request that all of a user&apos;s presence statuses be removed. Be aware         that this request may simply result in the statuses being replaced by a         default available status. Changes will be indicated by         &lt;tp:member-ref&gt;PresenceUpdate&lt;/tp:member-ref&gt; signals being emitted.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_connection_interface_presence_callback_for_get_presence:
 * @proxy: the proxy on which the call was made
 * @out_Presence: Used to return an 'out' argument if @error is %NULL: Presence information in the same format as for the           &lt;tp:member-ref&gt;PresenceUpdate&lt;/tp:member-ref&gt; signal
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetPresence method call
 * succeeds or fails.
 */

/**
 * tp_cli_connection_interface_presence_call_get_presence:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Contacts: Used to pass an 'in' argument: An array of the contacts whose presence should be obtained
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetPresence method call.
 *
 * Get presence previously emitted by         &lt;tp:member-ref&gt;PresenceUpdate&lt;/tp:member-ref&gt; for the given contacts.         Data is returned in the same structure as the PresenceUpdate signal.         Using this method in favour of         &lt;tp:member-ref&gt;RequestPresence&lt;/tp:member-ref&gt; has the advantage that         it will not wake up each client connected to the PresenceUpdate signal.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_connection_interface_presence_run_get_presence:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Contacts: Used to pass an 'in' argument: An array of the contacts whose presence should be obtained
 * @out_Presence: Used to return an 'out' argument if %TRUE is returned: Presence information in the same format as for the           &lt;tp:member-ref&gt;PresenceUpdate&lt;/tp:member-ref&gt; signal
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetPresence and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Get presence previously emitted by         &lt;tp:member-ref&gt;PresenceUpdate&lt;/tp:member-ref&gt; for the given contacts.         Data is returned in the same structure as the PresenceUpdate signal.         Using this method in favour of         &lt;tp:member-ref&gt;RequestPresence&lt;/tp:member-ref&gt; has the advantage that         it will not wake up each client connected to the PresenceUpdate signal.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_connection_interface_presence_callback_for_get_statuses:
 * @proxy: the proxy on which the call was made
 * @out_Available_Statuses: Used to return an 'out' argument if @error is %NULL: A dictionary of string identifiers mapped to a struct for each status, containing:         &lt;ul&gt;           &lt;li&gt;a type value from one of the values above&lt;/li&gt;           &lt;li&gt;a boolean to indicate if this status may be set on yourself&lt;/li&gt;           &lt;li&gt;a boolean to indicate if this is an exclusive status which you             may not set alongside any other&lt;/li&gt;           &lt;li&gt;a dictionary of valid optional string argument names mapped to             their types&lt;/li&gt;         &lt;/ul&gt;
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetStatuses method call
 * succeeds or fails.
 */

/**
 * tp_cli_connection_interface_presence_call_get_statuses:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetStatuses method call.
 *
 * Get a dictionary of the valid presence statuses for this connection.         This is only available when online because only some statuses will         be available on some servers.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_connection_interface_presence_run_get_statuses:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @out_Available_Statuses: Used to return an 'out' argument if %TRUE is returned: A dictionary of string identifiers mapped to a struct for each status, containing:         &lt;ul&gt;           &lt;li&gt;a type value from one of the values above&lt;/li&gt;           &lt;li&gt;a boolean to indicate if this status may be set on yourself&lt;/li&gt;           &lt;li&gt;a boolean to indicate if this is an exclusive status which you             may not set alongside any other&lt;/li&gt;           &lt;li&gt;a dictionary of valid optional string argument names mapped to             their types&lt;/li&gt;         &lt;/ul&gt;
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetStatuses and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Get a dictionary of the valid presence statuses for this connection.         This is only available when online because only some statuses will         be available on some servers.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_connection_interface_presence_callback_for_remove_status:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a RemoveStatus method call
 * succeeds or fails.
 */

/**
 * tp_cli_connection_interface_presence_call_remove_status:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Status: Used to pass an 'in' argument: The string identifier of the status not to publish anymore for the user
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a RemoveStatus method call.
 *
 * Request that the given presence status is no longer published for the         user. Changes will be indicated by         &lt;tp:member-ref&gt;PresenceUpdate&lt;/tp:member-ref&gt; signals being emitted. As         with &lt;tp:member-ref&gt;ClearStatus&lt;/tp:member-ref&gt;, removing a status may         actually result in it being replaced by a default available status.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_connection_interface_presence_run_remove_status:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Status: Used to pass an 'in' argument: The string identifier of the status not to publish anymore for the user
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method RemoveStatus and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Request that the given presence status is no longer published for the         user. Changes will be indicated by         &lt;tp:member-ref&gt;PresenceUpdate&lt;/tp:member-ref&gt; signals being emitted. As         with &lt;tp:member-ref&gt;ClearStatus&lt;/tp:member-ref&gt;, removing a status may         actually result in it being replaced by a default available status.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_connection_interface_presence_callback_for_request_presence:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a RequestPresence method call
 * succeeds or fails.
 */

/**
 * tp_cli_connection_interface_presence_call_request_presence:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Contacts: Used to pass an 'in' argument: An array of the contacts whose presence should be obtained
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a RequestPresence method call.
 *
 * Request the presence for contacts on this connection. A &lt;tp:member-ref&gt;PresenceUpdate&lt;/tp:member-ref&gt;         signal will be emitted when they are received. This is not the same as         subscribing to the presence of a contact, which must be done using the         &apos;subscription&apos; &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel.Type&quot;&gt;ContactList&lt;/tp:dbus-ref&gt;,         and on some protocols presence information may not be available unless         a subscription exists.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_connection_interface_presence_run_request_presence:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Contacts: Used to pass an 'in' argument: An array of the contacts whose presence should be obtained
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method RequestPresence and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Request the presence for contacts on this connection. A &lt;tp:member-ref&gt;PresenceUpdate&lt;/tp:member-ref&gt;         signal will be emitted when they are received. This is not the same as         subscribing to the presence of a contact, which must be done using the         &apos;subscription&apos; &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel.Type&quot;&gt;ContactList&lt;/tp:dbus-ref&gt;,         and on some protocols presence information may not be available unless         a subscription exists.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_connection_interface_presence_callback_for_set_last_activity_time:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a SetLastActivityTime method call
 * succeeds or fails.
 */

/**
 * tp_cli_connection_interface_presence_call_set_last_activity_time:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Time: Used to pass an 'in' argument: A UNIX timestamp of the user&apos;s last activity time (in UTC)
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a SetLastActivityTime method call.
 *
 * Request that the recorded last activity time for the user be updated on         the server.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_connection_interface_presence_run_set_last_activity_time:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Time: Used to pass an 'in' argument: A UNIX timestamp of the user&apos;s last activity time (in UTC)
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method SetLastActivityTime and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Request that the recorded last activity time for the user be updated on         the server.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_connection_interface_presence_callback_for_set_status:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a SetStatus method call
 * succeeds or fails.
 */

/**
 * tp_cli_connection_interface_presence_call_set_status:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Statuses: Used to pass an 'in' argument: A dictionary mapping status identifiers to dictionaries, which           map optional parameter names to their variant-boxed values
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a SetStatus method call.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Request that the user&apos;s presence be changed to the given statuses           and desired parameters. Changes will be reflected by           &lt;tp:member-ref&gt;PresenceUpdate&lt;/tp:member-ref&gt;           signals being emitted.&lt;/p&gt;          &lt;p&gt;Statuses whose &lt;tp:type&gt;Connection_Presence_Type&lt;/tp:type&gt;           is Offline, Error or Unknown MUST NOT be passed to this           function. Connection managers SHOULD reject these statuses.&lt;/p&gt;          &lt;tp:rationale&gt;           &lt;p&gt;The same rationale as for &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Connection.Interface&quot;&gt;SimplePresence.SetPresence&lt;/tp:dbus-ref&gt;             applies.&lt;/p&gt;         &lt;/tp:rationale&gt;          &lt;p&gt;On certain protocols, this method may be           called on a newly-created connection which is still in the           DISCONNECTED state, and will sign on with the requested status.           If the requested status is not available after signing on,           NotAvailable will be returned and the connection will remain           offline, or if the protocol does not support signing on with           a certain status, Disconnected will be returned.&lt;/p&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_connection_interface_presence_run_set_status:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Statuses: Used to pass an 'in' argument: A dictionary mapping status identifiers to dictionaries, which           map optional parameter names to their variant-boxed values
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method SetStatus and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Request that the user&apos;s presence be changed to the given statuses           and desired parameters. Changes will be reflected by           &lt;tp:member-ref&gt;PresenceUpdate&lt;/tp:member-ref&gt;           signals being emitted.&lt;/p&gt;          &lt;p&gt;Statuses whose &lt;tp:type&gt;Connection_Presence_Type&lt;/tp:type&gt;           is Offline, Error or Unknown MUST NOT be passed to this           function. Connection managers SHOULD reject these statuses.&lt;/p&gt;          &lt;tp:rationale&gt;           &lt;p&gt;The same rationale as for &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Connection.Interface&quot;&gt;SimplePresence.SetPresence&lt;/tp:dbus-ref&gt;             applies.&lt;/p&gt;         &lt;/tp:rationale&gt;          &lt;p&gt;On certain protocols, this method may be           called on a newly-created connection which is still in the           DISCONNECTED state, and will sign on with the requested status.           If the requested status is not available after signing on,           NotAvailable will be returned and the connection will remain           offline, or if the protocol does not support signing on with           a certain status, Disconnected will be returned.&lt;/p&gt;
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_connection_interface_requests_signal_callback_new_channels:
 * @proxy: The proxy on which tp_cli_connection_interface_requests_connect_to_new_channels ()
 *  was called
 * @arg_Channels: The channels and their details. All channels that are signalled           together like this MUST have the same           &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel.FUTURE&quot;&gt;Bundle&lt;/tp:dbus-ref&gt;           property, which may           either refer to an existing bundle, or establish a new bundle.
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal NewChannels.
 */

/**
 * tp_cli_connection_interface_requests_connect_to_new_channels:
 * @proxy: A #TpConnection or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal NewChannels.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;New channels have been created. The connection manager SHOULD emit           a single signal for any group of closely related channels that are           created at the same time, so that the channel dispatcher can try to           dispatch them to a handler as a unit.&lt;/p&gt;          &lt;p&gt;In particular, if additional channels are created as a side-effect           of a call to &lt;tp:member-ref&gt;CreateChannel&lt;/tp:member-ref&gt;,           these channels SHOULD appear in the same NewChannels signal as           the channel that satisfies the request.&lt;/p&gt;          &lt;tp:rationale&gt;           &lt;p&gt;Joining a MUC Tube in XMPP requires joining the corresponding             MUC (chatroom), so a &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel.Type&quot;&gt;Text&lt;/tp:dbus-ref&gt;             channel can be created as a side-effect.&lt;/p&gt;         &lt;/tp:rationale&gt;          &lt;p&gt;Every time NewChannels is emitted, it MUST be followed by           a &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy&quot;&gt;Connection.NewChannel&lt;/tp:dbus-ref&gt;           signal for each channel.&lt;/p&gt;          &lt;tp:rationale&gt;           &lt;p&gt;The double signal emission is for the benefit of older Telepathy             clients, which won&apos;t be listening for NewChannels.&lt;/p&gt;            &lt;p&gt;The more informative NewChannels signal comes first so that             clients that did not examine the connection to find             out whether Requests is supported will see the more informative             signal for each channel first, and then ignore the less             informative signal because it announces a new channel of which             they are already aware.&lt;/p&gt;         &lt;/tp:rationale&gt;
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_connection_interface_requests_signal_callback_channel_closed:
 * @proxy: The proxy on which tp_cli_connection_interface_requests_connect_to_channel_closed ()
 *  was called
 * @arg_Removed: The channel which has been removed from the Channels property
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal ChannelClosed.
 */

/**
 * tp_cli_connection_interface_requests_connect_to_channel_closed:
 * @proxy: A #TpConnection or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal ChannelClosed.
 *
 * Emitted when a channel is closed and hence disappears from the         &lt;tp:member-ref&gt;Channels&lt;/tp:member-ref&gt; property.          &lt;tp:rationale&gt;           This is redundant with the &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel&quot;&gt;Closed&lt;/tp:dbus-ref&gt;           signal on the channel itself, but it does provide full change           notification for the Channels property.         &lt;/tp:rationale&gt;
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_connection_interface_requests_callback_for_create_channel:
 * @proxy: the proxy on which the call was made
 * @out_Channel: Used to return an 'out' argument if @error is %NULL: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;The Channel object, which MUST NOT be signalled with             &lt;tp:member-ref&gt;NewChannels&lt;/tp:member-ref&gt; until after this method             returns.&lt;/p&gt;            &lt;tp:rationale&gt;             &lt;p&gt;This allows the requester to alter its handling of               NewChannels by knowing whether one of the channels satisfied               a request it made.&lt;/p&gt;           &lt;/tp:rationale&gt;
 * @out_Properties: Used to return an 'out' argument if @error is %NULL: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;Properties of the channel that was produced, equivalent to             the properties in &lt;tp:type&gt;Channel_Details&lt;/tp:type&gt;.             Connection managers MUST NOT include properties here whose             values can change, for the same reasons as in             &lt;tp:type&gt;Channel_Details&lt;/tp:type&gt;.&lt;/p&gt;
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a CreateChannel method call
 * succeeds or fails.
 */

/**
 * tp_cli_connection_interface_requests_call_create_channel:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Request: Used to pass an 'in' argument: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;A dictionary containing desirable properties, which MUST include             &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel&quot;&gt;ChannelType&lt;/tp:dbus-ref&gt;.             Some properties             are defined such that only an exact match makes sense, and             connection managers MUST NOT satisfy a request with a channel             where that property does not match; some properties are defined             such that the connection manager MAY treat the request as merely             a hint, and make a best-effort attempt to satisfy it. This is             documented separately for each property.&lt;/p&gt;            &lt;p&gt;If this dictionary contains a property whose semantics             are not known to the connection manager, this method MUST fail             without side-effects (in particular it must not create a new             channel).&lt;/p&gt;            &lt;tp:rationale&gt;             &lt;p&gt;This is necessary if we want to be able to invent properties               in future that, when used in a request, are hard requirements               rather than just hints. A connection manager that did not know               the semantics of those properties could incorrectly return a               new channel that did not satisfy the requirements.&lt;/p&gt;           &lt;/tp:rationale&gt;            &lt;p&gt;The connection manager MUST NOT respond successfully,             and SHOULD NOT create a new channel or cause any other             side-effects, unless it can create a new channel that satisfies             the client&apos;s requirements.&lt;/p&gt;            &lt;p&gt;Properties that will be set by this argument need not have write             access after the channel has been created - indeed, it is             expected that most will be read-only.&lt;/p&gt;
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a CreateChannel method call.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Request that an entirely new channel is created.&lt;/p&gt;          &lt;tp:rationale&gt;           &lt;p&gt;There is deliberately no flag corresponding to the             suppress_handler argument to             &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy&quot;&gt;Connection.RequestChannel&lt;/tp:dbus-ref&gt;,             because passing a FALSE value for that argument is deprecated.             Requests made using this interface always behave as though             suppress_handler was TRUE.&lt;/p&gt;         &lt;/tp:rationale&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_connection_interface_requests_run_create_channel:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Request: Used to pass an 'in' argument: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;A dictionary containing desirable properties, which MUST include             &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel&quot;&gt;ChannelType&lt;/tp:dbus-ref&gt;.             Some properties             are defined such that only an exact match makes sense, and             connection managers MUST NOT satisfy a request with a channel             where that property does not match; some properties are defined             such that the connection manager MAY treat the request as merely             a hint, and make a best-effort attempt to satisfy it. This is             documented separately for each property.&lt;/p&gt;            &lt;p&gt;If this dictionary contains a property whose semantics             are not known to the connection manager, this method MUST fail             without side-effects (in particular it must not create a new             channel).&lt;/p&gt;            &lt;tp:rationale&gt;             &lt;p&gt;This is necessary if we want to be able to invent properties               in future that, when used in a request, are hard requirements               rather than just hints. A connection manager that did not know               the semantics of those properties could incorrectly return a               new channel that did not satisfy the requirements.&lt;/p&gt;           &lt;/tp:rationale&gt;            &lt;p&gt;The connection manager MUST NOT respond successfully,             and SHOULD NOT create a new channel or cause any other             side-effects, unless it can create a new channel that satisfies             the client&apos;s requirements.&lt;/p&gt;            &lt;p&gt;Properties that will be set by this argument need not have write             access after the channel has been created - indeed, it is             expected that most will be read-only.&lt;/p&gt;
 * @out_Channel: Used to return an 'out' argument if %TRUE is returned: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;The Channel object, which MUST NOT be signalled with             &lt;tp:member-ref&gt;NewChannels&lt;/tp:member-ref&gt; until after this method             returns.&lt;/p&gt;            &lt;tp:rationale&gt;             &lt;p&gt;This allows the requester to alter its handling of               NewChannels by knowing whether one of the channels satisfied               a request it made.&lt;/p&gt;           &lt;/tp:rationale&gt;
 * @out_Properties: Used to return an 'out' argument if %TRUE is returned: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;Properties of the channel that was produced, equivalent to             the properties in &lt;tp:type&gt;Channel_Details&lt;/tp:type&gt;.             Connection managers MUST NOT include properties here whose             values can change, for the same reasons as in             &lt;tp:type&gt;Channel_Details&lt;/tp:type&gt;.&lt;/p&gt;
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method CreateChannel and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Request that an entirely new channel is created.&lt;/p&gt;          &lt;tp:rationale&gt;           &lt;p&gt;There is deliberately no flag corresponding to the             suppress_handler argument to             &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy&quot;&gt;Connection.RequestChannel&lt;/tp:dbus-ref&gt;,             because passing a FALSE value for that argument is deprecated.             Requests made using this interface always behave as though             suppress_handler was TRUE.&lt;/p&gt;         &lt;/tp:rationale&gt;
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_connection_interface_requests_callback_for_ensure_channel:
 * @proxy: the proxy on which the call was made
 * @out_Yours: Used to return an 'out' argument if @error is %NULL: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;If false, the caller of EnsureChannel MUST assume that some             other process is handling this channel; if true, the caller of             EnsureChannel SHOULD handle it themselves or delegate it to another             client.&lt;/p&gt;            &lt;p&gt;If the creation of a channel makes several calls to EnsureChannel             (and no other requests) successful, exactly one of those calls MUST             return a true value for this argument.&lt;/p&gt;            &lt;p&gt;If the creation of a channel makes other requests successful,             the value returned for this argument MUST be such that exactly             one of the clients making requests ends up responsible for the             channel. In particular, if             &lt;tp:member-ref&gt;CreateChannel&lt;/tp:member-ref&gt; returns a channel             &lt;em&gt;C&lt;/em&gt;, any EnsureChannel calls that also return &lt;em&gt;C&lt;/em&gt;             MUST return a false value for this argument.&lt;/p&gt;
 * @out_Channel: Used to return an 'out' argument if @error is %NULL: The Channel object. If it was created as a result of this method           call, it MUST NOT be signalled by           &lt;tp:member-ref&gt;NewChannels&lt;/tp:member-ref&gt; until after this method           returns.            &lt;tp:rationale&gt;             &lt;p&gt;This allows the requester to alter its handling of               NewChannels by knowing whether one of the channels satisfied               a request it made.&lt;/p&gt;           &lt;/tp:rationale&gt;
 * @out_Properties: Used to return an 'out' argument if @error is %NULL: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;Properties of the channel that was produced, equivalent to             the properties in &lt;tp:type&gt;Channel_Details&lt;/tp:type&gt;.             Connection managers MUST NOT include properties here whose             values can change, for the same reasons as in             &lt;tp:type&gt;Channel_Details&lt;/tp:type&gt;.&lt;/p&gt;
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a EnsureChannel method call
 * succeeds or fails.
 */

/**
 * tp_cli_connection_interface_requests_call_ensure_channel:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Request: Used to pass an 'in' argument: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;A dictionary containing desirable properties, with the same             semantics as the corresponding parameter to             &lt;tp:member-ref&gt;CreateChannel&lt;/tp:member-ref&gt;.&lt;/p&gt;
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a EnsureChannel method call.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Request that channels are ensured to exist.&lt;/p&gt;          &lt;tp:rationale&gt;           &lt;p&gt;The connection manager is in the best position to determine which             existing channels could satisfy which requests.&lt;/p&gt;         &lt;/tp:rationale&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_connection_interface_requests_run_ensure_channel:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Request: Used to pass an 'in' argument: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;A dictionary containing desirable properties, with the same             semantics as the corresponding parameter to             &lt;tp:member-ref&gt;CreateChannel&lt;/tp:member-ref&gt;.&lt;/p&gt;
 * @out_Yours: Used to return an 'out' argument if %TRUE is returned: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;If false, the caller of EnsureChannel MUST assume that some             other process is handling this channel; if true, the caller of             EnsureChannel SHOULD handle it themselves or delegate it to another             client.&lt;/p&gt;            &lt;p&gt;If the creation of a channel makes several calls to EnsureChannel             (and no other requests) successful, exactly one of those calls MUST             return a true value for this argument.&lt;/p&gt;            &lt;p&gt;If the creation of a channel makes other requests successful,             the value returned for this argument MUST be such that exactly             one of the clients making requests ends up responsible for the             channel. In particular, if             &lt;tp:member-ref&gt;CreateChannel&lt;/tp:member-ref&gt; returns a channel             &lt;em&gt;C&lt;/em&gt;, any EnsureChannel calls that also return &lt;em&gt;C&lt;/em&gt;             MUST return a false value for this argument.&lt;/p&gt;
 * @out_Channel: Used to return an 'out' argument if %TRUE is returned: The Channel object. If it was created as a result of this method           call, it MUST NOT be signalled by           &lt;tp:member-ref&gt;NewChannels&lt;/tp:member-ref&gt; until after this method           returns.            &lt;tp:rationale&gt;             &lt;p&gt;This allows the requester to alter its handling of               NewChannels by knowing whether one of the channels satisfied               a request it made.&lt;/p&gt;           &lt;/tp:rationale&gt;
 * @out_Properties: Used to return an 'out' argument if %TRUE is returned: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;Properties of the channel that was produced, equivalent to             the properties in &lt;tp:type&gt;Channel_Details&lt;/tp:type&gt;.             Connection managers MUST NOT include properties here whose             values can change, for the same reasons as in             &lt;tp:type&gt;Channel_Details&lt;/tp:type&gt;.&lt;/p&gt;
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method EnsureChannel and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Request that channels are ensured to exist.&lt;/p&gt;          &lt;tp:rationale&gt;           &lt;p&gt;The connection manager is in the best position to determine which             existing channels could satisfy which requests.&lt;/p&gt;         &lt;/tp:rationale&gt;
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_connection_interface_service_point_signal_callback_service_points_changed:
 * @proxy: The proxy on which tp_cli_connection_interface_service_point_connect_to_service_points_changed ()
 *  was called
 * @arg_Service_Points: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;The new value of             &lt;tp:member-ref&gt;KnownServicePoints&lt;/tp:member-ref&gt;.&lt;/p&gt;
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal ServicePointsChanged.
 */

/**
 * tp_cli_connection_interface_service_point_connect_to_service_points_changed:
 * @proxy: A #TpConnection or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal ServicePointsChanged.
 *
 * Emitted when the list of known service points (or their IDs) has         changed.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_connection_interface_simple_presence_signal_callback_presences_changed:
 * @proxy: The proxy on which tp_cli_connection_interface_simple_presence_connect_to_presences_changed ()
 *  was called
 * @arg_Presence: A dictionary of contact handles mapped to the status,           presence type and status message.
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal PresencesChanged.
 */

/**
 * tp_cli_connection_interface_simple_presence_connect_to_presences_changed:
 * @proxy: A #TpConnection or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal PresencesChanged.
 *
 * This signal should be emitted when your own presence has been changed,         or the presence of the member of any of the connection&apos;s channels has         been changed.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_connection_interface_simple_presence_callback_for_set_presence:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a SetPresence method call
 * succeeds or fails.
 */

/**
 * tp_cli_connection_interface_simple_presence_call_set_presence:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Status: Used to pass an 'in' argument: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;The string identifier of the desired status. Possible status             identifiers are defined in the             &lt;tp:member-ref&gt;Statuses&lt;/tp:member-ref&gt; property.&lt;/p&gt;            &lt;p&gt;Clients MUST NOT set a status whose string value they do not             recognise, even if its presence type in Statuses             matches what the user requested.&lt;/p&gt;            &lt;tp:rationale&gt;             &lt;p&gt;Suppose a protocol has statuses that include &apos;phone&apos; (of type               BUSY) and &apos;in-a-meeting&apos; (of type BUSY), but there is no               generic &apos;busy&apos; status.&lt;/p&gt;              &lt;p&gt;If the user requests &amp;quot;Busy&amp;quot; status from a menu, a               client author might be tempted to pick an arbitrary status               that has type BUSY. However, on this protocol, neither of               the choices would be appropriate, and incorrect information               about the user would be conveyed.&lt;/p&gt;           &lt;/tp:rationale&gt;            &lt;p&gt;Statuses whose &lt;tp:type&gt;Connection_Presence_Type&lt;/tp:type&gt;             is Offline, Error or Unknown MUST NOT be passed to this             function. Connection managers SHOULD reject these statuses.&lt;/p&gt;            &lt;tp:rationale&gt;             &lt;p&gt;To go offline, call &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Connection&quot;&gt;Disconnect&lt;/tp:dbus-ref&gt;             instead. The &amp;quot;error&amp;quot; and &amp;quot;unknown&amp;quot; statuses make no sense.&lt;/p&gt;           &lt;/tp:rationale&gt;
 * @in_Status_Message: Used to pass an 'in' argument: The status message associated with the current status.
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a SetPresence method call.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Request that the presence status and status message are published for           the connection.  Changes will be indicated by           &lt;tp:member-ref&gt;PresencesChanged&lt;/tp:member-ref&gt;           signals being emitted.&lt;/p&gt;          &lt;p&gt;This method may be called on a newly-created connection while it           is still in the DISCONNECTED state, to request that when the           connection connects, it will do so with the selected status.&lt;/p&gt;          &lt;p&gt;In DISCONNECTED state the           &lt;tp:member-ref&gt;Statuses&lt;/tp:member-ref&gt;           property will indicate which statuses are allowed to be set           while DISCONNECTED (none, if the Connection Manager doesn&apos;t allow           this). This value MUST NOT be cached, as the set of allowed           presences might change upon connecting.&lt;/p&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_connection_interface_simple_presence_run_set_presence:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Status: Used to pass an 'in' argument: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;The string identifier of the desired status. Possible status             identifiers are defined in the             &lt;tp:member-ref&gt;Statuses&lt;/tp:member-ref&gt; property.&lt;/p&gt;            &lt;p&gt;Clients MUST NOT set a status whose string value they do not             recognise, even if its presence type in Statuses             matches what the user requested.&lt;/p&gt;            &lt;tp:rationale&gt;             &lt;p&gt;Suppose a protocol has statuses that include &apos;phone&apos; (of type               BUSY) and &apos;in-a-meeting&apos; (of type BUSY), but there is no               generic &apos;busy&apos; status.&lt;/p&gt;              &lt;p&gt;If the user requests &amp;quot;Busy&amp;quot; status from a menu, a               client author might be tempted to pick an arbitrary status               that has type BUSY. However, on this protocol, neither of               the choices would be appropriate, and incorrect information               about the user would be conveyed.&lt;/p&gt;           &lt;/tp:rationale&gt;            &lt;p&gt;Statuses whose &lt;tp:type&gt;Connection_Presence_Type&lt;/tp:type&gt;             is Offline, Error or Unknown MUST NOT be passed to this             function. Connection managers SHOULD reject these statuses.&lt;/p&gt;            &lt;tp:rationale&gt;             &lt;p&gt;To go offline, call &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Connection&quot;&gt;Disconnect&lt;/tp:dbus-ref&gt;             instead. The &amp;quot;error&amp;quot; and &amp;quot;unknown&amp;quot; statuses make no sense.&lt;/p&gt;           &lt;/tp:rationale&gt;
 * @in_Status_Message: Used to pass an 'in' argument: The status message associated with the current status.
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method SetPresence and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Request that the presence status and status message are published for           the connection.  Changes will be indicated by           &lt;tp:member-ref&gt;PresencesChanged&lt;/tp:member-ref&gt;           signals being emitted.&lt;/p&gt;          &lt;p&gt;This method may be called on a newly-created connection while it           is still in the DISCONNECTED state, to request that when the           connection connects, it will do so with the selected status.&lt;/p&gt;          &lt;p&gt;In DISCONNECTED state the           &lt;tp:member-ref&gt;Statuses&lt;/tp:member-ref&gt;           property will indicate which statuses are allowed to be set           while DISCONNECTED (none, if the Connection Manager doesn&apos;t allow           this). This value MUST NOT be cached, as the set of allowed           presences might change upon connecting.&lt;/p&gt;
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_connection_interface_simple_presence_callback_for_get_presences:
 * @proxy: the proxy on which the call was made
 * @out_Presence: Used to return an 'out' argument if @error is %NULL: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;Presence information in the same format as for the             &lt;tp:member-ref&gt;PresencesChanged&lt;/tp:member-ref&gt; signal.             The returned mapping MUST include an entry for each contact             in the method&apos;s argument.&lt;/p&gt;            &lt;p&gt;The definition of the connection presence types Unknown             and Offline means that if a connection manager will return             Unknown for contacts not on the subscribe list, it MUST delay             the reply to this method call until it has found out which             contacts are, in fact, on the subscribe list.&lt;/p&gt;
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetPresences method call
 * succeeds or fails.
 */

/**
 * tp_cli_connection_interface_simple_presence_call_get_presences:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Contacts: Used to pass an 'in' argument: An array of the contacts whose presence should be obtained.
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetPresences method call.
 *
 * Get presence previously emitted by         &lt;tp:member-ref&gt;PresencesChanged&lt;/tp:member-ref&gt; for the given         contacts. Data is returned in the same structure as the         PresencesChanged signal; no additional network requests are made.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_connection_interface_simple_presence_run_get_presences:
 * @proxy: A #TpConnection or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Contacts: Used to pass an 'in' argument: An array of the contacts whose presence should be obtained.
 * @out_Presence: Used to return an 'out' argument if %TRUE is returned: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;Presence information in the same format as for the             &lt;tp:member-ref&gt;PresencesChanged&lt;/tp:member-ref&gt; signal.             The returned mapping MUST include an entry for each contact             in the method&apos;s argument.&lt;/p&gt;            &lt;p&gt;The definition of the connection presence types Unknown             and Offline means that if a connection manager will return             Unknown for contacts not on the subscribe list, it MUST delay             the reply to this method call until it has found out which             contacts are, in fact, on the subscribe list.&lt;/p&gt;
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetPresences and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Get presence previously emitted by         &lt;tp:member-ref&gt;PresencesChanged&lt;/tp:member-ref&gt; for the given         contacts. Data is returned in the same structure as the         PresencesChanged signal; no additional network requests are made.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */

