/**
 * tp_cli_channel_signal_callback_closed:
 * @proxy: The proxy on which tp_cli_channel_connect_to_closed ()
 *  was called
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal Closed.
 */

/**
 * tp_cli_channel_connect_to_closed:
 * @proxy: A #TpChannel or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal Closed.
 *
 * Emitted when the channel has been closed. Method calls on the         channel are no longer valid after this signal has been emitted,         and the connection manager may then remove the object from the bus         at any point.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_channel_callback_for_close:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a Close method call
 * succeeds or fails.
 */

/**
 * tp_cli_channel_call_close:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a Close method call.
 *
 * Request that the channel be closed. This is not the case until         the &lt;tp:member-ref&gt;Closed&lt;/tp:member-ref&gt; signal has been emitted, and         depending on the connection         manager this may simply remove you from the channel on the server,         rather than causing it to stop existing entirely. Some channels         such as contact list channels may not be closed.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_channel_run_close:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method Close and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Request that the channel be closed. This is not the case until         the &lt;tp:member-ref&gt;Closed&lt;/tp:member-ref&gt; signal has been emitted, and         depending on the connection         manager this may simply remove you from the channel on the server,         rather than causing it to stop existing entirely. Some channels         such as contact list channels may not be closed.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_channel_callback_for_get_channel_type:
 * @proxy: the proxy on which the call was made
 * @out_Channel_Type: Used to return an 'out' argument if @error is %NULL: The interface name
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetChannelType method call
 * succeeds or fails.
 *
 * Deprecated: Use the ChannelType         property if possible.
 */

/**
 * tp_cli_channel_call_get_channel_type:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetChannelType method call.
 *
 * Returns the interface name for the type of this channel.  Clients         SHOULD use the &lt;tp:member-ref&gt;ChannelType&lt;/tp:member-ref&gt; property         instead, falling back to this method only if necessary.          &lt;tp:rationale&gt;           The GetAll method lets clients retrieve all properties in one           round-trip.         &lt;/tp:rationale&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 *
 * Deprecated: Use the ChannelType         property if possible.
 */

/**
 * tp_cli_channel_run_get_channel_type:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @out_Channel_Type: Used to return an 'out' argument if %TRUE is returned: The interface name
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetChannelType and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Returns the interface name for the type of this channel.  Clients         SHOULD use the &lt;tp:member-ref&gt;ChannelType&lt;/tp:member-ref&gt; property         instead, falling back to this method only if necessary.          &lt;tp:rationale&gt;           The GetAll method lets clients retrieve all properties in one           round-trip.         &lt;/tp:rationale&gt;
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 *
 * Deprecated: Use the ChannelType         property if possible.
 */


/**
 * tp_cli_channel_callback_for_get_handle:
 * @proxy: the proxy on which the call was made
 * @out_Target_Handle_Type: Used to return an 'out' argument if @error is %NULL: The same as TargetHandleType.
 * @out_Target_Handle: Used to return an 'out' argument if @error is %NULL: The same as TargetHandle.
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetHandle method call
 * succeeds or fails.
 *
 * Deprecated: Use the TargetHandleType         and TargetHandle properties if possible.
 */

/**
 * tp_cli_channel_call_get_handle:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetHandle method call.
 *
 * Returns the handle type and number if this channel represents a         communication with a particular contact, room or server-stored list, or         zero if it is transient and defined only by its contents. Clients         SHOULD use the &lt;tp:member-ref&gt;TargetHandle&lt;/tp:member-ref&gt; and         &lt;tp:member-ref&gt;TargetHandleType&lt;/tp:member-ref&gt; properties instead,         falling back to this method only if necessary.          &lt;tp:rationale&gt;           The GetAll method lets clients retrieve all properties in one           round-trip.         &lt;/tp:rationale&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 *
 * Deprecated: Use the TargetHandleType         and TargetHandle properties if possible.
 */

/**
 * tp_cli_channel_run_get_handle:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @out_Target_Handle_Type: Used to return an 'out' argument if %TRUE is returned: The same as TargetHandleType.
 * @out_Target_Handle: Used to return an 'out' argument if %TRUE is returned: The same as TargetHandle.
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetHandle and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Returns the handle type and number if this channel represents a         communication with a particular contact, room or server-stored list, or         zero if it is transient and defined only by its contents. Clients         SHOULD use the &lt;tp:member-ref&gt;TargetHandle&lt;/tp:member-ref&gt; and         &lt;tp:member-ref&gt;TargetHandleType&lt;/tp:member-ref&gt; properties instead,         falling back to this method only if necessary.          &lt;tp:rationale&gt;           The GetAll method lets clients retrieve all properties in one           round-trip.         &lt;/tp:rationale&gt;
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 *
 * Deprecated: Use the TargetHandleType         and TargetHandle properties if possible.
 */


/**
 * tp_cli_channel_callback_for_get_interfaces:
 * @proxy: the proxy on which the call was made
 * @out_Interfaces: Used to return an 'out' argument if @error is %NULL: An array of the D-Bus interface names
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetInterfaces method call
 * succeeds or fails.
 *
 * Deprecated: Use the Interfaces         property if possible.
 */

/**
 * tp_cli_channel_call_get_interfaces:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetInterfaces method call.
 *
 * Get the optional interfaces implemented by the channel.         Clients SHOULD use the &lt;tp:member-ref&gt;Interfaces&lt;/tp:member-ref&gt;         property instead, falling back to this method only if necessary.          &lt;tp:rationale&gt;           The GetAll method lets clients retrieve all properties in one           round-trip.         &lt;/tp:rationale&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 *
 * Deprecated: Use the Interfaces         property if possible.
 */

/**
 * tp_cli_channel_run_get_interfaces:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @out_Interfaces: Used to return an 'out' argument if %TRUE is returned: An array of the D-Bus interface names
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetInterfaces and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Get the optional interfaces implemented by the channel.         Clients SHOULD use the &lt;tp:member-ref&gt;Interfaces&lt;/tp:member-ref&gt;         property instead, falling back to this method only if necessary.          &lt;tp:rationale&gt;           The GetAll method lets clients retrieve all properties in one           round-trip.         &lt;/tp:rationale&gt;
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 *
 * Deprecated: Use the Interfaces         property if possible.
 */


/**
 * tp_cli_channel_interface_call_state_signal_callback_call_state_changed:
 * @proxy: The proxy on which tp_cli_channel_interface_call_state_connect_to_call_state_changed ()
 *  was called
 * @arg_Contact: An integer handle for the contact.
 * @arg_State: The new state for this contact.
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal CallStateChanged.
 */

/**
 * tp_cli_channel_interface_call_state_connect_to_call_state_changed:
 * @proxy: A #TpChannel or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal CallStateChanged.
 *
 * Emitted when the state of a member of the channel has changed.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_channel_interface_call_state_callback_for_get_call_states:
 * @proxy: the proxy on which the call was made
 * @out_States: Used to return an 'out' argument if @error is %NULL: The current call states. Participants where the call state flags           would be 0 (all unset) may be omitted from this mapping.
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetCallStates method call
 * succeeds or fails.
 */

/**
 * tp_cli_channel_interface_call_state_call_get_call_states:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetCallStates method call.
 *
 * Get the current call states for all contacts involved in this call.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_channel_interface_call_state_run_get_call_states:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @out_States: Used to return an 'out' argument if %TRUE is returned: The current call states. Participants where the call state flags           would be 0 (all unset) may be omitted from this mapping.
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetCallStates and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Get the current call states for all contacts involved in this call.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_channel_interface_chat_state_signal_callback_chat_state_changed:
 * @proxy: The proxy on which tp_cli_channel_interface_chat_state_connect_to_chat_state_changed ()
 *  was called
 * @arg_Contact: An integer handle for the contact.
 * @arg_State: The new state of this contact.
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal ChatStateChanged.
 */

/**
 * tp_cli_channel_interface_chat_state_connect_to_chat_state_changed:
 * @proxy: A #TpChannel or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal ChatStateChanged.
 *
 * Emitted when the state of a member of the channel has changed.         This includes local state.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_channel_interface_chat_state_callback_for_set_chat_state:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a SetChatState method call
 * succeeds or fails.
 */

/**
 * tp_cli_channel_interface_chat_state_call_set_chat_state:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_State: Used to pass an 'in' argument: The new state.
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a SetChatState method call.
 *
 * Set the local state and notify other members of the channel that it         has changed.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_channel_interface_chat_state_run_set_chat_state:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_State: Used to pass an 'in' argument: The new state.
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method SetChatState and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Set the local state and notify other members of the channel that it         has changed.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_channel_interface_conference_signal_callback_channel_merged:
 * @proxy: The proxy on which tp_cli_channel_interface_conference_connect_to_channel_merged ()
 *  was called
 * @arg_Channel: The channel that was added to           &lt;tp:member-ref&gt;Channels&lt;/tp:member-ref&gt;.
 * @arg_Channel_Specific_Handle: A new channel-specific handle for the &lt;tp:dbus-ref namespace=&quot;ofdT.Channel&quot;&gt;TargetHandle&lt;/tp:dbus-ref&gt; of           &lt;var&gt;Channel&lt;/var&gt;, as will appear in           &lt;tp:member-ref&gt;OriginalChannels&lt;/tp:member-ref&gt;, or &lt;tt&gt;0&lt;/tt&gt; if a           global handle is used for           &lt;var&gt;Channel&lt;/var&gt;&apos;s TargetHandle on the &lt;tp:dbus-ref namespace=&quot;ofdT.Channel.Interface&quot;&gt;Group&lt;/tp:dbus-ref&gt; interface           of this channel.
 * @arg_Properties: &lt;var&gt;Channel&lt;/var&gt;&apos;s immutable properties.
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal ChannelMerged.
 */

/**
 * tp_cli_channel_interface_conference_connect_to_channel_merged:
 * @proxy: A #TpChannel or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal ChannelMerged.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Emitted when a new channel is added to the value of           &lt;tp:member-ref&gt;Channels&lt;/tp:member-ref&gt;.&lt;/p&gt;
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_channel_interface_conference_signal_callback_channel_removed:
 * @proxy: The proxy on which tp_cli_channel_interface_conference_connect_to_channel_removed ()
 *  was called
 * @arg_Channel: The channel that was removed from           &lt;tp:member-ref&gt;Channels&lt;/tp:member-ref&gt;.
 * @arg_Details: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           Additional information about the removal, which may include           the same well-known keys as the Details argument of           &lt;tp:dbus-ref namespace=&quot;ofdT.Channel.Interface.Group&quot;&gt;MembersChangedDetailed&lt;/tp:dbus-ref&gt;, with the same semantics.
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal ChannelRemoved.
 */

/**
 * tp_cli_channel_interface_conference_connect_to_channel_removed:
 * @proxy: A #TpChannel or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal ChannelRemoved.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Emitted when a channel is removed from the value of           &lt;tp:member-ref&gt;Channels&lt;/tp:member-ref&gt;, either because it closed           or because it was split using the &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel.Interface&quot;&gt;Splittable.DRAFT.Split&lt;/tp:dbus-ref&gt; method.&lt;/p&gt;          &lt;p&gt;If a channel is removed because it was closed, &lt;tp:dbus-ref namespace=&quot;ofdT.Channel&quot;&gt;Closed&lt;/tp:dbus-ref&gt; should be emitted           before this signal.&lt;/p&gt;
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_channel_interface_dtmf_signal_callback_sending_tones:
 * @proxy: The proxy on which tp_cli_channel_interface_dtmf_connect_to_sending_tones ()
 *  was called
 * @arg_Tones: DTMF string (one or more events) that is to be played.
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal SendingTones.
 */

/**
 * tp_cli_channel_interface_dtmf_connect_to_sending_tones:
 * @proxy: A #TpChannel or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal SendingTones.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;DTMF tone(s)are being sent to all eligible streams in the channel.         The signal is provided to indicating the fact that the streams are         currently being used to send one or more DTMF tones, so any other         media input is not getting through to the audio stream. It also         serves as a cue for the         &lt;tp:member-ref&gt;StopTone&lt;/tp:member-ref&gt; method.&lt;/p&gt;
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_channel_interface_dtmf_signal_callback_stopped_tones:
 * @proxy: The proxy on which tp_cli_channel_interface_dtmf_connect_to_stopped_tones ()
 *  was called
 * @arg_Cancelled: True if the DTMF tones were actively cancelled via           &lt;tp:member-ref&gt;StopTone&lt;/tp:member-ref&gt;.
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal StoppedTones.
 */

/**
 * tp_cli_channel_interface_dtmf_connect_to_stopped_tones:
 * @proxy: A #TpChannel or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal StoppedTones.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;DTMF tones have finished playing on streams in this channel.&lt;/p&gt;
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_channel_interface_dtmf_callback_for_start_tone:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a StartTone method call
 * succeeds or fails.
 */

/**
 * tp_cli_channel_interface_dtmf_call_start_tone:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Stream_ID: Used to pass an 'in' argument: A stream ID as defined in the StreamedMedia channel         type. This argument is included for backwards compatibility and MUST         be ignored by the implementations - the tone SHOULD be sent to all         eligible streams in the channel.
 * @in_Event: Used to pass an 'in' argument: A numeric event code from the DTMF_Event enum.
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a StartTone method call.
 *
 * &lt;p&gt;Start sending a DTMF tone to all eligible streams in the channel.           Where possible, the tone will continue until           &lt;tp:member-ref&gt;StopTone&lt;/tp:member-ref&gt; is called. On certain protocols,           it may only be possible to send events with a predetermined length. In           this case, the implementation MAY emit a fixed-length tone, and the           StopTone method call SHOULD return NotAvailable.&lt;/p&gt;           &lt;tp:rationale&gt;             The client may wish to control the exact duration and timing of the             tones sent as a result of user&apos;s interaction with the dialpad, thus             starting and stopping the tone sending explicitly.           &lt;/tp:rationale&gt;          &lt;p&gt;Tone overlaping or queueing is not supported, so this method can only           be called if no DTMF tones are already being played.&lt;/p&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_channel_interface_dtmf_run_start_tone:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Stream_ID: Used to pass an 'in' argument: A stream ID as defined in the StreamedMedia channel         type. This argument is included for backwards compatibility and MUST         be ignored by the implementations - the tone SHOULD be sent to all         eligible streams in the channel.
 * @in_Event: Used to pass an 'in' argument: A numeric event code from the DTMF_Event enum.
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method StartTone and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * &lt;p&gt;Start sending a DTMF tone to all eligible streams in the channel.           Where possible, the tone will continue until           &lt;tp:member-ref&gt;StopTone&lt;/tp:member-ref&gt; is called. On certain protocols,           it may only be possible to send events with a predetermined length. In           this case, the implementation MAY emit a fixed-length tone, and the           StopTone method call SHOULD return NotAvailable.&lt;/p&gt;           &lt;tp:rationale&gt;             The client may wish to control the exact duration and timing of the             tones sent as a result of user&apos;s interaction with the dialpad, thus             starting and stopping the tone sending explicitly.           &lt;/tp:rationale&gt;          &lt;p&gt;Tone overlaping or queueing is not supported, so this method can only           be called if no DTMF tones are already being played.&lt;/p&gt;
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_channel_interface_dtmf_callback_for_stop_tone:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a StopTone method call
 * succeeds or fails.
 */

/**
 * tp_cli_channel_interface_dtmf_call_stop_tone:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Stream_ID: Used to pass an 'in' argument: A stream ID as defined in the StreamedMedia channel         type. This argument is included for backwards compatibility and MUST         be ignored by the implementations - the sending SHOULD be stoped in         all eligible streams in the channel.
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a StopTone method call.
 *
 * Stop sending any DTMF tones which have been started using the         &lt;tp:member-ref&gt;StartTone&lt;/tp:member-ref&gt; or         &lt;tp:member-ref&gt;MultipleTones&lt;/tp:member-ref&gt; methods.         If there is no current tone, this method will do nothing.         If MultipleTones was used, the client should not assume the         sending has stopped immediately; instead, the client should wait         for the StoppedTones signal.         &lt;tp:rationale&gt;           On some protocols it might be impossible to cancel queued tones           immediately.         &lt;/tp:rationale&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_channel_interface_dtmf_run_stop_tone:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Stream_ID: Used to pass an 'in' argument: A stream ID as defined in the StreamedMedia channel         type. This argument is included for backwards compatibility and MUST         be ignored by the implementations - the sending SHOULD be stoped in         all eligible streams in the channel.
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method StopTone and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Stop sending any DTMF tones which have been started using the         &lt;tp:member-ref&gt;StartTone&lt;/tp:member-ref&gt; or         &lt;tp:member-ref&gt;MultipleTones&lt;/tp:member-ref&gt; methods.         If there is no current tone, this method will do nothing.         If MultipleTones was used, the client should not assume the         sending has stopped immediately; instead, the client should wait         for the StoppedTones signal.         &lt;tp:rationale&gt;           On some protocols it might be impossible to cancel queued tones           immediately.         &lt;/tp:rationale&gt;
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_channel_interface_dtmf_callback_for_multiple_tones:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a MultipleTones method call
 * succeeds or fails.
 */

/**
 * tp_cli_channel_interface_dtmf_call_multiple_tones:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Tones: Used to pass an 'in' argument: A string representation of one or more DTMF           events.
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a MultipleTones method call.
 *
 * &lt;p&gt;Send multiple DTMF events to all eligible streams in the channel.         Each character in the Tones string must be a valid DTMF event         (as defined by         &lt;a href=&quot;http://www.rfc-editor.org/rfc/rfc4733.txt&quot;&gt;RFC4733&lt;/a&gt;).         Each tone will be played for a pre-defined number of milliseconds,         followed by a pause before the next tone is played.  The         duration/pause is defined by the protocol or connection manager.&lt;/p&gt;         &lt;tp:rationale&gt;           In cases where the client knows in advance the tone sequence it wants           to send, it&apos;s easier to use this method than manually start and stop           each tone in the sequence.         &lt;/tp:rationale&gt;          &lt;p&gt;Tone overlaping or queueing is not supported, so this method can only           be called if no DTMF tones are already being played.&lt;/p&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_channel_interface_dtmf_run_multiple_tones:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Tones: Used to pass an 'in' argument: A string representation of one or more DTMF           events.
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method MultipleTones and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * &lt;p&gt;Send multiple DTMF events to all eligible streams in the channel.         Each character in the Tones string must be a valid DTMF event         (as defined by         &lt;a href=&quot;http://www.rfc-editor.org/rfc/rfc4733.txt&quot;&gt;RFC4733&lt;/a&gt;).         Each tone will be played for a pre-defined number of milliseconds,         followed by a pause before the next tone is played.  The         duration/pause is defined by the protocol or connection manager.&lt;/p&gt;         &lt;tp:rationale&gt;           In cases where the client knows in advance the tone sequence it wants           to send, it&apos;s easier to use this method than manually start and stop           each tone in the sequence.         &lt;/tp:rationale&gt;          &lt;p&gt;Tone overlaping or queueing is not supported, so this method can only           be called if no DTMF tones are already being played.&lt;/p&gt;
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_channel_interface_destroyable_callback_for_destroy:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a Destroy method call
 * succeeds or fails.
 */

/**
 * tp_cli_channel_interface_destroyable_call_destroy:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a Destroy method call.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Close the channel abruptly, possibly with loss of data. The           connection manager MUST NOT re-create the channel unless/until           more events occur.&lt;/p&gt;          &lt;tp:rationale&gt;           &lt;p&gt;The main motivating situation for this method is that when a Text             channel with pending messages is closed with Close, it comes back             as an incoming channel (to avoid a race between Close and an             incoming message). If Destroy is called on a Text channel, the CM             should delete all pending messages and close the channel, and             the channel shouldn&apos;t be re-created until/unless another message             arrives.&lt;/p&gt;         &lt;/tp:rationale&gt;          &lt;p&gt;Most clients SHOULD call           &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy&quot;&gt;Channel.Close&lt;/tp:dbus-ref&gt;           instead. However, if a client explicitly intends to destroy the           channel with possible loss of data, it SHOULD call this method           if this interface is supported (according to the           &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy&quot;&gt;Channel.Interfaces&lt;/tp:dbus-ref&gt;           property), falling back to Close if not.&lt;/p&gt;          &lt;p&gt;In particular, channel dispatchers SHOULD use this method if           available when terminating channels that cannot be handled           correctly (for instance, if no handler has been installed for           a channel type, or if the handler crashes repeatedly).&lt;/p&gt;          &lt;p&gt;Connection managers do not need to implement this interface on           channels where Close and Destroy would be equivalent.&lt;/p&gt;          &lt;tp:rationale&gt;           &lt;p&gt;Callers need to be able to fall back to Close in any case.&lt;/p&gt;         &lt;/tp:rationale&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_channel_interface_destroyable_run_destroy:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method Destroy and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Close the channel abruptly, possibly with loss of data. The           connection manager MUST NOT re-create the channel unless/until           more events occur.&lt;/p&gt;          &lt;tp:rationale&gt;           &lt;p&gt;The main motivating situation for this method is that when a Text             channel with pending messages is closed with Close, it comes back             as an incoming channel (to avoid a race between Close and an             incoming message). If Destroy is called on a Text channel, the CM             should delete all pending messages and close the channel, and             the channel shouldn&apos;t be re-created until/unless another message             arrives.&lt;/p&gt;         &lt;/tp:rationale&gt;          &lt;p&gt;Most clients SHOULD call           &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy&quot;&gt;Channel.Close&lt;/tp:dbus-ref&gt;           instead. However, if a client explicitly intends to destroy the           channel with possible loss of data, it SHOULD call this method           if this interface is supported (according to the           &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy&quot;&gt;Channel.Interfaces&lt;/tp:dbus-ref&gt;           property), falling back to Close if not.&lt;/p&gt;          &lt;p&gt;In particular, channel dispatchers SHOULD use this method if           available when terminating channels that cannot be handled           correctly (for instance, if no handler has been installed for           a channel type, or if the handler crashes repeatedly).&lt;/p&gt;          &lt;p&gt;Connection managers do not need to implement this interface on           channels where Close and Destroy would be equivalent.&lt;/p&gt;          &lt;tp:rationale&gt;           &lt;p&gt;Callers need to be able to fall back to Close in any case.&lt;/p&gt;         &lt;/tp:rationale&gt;
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_channel_interface_group_signal_callback_handle_owners_changed:
 * @proxy: The proxy on which tp_cli_channel_interface_group_connect_to_handle_owners_changed ()
 *  was called
 * @arg_Added: A map from channel-specific handles to their owners, in which the           keys include all the handles that were added to the keys of the           HandleOwners property, and all the handles in that property whose           owner has changed
 * @arg_Removed: The channel-specific handles that were removed from the keys of the           HandleOwners property, as a result of the contact leaving this group           in a previous &lt;tp:member-ref&gt;MembersChanged&lt;/tp:member-ref&gt; signal
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal HandleOwnersChanged.
 */

/**
 * tp_cli_channel_interface_group_connect_to_handle_owners_changed:
 * @proxy: A #TpChannel or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal HandleOwnersChanged.
 *
 * Emitted whenever the &lt;tp:member-ref&gt;HandleOwners&lt;/tp:member-ref&gt;         property changes.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_channel_interface_group_signal_callback_self_handle_changed:
 * @proxy: The proxy on which tp_cli_channel_interface_group_connect_to_self_handle_changed ()
 *  was called
 * @arg_Self_Handle: The new value of the SelfHandle property.
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal SelfHandleChanged.
 */

/**
 * tp_cli_channel_interface_group_connect_to_self_handle_changed:
 * @proxy: A #TpChannel or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal SelfHandleChanged.
 *
 * Emitted whenever the &lt;tp:member-ref&gt;SelfHandle&lt;/tp:member-ref&gt; property         changes.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_channel_interface_group_signal_callback_group_flags_changed:
 * @proxy: The proxy on which tp_cli_channel_interface_group_connect_to_group_flags_changed ()
 *  was called
 * @arg_Added: A bitwise OR of the flags which have been set
 * @arg_Removed: A bitwise OR of the flags which have been cleared
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal GroupFlagsChanged.
 */

/**
 * tp_cli_channel_interface_group_connect_to_group_flags_changed:
 * @proxy: A #TpChannel or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal GroupFlagsChanged.
 *
 * Emitted when the flags as returned by         &lt;tp:member-ref&gt;GetGroupFlags&lt;/tp:member-ref&gt; are changed.         The user interface should be updated as appropriate.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_channel_interface_group_signal_callback_members_changed:
 * @proxy: The proxy on which tp_cli_channel_interface_group_connect_to_members_changed ()
 *  was called
 * @arg_Message: A string message from the server, or blank if not
 * @arg_Added: A list of members added to the channel
 * @arg_Removed: A list of members removed from the channel
 * @arg_Local_Pending: A list of members who are pending local approval
 * @arg_Remote_Pending: A list of members who are pending remote approval
 * @arg_Actor: The contact handle of the person who made the change, or 0           if not known
 * @arg_Reason: A reason for the change
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal MembersChanged.
 */

/**
 * tp_cli_channel_interface_group_connect_to_members_changed:
 * @proxy: A #TpChannel or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal MembersChanged.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Emitted when contacts join any of the three lists (members, local           pending or remote pending) or when they leave any of the three lists.           There may also be a message from the server regarding this change,           which may be displayed to the user if desired.&lt;/p&gt;          &lt;p&gt;All channel-specific handles that are mentioned in this signal           MUST be represented in the value of the           &lt;tp:member-ref&gt;HandleOwners&lt;/tp:member-ref&gt; property.           In practice, this will mean that           &lt;tp:member-ref&gt;HandleOwnersChanged&lt;/tp:member-ref&gt; is           emitted &lt;em&gt;before&lt;/em&gt; emitting a MembersChanged signal in which           channel-specific handles are added, but that it is emitted           &lt;em&gt;after&lt;/em&gt; emitting a MembersChanged signal in which           channel-specific handles are removed.&lt;/p&gt;          &lt;p&gt;See &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel.Type&quot;&gt;StreamedMedia&lt;/tp:dbus-ref&gt;           for an overview of how group state changes are used to indicate the           progress of a call.&lt;/p&gt;
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_channel_interface_group_signal_callback_members_changed_detailed:
 * @proxy: The proxy on which tp_cli_channel_interface_group_connect_to_members_changed_detailed ()
 *  was called
 * @arg_Added: A list of members added to the channel
 * @arg_Removed: A list of members removed from the channel
 * @arg_Local_Pending: A list of members who are pending local approval
 * @arg_Remote_Pending: A list of members who are pending remote approval
 * @arg_Details: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;Information about the change, which may include the following             well-known keys:&lt;/p&gt;            &lt;dl&gt;             &lt;dt&gt;actor (u — &lt;tp:type&gt;Contact_Handle&lt;/tp:type&gt;)&lt;/dt&gt;             &lt;dd&gt;The contact handle of the person who made the change; 0 or               omitted if unknown or not applicable.&lt;/dd&gt;              &lt;dt&gt;change-reason (u — &lt;tp:type&gt;Channel_Group_Change_Reason&lt;/tp:type&gt;)&lt;/dt&gt;             &lt;dd&gt;A reason for the change.&lt;/dd&gt;              &lt;dt&gt;contact-ids (a{us} — &lt;tp:type&gt;Handle_Identifier_Map&lt;/tp:type&gt;)&lt;/dt&gt;             &lt;dd&gt;               &lt;p&gt;The string identifiers for handles mentioned in this signal, to               give clients the minimal information necessary to react to the               event without waiting for round-trips.  Connection managers               SHOULD include the identifiers for members added to the group and               for the actor (if any); they MAY omit the identifiers for handles               which have been removed from the group.&lt;/p&gt;                &lt;tp:rationale&gt;                 &lt;p&gt;On IRC, an event such as a netsplit could cause the vast                 majority of a channel to leave.  Given that clients should                 already know the identifiers of a channel&apos;s members, including                 potentially hundreds of strings in the netsplit signal is                 unnecessary.&lt;/p&gt;               &lt;/tp:rationale&gt;                &lt;p&gt;Clients MUST NOT assume that the presence or absence of a                 handle in this mapping is meaningful. This mapping is merely                 an optimization for round-trip reduction, and connection                 managers MAY add additional handles, omit some handles, or                 omit the mapping completely.&lt;/p&gt;             &lt;/dd&gt;              &lt;dt&gt;message (s)&lt;/dt&gt;             &lt;dd&gt;A string message from the server regarding the change&lt;/dd&gt;              &lt;dt&gt;error (s — &lt;tp:type&gt;DBus_Error_Name&lt;/tp:type&gt;)&lt;/dt&gt;             &lt;dd&gt;A (possibly implementation-specific) DBus error describing the               change, providing more specific information than the               &lt;tp:type&gt;Channel_Group_Change_Reason&lt;/tp:type&gt; enum allows. This               MUST only be present if it is strictly more informative than               &apos;change-reason&apos;; if present, &apos;change-reason&apos; MUST be set to the               closest available reason.                &lt;tp:rationale&gt;                 A SIP connection manager might want to signal &amp;quot;402 Payment                 required&amp;quot; as something more specific than Error or                 Permission_Denied so that a SIP-aware UI could handle it                 specially; including a namespaced error permits this to be done                 without &lt;tp:type&gt;Channel_Group_Change_Reason&lt;/tp:type&gt; being                 extended to encompass every error any CM ever wants to report.               &lt;/tp:rationale&gt;             &lt;/dd&gt;              &lt;dt&gt;debug-message (s)&lt;/dt&gt;             &lt;dd&gt;Debugging information on the change. SHOULD NOT be shown to               users in normal circumstances.&lt;/dd&gt;           &lt;/dl&gt;
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal MembersChangedDetailed.
 */

/**
 * tp_cli_channel_interface_group_connect_to_members_changed_detailed:
 * @proxy: A #TpChannel or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal MembersChangedDetailed.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Emitted when contacts join any of the three lists (members, local           pending or remote pending) or when they leave any of the three           lists. This signal provides a superset of the information provided by           &lt;tp:member-ref&gt;MembersChanged&lt;/tp:member-ref&gt;;           if the channel&apos;s &lt;tp:member-ref&gt;GroupFlags&lt;/tp:member-ref&gt;           contains Members_Changed_Detailed, then clients may listen exclusively           to this signal in preference to that signal.&lt;/p&gt;          &lt;p&gt;All channel-specific handles that are mentioned in this signal           MUST be represented in the value of the           &lt;tp:member-ref&gt;HandleOwners&lt;/tp:member-ref&gt; property.  In practice,           this will mean that           &lt;tp:member-ref&gt;HandleOwnersChanged&lt;/tp:member-ref&gt; is emitted           &lt;em&gt;before&lt;/em&gt; emitting a MembersChangedDetailed signal in which           channel-specific handles are added, but that it is emitted           &lt;em&gt;after&lt;/em&gt; emitting a MembersChangedDetailed signal in which           channel-specific handles are removed.&lt;/p&gt;          &lt;p&gt;See &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel.Type&quot;&gt;StreamedMedia&lt;/tp:dbus-ref&gt;           for an overview of how group state changes are used to indicate the           progress of a call.&lt;/p&gt;
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_channel_interface_group_callback_for_add_members:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a AddMembers method call
 * succeeds or fails.
 */

/**
 * tp_cli_channel_interface_group_call_add_members:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Contacts: Used to pass an 'in' argument: An array of contact handles to invite to the channel
 * @in_Message: Used to pass an 'in' argument: A string message, which can be blank if desired
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a AddMembers method call.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Invite all the given contacts into the channel, or accept requests for           channel membership for contacts on the pending local list.&lt;/p&gt;          &lt;p&gt;A message may be provided along with the request, which will be sent         to the server if supported. See the CHANNEL_GROUP_FLAG_MESSAGE_ADD and         CHANNEL_GROUP_FLAG_MESSAGE_ACCEPT         &lt;tp:member-ref&gt;GroupFlags&lt;/tp:member-ref&gt; to see in which cases this         message should be provided.&lt;/p&gt;          &lt;p&gt;Attempting to add contacts who are already members is allowed;           connection managers must silently accept this, without error.&lt;/p&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_channel_interface_group_run_add_members:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Contacts: Used to pass an 'in' argument: An array of contact handles to invite to the channel
 * @in_Message: Used to pass an 'in' argument: A string message, which can be blank if desired
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method AddMembers and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Invite all the given contacts into the channel, or accept requests for           channel membership for contacts on the pending local list.&lt;/p&gt;          &lt;p&gt;A message may be provided along with the request, which will be sent         to the server if supported. See the CHANNEL_GROUP_FLAG_MESSAGE_ADD and         CHANNEL_GROUP_FLAG_MESSAGE_ACCEPT         &lt;tp:member-ref&gt;GroupFlags&lt;/tp:member-ref&gt; to see in which cases this         message should be provided.&lt;/p&gt;          &lt;p&gt;Attempting to add contacts who are already members is allowed;           connection managers must silently accept this, without error.&lt;/p&gt;
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_channel_interface_group_callback_for_get_all_members:
 * @proxy: the proxy on which the call was made
 * @out_Members: Used to return an 'out' argument if @error is %NULL: array of handles of current members
 * @out_Local_Pending: Used to return an 'out' argument if @error is %NULL: array of handles of local pending members
 * @out_Remote_Pending: Used to return an 'out' argument if @error is %NULL: array of handles of remote pending members
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetAllMembers method call
 * succeeds or fails.
 *
 * Deprecated: Use GetAll on the D-Bus         Properties D-Bus interface to get properties including Members,         RemotePendingMembers and LocalPendingMembers instead, falling back to         this method and GetLocalPendingMembersWithInfo if necessary.
 */

/**
 * tp_cli_channel_interface_group_call_get_all_members:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetAllMembers method call.
 *
 * Returns arrays of all current, local and remote pending channel         members.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 *
 * Deprecated: Use GetAll on the D-Bus         Properties D-Bus interface to get properties including Members,         RemotePendingMembers and LocalPendingMembers instead, falling back to         this method and GetLocalPendingMembersWithInfo if necessary.
 */

/**
 * tp_cli_channel_interface_group_run_get_all_members:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @out_Members: Used to return an 'out' argument if %TRUE is returned: array of handles of current members
 * @out_Local_Pending: Used to return an 'out' argument if %TRUE is returned: array of handles of local pending members
 * @out_Remote_Pending: Used to return an 'out' argument if %TRUE is returned: array of handles of remote pending members
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetAllMembers and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Returns arrays of all current, local and remote pending channel         members.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 *
 * Deprecated: Use GetAll on the D-Bus         Properties D-Bus interface to get properties including Members,         RemotePendingMembers and LocalPendingMembers instead, falling back to         this method and GetLocalPendingMembersWithInfo if necessary.
 */


/**
 * tp_cli_channel_interface_group_callback_for_get_group_flags:
 * @proxy: the proxy on which the call was made
 * @out_Group_Flags: Used to return an 'out' argument if @error is %NULL: The value of the GroupFlags property
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetGroupFlags method call
 * succeeds or fails.
 *
 * Deprecated: Use GetAll on the D-Bus         Properties D-Bus interface to get properties including GroupFlags         instead, falling back to this method if necessary.
 */

/**
 * tp_cli_channel_interface_group_call_get_group_flags:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetGroupFlags method call.
 *
 * Returns the value of the &lt;tp:member-ref&gt;GroupFlags&lt;/tp:member-ref&gt; property.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 *
 * Deprecated: Use GetAll on the D-Bus         Properties D-Bus interface to get properties including GroupFlags         instead, falling back to this method if necessary.
 */

/**
 * tp_cli_channel_interface_group_run_get_group_flags:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @out_Group_Flags: Used to return an 'out' argument if %TRUE is returned: The value of the GroupFlags property
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetGroupFlags and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Returns the value of the &lt;tp:member-ref&gt;GroupFlags&lt;/tp:member-ref&gt; property.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 *
 * Deprecated: Use GetAll on the D-Bus         Properties D-Bus interface to get properties including GroupFlags         instead, falling back to this method if necessary.
 */


/**
 * tp_cli_channel_interface_group_callback_for_get_handle_owners:
 * @proxy: the proxy on which the call was made
 * @out_Owners: Used to return an 'out' argument if @error is %NULL: An array of integer handles representing the owner handles of           the given room members, in the same order, or 0 if the           owner is not available
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetHandleOwners method call
 * succeeds or fails.
 *
 * Deprecated: Clients should use the         HandleOwners property and HandleOwnersChanged signal if         Channel_Group_Flag_Properties is present.
 */

/**
 * tp_cli_channel_interface_group_call_get_handle_owners:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Handles: Used to pass an 'in' argument: A list of integer handles representing members of the channel
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetHandleOwners method call.
 *
 * If the CHANNEL_GROUP_FLAG_CHANNEL_SPECIFIC_HANDLES flag is set on         the channel, then the handles of the group members are specific         to this channel, and are not meaningful in a connection-wide         context such as contact lists. This method allows you to find         the owner of the handle if it can be discovered in this channel,         or 0 if the owner is not available.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 *
 * Deprecated: Clients should use the         HandleOwners property and HandleOwnersChanged signal if         Channel_Group_Flag_Properties is present.
 */

/**
 * tp_cli_channel_interface_group_run_get_handle_owners:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Handles: Used to pass an 'in' argument: A list of integer handles representing members of the channel
 * @out_Owners: Used to return an 'out' argument if %TRUE is returned: An array of integer handles representing the owner handles of           the given room members, in the same order, or 0 if the           owner is not available
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetHandleOwners and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * If the CHANNEL_GROUP_FLAG_CHANNEL_SPECIFIC_HANDLES flag is set on         the channel, then the handles of the group members are specific         to this channel, and are not meaningful in a connection-wide         context such as contact lists. This method allows you to find         the owner of the handle if it can be discovered in this channel,         or 0 if the owner is not available.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 *
 * Deprecated: Clients should use the         HandleOwners property and HandleOwnersChanged signal if         Channel_Group_Flag_Properties is present.
 */


/**
 * tp_cli_channel_interface_group_callback_for_get_local_pending_members:
 * @proxy: the proxy on which the call was made
 * @out_Handles: Used to return an 'out' argument if @error is %NULL: (Undocumented)
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetLocalPendingMembers method call
 * succeeds or fails.
 *
 * Deprecated: Use the LocalPendingMembers         property, if Channel_Group_Flag_Properties is present.
 */

/**
 * tp_cli_channel_interface_group_call_get_local_pending_members:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetLocalPendingMembers method call.
 *
 * Returns the To_Be_Added handle (only) for each structure in the         &lt;tp:member-ref&gt;LocalPendingMembers&lt;/tp:member-ref&gt; property.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 *
 * Deprecated: Use the LocalPendingMembers         property, if Channel_Group_Flag_Properties is present.
 */

/**
 * tp_cli_channel_interface_group_run_get_local_pending_members:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @out_Handles: Used to return an 'out' argument if %TRUE is returned: (Undocumented)
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetLocalPendingMembers and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Returns the To_Be_Added handle (only) for each structure in the         &lt;tp:member-ref&gt;LocalPendingMembers&lt;/tp:member-ref&gt; property.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 *
 * Deprecated: Use the LocalPendingMembers         property, if Channel_Group_Flag_Properties is present.
 */


/**
 * tp_cli_channel_interface_group_callback_for_get_local_pending_members_with_info:
 * @proxy: the proxy on which the call was made
 * @out_Info: Used to return an 'out' argument if @error is %NULL: An array of structs containing:           &lt;ul&gt;             &lt;li&gt;               A handle representing the contact requesting channel membership             &lt;/li&gt;             &lt;li&gt;               A handle representing the contact making the request, or 0 if               unknown             &lt;/li&gt;             &lt;li&gt;               The reason for the request: one of the values of               &lt;tp:type&gt;Channel_Group_Change_Reason&lt;/tp:type&gt;             &lt;/li&gt;             &lt;li&gt;               A string message containing the reason for the request if any (or               blank if none)             &lt;/li&gt;           &lt;/ul&gt;
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetLocalPendingMembersWithInfo method call
 * succeeds or fails.
 *
 * Deprecated: Use the LocalPendingMembers         property, if Channel_Group_Flag_Properties is present.
 */

/**
 * tp_cli_channel_interface_group_call_get_local_pending_members_with_info:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetLocalPendingMembersWithInfo method call.
 *
 * Returns the &lt;tp:member-ref&gt;LocalPendingMembers&lt;/tp:member-ref&gt; property.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 *
 * Deprecated: Use the LocalPendingMembers         property, if Channel_Group_Flag_Properties is present.
 */

/**
 * tp_cli_channel_interface_group_run_get_local_pending_members_with_info:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @out_Info: Used to return an 'out' argument if %TRUE is returned: An array of structs containing:           &lt;ul&gt;             &lt;li&gt;               A handle representing the contact requesting channel membership             &lt;/li&gt;             &lt;li&gt;               A handle representing the contact making the request, or 0 if               unknown             &lt;/li&gt;             &lt;li&gt;               The reason for the request: one of the values of               &lt;tp:type&gt;Channel_Group_Change_Reason&lt;/tp:type&gt;             &lt;/li&gt;             &lt;li&gt;               A string message containing the reason for the request if any (or               blank if none)             &lt;/li&gt;           &lt;/ul&gt;
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetLocalPendingMembersWithInfo and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Returns the &lt;tp:member-ref&gt;LocalPendingMembers&lt;/tp:member-ref&gt; property.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 *
 * Deprecated: Use the LocalPendingMembers         property, if Channel_Group_Flag_Properties is present.
 */


/**
 * tp_cli_channel_interface_group_callback_for_get_members:
 * @proxy: the proxy on which the call was made
 * @out_Handles: Used to return an 'out' argument if @error is %NULL: (Undocumented)
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetMembers method call
 * succeeds or fails.
 *
 * Deprecated: Use the Members         property, if Channel_Group_Flag_Properties is present.
 */

/**
 * tp_cli_channel_interface_group_call_get_members:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetMembers method call.
 *
 * Returns the &lt;tp:member-ref&gt;Members&lt;/tp:member-ref&gt; property.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 *
 * Deprecated: Use the Members         property, if Channel_Group_Flag_Properties is present.
 */

/**
 * tp_cli_channel_interface_group_run_get_members:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @out_Handles: Used to return an 'out' argument if %TRUE is returned: (Undocumented)
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetMembers and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Returns the &lt;tp:member-ref&gt;Members&lt;/tp:member-ref&gt; property.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 *
 * Deprecated: Use the Members         property, if Channel_Group_Flag_Properties is present.
 */


/**
 * tp_cli_channel_interface_group_callback_for_get_remote_pending_members:
 * @proxy: the proxy on which the call was made
 * @out_Handles: Used to return an 'out' argument if @error is %NULL: (Undocumented)
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetRemotePendingMembers method call
 * succeeds or fails.
 *
 * Deprecated: Use the RemotePendingMembers property, if Channel_Group_Flag_Properties is present.
 */

/**
 * tp_cli_channel_interface_group_call_get_remote_pending_members:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetRemotePendingMembers method call.
 *
 * Returns an array of handles representing contacts who have been         invited to the channel and are awaiting remote approval.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 *
 * Deprecated: Use the RemotePendingMembers property, if Channel_Group_Flag_Properties is present.
 */

/**
 * tp_cli_channel_interface_group_run_get_remote_pending_members:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @out_Handles: Used to return an 'out' argument if %TRUE is returned: (Undocumented)
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetRemotePendingMembers and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Returns an array of handles representing contacts who have been         invited to the channel and are awaiting remote approval.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 *
 * Deprecated: Use the RemotePendingMembers property, if Channel_Group_Flag_Properties is present.
 */


/**
 * tp_cli_channel_interface_group_callback_for_get_self_handle:
 * @proxy: the proxy on which the call was made
 * @out_Self_Handle: Used to return an 'out' argument if @error is %NULL: (Undocumented)
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetSelfHandle method call
 * succeeds or fails.
 *
 * Deprecated: Clients should retrieve the         SelfHandle property using GetAll instead,         if Channel_Group_Flag_Properties is present.
 */

/**
 * tp_cli_channel_interface_group_call_get_self_handle:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetSelfHandle method call.
 *
 * Returns the value of the &lt;tp:member-ref&gt;SelfHandle&lt;/tp:member-ref&gt;         property.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 *
 * Deprecated: Clients should retrieve the         SelfHandle property using GetAll instead,         if Channel_Group_Flag_Properties is present.
 */

/**
 * tp_cli_channel_interface_group_run_get_self_handle:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @out_Self_Handle: Used to return an 'out' argument if %TRUE is returned: (Undocumented)
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetSelfHandle and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Returns the value of the &lt;tp:member-ref&gt;SelfHandle&lt;/tp:member-ref&gt;         property.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 *
 * Deprecated: Clients should retrieve the         SelfHandle property using GetAll instead,         if Channel_Group_Flag_Properties is present.
 */


/**
 * tp_cli_channel_interface_group_callback_for_remove_members:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a RemoveMembers method call
 * succeeds or fails.
 */

/**
 * tp_cli_channel_interface_group_call_remove_members:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Contacts: Used to pass an 'in' argument: An array of contact handles to remove from the channel
 * @in_Message: Used to pass an 'in' argument: A string message, which can be blank if desired
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a RemoveMembers method call.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Requests the removal of contacts from a channel, reject their           request for channel membership on the pending local list, or           rescind their invitation on the pending remote list.&lt;/p&gt;          &lt;p&gt;If the &lt;tp:member-ref&gt;SelfHandle&lt;/tp:member-ref&gt; is in a Group,           it can be removed via this method, in order to leave the group           gracefully. This is the recommended way to leave a chatroom, close           or reject a &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel.Type&quot;&gt;StreamedMedia&lt;/tp:dbus-ref&gt;           call, and so on.&lt;/p&gt;          &lt;p&gt;Accordingly, connection managers SHOULD support           doing this, regardless of the value of           &lt;tp:member-ref&gt;GroupFlags&lt;/tp:member-ref&gt;.           If doing so fails with PermissionDenied, this is considered to a bug           in the connection manager, but clients MUST recover by falling back           to closing the channel with the &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel&quot;&gt;Close&lt;/tp:dbus-ref&gt;           method.&lt;/p&gt;          &lt;p&gt;Removing any contact from the local pending list is always           allowed. Removing contacts other than the           &lt;tp:member-ref&gt;SelfHandle&lt;/tp:member-ref&gt; from the channel&apos;s members           is allowed if and only if Channel_Group_Flag_Can_Remove is in the           &lt;tp:member-ref&gt;GroupFlags&lt;/tp:member-ref&gt;,           while removing contacts other than the           &lt;tp:member-ref&gt;SelfHandle&lt;/tp:member-ref&gt; from the remote pending list           is allowed if and only if Channel_Group_Flag_Can_Rescind is in the           &lt;tp:member-ref&gt;GroupFlags&lt;/tp:member-ref&gt;.&lt;/p&gt;          &lt;p&gt;A message may be provided along with the request, which will be           sent to the server if supported. See the           Channel_Group_Flag_Message_Remove,           Channel_Group_Flag_Message_Depart,           Channel_Group_Flag_Message_Reject and           Channel_Group_Flag_Message_Rescind           &lt;tp:member-ref&gt;GroupFlags&lt;/tp:member-ref&gt; to see in which cases this           message should be provided.&lt;/p&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_channel_interface_group_run_remove_members:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Contacts: Used to pass an 'in' argument: An array of contact handles to remove from the channel
 * @in_Message: Used to pass an 'in' argument: A string message, which can be blank if desired
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method RemoveMembers and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Requests the removal of contacts from a channel, reject their           request for channel membership on the pending local list, or           rescind their invitation on the pending remote list.&lt;/p&gt;          &lt;p&gt;If the &lt;tp:member-ref&gt;SelfHandle&lt;/tp:member-ref&gt; is in a Group,           it can be removed via this method, in order to leave the group           gracefully. This is the recommended way to leave a chatroom, close           or reject a &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel.Type&quot;&gt;StreamedMedia&lt;/tp:dbus-ref&gt;           call, and so on.&lt;/p&gt;          &lt;p&gt;Accordingly, connection managers SHOULD support           doing this, regardless of the value of           &lt;tp:member-ref&gt;GroupFlags&lt;/tp:member-ref&gt;.           If doing so fails with PermissionDenied, this is considered to a bug           in the connection manager, but clients MUST recover by falling back           to closing the channel with the &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel&quot;&gt;Close&lt;/tp:dbus-ref&gt;           method.&lt;/p&gt;          &lt;p&gt;Removing any contact from the local pending list is always           allowed. Removing contacts other than the           &lt;tp:member-ref&gt;SelfHandle&lt;/tp:member-ref&gt; from the channel&apos;s members           is allowed if and only if Channel_Group_Flag_Can_Remove is in the           &lt;tp:member-ref&gt;GroupFlags&lt;/tp:member-ref&gt;,           while removing contacts other than the           &lt;tp:member-ref&gt;SelfHandle&lt;/tp:member-ref&gt; from the remote pending list           is allowed if and only if Channel_Group_Flag_Can_Rescind is in the           &lt;tp:member-ref&gt;GroupFlags&lt;/tp:member-ref&gt;.&lt;/p&gt;          &lt;p&gt;A message may be provided along with the request, which will be           sent to the server if supported. See the           Channel_Group_Flag_Message_Remove,           Channel_Group_Flag_Message_Depart,           Channel_Group_Flag_Message_Reject and           Channel_Group_Flag_Message_Rescind           &lt;tp:member-ref&gt;GroupFlags&lt;/tp:member-ref&gt; to see in which cases this           message should be provided.&lt;/p&gt;
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_channel_interface_group_callback_for_remove_members_with_reason:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a RemoveMembersWithReason method call
 * succeeds or fails.
 */

/**
 * tp_cli_channel_interface_group_call_remove_members_with_reason:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Contacts: Used to pass an 'in' argument: An array of contact handles to remove from the channel
 * @in_Message: Used to pass an 'in' argument: A string message, which can be blank if desired
 * @in_Reason: Used to pass an 'in' argument: A reason for the change
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a RemoveMembersWithReason method call.
 *
 * As &lt;tp:member-ref&gt;RemoveMembers&lt;/tp:member-ref&gt;, but a reason code may         be provided where         appropriate. The reason code may be ignored if the underlying         protocol is unable to represent the given reason.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_channel_interface_group_run_remove_members_with_reason:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Contacts: Used to pass an 'in' argument: An array of contact handles to remove from the channel
 * @in_Message: Used to pass an 'in' argument: A string message, which can be blank if desired
 * @in_Reason: Used to pass an 'in' argument: A reason for the change
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method RemoveMembersWithReason and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * As &lt;tp:member-ref&gt;RemoveMembers&lt;/tp:member-ref&gt;, but a reason code may         be provided where         appropriate. The reason code may be ignored if the underlying         protocol is unable to represent the given reason.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_channel_interface_hold_signal_callback_hold_state_changed:
 * @proxy: The proxy on which tp_cli_channel_interface_hold_connect_to_hold_state_changed ()
 *  was called
 * @arg_HoldState: The state of the channel
 * @arg_Reason: The reason for the state change
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal HoldStateChanged.
 */

/**
 * tp_cli_channel_interface_hold_connect_to_hold_state_changed:
 * @proxy: A #TpChannel or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal HoldStateChanged.
 *
 * Emitted to indicate that the hold state has changed for this channel.         This may occur as a consequence of you requesting a change with         &lt;tp:member-ref&gt;RequestHold&lt;/tp:member-ref&gt;, or the state changing as a         result of a request from         another process.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_channel_interface_hold_callback_for_get_hold_state:
 * @proxy: the proxy on which the call was made
 * @out_HoldState: Used to return an 'out' argument if @error is %NULL: The state of the channel
 * @out_Reason: Used to return an 'out' argument if @error is %NULL: The reason why the channel is in that state
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetHoldState method call
 * succeeds or fails.
 */

/**
 * tp_cli_channel_interface_hold_call_get_hold_state:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetHoldState method call.
 *
 * Return whether the local user has placed the channel on hold.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_channel_interface_hold_run_get_hold_state:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @out_HoldState: Used to return an 'out' argument if %TRUE is returned: The state of the channel
 * @out_Reason: Used to return an 'out' argument if %TRUE is returned: The reason why the channel is in that state
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetHoldState and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Return whether the local user has placed the channel on hold.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_channel_interface_hold_callback_for_request_hold:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a RequestHold method call
 * succeeds or fails.
 */

/**
 * tp_cli_channel_interface_hold_call_request_hold:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Hold: Used to pass an 'in' argument: A boolean indicating whether or not the channel should be on hold
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a RequestHold method call.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Request that the channel be put on hold (be instructed not to send           any media streams to you) or be taken off hold.&lt;/p&gt;          &lt;p&gt;If the connection manager can immediately tell that the requested           state change could not possibly succeed, this method SHOULD           return the NotAvailable error. If the requested state is the           same as the current state, this method SHOULD return successfully           without doing anything.&lt;/p&gt;          &lt;p&gt;Otherwise, this method SHOULD immediately set the hold state to           Local_Hold_State_Pending_Hold or Local_Hold_State_Pending_Unhold           (as appropriate), emitting           &lt;tp:member-ref&gt;HoldStateChanged&lt;/tp:member-ref&gt; if this is a change,           and return successfully.&lt;/p&gt;          &lt;p&gt;The eventual success or failure of the request is indicated by a           subsequent HoldStateChanged signal, changing the hold state to           Local_Hold_State_Held or Local_Hold_State_Unheld.&lt;/p&gt;          &lt;p&gt;If the channel has multiple streams, and the connection manager           succeeds in changing the hold state of one stream but fails to           change the hold state of another, it SHOULD attempt to revert           all streams to their previous hold states.&lt;/p&gt;          &lt;p&gt;The following state transitions SHOULD be used, where           appropriate:&lt;/p&gt;          &lt;ul&gt;           &lt;li&gt;Successful hold:             (Unheld, any reason) → (Pending_Hold, Requested) →             (Held, Requested)           &lt;/li&gt;           &lt;li&gt;Successful unhold:             (Held, any reason) → (Pending_Unhold, Requested) →             (Unheld, Requested)           &lt;/li&gt;           &lt;li&gt;Attempting to unhold fails at the first attempt to acquire a             resource:             (Held, any reason) → (Pending_Unhold, Requested) →             (Held, Resource_Not_Available)           &lt;/li&gt;           &lt;li&gt;Attempting to unhold acquires one resource, but fails to acquire             a second, and takes time to release the first:             (Held, any reason) → (Pending_Unhold, Requested) →             (Pending_Hold, Resource_Not_Available) →             (Held, Resource_Not_Available)           &lt;/li&gt;         &lt;/ul&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_channel_interface_hold_run_request_hold:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Hold: Used to pass an 'in' argument: A boolean indicating whether or not the channel should be on hold
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method RequestHold and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Request that the channel be put on hold (be instructed not to send           any media streams to you) or be taken off hold.&lt;/p&gt;          &lt;p&gt;If the connection manager can immediately tell that the requested           state change could not possibly succeed, this method SHOULD           return the NotAvailable error. If the requested state is the           same as the current state, this method SHOULD return successfully           without doing anything.&lt;/p&gt;          &lt;p&gt;Otherwise, this method SHOULD immediately set the hold state to           Local_Hold_State_Pending_Hold or Local_Hold_State_Pending_Unhold           (as appropriate), emitting           &lt;tp:member-ref&gt;HoldStateChanged&lt;/tp:member-ref&gt; if this is a change,           and return successfully.&lt;/p&gt;          &lt;p&gt;The eventual success or failure of the request is indicated by a           subsequent HoldStateChanged signal, changing the hold state to           Local_Hold_State_Held or Local_Hold_State_Unheld.&lt;/p&gt;          &lt;p&gt;If the channel has multiple streams, and the connection manager           succeeds in changing the hold state of one stream but fails to           change the hold state of another, it SHOULD attempt to revert           all streams to their previous hold states.&lt;/p&gt;          &lt;p&gt;The following state transitions SHOULD be used, where           appropriate:&lt;/p&gt;          &lt;ul&gt;           &lt;li&gt;Successful hold:             (Unheld, any reason) → (Pending_Hold, Requested) →             (Held, Requested)           &lt;/li&gt;           &lt;li&gt;Successful unhold:             (Held, any reason) → (Pending_Unhold, Requested) →             (Unheld, Requested)           &lt;/li&gt;           &lt;li&gt;Attempting to unhold fails at the first attempt to acquire a             resource:             (Held, any reason) → (Pending_Unhold, Requested) →             (Held, Resource_Not_Available)           &lt;/li&gt;           &lt;li&gt;Attempting to unhold acquires one resource, but fails to acquire             a second, and takes time to release the first:             (Held, any reason) → (Pending_Unhold, Requested) →             (Pending_Hold, Resource_Not_Available) →             (Held, Resource_Not_Available)           &lt;/li&gt;         &lt;/ul&gt;
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_channel_interface_media_signalling_signal_callback_new_session_handler:
 * @proxy: The proxy on which tp_cli_channel_interface_media_signalling_connect_to_new_session_handler ()
 *  was called
 * @arg_Session_Handler: Object path of the new &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy&quot;&gt;Media.SessionHandler&lt;/tp:dbus-ref&gt;           object
 * @arg_Session_Type: String indicating type of session, eg &amp;quot;rtp&amp;quot;
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal NewSessionHandler.
 */

/**
 * tp_cli_channel_interface_media_signalling_connect_to_new_session_handler:
 * @proxy: A #TpChannel or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal NewSessionHandler.
 *
 * Signal that a session handler object has been created. The client         should create a session object and create streams for the streams         within.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_channel_interface_media_signalling_callback_for_get_session_handlers:
 * @proxy: the proxy on which the call was made
 * @out_Session_Handlers: Used to return an 'out' argument if @error is %NULL: (Undocumented)
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetSessionHandlers method call
 * succeeds or fails.
 */

/**
 * tp_cli_channel_interface_media_signalling_call_get_session_handlers:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetSessionHandlers method call.
 *
 * Returns all currently active session handlers on this channel         as a list of (session_handler_path, type).
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_channel_interface_media_signalling_run_get_session_handlers:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @out_Session_Handlers: Used to return an 'out' argument if %TRUE is returned: (Undocumented)
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetSessionHandlers and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Returns all currently active session handlers on this channel         as a list of (session_handler_path, type).
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_channel_interface_messages_signal_callback_message_sent:
 * @proxy: The proxy on which tp_cli_channel_interface_messages_connect_to_message_sent ()
 *  was called
 * @arg_Content: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;The message content (see &lt;tp:type&gt;Message_Part&lt;/tp:type&gt; for full             details). If the message that was passed to             &lt;tp:member-ref&gt;SendMessage&lt;/tp:member-ref&gt; has a formatted text             part that the connection manager recognises, but no             &lt;tt&gt;text/plain&lt;/tt&gt; alternative, the CM MUST use the formatted text             part to generate a &lt;tt&gt;text/plain&lt;/tt&gt; alternative which is also             included in this signal argument.&lt;/p&gt;            &lt;p&gt;If the connection manager can predict that the message will be             altered during transmission, this argument SHOULD reflect what             other contacts will receive, rather than being a copy of the             argument to SendMessage (if the message is truncated,             formatting or alternatives are dropped, etc., then the edited             version SHOULD appear in this signal).&lt;/p&gt;
 * @arg_Flags: &lt;p&gt;Flags affecting how the message was sent.  The flags might be a             subset of those passed to SendMessage if the caller requested             unsupported flags.&lt;/p&gt;
 * @arg_Message_Token: An opaque token used to match any incoming delivery or failure           reports against this message, or an empty string if the message           is not readily identifiable.
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal MessageSent.
 */

/**
 * tp_cli_channel_interface_messages_connect_to_message_sent:
 * @proxy: A #TpChannel or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal MessageSent.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Signals that a message has been submitted for sending. This           MUST be emitted exactly once per emission of the &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel.Type.Text&quot;&gt;Sent&lt;/tp:dbus-ref&gt;           signal on the Text interface, for backwards-compatibility; clients           SHOULD ignore the latter if this interface is present, as mentioned           in the introduction.&lt;/p&gt;          &lt;p&gt;This SHOULD be emitted as soon as the CM determines it&apos;s           theoretically possible to send the message (e.g. the parameters are           supported and correct).&lt;/p&gt;          &lt;tp:rationale&gt;           &lt;p&gt;This signal allows a process that is not the caller of             SendMessage to log sent messages.&lt;/p&gt;         &lt;/tp:rationale&gt;
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_channel_interface_messages_signal_callback_pending_messages_removed:
 * @proxy: The proxy on which tp_cli_channel_interface_messages_connect_to_pending_messages_removed ()
 *  was called
 * @arg_Message_IDs: The messages that have been removed from the pending message list.
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal PendingMessagesRemoved.
 */

/**
 * tp_cli_channel_interface_messages_connect_to_pending_messages_removed:
 * @proxy: A #TpChannel or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal PendingMessagesRemoved.
 *
 * The messages with the given IDs have been removed from the         &lt;tp:member-ref&gt;PendingMessages&lt;/tp:member-ref&gt; list. Clients SHOULD NOT         attempt to acknowledge those messages.          &lt;tp:rationale&gt;           This completes change notification for the PendingMessages property           (previously, there was change notification when pending messages           were added, but not when they were removed).         &lt;/tp:rationale&gt;
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_channel_interface_messages_signal_callback_message_received:
 * @proxy: The proxy on which tp_cli_channel_interface_messages_connect_to_message_received ()
 *  was called
 * @arg_Message: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;The message content, including any attachments or alternatives. If             the incoming message contains formatted text without a plain text             alternative, the connection manager MUST generate a             &lt;tt&gt;text/plain&lt;/tt&gt; alternative from the formatted text, and             include it in this message (both here, and in the             &lt;tp:member-ref&gt;PendingMessages&lt;/tp:member-ref&gt; property).&lt;/p&gt;
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal MessageReceived.
 */

/**
 * tp_cli_channel_interface_messages_connect_to_message_received:
 * @proxy: A #TpChannel or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal MessageReceived.
 *
 * Signals that a message has been received and added to the pending         messages queue. This MUST be emitted exactly once per emission of the         &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel.Type.Text&quot;&gt;Received&lt;/tp:dbus-ref&gt;         signal on the Text interface, for backwards-compatibility; clients         SHOULD ignore the latter in favour of this signal if this interface is         present, as mentioned in the introduction.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_channel_interface_messages_callback_for_send_message:
 * @proxy: the proxy on which the call was made
 * @out_Token: Used to return an 'out' argument if @error is %NULL: An opaque token used to match any incoming delivery or failure           reports against this message, or an empty string if the message           is not readily identifiable.
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a SendMessage method call
 * succeeds or fails.
 */

/**
 * tp_cli_channel_interface_messages_call_send_message:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Message: Used to pass an 'in' argument: The message content, including any attachments or alternatives
 * @in_Flags: Used to pass an 'in' argument: Flags affecting how the message is sent. The channel MAY ignore some           or all flags, depending on           &lt;tp:member-ref&gt;DeliveryReportingSupport&lt;/tp:member-ref&gt;; the flags           that were handled by the CM are provided in           &lt;tp:member-ref&gt;MessageSent&lt;/tp:member-ref&gt;.
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a SendMessage method call.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Submit a message to the server for sending.           If this method returns successfully, the message has been submitted           to the server and the &lt;tp:member-ref&gt;MessageSent&lt;/tp:member-ref&gt;           signal is emitted. A corresponding           &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel.Type.Text&quot;&gt;Sent&lt;/tp:dbus-ref&gt;           signal on the Text interface MUST also be emitted.&lt;/p&gt;          &lt;p&gt;This method MUST return before the MessageSent signal is           emitted.&lt;/p&gt;          &lt;tp:rationale&gt;           &lt;p&gt;This means that the process sending the message is the first             to see the &lt;tp:type&gt;Protocol_Message_Token&lt;/tp:type&gt;, and can             relate the message to the corresponding             &lt;tp:member-ref&gt;MessageSent&lt;/tp:member-ref&gt; signal by comparing             message tokens (if supported by the protocol).&lt;/p&gt;         &lt;/tp:rationale&gt;          &lt;p&gt;If this method fails, message submission to the server has failed           and no signal on this interface (or the Text interface) is           emitted.&lt;/p&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_channel_interface_messages_run_send_message:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Message: Used to pass an 'in' argument: The message content, including any attachments or alternatives
 * @in_Flags: Used to pass an 'in' argument: Flags affecting how the message is sent. The channel MAY ignore some           or all flags, depending on           &lt;tp:member-ref&gt;DeliveryReportingSupport&lt;/tp:member-ref&gt;; the flags           that were handled by the CM are provided in           &lt;tp:member-ref&gt;MessageSent&lt;/tp:member-ref&gt;.
 * @out_Token: Used to return an 'out' argument if %TRUE is returned: An opaque token used to match any incoming delivery or failure           reports against this message, or an empty string if the message           is not readily identifiable.
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method SendMessage and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Submit a message to the server for sending.           If this method returns successfully, the message has been submitted           to the server and the &lt;tp:member-ref&gt;MessageSent&lt;/tp:member-ref&gt;           signal is emitted. A corresponding           &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel.Type.Text&quot;&gt;Sent&lt;/tp:dbus-ref&gt;           signal on the Text interface MUST also be emitted.&lt;/p&gt;          &lt;p&gt;This method MUST return before the MessageSent signal is           emitted.&lt;/p&gt;          &lt;tp:rationale&gt;           &lt;p&gt;This means that the process sending the message is the first             to see the &lt;tp:type&gt;Protocol_Message_Token&lt;/tp:type&gt;, and can             relate the message to the corresponding             &lt;tp:member-ref&gt;MessageSent&lt;/tp:member-ref&gt; signal by comparing             message tokens (if supported by the protocol).&lt;/p&gt;         &lt;/tp:rationale&gt;          &lt;p&gt;If this method fails, message submission to the server has failed           and no signal on this interface (or the Text interface) is           emitted.&lt;/p&gt;
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_channel_interface_messages_callback_for_get_pending_message_content:
 * @proxy: the proxy on which the call was made
 * @out_Content: Used to return an 'out' argument if @error is %NULL: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;The content of the requested parts. The keys in this mapping             are positions in the array of message parts; the values are             either of type &apos;s&apos; or &apos;ay&apos; (UTF-8 text string, or byte array),             following the same rules as for the value of the &apos;content&apos; key in             the &lt;tp:type&gt;Message_Part&lt;/tp:type&gt; mappings.&lt;/p&gt;            &lt;p&gt;If the one of the requested part numbers was greater than zero             but referred to a part that had no content (i.e. it had no             &apos;content-type&apos; key or no &apos;content&apos; key), it is simply omitted from             this mapping; this is not considered to be an error condition.&lt;/p&gt;
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetPendingMessageContent method call
 * succeeds or fails.
 */

/**
 * tp_cli_channel_interface_messages_call_get_pending_message_content:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Message_ID: Used to pass an 'in' argument: The ID of a pending message
 * @in_Parts: Used to pass an 'in' argument: The desired entries in the array of message parts, identified by           their position. The &amp;quot;headers&amp;quot; part (which is not a valid argument           to this method) is considered to be part 0, so the valid part           numbers start at 1 (for the second Message_Part).
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetPendingMessageContent method call.
 *
 * Retrieve the content of one or more parts of a pending message.         Note that this function may take a considerable amount of time         to return if the part&apos;s &apos;needs-retrieval&apos; flag is true; consider         extending the default D-Bus method call timeout. Additional API is         likely to be added in future, to stream large message parts.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_channel_interface_messages_run_get_pending_message_content:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Message_ID: Used to pass an 'in' argument: The ID of a pending message
 * @in_Parts: Used to pass an 'in' argument: The desired entries in the array of message parts, identified by           their position. The &amp;quot;headers&amp;quot; part (which is not a valid argument           to this method) is considered to be part 0, so the valid part           numbers start at 1 (for the second Message_Part).
 * @out_Content: Used to return an 'out' argument if %TRUE is returned: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;The content of the requested parts. The keys in this mapping             are positions in the array of message parts; the values are             either of type &apos;s&apos; or &apos;ay&apos; (UTF-8 text string, or byte array),             following the same rules as for the value of the &apos;content&apos; key in             the &lt;tp:type&gt;Message_Part&lt;/tp:type&gt; mappings.&lt;/p&gt;            &lt;p&gt;If the one of the requested part numbers was greater than zero             but referred to a part that had no content (i.e. it had no             &apos;content-type&apos; key or no &apos;content&apos; key), it is simply omitted from             this mapping; this is not considered to be an error condition.&lt;/p&gt;
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetPendingMessageContent and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Retrieve the content of one or more parts of a pending message.         Note that this function may take a considerable amount of time         to return if the part&apos;s &apos;needs-retrieval&apos; flag is true; consider         extending the default D-Bus method call timeout. Additional API is         likely to be added in future, to stream large message parts.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_channel_interface_password_signal_callback_password_flags_changed:
 * @proxy: The proxy on which tp_cli_channel_interface_password_connect_to_password_flags_changed ()
 *  was called
 * @arg_Added: A bitwise OR of the flags which have been set
 * @arg_Removed: A bitwise OR of the flags which have been cleared
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal PasswordFlagsChanged.
 */

/**
 * tp_cli_channel_interface_password_connect_to_password_flags_changed:
 * @proxy: A #TpChannel or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal PasswordFlagsChanged.
 *
 * Emitted when the flags as returned by         &lt;tp:member-ref&gt;GetPasswordFlags&lt;/tp:member-ref&gt; are changed.         The user interface should be updated as appropriate.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_channel_interface_password_callback_for_get_password_flags:
 * @proxy: the proxy on which the call was made
 * @out_Password_Flags: Used to return an 'out' argument if @error is %NULL: An integer with the logical OR of all the flags set           (values of ChannelPasswordFlags)
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetPasswordFlags method call
 * succeeds or fails.
 */

/**
 * tp_cli_channel_interface_password_call_get_password_flags:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetPasswordFlags method call.
 *
 * Returns the bitwise-OR of the flags relevant to the password on this         channel.  The user interface can use this to present information about         which operations are currently valid.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_channel_interface_password_run_get_password_flags:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @out_Password_Flags: Used to return an 'out' argument if %TRUE is returned: An integer with the logical OR of all the flags set           (values of ChannelPasswordFlags)
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetPasswordFlags and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Returns the bitwise-OR of the flags relevant to the password on this         channel.  The user interface can use this to present information about         which operations are currently valid.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_channel_interface_password_callback_for_provide_password:
 * @proxy: the proxy on which the call was made
 * @out_Correct: Used to return an 'out' argument if @error is %NULL: A boolean indicating whether or not the password was correct
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a ProvidePassword method call
 * succeeds or fails.
 */

/**
 * tp_cli_channel_interface_password_call_provide_password:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Password: Used to pass an 'in' argument: The password
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a ProvidePassword method call.
 *
 * Provide the password so that the channel can be joined. Must be         called with the correct password in order for channel joining to         proceed if the &apos;provide&apos; password flag is set.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_channel_interface_password_run_provide_password:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Password: Used to pass an 'in' argument: The password
 * @out_Correct: Used to return an 'out' argument if %TRUE is returned: A boolean indicating whether or not the password was correct
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method ProvidePassword and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Provide the password so that the channel can be joined. Must be         called with the correct password in order for channel joining to         proceed if the &apos;provide&apos; password flag is set.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_channel_interface_service_point_signal_callback_service_point_changed:
 * @proxy: The proxy on which tp_cli_channel_interface_service_point_connect_to_service_point_changed ()
 *  was called
 * @arg_Service_Point: The new service point that is being used.
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal ServicePointChanged.
 */

/**
 * tp_cli_channel_interface_service_point_connect_to_service_point_changed:
 * @proxy: A #TpChannel or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal ServicePointChanged.
 *
 * &lt;p&gt;Emitted when a channel changes the service point that it&apos;s connected to.  This         might be a new call being connected to a service, a call connected to         a service being routed to a different service         (ie, an emergency call being routed from a generic emergency PSAP to         a poison control PSAP), or any number of other things.&lt;/p&gt;          &lt;p&gt;Note that this should be emitted as soon as the CM has been notified         of the switch, and has updated its internal state.  The CM MAY still         be in the process of connecting to the new service point.&lt;/p&gt;
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_channel_interface_tube_signal_callback_tube_channel_state_changed:
 * @proxy: The proxy on which tp_cli_channel_interface_tube_connect_to_tube_channel_state_changed ()
 *  was called
 * @arg_State: The new state of the tube.
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal TubeChannelStateChanged.
 */

/**
 * tp_cli_channel_interface_tube_connect_to_tube_channel_state_changed:
 * @proxy: A #TpChannel or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal TubeChannelStateChanged.
 *
 * Emitted when the state of the tube channel changes. Valid state         transitions are documented with &lt;tp:type&gt;Tube_Channel_State&lt;/tp:type&gt;.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_channel_type_contact_search_signal_callback_search_state_changed:
 * @proxy: The proxy on which tp_cli_channel_type_contact_search_connect_to_search_state_changed ()
 *  was called
 * @arg_State: The new search state
 * @arg_Error: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           If the new state is &lt;code&gt;Failed&lt;/code&gt;, the name of a D-Bus error           describing what went wrong. Otherwise, the empty string.
 * @arg_Details: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;Additional information about the state transition, which may             include the following well-known keys:&lt;/p&gt;            &lt;dl&gt;             &lt;dt&gt;debug-message (s)&lt;/dt&gt;             &lt;dd&gt;Debugging information on the change, corresponding to the               message part of a D-Bus error message, which SHOULD NOT be               displayed to users under normal circumstances&lt;/dd&gt;           &lt;/dl&gt;            &lt;tp:rationale&gt;             &lt;p&gt;This argument allows for future extensions. For instance,               if moving to state &lt;code&gt;Failed&lt;/code&gt; because the server               rejected one of our search terms, we could define a key               that indicates which terms were invalid.&lt;/p&gt;           &lt;/tp:rationale&gt;
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal SearchStateChanged.
 */

/**
 * tp_cli_channel_type_contact_search_connect_to_search_state_changed:
 * @proxy: A #TpChannel or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal SearchStateChanged.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Emitted when the &lt;tp:member-ref&gt;SearchState&lt;/tp:member-ref&gt; property           changes. The implementation MUST NOT make transitions other than the           following:&lt;/p&gt;          &lt;ul&gt;           &lt;li&gt;&lt;code&gt;Not_Started&lt;/code&gt; → &lt;code&gt;In_Progress&lt;/code&gt;&lt;/li&gt;           &lt;li&gt;&lt;code&gt;In_Progress&lt;/code&gt; → &lt;code&gt;More_Available&lt;/code&gt;&lt;/li&gt;           &lt;li&gt;&lt;code&gt;More_Available&lt;/code&gt; → &lt;code&gt;In_Progress&lt;/code&gt;&lt;/li&gt;           &lt;li&gt;&lt;code&gt;In_Progress&lt;/code&gt; → &lt;code&gt;Completed&lt;/code&gt;&lt;/li&gt;           &lt;li&gt;&lt;code&gt;In_Progress&lt;/code&gt; → &lt;code&gt;Failed&lt;/code&gt;&lt;/li&gt;         &lt;/ul&gt;
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_channel_type_contact_search_signal_callback_search_result_received:
 * @proxy: The proxy on which tp_cli_channel_type_contact_search_connect_to_search_result_received ()
 *  was called
 * @arg_Result: A mapping from contact identifier to an array of fields           representing information about this contact.
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal SearchResultReceived.
 */

/**
 * tp_cli_channel_type_contact_search_connect_to_search_result_received:
 * @proxy: A #TpChannel or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal SearchResultReceived.
 *
 * Emitted when a some search results are received from the server.         This signal can be fired arbitrarily many times so clients MUST NOT         assume they&apos;ll get only one signal.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_channel_type_contact_search_callback_for_search:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a Search method call
 * succeeds or fails.
 */

/**
 * tp_cli_channel_type_contact_search_call_search:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Terms: Used to pass an 'in' argument: A dictionary mapping search key names to the desired values
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a Search method call.
 *
 * Send a request to start a search for contacts on this connection. This         may only be called while the &lt;tp:member-ref&gt;SearchState&lt;/tp:member-ref&gt;         is Not_Started; a valid search request will cause the         &lt;tp:member-ref&gt;SearchStateChanged&lt;/tp:member-ref&gt; signal to be emitted         with the state In_Progress.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_channel_type_contact_search_run_search:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Terms: Used to pass an 'in' argument: A dictionary mapping search key names to the desired values
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method Search and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Send a request to start a search for contacts on this connection. This         may only be called while the &lt;tp:member-ref&gt;SearchState&lt;/tp:member-ref&gt;         is Not_Started; a valid search request will cause the         &lt;tp:member-ref&gt;SearchStateChanged&lt;/tp:member-ref&gt; signal to be emitted         with the state In_Progress.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_channel_type_contact_search_callback_for_more:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a More method call
 * succeeds or fails.
 */

/**
 * tp_cli_channel_type_contact_search_call_more:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a More method call.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         Request that a search in &lt;tp:member-ref&gt;SearchState&lt;/tp:member-ref&gt;         &lt;code&gt;More_Available&lt;/code&gt; move back to state &lt;code&gt;In_Progress&lt;/code&gt;         and continue listing up to &lt;tp:member-ref&gt;Limit&lt;/tp:member-ref&gt; more results.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_channel_type_contact_search_run_more:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method More and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         Request that a search in &lt;tp:member-ref&gt;SearchState&lt;/tp:member-ref&gt;         &lt;code&gt;More_Available&lt;/code&gt; move back to state &lt;code&gt;In_Progress&lt;/code&gt;         and continue listing up to &lt;tp:member-ref&gt;Limit&lt;/tp:member-ref&gt; more results.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_channel_type_contact_search_callback_for_stop:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a Stop method call
 * succeeds or fails.
 */

/**
 * tp_cli_channel_type_contact_search_call_stop:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a Stop method call.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Stop the current search. This may not be called while the           &lt;tp:member-ref&gt;SearchState&lt;/tp:member-ref&gt; is Not_Started. If called           while the SearchState is In_Progress,           &lt;tp:member-ref&gt;SearchStateChanged&lt;/tp:member-ref&gt; will be emitted,           with the state Failed and the error           &lt;code&gt;org.freedesktop.Telepathy.Errors.Cancelled&lt;/code&gt;.&lt;/p&gt;          &lt;p&gt;Calling this method on a search in state Completed or Failed           succeeds, but has no effect.&lt;/p&gt;          &lt;tp:rationale&gt;           &lt;p&gt;Specifying Stop to succeed when the search has finished means that             clients who call Stop just before receiving             &lt;tp:member-ref&gt;SearchStateChanged&lt;/tp:member-ref&gt; don&apos;t have to             handle a useless error.&lt;/p&gt;         &lt;/tp:rationale&gt;          &lt;p&gt;Depending on the protocol, the connection manager may not be           able to prevent the server from sending further results after this           method returns; if this is the case, it MUST ignore any further           results.&lt;/p&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_channel_type_contact_search_run_stop:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method Stop and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Stop the current search. This may not be called while the           &lt;tp:member-ref&gt;SearchState&lt;/tp:member-ref&gt; is Not_Started. If called           while the SearchState is In_Progress,           &lt;tp:member-ref&gt;SearchStateChanged&lt;/tp:member-ref&gt; will be emitted,           with the state Failed and the error           &lt;code&gt;org.freedesktop.Telepathy.Errors.Cancelled&lt;/code&gt;.&lt;/p&gt;          &lt;p&gt;Calling this method on a search in state Completed or Failed           succeeds, but has no effect.&lt;/p&gt;          &lt;tp:rationale&gt;           &lt;p&gt;Specifying Stop to succeed when the search has finished means that             clients who call Stop just before receiving             &lt;tp:member-ref&gt;SearchStateChanged&lt;/tp:member-ref&gt; don&apos;t have to             handle a useless error.&lt;/p&gt;         &lt;/tp:rationale&gt;          &lt;p&gt;Depending on the protocol, the connection manager may not be           able to prevent the server from sending further results after this           method returns; if this is the case, it MUST ignore any further           results.&lt;/p&gt;
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_channel_type_dbus_tube_signal_callback_dbus_names_changed:
 * @proxy: The proxy on which tp_cli_channel_type_dbus_tube_connect_to_dbus_names_changed ()
 *  was called
 * @arg_Added: Array of handles and D-Bus names of new participants.
 * @arg_Removed: Array of handles of former participants.
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal DBusNamesChanged.
 */

/**
 * tp_cli_channel_type_dbus_tube_connect_to_dbus_names_changed:
 * @proxy: A #TpChannel or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal DBusNamesChanged.
 *
 * Emitted on a multi-user (i.e. Handle_Type_Room) D-Bus tube when a         participant opens or closes the tube.  This provides change         notification for the &lt;tp:member-ref&gt;DBusNames&lt;/tp:member-ref&gt; property.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_channel_type_dbus_tube_callback_for_offer:
 * @proxy: the proxy on which the call was made
 * @out_address: Used to return an 'out' argument if @error is %NULL: The string describing the address of the private bus. The client           SHOULD NOT attempt to connect to the address until the tube is open.
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a Offer method call
 * succeeds or fails.
 */

/**
 * tp_cli_channel_type_dbus_tube_call_offer:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_parameters: Used to pass an 'in' argument: The dictionary of arbitrary           &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel.Interface.Tube&quot;&gt;Parameters&lt;/tp:dbus-ref&gt;           to send with the tube offer.
 * @in_access_control: Used to pass an 'in' argument: The access control the connection manager applies to the D-Bus socket.
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a Offer method call.
 *
 * Offers a D-Bus tube providing the service specified.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_channel_type_dbus_tube_run_offer:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_parameters: Used to pass an 'in' argument: The dictionary of arbitrary           &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel.Interface.Tube&quot;&gt;Parameters&lt;/tp:dbus-ref&gt;           to send with the tube offer.
 * @in_access_control: Used to pass an 'in' argument: The access control the connection manager applies to the D-Bus socket.
 * @out_address: Used to return an 'out' argument if %TRUE is returned: The string describing the address of the private bus. The client           SHOULD NOT attempt to connect to the address until the tube is open.
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method Offer and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Offers a D-Bus tube providing the service specified.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_channel_type_dbus_tube_callback_for_accept:
 * @proxy: the proxy on which the call was made
 * @out_address: Used to return an 'out' argument if @error is %NULL: The string describing the address of the private bus. The client           SHOULD NOT attempt to connect to the address until the tube is open.
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a Accept method call
 * succeeds or fails.
 */

/**
 * tp_cli_channel_type_dbus_tube_call_accept:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_access_control: Used to pass an 'in' argument: The access control the connection manager applies to the D-Bus socket.
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a Accept method call.
 *
 * Accept a D-Bus tube that&apos;s in the &amp;quot;local pending&amp;quot; state. The         connection manager will attempt to open the tube. The tube remains in         the &amp;quot;local pending&amp;quot; state until the &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel.Interface.Tube&quot;&gt;TubeChannelStateChanged&lt;/tp:dbus-ref&gt;         signal is emitted.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_channel_type_dbus_tube_run_accept:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_access_control: Used to pass an 'in' argument: The access control the connection manager applies to the D-Bus socket.
 * @out_address: Used to return an 'out' argument if %TRUE is returned: The string describing the address of the private bus. The client           SHOULD NOT attempt to connect to the address until the tube is open.
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method Accept and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Accept a D-Bus tube that&apos;s in the &amp;quot;local pending&amp;quot; state. The         connection manager will attempt to open the tube. The tube remains in         the &amp;quot;local pending&amp;quot; state until the &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel.Interface.Tube&quot;&gt;TubeChannelStateChanged&lt;/tp:dbus-ref&gt;         signal is emitted.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_channel_type_file_transfer_signal_callback_file_transfer_state_changed:
 * @proxy: The proxy on which tp_cli_channel_type_file_transfer_connect_to_file_transfer_state_changed ()
 *  was called
 * @arg_State: The new state of the file transfer; see the File_Transfer_State enumeration.
 * @arg_Reason: The reason for the state change; see the File_Transfer_State_Change_Reason           enumeration.           The value will always be File_Transfer_State_Change_Reason_None, except           when changing state to cancelled.
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal FileTransferStateChanged.
 */

/**
 * tp_cli_channel_type_file_transfer_connect_to_file_transfer_state_changed:
 * @proxy: A #TpChannel or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal FileTransferStateChanged.
 *
 * Emitted when the state of a file transfer changes.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_channel_type_file_transfer_signal_callback_transferred_bytes_changed:
 * @proxy: The proxy on which tp_cli_channel_type_file_transfer_connect_to_transferred_bytes_changed ()
 *  was called
 * @arg_Count: The number of already transferred bytes.
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal TransferredBytesChanged.
 */

/**
 * tp_cli_channel_type_file_transfer_connect_to_transferred_bytes_changed:
 * @proxy: A #TpChannel or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal TransferredBytesChanged.
 *
 * Emitted when the number of transferred bytes changes. This will not be         signalled with every single byte change. Instead, the most frequent         this signal will be emitted is once a second. This should be         sufficient, and the &lt;tp:member-ref&gt;TransferredBytes&lt;/tp:member-ref&gt;         property SHOULD NOT be polled.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_channel_type_file_transfer_signal_callback_initial_offset_defined:
 * @proxy: The proxy on which tp_cli_channel_type_file_transfer_connect_to_initial_offset_defined ()
 *  was called
 * @arg_InitialOffset: The value of the &lt;tp:member-ref&gt;InitialOffset&lt;/tp:member-ref&gt; property.
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal InitialOffsetDefined.
 */

/**
 * tp_cli_channel_type_file_transfer_connect_to_initial_offset_defined:
 * @proxy: A #TpChannel or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal InitialOffsetDefined.
 *
 * Emitted when the value of the &lt;tp:member-ref&gt;InitialOffset&lt;/tp:member-ref&gt;         property has been negotiated. This signal MUST be emitted before the channel         becomes Open and clients have to use this offset when transferring the         file.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_channel_type_file_transfer_callback_for_accept_file:
 * @proxy: the proxy on which the call was made
 * @out_Address: Used to return an 'out' argument if @error is %NULL: The address on which the connection manager will listen for           connections for this file transfer.
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a AcceptFile method call
 * succeeds or fails.
 */

/**
 * tp_cli_channel_type_file_transfer_call_accept_file:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Address_Type: Used to pass an 'in' argument: The type of address the connection manager should listen on.
 * @in_Access_Control: Used to pass an 'in' argument: The type of access control the connection manager should apply to           the socket.
 * @in_Access_Control_Param: Used to pass an 'in' argument: A parameter for the access control type, to be interpreted as           specified in the documentation for the Socket_Access_Control enum.
 * @in_Offset: Used to pass an 'in' argument: The desired offset in bytes where the file transfer should start.           The offset is taken from the beginning of the file. Specifying an           offset of zero will start the transfer from the beginning of the           file. The offset that is actually given in the           &lt;tp:member-ref&gt;InitialOffset&lt;/tp:member-ref&gt; property can differ           from this argument where the requested offset is not supported.           (For example, some protocols do not support offsets at all so           the InitialOffset property will always be 0.)
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a AcceptFile method call.
 *
 * Accept a file transfer that&apos;s in the Pending state. The file         transfer&apos;s state becomes Accepted after this method is called.         At this point the client can connect to the socket. CM MUST emit         &lt;tp:member-ref&gt;InitialOffsetDefined&lt;/tp:member-ref&gt; and change         the state to Open before writing to the socket.         Then &lt;tp:member-ref&gt;InitialOffset&lt;/tp:member-ref&gt; should be respected in case         its value differs from the offset that was specified as an argument         to AcceptFile.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_channel_type_file_transfer_run_accept_file:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Address_Type: Used to pass an 'in' argument: The type of address the connection manager should listen on.
 * @in_Access_Control: Used to pass an 'in' argument: The type of access control the connection manager should apply to           the socket.
 * @in_Access_Control_Param: Used to pass an 'in' argument: A parameter for the access control type, to be interpreted as           specified in the documentation for the Socket_Access_Control enum.
 * @in_Offset: Used to pass an 'in' argument: The desired offset in bytes where the file transfer should start.           The offset is taken from the beginning of the file. Specifying an           offset of zero will start the transfer from the beginning of the           file. The offset that is actually given in the           &lt;tp:member-ref&gt;InitialOffset&lt;/tp:member-ref&gt; property can differ           from this argument where the requested offset is not supported.           (For example, some protocols do not support offsets at all so           the InitialOffset property will always be 0.)
 * @out_Address: Used to return an 'out' argument if %TRUE is returned: The address on which the connection manager will listen for           connections for this file transfer.
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method AcceptFile and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Accept a file transfer that&apos;s in the Pending state. The file         transfer&apos;s state becomes Accepted after this method is called.         At this point the client can connect to the socket. CM MUST emit         &lt;tp:member-ref&gt;InitialOffsetDefined&lt;/tp:member-ref&gt; and change         the state to Open before writing to the socket.         Then &lt;tp:member-ref&gt;InitialOffset&lt;/tp:member-ref&gt; should be respected in case         its value differs from the offset that was specified as an argument         to AcceptFile.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_channel_type_file_transfer_callback_for_provide_file:
 * @proxy: the proxy on which the call was made
 * @out_Address: Used to return an 'out' argument if @error is %NULL: The address on which the connection manager will listen for           connections for this file transfer.
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a ProvideFile method call
 * succeeds or fails.
 */

/**
 * tp_cli_channel_type_file_transfer_call_provide_file:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Address_Type: Used to pass an 'in' argument: The type of address the connection manager should listen on.
 * @in_Access_Control: Used to pass an 'in' argument: The type of access control the connection manager should apply to           the socket.
 * @in_Access_Control_Param: Used to pass an 'in' argument: A parameter for the access control type, to be interpreted as           specified in the documentation for the Socket_Access_Control enum.
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a ProvideFile method call.
 *
 * Provide the file for an outgoing file transfer which has been offered.         Opens a socket that the client can use to provide a file to the connection manager.         The channel MUST have been requested, and will change state         to Open when this method is called if its state was Accepted.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_channel_type_file_transfer_run_provide_file:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Address_Type: Used to pass an 'in' argument: The type of address the connection manager should listen on.
 * @in_Access_Control: Used to pass an 'in' argument: The type of access control the connection manager should apply to           the socket.
 * @in_Access_Control_Param: Used to pass an 'in' argument: A parameter for the access control type, to be interpreted as           specified in the documentation for the Socket_Access_Control enum.
 * @out_Address: Used to return an 'out' argument if %TRUE is returned: The address on which the connection manager will listen for           connections for this file transfer.
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method ProvideFile and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Provide the file for an outgoing file transfer which has been offered.         Opens a socket that the client can use to provide a file to the connection manager.         The channel MUST have been requested, and will change state         to Open when this method is called if its state was Accepted.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_channel_type_room_list_signal_callback_got_rooms:
 * @proxy: The proxy on which tp_cli_channel_type_room_list_connect_to_got_rooms ()
 *  was called
 * @arg_Rooms: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           An array of structs containing:           &lt;ul&gt;             &lt;li&gt;an integer room handle&lt;/li&gt;             &lt;li&gt;a string representing the D-Bus interface name of the channel type&lt;/li&gt;             &lt;li&gt;a dictionary mapping string keys to variant boxed information&lt;/li&gt;           &lt;/ul&gt;
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal GotRooms.
 */

/**
 * tp_cli_channel_type_room_list_connect_to_got_rooms:
 * @proxy: A #TpChannel or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal GotRooms.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Emitted when information about rooms on the server becomes available.         The array contains the room handle (as can be passed to the         &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Connection&quot;&gt;RequestChannel&lt;/tp:dbus-ref&gt;         method with HANDLE_TYPE_ROOM), the channel         type, and a dictionary containing further information about the         room as available. The following well-known keys and types are         recommended for use where appropriate:&lt;/p&gt;          &lt;dl&gt;           &lt;dt&gt;handle-name (s)&lt;/dt&gt;           &lt;dd&gt;The identifier of the room (as would be returned by             &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Connection&quot;&gt;InspectHandles&lt;/tp:dbus-ref&gt;)&lt;/dd&gt;            &lt;dt&gt;name (s)&lt;/dt&gt;           &lt;dd&gt;The human-readable name of the room if different from the handle&lt;/dd&gt;            &lt;dt&gt;description (s)&lt;/dt&gt;           &lt;dd&gt;A description of the room&apos;s overall purpose&lt;/dd&gt;            &lt;dt&gt;subject (s)&lt;/dt&gt;           &lt;dd&gt;The current subject of conversation in the room (as would             be returned by getting the string part of the &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel.Interface.Room.DRAFT&quot;&gt;Subject&lt;/tp:dbus-ref&gt; property)&lt;/dd&gt;            &lt;dt&gt;members (u)&lt;/dt&gt;           &lt;dd&gt;The number of members in the room&lt;/dd&gt;            &lt;dt&gt;password (b)&lt;/dt&gt;           &lt;dd&gt;True if the room requires a password to enter&lt;/dd&gt;            &lt;dt&gt;invite-only (b)&lt;/dt&gt;           &lt;dd&gt;True if you cannot join the room, but must be invited&lt;/dd&gt;            &lt;dt&gt;room-id (s)&lt;/dt&gt;           &lt;dd&gt;The human-readable identifier of a chat room (as would be             returned by getting the &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel.Interface.Room.DRAFT&quot;&gt;RoomID&lt;/tp:dbus-ref&gt; property)&lt;/dd&gt;            &lt;dt&gt;server (s)&lt;/dt&gt;           &lt;dd&gt;The DNS name of the server hosting these channels (as would be             returned by getting the &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel.Interface.Room.DRAFT&quot;&gt;Server&lt;/tp:dbus-ref&gt; property)&lt;/dd&gt;         &lt;/dl&gt;
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_channel_type_room_list_signal_callback_listing_rooms:
 * @proxy: The proxy on which tp_cli_channel_type_room_list_connect_to_listing_rooms ()
 *  was called
 * @arg_Listing: A boolean indicating if room listing is in progress
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal ListingRooms.
 */

/**
 * tp_cli_channel_type_room_list_connect_to_listing_rooms:
 * @proxy: A #TpChannel or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal ListingRooms.
 *
 * Emitted to indicate whether or not room listing request is currently         in progress.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_channel_type_room_list_callback_for_get_listing_rooms:
 * @proxy: the proxy on which the call was made
 * @out_In_Progress: Used to return an 'out' argument if @error is %NULL: A boolean indicating if room listing is in progress
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetListingRooms method call
 * succeeds or fails.
 */

/**
 * tp_cli_channel_type_room_list_call_get_listing_rooms:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetListingRooms method call.
 *
 * Check to see if there is already a room list request in progress         on this channel.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_channel_type_room_list_run_get_listing_rooms:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @out_In_Progress: Used to return an 'out' argument if %TRUE is returned: A boolean indicating if room listing is in progress
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetListingRooms and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Check to see if there is already a room list request in progress         on this channel.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_channel_type_room_list_callback_for_list_rooms:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a ListRooms method call
 * succeeds or fails.
 */

/**
 * tp_cli_channel_type_room_list_call_list_rooms:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a ListRooms method call.
 *
 * Request the list of rooms from the server. The         &lt;tp:member-ref&gt;ListingRooms&lt;/tp:member-ref&gt; (True) signal should be         emitted when this request is being processed,         &lt;tp:member-ref&gt;GotRooms&lt;/tp:member-ref&gt; when any room information is         received, and &lt;tp:member-ref&gt;ListingRooms&lt;/tp:member-ref&gt; (False) when         the request is complete.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_channel_type_room_list_run_list_rooms:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method ListRooms and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Request the list of rooms from the server. The         &lt;tp:member-ref&gt;ListingRooms&lt;/tp:member-ref&gt; (True) signal should be         emitted when this request is being processed,         &lt;tp:member-ref&gt;GotRooms&lt;/tp:member-ref&gt; when any room information is         received, and &lt;tp:member-ref&gt;ListingRooms&lt;/tp:member-ref&gt; (False) when         the request is complete.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_channel_type_room_list_callback_for_stop_listing:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a StopListing method call
 * succeeds or fails.
 */

/**
 * tp_cli_channel_type_room_list_call_stop_listing:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a StopListing method call.
 *
 * Stop the room listing if it&apos;s in progress, but don&apos;t close the channel.         The &lt;tp:member-ref&gt;ListingRooms&lt;/tp:member-ref&gt; (False) signal should         be emitted when the listing stops.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_channel_type_room_list_run_stop_listing:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method StopListing and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Stop the room listing if it&apos;s in progress, but don&apos;t close the channel.         The &lt;tp:member-ref&gt;ListingRooms&lt;/tp:member-ref&gt; (False) signal should         be emitted when the listing stops.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_channel_type_stream_tube_signal_callback_new_remote_connection:
 * @proxy: The proxy on which tp_cli_channel_type_stream_tube_connect_to_new_remote_connection ()
 *  was called
 * @arg_Handle: The handle of the participant who opened the new connection
 * @arg_Connection_Param: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;A parameter which can be used by the listening process to identify           the connection. Note that this parameter has a meaningful value           only in the Socket_Access_Control_Port and           Socket_Access_Control_Credentials cases. If a different           Socket_Access_Control has been chosen when offering the tube, this           parameter should be ignored.&lt;/p&gt;            &lt;p&gt;In the Socket_Access_Control_Port case, the variant           contains a struct Socket_Address_IPv4 (or Socket_Address_IPv6)           containing the address from which the CM is connected to the client           application.&lt;/p&gt;            &lt;p&gt;In the Socket_Access_Control_Credentials case, the variant           contains the byte (D-Bus signature &apos;y&apos;) that has been sent with           the credentials.&lt;/p&gt;
 * @arg_Connection_ID: The unique ID associated with this connection. This ID will be used           to identifiy the connection when reporting errors with           &lt;tp:member-ref&gt;ConnectionClosed&lt;/tp:member-ref&gt;.
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal NewRemoteConnection.
 */

/**
 * tp_cli_channel_type_stream_tube_connect_to_new_remote_connection:
 * @proxy: A #TpChannel or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal NewRemoteConnection.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Emitted each time a participant opens a new connection to its         socket.&lt;/p&gt;          &lt;p&gt;This signal is only fired on the offering side.&lt;/p&gt;
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_channel_type_stream_tube_signal_callback_new_local_connection:
 * @proxy: The proxy on which tp_cli_channel_type_stream_tube_connect_to_new_local_connection ()
 *  was called
 * @arg_Connection_ID: The unique ID associated with this connection. This ID will be used           to identifiy the connection when reporting errors with           &lt;tp:member-ref&gt;ConnectionClosed&lt;/tp:member-ref&gt;.
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal NewLocalConnection.
 */

/**
 * tp_cli_channel_type_stream_tube_connect_to_new_local_connection:
 * @proxy: A #TpChannel or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal NewLocalConnection.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Emitted when the tube application connects to the CM&apos;s socket.&lt;/p&gt;          &lt;p&gt;This signal is only fired on the accepting side.&lt;/p&gt;
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_channel_type_stream_tube_signal_callback_connection_closed:
 * @proxy: The proxy on which tp_cli_channel_type_stream_tube_connect_to_connection_closed ()
 *  was called
 * @arg_Connection_ID: The ID of the connection.
 * @arg_Error: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;The name of a D-Bus error describing the error that occurred.&lt;/p&gt;            &lt;p&gt;The following errors can be used:&lt;/p&gt;           &lt;ul&gt;             &lt;li&gt;&lt;code&gt;org.freedesktop.Telepathy.Error.Cancelled&lt;/code&gt;:                user closed the socket or the tube.&lt;/li&gt;             &lt;li&gt;&lt;code&gt;org.freedesktop.Telepathy.Error.ConnectionLost&lt;/code&gt;:                the bytestream relaying connection&apos;s data has been broken.&lt;/li&gt;             &lt;li&gt;&lt;code&gt;org.freedesktop.Telepathy.Error.ConnectionRefused&lt;/code&gt;:                the tube offer refused the connection.&lt;/li&gt;           &lt;/ul&gt;
 * @arg_Message: A debug message.
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal ConnectionClosed.
 */

/**
 * tp_cli_channel_type_stream_tube_connect_to_connection_closed:
 * @proxy: A #TpChannel or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal ConnectionClosed.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Emitted when a connection has been closed.&lt;/p&gt;
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_channel_type_stream_tube_callback_for_offer:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a Offer method call
 * succeeds or fails.
 */

/**
 * tp_cli_channel_type_stream_tube_call_offer:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_address_type: Used to pass an 'in' argument: The type of the listening address of the local service, as a member of           Socket_Address_Type.
 * @in_address: Used to pass an 'in' argument: The listening address of the local service, as indicated by the           address_type.
 * @in_access_control: Used to pass an 'in' argument: The access control the local service applies to the local socket,           specified so the connection manager can behave appropriately           when it connects.
 * @in_parameters: Used to pass an 'in' argument: The dictionary of arbitrary           &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel.Interface.Tube&quot;&gt;Parameters&lt;/tp:dbus-ref&gt;           to send with the tube offer.
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a Offer method call.
 *
 * Offer a stream tube exporting the local socket specified.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_channel_type_stream_tube_run_offer:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_address_type: Used to pass an 'in' argument: The type of the listening address of the local service, as a member of           Socket_Address_Type.
 * @in_address: Used to pass an 'in' argument: The listening address of the local service, as indicated by the           address_type.
 * @in_access_control: Used to pass an 'in' argument: The access control the local service applies to the local socket,           specified so the connection manager can behave appropriately           when it connects.
 * @in_parameters: Used to pass an 'in' argument: The dictionary of arbitrary           &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel.Interface.Tube&quot;&gt;Parameters&lt;/tp:dbus-ref&gt;           to send with the tube offer.
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method Offer and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Offer a stream tube exporting the local socket specified.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_channel_type_stream_tube_callback_for_accept:
 * @proxy: the proxy on which the call was made
 * @out_address: Used to return an 'out' argument if @error is %NULL: The address on which the connection manager will listen for           connections to this tube. The client should not attempt to connect           to the address until the tube is open.
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a Accept method call
 * succeeds or fails.
 */

/**
 * tp_cli_channel_type_stream_tube_call_accept:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_address_type: Used to pass an 'in' argument: The type of address the connection manager should listen on.
 * @in_access_control: Used to pass an 'in' argument: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;The type of access control the connection manager should apply to           the socket.&lt;/p&gt;            &lt;p&gt;Note that if you plan to establish more than one connection           through the tube, the Socket_Access_Control_Port access control           can&apos;t be used as you can&apos;t connect more than once from the same           port.&lt;/p&gt;
 * @in_access_control_param: Used to pass an 'in' argument: A parameter for the access control type, to be interpreted as           specified in the documentation for the Socket_Access_Control enum.
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a Accept method call.
 *
 * Accept a stream tube that&apos;s in the &amp;quot;local pending&amp;quot; state. The         connection manager will attempt to open the tube. The tube remains in         the &amp;quot;local pending&amp;quot; state until the &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel.Interface.Tube&quot;&gt;TubeChannelStateChanged&lt;/tp:dbus-ref&gt;         signal is emitted.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_channel_type_stream_tube_run_accept:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_address_type: Used to pass an 'in' argument: The type of address the connection manager should listen on.
 * @in_access_control: Used to pass an 'in' argument: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;The type of access control the connection manager should apply to           the socket.&lt;/p&gt;            &lt;p&gt;Note that if you plan to establish more than one connection           through the tube, the Socket_Access_Control_Port access control           can&apos;t be used as you can&apos;t connect more than once from the same           port.&lt;/p&gt;
 * @in_access_control_param: Used to pass an 'in' argument: A parameter for the access control type, to be interpreted as           specified in the documentation for the Socket_Access_Control enum.
 * @out_address: Used to return an 'out' argument if %TRUE is returned: The address on which the connection manager will listen for           connections to this tube. The client should not attempt to connect           to the address until the tube is open.
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method Accept and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Accept a stream tube that&apos;s in the &amp;quot;local pending&amp;quot; state. The         connection manager will attempt to open the tube. The tube remains in         the &amp;quot;local pending&amp;quot; state until the &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel.Interface.Tube&quot;&gt;TubeChannelStateChanged&lt;/tp:dbus-ref&gt;         signal is emitted.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_channel_type_streamed_media_signal_callback_stream_added:
 * @proxy: The proxy on which tp_cli_channel_type_streamed_media_connect_to_stream_added ()
 *  was called
 * @arg_Stream_ID: The stream identifier (as defined in           &lt;tp:member-ref&gt;ListStreams&lt;/tp:member-ref&gt;)
 * @arg_Contact_Handle: The contact handle who the stream is with (or 0 if it           represents more than a single member)
 * @arg_Stream_Type: The stream type (a value from MediaStreamType)
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal StreamAdded.
 */

/**
 * tp_cli_channel_type_streamed_media_connect_to_stream_added:
 * @proxy: A #TpChannel or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal StreamAdded.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Emitted when a new stream has been added to this channel.           Clients SHOULD assume that the stream&apos;s           &lt;tp:type&gt;Media_Stream_State&lt;/tp:type&gt; is initially Disconnected.&lt;/p&gt;          &lt;p&gt;If a connection manager needs to represent the addition of a stream           whose state is already Connecting or Connected, it MUST do this           by emitting StreamAdded, closely followed by           &lt;tp:member-ref&gt;StreamStateChanged&lt;/tp:member-ref&gt; indicating a           change to the appropriate state.&lt;/p&gt;          &lt;tp:rationale&gt;           &lt;p&gt;Historically, it was not clear from the StreamAdded signal what             the state of the stream was. telepathy-spec 0.17.22             clarified this.&lt;/p&gt;         &lt;/tp:rationale&gt;          &lt;p&gt;Similarly, clients SHOULD assume that the initial           &lt;tp:type&gt;Media_Stream_Direction&lt;/tp:type&gt; of a newly added stream           is Receive, and that the initial           &lt;tp:type&gt;Media_Stream_Pending_Send&lt;/tp:type&gt; is           Pending_Local_Send.&lt;/p&gt;          &lt;p&gt;If a connection manager needs to represent the addition of a stream           whose direction or pending-send differs from those initial values,           it MUST do so by emitting StreamAdded, closely followed by           &lt;tp:member-ref&gt;StreamDirectionChanged&lt;/tp:member-ref&gt; indicating a           change to the appropriate direction and pending-send state.&lt;/p&gt;          &lt;tp:rationale&gt;           &lt;p&gt;StreamAdded doesn&apos;t itself indicate the stream&apos;s direction; this             is unfortunate, but is preserved for compatibility.&lt;/p&gt;            &lt;p&gt;This is the appropriate direction for streams added by a remote             contact on existing connection managers, and does not violate             user privacy by automatically sending audio or video (audio streams             start off muted, video streams start off not sending). For             streams added by the local user using the client receiving the             signal, the true direction can also be determined from the return             value of the &lt;tp:member-ref&gt;RequestStreams&lt;/tp:member-ref&gt;             method.&lt;/p&gt;            &lt;p&gt;Existing clients typically operate by maintaining a separate             idea of the directions that they would like the streams to have,             and enforcing these intended directions by calling             &lt;tp:member-ref&gt;RequestStreamDirection&lt;/tp:member-ref&gt; whenever             needed.&lt;/p&gt;         &lt;/tp:rationale&gt;
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_channel_type_streamed_media_signal_callback_stream_direction_changed:
 * @proxy: The proxy on which tp_cli_channel_type_streamed_media_connect_to_stream_direction_changed ()
 *  was called
 * @arg_Stream_ID: The stream identifier (as defined in &lt;tp:member-ref&gt;ListStreams&lt;/tp:member-ref&gt;)
 * @arg_Stream_Direction: The new stream direction (as defined in ListStreams)
 * @arg_Pending_Flags: The new pending send flags (as defined in ListStreams)
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal StreamDirectionChanged.
 */

/**
 * tp_cli_channel_type_streamed_media_connect_to_stream_direction_changed:
 * @proxy: A #TpChannel or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal StreamDirectionChanged.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Emitted when the direction or pending flags of a stream are           changed.&lt;/p&gt;          &lt;p&gt;If the MEDIA_STREAM_PENDING_LOCAL_SEND flag is set, the remote user           has requested that we begin sending on this stream.           &lt;tp:member-ref&gt;RequestStreamDirection&lt;/tp:member-ref&gt;           should be called to indicate whether or not this change is           acceptable.&lt;/p&gt;          &lt;tp:rationale&gt;           &lt;p&gt;This allows for a MSN-style user interface, &amp;quot;Fred has asked you             to enable your webcam. (Accept | Reject)&amp;quot;, if desired.&lt;/p&gt;         &lt;/tp:rationale&gt;
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_channel_type_streamed_media_signal_callback_stream_error:
 * @proxy: The proxy on which tp_cli_channel_type_streamed_media_connect_to_stream_error ()
 *  was called
 * @arg_Stream_ID: The stream identifier (as defined in         &lt;tp:member-ref&gt;ListStreams&lt;/tp:member-ref&gt;)
 * @arg_Error_Code: A stream error number, one of the values of MediaStreamError
 * @arg_Message: A string describing the error (for debugging purposes only)
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal StreamError.
 */

/**
 * tp_cli_channel_type_streamed_media_connect_to_stream_error:
 * @proxy: A #TpChannel or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal StreamError.
 *
 * Emitted when a stream encounters an error.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_channel_type_streamed_media_signal_callback_stream_removed:
 * @proxy: The proxy on which tp_cli_channel_type_streamed_media_connect_to_stream_removed ()
 *  was called
 * @arg_Stream_ID: stream_id - the stream identifier (as defined in         &lt;tp:member-ref&gt;ListStreams&lt;/tp:member-ref&gt;)
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal StreamRemoved.
 */

/**
 * tp_cli_channel_type_streamed_media_connect_to_stream_removed:
 * @proxy: A #TpChannel or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal StreamRemoved.
 *
 * Emitted when a stream has been removed from this channel.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_channel_type_streamed_media_signal_callback_stream_state_changed:
 * @proxy: The proxy on which tp_cli_channel_type_streamed_media_connect_to_stream_state_changed ()
 *  was called
 * @arg_Stream_ID: The stream identifier (as defined in           &lt;tp:member-ref&gt;ListStreams&lt;/tp:member-ref&gt;)
 * @arg_Stream_State: The new stream state (as defined in ListStreams)
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal StreamStateChanged.
 */

/**
 * tp_cli_channel_type_streamed_media_connect_to_stream_state_changed:
 * @proxy: A #TpChannel or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal StreamStateChanged.
 *
 * Emitted when a member&apos;s stream&apos;s state changes.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_channel_type_streamed_media_callback_for_list_streams:
 * @proxy: the proxy on which the call was made
 * @out_Streams: Used to return an 'out' argument if @error is %NULL: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           An array of structs containing:           &lt;ul&gt;           &lt;li&gt;the stream identifier&lt;/li&gt;           &lt;li&gt;the contact handle who the stream is with (or 0 if the stream             represents more than a single member)&lt;/li&gt;           &lt;li&gt;the type of the stream&lt;/li&gt;           &lt;li&gt;the current stream state&lt;/li&gt;           &lt;li&gt;the current direction of the stream&lt;/li&gt;           &lt;li&gt;the current pending send flags&lt;/li&gt;           &lt;/ul&gt;
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a ListStreams method call
 * succeeds or fails.
 */

/**
 * tp_cli_channel_type_streamed_media_call_list_streams:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a ListStreams method call.
 *
 * Returns an array of structs representing the streams currently active         within this channel. Each stream is identified by an unsigned integer         which is unique for each stream within the channel.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_channel_type_streamed_media_run_list_streams:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @out_Streams: Used to return an 'out' argument if %TRUE is returned: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           An array of structs containing:           &lt;ul&gt;           &lt;li&gt;the stream identifier&lt;/li&gt;           &lt;li&gt;the contact handle who the stream is with (or 0 if the stream             represents more than a single member)&lt;/li&gt;           &lt;li&gt;the type of the stream&lt;/li&gt;           &lt;li&gt;the current stream state&lt;/li&gt;           &lt;li&gt;the current direction of the stream&lt;/li&gt;           &lt;li&gt;the current pending send flags&lt;/li&gt;           &lt;/ul&gt;
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method ListStreams and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Returns an array of structs representing the streams currently active         within this channel. Each stream is identified by an unsigned integer         which is unique for each stream within the channel.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_channel_type_streamed_media_callback_for_remove_streams:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a RemoveStreams method call
 * succeeds or fails.
 */

/**
 * tp_cli_channel_type_streamed_media_call_remove_streams:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Streams: Used to pass an 'in' argument: An array of stream identifiers (as defined in           &lt;tp:member-ref&gt;ListStreams&lt;/tp:member-ref&gt;)
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a RemoveStreams method call.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Request that the given streams are removed. If all streams are           removed, the channel MAY close.&lt;/p&gt;          &lt;p&gt;Clients SHOULD NOT attempt to terminate calls by removing all the           streams; instead, clients SHOULD terminate calls by removing the           &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel.Interface&quot;&gt;Group.SelfHandle&lt;/tp:dbus-ref&gt;           from the channel, using either           &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel.Interface.Group&quot;&gt;RemoveMembers&lt;/tp:dbus-ref&gt;           or           &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel.Interface.Group&quot;&gt;RemoveMembersWithReason&lt;/tp:dbus-ref&gt;.           &lt;/p&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_channel_type_streamed_media_run_remove_streams:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Streams: Used to pass an 'in' argument: An array of stream identifiers (as defined in           &lt;tp:member-ref&gt;ListStreams&lt;/tp:member-ref&gt;)
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method RemoveStreams and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Request that the given streams are removed. If all streams are           removed, the channel MAY close.&lt;/p&gt;          &lt;p&gt;Clients SHOULD NOT attempt to terminate calls by removing all the           streams; instead, clients SHOULD terminate calls by removing the           &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel.Interface&quot;&gt;Group.SelfHandle&lt;/tp:dbus-ref&gt;           from the channel, using either           &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel.Interface.Group&quot;&gt;RemoveMembers&lt;/tp:dbus-ref&gt;           or           &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel.Interface.Group&quot;&gt;RemoveMembersWithReason&lt;/tp:dbus-ref&gt;.           &lt;/p&gt;
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_channel_type_streamed_media_callback_for_request_stream_direction:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a RequestStreamDirection method call
 * succeeds or fails.
 */

/**
 * tp_cli_channel_type_streamed_media_call_request_stream_direction:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Stream_ID: Used to pass an 'in' argument: The stream identifier (as defined in           &lt;tp:member-ref&gt;ListStreams&lt;/tp:member-ref&gt;)
 * @in_Stream_Direction: Used to pass an 'in' argument: The desired stream direction (a value of MediaStreamDirection)
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a RequestStreamDirection method call.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Request a change in the direction of an existing stream. In particular,         this might be useful to stop sending media of a particular type,         or inform the peer that you are no longer using media that is being         sent to you.&lt;/p&gt;          &lt;p&gt;Depending on the protocol, streams which are no longer sending in         either direction should be removed and a         &lt;tp:member-ref&gt;StreamRemoved&lt;/tp:member-ref&gt; signal emitted.         Some direction changes can be enforced locally (for example,         BIDIRECTIONAL -&amp;gt; RECEIVE can be achieved by merely stopping sending),         others may not be possible on some protocols, and some need agreement         from the remote end. In this case, the MEDIA_STREAM_PENDING_REMOTE_SEND         flag will be set in the         &lt;tp:member-ref&gt;StreamDirectionChanged&lt;/tp:member-ref&gt; signal, and the         signal         emitted again without the flag to indicate the resulting direction when         the remote end has accepted or rejected the change.&lt;/p&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_channel_type_streamed_media_run_request_stream_direction:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Stream_ID: Used to pass an 'in' argument: The stream identifier (as defined in           &lt;tp:member-ref&gt;ListStreams&lt;/tp:member-ref&gt;)
 * @in_Stream_Direction: Used to pass an 'in' argument: The desired stream direction (a value of MediaStreamDirection)
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method RequestStreamDirection and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Request a change in the direction of an existing stream. In particular,         this might be useful to stop sending media of a particular type,         or inform the peer that you are no longer using media that is being         sent to you.&lt;/p&gt;          &lt;p&gt;Depending on the protocol, streams which are no longer sending in         either direction should be removed and a         &lt;tp:member-ref&gt;StreamRemoved&lt;/tp:member-ref&gt; signal emitted.         Some direction changes can be enforced locally (for example,         BIDIRECTIONAL -&amp;gt; RECEIVE can be achieved by merely stopping sending),         others may not be possible on some protocols, and some need agreement         from the remote end. In this case, the MEDIA_STREAM_PENDING_REMOTE_SEND         flag will be set in the         &lt;tp:member-ref&gt;StreamDirectionChanged&lt;/tp:member-ref&gt; signal, and the         signal         emitted again without the flag to indicate the resulting direction when         the remote end has accepted or rejected the change.&lt;/p&gt;
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_channel_type_streamed_media_callback_for_request_streams:
 * @proxy: the proxy on which the call was made
 * @out_Streams: Used to return an 'out' argument if @error is %NULL: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           An array of structs (in the same order as the given stream types)           containing:           &lt;ul&gt;             &lt;li&gt;the stream identifier&lt;/li&gt;             &lt;li&gt;the contact handle who the stream is with (or 0 if the stream               represents more than a single member)&lt;/li&gt;             &lt;li&gt;the type of the stream&lt;/li&gt;             &lt;li&gt;the current stream state&lt;/li&gt;             &lt;li&gt;the current direction of the stream&lt;/li&gt;             &lt;li&gt;the current pending send flags&lt;/li&gt;           &lt;/ul&gt;
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a RequestStreams method call
 * succeeds or fails.
 */

/**
 * tp_cli_channel_type_streamed_media_call_request_streams:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Contact_Handle: Used to pass an 'in' argument: A contact handle with whom to establish the streams
 * @in_Types: Used to pass an 'in' argument: An array of stream types (values of MediaStreamType)
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a RequestStreams method call.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Request that streams be established to exchange the given types of         media with the given member. In general this will try and establish a         bidirectional stream, but on some protocols it may not be possible to         indicate to the peer that you would like to receive media, so a         send-only stream will be created initially. In the cases where the         stream requires remote agreement (eg you wish to receive media from         them), the &lt;tp:member-ref&gt;StreamDirectionChanged&lt;/tp:member-ref&gt; signal         will be emitted with the         MEDIA_STREAM_PENDING_REMOTE_SEND flag set, and the signal emitted again         with the flag cleared when the remote end has replied.&lt;/p&gt;          &lt;p&gt;If streams of the requested types already exist, calling this           method results in the creation of additional streams. Accordingly,           clients wishing to have exactly one audio stream or exactly one           video stream SHOULD check for the current streams using           &lt;tp:member-ref&gt;ListStreams&lt;/tp:member-ref&gt; before calling this           method.&lt;/p&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_channel_type_streamed_media_run_request_streams:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Contact_Handle: Used to pass an 'in' argument: A contact handle with whom to establish the streams
 * @in_Types: Used to pass an 'in' argument: An array of stream types (values of MediaStreamType)
 * @out_Streams: Used to return an 'out' argument if %TRUE is returned: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           An array of structs (in the same order as the given stream types)           containing:           &lt;ul&gt;             &lt;li&gt;the stream identifier&lt;/li&gt;             &lt;li&gt;the contact handle who the stream is with (or 0 if the stream               represents more than a single member)&lt;/li&gt;             &lt;li&gt;the type of the stream&lt;/li&gt;             &lt;li&gt;the current stream state&lt;/li&gt;             &lt;li&gt;the current direction of the stream&lt;/li&gt;             &lt;li&gt;the current pending send flags&lt;/li&gt;           &lt;/ul&gt;
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method RequestStreams and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Request that streams be established to exchange the given types of         media with the given member. In general this will try and establish a         bidirectional stream, but on some protocols it may not be possible to         indicate to the peer that you would like to receive media, so a         send-only stream will be created initially. In the cases where the         stream requires remote agreement (eg you wish to receive media from         them), the &lt;tp:member-ref&gt;StreamDirectionChanged&lt;/tp:member-ref&gt; signal         will be emitted with the         MEDIA_STREAM_PENDING_REMOTE_SEND flag set, and the signal emitted again         with the flag cleared when the remote end has replied.&lt;/p&gt;          &lt;p&gt;If streams of the requested types already exist, calling this           method results in the creation of additional streams. Accordingly,           clients wishing to have exactly one audio stream or exactly one           video stream SHOULD check for the current streams using           &lt;tp:member-ref&gt;ListStreams&lt;/tp:member-ref&gt; before calling this           method.&lt;/p&gt;
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_channel_type_text_signal_callback_lost_message:
 * @proxy: The proxy on which tp_cli_channel_type_text_connect_to_lost_message ()
 *  was called
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal LostMessage.
 */

/**
 * tp_cli_channel_type_text_connect_to_lost_message:
 * @proxy: A #TpChannel or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal LostMessage.
 *
 * This signal is emitted to indicate that an incoming message was         not able to be stored and forwarded by the connection manager         due to lack of memory.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_channel_type_text_signal_callback_received:
 * @proxy: The proxy on which tp_cli_channel_type_text_connect_to_received ()
 *  was called
 * @arg_ID: A numeric identifier for acknowledging the message
 * @arg_Timestamp: A Unix timestamp indicating when the message was received
 * @arg_Sender: The handle of the contact who sent the message
 * @arg_Type: The type of the message (normal, action, notice, etc.)
 * @arg_Flags: A bitwise OR of the message flags
 * @arg_Text: The text of the message
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal Received.
 */

/**
 * tp_cli_channel_type_text_connect_to_received:
 * @proxy: A #TpChannel or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal Received.
 *
 * Signals that a message with the given id, timestamp, sender, type         and text has been received on this channel. Applications that catch         this signal and reliably inform the user of the message should         acknowledge that they have dealt with the message with the         &lt;tp:member-ref&gt;AcknowledgePendingMessages&lt;/tp:member-ref&gt; method.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_channel_type_text_signal_callback_send_error:
 * @proxy: The proxy on which tp_cli_channel_type_text_connect_to_send_error ()
 *  was called
 * @arg_Error: The error that occurred
 * @arg_Timestamp: The Unix timestamp indicating when the message was sent
 * @arg_Type: The message type
 * @arg_Text: The text of the message
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal SendError.
 */

/**
 * tp_cli_channel_type_text_connect_to_send_error:
 * @proxy: A #TpChannel or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal SendError.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Signals that an outgoing message has failed to send. The error           will be one of the values from ChannelTextSendError.&lt;/p&gt;          &lt;p&gt;This signal should only be emitted for messages for which           &lt;tp:member-ref&gt;Sent&lt;/tp:member-ref&gt; has already been emitted and           &lt;tp:member-ref&gt;Send&lt;/tp:member-ref&gt; has already returned success.&lt;/p&gt;
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_channel_type_text_signal_callback_sent:
 * @proxy: The proxy on which tp_cli_channel_type_text_connect_to_sent ()
 *  was called
 * @arg_Timestamp: Unix timestamp indicating when the message was sent
 * @arg_Type: The message type (normal, action, notice, etc) from           ChannelTextMessageType
 * @arg_Text: The text of the message. If the message was, or will be, altered           during transmission, this argument SHOULD reflect what other           contacts will receive rather than being a copy of the argument           to &lt;tp:member-ref&gt;Send&lt;/tp:member-ref&gt;.
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal Sent.
 */

/**
 * tp_cli_channel_type_text_connect_to_sent:
 * @proxy: A #TpChannel or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal Sent.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Signals that a message has been submitted for sending.&lt;/p&gt;
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_channel_type_text_callback_for_acknowledge_pending_messages:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a AcknowledgePendingMessages method call
 * succeeds or fails.
 */

/**
 * tp_cli_channel_type_text_call_acknowledge_pending_messages:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_IDs: Used to pass an 'in' argument: The IDs of the messages to acknowledge
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a AcknowledgePendingMessages method call.
 *
 * Inform the channel that you have handled messages by displaying them to         the user (or equivalent), so they can be removed from the pending queue.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_channel_type_text_run_acknowledge_pending_messages:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_IDs: Used to pass an 'in' argument: The IDs of the messages to acknowledge
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method AcknowledgePendingMessages and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Inform the channel that you have handled messages by displaying them to         the user (or equivalent), so they can be removed from the pending queue.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_channel_type_text_callback_for_get_message_types:
 * @proxy: the proxy on which the call was made
 * @out_Available_Types: Used to return an 'out' argument if @error is %NULL: An array of integer message types (ChannelTextMessageType)
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetMessageTypes method call
 * succeeds or fails.
 */

/**
 * tp_cli_channel_type_text_call_get_message_types:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetMessageTypes method call.
 *
 * Return an array indicating which types of message may be sent on this         channel.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_channel_type_text_run_get_message_types:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @out_Available_Types: Used to return an 'out' argument if %TRUE is returned: An array of integer message types (ChannelTextMessageType)
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetMessageTypes and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Return an array indicating which types of message may be sent on this         channel.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_channel_type_text_callback_for_list_pending_messages:
 * @proxy: the proxy on which the call was made
 * @out_Pending_Messages: Used to return an 'out' argument if @error is %NULL: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           An array of structs representing the pending queue. Each contains:           &lt;ul&gt;             &lt;li&gt;a numeric identifier&lt;/li&gt;             &lt;li&gt;a Unix timestamp indicating when the message was received&lt;/li&gt;             &lt;li&gt;the contact handle for the contact who sent the message&lt;/li&gt;             &lt;li&gt;the message type, taken from ChannelTextMessageType&lt;/li&gt;             &lt;li&gt;the bitwise-OR of the message flags from ChannelTextMessageFlags&lt;/li&gt;             &lt;li&gt;the text of the message&lt;/li&gt;           &lt;/ul&gt;
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a ListPendingMessages method call
 * succeeds or fails.
 *
 * Deprecated: Setting this to true is NOT RECOMMENDED for clients that           have some sort of persistent message storage - clients SHOULD only           acknowledge messages after they have actually stored them, which is           impossible if this flag is true.
 */

/**
 * tp_cli_channel_type_text_call_list_pending_messages:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Clear: Used to pass an 'in' argument: If true, behave as if           &lt;tp:member-ref&gt;AcknowledgePendingMessages&lt;/tp:member-ref&gt; had also           been called.
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a ListPendingMessages method call.
 *
 * List the messages currently in the pending queue, and optionally         remove then all.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 *
 * Deprecated: Setting this to true is NOT RECOMMENDED for clients that           have some sort of persistent message storage - clients SHOULD only           acknowledge messages after they have actually stored them, which is           impossible if this flag is true.
 */

/**
 * tp_cli_channel_type_text_run_list_pending_messages:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Clear: Used to pass an 'in' argument: If true, behave as if           &lt;tp:member-ref&gt;AcknowledgePendingMessages&lt;/tp:member-ref&gt; had also           been called.
 * @out_Pending_Messages: Used to return an 'out' argument if %TRUE is returned: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           An array of structs representing the pending queue. Each contains:           &lt;ul&gt;             &lt;li&gt;a numeric identifier&lt;/li&gt;             &lt;li&gt;a Unix timestamp indicating when the message was received&lt;/li&gt;             &lt;li&gt;the contact handle for the contact who sent the message&lt;/li&gt;             &lt;li&gt;the message type, taken from ChannelTextMessageType&lt;/li&gt;             &lt;li&gt;the bitwise-OR of the message flags from ChannelTextMessageFlags&lt;/li&gt;             &lt;li&gt;the text of the message&lt;/li&gt;           &lt;/ul&gt;
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method ListPendingMessages and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * List the messages currently in the pending queue, and optionally         remove then all.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 *
 * Deprecated: Setting this to true is NOT RECOMMENDED for clients that           have some sort of persistent message storage - clients SHOULD only           acknowledge messages after they have actually stored them, which is           impossible if this flag is true.
 */


/**
 * tp_cli_channel_type_text_callback_for_send:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a Send method call
 * succeeds or fails.
 */

/**
 * tp_cli_channel_type_text_call_send:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Type: Used to pass an 'in' argument: An integer indicating the type of the message
 * @in_Text: Used to pass an 'in' argument: The message to send
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a Send method call.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Request that a message be sent on this channel. When the message has           been submitted for delivery, this method will return and the           &lt;tp:member-ref&gt;Sent&lt;/tp:member-ref&gt; signal will be emitted. If the           message cannot be submitted for delivery, the method returns an error           and no signal is emitted.&lt;/p&gt;          &lt;p&gt;This method SHOULD return before the Sent signal is           emitted.&lt;/p&gt;          &lt;tp:rationale&gt;           &lt;p&gt;When a Text channel implements the &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel.Interface&quot;&gt;Messages&lt;/tp:dbus-ref&gt;             interface, that &amp;quot;SHOULD&amp;quot; becomes a &amp;quot;MUST&amp;quot;.&lt;/p&gt;         &lt;/tp:rationale&gt;
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_channel_type_text_run_send:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Type: Used to pass an 'in' argument: An integer indicating the type of the message
 * @in_Text: Used to pass an 'in' argument: The message to send
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method Send and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Request that a message be sent on this channel. When the message has           been submitted for delivery, this method will return and the           &lt;tp:member-ref&gt;Sent&lt;/tp:member-ref&gt; signal will be emitted. If the           message cannot be submitted for delivery, the method returns an error           and no signal is emitted.&lt;/p&gt;          &lt;p&gt;This method SHOULD return before the Sent signal is           emitted.&lt;/p&gt;          &lt;tp:rationale&gt;           &lt;p&gt;When a Text channel implements the &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Channel.Interface&quot;&gt;Messages&lt;/tp:dbus-ref&gt;             interface, that &amp;quot;SHOULD&amp;quot; becomes a &amp;quot;MUST&amp;quot;.&lt;/p&gt;         &lt;/tp:rationale&gt;
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_channel_type_tubes_signal_callback_new_tube:
 * @proxy: The proxy on which tp_cli_channel_type_tubes_connect_to_new_tube ()
 *  was called
 * @arg_ID: The ID of the new tube.
 * @arg_Initiator: The handle of the contact who initiated the tube.
 * @arg_Type: The tube type, as defined by the Tube_Type enum.
 * @arg_Service: A string representing the service that will be used over the tube.
 * @arg_Parameters: The new tube&apos;s properties.
 * @arg_State: The new tube&apos;s state.
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal NewTube.
 */

/**
 * tp_cli_channel_type_tubes_connect_to_new_tube:
 * @proxy: A #TpChannel or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal NewTube.
 *
 * Emitted when a tube is created.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_channel_type_tubes_signal_callback_tube_state_changed:
 * @proxy: The proxy on which tp_cli_channel_type_tubes_connect_to_tube_state_changed ()
 *  was called
 * @arg_ID: The ID of the tube that changed state.
 * @arg_State: The new state of the tube; see the Tube_State enumeration.
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal TubeStateChanged.
 */

/**
 * tp_cli_channel_type_tubes_connect_to_tube_state_changed:
 * @proxy: A #TpChannel or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal TubeStateChanged.
 *
 * Emitted when the state of a tube changes.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_channel_type_tubes_signal_callback_tube_closed:
 * @proxy: The proxy on which tp_cli_channel_type_tubes_connect_to_tube_closed ()
 *  was called
 * @arg_ID: The ID of the tube that was closed.
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal TubeClosed.
 */

/**
 * tp_cli_channel_type_tubes_connect_to_tube_closed:
 * @proxy: A #TpChannel or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal TubeClosed.
 *
 * Emitted when a tube has been closed. The ID of a closed tube is no        longer valid. The ID may later be reused for a new tube.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_channel_type_tubes_signal_callback_d_bus_names_changed:
 * @proxy: The proxy on which tp_cli_channel_type_tubes_connect_to_d_bus_names_changed ()
 *  was called
 * @arg_ID: The ID of the tube whose names have changed.
 * @arg_Added: Array of handles and D-Bus names of new participants.
 * @arg_Removed: Array of handles of former participants.
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal DBusNamesChanged.
 */

/**
 * tp_cli_channel_type_tubes_connect_to_d_bus_names_changed:
 * @proxy: A #TpChannel or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal DBusNamesChanged.
 *
 * Emitted on a multi-user (i.e. Handle_Type_Room) D-Bus tube when a         participant opens or closes the tube.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_channel_type_tubes_signal_callback_stream_tube_new_connection:
 * @proxy: The proxy on which tp_cli_channel_type_tubes_connect_to_stream_tube_new_connection ()
 *  was called
 * @arg_ID: The ID of the tube
 * @arg_Handle: The handle of the participant who opened the new connection
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal StreamTubeNewConnection.
 */

/**
 * tp_cli_channel_type_tubes_connect_to_stream_tube_new_connection:
 * @proxy: A #TpChannel or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal StreamTubeNewConnection.
 *
 * Emitted on a stream tube when a participant opens a new connection         to its socket.
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_channel_type_tubes_callback_for_get_available_stream_tube_types:
 * @proxy: the proxy on which the call was made
 * @out_Available_Stream_Tube_Types: Used to return an 'out' argument if @error is %NULL: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;A mapping from address types (members of Socket_Address_Type) to           arrays of access-control type (members of Socket_Access_Control)           that the connection manager supports for stream tubes with that           address type. For simplicity, if a CM supports offering a           particular type of tube, it is assumed to support accepting it.&lt;/p&gt;            &lt;p&gt;A typical value for a host without IPv6 support:&lt;/p&gt;            &lt;pre&gt;             {               Socket_Address_Type_IPv4:                 [Socket_Access_Control_Localhost, Socket_Access_Control_Port,                  Socket_Access_Control_Netmask],               Socket_Address_Type_Unix:                 [Socket_Access_Control_Localhost, Socket_Access_Control_Credentials]             }           &lt;/pre&gt;            &lt;p&gt;If stream tubes are not supported, this will be an empty             dictionary.&lt;/p&gt;
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetAvailableStreamTubeTypes method call
 * succeeds or fails.
 */

/**
 * tp_cli_channel_type_tubes_call_get_available_stream_tube_types:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetAvailableStreamTubeTypes method call.
 *
 * List the available address types and access-control types         for stream tubes.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_channel_type_tubes_run_get_available_stream_tube_types:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @out_Available_Stream_Tube_Types: Used to return an 'out' argument if %TRUE is returned: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;A mapping from address types (members of Socket_Address_Type) to           arrays of access-control type (members of Socket_Access_Control)           that the connection manager supports for stream tubes with that           address type. For simplicity, if a CM supports offering a           particular type of tube, it is assumed to support accepting it.&lt;/p&gt;            &lt;p&gt;A typical value for a host without IPv6 support:&lt;/p&gt;            &lt;pre&gt;             {               Socket_Address_Type_IPv4:                 [Socket_Access_Control_Localhost, Socket_Access_Control_Port,                  Socket_Access_Control_Netmask],               Socket_Address_Type_Unix:                 [Socket_Access_Control_Localhost, Socket_Access_Control_Credentials]             }           &lt;/pre&gt;            &lt;p&gt;If stream tubes are not supported, this will be an empty             dictionary.&lt;/p&gt;
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetAvailableStreamTubeTypes and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * List the available address types and access-control types         for stream tubes.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_channel_type_tubes_callback_for_get_available_tube_types:
 * @proxy: the proxy on which the call was made
 * @out_Available_Tube_Types: Used to return an 'out' argument if @error is %NULL: An array of the available tube types, as defined by the Tube_Type           enum.
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetAvailableTubeTypes method call
 * succeeds or fails.
 */

/**
 * tp_cli_channel_type_tubes_call_get_available_tube_types:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetAvailableTubeTypes method call.
 *
 * (Undocumented)
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_channel_type_tubes_run_get_available_tube_types:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @out_Available_Tube_Types: Used to return an 'out' argument if %TRUE is returned: An array of the available tube types, as defined by the Tube_Type           enum.
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetAvailableTubeTypes and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * (Undocumented)
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_channel_type_tubes_callback_for_list_tubes:
 * @proxy: the proxy on which the call was made
 * @out_Tubes: Used to return an 'out' argument if @error is %NULL: Return an array of tuples, each representing a tube, with the          following members:           &lt;ul&gt;            &lt;li&gt;the tube&apos;s ID&lt;/li&gt;            &lt;li&gt;the tube&apos;s initiator&lt;/li&gt;            &lt;li&gt;the tube&apos;s type&lt;/li&gt;            &lt;li&gt;the tube&apos;s service&lt;/li&gt;            &lt;li&gt;the tube&apos;s parameters&lt;/li&gt;            &lt;li&gt;the tube&apos;s state&lt;/li&gt;          &lt;/ul&gt;
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a ListTubes method call
 * succeeds or fails.
 */

/**
 * tp_cli_channel_type_tubes_call_list_tubes:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a ListTubes method call.
 *
 * (Undocumented)
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_channel_type_tubes_run_list_tubes:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @out_Tubes: Used to return an 'out' argument if %TRUE is returned: Return an array of tuples, each representing a tube, with the          following members:           &lt;ul&gt;            &lt;li&gt;the tube&apos;s ID&lt;/li&gt;            &lt;li&gt;the tube&apos;s initiator&lt;/li&gt;            &lt;li&gt;the tube&apos;s type&lt;/li&gt;            &lt;li&gt;the tube&apos;s service&lt;/li&gt;            &lt;li&gt;the tube&apos;s parameters&lt;/li&gt;            &lt;li&gt;the tube&apos;s state&lt;/li&gt;          &lt;/ul&gt;
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method ListTubes and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * (Undocumented)
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_channel_type_tubes_callback_for_offer_d_bus_tube:
 * @proxy: the proxy on which the call was made
 * @out_Tube_ID: Used to return an 'out' argument if @error is %NULL: The ID of the new tube.
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a OfferDBusTube method call
 * succeeds or fails.
 */

/**
 * tp_cli_channel_type_tubes_call_offer_d_bus_tube:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Service: Used to pass an 'in' argument: A string representing the service name that will be used over the           tube.           It should be a well-known D-Bus service name, of the form           com.example.ServiceName.
 * @in_Parameters: Used to pass an 'in' argument: A dictionary of properties for the new tube; the allowable keys,           types and values are defined by the service. Connection managers           must support the value being any primitive (non-container)           D-Bus type, or a byte array &apos;ay&apos;.
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a OfferDBusTube method call.
 *
 * Offers a D-Bus tube providing the service specified.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_channel_type_tubes_run_offer_d_bus_tube:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Service: Used to pass an 'in' argument: A string representing the service name that will be used over the           tube.           It should be a well-known D-Bus service name, of the form           com.example.ServiceName.
 * @in_Parameters: Used to pass an 'in' argument: A dictionary of properties for the new tube; the allowable keys,           types and values are defined by the service. Connection managers           must support the value being any primitive (non-container)           D-Bus type, or a byte array &apos;ay&apos;.
 * @out_Tube_ID: Used to return an 'out' argument if %TRUE is returned: The ID of the new tube.
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method OfferDBusTube and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Offers a D-Bus tube providing the service specified.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_channel_type_tubes_callback_for_offer_stream_tube:
 * @proxy: the proxy on which the call was made
 * @out_Tube_ID: Used to return an 'out' argument if @error is %NULL: The ID of the new tube.
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a OfferStreamTube method call
 * succeeds or fails.
 */

/**
 * tp_cli_channel_type_tubes_call_offer_stream_tube:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Service: Used to pass an 'in' argument: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           A string representing the service name that will be used over the           tube.           It should be a well-known TCP service name as defined by           &lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;             http://www.iana.org/assignments/port-numbers&lt;/a&gt; or           &lt;a href=&quot;http://www.dns-sd.org/ServiceTypes.html&quot;&gt;             http://www.dns-sd.org/ServiceTypes.html&lt;/a&gt;, for instance           &amp;quot;rsync&amp;quot; or &amp;quot;daap&amp;quot;.
 * @in_Parameters: Used to pass an 'in' argument: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;A dictionary of properties for the new tube; the allowable keys,           types and values are defined by the service. Connection managers           must support the value being any primitive (non-container)           D-Bus type, or a byte array &apos;ay&apos;.&lt;/p&gt;           &lt;p&gt;These should usually be the same key-value pairs specified for           use in the DNS-SD TXT record for that service.&lt;/p&gt;
 * @in_Address_Type: Used to pass an 'in' argument: The type of the listening address of the local service, as a member of           Socket_Address_Type.
 * @in_Address: Used to pass an 'in' argument: The listening address of the local service, as indicated by the           address_type.
 * @in_Access_Control: Used to pass an 'in' argument: The access control the local service applies to the local socket,           specified so the connection manager can behave appropriately           when it connects.
 * @in_Access_Control_Param: Used to pass an 'in' argument: A parameter for the access control type, to be interpreted as           specified in the documentation for the Socket_Access_Control enum.
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a OfferStreamTube method call.
 *
 * Offer a stream tube exporting the local socket specified.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_channel_type_tubes_run_offer_stream_tube:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_Service: Used to pass an 'in' argument: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           A string representing the service name that will be used over the           tube.           It should be a well-known TCP service name as defined by           &lt;a href=&quot;http://www.iana.org/assignments/port-numbers&quot;&gt;             http://www.iana.org/assignments/port-numbers&lt;/a&gt; or           &lt;a href=&quot;http://www.dns-sd.org/ServiceTypes.html&quot;&gt;             http://www.dns-sd.org/ServiceTypes.html&lt;/a&gt;, for instance           &amp;quot;rsync&amp;quot; or &amp;quot;daap&amp;quot;.
 * @in_Parameters: Used to pass an 'in' argument: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;A dictionary of properties for the new tube; the allowable keys,           types and values are defined by the service. Connection managers           must support the value being any primitive (non-container)           D-Bus type, or a byte array &apos;ay&apos;.&lt;/p&gt;           &lt;p&gt;These should usually be the same key-value pairs specified for           use in the DNS-SD TXT record for that service.&lt;/p&gt;
 * @in_Address_Type: Used to pass an 'in' argument: The type of the listening address of the local service, as a member of           Socket_Address_Type.
 * @in_Address: Used to pass an 'in' argument: The listening address of the local service, as indicated by the           address_type.
 * @in_Access_Control: Used to pass an 'in' argument: The access control the local service applies to the local socket,           specified so the connection manager can behave appropriately           when it connects.
 * @in_Access_Control_Param: Used to pass an 'in' argument: A parameter for the access control type, to be interpreted as           specified in the documentation for the Socket_Access_Control enum.
 * @out_Tube_ID: Used to return an 'out' argument if %TRUE is returned: The ID of the new tube.
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method OfferStreamTube and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Offer a stream tube exporting the local socket specified.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_channel_type_tubes_callback_for_accept_d_bus_tube:
 * @proxy: the proxy on which the call was made
 * @out_Address: Used to return an 'out' argument if @error is %NULL: The string describing the address of the private bus. The client           should not attempt to connect to the address until the tube is open.
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a AcceptDBusTube method call
 * succeeds or fails.
 */

/**
 * tp_cli_channel_type_tubes_call_accept_d_bus_tube:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_ID: Used to pass an 'in' argument: The ID of the tube to accept.
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a AcceptDBusTube method call.
 *
 * Accept a D-Bus tube that&apos;s in the &amp;quot;local pending&amp;quot; state. The         connection manager will attempt to open the tube. The tube remains in         the &amp;quot;local pending&amp;quot; state until the TubeStateChanged signal is         emitted.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_channel_type_tubes_run_accept_d_bus_tube:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_ID: Used to pass an 'in' argument: The ID of the tube to accept.
 * @out_Address: Used to return an 'out' argument if %TRUE is returned: The string describing the address of the private bus. The client           should not attempt to connect to the address until the tube is open.
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method AcceptDBusTube and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Accept a D-Bus tube that&apos;s in the &amp;quot;local pending&amp;quot; state. The         connection manager will attempt to open the tube. The tube remains in         the &amp;quot;local pending&amp;quot; state until the TubeStateChanged signal is         emitted.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_channel_type_tubes_callback_for_accept_stream_tube:
 * @proxy: the proxy on which the call was made
 * @out_Address: Used to return an 'out' argument if @error is %NULL: The address on which the connection manager will listen for           connections to this tube. The client should not attempt to connect           to the address until the tube is open.
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a AcceptStreamTube method call
 * succeeds or fails.
 */

/**
 * tp_cli_channel_type_tubes_call_accept_stream_tube:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_ID: Used to pass an 'in' argument: The ID of the tube to accept.
 * @in_Address_Type: Used to pass an 'in' argument: The type of address the connection manager should listen on.
 * @in_Access_Control: Used to pass an 'in' argument: The type of access control the connection manager should apply to           the socket.
 * @in_Access_Control_Param: Used to pass an 'in' argument: A parameter for the access control type, to be interpreted as           specified in the documentation for the Socket_Access_Control enum.
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a AcceptStreamTube method call.
 *
 * Accept a stream tube that&apos;s in the &amp;quot;local pending&amp;quot; state. The         connection manager will attempt to open the tube. The tube remains in         the &amp;quot;local pending&amp;quot; state until the TubeStateChanged signal is         emitted.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_channel_type_tubes_run_accept_stream_tube:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_ID: Used to pass an 'in' argument: The ID of the tube to accept.
 * @in_Address_Type: Used to pass an 'in' argument: The type of address the connection manager should listen on.
 * @in_Access_Control: Used to pass an 'in' argument: The type of access control the connection manager should apply to           the socket.
 * @in_Access_Control_Param: Used to pass an 'in' argument: A parameter for the access control type, to be interpreted as           specified in the documentation for the Socket_Access_Control enum.
 * @out_Address: Used to return an 'out' argument if %TRUE is returned: The address on which the connection manager will listen for           connections to this tube. The client should not attempt to connect           to the address until the tube is open.
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method AcceptStreamTube and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Accept a stream tube that&apos;s in the &amp;quot;local pending&amp;quot; state. The         connection manager will attempt to open the tube. The tube remains in         the &amp;quot;local pending&amp;quot; state until the TubeStateChanged signal is         emitted.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_channel_type_tubes_callback_for_close_tube:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a CloseTube method call
 * succeeds or fails.
 */

/**
 * tp_cli_channel_type_tubes_call_close_tube:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_ID: Used to pass an 'in' argument: The ID of the tube to close.
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a CloseTube method call.
 *
 * Close a tube.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_channel_type_tubes_run_close_tube:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_ID: Used to pass an 'in' argument: The ID of the tube to close.
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method CloseTube and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * Close a tube.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_channel_type_tubes_callback_for_get_d_bus_tube_address:
 * @proxy: the proxy on which the call was made
 * @out_Address: Used to return an 'out' argument if @error is %NULL: The bus address.
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetDBusTubeAddress method call
 * succeeds or fails.
 */

/**
 * tp_cli_channel_type_tubes_call_get_d_bus_tube_address:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_ID: Used to pass an 'in' argument: The ID of the tube to get an address for.
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetDBusTubeAddress method call.
 *
 * For a D-Bus tube, return a string describing the address of the         private bus.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_channel_type_tubes_run_get_d_bus_tube_address:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_ID: Used to pass an 'in' argument: The ID of the tube to get an address for.
 * @out_Address: Used to return an 'out' argument if %TRUE is returned: The bus address.
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetDBusTubeAddress and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * For a D-Bus tube, return a string describing the address of the         private bus.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_channel_type_tubes_callback_for_get_d_bus_names:
 * @proxy: the proxy on which the call was made
 * @out_DBus_Names: Used to return an 'out' argument if @error is %NULL: An array of structures, each containing a contact handle and a D-Bus           bus name.
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetDBusNames method call
 * succeeds or fails.
 */

/**
 * tp_cli_channel_type_tubes_call_get_d_bus_names:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_ID: Used to pass an 'in' argument: The ID of the tube to get names for.
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetDBusNames method call.
 *
 * For a multi-user (i.e. Handle_Type_Room) D-Bus tube, obtain a mapping         between contact handles and their unique bus names on this tube.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_channel_type_tubes_run_get_d_bus_names:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_ID: Used to pass an 'in' argument: The ID of the tube to get names for.
 * @out_DBus_Names: Used to return an 'out' argument if %TRUE is returned: An array of structures, each containing a contact handle and a D-Bus           bus name.
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetDBusNames and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * For a multi-user (i.e. Handle_Type_Room) D-Bus tube, obtain a mapping         between contact handles and their unique bus names on this tube.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */


/**
 * tp_cli_channel_type_tubes_callback_for_get_stream_tube_socket_address:
 * @proxy: the proxy on which the call was made
 * @out_Address_Type: Used to return an 'out' argument if @error is %NULL: The type of the listening address of the socket, as a member of           Socket_Address_Type.
 * @out_Address: Used to return an 'out' argument if @error is %NULL: The listening address of the socket, as indicated by the           address_type.
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a GetStreamTubeSocketAddress method call
 * succeeds or fails.
 */

/**
 * tp_cli_channel_type_tubes_call_get_stream_tube_socket_address:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_ID: Used to pass an 'in' argument: The ID of the stream tube to get the socket for.
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a GetStreamTubeSocketAddress method call.
 *
 * For a stream tube, obtain the address of the socket used to         communicate over this tube.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

/**
 * tp_cli_channel_type_tubes_run_get_stream_tube_socket_address:
 * @proxy: A #TpChannel or subclass
 * @timeout_ms: Timeout in milliseconds, or -1 for default
 * @in_ID: Used to pass an 'in' argument: The ID of the stream tube to get the socket for.
 * @out_Address_Type: Used to return an 'out' argument if %TRUE is returned: The type of the listening address of the socket, as a member of           Socket_Address_Type.
 * @out_Address: Used to return an 'out' argument if %TRUE is returned: The listening address of the socket, as indicated by the           address_type.
 * @error: If not %NULL, used to return errors if %FALSE 
 *  is returned
 * @loop: If not %NULL, set before re-entering 
 *  the main loop, to point to a #GMainLoop 
 *  which can be used to cancel this call with 
 *  g_main_loop_quit(), causing a return of 
 *  %FALSE with @error set to %TP_DBUS_ERROR_CANCELLED
 *
 * Call the method GetStreamTubeSocketAddress and run the main loop
 * until it returns. Before calling this method, you must
 * add a reference to any borrowed objects you need to keep,
 * and generally ensure that everything is in a consistent
 * state.
 *
 * For a stream tube, obtain the address of the socket used to         communicate over this tube.
 *
 * Returns: TRUE on success, FALSE and sets @error on error
 */

