/**
 * tp_cli_account_manager_signal_callback_account_removed:
 * @proxy: The proxy on which tp_cli_account_manager_connect_to_account_removed ()
 *  was called
 * @arg_Account: An Account, which must not be used any more.
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal AccountRemoved.
 */

/**
 * tp_cli_account_manager_connect_to_account_removed:
 * @proxy: A #TpAccountManager or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal AccountRemoved.
 *
 * The given account has been removed.          &lt;tp:rationale&gt;           This is effectively change notification for the valid and invalid           accounts lists. On emission of this signal, the Account indicated           will no longer be present in either of the lists.         &lt;/tp:rationale&gt;
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_account_manager_signal_callback_account_validity_changed:
 * @proxy: The proxy on which tp_cli_account_manager_connect_to_account_validity_changed ()
 *  was called
 * @arg_Account: An &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy&quot;&gt;Account&lt;/tp:dbus-ref&gt;.
 * @arg_Valid: True if the account is now valid.
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal AccountValidityChanged.
 */

/**
 * tp_cli_account_manager_connect_to_account_validity_changed:
 * @proxy: A #TpAccountManager or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal AccountValidityChanged.
 *
 * The validity of the given account has changed. New accounts are         also indicated by this signal, as an account validity change         (usually to True) on an account that did not previously exist.          &lt;tp:rationale&gt;           This is effectively change notification for the valid and invalid           accounts lists.         &lt;/tp:rationale&gt;
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * tp_cli_account_manager_callback_for_create_account:
 * @proxy: the proxy on which the call was made
 * @out_Account: Used to return an 'out' argument if @error is %NULL: The new &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy&quot;&gt;Account&lt;/tp:dbus-ref&gt;.
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a CreateAccount method call
 * succeeds or fails.
 */

/**
 * tp_cli_account_manager_call_create_account:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Connection_Manager: Used to pass an 'in' argument: The name of the connection manager, e.g. &amp;quot;salut&amp;quot;.
 * @in_Protocol: Used to pass an 'in' argument: The protocol, e.g. &amp;quot;local-xmpp&amp;quot;.
 * @in_Display_Name: Used to pass an 'in' argument: The initial value of the new account&apos;s &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Account&quot;&gt;DisplayName&lt;/tp:dbus-ref&gt;           property. The account manager SHOULD modify this to make it unique if           an Account already exists with the same display name, for instance by           appending a number or the &apos;account&apos; parameter. Account manager           implementations SHOULD accept an empty string, but account editing           user interfaces should avoid passing an empty string for this           parameter.            &lt;tp:rationale&gt;             &lt;p&gt;The account creation UI may ask the user for a name for the new               account. If the author of the UI chooses not to do this, the               account creation UI is better able to suggest a default display               name because it has protocol-specific knowledge which the account               manager does not.&lt;/p&gt;              &lt;p&gt;The account manager always knows the complete list of accounts so               it can easily tell whether it should append something to the               display name to avoid presenting two identically-named accounts to               the user.&lt;/p&gt;           &lt;/tp:rationale&gt;
 * @in_Parameters: Used to pass an 'in' argument: Initial parameter values, as would be passed to           &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.ConnectionManager&quot;&gt;RequestConnection&lt;/tp:dbus-ref&gt;.
 * @in_Properties: Used to pass an 'in' argument: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;The values of any other properties to be set immediately on the             new Account.&lt;/p&gt;            &lt;p&gt;Only the properties mentioned in             &lt;tp:member-ref&gt;SupportedAccountProperties&lt;/tp:member-ref&gt; are             acceptable here. In particular, the &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Account&quot;&gt;DisplayName&lt;/tp:dbus-ref&gt;             and &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Account&quot;&gt;Parameters&lt;/tp:dbus-ref&gt;             properties are never allowed here, since they are set using the other             arguments to this method.&lt;/p&gt;            &lt;p&gt;Account manager implementations SHOULD support creating accounts             with an empty value for this argument.&lt;/p&gt;
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a CreateAccount method call.
 *
 * Request the creation of a new &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy&quot;&gt;Account&lt;/tp:dbus-ref&gt;. The         account manager SHOULD NOT allow invalid accounts to be created.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

