#include "_gen/svc-call-content.h"

#include <telepathy-glib/dbus.h>
#include "_gen/signals-marshal.h"

static const DBusGObjectInfo _future_svc_call_content_object_info;

struct _FutureSvcCallContentClass {
    GTypeInterface parent_class;
    future_svc_call_content_remove_impl remove_cb;
};

enum {
    SIGNAL_CALL_CONTENT_StreamAdded,
    SIGNAL_CALL_CONTENT_StreamRemoved,
    N_CALL_CONTENT_SIGNALS
};
static guint call_content_signals[N_CALL_CONTENT_SIGNALS] = {0};

static void future_svc_call_content_base_init (gpointer klass);

GType
future_svc_call_content_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (FutureSvcCallContentClass),
        future_svc_call_content_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "FutureSvcCallContent", &info, 0);
    }

  return type;
}

static void
future_svc_call_content_remove (FutureSvcCallContent *self,
    DBusGMethodInvocation *context)
{
  future_svc_call_content_remove_impl impl = (FUTURE_SVC_CALL_CONTENT_GET_CLASS (self)->remove_cb);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

void
future_svc_call_content_implement_remove (FutureSvcCallContentClass *klass, future_svc_call_content_remove_impl impl)
{
  klass->remove_cb = impl;
}

void
future_svc_call_content_emit_stream_added (gpointer instance,
    const gchar *arg_Stream)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, FUTURE_TYPE_SVC_CALL_CONTENT));
  g_signal_emit (instance,
      call_content_signals[SIGNAL_CALL_CONTENT_StreamAdded],
      0,
      arg_Stream);
}

void
future_svc_call_content_emit_stream_removed (gpointer instance,
    const gchar *arg_Stream)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, FUTURE_TYPE_SVC_CALL_CONTENT));
  g_signal_emit (instance,
      call_content_signals[SIGNAL_CALL_CONTENT_StreamRemoved],
      0,
      arg_Stream);
}

static inline void
future_svc_call_content_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  static TpDBusPropertiesMixinPropInfo properties[7] = {
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "as", 0, NULL, NULL }, /* Interfaces */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "s", 0, NULL, NULL }, /* Name */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "u", 0, NULL, NULL }, /* Type */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "u", 0, NULL, NULL }, /* Creator */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "u", 0, NULL, NULL }, /* Disposition */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "ao", 0, NULL, NULL }, /* Streams */
      { 0, 0, NULL, 0, NULL, NULL }
  };
  static TpDBusPropertiesMixinIfaceInfo interface =
      { 0, properties, NULL, NULL };

  dbus_g_object_type_install_info (future_svc_call_content_get_type (),
      &_future_svc_call_content_object_info);

  interface.dbus_interface = g_quark_from_static_string ("org.freedesktop.Telepathy.Call.Content.DRAFT");
  properties[0].name = g_quark_from_static_string ("Interfaces");
  properties[0].type = G_TYPE_STRV;
  properties[1].name = g_quark_from_static_string ("Name");
  properties[1].type = G_TYPE_STRING;
  properties[2].name = g_quark_from_static_string ("Type");
  properties[2].type = G_TYPE_UINT;
  properties[3].name = g_quark_from_static_string ("Creator");
  properties[3].type = G_TYPE_UINT;
  properties[4].name = g_quark_from_static_string ("Disposition");
  properties[4].type = G_TYPE_UINT;
  properties[5].name = g_quark_from_static_string ("Streams");
  properties[5].type = dbus_g_type_get_collection ("GPtrArray", DBUS_TYPE_G_OBJECT_PATH);
  tp_svc_interface_set_dbus_properties_info (FUTURE_TYPE_SVC_CALL_CONTENT, &interface);

  call_content_signals[SIGNAL_CALL_CONTENT_StreamAdded] =
  g_signal_new ("stream-added",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      g_cclosure_marshal_VOID__BOXED,
      G_TYPE_NONE,
      1,
      DBUS_TYPE_G_OBJECT_PATH);

  call_content_signals[SIGNAL_CALL_CONTENT_StreamRemoved] =
  g_signal_new ("stream-removed",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      g_cclosure_marshal_VOID__BOXED,
      G_TYPE_NONE,
      1,
      DBUS_TYPE_G_OBJECT_PATH);

}
static void
future_svc_call_content_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      future_svc_call_content_base_init_once (klass);
    }
}
static const DBusGMethodInfo _future_svc_call_content_methods[] = {
  { (GCallback) future_svc_call_content_remove, g_cclosure_marshal_VOID__POINTER, 0 },
};

static const DBusGObjectInfo _future_svc_call_content_object_info = {
  0,
  _future_svc_call_content_methods,
  1,
"org.freedesktop.Telepathy.Call.Content.DRAFT\0Remove\0A\0\0\0",
"org.freedesktop.Telepathy.Call.Content.DRAFT\0StreamAdded\0org.freedesktop.Telepathy.Call.Content.DRAFT\0StreamRemoved\0\0",
"\0\0",
};

static const DBusGObjectInfo _future_svc_call_content_interface_media_object_info;

struct _FutureSvcCallContentInterfaceMediaClass {
    GTypeInterface parent_class;
    future_svc_call_content_interface_media_set_codecs_impl set_codecs_cb;
};

enum {
    SIGNAL_CALL_CONTENT_INTERFACE_MEDIA_CodecsChanged,
    SIGNAL_CALL_CONTENT_INTERFACE_MEDIA_NewCodecOffer,
    N_CALL_CONTENT_INTERFACE_MEDIA_SIGNALS
};
static guint call_content_interface_media_signals[N_CALL_CONTENT_INTERFACE_MEDIA_SIGNALS] = {0};

static void future_svc_call_content_interface_media_base_init (gpointer klass);

GType
future_svc_call_content_interface_media_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (FutureSvcCallContentInterfaceMediaClass),
        future_svc_call_content_interface_media_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "FutureSvcCallContentInterfaceMedia", &info, 0);
    }

  return type;
}

static void
future_svc_call_content_interface_media_set_codecs (FutureSvcCallContentInterfaceMedia *self,
    const GPtrArray *in_Codecs,
    DBusGMethodInvocation *context)
{
  future_svc_call_content_interface_media_set_codecs_impl impl = (FUTURE_SVC_CALL_CONTENT_INTERFACE_MEDIA_GET_CLASS (self)->set_codecs_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_Codecs,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

void
future_svc_call_content_interface_media_implement_set_codecs (FutureSvcCallContentInterfaceMediaClass *klass, future_svc_call_content_interface_media_set_codecs_impl impl)
{
  klass->set_codecs_cb = impl;
}

void
future_svc_call_content_interface_media_emit_codecs_changed (gpointer instance,
    GHashTable *arg_Updated_Codecs,
    const GArray *arg_Removed_Contacts)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, FUTURE_TYPE_SVC_CALL_CONTENT_INTERFACE_MEDIA));
  g_signal_emit (instance,
      call_content_interface_media_signals[SIGNAL_CALL_CONTENT_INTERFACE_MEDIA_CodecsChanged],
      0,
      arg_Updated_Codecs,
      arg_Removed_Contacts);
}

void
future_svc_call_content_interface_media_emit_new_codec_offer (gpointer instance,
    const gchar *arg_Offer,
    GHashTable *arg_Codecs)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, FUTURE_TYPE_SVC_CALL_CONTENT_INTERFACE_MEDIA));
  g_signal_emit (instance,
      call_content_interface_media_signals[SIGNAL_CALL_CONTENT_INTERFACE_MEDIA_NewCodecOffer],
      0,
      arg_Offer,
      arg_Codecs);
}

static inline void
future_svc_call_content_interface_media_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  static TpDBusPropertiesMixinPropInfo properties[3] = {
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "a{ua(usuua{ss})}", 0, NULL, NULL }, /* ContactCodecMap */
      { 0, TP_DBUS_PROPERTIES_MIXIN_FLAG_READ, "(oa{ua(usuua{ss})})", 0, NULL, NULL }, /* CodecOffer */
      { 0, 0, NULL, 0, NULL, NULL }
  };
  static TpDBusPropertiesMixinIfaceInfo interface =
      { 0, properties, NULL, NULL };

  dbus_g_object_type_install_info (future_svc_call_content_interface_media_get_type (),
      &_future_svc_call_content_interface_media_object_info);

  interface.dbus_interface = g_quark_from_static_string ("org.freedesktop.Telepathy.Call.Content.Interface.Media.DRAFT");
  properties[0].name = g_quark_from_static_string ("ContactCodecMap");
  properties[0].type = (dbus_g_type_get_map ("GHashTable", G_TYPE_UINT, (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_UINT, DBUS_TYPE_G_STRING_STRING_HASHTABLE, G_TYPE_INVALID))))));
  properties[1].name = g_quark_from_static_string ("CodecOffer");
  properties[1].type = (dbus_g_type_get_struct ("GValueArray", DBUS_TYPE_G_OBJECT_PATH, (dbus_g_type_get_map ("GHashTable", G_TYPE_UINT, (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_UINT, DBUS_TYPE_G_STRING_STRING_HASHTABLE, G_TYPE_INVALID)))))), G_TYPE_INVALID));
  tp_svc_interface_set_dbus_properties_info (FUTURE_TYPE_SVC_CALL_CONTENT_INTERFACE_MEDIA, &interface);

  call_content_interface_media_signals[SIGNAL_CALL_CONTENT_INTERFACE_MEDIA_CodecsChanged] =
  g_signal_new ("codecs-changed",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      _future_ext_marshal_VOID__BOXED_BOXED,
      G_TYPE_NONE,
      2,
      (dbus_g_type_get_map ("GHashTable", G_TYPE_UINT, (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_UINT, DBUS_TYPE_G_STRING_STRING_HASHTABLE, G_TYPE_INVALID)))))),
      DBUS_TYPE_G_UINT_ARRAY);

  call_content_interface_media_signals[SIGNAL_CALL_CONTENT_INTERFACE_MEDIA_NewCodecOffer] =
  g_signal_new ("new-codec-offer",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      _future_ext_marshal_VOID__BOXED_BOXED,
      G_TYPE_NONE,
      2,
      DBUS_TYPE_G_OBJECT_PATH,
      (dbus_g_type_get_map ("GHashTable", G_TYPE_UINT, (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_UINT, DBUS_TYPE_G_STRING_STRING_HASHTABLE, G_TYPE_INVALID)))))));

}
static void
future_svc_call_content_interface_media_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      future_svc_call_content_interface_media_base_init_once (klass);
    }
}
static const DBusGMethodInfo _future_svc_call_content_interface_media_methods[] = {
  { (GCallback) future_svc_call_content_interface_media_set_codecs, _future_ext_marshal_VOID__BOXED_POINTER, 0 },
};

static const DBusGObjectInfo _future_svc_call_content_interface_media_object_info = {
  0,
  _future_svc_call_content_interface_media_methods,
  1,
"org.freedesktop.Telepathy.Call.Content.Interface.Media.DRAFT\0SetCodecs\0A\0Codecs\0I\0a(usuua{ss})\0\0\0",
"org.freedesktop.Telepathy.Call.Content.Interface.Media.DRAFT\0CodecsChanged\0org.freedesktop.Telepathy.Call.Content.Interface.Media.DRAFT\0NewCodecOffer\0\0",
"\0\0",
};


