/**
 *
FutureCallContentDisposition:
 * @FUTURE_CALL_CONTENT_DISPOSITION_NONE: <![CDATA[           The content has no specific disposition         ]]>
 * @FUTURE_CALL_CONTENT_DISPOSITION_EARLY_MEDIA: <![CDATA[           [FIXME: what does this mean?]         ]]>
 * @FUTURE_CALL_CONTENT_DISPOSITION_INITIAL: <![CDATA[           The content was initially part of the call. When Accept is called on the channel, all streams of             this content where the self-handle's sending state in Senders is Sending_State_Pending_Send             will be moved to Sending_State_Sending as if SetSending(TRUE) had been called.         ]]>
 *
 * <![CDATA[         [FIXME]       ]]>
 *
 * Bitfield/set of flags generated from the Telepathy specification.
 */
/**
 * NUM_FUTURE_CALL_CONTENT_DISPOSITIONS:
 *
 * 1 higher than the highest valid value of #FutureCallContentDisposition.
 */
/**
 *
FutureSendingState:
 * @FUTURE_SENDING_STATE_NONE: <![CDATA[           The contact is not sending media and has not been asked to do so.         ]]>
 * @FUTURE_SENDING_STATE_PENDING_SEND: <![CDATA[           The contact has been asked to start sending media.         ]]>
 * @FUTURE_SENDING_STATE_SENDING: <![CDATA[           The contact is sending media.         ]]>
 *
 * <![CDATA[         Tristate indicating whether a contact is sending media.       ]]>
 *
 * Bitfield/set of flags generated from the Telepathy specification.
 */
/**
 * NUM_FUTURE_SENDING_STATES:
 *
 * 1 higher than the highest valid value of #FutureSendingState.
 */
/**
 *
FutureStreamTransportType:
 * @FUTURE_STREAM_TRANSPORT_TYPE_RAW_UDP: <![CDATA[           Raw UDP, with or without STUN. All streaming clients are assumed to           support this transport, so there is no handler capability token for           it in the Call.DRAFT interface.           [This corresponds to "none" or "stun" in the old Media.StreamHandler           interface.]         ]]>
 * @FUTURE_STREAM_TRANSPORT_TYPE_ICE: <![CDATA[           Interactive Connectivity Establishment, as defined by the IETF MMUSIC           working group.           [FIXME: do we want this to cover both ICE-UDP and ICE-TCP, or split           them?]           [This corresponds to "ice-udp" in the old Media.StreamHandler           interface.]         ]]>
 * @FUTURE_STREAM_TRANSPORT_TYPE_GTALK_P2P: <![CDATA[           Google Talk peer-to-peer connectivity establishment, as implemented           by libjingle 0.3.           [This corresponds to "gtalk-p2p" in the old Media.StreamHandler           interface.]         ]]>
 * @FUTURE_STREAM_TRANSPORT_TYPE_WLM_8_5: <![CDATA[           The transport used by Windows Live Messenger 8.5 or later, which           resembles ICE draft 6.           [This corresponds to "wlm-8.5" in the old Media.StreamHandler           interface.]         ]]>
 * @FUTURE_STREAM_TRANSPORT_TYPE_WLM_2009: <![CDATA[           The transport used by Windows Live Messenger 2009 or later, which           resembles ICE draft 19.           [This corresponds to "wlm-2009" in the old Media.StreamHandler           interface.]         ]]>
 *
 * <![CDATA[         A transport that can be used for streaming.       ]]>
 *
 * Bitfield/set of flags generated from the Telepathy specification.
 */
/**
 * NUM_FUTURE_STREAM_TRANSPORT_TYPES:
 *
 * 1 higher than the highest valid value of #FutureStreamTransportType.
 */
/**
 *
FutureCallState:
 * @FUTURE_CALL_STATE_UNKNOWN: <![CDATA[           The call state is not known. This call state MUST NOT appear as a           value of the CallState property, but           MAY be used by client code to represent calls whose state is as yet           unknown.         ]]>
 * @FUTURE_CALL_STATE_PENDING_INITIATOR: <![CDATA[           The initiator of the call hasn't accepted the call yet. This state           only makes sense for outgoing calls, where it means that the local           user has not yet sent any signalling messages to the remote user(s),           and will not do so until Accept is           called.         ]]>
 * @FUTURE_CALL_STATE_PENDING_RECEIVER: <![CDATA[           The receiver (the contact being called) hasn't accepted the call yet.         ]]>
 * @FUTURE_CALL_STATE_ACCEPTED: <![CDATA[           The contact being called has accepted the call.         ]]>
 * @FUTURE_CALL_STATE_ENDED: <![CDATA[           The call has ended, either via normal termination or an error.         ]]>
 *
 * <![CDATA[         The state of a call, as a whole.          The allowed transitions are:                     Pending_Initiator → Pending_Receiver (for outgoing calls,             when Accept is called)           Pending_Receiver → Accepted (for incoming calls, when             Accept is called; for outgoing             calls to a contact, when the remote contact accepts the call;             for joining a conference call, when the local user successfully             joins the conference)           Accepted → Pending_Receiver (when transferred to another             contact)           any state → Ended (when the call is terminated normally, or             when an error occurs)                   Clients MAY consider unknown values from this enum to be an           error - additional values will not be defined after the Call           specification is declared to be stable.       ]]>
 *
 * Bitfield/set of flags generated from the Telepathy specification.
 */
/**
 * NUM_FUTURE_CALL_STATES:
 *
 * 1 higher than the highest valid value of #FutureCallState.
 */
/**
 *
FutureCallFlags:
 * @FUTURE_CALL_FLAG_LOCALLY_RINGING: <![CDATA[           The local contact has been alerted about the call but has not           responded; if possible, the remote contact(s) have been informed of           this fact. This flag only makes sense on incoming calls in           state Call_State_Pending_Receiver. It SHOULD be set when           Ringing is called successfully, and           unset when the state changes.         ]]>
 * @FUTURE_CALL_FLAG_QUEUED: <![CDATA[           The contact is temporarily unavailable, and the call has been placed           in a queue (e.g. 182 Queued in SIP, or call-waiting in telephony).           This flag only makes sense on outgoing 1-1 calls in           state Call_State_Pending_Receiver. It SHOULD be set or unset           according to informational messages from other contacts.         ]]>
 * @FUTURE_CALL_FLAG_LOCALLY_HELD: <![CDATA[           The call has been put on hold by the local user, e.g. using the           Hold interface. This flag SHOULD only be set if           there is at least one Content, and all Contents are locally held;           it makes sense on calls in state Call_State_Pending_Receiver or           Call_State_Accepted.                         Otherwise, in transient situations where some but not all contents             are on hold, UIs would falsely indicate that the call as a whole             is on hold, which could lead to the user saying something they'll             regret, while under the impression that the other contacts can't             hear them!                    ]]>
 * @FUTURE_CALL_FLAG_FORWARDED: <![CDATA[           The initiator of the call originally called a contact other than the           current recipient of the call, but the call was then forwarded or           diverted. This flag only makes sense on outgoing calls, in state           Call_State_Pending_Receiver or Call_State_Accepted. It SHOULD be           set or unset according to informational messages from other contacts.         ]]>
 * @FUTURE_CALL_FLAG_IN_PROGRESS: <![CDATA[           Progress has been made in placing the outgoing call, but the           contact may not have been made aware of the call yet           (so the Ringing state is not appropriate). This corresponds to SIP's           status code 183 Session Progress, and could be used when the           outgoing call has reached a gateway, for instance.           This flag only makes sense on outgoing calls in state           Call_State_Pending_Receiver, and SHOULD be set or unset according to           informational messages from servers, gateways and other           infrastructure.         ]]>
 * @FUTURE_CALL_FLAG_CLEARING: <![CDATA[           This flag only occurs when the CallState is Ended. The call with           this flag set has ended, but not all resources corresponding to the           call have been freed yet.            Depending on the protocol there might be some audible feedback while           the clearing flag is set.                         In calls following the ITU-T Q.931 standard there is a period of             time between the call ending and the underlying channel being             completely free for re-use.                    ]]>
 * @FUTURE_CALL_FLAG_MUTED: <![CDATA[           The call has been muted by the local user, e.g. using the           Mute.DRAFT interface. This flag SHOULD only be set if           there is at least one Content, and all Contents are locally muted;           it makes sense on calls in state Call_State_Pending_Receiver or           Call_State_Accepted.         ]]>
 *
 * <![CDATA[         A set of flags representing the status of the call as a whole,         providing more specific information than the         CallState. Many of these flags only make         sense in a particular state.       ]]>
 *
 * Bitfield/set of flags generated from the Telepathy specification.
 */
/**
 *
FutureCallStateChangeReason:
 * @FUTURE_CALL_STATE_CHANGE_REASON_UNKNOWN: <![CDATA[           We just don't know. Unknown values of this enum SHOULD also be           treated like this.         ]]>
 * @FUTURE_CALL_STATE_CHANGE_REASON_USER_REQUESTED: <![CDATA[           The change was requested by the contact indicated by the Actor             member of a Call_State_Reason struct.            If the Actor is the local user, the DBus_Reason SHOULD be the             empty string.            If the Actor is a remote user, the DBus_Reason SHOULD be the empty             string if the call was terminated normally, but MAY be a non-empty             error name to indicate error-like call termination reasons (call             rejected as busy, kicked from a conference by a moderator, etc.).         ]]>
 * @FUTURE_CALL_STATE_CHANGE_REASON_FORWARDED: <![CDATA[           The call was forwarded. If known, the handle of the contact             the call was forwarded to will be indicated by the Actor member             of a Call_State_Reason struct.         ]]>
 *
 * <![CDATA[         A simple representation of the reason for a change in the call's         state, which may be used by simple clients, or used as a fallback         when the DBus_Reason member of a Call_State_Reason         struct is not understood.       ]]>
 *
 * Bitfield/set of flags generated from the Telepathy specification.
 */
/**
 * NUM_FUTURE_CALL_STATE_CHANGE_REASONS:
 *
 * 1 higher than the highest valid value of #FutureCallStateChangeReason.
 */
/**
 *
FutureCallMemberFlags:
 * @FUTURE_CALL_MEMBER_FLAG_RINGING: <![CDATA[           The remote contact's client has told us that the contact has been             alerted about the call but has not responded.                         This is a flag per member, not a flag for the call as a whole,               because in Muji conference calls, you could invite someone and               have their state be "ringing" for a while.                    ]]>
 * @FUTURE_CALL_MEMBER_FLAG_HELD: <![CDATA[           The call member has put this call on hold.                         This is a flag per member, not a flag for the call as a whole,               because in conference calls, any member could put the conference               on hold.                    ]]>
 * @FUTURE_CALL_MEMBER_FLAG_CONFERENCE_HOST: <![CDATA[           This contact has merged this call into a conference. Note that GSM           provides a notification when the remote party merges a call into a           conference, but not when it is split out again; thus, this flag can           only indicate that the call has been part of a conference at some           point. If a GSM connection manager receives a notification that a           call has been merged into a conference a second time, it SHOULD           represent this by clearing and immediately re-setting this flag on           the remote contact.         ]]>
 *
 * <![CDATA[         A set of flags representing the status of a remote contact in a           call.          It is protocol- and client-specific whether a particular contact           will ever have a particular flag set on them, and Telepathy clients           SHOULD NOT assume that a flag will ever be set.                     180 Ringing in SIP, and its equivalent in XMPP, are optional             informational messages, and implementations are not required             to send them. The same applies to the messages used to indicate             hold state.                ]]>
 *
 * Bitfield/set of flags generated from the Telepathy specification.
 */
