/* We don't want gtkdoc scanning this file, it'll get
 * confused by seeing function definitions, so mark it as: */
/*<private_header>*/

static void
_future_cli_call_content_codec_offer_collect_callback_accept (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;

  dbus_g_proxy_end_call (proxy, call, &error,
      G_TYPE_INVALID);
  tp_proxy_pending_call_v0_take_results (user_data, error,NULL);
}
static void
_future_cli_call_content_codec_offer_invoke_callback_accept (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  future_cli_call_content_codec_offer_callback_for_accept callback = (future_cli_call_content_codec_offer_callback_for_accept) generic_callback;

  if (error != NULL)
    {
      callback ((TpProxy *) self,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((TpProxy *) self,
      error, user_data, weak_object);

  if (args != NULL)
    g_value_array_free (args);
}

TpProxyPendingCall *
future_cli_call_content_codec_offer_call_accept (gpointer proxy,
    gint timeout_ms,
    const GPtrArray *in_Codecs,
    future_cli_call_content_codec_offer_callback_for_accept callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = FUTURE_IFACE_QUARK_CALL_CONTENT_CODEC_OFFER;
  DBusGProxy *iface;

  g_return_val_if_fail (TP_IS_PROXY (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "Accept",
          (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_UINT, DBUS_TYPE_G_STRING_STRING_HASHTABLE, G_TYPE_INVALID)))), in_Codecs,
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "Accept", iface,
          _future_cli_call_content_codec_offer_invoke_callback_accept,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "Accept",
              _future_cli_call_content_codec_offer_collect_callback_accept,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_UINT, DBUS_TYPE_G_STRING_STRING_HASHTABLE, G_TYPE_INVALID)))), in_Codecs,
              G_TYPE_INVALID));

      return data;
    }
}


static void
_future_cli_call_content_codec_offer_collect_callback_reject (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;

  dbus_g_proxy_end_call (proxy, call, &error,
      G_TYPE_INVALID);
  tp_proxy_pending_call_v0_take_results (user_data, error,NULL);
}
static void
_future_cli_call_content_codec_offer_invoke_callback_reject (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  future_cli_call_content_codec_offer_callback_for_reject callback = (future_cli_call_content_codec_offer_callback_for_reject) generic_callback;

  if (error != NULL)
    {
      callback ((TpProxy *) self,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((TpProxy *) self,
      error, user_data, weak_object);

  if (args != NULL)
    g_value_array_free (args);
}

TpProxyPendingCall *
future_cli_call_content_codec_offer_call_reject (gpointer proxy,
    gint timeout_ms,
    future_cli_call_content_codec_offer_callback_for_reject callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = FUTURE_IFACE_QUARK_CALL_CONTENT_CODEC_OFFER;
  DBusGProxy *iface;

  g_return_val_if_fail (TP_IS_PROXY (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "Reject",
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "Reject", iface,
          _future_cli_call_content_codec_offer_invoke_callback_reject,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "Reject",
              _future_cli_call_content_codec_offer_collect_callback_reject,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              G_TYPE_INVALID));

      return data;
    }
}


static inline void
future_cli_add_signals_for_call_stream_endpoint (DBusGProxy *proxy)
{
  if (!tp_proxy_dbus_g_proxy_claim_for_signal_adding (proxy))
    return;
  dbus_g_proxy_add_signal (proxy, "RemoteCredentialsSet",
      G_TYPE_STRING,
      G_TYPE_STRING,
      G_TYPE_INVALID);
  dbus_g_proxy_add_signal (proxy, "RemoteCandidatesAdded",
      (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)), G_TYPE_INVALID)))),
      G_TYPE_INVALID);
  dbus_g_proxy_add_signal (proxy, "CandidateSelected",
      (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)), G_TYPE_INVALID)),
      G_TYPE_INVALID);
  dbus_g_proxy_add_signal (proxy, "StreamStateChanged",
      G_TYPE_UINT,
      G_TYPE_INVALID);
}


static void
_future_cli_call_stream_endpoint_collect_args_of_remote_credentials_set (DBusGProxy *proxy G_GNUC_UNUSED,
    const gchar *arg_Username,
    const gchar *arg_Password,
    TpProxySignalConnection *sc)
{
  GValueArray *args = g_value_array_new (2);
  GValue blank = { 0 };
  guint i;

  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 2; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, G_TYPE_STRING);
  g_value_set_string (args->values + 0, arg_Username);

  g_value_unset (args->values + 1);
  g_value_init (args->values + 1, G_TYPE_STRING);
  g_value_set_string (args->values + 1, arg_Password);

  tp_proxy_signal_connection_v0_take_results (sc, args);
}
static void
_future_cli_call_stream_endpoint_invoke_callback_for_remote_credentials_set (TpProxy *tpproxy,
    GError *error G_GNUC_UNUSED,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  future_cli_call_stream_endpoint_signal_callback_remote_credentials_set callback =
      (future_cli_call_stream_endpoint_signal_callback_remote_credentials_set) generic_callback;

  if (callback != NULL)
    callback (g_object_ref (tpproxy),
      g_value_get_string (args->values + 0),
      g_value_get_string (args->values + 1),
      user_data,
      weak_object);

  g_value_array_free (args);
  g_object_unref (tpproxy);
}
TpProxySignalConnection *
future_cli_call_stream_endpoint_connect_to_remote_credentials_set (gpointer proxy,
    future_cli_call_stream_endpoint_signal_callback_remote_credentials_set callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object,
    GError **error)
{
  GType expected_types[3] = {
      G_TYPE_STRING,
      G_TYPE_STRING,
      G_TYPE_INVALID };

  g_return_val_if_fail (TP_IS_PROXY (proxy), NULL);
  g_return_val_if_fail (callback != NULL, NULL);

  return tp_proxy_signal_connection_v0_new ((TpProxy *) proxy,
      FUTURE_IFACE_QUARK_CALL_STREAM_ENDPOINT, "RemoteCredentialsSet",
      expected_types,
      G_CALLBACK (_future_cli_call_stream_endpoint_collect_args_of_remote_credentials_set),
      _future_cli_call_stream_endpoint_invoke_callback_for_remote_credentials_set,
      G_CALLBACK (callback), user_data, destroy,
      weak_object, error);
}

static void
_future_cli_call_stream_endpoint_collect_args_of_remote_candidates_added (DBusGProxy *proxy G_GNUC_UNUSED,
    const GPtrArray *arg_Candidates,
    TpProxySignalConnection *sc)
{
  GValueArray *args = g_value_array_new (1);
  GValue blank = { 0 };
  guint i;

  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 1; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)), G_TYPE_INVALID)))));
  g_value_set_boxed (args->values + 0, arg_Candidates);

  tp_proxy_signal_connection_v0_take_results (sc, args);
}
static void
_future_cli_call_stream_endpoint_invoke_callback_for_remote_candidates_added (TpProxy *tpproxy,
    GError *error G_GNUC_UNUSED,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  future_cli_call_stream_endpoint_signal_callback_remote_candidates_added callback =
      (future_cli_call_stream_endpoint_signal_callback_remote_candidates_added) generic_callback;

  if (callback != NULL)
    callback (g_object_ref (tpproxy),
      g_value_get_boxed (args->values + 0),
      user_data,
      weak_object);

  g_value_array_free (args);
  g_object_unref (tpproxy);
}
TpProxySignalConnection *
future_cli_call_stream_endpoint_connect_to_remote_candidates_added (gpointer proxy,
    future_cli_call_stream_endpoint_signal_callback_remote_candidates_added callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object,
    GError **error)
{
  GType expected_types[2] = {
      (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)), G_TYPE_INVALID)))),
      G_TYPE_INVALID };

  g_return_val_if_fail (TP_IS_PROXY (proxy), NULL);
  g_return_val_if_fail (callback != NULL, NULL);

  return tp_proxy_signal_connection_v0_new ((TpProxy *) proxy,
      FUTURE_IFACE_QUARK_CALL_STREAM_ENDPOINT, "RemoteCandidatesAdded",
      expected_types,
      G_CALLBACK (_future_cli_call_stream_endpoint_collect_args_of_remote_candidates_added),
      _future_cli_call_stream_endpoint_invoke_callback_for_remote_candidates_added,
      G_CALLBACK (callback), user_data, destroy,
      weak_object, error);
}

static void
_future_cli_call_stream_endpoint_collect_args_of_candidate_selected (DBusGProxy *proxy G_GNUC_UNUSED,
    const GValueArray *arg_Candidate,
    TpProxySignalConnection *sc)
{
  GValueArray *args = g_value_array_new (1);
  GValue blank = { 0 };
  guint i;

  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 1; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)), G_TYPE_INVALID)));
  g_value_set_boxed (args->values + 0, arg_Candidate);

  tp_proxy_signal_connection_v0_take_results (sc, args);
}
static void
_future_cli_call_stream_endpoint_invoke_callback_for_candidate_selected (TpProxy *tpproxy,
    GError *error G_GNUC_UNUSED,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  future_cli_call_stream_endpoint_signal_callback_candidate_selected callback =
      (future_cli_call_stream_endpoint_signal_callback_candidate_selected) generic_callback;

  if (callback != NULL)
    callback (g_object_ref (tpproxy),
      g_value_get_boxed (args->values + 0),
      user_data,
      weak_object);

  g_value_array_free (args);
  g_object_unref (tpproxy);
}
TpProxySignalConnection *
future_cli_call_stream_endpoint_connect_to_candidate_selected (gpointer proxy,
    future_cli_call_stream_endpoint_signal_callback_candidate_selected callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object,
    GError **error)
{
  GType expected_types[2] = {
      (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)), G_TYPE_INVALID)),
      G_TYPE_INVALID };

  g_return_val_if_fail (TP_IS_PROXY (proxy), NULL);
  g_return_val_if_fail (callback != NULL, NULL);

  return tp_proxy_signal_connection_v0_new ((TpProxy *) proxy,
      FUTURE_IFACE_QUARK_CALL_STREAM_ENDPOINT, "CandidateSelected",
      expected_types,
      G_CALLBACK (_future_cli_call_stream_endpoint_collect_args_of_candidate_selected),
      _future_cli_call_stream_endpoint_invoke_callback_for_candidate_selected,
      G_CALLBACK (callback), user_data, destroy,
      weak_object, error);
}

static void
_future_cli_call_stream_endpoint_collect_args_of_stream_state_changed (DBusGProxy *proxy G_GNUC_UNUSED,
    guint arg_state,
    TpProxySignalConnection *sc)
{
  GValueArray *args = g_value_array_new (1);
  GValue blank = { 0 };
  guint i;

  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 1; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, G_TYPE_UINT);
  g_value_set_uint (args->values + 0, arg_state);

  tp_proxy_signal_connection_v0_take_results (sc, args);
}
static void
_future_cli_call_stream_endpoint_invoke_callback_for_stream_state_changed (TpProxy *tpproxy,
    GError *error G_GNUC_UNUSED,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  future_cli_call_stream_endpoint_signal_callback_stream_state_changed callback =
      (future_cli_call_stream_endpoint_signal_callback_stream_state_changed) generic_callback;

  if (callback != NULL)
    callback (g_object_ref (tpproxy),
      g_value_get_uint (args->values + 0),
      user_data,
      weak_object);

  g_value_array_free (args);
  g_object_unref (tpproxy);
}
TpProxySignalConnection *
future_cli_call_stream_endpoint_connect_to_stream_state_changed (gpointer proxy,
    future_cli_call_stream_endpoint_signal_callback_stream_state_changed callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object,
    GError **error)
{
  GType expected_types[2] = {
      G_TYPE_UINT,
      G_TYPE_INVALID };

  g_return_val_if_fail (TP_IS_PROXY (proxy), NULL);
  g_return_val_if_fail (callback != NULL, NULL);

  return tp_proxy_signal_connection_v0_new ((TpProxy *) proxy,
      FUTURE_IFACE_QUARK_CALL_STREAM_ENDPOINT, "StreamStateChanged",
      expected_types,
      G_CALLBACK (_future_cli_call_stream_endpoint_collect_args_of_stream_state_changed),
      _future_cli_call_stream_endpoint_invoke_callback_for_stream_state_changed,
      G_CALLBACK (callback), user_data, destroy,
      weak_object, error);
}

static void
_future_cli_call_stream_endpoint_collect_callback_set_selected_candidate (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;

  dbus_g_proxy_end_call (proxy, call, &error,
      G_TYPE_INVALID);
  tp_proxy_pending_call_v0_take_results (user_data, error,NULL);
}
static void
_future_cli_call_stream_endpoint_invoke_callback_set_selected_candidate (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  future_cli_call_stream_endpoint_callback_for_set_selected_candidate callback = (future_cli_call_stream_endpoint_callback_for_set_selected_candidate) generic_callback;

  if (error != NULL)
    {
      callback ((TpProxy *) self,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((TpProxy *) self,
      error, user_data, weak_object);

  if (args != NULL)
    g_value_array_free (args);
}

TpProxyPendingCall *
future_cli_call_stream_endpoint_call_set_selected_candidate (gpointer proxy,
    gint timeout_ms,
    const GValueArray *in_Candidate,
    future_cli_call_stream_endpoint_callback_for_set_selected_candidate callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = FUTURE_IFACE_QUARK_CALL_STREAM_ENDPOINT;
  DBusGProxy *iface;

  g_return_val_if_fail (TP_IS_PROXY (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "SetSelectedCandidate",
          (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)), G_TYPE_INVALID)), in_Candidate,
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "SetSelectedCandidate", iface,
          _future_cli_call_stream_endpoint_invoke_callback_set_selected_candidate,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "SetSelectedCandidate",
              _future_cli_call_stream_endpoint_collect_callback_set_selected_candidate,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)), G_TYPE_INVALID)), in_Candidate,
              G_TYPE_INVALID));

      return data;
    }
}


static void
_future_cli_call_stream_endpoint_collect_callback_set_stream_state (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;

  dbus_g_proxy_end_call (proxy, call, &error,
      G_TYPE_INVALID);
  tp_proxy_pending_call_v0_take_results (user_data, error,NULL);
}
static void
_future_cli_call_stream_endpoint_invoke_callback_set_stream_state (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  future_cli_call_stream_endpoint_callback_for_set_stream_state callback = (future_cli_call_stream_endpoint_callback_for_set_stream_state) generic_callback;

  if (error != NULL)
    {
      callback ((TpProxy *) self,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((TpProxy *) self,
      error, user_data, weak_object);

  if (args != NULL)
    g_value_array_free (args);
}

TpProxyPendingCall *
future_cli_call_stream_endpoint_call_set_stream_state (gpointer proxy,
    gint timeout_ms,
    guint in_State,
    future_cli_call_stream_endpoint_callback_for_set_stream_state callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = FUTURE_IFACE_QUARK_CALL_STREAM_ENDPOINT;
  DBusGProxy *iface;

  g_return_val_if_fail (TP_IS_PROXY (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "SetStreamState",
          G_TYPE_UINT, in_State,
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "SetStreamState", iface,
          _future_cli_call_stream_endpoint_invoke_callback_set_stream_state,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "SetStreamState",
              _future_cli_call_stream_endpoint_collect_callback_set_stream_state,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              G_TYPE_UINT, in_State,
              G_TYPE_INVALID));

      return data;
    }
}


/*
 * future_cli_misc_add_signals:
 * @self: the #TpProxy
 * @quark: a quark whose string value is the interface
 *   name whose signals should be added
 * @proxy: the D-Bus proxy to which to add the signals
 * @unused: not used for anything
 *
 * Tell dbus-glib that @proxy has the signatures of all
 * signals on the given interface, if it's one we
 * support.
 *
 * This function should be used as a signal handler for
 * #TpProxy::interface-added.
 */
static void
future_cli_misc_add_signals (TpProxy *self G_GNUC_UNUSED,
    guint quark,
    DBusGProxy *proxy,
    gpointer unused G_GNUC_UNUSED)
{
  if (quark == FUTURE_IFACE_QUARK_CALL_STREAM_ENDPOINT)
    future_cli_add_signals_for_call_stream_endpoint (proxy);
}
