/* We don't want gtkdoc scanning this file, it'll get
 * confused by seeing function definitions, so mark it as: */
/*<private_header>*/

static inline void
future_cli_add_signals_for_channel_type_call (DBusGProxy *proxy)
{
  if (!tp_proxy_dbus_g_proxy_claim_for_signal_adding (proxy))
    return;
  dbus_g_proxy_add_signal (proxy, "ContentAdded",
      DBUS_TYPE_G_OBJECT_PATH,
      G_TYPE_UINT,
      G_TYPE_INVALID);
  dbus_g_proxy_add_signal (proxy, "ContentRemoved",
      DBUS_TYPE_G_OBJECT_PATH,
      G_TYPE_INVALID);
  dbus_g_proxy_add_signal (proxy, "CallStateChanged",
      G_TYPE_UINT,
      G_TYPE_UINT,
      (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_INVALID)),
      (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)),
      G_TYPE_INVALID);
  dbus_g_proxy_add_signal (proxy, "CallMembersChanged",
      (dbus_g_type_get_map ("GHashTable", G_TYPE_UINT, G_TYPE_UINT)),
      DBUS_TYPE_G_UINT_ARRAY,
      G_TYPE_INVALID);
}


static void
_future_cli_channel_type_call_collect_args_of_content_added (DBusGProxy *proxy G_GNUC_UNUSED,
    const gchar *arg_Content,
    guint arg_Content_Type,
    TpProxySignalConnection *sc)
{
  GValueArray *args = g_value_array_new (2);
  GValue blank = { 0 };
  guint i;

  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 2; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, DBUS_TYPE_G_OBJECT_PATH);
  g_value_set_boxed (args->values + 0, arg_Content);

  g_value_unset (args->values + 1);
  g_value_init (args->values + 1, G_TYPE_UINT);
  g_value_set_uint (args->values + 1, arg_Content_Type);

  tp_proxy_signal_connection_v0_take_results (sc, args);
}
static void
_future_cli_channel_type_call_invoke_callback_for_content_added (TpProxy *tpproxy,
    GError *error G_GNUC_UNUSED,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  future_cli_channel_type_call_signal_callback_content_added callback =
      (future_cli_channel_type_call_signal_callback_content_added) generic_callback;

  if (callback != NULL)
    callback (g_object_ref (tpproxy),
      g_value_get_boxed (args->values + 0),
      g_value_get_uint (args->values + 1),
      user_data,
      weak_object);

  g_value_array_free (args);
  g_object_unref (tpproxy);
}
TpProxySignalConnection *
future_cli_channel_type_call_connect_to_content_added (TpChannel *proxy,
    future_cli_channel_type_call_signal_callback_content_added callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object,
    GError **error)
{
  GType expected_types[3] = {
      DBUS_TYPE_G_OBJECT_PATH,
      G_TYPE_UINT,
      G_TYPE_INVALID };

  g_return_val_if_fail (TP_IS_CHANNEL (proxy), NULL);
  g_return_val_if_fail (callback != NULL, NULL);

  return tp_proxy_signal_connection_v0_new ((TpProxy *) proxy,
      FUTURE_IFACE_QUARK_CHANNEL_TYPE_CALL, "ContentAdded",
      expected_types,
      G_CALLBACK (_future_cli_channel_type_call_collect_args_of_content_added),
      _future_cli_channel_type_call_invoke_callback_for_content_added,
      G_CALLBACK (callback), user_data, destroy,
      weak_object, error);
}

static void
_future_cli_channel_type_call_collect_args_of_content_removed (DBusGProxy *proxy G_GNUC_UNUSED,
    const gchar *arg_Content,
    TpProxySignalConnection *sc)
{
  GValueArray *args = g_value_array_new (1);
  GValue blank = { 0 };
  guint i;

  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 1; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, DBUS_TYPE_G_OBJECT_PATH);
  g_value_set_boxed (args->values + 0, arg_Content);

  tp_proxy_signal_connection_v0_take_results (sc, args);
}
static void
_future_cli_channel_type_call_invoke_callback_for_content_removed (TpProxy *tpproxy,
    GError *error G_GNUC_UNUSED,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  future_cli_channel_type_call_signal_callback_content_removed callback =
      (future_cli_channel_type_call_signal_callback_content_removed) generic_callback;

  if (callback != NULL)
    callback (g_object_ref (tpproxy),
      g_value_get_boxed (args->values + 0),
      user_data,
      weak_object);

  g_value_array_free (args);
  g_object_unref (tpproxy);
}
TpProxySignalConnection *
future_cli_channel_type_call_connect_to_content_removed (TpChannel *proxy,
    future_cli_channel_type_call_signal_callback_content_removed callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object,
    GError **error)
{
  GType expected_types[2] = {
      DBUS_TYPE_G_OBJECT_PATH,
      G_TYPE_INVALID };

  g_return_val_if_fail (TP_IS_CHANNEL (proxy), NULL);
  g_return_val_if_fail (callback != NULL, NULL);

  return tp_proxy_signal_connection_v0_new ((TpProxy *) proxy,
      FUTURE_IFACE_QUARK_CHANNEL_TYPE_CALL, "ContentRemoved",
      expected_types,
      G_CALLBACK (_future_cli_channel_type_call_collect_args_of_content_removed),
      _future_cli_channel_type_call_invoke_callback_for_content_removed,
      G_CALLBACK (callback), user_data, destroy,
      weak_object, error);
}

static void
_future_cli_channel_type_call_collect_args_of_call_state_changed (DBusGProxy *proxy G_GNUC_UNUSED,
    guint arg_Call_State,
    guint arg_Call_Flags,
    const GValueArray *arg_Call_State_Reason,
    GHashTable *arg_Call_State_Details,
    TpProxySignalConnection *sc)
{
  GValueArray *args = g_value_array_new (4);
  GValue blank = { 0 };
  guint i;

  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 4; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, G_TYPE_UINT);
  g_value_set_uint (args->values + 0, arg_Call_State);

  g_value_unset (args->values + 1);
  g_value_init (args->values + 1, G_TYPE_UINT);
  g_value_set_uint (args->values + 1, arg_Call_Flags);

  g_value_unset (args->values + 2);
  g_value_init (args->values + 2, (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_INVALID)));
  g_value_set_boxed (args->values + 2, arg_Call_State_Reason);

  g_value_unset (args->values + 3);
  g_value_init (args->values + 3, (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)));
  g_value_set_boxed (args->values + 3, arg_Call_State_Details);

  tp_proxy_signal_connection_v0_take_results (sc, args);
}
static void
_future_cli_channel_type_call_invoke_callback_for_call_state_changed (TpProxy *tpproxy,
    GError *error G_GNUC_UNUSED,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  future_cli_channel_type_call_signal_callback_call_state_changed callback =
      (future_cli_channel_type_call_signal_callback_call_state_changed) generic_callback;

  if (callback != NULL)
    callback (g_object_ref (tpproxy),
      g_value_get_uint (args->values + 0),
      g_value_get_uint (args->values + 1),
      g_value_get_boxed (args->values + 2),
      g_value_get_boxed (args->values + 3),
      user_data,
      weak_object);

  g_value_array_free (args);
  g_object_unref (tpproxy);
}
TpProxySignalConnection *
future_cli_channel_type_call_connect_to_call_state_changed (TpChannel *proxy,
    future_cli_channel_type_call_signal_callback_call_state_changed callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object,
    GError **error)
{
  GType expected_types[5] = {
      G_TYPE_UINT,
      G_TYPE_UINT,
      (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_INVALID)),
      (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)),
      G_TYPE_INVALID };

  g_return_val_if_fail (TP_IS_CHANNEL (proxy), NULL);
  g_return_val_if_fail (callback != NULL, NULL);

  return tp_proxy_signal_connection_v0_new ((TpProxy *) proxy,
      FUTURE_IFACE_QUARK_CHANNEL_TYPE_CALL, "CallStateChanged",
      expected_types,
      G_CALLBACK (_future_cli_channel_type_call_collect_args_of_call_state_changed),
      _future_cli_channel_type_call_invoke_callback_for_call_state_changed,
      G_CALLBACK (callback), user_data, destroy,
      weak_object, error);
}

static void
_future_cli_channel_type_call_collect_args_of_call_members_changed (DBusGProxy *proxy G_GNUC_UNUSED,
    GHashTable *arg_Flags_Changed,
    const GArray *arg_Removed,
    TpProxySignalConnection *sc)
{
  GValueArray *args = g_value_array_new (2);
  GValue blank = { 0 };
  guint i;

  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 2; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, (dbus_g_type_get_map ("GHashTable", G_TYPE_UINT, G_TYPE_UINT)));
  g_value_set_boxed (args->values + 0, arg_Flags_Changed);

  g_value_unset (args->values + 1);
  g_value_init (args->values + 1, DBUS_TYPE_G_UINT_ARRAY);
  g_value_set_boxed (args->values + 1, arg_Removed);

  tp_proxy_signal_connection_v0_take_results (sc, args);
}
static void
_future_cli_channel_type_call_invoke_callback_for_call_members_changed (TpProxy *tpproxy,
    GError *error G_GNUC_UNUSED,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  future_cli_channel_type_call_signal_callback_call_members_changed callback =
      (future_cli_channel_type_call_signal_callback_call_members_changed) generic_callback;

  if (callback != NULL)
    callback (g_object_ref (tpproxy),
      g_value_get_boxed (args->values + 0),
      g_value_get_boxed (args->values + 1),
      user_data,
      weak_object);

  g_value_array_free (args);
  g_object_unref (tpproxy);
}
TpProxySignalConnection *
future_cli_channel_type_call_connect_to_call_members_changed (TpChannel *proxy,
    future_cli_channel_type_call_signal_callback_call_members_changed callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object,
    GError **error)
{
  GType expected_types[3] = {
      (dbus_g_type_get_map ("GHashTable", G_TYPE_UINT, G_TYPE_UINT)),
      DBUS_TYPE_G_UINT_ARRAY,
      G_TYPE_INVALID };

  g_return_val_if_fail (TP_IS_CHANNEL (proxy), NULL);
  g_return_val_if_fail (callback != NULL, NULL);

  return tp_proxy_signal_connection_v0_new ((TpProxy *) proxy,
      FUTURE_IFACE_QUARK_CHANNEL_TYPE_CALL, "CallMembersChanged",
      expected_types,
      G_CALLBACK (_future_cli_channel_type_call_collect_args_of_call_members_changed),
      _future_cli_channel_type_call_invoke_callback_for_call_members_changed,
      G_CALLBACK (callback), user_data, destroy,
      weak_object, error);
}

static void
_future_cli_channel_type_call_collect_callback_ringing (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;

  dbus_g_proxy_end_call (proxy, call, &error,
      G_TYPE_INVALID);
  tp_proxy_pending_call_v0_take_results (user_data, error,NULL);
}
static void
_future_cli_channel_type_call_invoke_callback_ringing (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  future_cli_channel_type_call_callback_for_ringing callback = (future_cli_channel_type_call_callback_for_ringing) generic_callback;

  if (error != NULL)
    {
      callback ((TpChannel *) self,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((TpChannel *) self,
      error, user_data, weak_object);

  if (args != NULL)
    g_value_array_free (args);
}

TpProxyPendingCall *
future_cli_channel_type_call_call_ringing (TpChannel *proxy,
    gint timeout_ms,
    future_cli_channel_type_call_callback_for_ringing callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = FUTURE_IFACE_QUARK_CHANNEL_TYPE_CALL;
  DBusGProxy *iface;

  g_return_val_if_fail (TP_IS_CHANNEL (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "Ringing",
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "Ringing", iface,
          _future_cli_channel_type_call_invoke_callback_ringing,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "Ringing",
              _future_cli_channel_type_call_collect_callback_ringing,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              G_TYPE_INVALID));

      return data;
    }
}


static void
_future_cli_channel_type_call_collect_callback_accept (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;

  dbus_g_proxy_end_call (proxy, call, &error,
      G_TYPE_INVALID);
  tp_proxy_pending_call_v0_take_results (user_data, error,NULL);
}
static void
_future_cli_channel_type_call_invoke_callback_accept (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  future_cli_channel_type_call_callback_for_accept callback = (future_cli_channel_type_call_callback_for_accept) generic_callback;

  if (error != NULL)
    {
      callback ((TpChannel *) self,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((TpChannel *) self,
      error, user_data, weak_object);

  if (args != NULL)
    g_value_array_free (args);
}

TpProxyPendingCall *
future_cli_channel_type_call_call_accept (TpChannel *proxy,
    gint timeout_ms,
    future_cli_channel_type_call_callback_for_accept callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = FUTURE_IFACE_QUARK_CHANNEL_TYPE_CALL;
  DBusGProxy *iface;

  g_return_val_if_fail (TP_IS_CHANNEL (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "Accept",
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "Accept", iface,
          _future_cli_channel_type_call_invoke_callback_accept,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "Accept",
              _future_cli_channel_type_call_collect_callback_accept,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              G_TYPE_INVALID));

      return data;
    }
}


static void
_future_cli_channel_type_call_collect_callback_hangup (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;

  dbus_g_proxy_end_call (proxy, call, &error,
      G_TYPE_INVALID);
  tp_proxy_pending_call_v0_take_results (user_data, error,NULL);
}
static void
_future_cli_channel_type_call_invoke_callback_hangup (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  future_cli_channel_type_call_callback_for_hangup callback = (future_cli_channel_type_call_callback_for_hangup) generic_callback;

  if (error != NULL)
    {
      callback ((TpChannel *) self,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((TpChannel *) self,
      error, user_data, weak_object);

  if (args != NULL)
    g_value_array_free (args);
}

TpProxyPendingCall *
future_cli_channel_type_call_call_hangup (TpChannel *proxy,
    gint timeout_ms,
    guint in_Reason,
    const gchar *in_Detailed_Hangup_Reason,
    const gchar *in_Message,
    future_cli_channel_type_call_callback_for_hangup callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = FUTURE_IFACE_QUARK_CHANNEL_TYPE_CALL;
  DBusGProxy *iface;

  g_return_val_if_fail (TP_IS_CHANNEL (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "Hangup",
          G_TYPE_UINT, in_Reason,
          G_TYPE_STRING, in_Detailed_Hangup_Reason,
          G_TYPE_STRING, in_Message,
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "Hangup", iface,
          _future_cli_channel_type_call_invoke_callback_hangup,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "Hangup",
              _future_cli_channel_type_call_collect_callback_hangup,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              G_TYPE_UINT, in_Reason,
              G_TYPE_STRING, in_Detailed_Hangup_Reason,
              G_TYPE_STRING, in_Message,
              G_TYPE_INVALID));

      return data;
    }
}


static void
_future_cli_channel_type_call_collect_callback_add_content (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;
  GValueArray *args;
  GValue blank = { 0 };
  guint i;
  gchar *out_Content;

  dbus_g_proxy_end_call (proxy, call, &error,
      DBUS_TYPE_G_OBJECT_PATH, &out_Content,
      G_TYPE_INVALID);

  if (error != NULL)
    {
      tp_proxy_pending_call_v0_take_results (user_data, error,
          NULL);
      return;
    }

  args = g_value_array_new (1);
  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 1; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, DBUS_TYPE_G_OBJECT_PATH);
  g_value_take_boxed (args->values + 0, out_Content);
  tp_proxy_pending_call_v0_take_results (user_data, NULL, args);
}
static void
_future_cli_channel_type_call_invoke_callback_add_content (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  future_cli_channel_type_call_callback_for_add_content callback = (future_cli_channel_type_call_callback_for_add_content) generic_callback;

  if (error != NULL)
    {
      callback ((TpChannel *) self,
          NULL,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((TpChannel *) self,
      g_value_get_boxed (args->values + 0),
      error, user_data, weak_object);

  g_value_array_free (args);
}

TpProxyPendingCall *
future_cli_channel_type_call_call_add_content (TpChannel *proxy,
    gint timeout_ms,
    const gchar *in_Content_Name,
    guint in_Content_Type,
    future_cli_channel_type_call_callback_for_add_content callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = FUTURE_IFACE_QUARK_CHANNEL_TYPE_CALL;
  DBusGProxy *iface;

  g_return_val_if_fail (TP_IS_CHANNEL (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            NULL,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "AddContent",
          G_TYPE_STRING, in_Content_Name,
          G_TYPE_UINT, in_Content_Type,
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "AddContent", iface,
          _future_cli_channel_type_call_invoke_callback_add_content,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "AddContent",
              _future_cli_channel_type_call_collect_callback_add_content,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              G_TYPE_STRING, in_Content_Name,
              G_TYPE_UINT, in_Content_Type,
              G_TYPE_INVALID));

      return data;
    }
}


/*
 * future_cli_channel_add_signals:
 * @self: the #TpProxy
 * @quark: a quark whose string value is the interface
 *   name whose signals should be added
 * @proxy: the D-Bus proxy to which to add the signals
 * @unused: not used for anything
 *
 * Tell dbus-glib that @proxy has the signatures of all
 * signals on the given interface, if it's one we
 * support.
 *
 * This function should be used as a signal handler for
 * #TpProxy::interface-added.
 */
static void
future_cli_channel_add_signals (TpProxy *self G_GNUC_UNUSED,
    guint quark,
    DBusGProxy *proxy,
    gpointer unused G_GNUC_UNUSED)
{
  if (quark == FUTURE_IFACE_QUARK_CHANNEL_TYPE_CALL)
    future_cli_add_signals_for_channel_type_call (proxy);
}
