/* We don't want gtkdoc scanning this file, it'll get
 * confused by seeing function definitions, so mark it as: */
/*<private_header>*/

static inline void
future_cli_add_signals_for_call_stream (DBusGProxy *proxy)
{
  if (!tp_proxy_dbus_g_proxy_claim_for_signal_adding (proxy))
    return;
  dbus_g_proxy_add_signal (proxy, "SendersChanged",
      (dbus_g_type_get_map ("GHashTable", G_TYPE_UINT, G_TYPE_UINT)),
      DBUS_TYPE_G_UINT_ARRAY,
      G_TYPE_INVALID);
}


static void
_future_cli_call_stream_collect_args_of_senders_changed (DBusGProxy *proxy G_GNUC_UNUSED,
    GHashTable *arg_Updates,
    const GArray *arg_Removed,
    TpProxySignalConnection *sc)
{
  GValueArray *args = g_value_array_new (2);
  GValue blank = { 0 };
  guint i;

  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 2; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, (dbus_g_type_get_map ("GHashTable", G_TYPE_UINT, G_TYPE_UINT)));
  g_value_set_boxed (args->values + 0, arg_Updates);

  g_value_unset (args->values + 1);
  g_value_init (args->values + 1, DBUS_TYPE_G_UINT_ARRAY);
  g_value_set_boxed (args->values + 1, arg_Removed);

  tp_proxy_signal_connection_v0_take_results (sc, args);
}
static void
_future_cli_call_stream_invoke_callback_for_senders_changed (TpProxy *tpproxy,
    GError *error G_GNUC_UNUSED,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  future_cli_call_stream_signal_callback_senders_changed callback =
      (future_cli_call_stream_signal_callback_senders_changed) generic_callback;

  if (callback != NULL)
    callback (g_object_ref (tpproxy),
      g_value_get_boxed (args->values + 0),
      g_value_get_boxed (args->values + 1),
      user_data,
      weak_object);

  g_value_array_free (args);
  g_object_unref (tpproxy);
}
TpProxySignalConnection *
future_cli_call_stream_connect_to_senders_changed (FutureCallStream *proxy,
    future_cli_call_stream_signal_callback_senders_changed callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object,
    GError **error)
{
  GType expected_types[3] = {
      (dbus_g_type_get_map ("GHashTable", G_TYPE_UINT, G_TYPE_UINT)),
      DBUS_TYPE_G_UINT_ARRAY,
      G_TYPE_INVALID };

  g_return_val_if_fail (FUTURE_IS_CALL_STREAM (proxy), NULL);
  g_return_val_if_fail (callback != NULL, NULL);

  return tp_proxy_signal_connection_v0_new ((TpProxy *) proxy,
      FUTURE_IFACE_QUARK_CALL_STREAM, "SendersChanged",
      expected_types,
      G_CALLBACK (_future_cli_call_stream_collect_args_of_senders_changed),
      _future_cli_call_stream_invoke_callback_for_senders_changed,
      G_CALLBACK (callback), user_data, destroy,
      weak_object, error);
}

static void
_future_cli_call_stream_collect_callback_set_sending (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;

  dbus_g_proxy_end_call (proxy, call, &error,
      G_TYPE_INVALID);
  tp_proxy_pending_call_v0_take_results (user_data, error,NULL);
}
static void
_future_cli_call_stream_invoke_callback_set_sending (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  future_cli_call_stream_callback_for_set_sending callback = (future_cli_call_stream_callback_for_set_sending) generic_callback;

  if (error != NULL)
    {
      callback ((FutureCallStream *) self,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((FutureCallStream *) self,
      error, user_data, weak_object);

  if (args != NULL)
    g_value_array_free (args);
}

TpProxyPendingCall *
future_cli_call_stream_call_set_sending (FutureCallStream *proxy,
    gint timeout_ms,
    gboolean in_Send,
    future_cli_call_stream_callback_for_set_sending callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = FUTURE_IFACE_QUARK_CALL_STREAM;
  DBusGProxy *iface;

  g_return_val_if_fail (FUTURE_IS_CALL_STREAM (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "SetSending",
          G_TYPE_BOOLEAN, in_Send,
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "SetSending", iface,
          _future_cli_call_stream_invoke_callback_set_sending,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "SetSending",
              _future_cli_call_stream_collect_callback_set_sending,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              G_TYPE_BOOLEAN, in_Send,
              G_TYPE_INVALID));

      return data;
    }
}


static void
_future_cli_call_stream_collect_callback_request_receiving (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;

  dbus_g_proxy_end_call (proxy, call, &error,
      G_TYPE_INVALID);
  tp_proxy_pending_call_v0_take_results (user_data, error,NULL);
}
static void
_future_cli_call_stream_invoke_callback_request_receiving (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  future_cli_call_stream_callback_for_request_receiving callback = (future_cli_call_stream_callback_for_request_receiving) generic_callback;

  if (error != NULL)
    {
      callback ((FutureCallStream *) self,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((FutureCallStream *) self,
      error, user_data, weak_object);

  if (args != NULL)
    g_value_array_free (args);
}

TpProxyPendingCall *
future_cli_call_stream_call_request_receiving (FutureCallStream *proxy,
    gint timeout_ms,
    guint in_Contact,
    gboolean in_Receive,
    future_cli_call_stream_callback_for_request_receiving callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = FUTURE_IFACE_QUARK_CALL_STREAM;
  DBusGProxy *iface;

  g_return_val_if_fail (FUTURE_IS_CALL_STREAM (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "RequestReceiving",
          G_TYPE_UINT, in_Contact,
          G_TYPE_BOOLEAN, in_Receive,
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "RequestReceiving", iface,
          _future_cli_call_stream_invoke_callback_request_receiving,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "RequestReceiving",
              _future_cli_call_stream_collect_callback_request_receiving,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              G_TYPE_UINT, in_Contact,
              G_TYPE_BOOLEAN, in_Receive,
              G_TYPE_INVALID));

      return data;
    }
}


static inline void
future_cli_add_signals_for_call_stream_interface_media (DBusGProxy *proxy)
{
  if (!tp_proxy_dbus_g_proxy_claim_for_signal_adding (proxy))
    return;
  dbus_g_proxy_add_signal (proxy, "LocalCandidatesAdded",
      (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)), G_TYPE_INVALID)))),
      G_TYPE_INVALID);
  dbus_g_proxy_add_signal (proxy, "LocalCredentialsSet",
      G_TYPE_STRING,
      G_TYPE_STRING,
      G_TYPE_INVALID);
  dbus_g_proxy_add_signal (proxy, "ServerInfoRetrieved",
      G_TYPE_INVALID);
  dbus_g_proxy_add_signal (proxy, "EndpointsChanged",
      dbus_g_type_get_collection ("GPtrArray", DBUS_TYPE_G_OBJECT_PATH),
      dbus_g_type_get_collection ("GPtrArray", DBUS_TYPE_G_OBJECT_PATH),
      G_TYPE_INVALID);
}


static void
_future_cli_call_stream_interface_media_collect_args_of_local_candidates_added (DBusGProxy *proxy G_GNUC_UNUSED,
    const GPtrArray *arg_Candidates,
    TpProxySignalConnection *sc)
{
  GValueArray *args = g_value_array_new (1);
  GValue blank = { 0 };
  guint i;

  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 1; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)), G_TYPE_INVALID)))));
  g_value_set_boxed (args->values + 0, arg_Candidates);

  tp_proxy_signal_connection_v0_take_results (sc, args);
}
static void
_future_cli_call_stream_interface_media_invoke_callback_for_local_candidates_added (TpProxy *tpproxy,
    GError *error G_GNUC_UNUSED,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  future_cli_call_stream_interface_media_signal_callback_local_candidates_added callback =
      (future_cli_call_stream_interface_media_signal_callback_local_candidates_added) generic_callback;

  if (callback != NULL)
    callback (g_object_ref (tpproxy),
      g_value_get_boxed (args->values + 0),
      user_data,
      weak_object);

  g_value_array_free (args);
  g_object_unref (tpproxy);
}
TpProxySignalConnection *
future_cli_call_stream_interface_media_connect_to_local_candidates_added (FutureCallStream *proxy,
    future_cli_call_stream_interface_media_signal_callback_local_candidates_added callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object,
    GError **error)
{
  GType expected_types[2] = {
      (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)), G_TYPE_INVALID)))),
      G_TYPE_INVALID };

  g_return_val_if_fail (FUTURE_IS_CALL_STREAM (proxy), NULL);
  g_return_val_if_fail (callback != NULL, NULL);

  return tp_proxy_signal_connection_v0_new ((TpProxy *) proxy,
      FUTURE_IFACE_QUARK_CALL_STREAM_INTERFACE_MEDIA, "LocalCandidatesAdded",
      expected_types,
      G_CALLBACK (_future_cli_call_stream_interface_media_collect_args_of_local_candidates_added),
      _future_cli_call_stream_interface_media_invoke_callback_for_local_candidates_added,
      G_CALLBACK (callback), user_data, destroy,
      weak_object, error);
}

static void
_future_cli_call_stream_interface_media_collect_args_of_local_credentials_set (DBusGProxy *proxy G_GNUC_UNUSED,
    const gchar *arg_Username,
    const gchar *arg_Password,
    TpProxySignalConnection *sc)
{
  GValueArray *args = g_value_array_new (2);
  GValue blank = { 0 };
  guint i;

  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 2; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, G_TYPE_STRING);
  g_value_set_string (args->values + 0, arg_Username);

  g_value_unset (args->values + 1);
  g_value_init (args->values + 1, G_TYPE_STRING);
  g_value_set_string (args->values + 1, arg_Password);

  tp_proxy_signal_connection_v0_take_results (sc, args);
}
static void
_future_cli_call_stream_interface_media_invoke_callback_for_local_credentials_set (TpProxy *tpproxy,
    GError *error G_GNUC_UNUSED,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  future_cli_call_stream_interface_media_signal_callback_local_credentials_set callback =
      (future_cli_call_stream_interface_media_signal_callback_local_credentials_set) generic_callback;

  if (callback != NULL)
    callback (g_object_ref (tpproxy),
      g_value_get_string (args->values + 0),
      g_value_get_string (args->values + 1),
      user_data,
      weak_object);

  g_value_array_free (args);
  g_object_unref (tpproxy);
}
TpProxySignalConnection *
future_cli_call_stream_interface_media_connect_to_local_credentials_set (FutureCallStream *proxy,
    future_cli_call_stream_interface_media_signal_callback_local_credentials_set callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object,
    GError **error)
{
  GType expected_types[3] = {
      G_TYPE_STRING,
      G_TYPE_STRING,
      G_TYPE_INVALID };

  g_return_val_if_fail (FUTURE_IS_CALL_STREAM (proxy), NULL);
  g_return_val_if_fail (callback != NULL, NULL);

  return tp_proxy_signal_connection_v0_new ((TpProxy *) proxy,
      FUTURE_IFACE_QUARK_CALL_STREAM_INTERFACE_MEDIA, "LocalCredentialsSet",
      expected_types,
      G_CALLBACK (_future_cli_call_stream_interface_media_collect_args_of_local_credentials_set),
      _future_cli_call_stream_interface_media_invoke_callback_for_local_credentials_set,
      G_CALLBACK (callback), user_data, destroy,
      weak_object, error);
}

static void
_future_cli_call_stream_interface_media_invoke_callback_for_server_info_retrieved (TpProxy *tpproxy,
    GError *error G_GNUC_UNUSED,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  future_cli_call_stream_interface_media_signal_callback_server_info_retrieved callback =
      (future_cli_call_stream_interface_media_signal_callback_server_info_retrieved) generic_callback;

  if (callback != NULL)
    callback (g_object_ref (tpproxy),
      user_data,
      weak_object);

  if (args != NULL)
    g_value_array_free (args);

  g_object_unref (tpproxy);
}
TpProxySignalConnection *
future_cli_call_stream_interface_media_connect_to_server_info_retrieved (FutureCallStream *proxy,
    future_cli_call_stream_interface_media_signal_callback_server_info_retrieved callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object,
    GError **error)
{
  GType expected_types[1] = {
      G_TYPE_INVALID };

  g_return_val_if_fail (FUTURE_IS_CALL_STREAM (proxy), NULL);
  g_return_val_if_fail (callback != NULL, NULL);

  return tp_proxy_signal_connection_v0_new ((TpProxy *) proxy,
      FUTURE_IFACE_QUARK_CALL_STREAM_INTERFACE_MEDIA, "ServerInfoRetrieved",
      expected_types,
      NULL, /* no args => no collector function */
      _future_cli_call_stream_interface_media_invoke_callback_for_server_info_retrieved,
      G_CALLBACK (callback), user_data, destroy,
      weak_object, error);
}

static void
_future_cli_call_stream_interface_media_collect_args_of_endpoints_changed (DBusGProxy *proxy G_GNUC_UNUSED,
    const GPtrArray *arg_EndpointsAdded,
    const GPtrArray *arg_EndpointsRemoved,
    TpProxySignalConnection *sc)
{
  GValueArray *args = g_value_array_new (2);
  GValue blank = { 0 };
  guint i;

  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 2; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, dbus_g_type_get_collection ("GPtrArray", DBUS_TYPE_G_OBJECT_PATH));
  g_value_set_boxed (args->values + 0, arg_EndpointsAdded);

  g_value_unset (args->values + 1);
  g_value_init (args->values + 1, dbus_g_type_get_collection ("GPtrArray", DBUS_TYPE_G_OBJECT_PATH));
  g_value_set_boxed (args->values + 1, arg_EndpointsRemoved);

  tp_proxy_signal_connection_v0_take_results (sc, args);
}
static void
_future_cli_call_stream_interface_media_invoke_callback_for_endpoints_changed (TpProxy *tpproxy,
    GError *error G_GNUC_UNUSED,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  future_cli_call_stream_interface_media_signal_callback_endpoints_changed callback =
      (future_cli_call_stream_interface_media_signal_callback_endpoints_changed) generic_callback;

  if (callback != NULL)
    callback (g_object_ref (tpproxy),
      g_value_get_boxed (args->values + 0),
      g_value_get_boxed (args->values + 1),
      user_data,
      weak_object);

  g_value_array_free (args);
  g_object_unref (tpproxy);
}
TpProxySignalConnection *
future_cli_call_stream_interface_media_connect_to_endpoints_changed (FutureCallStream *proxy,
    future_cli_call_stream_interface_media_signal_callback_endpoints_changed callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object,
    GError **error)
{
  GType expected_types[3] = {
      dbus_g_type_get_collection ("GPtrArray", DBUS_TYPE_G_OBJECT_PATH),
      dbus_g_type_get_collection ("GPtrArray", DBUS_TYPE_G_OBJECT_PATH),
      G_TYPE_INVALID };

  g_return_val_if_fail (FUTURE_IS_CALL_STREAM (proxy), NULL);
  g_return_val_if_fail (callback != NULL, NULL);

  return tp_proxy_signal_connection_v0_new ((TpProxy *) proxy,
      FUTURE_IFACE_QUARK_CALL_STREAM_INTERFACE_MEDIA, "EndpointsChanged",
      expected_types,
      G_CALLBACK (_future_cli_call_stream_interface_media_collect_args_of_endpoints_changed),
      _future_cli_call_stream_interface_media_invoke_callback_for_endpoints_changed,
      G_CALLBACK (callback), user_data, destroy,
      weak_object, error);
}

static void
_future_cli_call_stream_interface_media_collect_callback_add_candidates (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;

  dbus_g_proxy_end_call (proxy, call, &error,
      G_TYPE_INVALID);
  tp_proxy_pending_call_v0_take_results (user_data, error,NULL);
}
static void
_future_cli_call_stream_interface_media_invoke_callback_add_candidates (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  future_cli_call_stream_interface_media_callback_for_add_candidates callback = (future_cli_call_stream_interface_media_callback_for_add_candidates) generic_callback;

  if (error != NULL)
    {
      callback ((FutureCallStream *) self,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((FutureCallStream *) self,
      error, user_data, weak_object);

  if (args != NULL)
    g_value_array_free (args);
}

TpProxyPendingCall *
future_cli_call_stream_interface_media_call_add_candidates (FutureCallStream *proxy,
    gint timeout_ms,
    const GPtrArray *in_candidates,
    future_cli_call_stream_interface_media_callback_for_add_candidates callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = FUTURE_IFACE_QUARK_CALL_STREAM_INTERFACE_MEDIA;
  DBusGProxy *iface;

  g_return_val_if_fail (FUTURE_IS_CALL_STREAM (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "AddCandidates",
          (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)), G_TYPE_INVALID)))), in_candidates,
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "AddCandidates", iface,
          _future_cli_call_stream_interface_media_invoke_callback_add_candidates,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "AddCandidates",
              _future_cli_call_stream_interface_media_collect_callback_add_candidates,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)), G_TYPE_INVALID)))), in_candidates,
              G_TYPE_INVALID));

      return data;
    }
}


static void
_future_cli_call_stream_interface_media_collect_callback_candidates_prepared (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;

  dbus_g_proxy_end_call (proxy, call, &error,
      G_TYPE_INVALID);
  tp_proxy_pending_call_v0_take_results (user_data, error,NULL);
}
static void
_future_cli_call_stream_interface_media_invoke_callback_candidates_prepared (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  future_cli_call_stream_interface_media_callback_for_candidates_prepared callback = (future_cli_call_stream_interface_media_callback_for_candidates_prepared) generic_callback;

  if (error != NULL)
    {
      callback ((FutureCallStream *) self,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((FutureCallStream *) self,
      error, user_data, weak_object);

  if (args != NULL)
    g_value_array_free (args);
}

TpProxyPendingCall *
future_cli_call_stream_interface_media_call_candidates_prepared (FutureCallStream *proxy,
    gint timeout_ms,
    future_cli_call_stream_interface_media_callback_for_candidates_prepared callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = FUTURE_IFACE_QUARK_CALL_STREAM_INTERFACE_MEDIA;
  DBusGProxy *iface;

  g_return_val_if_fail (FUTURE_IS_CALL_STREAM (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "CandidatesPrepared",
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "CandidatesPrepared", iface,
          _future_cli_call_stream_interface_media_invoke_callback_candidates_prepared,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "CandidatesPrepared",
              _future_cli_call_stream_interface_media_collect_callback_candidates_prepared,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              G_TYPE_INVALID));

      return data;
    }
}


/*
 * future_cli_call_stream_add_signals:
 * @self: the #TpProxy
 * @quark: a quark whose string value is the interface
 *   name whose signals should be added
 * @proxy: the D-Bus proxy to which to add the signals
 * @unused: not used for anything
 *
 * Tell dbus-glib that @proxy has the signatures of all
 * signals on the given interface, if it's one we
 * support.
 *
 * This function should be used as a signal handler for
 * #TpProxy::interface-added.
 */
static void
future_cli_call_stream_add_signals (TpProxy *self G_GNUC_UNUSED,
    guint quark,
    DBusGProxy *proxy,
    gpointer unused G_GNUC_UNUSED)
{
  if (quark == FUTURE_IFACE_QUARK_CALL_STREAM)
    future_cli_add_signals_for_call_stream (proxy);
  if (quark == FUTURE_IFACE_QUARK_CALL_STREAM_INTERFACE_MEDIA)
    future_cli_add_signals_for_call_stream_interface_media (proxy);
}
