/**
 * future_cli_call_content_signal_callback_stream_added:
 * @proxy: The proxy on which future_cli_call_content_connect_to_stream_added ()
 *  was called
 * @arg_Stream: The stream which was added
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal StreamAdded.
 */

/**
 * future_cli_call_content_connect_to_stream_added:
 * @proxy: A #FutureCallContent or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal StreamAdded.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;          &lt;p&gt;Emitted when a stream is added to a call&lt;/p&gt;
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * future_cli_call_content_signal_callback_stream_removed:
 * @proxy: The proxy on which future_cli_call_content_connect_to_stream_removed ()
 *  was called
 * @arg_Stream: The stream which was removed
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal StreamRemoved.
 */

/**
 * future_cli_call_content_connect_to_stream_removed:
 * @proxy: A #FutureCallContent or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal StreamRemoved.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;          &lt;p&gt;Emitted when a stream is added to a call&lt;/p&gt;
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * future_cli_call_content_callback_for_remove:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a Remove method call
 * succeeds or fails.
 */

/**
 * future_cli_call_content_call_remove:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a Remove method call.
 *
 * Remove the content from the call.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */


/**
 * future_cli_call_content_interface_media_signal_callback_codecs_changed:
 * @proxy: The proxy on which future_cli_call_content_interface_media_connect_to_codecs_changed ()
 *  was called
 * @arg_Updated_Codecs: A map from contacts to their codecs. Each pair in this map is added           to the &lt;tp:member-ref&gt;ContactCodecMap&lt;/tp:member-ref&gt; property,           replacing any previous pair with that key.
 * @arg_Removed_Contacts: A list of keys which were removed from the           &lt;tp:member-ref&gt;ContactCodecMap&lt;/tp:member-ref&gt;, probably because           those contacts left the call.
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal CodecsChanged.
 */

/**
 * future_cli_call_content_interface_media_connect_to_codecs_changed:
 * @proxy: A #FutureCallContent or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal CodecsChanged.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Emitted when the codecs in use change.&lt;/p&gt;          &lt;p&gt;As well as acting as change notification for the           &lt;tp:member-ref&gt;ContactCodecMap&lt;/tp:member-ref&gt;, emission of this           signal implies that the &lt;tp:member-ref&gt;CodecOffer&lt;/tp:member-ref&gt;           property has changed to &lt;code&gt;(&apos;/&apos;, {})&lt;/code&gt;.&lt;/p&gt;
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * future_cli_call_content_interface_media_signal_callback_new_codec_offer:
 * @proxy: The proxy on which future_cli_call_content_interface_media_connect_to_new_codec_offer ()
 *  was called
 * @arg_Offer: The object path of the new codec offer. This replaces any previous           codec offer.
 * @arg_Codecs: &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;           &lt;p&gt;The &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Call.Content&quot;&gt;CodecOffer.DRAFT.RemoteContactCodecMap&lt;/tp:dbus-ref&gt; property             of the codec offer.&lt;/p&gt;            &lt;tp:rationale&gt;             &lt;p&gt;Having the RemoteContactCodecMap property here saves a D-Bus               round-trip - it shouldn&apos;t be necessary to get the property               from the CodecOffer object, in practice.&lt;/p&gt;           &lt;/tp:rationale&gt;
 * @user_data: User-supplied data
 * @weak_object: User-supplied weakly referenced object
 *
 * Represents the signature of a callback for the signal NewCodecOffer.
 */

/**
 * future_cli_call_content_interface_media_connect_to_new_codec_offer:
 * @proxy: A #FutureCallContent or subclass
 * @callback: Callback to be called when the signal is
 *   received
 * @user_data: User-supplied data for the callback
 * @destroy: Destructor for the user-supplied data, which
 *   will be called when this signal is disconnected, or
 *   before this function returns %NULL
 * @weak_object: A #GObject which will be weakly referenced; 
 *   if it is destroyed, this callback will automatically be
 *   disconnected
 * @error: If not %NULL, used to raise an error if %NULL is
 *   returned
 *
 * Connect a handler to the signal NewCodecOffer.
 *
 * &lt;tp:docstring xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;         &lt;p&gt;Emitted when a new &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Call.Content&quot;&gt;CodecOffer.DRAFT&lt;/tp:dbus-ref&gt; appears. The streaming           implementation MUST respond by calling the &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Call.Content.CodecOffer.DRAFT&quot;&gt;Accept&lt;/tp:dbus-ref&gt; or &lt;tp:dbus-ref namespace=&quot;org.freedesktop.Telepathy.Call.Content.CodecOffer.DRAFT&quot;&gt;Reject&lt;/tp:dbus-ref&gt; method on the codec offer object.&lt;/p&gt;          &lt;p&gt;Emission of this signal indicates that the           &lt;tp:member-ref&gt;CodecOffer&lt;/tp:member-ref&gt; property has changed to           &lt;code&gt;(Offer, Codecs)&lt;/code&gt;.&lt;/p&gt;
 *
 * Returns: a #TpProxySignalConnection containing all of the
 * above, which can be used to disconnect the signal; or
 * %NULL if the proxy does not have the desired interface
 * or has become invalid.
 */

/**
 * future_cli_call_content_interface_media_callback_for_set_codecs:
 * @proxy: the proxy on which the call was made
 * @error: %NULL on success, or an error on failure
 * @user_data: user-supplied data
 * @weak_object: user-supplied object
 *
 * Signature of the callback called when a SetCodecs method call
 * succeeds or fails.
 */

/**
 * future_cli_call_content_interface_media_call_set_codecs:
 * @proxy: the #TpProxy
 * @timeout_ms: the timeout in milliseconds, or -1 to use the
 *   default
 * @in_Codecs: Used to pass an 'in' argument: The codecs now supported by the local user.
 * @callback: called when the method call succeeds or fails;
 *   may be %NULL to make a "fire and forget" call with no 
 *   reply tracking
 * @user_data: user-supplied data passed to the callback;
 *   must be %NULL if @callback is %NULL
 * @destroy: called with the user_data as argument, after the
 *   call has succeeded, failed or been cancelled;
 *   must be %NULL if @callback is %NULL
 * @weak_object: If not %NULL, a #GObject which will be 
 *   weakly referenced; if it is destroyed, this call 
 *   will automatically be cancelled. Must be %NULL if 
 *   @callback is %NULL
 *
 * Start a SetCodecs method call.
 *
 * Set or update the local codec mapping.
 *
 * Returns: a #TpProxyPendingCall representing the call in
 *  progress. It is borrowed from the object, and will become
 *  invalid when the callback is called, the call is
 *  cancelled or the #TpProxy becomes invalid.
 */

