/* We don't want gtkdoc scanning this file, it'll get
 * confused by seeing function definitions, so mark it as: */
/*<private_header>*/

static inline void
example_cli_add_signals_for_connection_interface_hats (DBusGProxy *proxy)
{
  if (!tp_proxy_dbus_g_proxy_claim_for_signal_adding (proxy))
    return;
  dbus_g_proxy_add_signal (proxy, "HatsChanged",
      G_TYPE_UINT,
      G_TYPE_STRING,
      G_TYPE_UINT,
      (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)),
      G_TYPE_INVALID);
}


static void
_example_cli_connection_interface_hats_collect_args_of_hats_changed (DBusGProxy *proxy G_GNUC_UNUSED,
    guint arg_Contact,
    const gchar *arg_Color,
    guint arg_Style,
    GHashTable *arg_Properties,
    TpProxySignalConnection *sc)
{
  GValueArray *args = g_value_array_new (4);
  GValue blank = { 0 };
  guint i;

  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 4; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, G_TYPE_UINT);
  g_value_set_uint (args->values + 0, arg_Contact);

  g_value_unset (args->values + 1);
  g_value_init (args->values + 1, G_TYPE_STRING);
  g_value_set_string (args->values + 1, arg_Color);

  g_value_unset (args->values + 2);
  g_value_init (args->values + 2, G_TYPE_UINT);
  g_value_set_uint (args->values + 2, arg_Style);

  g_value_unset (args->values + 3);
  g_value_init (args->values + 3, (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)));
  g_value_set_boxed (args->values + 3, arg_Properties);

  tp_proxy_signal_connection_v0_take_results (sc, args);
}
static void
_example_cli_connection_interface_hats_invoke_callback_for_hats_changed (TpProxy *tpproxy,
    GError *error G_GNUC_UNUSED,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  example_cli_connection_interface_hats_signal_callback_hats_changed callback =
      (example_cli_connection_interface_hats_signal_callback_hats_changed) generic_callback;

  if (callback != NULL)
    callback (g_object_ref (tpproxy),
      g_value_get_uint (args->values + 0),
      g_value_get_string (args->values + 1),
      g_value_get_uint (args->values + 2),
      g_value_get_boxed (args->values + 3),
      user_data,
      weak_object);

  g_value_array_free (args);
  g_object_unref (tpproxy);
}
TpProxySignalConnection *
example_cli_connection_interface_hats_connect_to_hats_changed (TpConnection *proxy,
    example_cli_connection_interface_hats_signal_callback_hats_changed callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object,
    GError **error)
{
  GType expected_types[5] = {
      G_TYPE_UINT,
      G_TYPE_STRING,
      G_TYPE_UINT,
      (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)),
      G_TYPE_INVALID };

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), NULL);
  g_return_val_if_fail (callback != NULL, NULL);

  return tp_proxy_signal_connection_v0_new ((TpProxy *) proxy,
      EXAMPLE_IFACE_QUARK_CONNECTION_INTERFACE_HATS, "HatsChanged",
      expected_types,
      G_CALLBACK (_example_cli_connection_interface_hats_collect_args_of_hats_changed),
      _example_cli_connection_interface_hats_invoke_callback_for_hats_changed,
      G_CALLBACK (callback), user_data, destroy,
      weak_object, error);
}

static void
_example_cli_connection_interface_hats_collect_callback_get_hats (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;
  GValueArray *args;
  GValue blank = { 0 };
  guint i;
  GPtrArray *out_Hats;

  dbus_g_proxy_end_call (proxy, call, &error,
      (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)), G_TYPE_INVALID)))), &out_Hats,
      G_TYPE_INVALID);

  if (error != NULL)
    {
      tp_proxy_pending_call_v0_take_results (user_data, error,
          NULL);
      return;
    }

  args = g_value_array_new (1);
  g_value_init (&blank, G_TYPE_INT);

  for (i = 0; i < 1; i++)
    g_value_array_append (args, &blank);

  g_value_unset (args->values + 0);
  g_value_init (args->values + 0, (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)), G_TYPE_INVALID)))));
  g_value_take_boxed (args->values + 0, out_Hats);
  tp_proxy_pending_call_v0_take_results (user_data, NULL, args);
}
static void
_example_cli_connection_interface_hats_invoke_callback_get_hats (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  example_cli_connection_interface_hats_callback_for_get_hats callback = (example_cli_connection_interface_hats_callback_for_get_hats) generic_callback;

  if (error != NULL)
    {
      callback ((TpConnection *) self,
          NULL,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((TpConnection *) self,
      g_value_get_boxed (args->values + 0),
      error, user_data, weak_object);

  g_value_array_free (args);
}

TpProxyPendingCall *
example_cli_connection_interface_hats_call_get_hats (TpConnection *proxy,
    gint timeout_ms,
    const GArray *in_Contact,
    example_cli_connection_interface_hats_callback_for_get_hats callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = EXAMPLE_IFACE_QUARK_CONNECTION_INTERFACE_HATS;
  DBusGProxy *iface;

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            NULL,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "GetHats",
          DBUS_TYPE_G_UINT_ARRAY, in_Contact,
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "GetHats", iface,
          _example_cli_connection_interface_hats_invoke_callback_get_hats,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "GetHats",
              _example_cli_connection_interface_hats_collect_callback_get_hats,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              DBUS_TYPE_G_UINT_ARRAY, in_Contact,
              G_TYPE_INVALID));

      return data;
    }
}

typedef struct {
    GMainLoop *loop;
    GError **error;
    GPtrArray **out_Hats;
    unsigned success:1;
    unsigned completed:1;
} _example_cli_connection_interface_hats_run_state_get_hats;
static void
_example_cli_connection_interface_hats_finish_running_get_hats (TpProxy *self G_GNUC_UNUSED,
    GError *error,
    GValueArray *args,
    GCallback unused G_GNUC_UNUSED,
    gpointer user_data G_GNUC_UNUSED,
    GObject *unused2 G_GNUC_UNUSED)
{
  _example_cli_connection_interface_hats_run_state_get_hats *state = user_data;

  state->success = (error == NULL);
  state->completed = TRUE;
  g_main_loop_quit (state->loop);

  if (error != NULL)
    {
      if (state->error != NULL)
        *state->error = error;
      else
        g_error_free (error);

      return;
    }

  if (state->out_Hats != NULL)
    *state->out_Hats = g_value_dup_boxed (args->values + 0);

  g_value_array_free (args);
}

gboolean
example_cli_connection_interface_hats_run_get_hats (TpConnection *proxy,
    gint timeout_ms,
    const GArray *in_Contact,
    GPtrArray **out_Hats,
    GError **error,
    GMainLoop **loop)
{
  DBusGProxy *iface;
  GQuark interface = EXAMPLE_IFACE_QUARK_CONNECTION_INTERFACE_HATS;
  TpProxyPendingCall *pc;
  _example_cli_connection_interface_hats_run_state_get_hats state = {
      NULL /* loop */, error,
    out_Hats,
      FALSE /* completed */, FALSE /* success */ };

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), FALSE);

  iface = tp_proxy_borrow_interface_by_id
       ((TpProxy *) proxy, interface, error);

  if (iface == NULL)
    return FALSE;

  state.loop = g_main_loop_new (NULL, FALSE);

  pc = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
      interface, "GetHats", iface,
      _example_cli_connection_interface_hats_finish_running_get_hats,
      NULL, &state, NULL, NULL, TRUE);

  if (loop != NULL)
    *loop = state.loop;

  tp_proxy_pending_call_v0_take_pending_call (pc,
      dbus_g_proxy_begin_call_with_timeout (iface,
          "GetHats",
          _example_cli_connection_interface_hats_collect_callback_get_hats,
          pc,
          tp_proxy_pending_call_v0_completed,
          timeout_ms,
              DBUS_TYPE_G_UINT_ARRAY, in_Contact,
          G_TYPE_INVALID));

  if (!state.completed)
    g_main_loop_run (state.loop);

  if (!state.completed)
    tp_proxy_pending_call_cancel (pc);

  if (loop != NULL)
    *loop = NULL;

  g_main_loop_unref (state.loop);

  return state.success;
}


static void
_example_cli_connection_interface_hats_collect_callback_set_hat (DBusGProxy *proxy,
    DBusGProxyCall *call,
    gpointer user_data)
{
  GError *error = NULL;

  dbus_g_proxy_end_call (proxy, call, &error,
      G_TYPE_INVALID);
  tp_proxy_pending_call_v0_take_results (user_data, error,NULL);
}
static void
_example_cli_connection_interface_hats_invoke_callback_set_hat (TpProxy *self,
    GError *error,
    GValueArray *args,
    GCallback generic_callback,
    gpointer user_data,
    GObject *weak_object)
{
  example_cli_connection_interface_hats_callback_for_set_hat callback = (example_cli_connection_interface_hats_callback_for_set_hat) generic_callback;

  if (error != NULL)
    {
      callback ((TpConnection *) self,
          error, user_data, weak_object);
      g_error_free (error);
      return;
    }
  callback ((TpConnection *) self,
      error, user_data, weak_object);

  if (args != NULL)
    g_value_array_free (args);
}

TpProxyPendingCall *
example_cli_connection_interface_hats_call_set_hat (TpConnection *proxy,
    gint timeout_ms,
    const gchar *in_Color,
    guint in_Style,
    GHashTable *in_Properties,
    example_cli_connection_interface_hats_callback_for_set_hat callback,
    gpointer user_data,
    GDestroyNotify destroy,
    GObject *weak_object)
{
  GError *error = NULL;
  GQuark interface = EXAMPLE_IFACE_QUARK_CONNECTION_INTERFACE_HATS;
  DBusGProxy *iface;

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), NULL);
  g_return_val_if_fail (callback != NULL || user_data == NULL, NULL);
  g_return_val_if_fail (callback != NULL || destroy == NULL, NULL);
  g_return_val_if_fail (callback != NULL || weak_object == NULL, NULL);

  iface = tp_proxy_borrow_interface_by_id (
      (TpProxy *) proxy,
      interface, &error);

  if (iface == NULL)
    {
      if (callback != NULL)
        callback (proxy,
            error, user_data, weak_object);

      if (destroy != NULL)
        destroy (user_data);

      g_error_free (error);
      return NULL;
    }

  if (callback == NULL)
    {
      dbus_g_proxy_call_no_reply (iface, "SetHat",
          G_TYPE_STRING, in_Color,
          G_TYPE_UINT, in_Style,
          (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)), in_Properties,
          G_TYPE_INVALID);
      return NULL;
    }
  else
    {
      TpProxyPendingCall *data;

      data = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
          interface, "SetHat", iface,
          _example_cli_connection_interface_hats_invoke_callback_set_hat,
          G_CALLBACK (callback), user_data, destroy,
          weak_object, FALSE);
      tp_proxy_pending_call_v0_take_pending_call (data,
          dbus_g_proxy_begin_call_with_timeout (iface,
              "SetHat",
              _example_cli_connection_interface_hats_collect_callback_set_hat,
              data,
              tp_proxy_pending_call_v0_completed,
              timeout_ms,
              G_TYPE_STRING, in_Color,
              G_TYPE_UINT, in_Style,
              (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)), in_Properties,
              G_TYPE_INVALID));

      return data;
    }
}

typedef struct {
    GMainLoop *loop;
    GError **error;
    unsigned success:1;
    unsigned completed:1;
} _example_cli_connection_interface_hats_run_state_set_hat;
static void
_example_cli_connection_interface_hats_finish_running_set_hat (TpProxy *self G_GNUC_UNUSED,
    GError *error,
    GValueArray *args,
    GCallback unused G_GNUC_UNUSED,
    gpointer user_data G_GNUC_UNUSED,
    GObject *unused2 G_GNUC_UNUSED)
{
  _example_cli_connection_interface_hats_run_state_set_hat *state = user_data;

  state->success = (error == NULL);
  state->completed = TRUE;
  g_main_loop_quit (state->loop);

  if (error != NULL)
    {
      if (state->error != NULL)
        *state->error = error;
      else
        g_error_free (error);

      return;
    }

  if (args != NULL)
    g_value_array_free (args);
}

gboolean
example_cli_connection_interface_hats_run_set_hat (TpConnection *proxy,
    gint timeout_ms,
    const gchar *in_Color,
    guint in_Style,
    GHashTable *in_Properties,
    GError **error,
    GMainLoop **loop)
{
  DBusGProxy *iface;
  GQuark interface = EXAMPLE_IFACE_QUARK_CONNECTION_INTERFACE_HATS;
  TpProxyPendingCall *pc;
  _example_cli_connection_interface_hats_run_state_set_hat state = {
      NULL /* loop */, error,
      FALSE /* completed */, FALSE /* success */ };

  g_return_val_if_fail (TP_IS_CONNECTION (proxy), FALSE);

  iface = tp_proxy_borrow_interface_by_id
       ((TpProxy *) proxy, interface, error);

  if (iface == NULL)
    return FALSE;

  state.loop = g_main_loop_new (NULL, FALSE);

  pc = tp_proxy_pending_call_v0_new ((TpProxy *) proxy,
      interface, "SetHat", iface,
      _example_cli_connection_interface_hats_finish_running_set_hat,
      NULL, &state, NULL, NULL, TRUE);

  if (loop != NULL)
    *loop = state.loop;

  tp_proxy_pending_call_v0_take_pending_call (pc,
      dbus_g_proxy_begin_call_with_timeout (iface,
          "SetHat",
          _example_cli_connection_interface_hats_collect_callback_set_hat,
          pc,
          tp_proxy_pending_call_v0_completed,
          timeout_ms,
              G_TYPE_STRING, in_Color,
              G_TYPE_UINT, in_Style,
              (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)), in_Properties,
          G_TYPE_INVALID));

  if (!state.completed)
    g_main_loop_run (state.loop);

  if (!state.completed)
    tp_proxy_pending_call_cancel (pc);

  if (loop != NULL)
    *loop = NULL;

  g_main_loop_unref (state.loop);

  return state.success;
}


/*
 * example_cli_connection_add_signals:
 * @self: the #TpProxy
 * @quark: a quark whose string value is the interface
 *   name whose signals should be added
 * @proxy: the D-Bus proxy to which to add the signals
 * @unused: not used for anything
 *
 * Tell dbus-glib that @proxy has the signatures of all
 * signals on the given interface, if it's one we
 * support.
 *
 * This function should be used as a signal handler for
 * #TpProxy::interface-added.
 */
static void
example_cli_connection_add_signals (TpProxy *self G_GNUC_UNUSED,
    guint quark,
    DBusGProxy *proxy,
    gpointer unused G_GNUC_UNUSED)
{
  if (quark == EXAMPLE_IFACE_QUARK_CONNECTION_INTERFACE_HATS)
    example_cli_add_signals_for_connection_interface_hats (proxy);
}
