


#include <wocky-tls.h>
#include <wocky-tls-enumtypes.h>

/* enumerations from "wocky-tls.h" */
GType
wocky_tls_verification_level_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { WOCKY_TLS_VERIFY_STRICT, "WOCKY_TLS_VERIFY_STRICT", "strict" },
      { WOCKY_TLS_VERIFY_NORMAL, "WOCKY_TLS_VERIFY_NORMAL", "normal" },
      { WOCKY_TLS_VERIFY_LENIENT, "WOCKY_TLS_VERIFY_LENIENT", "lenient" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("WockyTLSVerificationLevel", values);
  }
  return etype;
}
GType
wocky_tls_cert_status_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { WOCKY_TLS_CERT_OK, "WOCKY_TLS_CERT_OK", "ok" },
      { WOCKY_TLS_CERT_INVALID, "WOCKY_TLS_CERT_INVALID", "invalid" },
      { WOCKY_TLS_CERT_NAME_MISMATCH, "WOCKY_TLS_CERT_NAME_MISMATCH", "name-mismatch" },
      { WOCKY_TLS_CERT_REVOKED, "WOCKY_TLS_CERT_REVOKED", "revoked" },
      { WOCKY_TLS_CERT_SIGNER_UNKNOWN, "WOCKY_TLS_CERT_SIGNER_UNKNOWN", "signer-unknown" },
      { WOCKY_TLS_CERT_SIGNER_UNAUTHORISED, "WOCKY_TLS_CERT_SIGNER_UNAUTHORISED", "signer-unauthorised" },
      { WOCKY_TLS_CERT_INSECURE, "WOCKY_TLS_CERT_INSECURE", "insecure" },
      { WOCKY_TLS_CERT_NOT_ACTIVE, "WOCKY_TLS_CERT_NOT_ACTIVE", "not-active" },
      { WOCKY_TLS_CERT_EXPIRED, "WOCKY_TLS_CERT_EXPIRED", "expired" },
      { WOCKY_TLS_CERT_NO_CERTIFICATE, "WOCKY_TLS_CERT_NO_CERTIFICATE", "no-certificate" },
      { WOCKY_TLS_CERT_MAYBE_DOS, "WOCKY_TLS_CERT_MAYBE_DOS", "maybe-dos" },
      { WOCKY_TLS_CERT_INTERNAL_ERROR, "WOCKY_TLS_CERT_INTERNAL_ERROR", "internal-error" },
      { WOCKY_TLS_CERT_UNKNOWN_ERROR, "WOCKY_TLS_CERT_UNKNOWN_ERROR", "unknown-error" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("WockyTLSCertStatus", values);
  }
  return etype;
}
GType
wocky_tls_cert_type_get_type (void)
{
  static GType etype = 0;
  if (etype == 0) {
    static const GEnumValue values[] = {
      { WOCKY_TLS_CERT_TYPE_NONE, "WOCKY_TLS_CERT_TYPE_NONE", "none" },
      { WOCKY_TLS_CERT_TYPE_X509, "WOCKY_TLS_CERT_TYPE_X509", "x509" },
      { WOCKY_TLS_CERT_TYPE_OPENPGP, "WOCKY_TLS_CERT_TYPE_OPENPGP", "openpgp" },
      { 0, NULL, NULL }
    };
    etype = g_enum_register_static ("WockyTLSCertType", values);
  }
  return etype;
}



