/* Generated from Gabble-specific extensions to the Telepathy interfaces

Copyright (C) 2007 Collabora Limited

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


 */

#ifdef __cplusplus
extern "C" {
#endif

/**
 *
GabbleMailNotificationFlags:
 * @GABBLE_MAIL_NOTIFICATION_FLAG_SUPPORTS_UNREAD_MAIL_COUNT: <![CDATA[           This Connection provides the number of unread e-mails (or e-mail           threads) in the main folder of your e-mail account, as the           UnreadMailCount property. The           connection manager will update this value by emitting the           UnreadMailsChanged signal.         ]]>
 * @GABBLE_MAIL_NOTIFICATION_FLAG_SUPPORTS_UNREAD_MAILS: <![CDATA[           This Connection provides a detailed list of unread e-mails, as the           UnreadMails property. If this flag           is set, Supports_Unread_Mail_Count MUST be set, and           Emits_Mails_Received MUST NOT be set.           The Connection will update the list by emitting the           UnreadMailsChanged signals.         ]]>
 * @GABBLE_MAIL_NOTIFICATION_FLAG_EMITS_MAILS_RECEIVED: <![CDATA[           This Connection emits the MailsReceived           signal, which provides details about newly arrived e-mails but does           not maintain their read/unread status afterwards. This flag MUST NOT           be combined with Supports_Unread_Mails.         ]]>
 * @GABBLE_MAIL_NOTIFICATION_FLAG_SUPPORTS_REQUEST_INBOX_URL: <![CDATA[           This Connection can provide a URL (with optional POST data) to           open the the inbox of the e-mail account in a web-based client, via           the RequestInboxURL method.         ]]>
 * @GABBLE_MAIL_NOTIFICATION_FLAG_SUPPORTS_REQUEST_MAIL_URL: <![CDATA[           This Connection can provide a URL (with optional POST data) to open             a specific mail in a web-based client, via the             RequestMailURL method. This feature             is not useful unless either Emits_Mails_Received or             Supports_Unread_Mails is set.            If this flag is not set, clients SHOULD fall back to using             RequestInboxURL if available.         ]]>
 * @GABBLE_MAIL_NOTIFICATION_FLAG_THREAD_BASED: <![CDATA[           Each Mail represents a thread of e-mails, which             MAY have more than one sender.                         Google Talk notifies users about new mail in terms of unread               threads, rather than unread e-mails.                    ]]>
 *
 * <![CDATA[         Flags representing capabilities provided by a connection manager.           Those values can be used as bitfield. Some flags depend on, or           conflict with, each other.          Connections SHOULD implement as many of these features as the           underlying protocol allows, preferring to implement           Supports_Unread_Mails instead of Emits_Mails_Received if both are           possible.       ]]>
 *
 * Bitfield/set of flags generated from the Telepathy specification.
 */
typedef enum {
    GABBLE_MAIL_NOTIFICATION_FLAG_SUPPORTS_UNREAD_MAIL_COUNT = 1,
    GABBLE_MAIL_NOTIFICATION_FLAG_SUPPORTS_UNREAD_MAILS = 2,
    GABBLE_MAIL_NOTIFICATION_FLAG_EMITS_MAILS_RECEIVED = 4,
    GABBLE_MAIL_NOTIFICATION_FLAG_SUPPORTS_REQUEST_INBOX_URL = 8,
    GABBLE_MAIL_NOTIFICATION_FLAG_SUPPORTS_REQUEST_MAIL_URL = 16,
    GABBLE_MAIL_NOTIFICATION_FLAG_THREAD_BASED = 32,
} GabbleMailNotificationFlags;

/**
 *
GabbleHTTPMethod:
 * @GABBLE_HTTP_METHOD_GET: <![CDATA[           Use the GET method when opening the URL.         ]]>
 * @GABBLE_HTTP_METHOD_POST: <![CDATA[           Use the POST method when opening the URL. Refer to           HTTP_Post_Data for more details.         ]]>
 *
 * <![CDATA[         The HTTP Method with which to request a URL.       ]]>
 *
 * Bitfield/set of flags generated from the Telepathy specification.
 */
typedef enum {
    GABBLE_HTTP_METHOD_GET = 0,
    GABBLE_HTTP_METHOD_POST = 1,
} GabbleHTTPMethod;

/**
 * NUM_GABBLE_HTTP_METHODS:
 *
 * 1 higher than the highest valid value of #GabbleHTTPMethod.
 */
#define NUM_GABBLE_HTTP_METHODS (1+1)

/**
 *
GabbleCallContentDisposition:
 * @GABBLE_CALL_CONTENT_DISPOSITION_NONE: <![CDATA[           The content has no specific disposition         ]]>
 * @GABBLE_CALL_CONTENT_DISPOSITION_EARLY_MEDIA: <![CDATA[           [FIXME: what does this mean?]         ]]>
 * @GABBLE_CALL_CONTENT_DISPOSITION_INITIAL: <![CDATA[           The content was initially part of the call. When Accept is called on the channel, all streams of             this content where the self-handle's sending state in Senders is Sending_State_Pending_Send             will be moved to Sending_State_Sending as if SetSending(TRUE) had been called.         ]]>
 *
 * <![CDATA[         [FIXME]       ]]>
 *
 * Bitfield/set of flags generated from the Telepathy specification.
 */
typedef enum {
    GABBLE_CALL_CONTENT_DISPOSITION_NONE = 0,
    GABBLE_CALL_CONTENT_DISPOSITION_EARLY_MEDIA = 1,
    GABBLE_CALL_CONTENT_DISPOSITION_INITIAL = 2,
} GabbleCallContentDisposition;

/**
 * NUM_GABBLE_CALL_CONTENT_DISPOSITIONS:
 *
 * 1 higher than the highest valid value of #GabbleCallContentDisposition.
 */
#define NUM_GABBLE_CALL_CONTENT_DISPOSITIONS (2+1)

/**
 *
GabbleSendingState:
 * @GABBLE_SENDING_STATE_NONE: <![CDATA[           The contact is not sending media and has not been asked to do so.         ]]>
 * @GABBLE_SENDING_STATE_PENDING_SEND: <![CDATA[           The contact has been asked to start sending media.         ]]>
 * @GABBLE_SENDING_STATE_SENDING: <![CDATA[           The contact is sending media.         ]]>
 *
 * <![CDATA[         Tristate indicating whether a contact is sending media.       ]]>
 *
 * Bitfield/set of flags generated from the Telepathy specification.
 */
typedef enum {
    GABBLE_SENDING_STATE_NONE = 0,
    GABBLE_SENDING_STATE_PENDING_SEND = 1,
    GABBLE_SENDING_STATE_SENDING = 2,
} GabbleSendingState;

/**
 * NUM_GABBLE_SENDING_STATES:
 *
 * 1 higher than the highest valid value of #GabbleSendingState.
 */
#define NUM_GABBLE_SENDING_STATES (2+1)

/**
 *
GabbleStreamTransportType:
 * @GABBLE_STREAM_TRANSPORT_TYPE_RAW_UDP: <![CDATA[           Raw UDP, with or without STUN. All streaming clients are assumed to           support this transport, so there is no handler capability token for           it in the Call.DRAFT interface.           [This corresponds to "none" or "stun" in the old Media.StreamHandler           interface.]         ]]>
 * @GABBLE_STREAM_TRANSPORT_TYPE_ICE: <![CDATA[           Interactive Connectivity Establishment, as defined by the IETF MMUSIC           working group.           [FIXME: do we want this to cover both ICE-UDP and ICE-TCP, or split           them?]           [This corresponds to "ice-udp" in the old Media.StreamHandler           interface.]         ]]>
 * @GABBLE_STREAM_TRANSPORT_TYPE_GTALK_P2P: <![CDATA[           Google Talk peer-to-peer connectivity establishment, as implemented           by libjingle 0.3.           [This corresponds to "gtalk-p2p" in the old Media.StreamHandler           interface.]         ]]>
 * @GABBLE_STREAM_TRANSPORT_TYPE_WLM_8_5: <![CDATA[           The transport used by Windows Live Messenger 8.5 or later, which           resembles ICE draft 6.           [This corresponds to "wlm-8.5" in the old Media.StreamHandler           interface.]         ]]>
 * @GABBLE_STREAM_TRANSPORT_TYPE_WLM_2009: <![CDATA[           The transport used by Windows Live Messenger 2009 or later, which           resembles ICE draft 19.           [This corresponds to "wlm-2009" in the old Media.StreamHandler           interface.]         ]]>
 *
 * <![CDATA[         A transport that can be used for streaming.       ]]>
 *
 * Bitfield/set of flags generated from the Telepathy specification.
 */
typedef enum {
    GABBLE_STREAM_TRANSPORT_TYPE_RAW_UDP = 0,
    GABBLE_STREAM_TRANSPORT_TYPE_ICE = 1,
    GABBLE_STREAM_TRANSPORT_TYPE_GTALK_P2P = 2,
    GABBLE_STREAM_TRANSPORT_TYPE_WLM_8_5 = 3,
    GABBLE_STREAM_TRANSPORT_TYPE_WLM_2009 = 4,
} GabbleStreamTransportType;

/**
 * NUM_GABBLE_STREAM_TRANSPORT_TYPES:
 *
 * 1 higher than the highest valid value of #GabbleStreamTransportType.
 */
#define NUM_GABBLE_STREAM_TRANSPORT_TYPES (4+1)

/**
 *
GabbleCallState:
 * @GABBLE_CALL_STATE_UNKNOWN: <![CDATA[           The call state is not known. This call state MUST NOT appear as a           value of the CallState property, but           MAY be used by client code to represent calls whose state is as yet           unknown.         ]]>
 * @GABBLE_CALL_STATE_PENDING_INITIATOR: <![CDATA[           The initiator of the call hasn't accepted the call yet. This state           only makes sense for outgoing calls, where it means that the local           user has not yet sent any signalling messages to the remote user(s),           and will not do so until Accept is           called.         ]]>
 * @GABBLE_CALL_STATE_PENDING_RECEIVER: <![CDATA[           The receiver (the contact being called) hasn't accepted the call yet.         ]]>
 * @GABBLE_CALL_STATE_ACCEPTED: <![CDATA[           The contact being called has accepted the call.         ]]>
 * @GABBLE_CALL_STATE_ENDED: <![CDATA[           The call has ended, either via normal termination or an error.         ]]>
 *
 * <![CDATA[         The state of a call, as a whole.          The allowed transitions are:                     Pending_Initiator → Pending_Receiver (for outgoing calls,             when Accept is called)           Pending_Receiver → Accepted (for incoming calls, when             Accept is called; for outgoing             calls to a contact, when the remote contact accepts the call;             for joining a conference call, when the local user successfully             joins the conference)           Accepted → Pending_Receiver (when transferred to another             contact)           any state → Ended (when the call is terminated normally, or             when an error occurs)                   Clients MAY consider unknown values from this enum to be an           error - additional values will not be defined after the Call           specification is declared to be stable.       ]]>
 *
 * Bitfield/set of flags generated from the Telepathy specification.
 */
typedef enum {
    GABBLE_CALL_STATE_UNKNOWN = 0,
    GABBLE_CALL_STATE_PENDING_INITIATOR = 1,
    GABBLE_CALL_STATE_PENDING_RECEIVER = 2,
    GABBLE_CALL_STATE_ACCEPTED = 3,
    GABBLE_CALL_STATE_ENDED = 4,
} GabbleCallState;

/**
 * NUM_GABBLE_CALL_STATES:
 *
 * 1 higher than the highest valid value of #GabbleCallState.
 */
#define NUM_GABBLE_CALL_STATES (4+1)

/**
 *
GabbleCallFlags:
 * @GABBLE_CALL_FLAG_LOCALLY_RINGING: <![CDATA[           The local contact has been alerted about the call but has not           responded; if possible, the remote contact(s) have been informed of           this fact. This flag only makes sense on incoming calls in           state Call_State_Pending_Receiver. It SHOULD be set when           Ringing is called successfully, and           unset when the state changes.         ]]>
 * @GABBLE_CALL_FLAG_QUEUED: <![CDATA[           The contact is temporarily unavailable, and the call has been placed           in a queue (e.g. 182 Queued in SIP, or call-waiting in telephony).           This flag only makes sense on outgoing 1-1 calls in           state Call_State_Pending_Receiver. It SHOULD be set or unset           according to informational messages from other contacts.         ]]>
 * @GABBLE_CALL_FLAG_LOCALLY_HELD: <![CDATA[           The call has been put on hold by the local user, e.g. using the           Hold interface. This flag SHOULD only be set if           there is at least one Content, and all Contents are locally held;           it makes sense on calls in state Call_State_Pending_Receiver or           Call_State_Accepted.                         Otherwise, in transient situations where some but not all contents             are on hold, UIs would falsely indicate that the call as a whole             is on hold, which could lead to the user saying something they'll             regret, while under the impression that the other contacts can't             hear them!                    ]]>
 * @GABBLE_CALL_FLAG_FORWARDED: <![CDATA[           The initiator of the call originally called a contact other than the           current recipient of the call, but the call was then forwarded or           diverted. This flag only makes sense on outgoing calls, in state           Call_State_Pending_Receiver or Call_State_Accepted. It SHOULD be           set or unset according to informational messages from other contacts.         ]]>
 * @GABBLE_CALL_FLAG_IN_PROGRESS: <![CDATA[           Progress has been made in placing the outgoing call, but the           contact may not have been made aware of the call yet           (so the Ringing state is not appropriate). This corresponds to SIP's           status code 183 Session Progress, and could be used when the           outgoing call has reached a gateway, for instance.           This flag only makes sense on outgoing calls in state           Call_State_Pending_Receiver, and SHOULD be set or unset according to           informational messages from servers, gateways and other           infrastructure.         ]]>
 * @GABBLE_CALL_FLAG_CLEARING: <![CDATA[           This flag only occurs when the CallState is Ended. The call with           this flag set has ended, but not all resources corresponding to the           call have been freed yet.            Depending on the protocol there might be some audible feedback while           the clearing flag is set.                         In calls following the ITU-T Q.931 standard there is a period of             time between the call ending and the underlying channel being             completely free for re-use.                    ]]>
 *
 * <![CDATA[         A set of flags representing the status of the call as a whole,         providing more specific information than the         CallState. Many of these flags only make         sense in a particular state.       ]]>
 *
 * Bitfield/set of flags generated from the Telepathy specification.
 */
typedef enum {
    GABBLE_CALL_FLAG_LOCALLY_RINGING = 1,
    GABBLE_CALL_FLAG_QUEUED = 2,
    GABBLE_CALL_FLAG_LOCALLY_HELD = 4,
    GABBLE_CALL_FLAG_FORWARDED = 8,
    GABBLE_CALL_FLAG_IN_PROGRESS = 16,
    GABBLE_CALL_FLAG_CLEARING = 32,
} GabbleCallFlags;

/**
 *
GabbleCallStateChangeReason:
 * @GABBLE_CALL_STATE_CHANGE_REASON_UNKNOWN: <![CDATA[           We just don't know. Unknown values of this enum SHOULD also be           treated like this.         ]]>
 * @GABBLE_CALL_STATE_CHANGE_REASON_USER_REQUESTED: <![CDATA[           The change was requested by the contact indicated by the Actor             member of a Call_State_Reason struct.            If the Actor is the local user, the DBus_Reason SHOULD be the             empty string.            If the Actor is a remote user, the DBus_Reason SHOULD be the empty             string if the call was terminated normally, but MAY be a non-empty             error name to indicate error-like call termination reasons (call             rejected as busy, kicked from a conference by a moderator, etc.).         ]]>
 *
 * <![CDATA[         A simple representation of the reason for a change in the call's         state, which may be used by simple clients, or used as a fallback         when the DBus_Reason member of a Call_State_Reason         struct is not understood.       ]]>
 *
 * Bitfield/set of flags generated from the Telepathy specification.
 */
typedef enum {
    GABBLE_CALL_STATE_CHANGE_REASON_UNKNOWN = 0,
    GABBLE_CALL_STATE_CHANGE_REASON_USER_REQUESTED = 1,
} GabbleCallStateChangeReason;

/**
 * NUM_GABBLE_CALL_STATE_CHANGE_REASONS:
 *
 * 1 higher than the highest valid value of #GabbleCallStateChangeReason.
 */
#define NUM_GABBLE_CALL_STATE_CHANGE_REASONS (1+1)

/**
 *
GabbleCallMemberFlags:
 * @GABBLE_CALL_MEMBER_FLAG_RINGING: <![CDATA[           The remote contact's client has told us that the contact has been             alerted about the call but has not responded.                         This is a flag per member, not a flag for the call as a whole,               because in Muji conference calls, you could invite someone and               have their state be "ringing" for a while.                    ]]>
 * @GABBLE_CALL_MEMBER_FLAG_HELD: <![CDATA[           The call member has put this call on hold.                         This is a flag per member, not a flag for the call as a whole,               because in conference calls, any member could put the conference               on hold.                    ]]>
 *
 * <![CDATA[         A set of flags representing the status of a remote contact in a           call.          It is protocol- and client-specific whether a particular contact           will ever have a particular flag set on them, and Telepathy clients           SHOULD NOT assume that a flag will ever be set.                     180 Ringing in SIP, and its equivalent in XMPP, are optional             informational messages, and implementations are not required             to send them. The same applies to the messages used to indicate             hold state.                ]]>
 *
 * Bitfield/set of flags generated from the Telepathy specification.
 */
typedef enum {
    GABBLE_CALL_MEMBER_FLAG_RINGING = 1,
    GABBLE_CALL_MEMBER_FLAG_HELD = 2,
} GabbleCallMemberFlags;

/**
 *
GabbleAuthenticationType:
 * @GABBLE_AUTHENTICATION_TYPE_SASL: <![CDATA[           SASL authentication.         ]]>
 * @GABBLE_AUTHENTICATION_TYPE_CAPTCHA: <![CDATA[           Captcha authentication.         ]]>
 *
 * Bitfield/set of flags generated from the Telepathy specification.
 */
typedef enum {
    GABBLE_AUTHENTICATION_TYPE_SASL = 0,
    GABBLE_AUTHENTICATION_TYPE_CAPTCHA = 1,
} GabbleAuthenticationType;

/**
 * NUM_GABBLE_AUTHENTICATION_TYPES:
 *
 * 1 higher than the highest valid value of #GabbleAuthenticationType.
 */
#define NUM_GABBLE_AUTHENTICATION_TYPES (1+1)

/**
 *
GabbleAbortReason:
 * @GABBLE_ABORT_REASON_INVALID_CHALLENGE: <![CDATA[           Server sent an invalid challenge or data.         ]]>
 * @GABBLE_ABORT_REASON_USER_ABORT: <![CDATA[           User aborted the authentication.         ]]>
 *
 * Bitfield/set of flags generated from the Telepathy specification.
 */
typedef enum {
    GABBLE_ABORT_REASON_INVALID_CHALLENGE = 0,
    GABBLE_ABORT_REASON_USER_ABORT = 1,
} GabbleAbortReason;

/**
 * NUM_GABBLE_ABORT_REASONS:
 *
 * 1 higher than the highest valid value of #GabbleAbortReason.
 */
#define NUM_GABBLE_ABORT_REASONS (1+1)

/**
 *
GabbleSaslStatus:
 * @GABBLE_SASL_STATUS_NOT_STARTED: <![CDATA[           Need to call StartMechanism to start.         ]]>
 * @GABBLE_SASL_STATUS_IN_PROGRESS: <![CDATA[           Challenge/Response cycle in progress         ]]>
 * @GABBLE_SASL_STATUS_SERVER_SUCCEEDED: <![CDATA[           Server indicated successful authentication, handler needs to           Accept or Abort.         ]]>
 * @GABBLE_SASL_STATUS_CLIENT_ACCEPTED: <![CDATA[           Handler indicates that from its perspective the           authentication has successfully finished.         ]]>
 * @GABBLE_SASL_STATUS_SUCCEEDED: <![CDATA[           Everyone is happy (server sent success, client sent Accept),                    up to the handler to close the channel.         ]]>
 * @GABBLE_SASL_STATUS_SERVER_FAILED: <![CDATA[           Server indicated an authentication failure,           Authentication can be restarted by calling           StartMechanism again or completely aborted by Closing           the channel.         ]]>
 * @GABBLE_SASL_STATUS_CLIENT_FAILED: <![CDATA[           Client indicated an authentication failure,           Authentication can be restarted by calling           StartMechanism again or completely aborted by Closing           the channel.         ]]>
 *
 * Bitfield/set of flags generated from the Telepathy specification.
 */
typedef enum {
    GABBLE_SASL_STATUS_NOT_STARTED = 0,
    GABBLE_SASL_STATUS_IN_PROGRESS = 1,
    GABBLE_SASL_STATUS_SERVER_SUCCEEDED = 2,
    GABBLE_SASL_STATUS_CLIENT_ACCEPTED = 3,
    GABBLE_SASL_STATUS_SUCCEEDED = 4,
    GABBLE_SASL_STATUS_SERVER_FAILED = 5,
    GABBLE_SASL_STATUS_CLIENT_FAILED = 6,
} GabbleSaslStatus;

/**
 * NUM_GABBLE_SASL_STATUSS:
 *
 * 1 higher than the highest valid value of #GabbleSaslStatus.
 */
#define NUM_GABBLE_SASL_STATUSS (6+1)

/**
 *
GabbleMediaStreamType:
 * @GABBLE_MEDIA_STREAM_TYPE_AUDIO: <![CDATA[An audio stream]]>
 * @GABBLE_MEDIA_STREAM_TYPE_VIDEO: <![CDATA[A video stream]]>
 *
 * Bitfield/set of flags generated from the Telepathy specification.
 */
typedef enum {
    GABBLE_MEDIA_STREAM_TYPE_AUDIO = 0,
    GABBLE_MEDIA_STREAM_TYPE_VIDEO = 1,
} GabbleMediaStreamType;

/**
 * NUM_GABBLE_MEDIA_STREAM_TYPES:
 *
 * 1 higher than the highest valid value of #GabbleMediaStreamType.
 */
#define NUM_GABBLE_MEDIA_STREAM_TYPES (1+1)

/**
 *
GabbleMediaStreamState:
 * @GABBLE_MEDIA_STREAM_STATE_DISCONNECTED: <![CDATA[The stream is disconnected.]]>
 * @GABBLE_MEDIA_STREAM_STATE_CONNECTING: <![CDATA[The stream is trying to connect.]]>
 * @GABBLE_MEDIA_STREAM_STATE_CONNECTED: <![CDATA[The stream is connected.]]>
 *
 * Bitfield/set of flags generated from the Telepathy specification.
 */
typedef enum {
    GABBLE_MEDIA_STREAM_STATE_DISCONNECTED = 0,
    GABBLE_MEDIA_STREAM_STATE_CONNECTING = 1,
    GABBLE_MEDIA_STREAM_STATE_CONNECTED = 2,
} GabbleMediaStreamState;

/**
 * NUM_GABBLE_MEDIA_STREAM_STATES:
 *
 * 1 higher than the highest valid value of #GabbleMediaStreamState.
 */
#define NUM_GABBLE_MEDIA_STREAM_STATES (2+1)


#ifdef __cplusplus
}
#endif
