import sys
from optparse import make_option

from jhbuild.commands import Command, register_command

import sysdeps


class cmd_depscheck(Command):

    name = 'depscheck'
    doc = 'Check that all system dependencies are installed'
    usage_args = ''

    def __init__(self):
        Command.__init__(self, [
            make_option('-s', '--script',
                        action='store_true', dest='script', default=False,
                        help=_('script friendly output')),
            ])

    def run(self, config, options, args, help=None):
        deps = sysdeps.get_packages()
        missing_deps = []
        for package, source_ in deps:
            if not sysdeps.check_package(package):
                missing_deps.append(package)

        if missing_deps:
            if not options.script:
                print 'Missing packages:'
            print ' '.join(missing_deps)
            sys.exit(1)
        elif not options.script:
            print 'All dependencies are installed.'


register_command(cmd_depscheck)
