__metaclass__ = type

import os

from jhbuild.errors import BuildStateError
from jhbuild.modtypes import distutils, register_module_type


__all__ = ['BundleModule']


class BundleModule(distutils.DistutilsModule):

    type = 'bundle'

    def do_build(self, buildscript):
        buildscript.set_action(_('Building'), self)
        srcdir = self.get_srcdir(buildscript)
        builddir = self.get_builddir(buildscript)
        python = os.environ.get('PYTHON', 'python')
        cmd = [python, 'setup.py', 'fix_manifest']
        if srcdir != builddir:
            cmd.extend(['--build-base', builddir])
        buildscript.execute(cmd, cwd = srcdir, extra_env = self.extra_env)

        cmd = [python, 'setup.py', 'build']
        if srcdir != builddir:
            cmd.extend(['--build-base', builddir])
        buildscript.execute(cmd, cwd = srcdir, extra_env = self.extra_env)

    def do_install(self, buildscript):
        buildscript.set_action(_('Installing'), self)
        srcdir = self.get_srcdir(buildscript)
        builddir = self.get_builddir(buildscript)
        destdir = self.prepare_installroot(buildscript)
        python = os.environ.get('PYTHON', 'python')
        cmd = [python, 'setup.py']
        if srcdir != builddir:
            cmd.extend(['build', '--build-base', builddir])
        # sugar.activity.bundlebuilder doesn't support --root (SL#2947)
        cmd.extend(['install',
                    '--prefix', buildscript.config.prefix])
        buildscript.execute(cmd, cwd = srcdir, extra_env = self.extra_env)
        self.process_install(buildscript, self.get_revision())


def parse_bundle(node, config, uri, repositories, default_repo):
    instance = BundleModule.parse_from_xml(node, config, uri, repositories, default_repo)
    # sugar.activity.bundlebuilder doesn't support --build-base (SL#2947)
    instance.supports_non_srcdir_builds = False

    if node.hasAttribute('supports-non-srcdir-builds'):
        instance.supports_non_srcdir_builds = \
            (node.getAttribute('supports-non-srcdir-builds') != 'no')
    return instance


register_module_type('bundle', parse_bundle)
