import os
import logging

BOUND_KEYS = ['<control><shift>Super_R']

TOUCHPAD_MODES = ['capacitive', 'resistive']
# FLAG_PATH is used to preserve status between boots.
FLAG_PATH = '/home/olpc/.olpc-pentablet-mode'
# NODE_PATH is used to communicate with the touchpad device.
NODE_PATH = '/sys/devices/platform/i8042/serio1/ptmode'

def read_touchpad_mode():
    """ Read the touchpad mode from the node path. """
    node_file_handle = open(NODE_PATH, 'r')
    text = node_file_handle.read()
    node_file_handle.close()

    return TOUCHPAD_MODES[int(text[0])]

def write_touchpad_mode(touchpad):
    """ Write the touchpad mode to the node path and set/unset the flag. """
    touchpad_mode_index = TOUCHPAD_MODES.index(touchpad)

    node_file_handle = open(NODE_PATH, 'w')
    node_file_handle.write(str(touchpad_mode_index))
    node_file_handle.close()

    if touchpad_mode_index == 0:
        if os.path.exists(FLAG_PATH):
            os.remove(FLAG_PATH)
    else:
        flag_file_handle = open(FLAG_PATH, 'w')
        flag_file_handle.close()

def handle_key_press(key):
    logging.debug('Set touchpad mode for globalkeys.')
    try:       
        mode = read_touchpad_mode() 
        mode = TOUCHPAD_MODES[1 - TOUCHPAD_MODES.index(mode)]
        write_touchpad_mode(mode)
    except Exception, e:
        logging.error('Set touchpad mode for globalkeys. ' + str(e))
