//conditional compilation
#ifndef _UART_H
#define _UART_H

#include<avr/io.h>
#endif

#define IDLE 0
#define TXING 1
#define RXING 2

unsigned char state = IDLE;
//Defining states (busy/idle)


/*
Once bit delay corresponding to baud rate of 9600 bps
*/
void bit_delay()
{
	//Clock/8 prescalar
	TCCR0B=0b00000010;
	
	TCNT0=0;
	while(TCNT0<100)
		;
	//TCCR0B=0x00;
//	TCNT0=0;
	
}

/*
Half bit delay corresponding to baud rate of 9600bps
*/
void half_bit_delay()
{
	//Clock/8 prescalar
	TCCR0B=0b00000010;
	
	TCNT0=0;
	while(TCNT0<50)
		;
	//TCCR0B=0x00;
	//TCNT0=0;
}

/*
Initialize the USART
*/
void init_usart()
{
	state=IDLE;
	//Configure TXD pin
	PORTB|=0b010000;
	DDRB|=0b010000;

	//Configure RXD pin
	
	PORTB|=0b001000;
	DDRB&= 0b110111; 
}


/*
Send a byte out of the implemented soft UART
Transmitting Function
*/
void send_char(unsigned char value)
{
	init_usart();
	int i=0;
	
	if(state==IDLE)
	{
		state= TXING;
		
		//start bit (low)
		PORTB&=0b101111;
		bit_delay();

		for(i=0;i<8;i++)
		{
			//if bit is one
			if( (value|0b11111110)==0b11111111 )
			{
				//send a high
				PORTB|=0b010000;
				bit_delay();
			}
			else		//if bit low
			{
				//send a low
				PORTB&=0b101111;
				bit_delay();
			}

			//shift bits to right by one
			value=value>>1;

		}

		//Stop Bit		
		PORTB|=0b010000;
		bit_delay();

		TCCR0B=0x00;
		TCNT0=0;
	}

	state=IDLE;
	
}

//PB3 is RXD pin
unsigned char recv_char()
{
	init_usart();
	unsigned char temp=0b00000000,temp2=0b00000001;
	int i=0;
	
	if(state==IDLE)
	{
		state=RXING;

		//Wait for start bit (low)
		while( (PINB&0b001000)==0b001000 )
			;
		half_bit_delay();
		bit_delay();

		for (i=0;i<8;i++)
		{
			//If a high is encountered
			if( (PINB&0b001000)==0b001000 )
				temp= (temp|temp2);

			temp2=temp2<<1;
			bit_delay();
		}
		
		
	}

	state=IDLE;
	half_bit_delay();

	TCCR0B=0x00;
	TCNT0=0;

	return temp;
			
}

