# Copyright (C) 2010, Martin Abente
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

import gtk
from gettext import gettext as _

from sugar.graphics import style
from sugar.graphics.icon import Icon

from jarabe.controlpanel.sectionview import SectionView

class YumUpdater(SectionView):
    def __init__(self, model, alerts):
        SectionView.__init__(self)

        self._model = model
        self.restart_alerts = alerts

        self.set_spacing(style.DEFAULT_SPACING)
        self.set_border_width(style.DEFAULT_SPACING * 2)

        self._setup()

    def _setup(self):
        top_label = gtk.Label(_('YUM Updater'))
        top_label.set_line_wrap(True)
        top_label.set_justify(gtk.JUSTIFY_LEFT)
        top_label.props.xalign = 0
        top_label.show()

        self.pack_start(top_label, expand=False)

        separator = gtk.HSeparator()
        separator.show()

        self.pack_start(separator, expand=False)

        botton_text = _('Click on the start button to') + \
                      _(' update your system\'s RPMs')

        bottom_label = gtk.Label()
        bottom_label.set_line_wrap(True)
        bottom_label.set_justify(gtk.JUSTIFY_LEFT)
        bottom_label.props.xalign = 0
        bottom_label.set_markup(botton_text)
        bottom_label.show()

        self.pack_start(bottom_label, expand=False)

        alignment_box = gtk.Alignment(xalign=0.5, yalign=0.5)
        alignment_box.show()

        self.pack_start(alignment_box)

        update_button = gtk.Button(_('Start'))
        update_button.props.image = Icon(icon_name='emblem-downloads',
                                        icon_size=gtk.ICON_SIZE_BUTTON)
        update_button.connect('clicked', self.__start_update_cb)
        update_button.show()

        alignment_box.add(update_button)

    def __start_update_cb(self, button, data=None):
        self._model.start_updater()
