/*
 * The Python Imaging Library.
 * $Id: Lzw.h,v 1.1.1.1 2007/09/26 00:00:34 chrism Exp $
 *
 * declarations for the TIFF LZW decoder.
 *
 * Copyright (c) Fredrik Lundh 1995-96.
 */


/* Max size for LZW code words */

#define	LZWBITS	    12

#define	LZWTABLE    (1<<LZWBITS)
#define	LZWBUFFER   (1<<LZWBITS)


typedef struct {

    /* CONFIGURATION */

    /* Filter type */
    int filter;

    /* PRIVATE CONTEXT (set by decoder) */

    /* Input bit buffer */
    INT32 bitbuffer;
    int bitcount;

    /* Code buffer */
    int codesize;
    int codemask;

    /* Constant symbol codes */
    int clear, end;

    /* Symbol history */
    int lastcode;
    unsigned char lastdata;

    /* History buffer */
    int bufferindex;
    unsigned char buffer[LZWTABLE];

    /* Symbol table */
    unsigned INT16 link[LZWTABLE];
    unsigned char data[LZWTABLE];
    int next;

} LZWSTATE;
