# Copyright (C) 2011, Aleksey Lim
# Copyright (C) 2011, Martin Abente
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import os
import cgi
import time
import socket
import logging
import tarfile
import threading
from ConfigParser import ConfigParser
from cStringIO import StringIO
from SocketServer import ThreadingMixIn, TCPServer, BaseServer
from SimpleHTTPServer import SimpleHTTPRequestHandler
from OpenSSL import SSL

config = ConfigParser()
script_path = os.path.abspath(__file__)
config_path = os.path.join(os.path.dirname(script_path), 'config.ini')
config.read(config_path)

HOST =          config.get('server', 'host')
PORT =          config.getint('server', 'port')
LOG_PATH =      config.get('server', 'log')
PKEY_FILE =     config.get('ssl', 'pkey_file')
CERT_FILE =     config.get('ssl', 'cert_file')
REPORTS_PATH =  config.get('feedback', 'reports_path')

logging.basicConfig(filename=LOG_PATH, level=logging.INFO)


class RequestHandler(SimpleHTTPRequestHandler):

    def setup(self):
       self.connection = self.request
       self.rfile = socket._fileobject(self.request, 'rb', self.rbufsize)
       self.wfile = socket._fileobject(self.request, 'wb', self.wbufsize)

    def do_GET(self):
       self._reply(403, 'Only POST requests are allowed')

    def do_POST(self):
       ctype, pdict = cgi.parse_header(self.headers.getheader('content-type'))

       if ctype != 'multipart/form-data':
           self._reply(403, 'Only multipart/form-data is accepted')
           return

       body = cgi.parse_multipart(self.rfile, pdict)
       tar_content = body.get('report')
       if not tar_content:
           self._reply(403, 'No "report" form parameter')
           return

       try:
           tar = tarfile.open(fileobj=StringIO(tar_content[0]), mode='r:gz')
           unique_path = self._unique_path()
           tar.extractall(path=unique_path)
           self._reply(200, 'Report was accepted')
       except Exception:
           logging.exception('Cannot process request')
           self._reply(403, 'Cannot process request')

    def log_message(self, format, *args):
        timestamp = self.log_date_time_string()
        client_addr = self.address_string()
        message = '%s - %s: %s' % (timestamp, client_addr, (format % args))

        logging.info(message)

    def _reply(self, code, message):
       self.send_response(code)
       self.send_header('Content-type', 'text/html')
       self.send_header('Content-length', len(message))
       self.end_headers()

       self.wfile.write(message)

       self.wfile.flush()
       self.connection.shutdown()

    def _unique_path(self):
      base_name = time.strftime('%Y-%m-%d-%s')
      counter = 0
      while True:
          attempt = '%s-%s' % (base_name, str(counter))
          path = os.path.join(REPORTS_PATH, attempt)
          if not os.path.exists(path):
              try:
                  os.makedirs(path, 0755)
              except OSError, err:
                  logging.error(str(err))
              return path
          counter += 1

class Server(ThreadingMixIn, TCPServer):

    def __init__(self, server_address, HandlerClass):
       BaseServer.__init__(self, server_address, HandlerClass)

       ctx = SSL.Context(SSL.SSLv23_METHOD)
       ctx.use_privatekey_file(PKEY_FILE)
       ctx.use_certificate_file(CERT_FILE)
       self.socket = SSL.Connection(ctx,
               socket.socket(self.address_family, self.socket_type))

       self.allow_reuse_address = True
       self.server_bind()
       self.server_activate()

def listen():
    srv = Server((HOST, PORT), RequestHandler)
    print srv
    srv_thread = threading.Thread(target=srv.serve_forever)
    srv_thread.start()
