#!/usr/bin/env python
# Copyright (C) 2011, Martin Abente
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>

# This source code is based on Sander Marechal's examples provided at
# http://www.jejik.com/articles/2007/02/a_simple_unix_linux_daemon_in_python/

import sys
import fbserver
from daemon import Daemon

class FeedbackDaemon(Daemon):
    def run(self):
        print "calling listen"
        fbserver.listen()

if __name__ == "__main__":
    daemon = FeedbackDaemon('/tmp/fbdaemon.pid', '/dev/null',
            '/home/anish/out',
            '/home/anish/err')
    if len(sys.argv) == 2:
        if 'start' == sys.argv[1]:
            print "starting daemon"
            daemon.start()
        elif 'stop' == sys.argv[1]:
            print "stopping daemon"
            daemon.stop()
        elif 'restart' == sys.argv[1]:
            print "restarting daemon"
            daemon.restart()
        elif 'status' == sys.argv[1]:
            print "reporting daemon status"
            daemon.status()
        else:
            print "Unknown command"
            sys.exit(2)
        sys.exit(0)
    else:
        print "usage: %s start|stop|restart" % sys.argv[0]
        sys.exit(2)
