/*
Jan 16th, 2007
Code to check transoformer setup
One pin of Tiny would be only used to drive transmitter
*/
#include<avr/io.h>
#include<avr/interrupt.h>
#include<avr/signal.h>
#include<avr/wdt.h>

#include"uart.h"

#define CROSSTALK_WAIT 50

volatile unsigned char time_minor=0;	//Value of TCNT0
volatile unsigned char inc=0,flag=0;	//flag=1 true
unsigned char debug=0;

SIGNAL(	SIG_INTERRUPT0 )
{
	time_minor=TCNT0;
	flag=1;
}


SIGNAL( SIG_OVERFLOW0 )
{
	TCNT0=0;
	++inc;
}

void calc_distance( void )
{	
	
	flag=0;
	time_minor=0;
	inc=0;

	//Send burst
	//Prescalar 1
	TCCR0B=0b00000001;

	unsigned char count=0;
	DDRB|=0b000001;
	
	PORTB&=0b000000;
	//PORTB|=0b000001;		//added on feb 5, 2007.

	TCNT0=0;
	
	while(count<CROSSTALK_WAIT)			//can be increased for experimentation
	{
		while( TCNT0<92)		
			;
		TCNT0=0;
		PORTB^=0b000001;		
		++count;
	}

	PORTB&=0b111110;
	
	TCCR0B=0x00;
	TCNT0=0;

	/*
	Disable external interrupt
	*/
	GIMSK&=(0<<INT0);

	//Recv burst
	
	/*
	Waiting for cross talk to subside
	*/
	//Prescalar CLK/1024
	TCCR0B=0b00000101;

	TCNT0=0;

	while( TCNT0<50 )		//changed from 4 to 50
		;					//waiting for 6.125ms , minimum distance measured 33cm (66cm round trip)

	TCCR0B=0x00;
	TCNT0=0;

	DDRB&= 0b111011;
	PORTB&=0b111011;

	//Prescalar CLK/64
	TCCR0B=0b00000011;

	/*
	Configure External Interrupt
	*/
	MCUCR=0b00000011;
	GIMSK|=(1<<INT0);
	
	/*
	Configure timer interrupt
	*/
	TIMSK|=(1<<TOIE0);
	TCNT0=0;

	sei();
	
	debug='E';
	
	while( flag==0 && inc<40 )
		debug='A';
	
	/*
	Setting the values of ALL timer and external interrupt related registers to zero
	EXPERIMENTAL!!! 
	*/
	MCUCR=0x00;
	GIMSK=0x00;
	GIFR= 0x00;
	PCMSK=0x3F;

	TCCR0A=0x00;
	TIMSK=0x00;
	TIFR=0x00;
	GTCCR=0x00;
	TCCR0B=0x00;
	TCNT0=0;
	
	send_char( inc );
	send_char( time_minor );
	send_char( debug );
		
}

int main( void )
{
	unsigned char c;
	DDRB =0b000001;
	PORTB=0b000000;
	while(1)
	{		
		c=recv_char();	
		calc_distance();
	}
	
	return 0;
}
